/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.InternalClobTest;
import com.pivotal.gemfirexd.internal.impl.jdbc.TemporaryClob;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;

public class SmallTemporaryClobTest
extends InternalClobTest {
    private static final long CLOBLENGTH = 1027L;
    private static final long BYTES_PER_CHAR = 3L;

    public SmallTemporaryClobTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.initialCharLength = 1027L;
        this.initialByteLength = 3081L;
        this.bytesPerChar = 3L;
        EmbedStatement embStmt = (EmbedStatement)this.createStatement();
        EmbedConnection embCon = (EmbedConnection)this.getConnection();
        this.iClob = new TemporaryClob(embCon.getDBName(), (ConnectionChild)embStmt);
        SmallTemporaryClobTest.transferData(new LoopingAlphabetReader(1027L, CharAlphabet.tamil()), this.iClob.getWriter(1L), 1027L);
        SmallTemporaryClobTest.assertEquals((long)1027L, (long)this.iClob.getCharLength());
    }

    @Override
    public void tearDown() throws Exception {
        this.iClob.release();
        this.iClob = null;
        super.tearDown();
    }

    public static Test suite() throws Exception {
        Class<SmallTemporaryClobTest> theClass = SmallTemporaryClobTest.class;
        TestSuite suite = new TestSuite(theClass, "SmallTemporaryClobTest suite");
        suite.addTest(SmallTemporaryClobTest.addModifyingTests(theClass));
        return suite;
    }
}

