/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.Resetable;
import com.pivotal.gemfirexd.internal.impl.jdbc.InternalClob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.streams.ByteAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public abstract class InternalClobTest
extends BaseJDBCTestCase {
    static final int BUFFER_SIZE = 4096;
    protected InternalClob iClob = null;
    protected long initialByteLength = Long.MIN_VALUE;
    protected long initialCharLength = Long.MIN_VALUE;
    protected long bytesPerChar = Long.MIN_VALUE;

    InternalClobTest(String name) {
        super(name);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected static Test addModifyingTests(Class<? extends TestCase> theClass) throws Exception {
        TestSuite suite = new TestSuite("Modifying InternalClob test suite");
        Method[] methods = theClass.getMethods();
        ArrayList<String> testMethods = new ArrayList<String>();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getReturnType().equals(Void.TYPE) || !m.getName().startsWith("modTest") || m.getParameterTypes().length != 0) continue;
            testMethods.add(m.getName());
        }
        Constructor<? extends TestCase> ctor = theClass.getConstructor(String.class);
        for (int i = 0; i < testMethods.size(); ++i) {
            suite.addTest((Test)ctor.newInstance(testMethods.get(i)));
        }
        return suite;
    }

    public void testSanity() {
        InternalClobTest.assertEquals((long)this.initialByteLength, (long)(this.initialCharLength * this.bytesPerChar));
        InternalClobTest.assertTrue((this.initialCharLength > 25L ? 1 : 0) != 0);
    }

    public void testGetByteLengthAfterRelease() throws IOException, SQLException {
        this.iClob.release();
        try {
            this.iClob.getByteLength();
            InternalClobTest.fail((String)"Exception should have been raised, but was not");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetBytePositionAfterRelease() throws IOException, SQLException {
        this.iClob.release();
        try {
            this.iClob.getBytePosition(1L);
            InternalClobTest.fail((String)"Exception should have been raised, but was not");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetCharLengthAfterRelease() throws IOException, SQLException {
        this.iClob.release();
        try {
            this.iClob.getCharLength();
            InternalClobTest.fail((String)"Exception should have been raised, but was not");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetRawByteStreamAfterRelease() throws IOException, SQLException {
        this.iClob.release();
        try {
            this.iClob.getRawByteStream();
            InternalClobTest.fail((String)"Exception should have been raised, but was not");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetReaderAfterRelease() throws IOException, SQLException {
        this.iClob.release();
        try {
            this.iClob.getReader(1L);
            InternalClobTest.fail((String)"Exception should have been raised, but was not");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testReleaseAfterRelase() throws IOException, SQLException {
        this.iClob.release();
        this.iClob.release();
    }

    public void testGetWriterAfterRelease() throws IOException, SQLException {
        this.iClob.release();
        try {
            this.iClob.getWriter(1L);
            InternalClobTest.fail((String)"Exception should have been raised, but was not");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException uoe) {
            InternalClobTest.assertFalse((String)"Must support getWriter if the Clob is writable", (boolean)this.iClob.isWritable());
        }
    }

    public void testInsertStringAfterRelease() throws IOException, SQLException {
        this.iClob.release();
        try {
            this.iClob.insertString("What a nice sunny day :)", 1L);
            InternalClobTest.fail((String)"Exception should have been raised, but was not");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException uoe) {
            InternalClobTest.assertFalse((String)"Must support insertString if the Clob is writable", (boolean)this.iClob.isWritable());
        }
    }

    public void testTruncateAfterRelease() throws IOException, SQLException {
        this.iClob.release();
        try {
            this.iClob.truncate(1L);
            InternalClobTest.fail((String)"Exception should have been raised, but was not");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException uoe) {
            InternalClobTest.assertFalse((String)"Must support trucate if the Clob is writable", (boolean)this.iClob.isWritable());
        }
    }

    public void testGetByteLength() throws IOException, SQLException {
        InternalClobTest.assertEquals((long)this.initialByteLength, (long)this.iClob.getByteLength());
    }

    public void testGetBytePosition_first() throws IOException, SQLException {
        InternalClobTest.assertEquals((long)0L, (long)this.iClob.getBytePosition(1L));
    }

    public void testGetBytePosition_second() throws IOException, SQLException {
        InternalClobTest.assertEquals((long)this.bytesPerChar, (long)this.iClob.getBytePosition(2L));
    }

    public void testGetBytePosition_last() throws IOException, SQLException {
        InternalClobTest.assertEquals((long)(this.initialByteLength - this.bytesPerChar), (long)this.iClob.getBytePosition(this.initialCharLength));
    }

    public void testGetBytePosition_lastPlussOne() throws IOException, SQLException {
        InternalClobTest.assertEquals((long)this.initialByteLength, (long)this.iClob.getBytePosition(this.initialCharLength + 1L));
    }

    public void testGetBytePosition_lastPlussTwo() throws IOException, SQLException {
        try {
            long pos = this.iClob.getBytePosition(this.initialCharLength + 2L);
            InternalClobTest.fail((String)("Length +2 should have no valid byte position, got " + pos));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testGetBytePosition_lastPlussThousand() throws IOException, SQLException {
        try {
            long pos = this.iClob.getBytePosition(this.initialCharLength + 1000L);
            InternalClobTest.fail((String)("Length +1000 should have no valid byte position, got " + pos));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testGetCharLength() throws IOException, SQLException {
        InternalClobTest.assertEquals((long)this.initialCharLength, (long)this.iClob.getCharLength());
    }

    public void testGetReaderAtStartPos() throws IOException, SQLException {
        Reader reader = this.iClob.getReader(1L);
        InternalClobTest.assertEquals((long)this.initialCharLength, (long)InternalClobTest.readFromStream(reader, this.initialCharLength));
        InternalClobTest.assertEquals((int)-1, (int)reader.read());
        reader.close();
    }

    public void testGetReaderAtSecondPos() throws IOException, SQLException {
        Reader reader = this.iClob.getReader(2L);
        InternalClobTest.assertEquals((long)(this.initialCharLength - 1L), (long)InternalClobTest.readFromStream(reader, this.initialCharLength - 1L));
        InternalClobTest.assertEquals((int)-1, (int)reader.read());
        reader.close();
    }

    public void testGetReaderAtEndPos() throws IOException, SQLException {
        Reader reader = this.iClob.getReader(this.initialCharLength);
        InternalClobTest.assertTrue((reader.read() != -1 ? 1 : 0) != 0);
        InternalClobTest.assertEquals((int)-1, (int)reader.read());
        reader.close();
    }

    public void testGetReaderAfterEndPos() throws IOException, SQLException {
        Reader reader = this.iClob.getReader(this.initialCharLength + 1L);
        InternalClobTest.assertEquals((int)-1, (int)reader.read());
        reader.close();
        try {
            reader = this.iClob.getReader(this.initialCharLength + 767L);
            InternalClobTest.fail((String)"Got a reader at a position greater than the Clob");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void modTestInsertString_append_small() throws IOException, SQLException {
        long cLength = this.iClob.getCharLength();
        this.iClob.insertString("END", cLength + 1L);
        InternalClobTest.assertEquals((long)(cLength + 3L), (long)this.iClob.getCharLength());
        InternalClobTest.assertEquals((String)"END", (String)InternalClobTest.subString(this.iClob, cLength + 1L, 3));
    }

    public void modTestInsertString_replace_small() throws IOException, SQLException {
        String replacement = "MIDDLE";
        this.iClob.insertString(replacement, 15L);
        InternalClobTest.assertEquals((long)this.initialCharLength, (long)this.iClob.getCharLength());
        InternalClobTest.assertEquals((String)replacement, (String)InternalClobTest.subString(this.iClob, 15L, replacement.length()));
    }

    public void modTestInsertString_replace_and_append_small() throws IOException, SQLException {
        String replacement = "REPLACING_AND_APPENDING!";
        InternalClobTest.assertTrue((String)"Length of replacement text must be even", (replacement.length() % 2 == 0 ? 1 : 0) != 0);
        int halfLength = replacement.length() / 2;
        this.iClob.insertString(replacement, this.initialCharLength - (long)halfLength + 1L);
        InternalClobTest.assertEquals((String)"Wrong length after replace and append", (long)(this.initialCharLength + (long)halfLength), (long)this.iClob.getCharLength());
        InternalClobTest.assertEquals((String)"Corresponding substring does not match replacement", (String)replacement, (String)InternalClobTest.subString(this.iClob, this.initialCharLength - (long)halfLength + 1L, replacement.length()));
    }

    protected static String subString(InternalClob clob, long pos, int count) throws IOException, SQLException {
        long read;
        Reader reader = clob.getReader(pos);
        char[] sub = new char[count];
        int offset = 0;
        while (offset < count && (read = (long)reader.read(sub, offset, count - offset)) != -1L) {
            offset = (int)((long)offset + read);
        }
        return String.copyValueOf(sub);
    }

    public static long transferData(Reader src, Writer dest, long charsToCopy) throws IOException {
        int read;
        BufferedReader in = new BufferedReader(src);
        BufferedWriter out = new BufferedWriter(dest, 4096);
        char[] bridge = new char[4096];
        long charsLeft = charsToCopy;
        while ((read = in.read(bridge, 0, (int)Math.min(charsLeft, 4096L))) > 0) {
            out.write(bridge, 0, read);
            charsLeft -= (long)read;
        }
        in.close();
        out.flush();
        return charsToCopy - charsLeft;
    }

    public static final long readFromStream(Reader in, long characterCount) throws IOException {
        long leftToRead;
        long read;
        char[] buf = new char[4096];
        for (leftToRead = characterCount; leftToRead > 0L && (read = (long)in.read(buf, 0, (int)Math.min(leftToRead, 4096L))) != 0L; leftToRead -= read) {
        }
        return characterCount - leftToRead;
    }

    static class FakeStoreStream
    extends InputStream
    implements Resetable {
        private static final ByteAlphabet ALPHABET = ByteAlphabet.modernLatinLowercase();
        private LoopingAlphabetStream stream = null;
        private final long length;
        private int encodedLengthRemaining = 2;
        private int eofMarkerRemaining = 3;

        public FakeStoreStream(long length) {
            this.length = length;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int count = 0;
            while (count < len) {
                int ret = this.read();
                if (ret == -1) {
                    if (count != 0) break;
                    return -1;
                }
                b[off + count++] = (byte)ret;
            }
            return count;
        }

        @Override
        public int read() throws IOException {
            if (this.encodedLengthRemaining > 0) {
                --this.encodedLengthRemaining;
                return 0;
            }
            int b = this.stream.read();
            if (b == -1 && this.eofMarkerRemaining > 0) {
                b = this.eofMarkerRemaining == 3 ? 224 : 0;
                --this.eofMarkerRemaining;
            }
            return b;
        }

        public void resetStream() throws IOException, StandardException {
            this.stream = new LoopingAlphabetStream(this.length, ALPHABET);
            this.encodedLengthRemaining = 2;
            this.eofMarkerRemaining = 3;
        }

        public void initStream() throws StandardException {
            this.stream = new LoopingAlphabetStream(this.length, ALPHABET);
            this.encodedLengthRemaining = 2;
            this.eofMarkerRemaining = 3;
        }

        public void closeStream() {
            this.stream = null;
        }
    }
}

