/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.hadoop;

import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TransactionHDFSTableTest
extends JdbcTestBase {
    static final String HDFS_DIR = "./myhdfs";

    public TransactionHDFSTableTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testRRTransactionalInsertUpdateDeleteWithoutEvictionCriteriaPKbasedOperation() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))  persistent hdfsstore (myhdfs)");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=20 where c1=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)20, (int)rs.getInt("c2"));
        rs.close();
        st.execute("delete from tran.t1 where c1 =10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRRTransactionalInsertUpdateDeleteWithoutEvictionCriteriaTableScan() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))  persistent hdfsstore (myhdfs)");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=20 where c2=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)20, (int)rs.getInt("c2"));
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs.close();
        st.execute("delete from tran.t1 where c2 = 20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRCTransactionalInsertDeleteWithoutEvictionCriteriaPKbasedOperation() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))  persistent hdfsstore (myhdfs)");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=20 where c1=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)20, (int)rs.getInt("c2"));
        rs.close();
        st.execute("delete from tran.t1 where c1 =10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRCTransactionalInsertDeleteWithoutEvictionCriteriaTableScan() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))  persistent hdfsstore (myhdfs)");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=20 where c2=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)20, (int)rs.getInt("c2"));
        rs.close();
        st.execute("delete from tran.t1 where c2 =20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRRTransactionalInsertUpdateDeleteWithEvictionCriteriaPKbasedOperation() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))  persistent hdfsstore (myhdfs)  eviction by criteria ( c2 > 10 ) EVICT INCOMING");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 20)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=4 where c1=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 where c1=10");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)4, (int)rs.getInt("c2"));
        rs.close();
        st.executeUpdate("update tran.t1 set c2=40 where c1=20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 where c1=20");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c1=20 ");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)40, (int)rs.getInt("c2"));
        rs.close();
        st.executeUpdate("update tran.t1 set c2=30 where c1=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 where c1=10");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c1=10 ");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)30, (int)rs.getInt("c2"));
        rs.close();
        st.executeUpdate("update tran.t1 set c2=5 where c1=20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 where c1=20");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)5, (int)rs.getInt("c2"));
        rs.close();
        st.execute("delete from tran.t1 where c1 = 10");
        st.execute("delete from tran.t1 where c1 = 20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRRTransactionalInsertUpdateDeleteWithEvictionCriteriaTableScan() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))  persistent hdfsstore (myhdfs)  eviction by criteria ( c2 > 10 ) EVICT INCOMING");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 20)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=4 where c2=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 where c2=4");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)10, (int)rs.getInt("c1"));
        rs.close();
        st.executeUpdate("update tran.t1 set c2=40 where c2=20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 where c2=40");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c2=40 ");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)40, (int)rs.getInt("c2"));
        rs.close();
        st.executeUpdate("update tran.t1 set c2=30 where c2=4");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 where c2=30");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c2=30 ");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)30, (int)rs.getInt("c2"));
        rs.close();
        st.executeUpdate("update tran.t1 set c2=5 where c1=20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 where c1=20");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)5, (int)rs.getInt("c2"));
        rs.close();
        st.execute("delete from tran.t1 where c1 = 10");
        st.execute("delete from tran.t1 where c1 = 20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRRTransactionalInsertUpdateDeleteWithoutEvictionCriteriaUniqueIndex() throws Exception {
        Statement st;
        Connection conn;
        block3: {
            TransactionHDFSTableTest.setupConnection();
            conn = jdbcConn;
            conn.setTransactionIsolation(4);
            conn.setAutoCommit(false);
            st = conn.createStatement();
            st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
            st.execute("create schema tran");
            st.execute("create table tran.t1( id int primary key, qty int, abc int, constraint uq unique (qty,abc)) persistent hdfsstore (myhdfs)");
            conn.commit();
            ResultSet rs = st.executeQuery("Select * from tran.t1");
            TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
            rs.close();
            st.execute("insert into tran.t1 values (10, 10, 10)");
            conn.commit();
            rs = st.executeQuery("Select * from tran.t1");
            int numRows = 0;
            while (rs.next()) {
                ++numRows;
            }
            TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
            rs.close();
            try {
                st.execute("insert into tran.t1 values (20, 10, 10)");
                TransactionHDFSTableTest.fail("Did not get expected constraint violation exception");
            }
            catch (SQLException e) {
                if ("23505".equals(e.getSQLState())) break block3;
                throw e;
            }
        }
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRRTransactionalInsertUpdateDeleteWithEvictionCriteriaUniqueIndexNoEviction() throws Exception {
        Statement st;
        Connection conn;
        block3: {
            TransactionHDFSTableTest.setupConnection();
            conn = jdbcConn;
            conn.setTransactionIsolation(4);
            conn.setAutoCommit(false);
            st = conn.createStatement();
            st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
            st.execute("create schema tran");
            st.execute("create table tran.t1( id int primary key, qty int, abc int, constraint uq unique (qty,abc)) persistent hdfsstore (myhdfs) eviction by criteria ( qty > 10 ) EVICT INCOMING");
            conn.commit();
            ResultSet rs = st.executeQuery("Select * from tran.t1");
            TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
            rs.close();
            st.execute("insert into tran.t1 values (10, 5, 10)");
            conn.commit();
            rs = st.executeQuery("Select * from tran.t1 -- GFXDIRE-PROPERTIES queryHDFS=true \n");
            int numRows = 0;
            while (rs.next()) {
                ++numRows;
            }
            TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
            rs.close();
            try {
                st.execute("insert into tran.t1 values (20, 5, 10)");
                TransactionHDFSTableTest.fail("Did not get expected constraint violation exception");
            }
            catch (SQLException e) {
                if ("23505".equals(e.getSQLState())) break block3;
                throw e;
            }
        }
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRRTransactionalInsertUpdateDeleteWithEvictionCriteriaUniqueIndex() throws Exception {
        Statement st;
        Connection conn;
        block3: {
            TransactionHDFSTableTest.setupConnection();
            conn = jdbcConn;
            conn.setTransactionIsolation(4);
            conn.setAutoCommit(false);
            st = conn.createStatement();
            st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
            st.execute("create schema tran");
            st.execute("create table tran.t1( id int primary key, qty int, abc int, constraint uq unique (qty,abc)) persistent hdfsstore (myhdfs) eviction by criteria ( qty > 10 ) EVICT INCOMING");
            conn.commit();
            ResultSet rs = st.executeQuery("Select * from tran.t1");
            TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
            rs.close();
            st.execute("insert into tran.t1 values (10, 20, 10)");
            conn.commit();
            rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
            int numRows = 0;
            while (rs.next()) {
                ++numRows;
            }
            TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
            rs.close();
            try {
                st.execute("insert into tran.t1 values (20, 20, 10)");
                TransactionHDFSTableTest.fail("Did not get expected constraint violation exception");
            }
            catch (SQLException e) {
                if ("23505".equals(e.getSQLState())) break block3;
                throw e;
            }
        }
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRRTransactionalInsertUpdateDeleteWithEvictionCriteriaUniqueIndex2() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("create table tran.t1( id int primary key, qty int, abc int, constraint uq unique (qty)) persistent hdfsstore (myhdfs) eviction by criteria ( qty > 10 ) EVICT INCOMING");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 20, 10)");
        st.execute("insert into tran.t1 values (20, 30, 20)");
        st.execute("insert into tran.t1 values (30, 40, 20)");
        st.execute("insert into tran.t1 values (40, 50, 20)");
        st.execute("insert into tran.t1 values (50, 60, 20)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)5, (int)numRows);
        rs.close();
        st.execute("update tran.t1 set qty=1 where abc=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1 ");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)1, (int)rs.getInt("qty"));
        conn.commit();
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRCTransactionalInsertUpdateDeleteReadPKbasedOperation() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))  persistent hdfsstore (myhdfs) eviction by criteria ( c2 > 10 ) EVICT INCOMING");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 20)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=20 where c1=10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("delete from tran.t1 where c1 =10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testEvictIncomingWithLocalIndexes() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './myhdfs' QUEUEPERSISTENT true");
        stmt.execute("create table trade.customers (cid int not null, cust_name int, addr int, primary key (cid)) persistent hdfsstore (hdfsdata) eviction by criteria ( cust_name > 5 ) EVICT INCOMING ");
        stmt.execute("create index idx1 on trade.customers (cust_name)");
        stmt.execute("create index idx2 on trade.customers (addr)");
        conn.commit();
        stmt.executeUpdate("insert into trade.customers values (12, 120, 1200)");
        stmt.executeUpdate("insert into trade.customers values (13, 130, 1300)");
        stmt.executeUpdate("insert into trade.customers values (1, 1, 100)");
        conn.commit();
        ResultSet rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=12");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)12, (int)rs.getInt("cid"));
        TransactionHDFSTableTest.assertEquals((int)120, (int)rs.getInt("cust_name"));
        TransactionHDFSTableTest.assertEquals((int)1200, (int)rs.getInt("addr"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=1");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)1, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=100");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)100, (int)rs.getInt("addr"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=12");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=120");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1200");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=13");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=130");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1300");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=12");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)12, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=120");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)120, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1200");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)1200, (int)rs.getInt("addr"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=13");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)13, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=130");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)130, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1300");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)1300, (int)rs.getInt("addr"));
        stmt.executeUpdate("update trade.customers set cust_name=4 where cid=12");
        conn.commit();
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=12");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)12, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=4");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)4, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1200");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)1200, (int)rs.getInt("addr"));
        stmt.executeUpdate("update trade.customers set cust_name=15 where cid=13");
        conn.commit();
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=13");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=15");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1300");
        TransactionHDFSTableTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=13");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)13, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=15");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)15, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1300");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)1300, (int)rs.getInt("addr"));
    }

    public void testRCTransactionalInsertDeleteWithoutEvictionCriteria() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1)) persistent hdfsstore (myhdfs)");
        conn.commit();
        st.execute("insert into tran.t1 values (10, 10)");
        ResultSet rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n ");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=20 where c2=10");
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        TransactionHDFSTableTest.assertTrue((boolean)rs.next());
        TransactionHDFSTableTest.assertEquals((int)20, (int)rs.getInt("c2"));
        rs.close();
        st.execute("delete from tran.t1 where c2 =20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionHDFSTableTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRCTransactionalInsertDeleteWithoutEvictionCriteriaCount() throws Exception {
        TransactionHDFSTableTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1)) persistent hdfsstore (myhdfs)");
        conn.commit();
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 20)");
        st.execute("insert into tran.t1 values (30, 30)");
        ResultSet rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n ");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)3, (int)numRows);
        rs.close();
        rs = st.executeQuery("Select count(*) from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n ");
        rs.next();
        numRows = rs.getInt(1);
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)3, (int)numRows);
        rs.close();
        rs = st.executeQuery("Select count(*) from tran.t1 \n ");
        rs.next();
        numRows = rs.getInt(1);
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain one row ", (int)3, (int)numRows);
        rs.close();
        st.executeUpdate("update tran.t1 set c2=20 where c2=10");
        rs = st.executeQuery("Select count(*) from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n ");
        rs.next();
        numRows = rs.getInt(1);
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain three row ", (int)3, (int)numRows);
        rs.close();
        st.execute("delete from tran.t1 where c2 =20");
        conn.commit();
        rs = st.executeQuery("Select count(*) from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n ");
        rs.next();
        numRows = rs.getInt(1);
        TransactionHDFSTableTest.assertEquals((String)"ResultSet should contain two row ", (int)1, (int)numRows);
        rs.close();
        st.execute("drop table tran.t1");
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.commit();
        conn.close();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.delete(new File(HDFS_DIR));
    }

    private void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                File[] files;
                for (File f : files = file.listFiles()) {
                    this.delete(f);
                }
                file.delete();
            }
        } else {
            file.delete();
        }
    }
}

