/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.hadoop;

import com.gemstone.gemfire.cache.CustomEvictionAttributes;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdEvictionCriteria;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDumpLocalResultMessage;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public class EvictionByCriteriaTest
extends JdbcTestBase {
    static final String HDFS_DIR = "./evictHDFS";

    public EvictionByCriteriaTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.delete(new File(HDFS_DIR));
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    private void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                File[] files;
                for (File f : files = file.listFiles()) {
                    this.delete(f);
                }
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    public void testDDLSupport() throws Exception {
        int i;
        DataValueDescriptor key;
        RegionEntry entry;
        int i2;
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        String evictClause = "{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10";
        stmt.execute("create table e.evictTable(id varchar(20) primary key, qty int, ts timestamp)  " + this.getOffHeapSuffix() + " partition by column(id) " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria (" + "{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10" + ") eviction frequency 8 seconds");
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/E/EVICTTABLE", (boolean)true, (boolean)false);
        GemFireContainer container = (GemFireContainer)lr.getUserAttribute();
        CustomEvictionAttributes evictionAttrs = lr.getAttributes().getCustomEvictionAttributes();
        EvictionAttributes defEvictAttrs = lr.getAttributes().getEvictionAttributes();
        EvictionByCriteriaTest.assertEquals((Object)DataPolicy.HDFS_PERSISTENT_PARTITION, (Object)lr.getAttributes().getDataPolicy());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAlgorithm.LRU_HEAP, (Object)defEvictAttrs.getAlgorithm());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAction.OVERFLOW_TO_DISK, (Object)defEvictAttrs.getAction());
        EvictionByCriteriaTest.assertNotNull((Object)evictionAttrs);
        EvictionByCriteriaTest.assertEquals((long)0L, (long)evictionAttrs.getEvictorStartTime());
        EvictionByCriteriaTest.assertEquals((long)8000L, (long)evictionAttrs.getEvictorInterval());
        GfxdEvictionCriteria criteria = (GfxdEvictionCriteria)evictionAttrs.getCriteria();
        EvictionByCriteriaTest.assertEquals((String)"{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10", (String)criteria.getPredicateString());
        for (int i3 = 1; i3 <= 10; ++i3) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i3 + "', " + i3 * 10 + ", CURRENT_TIMESTAMP)");
        }
        for (i2 = 1; i2 <= 10; ++i2) {
            CompactCompositeRegionKey key2 = new CompactCompositeRegionKey((DataValueDescriptor)new SQLVarchar(Integer.toString(i2)), container.getExtraTableInfo());
            EntryEventImpl event = EntryEventImpl.create((LocalRegion)lr, (Operation)Operation.LOCAL_DESTROY, (Object)key2, null, null, (boolean)false, null);
            LocalRegion dataRegion = lr.getDataRegionForWrite((KeyInfo)event, Operation.LOCAL_DESTROY);
            entry = lr.basicGetEntryForLock(dataRegion, (Object)key2);
            EvictionByCriteriaTest.assertFalse((boolean)entry.isMarkedForEviction());
            event.setRegionEntry(entry);
            EvictionByCriteriaTest.assertFalse((boolean)criteria.doEvict((EntryEvent)event));
        }
        Thread.sleep(12000L);
        for (i2 = 11; i2 <= 20; ++i2) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i2 + "', " + i2 * 10 + ", CURRENT_TIMESTAMP)");
        }
        Iterator evictIter = criteria.getKeysToBeEvicted(System.currentTimeMillis(), (Region)lr);
        int numExpectedKeys = 10;
        boolean[] expectedKeys = new boolean[numExpectedKeys];
        while (evictIter.hasNext()) {
            Map.Entry e = (Map.Entry)evictIter.next();
            key = ((RegionKey)e.getKey()).getKeyColumn(0);
            int keyValue = key.getInt();
            EvictionByCriteriaTest.assertFalse((boolean)expectedKeys[keyValue - 1]);
            expectedKeys[keyValue - 1] = true;
            --numExpectedKeys;
        }
        EvictionByCriteriaTest.assertEquals((int)0, (int)numExpectedKeys);
        for (i = 1; i <= 10; ++i) {
            key = new CompactCompositeRegionKey((DataValueDescriptor)new SQLVarchar(Integer.toString(i)), container.getExtraTableInfo());
            EntryEventImpl event = EntryEventImpl.create((LocalRegion)lr, (Operation)Operation.LOCAL_DESTROY, (Object)key, null, null, (boolean)false, null);
            LocalRegion dataRegion = lr.getDataRegionForWrite((KeyInfo)event, Operation.LOCAL_DESTROY);
            entry = lr.basicGetEntryForLock(dataRegion, (Object)key);
            event.setRegionEntry(entry);
            EvictionByCriteriaTest.assertTrue((boolean)criteria.doEvict((EntryEvent)event));
            entry.clearMarkedForEviction();
            EvictionByCriteriaTest.assertTrue((boolean)criteria.doEvict((EntryEvent)event));
        }
        for (i = 11; i <= 20; ++i) {
            key = new CompactCompositeRegionKey((DataValueDescriptor)new SQLVarchar(Integer.toString(i)), container.getExtraTableInfo());
            EntryEventImpl event = EntryEventImpl.create((LocalRegion)lr, (Operation)Operation.LOCAL_DESTROY, (Object)key, null, null, (boolean)false, null);
            LocalRegion dataRegion = lr.getDataRegionForWrite((KeyInfo)event, Operation.LOCAL_DESTROY);
            entry = lr.basicGetEntryForLock(dataRegion, (Object)key);
            EvictionByCriteriaTest.assertFalse((boolean)entry.isMarkedForEviction());
            event.setRegionEntry(entry);
            EvictionByCriteriaTest.assertFalse((boolean)criteria.doEvict((EntryEvent)event));
        }
    }

    public void testEvictionService_AlterFrequency() throws Exception {
        int i;
        int id;
        this.reduceLogLevelForTest("config");
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        String evictClause = "qty > 500";
        stmt.execute("create table e.evictTable(id varchar(20) primary key, qty int, ts timestamp)  " + this.getOffHeapSuffix() + "  partition by column(id) " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria (" + "qty > 500" + ") eviction frequency 15 seconds");
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/E/EVICTTABLE", (boolean)true, (boolean)false);
        CustomEvictionAttributes evictionAttrs = lr.getAttributes().getCustomEvictionAttributes();
        EvictionAttributes defEvictAttrs = lr.getAttributes().getEvictionAttributes();
        EvictionByCriteriaTest.assertEquals((Object)DataPolicy.HDFS_PERSISTENT_PARTITION, (Object)lr.getAttributes().getDataPolicy());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAlgorithm.LRU_HEAP, (Object)defEvictAttrs.getAlgorithm());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAction.OVERFLOW_TO_DISK, (Object)defEvictAttrs.getAction());
        EvictionByCriteriaTest.assertNotNull((Object)evictionAttrs);
        EvictionByCriteriaTest.assertEquals((long)0L, (long)evictionAttrs.getEvictorStartTime());
        EvictionByCriteriaTest.assertEquals((long)15000L, (long)evictionAttrs.getEvictorInterval());
        GfxdEvictionCriteria criteria = (GfxdEvictionCriteria)evictionAttrs.getCriteria();
        EvictionByCriteriaTest.assertEquals((String)"qty > 500", (String)criteria.getPredicateString());
        for (int i2 = 1; i2 <= 100; ++i2) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i2 + "', " + i2 * 10 + ", CURRENT_TIMESTAMP)");
        }
        EvictionByCriteriaTest.assertTrue((boolean)stmt.execute("select * from e.evictTable"));
        ResultSet rs = stmt.getResultSet();
        HashSet<Integer> ids = new HashSet<Integer>();
        while (rs.next()) {
            id = rs.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)100, (int)ids.size());
        for (i = 1; i <= 100; ++i) {
            EvictionByCriteriaTest.assertTrue((boolean)ids.contains(i));
        }
        Thread.sleep(32000L);
        EvictionByCriteriaTest.assertTrue((boolean)stmt.execute("select * from e.evictTable"));
        rs = stmt.getResultSet();
        ids = new HashSet();
        while (rs.next()) {
            id = rs.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)50, (int)ids.size());
        for (i = 1; i <= 50; ++i) {
            EvictionByCriteriaTest.assertTrue((boolean)ids.contains(i));
        }
        for (i = 101; i <= 200; ++i) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i + "', " + i * 10 + ", CURRENT_TIMESTAMP)");
        }
        EvictionByCriteriaTest.assertTrue((boolean)stmt.execute("select * from e.evictTable"));
        rs = stmt.getResultSet();
        ids = new HashSet();
        while (rs.next()) {
            id = rs.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)150, (int)ids.size());
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String gmtStrDate = sdf.format(Calendar.getInstance().getTime());
        Date date = new Date(gmtStrDate);
        stmt.execute("ALTER TABLE e.evictTable SET EVICTION FREQUENCY 5 SECONDS START T '" + new Time(date.getTime()) + "'");
        lr = (LocalRegion)Misc.getRegion((String)"/E/EVICTTABLE", (boolean)true, (boolean)false);
        evictionAttrs = lr.getAttributes().getCustomEvictionAttributes();
        EvictionByCriteriaTest.assertEquals((long)5000L, (long)evictionAttrs.getEvictorInterval());
        criteria = (GfxdEvictionCriteria)evictionAttrs.getCriteria();
        EvictionByCriteriaTest.assertEquals((String)"qty > 500", (String)criteria.getPredicateString());
        Thread.sleep(30000L);
        for (int i3 = 201; i3 <= 300; ++i3) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i3 + "', " + i3 * 10 + ", CURRENT_TIMESTAMP)");
        }
        Thread.sleep(10000L);
        EvictionByCriteriaTest.assertTrue((boolean)stmt.execute("select * from e.evictTable"));
        rs = stmt.getResultSet();
        ids = new HashSet();
        while (rs.next()) {
            int id2 = rs.getInt("id");
            ids.add(id2);
        }
        EvictionByCriteriaTest.assertEquals((int)50, (int)ids.size());
    }

    public void testEvictionService() throws Exception {
        int i;
        this.reduceLogLevelForTest("config");
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        String evictClause = "{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10";
        stmt.execute("create table e.evictTable(id varchar(20) primary key, qty int, ts timestamp)  " + this.getOffHeapSuffix() + "  partition by column(id) " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria (" + "{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10" + ") eviction frequency 5 seconds");
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/E/EVICTTABLE", (boolean)true, (boolean)false);
        CustomEvictionAttributes evictionAttrs = lr.getAttributes().getCustomEvictionAttributes();
        EvictionAttributes defEvictAttrs = lr.getAttributes().getEvictionAttributes();
        EvictionByCriteriaTest.assertEquals((Object)DataPolicy.HDFS_PERSISTENT_PARTITION, (Object)lr.getAttributes().getDataPolicy());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAlgorithm.LRU_HEAP, (Object)defEvictAttrs.getAlgorithm());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAction.OVERFLOW_TO_DISK, (Object)defEvictAttrs.getAction());
        EvictionByCriteriaTest.assertNotNull((Object)evictionAttrs);
        EvictionByCriteriaTest.assertEquals((long)0L, (long)evictionAttrs.getEvictorStartTime());
        EvictionByCriteriaTest.assertEquals((long)5000L, (long)evictionAttrs.getEvictorInterval());
        GfxdEvictionCriteria criteria = (GfxdEvictionCriteria)evictionAttrs.getCriteria();
        EvictionByCriteriaTest.assertEquals((String)"{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10", (String)criteria.getPredicateString());
        for (i = 1; i <= 10; ++i) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i + "', " + i * 10 + ", CURRENT_TIMESTAMP)");
        }
        Thread.sleep(17000L);
        for (i = 11; i <= 20; ++i) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i + "', " + i * 10 + ", CURRENT_TIMESTAMP)");
        }
        EvictionByCriteriaTest.assertTrue((boolean)stmt.execute("select * from e.evictTable"));
        ResultSet rs = stmt.getResultSet();
        HashSet<Integer> ids = new HashSet<Integer>();
        while (rs.next()) {
            int id = rs.getInt("id");
            EvictionByCriteriaTest.getLogger().info((Object)("The id is " + id));
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)10, (int)ids.size());
        for (int i2 = 11; i2 <= 20; ++i2) {
            EvictionByCriteriaTest.assertTrue((boolean)ids.contains(i2));
        }
        EvictionByCriteriaTest.assertEquals((long)10L, (long)lr.getCachePerfStats().getEvictions());
        EvictionByCriteriaTest.assertEquals((long)0L, (long)lr.getCachePerfStats().getEvictionsInProgress());
        EvictionByCriteriaTest.assertEquals((long)30L, (long)lr.getCachePerfStats().getEvaluations());
    }

    public void testBug49900() throws Exception {
        block14: {
            Statement st;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            EvictionByCriteriaTest.setupConnection();
                            Connection conn = jdbcConn;
                            st = conn.createStatement();
                            try {
                                st.execute("create table t1 (col1 int)  " + this.getOffHeapSuffix() + "  replicate persistent eviction by criteria (col1 > 0) evict incoming");
                                EvictionByCriteriaTest.fail("EVICTION BY CRITERIA is not supported for non-HDFS tables");
                            }
                            catch (SQLException e) {
                                if (e.getSQLState().equals("0A000") && e.getMessage().equals("Eviction By Criteria is not supported for non-HDFS Table.")) break block10;
                                throw e;
                            }
                        }
                        try {
                            st.execute("create table t2 (col1 int)  " + this.getOffHeapSuffix() + "  replicate eviction by criteria (col1 > 0) evict incoming");
                            EvictionByCriteriaTest.fail("EVICTION BY CRITERIA is not supported for non-HDFS tables");
                        }
                        catch (SQLException e) {
                            if (e.getSQLState().equals("0A000") && e.getMessage().equals("Eviction By Criteria is not supported for non-HDFS Table.")) break block11;
                            throw e;
                        }
                    }
                    try {
                        st.execute("create table t3 (col1 int)  " + this.getOffHeapSuffix() + "  partition by column (col1) persistent eviction by criteria (col1 > 0) evict incoming");
                        EvictionByCriteriaTest.fail("EVICTION BY CRITERIA is not supported for non-HDFS tables");
                    }
                    catch (SQLException e) {
                        if (e.getSQLState().equals("0A000") && e.getMessage().equals("Eviction By Criteria is not supported for non-HDFS Table.")) break block12;
                        throw e;
                    }
                }
                try {
                    st.execute("create table t4 (col1 int)  " + this.getOffHeapSuffix() + "   partition by column (col1) eviction by criteria (col1 > 0) evict incoming");
                    EvictionByCriteriaTest.fail("EVICTION BY CRITERIA is not supported for non-HDFS tables");
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("0A000") && e.getMessage().equals("Eviction By Criteria is not supported for non-HDFS Table.")) break block13;
                    throw e;
                }
            }
            try {
                st.execute("create table t5 (col1 varchar(20) primary key, col2 int)  " + this.getOffHeapSuffix() + "  partition by column (col1) eviction by lrucount 1 evictaction destroy hdfsstore (hstore)");
                EvictionByCriteriaTest.fail("EVICTION action is not supported for HDFS tables");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("0A000") && e.getMessage().equals("LRU eviction is not supported for HDFS tables.")) break block14;
                throw e;
            }
        }
    }

    public void testEvictionServiceIndex() throws Exception {
        int i;
        int id;
        int i2;
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        String evictClause = "{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10";
        stmt.execute("create table e.evictTable(id varchar(20) primary key, qty int, ts timestamp)  " + this.getOffHeapSuffix() + "  partition by column(id) " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria (" + "{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10" + ") eviction frequency 5 seconds");
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/E/EVICTTABLE", (boolean)true, (boolean)false);
        CustomEvictionAttributes evictionAttrs = lr.getAttributes().getCustomEvictionAttributes();
        EvictionAttributes defEvictAttrs = lr.getAttributes().getEvictionAttributes();
        EvictionByCriteriaTest.assertEquals((Object)DataPolicy.HDFS_PERSISTENT_PARTITION, (Object)lr.getAttributes().getDataPolicy());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAlgorithm.LRU_HEAP, (Object)defEvictAttrs.getAlgorithm());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAction.OVERFLOW_TO_DISK, (Object)defEvictAttrs.getAction());
        EvictionByCriteriaTest.assertNotNull((Object)evictionAttrs);
        EvictionByCriteriaTest.assertEquals((long)0L, (long)evictionAttrs.getEvictorStartTime());
        EvictionByCriteriaTest.assertEquals((long)5000L, (long)evictionAttrs.getEvictorInterval());
        GfxdEvictionCriteria criteria = (GfxdEvictionCriteria)evictionAttrs.getCriteria();
        EvictionByCriteriaTest.assertEquals((String)"{fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10", (String)criteria.getPredicateString());
        for (i2 = 1; i2 <= 10; ++i2) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i2 + "', " + i2 * 10 + ", CURRENT_TIMESTAMP)");
        }
        Thread.sleep(17000L);
        for (i2 = 11; i2 <= 20; ++i2) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i2 + "', " + i2 * 10 + ", CURRENT_TIMESTAMP)");
        }
        EvictionByCriteriaTest.assertTrue((boolean)stmt.execute("select * from e.evictTable"));
        ResultSet rs = stmt.getResultSet();
        HashSet<Integer> ids = new HashSet<Integer>();
        while (rs.next()) {
            id = rs.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)10, (int)ids.size());
        for (i = 11; i <= 20; ++i) {
            EvictionByCriteriaTest.assertTrue((boolean)ids.contains(i));
        }
        EvictionByCriteriaTest.assertTrue((boolean)stmt.execute("select * from e.evictTable -- GEMFIREXD-PROPERTIES queryHDFS=true"));
        rs = stmt.getResultSet();
        ids = new HashSet();
        while (rs.next()) {
            id = rs.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)20, (int)ids.size());
        for (i = 1; i <= 20; ++i) {
            EvictionByCriteriaTest.assertTrue((boolean)ids.contains(i));
        }
        EvictionByCriteriaTest.assertTrue((boolean)stmt.execute("select * from e.evictTable -- GEMFIREXD-PROPERTIES queryHDFS=false"));
        rs = stmt.getResultSet();
        ids = new HashSet();
        while (rs.next()) {
            id = rs.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)10, (int)ids.size());
        for (i = 11; i <= 20; ++i) {
            EvictionByCriteriaTest.assertTrue((boolean)ids.contains(i));
        }
        EvictionByCriteriaTest.assertEquals((long)10L, (long)lr.getCachePerfStats().getEvictions());
        EvictionByCriteriaTest.assertEquals((long)0L, (long)lr.getCachePerfStats().getEvictionsInProgress());
    }

    public void testEvictIncomingDDLSupport() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        String evictClause = "qty > 100";
        stmt.execute("create table e.evictTable(id varchar(20) primary key, qty int, ts timestamp)  " + this.getOffHeapSuffix() + "  partition by column(id) " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria (" + "qty > 100" + ") EVICT INCOMING ");
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/E/EVICTTABLE", (boolean)true, (boolean)false);
        GemFireContainer container = (GemFireContainer)lr.getUserAttribute();
        CustomEvictionAttributes evictionAttrs = lr.getAttributes().getCustomEvictionAttributes();
        EvictionAttributes defEvictAttrs = lr.getAttributes().getEvictionAttributes();
        EvictionByCriteriaTest.assertEquals((Object)DataPolicy.HDFS_PERSISTENT_PARTITION, (Object)lr.getAttributes().getDataPolicy());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAlgorithm.LRU_HEAP, (Object)defEvictAttrs.getAlgorithm());
        EvictionByCriteriaTest.assertEquals((Object)EvictionAction.OVERFLOW_TO_DISK, (Object)defEvictAttrs.getAction());
        EvictionByCriteriaTest.assertNotNull((Object)evictionAttrs);
        GfxdEvictionCriteria criteria = (GfxdEvictionCriteria)evictionAttrs.getCriteria();
        EvictionByCriteriaTest.assertEquals((String)"qty > 100", (String)criteria.getPredicateString());
        EvictionByCriteriaTest.assertTrue((boolean)evictionAttrs.isEvictIncoming());
        for (int i = 1; i <= 20; ++i) {
            stmt.executeUpdate("insert into e.evictTable values ('" + i + "', " + i * 10 + ", CURRENT_TIMESTAMP)");
        }
        EvictionByCriteriaTest.assertEquals((int)10, (int)lr.size());
        CachePerfStats stats = lr.getCachePerfStats();
        EvictionByCriteriaTest.assertEquals((long)10L, (long)stats.getEvictions());
        EvictionByCriteriaTest.assertEquals((long)0L, (long)stats.getEvictionsInProgress());
        EvictionByCriteriaTest.assertEquals((long)20L, (long)stats.getEvaluations());
    }

    public void testEvictIncomingQueryHDFS() throws Exception {
        int id;
        ResultSet rs;
        int i;
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table e.evictTable( id int primary key, qty int, abc int )  " + this.getOffHeapSuffix() + "   partition by column(id) persistent hdfsstore (hdfsdata) " + "eviction by criteria ( qty > 100 ) EVICT INCOMING ");
        stmt.execute("create index idx on e.evictTable (qty, abc)");
        for (int i2 = 1; i2 <= 20; ++i2) {
            stmt.executeUpdate("insert into e.evictTable values (" + i2 + ", " + i2 * 10 + ", " + i2 * 10 + ")");
        }
        PreparedStatement ps = conn.prepareStatement("select * from e.evictTable -- GEMFIREXD-PROPERTIES queryHDFS=false \n where qty=?");
        for (i = 1; i < 20; ++i) {
            ps.setInt(1, i * 10);
            rs = ps.executeQuery();
            if (i > 10) {
                EvictionByCriteriaTest.assertFalse((boolean)rs.next());
                continue;
            }
            EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        }
        ps = conn.prepareStatement("select * from e.evictTable -- GEMFIREXD-PROPERTIES queryHDFS=false \n where id=?");
        for (i = 1; i < 20; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            if (i > 10) {
                EvictionByCriteriaTest.assertFalse((boolean)rs.next());
                continue;
            }
            EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        }
        ps = conn.prepareStatement("select * from e.evictTable -- GEMFIREXD-PROPERTIES queryHDFS=true  \n where id=?");
        for (i = 1; i < 20; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        }
        ResultSet rs1 = stmt.executeQuery("select * from e.evictTable -- GEMFIREXD-PROPERTIES queryHDFS=true");
        HashSet<Integer> ids = new HashSet<Integer>();
        while (rs1.next()) {
            id = rs1.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)20, (int)ids.size());
        rs1 = stmt.executeQuery("select * from e.evictTable -- GEMFIREXD-PROPERTIES queryHDFS=false");
        ids = new HashSet();
        while (rs1.next()) {
            id = rs1.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)10, (int)ids.size());
        rs1 = stmt.executeQuery("select * from e.evictTable -- GEMFIREXD-PROPERTIES queryHDFS=false  \n where qty > 100");
        ids = new HashSet();
        while (rs1.next()) {
            id = rs1.getInt("id");
            ids.add(id);
        }
        EvictionByCriteriaTest.assertEquals((int)0, (int)ids.size());
    }

    public void testEvictIncomingWithPartitionKey() throws Exception {
        Statement stmt;
        block4: {
            EvictionByCriteriaTest.setupConnection();
            Connection conn = jdbcConn;
            stmt = conn.createStatement();
            stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
            stmt.execute("create table e.evictTable( id int primary key, partkey int not null )  " + this.getOffHeapSuffix() + "  partition by column(partkey) persistent hdfsstore (hdfsdata) " + "eviction by criteria ( id > 10 ) EVICT INCOMING ");
            stmt.executeUpdate("insert into e.evictTable values (20, 200 )");
            try {
                stmt.executeUpdate("insert into e.evictTable values (20, 201)");
                EvictionByCriteriaTest.fail("Did not get expected constraint violation exception");
            }
            catch (SQLException e) {
                if ("23505".equals(e.getSQLState())) break block4;
                throw e;
            }
        }
        stmt.executeUpdate("insert into e.evictTable values (30, 201 )");
        stmt.executeUpdate("delete from e.evictTable where id=30");
        EvictionByCriteriaTest.shutDown();
        String currDir = System.getProperty("user.dir");
        File cdir = new File(currDir);
        String[] files = cdir.list();
        if (files != null) {
            for (String file : files) {
                if (!file.matches(".*GFXD-DEFAULT-DISKSTORE.*krf")) continue;
                File f = new File(file);
                f.delete();
            }
        }
        EvictionByCriteriaTest.setupConnection();
    }

    public void testEvictIncomingWithUniqueIndex() throws Exception {
        block3: {
            EvictionByCriteriaTest.setupConnection();
            Connection conn = jdbcConn;
            Statement stmt = conn.createStatement();
            stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
            stmt.execute("create table e.evictTable( id int primary key, partkey int not null, qty int, constraint uq unique (partkey, qty) )  " + this.getOffHeapSuffix() + "  partition by column(partkey) persistent hdfsstore (hdfsdata) " + "eviction by criteria ( qty > 100 ) EVICT INCOMING ");
            for (int i = 1; i <= 20; ++i) {
                stmt.executeUpdate("insert into e.evictTable values (" + i + ", " + i * 10 + ", " + i * 100 + ")");
            }
            try {
                stmt.executeUpdate("insert into e.evictTable values (21, 200, 2000)");
                EvictionByCriteriaTest.fail("Did not get expected constraint violation exception");
            }
            catch (SQLException e) {
                if ("23505".equals(e.getSQLState())) break block3;
                throw e;
            }
        }
    }

    public void testEvictIncomingWithUniqueIndexDelete() throws Exception {
        Statement stmt;
        block6: {
            block5: {
                EvictionByCriteriaTest.setupConnection();
                Connection conn = jdbcConn;
                stmt = conn.createStatement();
                stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
                stmt.execute("create table e.evictTable( id int primary key, partkey int not null, qty int, constraint uq unique (partkey, qty) )  " + this.getOffHeapSuffix() + "  partition by column(partkey) persistent hdfsstore (hdfsdata) " + "eviction by criteria ( qty > 100 ) EVICT INCOMING ");
                stmt.execute("create table e.simpleTable( id int primary key, partkey int not null, qty int, constraint uq2 unique (partkey, qty) )  " + this.getOffHeapSuffix() + "  partition by column(partkey) ");
                for (int i = 20; i <= 20; ++i) {
                    stmt.executeUpdate("insert into e.evictTable values (" + i + ", " + i * 10 + ", " + i * 100 + ")");
                    stmt.executeUpdate("insert into e.simpleTable values (" + i + ", " + i * 10 + ", " + i * 100 + ")");
                }
                try {
                    stmt.executeUpdate("insert into e.evictTable values (21, 200, 2000)");
                    EvictionByCriteriaTest.fail("Did not get expected constraint violation exception");
                }
                catch (SQLException e) {
                    if ("23505".equals(e.getSQLState())) break block5;
                    throw e;
                }
            }
            try {
                stmt.executeUpdate("insert into e.simpleTable values (21, 200, 2000)");
                EvictionByCriteriaTest.fail("Did not get expected constraint violation exception");
            }
            catch (SQLException e) {
                if ("23505".equals(e.getSQLState())) break block6;
                throw e;
            }
        }
        stmt.execute("delete from e.evictTable where id= 20");
        stmt.execute("delete from e.simpleTable where id= 20");
        ResultSet rs = stmt.executeQuery("select * from e.evictTable  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where id = 20 ");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from e.simpleTable where id = 20");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        stmt.executeUpdate("insert into e.simpleTable values (21, 200, 2000)");
        stmt.executeUpdate("insert into e.evictTable values (21, 200, 2000)");
    }

    public void testEvictIncomingWithUniqueIndexUpdateDelete() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table e.evictTable( id int primary key, partkey int not null, qty int, constraint uq unique (partkey, qty) )  " + this.getOffHeapSuffix() + "  partition by column(partkey) persistent hdfsstore (hdfsdata) " + "eviction by criteria ( qty > 100 ) EVICT INCOMING ");
        stmt.execute("create table e.simpleTable( id int primary key, partkey int not null, qty int, constraint uq2 unique (partkey, qty) )  " + this.getOffHeapSuffix() + "  partition by column(partkey) ");
        int i = 20;
        stmt.executeUpdate("insert into e.evictTable values (" + i + ", " + i * 10 + ", " + i * 100 + ")");
        stmt.executeUpdate("update e.evictTable set qty=300 where id=20");
        stmt.execute("delete from e.evictTable where id= 20");
        ResultSet rs = stmt.executeQuery("select * from e.evictTable  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where id = 20 ");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        stmt.executeUpdate("insert into e.evictTable values (21, 200, 2000)");
    }

    public void testEvictIncomingWithUniqueIndexUpdateDelete2() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  " + this.getOffHeapSuffix() + "  persistent hdfsstore (hdfsdata) " + "EVICTION BY CRITERIA ( qty > 500  ) EVICT INCOMING ");
        stmt.executeUpdate("insert into trade.portfolio  values(3, 120, 1592, 1592, 14264.32000000000000000000 ,18)");
        try {
            stmt.executeUpdate("insert into trade.portfolio  values(3, 120, 1374, 1374, 12311.04000000000000000000, 18)");
            EvictionByCriteriaTest.fail("failed");
        }
        catch (Exception c) {
            c.printStackTrace();
        }
        stmt.execute("delete from trade.portfolio where cid = 3 and sid = 120 and tid = 18");
        ResultSet rs = stmt.executeQuery("select * from trade.portfolio  -- GEMFIREXD-PROPERTIES queryHDFS=true ");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        stmt.executeUpdate("insert into trade.portfolio  values(3, 120, 1374, 1374, 12311.04000000000000000000, 8)");
    }

    public void testEvictIncomingWithUniqueIndexUpdate() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table e.evictTable( id int primary key, partkey int not null, qty int, constraint uq unique (partkey, qty) )  " + this.getOffHeapSuffix() + "  persistent hdfsstore (hdfsdata) " + "eviction by criteria ( qty > 100 ) EVICT INCOMING ");
        stmt.execute("create table e.simpleTable( id int primary key, partkey int not null, qty int, constraint uq2 unique (partkey, qty) )  " + this.getOffHeapSuffix() + "  ");
        for (int i = 20; i <= 20; ++i) {
            stmt.executeUpdate("insert into e.evictTable values (" + i + ", " + i * 10 + ", " + i * 100 + ")");
            stmt.executeUpdate("insert into e.simpleTable values (" + i + ", " + i * 10 + ", " + i * 100 + ")");
        }
        stmt.executeUpdate("update e.evictTable set qty=2002,partkey=202 where id = 20");
        stmt.executeUpdate("update e.simpleTable set qty=2002,partkey=202 where id = 20");
        ResultSet rs = stmt.executeQuery("select * from e.evictTable  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where id = 20 ");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)202, (int)rs.getInt(2));
        EvictionByCriteriaTest.assertEquals((int)2002, (int)rs.getInt(3));
    }

    public void testEvictIncomingWithUniqueIndexUpdate2() throws Exception {
        String[] arr;
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  " + this.getOffHeapSuffix() + "  persistent hdfsstore (hdfsdata) " + "EVICTION BY CRITERIA ( qty > 500  ) EVICT INCOMING ");
        stmt.executeUpdate("insert into trade.portfolio values ( 104 , 91 , 1568 , 1568 , 53500.16000000000000000000 , 6)");
        try {
            stmt.executeUpdate("insert into trade.portfolio values ( 104 , 91 , 2000 , 2000 , 68240.00000000000000000000 ,6)");
            EvictionByCriteriaTest.fail("failed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            stmt.executeUpdate("insert into trade.portfolio values ( 104 , 91 , 247 , 247 , 8427.64000000000000000000, 6)");
            EvictionByCriteriaTest.fail("failed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            stmt.executeUpdate("insert into trade.portfolio values ( 104 , 91 , 1408 , 1408 , 48040.96000000000000000000, 6)");
            EvictionByCriteriaTest.fail("failed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String st : arr = new String[]{"insert into trade.portfolio values ( 104 , 91 , 1090 , 1090 , 37190.80000000000000000000 ,6)", "insert into  trade.portfolio  values (104 , 91 , 659 , 659 , 22485.08000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 1943 , 1943 , 66295.16000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 1051 , 1051 , 35860.12000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 1905 , 1905 , 64998.60000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 756 , 756 , 25794.72000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 432 , 432 , 14739.84000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 438 , 438 , 14944.56000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 633 , 633 , 21597.96000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 755 , 755 , 25760.60000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 1737 , 1737 , 59266.44000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 691 , 691 , 23576.92000000000000000000, 6)", "insert into  trade.portfolio  values (104 , 91 , 1968 , 1968 , 67148.16000000000000000000, 6)"}) {
            try {
                stmt.executeUpdate(st);
                EvictionByCriteriaTest.fail("failed");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ResultSet rs = stmt.executeQuery("select * from trade.portfolio where qty > 500");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.portfolio -- GEMFIREXD-PROPERTIES queryHDFS=true \n where qty > 500 ");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        System.out.println(rs.getInt("qty"));
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/TRADE/PORTFOLIO", (boolean)true, (boolean)false);
        System.out.println(lr.size());
        for (Object o : lr.entrySet()) {
            System.out.println("Entry : " + o);
        }
    }

    public void testEvictIncomingWithForeignKey() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table trade.customers (cid int not null, cust_name int, primary key (cid))  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria ( cid > 5 ) EVICT INCOMING ");
        String expectedMessage = "Foreign key constraint is not supported with custom eviction criteria for HDFS tables.";
        try {
            stmt.execute("create table trade.networth (netid int not null, cid int not null, cash decimal (30, 20), constraint netw_pk primary key (netid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict)  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria ( cash > 1000 ) EVICT INCOMING ");
            EvictionByCriteriaTest.fail("Expected SQLFeatureNotSupportedException as FK is not supported with custom eviction to HDFS.");
        }
        catch (SQLFeatureNotSupportedException e) {
            EvictionByCriteriaTest.assertTrue((boolean)e.getMessage().equals(expectedMessage));
        }
        stmt.execute("create table trade.networth (netid int not null, cid int not null, cash decimal (30, 20), constraint netw_pk primary key (netid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict)  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) ");
    }

    public void testEvictIncomingWithLocalIndexes() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table trade.customers (cid int not null, cust_name int, addr int, primary key (cid))  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria ( cust_name > 5 ) EVICT INCOMING ");
        stmt.execute("create index idx1 on trade.customers (cust_name)");
        stmt.execute("create index idx2 on trade.customers (addr)");
        stmt.executeUpdate("insert into trade.customers values (12, 120, 1200)");
        stmt.executeUpdate("insert into trade.customers values (13, 130, 1300)");
        stmt.executeUpdate("insert into trade.customers values (1, 1, 100)");
        try {
            stmt.executeUpdate("insert into trade.customers values (12, 120, 1200)");
            EvictionByCriteriaTest.fail("Expected Exception as the row was already inserted. ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=1");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=1");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=100");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)100, (int)rs.getInt("addr"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=12");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=120");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1200");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=13");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=130");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1300");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=12");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)12, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=120");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)120, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1200");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1200, (int)rs.getInt("addr"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=13");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)13, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=130");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)130, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1300");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1300, (int)rs.getInt("addr"));
        stmt.executeUpdate("update trade.customers set cust_name=4 where cid=12");
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=12");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)12, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=4");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)4, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1200");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1200, (int)rs.getInt("addr"));
        stmt.executeUpdate("update trade.customers set cust_name=15 where cid=13");
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=13");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=15");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1300");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=13");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)13, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=15");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)15, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1300");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1300, (int)rs.getInt("addr"));
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/TRADE/CUSTOMERS", (boolean)true, (boolean)false);
    }

    public void testEvictIncomingWithLocalIndexesMultipleOperations() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table trade.customers (cid int not null, cust_name int, addr int, primary key (cid))  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria ( cust_name > 5 ) EVICT INCOMING ");
        stmt.execute("create index idx1 on trade.customers (cust_name)");
        stmt.execute("create index idx2 on trade.customers (addr)");
        stmt.executeUpdate("insert into trade.customers values (12, 120, 1200)");
        ResultSet rs = null;
        stmt.executeUpdate("update trade.customers set cust_name=4 where cid=12");
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=12");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)12, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=4");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)4, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1200");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1200, (int)rs.getInt("addr"));
        stmt.execute("delete from trade.customers where cid=12");
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=12");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=4");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1200");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=12");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=4");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1200");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        stmt.executeUpdate("insert into trade.customers values (12, 120, 1200)");
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=12");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=4");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1200");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=12");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)12, (int)rs.getInt("cid"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=120");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)120, (int)rs.getInt("cust_name"));
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1200");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1200, (int)rs.getInt("addr"));
        stmt.execute("delete from trade.customers where cid=12");
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=12");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cust_name=4");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=false \n where addr=1200");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=12");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cust_name=4");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true \n where addr=1200");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/TRADE/CUSTOMERS", (boolean)true, (boolean)false);
        EvictionByCriteriaTest.assertEquals((int)0, (int)lr.size());
    }

    public void testEvictIncomingWithLocalIndexesFailedOperation() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria ( qty > 100 ) EVICT INCOMING ");
        stmt.executeUpdate("insert into trade.portfolio values (1, 2, 2000 , 200)");
        Thread.sleep(10000L);
        try {
            stmt.executeUpdate("insert into trade.portfolio values (1, 2, 20 , 2)");
            EvictionByCriteriaTest.fail("Expected Exception as the row was already inserted in the table.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet rs = null;
        rs = stmt.executeQuery("select * from trade.portfolio -- GEMFIREXD-PROPERTIES queryHDFS=false \n where cid=1");
        EvictionByCriteriaTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.portfolio -- GEMFIREXD-PROPERTIES queryHDFS=true \n where cid=1");
        EvictionByCriteriaTest.assertTrue((boolean)rs.next());
        EvictionByCriteriaTest.assertEquals((int)1, (int)rs.getInt("cid"));
        EvictionByCriteriaTest.assertEquals((int)2, (int)rs.getInt("sid"));
        EvictionByCriteriaTest.assertEquals((int)2000, (int)rs.getInt("qty"));
        EvictionByCriteriaTest.assertEquals((int)200, (int)rs.getInt("availQty"));
        LocalRegion lr = (LocalRegion)Misc.getRegion((String)"/TRADE/PORTFOLIO", (boolean)true, (boolean)false);
    }

    public void testEvictIncomingWithTrigger() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table e.evictTable_history( id int primary key, qty int, abc int )  " + this.getOffHeapSuffix() + "  ");
        String insertStmt = "INSERT INTO e.evictTable_history  VALUES (  NEWROW.id ,  NEWROW.qty , NEWROW.abc )";
        String delStmt = "DELETE FROM e.evictTable_history  WHERE id=OLDROW.id";
        String insertTriggerStmt = "CREATE TRIGGER  e.evictTable_INSERTTRIGGER AFTER INSERT ON e.evictTable REFERENCING NEW AS NEWROW FOR EACH ROW  " + insertStmt;
        String deleteTriggerStmt = "CREATE TRIGGER  e.evictTable_DELETETRIGGER AFTER DELETE ON e.evictTable REFERENCING OLD AS OLDROW  FOR EACH ROW " + delStmt;
        String updateTriggerStmt = "CREATE TRIGGER  e.evictTable_DELETEFORUPDATE AFTER UPDATE ON e.evictTable REFERENCING NEW AS NEWROW OLD AS OLDROW FOR EACH ROW  " + delStmt;
        String updateTriggerStmt1 = "CREATE TRIGGER  e.evictTable_INSERTFORUPDATE AFTER UPDATE ON e.evictTable REFERENCING NEW AS NEWROW OLD AS OLDROW FOR EACH ROW " + insertStmt;
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table e.evictTable( id int primary key, qty int, abc int )  " + this.getOffHeapSuffix() + "  partition by column(id) persistent hdfsstore (hdfsdata) " + "eviction by criteria ( qty > 100 ) EVICT INCOMING ");
        stmt.execute(insertTriggerStmt);
        stmt.execute(deleteTriggerStmt);
        stmt.execute(updateTriggerStmt);
        stmt.execute(updateTriggerStmt1);
        stmt.execute("insert into e.evictTable values (1, 1, 200)");
        stmt.execute("insert into e.evictTable values (2, 2, 200)");
        stmt.execute("insert into e.evictTable values (3, 200, 200)");
        stmt.execute("update e.evictTable set qty = 300 where id=3");
        stmt.execute("update e.evictTable set qty = 500 where id=2");
        ResultSet actualRs = stmt.executeQuery("select * from e.evictTable");
        while (actualRs.next()) {
            EvictionByCriteriaTest.assertEquals((int)1, (int)actualRs.getInt("qty"));
            EvictionByCriteriaTest.assertEquals((int)1, (int)actualRs.getInt("id"));
        }
        ResultSet triggerRs = stmt.executeQuery("select * from e.evictTable_history");
        HashSet<Integer> s1 = new HashSet<Integer>();
        HashSet<Integer> s2 = new HashSet<Integer>();
        while (triggerRs.next()) {
            s1.add(triggerRs.getInt("id"));
            s2.add(triggerRs.getInt("qty"));
        }
        EvictionByCriteriaTest.assertEquals((int)3, (int)s1.size());
        EvictionByCriteriaTest.assertEquals((int)3, (int)s2.size());
        EvictionByCriteriaTest.assertTrue((boolean)s1.contains(1));
        EvictionByCriteriaTest.assertTrue((boolean)s1.contains(2));
        EvictionByCriteriaTest.assertTrue((boolean)s1.contains(3));
        EvictionByCriteriaTest.assertTrue((boolean)s2.contains(1));
        EvictionByCriteriaTest.assertTrue((boolean)s2.contains(300));
        EvictionByCriteriaTest.assertTrue((boolean)s2.contains(500));
    }

    public void testEvictIncomingWithForeignKey2() throws Exception {
        Statement stmt;
        block3: {
            EvictionByCriteriaTest.setupConnection();
            Connection conn = jdbcConn;
            stmt = conn.createStatement();
            stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
            stmt.execute("create table trade.customers (cid int not null, cust_name int, primary key (cid))  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria ( cid > 5 ) EVICT INCOMING ");
            stmt.execute("create table trade.networth (netid int not null, cid int not null, cash decimal (30, 20), constraint netw_pk primary key (netid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict)  " + this.getOffHeapSuffix() + "  " + " persistent hdfsstore (hdfsdata) ");
            stmt.executeUpdate("insert into trade.customers values (12, 1200)");
            stmt.executeUpdate("insert into trade.networth values (12, 12, 1200)");
            stmt.executeUpdate("insert into trade.customers values (11, 110)");
            stmt.executeUpdate("insert into trade.networth values (11, 11, 110)");
            try {
                stmt.executeUpdate("delete from trade.customers where cid=11");
                EvictionByCriteriaTest.fail("Expected SQLIntegrityConstraintViolationException");
            }
            catch (SQLException e) {
                if ("23503".equals(e.getSQLState())) break block3;
                throw e;
            }
        }
        stmt.executeUpdate("update trade.customers set cust_name=1100 where cid=11");
        stmt.executeUpdate("update trade.networth set cash=2000 where cid=11");
        ResultSet rs = stmt.executeQuery("select * from trade.customers -- GEMFIREXD-PROPERTIES queryHDFS=true");
        while (rs.next()) {
            System.out.println(rs.getInt("cid"));
            System.out.println(rs.getInt("cust_name"));
        }
        System.out.println("END");
    }

    public void testEvictIncomingWithAlterTableAddForeignKeyConstraint() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table trade.customers (cid int not null, cust_name int, primary key (cid))  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria ( cid > 5 ) EVICT INCOMING ");
        stmt.execute("create table trade.networth (netid int not null, cid int not null, cash decimal (30, 20), constraint netw_pk primary key (netid))  " + this.getOffHeapSuffix() + "  " + " persistent hdfsstore (hdfsdata)" + " eviction by criteria ( cash > 1000 ) EVICT INCOMING ");
        try {
            stmt.execute("alter table trade.networth add constraint cust_newt_fk foreign key (cid) references trade.customers (cid)");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testEvictIncomingWithAlterTableAddForeignKeyConstraint_2() throws Exception {
        EvictionByCriteriaTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create hdfsstore hdfsdata namenode 'localhost' homedir './evictHDFS' QUEUEPERSISTENT true");
        stmt.execute("create table trade.customers (cid int not null, cust_name int, primary key (cid))  " + this.getOffHeapSuffix() + "  " + "persistent hdfsstore (hdfsdata) " + "eviction by criteria ( cid > 5 ) EVICT INCOMING ");
        stmt.execute("create table trade.networth (netid int not null, cid int not null, cash decimal (30, 20), constraint netw_pk primary key (netid))  " + this.getOffHeapSuffix() + "  " + " persistent hdfsstore (hdfsdata)");
        stmt.execute("alter table trade.networth add constraint cust_newt_fk foreign key (cid) references trade.customers (cid)");
    }

    public static void dumpAll() {
        try {
            GfxdDumpLocalResultMessage msg = new GfxdDumpLocalResultMessage();
            InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
            msg.send(sys, null);
            msg.executeLocally(sys.getDistributionManager(), false);
            GfxdDumpLocalResultMessage.sendBucketInfoDumpMsg(null, (boolean)false);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    protected String getOffHeapSuffix() {
        return " ";
    }
}

