/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.hadoop;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.DDLHoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.GFInputFormat;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HDFSSplitIterator;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.BlobHelper;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.store.entry.HDFSEventRowLocationRegionEntry;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import io.snappydata.test.dunit.AvailablePortHelper;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

public class DDLPersistenceHDFSTest
extends JdbcTestBase {
    String HDFS_DIR = "./myhdfs";
    final String expectedExceptions = InterruptedException.class.getName() + "||" + IOException.class.getName();

    public DDLPersistenceHDFSTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        FileUtil.delete((File)new File(this.HDFS_DIR));
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        FileUtil.delete((File)new File(this.HDFS_DIR));
        FileUtil.delete((File)new File("./mynewhdfs"));
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testBackwardCompatibility() throws Exception {
        Properties props = new Properties();
        System.setProperty("gemfirexd.use-pre1302-hashing", "true");
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "'");
        st.execute("create table mytab (col1 int primary key) persistent hdfsstore (myhdfs) writeonly");
        ArrayList<DDLConflatable> ddlListTobePersisted = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        HDFSStoreImpl hdfsstore = GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS");
        ArrayList<byte[]> keyList = new ArrayList<byte[]>();
        ArrayList<byte[]> valueList = new ArrayList<byte[]>();
        try {
            for (DDLConflatable ddlstmt : ddlListTobePersisted) {
                SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("EmbedStatement: Persisting all statements on HDFS " + ddlstmt.getValueToConflate()));
                byte[] valueBytes = BlobHelper.serializeToBlob((Object)ddlstmt, (Version)Version.GFXD_101);
                byte[] keyBytes = BlobHelper.serializeToBlob((Object)ddlstmt.getId(), (Version)Version.GFXD_101);
                keyList.add(keyBytes);
                valueList.add(valueBytes);
            }
        }
        catch (IOException e) {
            throw new InternalGemFireError("Could not serialize DDL statement", (Throwable)e);
        }
        hdfsstore.getDDLHoplogOrganizer().flush(keyList.iterator(), valueList.iterator(), Version.GFXD_101);
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        ArrayList<DDLConflatable> ddlList = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        for (DDLConflatable ddl : ddlList) {
            DDLPersistenceHDFSTest.assertEquals((short)ddl.getDDLVersion(), (short)Version.GFXD_13.ordinal());
        }
        TestUtil.shutDown();
    }

    public void testDDLPersistenceOnHDFS() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "'");
        ArrayList<DDLConflatable> ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 2 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        st.execute("create table mytab1 (col1 int primary key)");
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 2 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        st.execute("create table mytab (col1 int primary key) persistent hdfsstore (myhdfs) writeonly");
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 3 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        st.execute("create table mytab2 (col1 int primary key) hdfsstore (myhdfs) writeonly");
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 4 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getTableName().equals("MYTAB"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getTableName().equals("MYTAB2"));
        st.execute("create hdfsstore mynewhdfs namenode 'localhost' homedir './mynewhdfs'");
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 4 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getTableName().equals("MYTAB"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getTableName().equals("MYTAB2"));
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYNEWHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 2 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        st.execute("create table mytab3 (col1 int primary key) hdfsstore (mynewhdfs) writeonly");
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYNEWHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 3 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 4 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getTableName().equals("MYTAB"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getTableName().equals("MYTAB2"));
        st.execute("drop table mytab");
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 4 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getTableName().equals("MYTAB"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getTableName().equals("MYTAB2"));
        st.execute("create table mytab4 (col1 int primary key) persistent hdfsstore (myhdfs) writeonly");
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 4 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getTableName().equals("MYTAB2"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getTableName().equals("MYTAB4"));
        st.execute("create alias x for 'y'");
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 5 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getTableName().equals("MYTAB2"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getTableName().equals("MYTAB4"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(4).getValueToConflate().startsWith("create alias"));
        ddlconflatables = this.getDDLConflatables(GemFireCacheImpl.getInstance().findHDFSStore("MYNEWHDFS"));
        DDLPersistenceHDFSTest.assertTrue((ddlconflatables.size() == 4 ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
        DDLPersistenceHDFSTest.assertTrue((boolean)ddlconflatables.get(3).getValueToConflate().startsWith("create alias"));
        TestUtil.shutDown();
    }

    public void testDDLReplayOnHDFS() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "'");
        st.execute("create table mytab1 (col1 int primary key)");
        st.execute("create table mytab (col1 int primary key) persistent hdfsstore (myhdfs) writeonly");
        st.execute("create table mytab2 (col1 int primary key) persistent hdfsstore (myhdfs) writeonly");
        st.execute("create hdfsstore mynewhdfs namenode 'localhost' homedir './mynewhdfs'");
        st.execute("create table mytab3 (col1 int primary key) hdfsstore (mynewhdfs) writeonly");
        st.execute("drop table mytab");
        st.execute("create table mytab4 (col1 int primary key) hdfsstore (myhdfs) writeonly");
        st.execute("create alias x for 'y'");
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("select * from sys.syshdfsstores");
        ResultSet rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        DDLPersistenceHDFSTest.assertEquals((String)"MYHDFS", (String)rs.getString(1));
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB2'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB4'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB3'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./mynewhdfs");
        conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        DDLPersistenceHDFSTest.assertEquals((String)"MYNEWHDFS", (String)rs.getString(1));
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB3'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        DDLPersistenceHDFSTest.assertEquals((String)"MYTAB3", (String)rs.getString(2));
        st.execute("select * from sys.systables where tablename='MYTAB'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB2'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB4'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
    }

    public void testDDLReplayOfTwoHDFSStores() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "'");
        st.execute("create table mytab1 (col1 int primary key)");
        st.execute("create table mytab (col1 int primary key) persistent hdfsstore (myhdfs) writeonly");
        st.execute("create table mytab2 (col1 int primary key) persistent hdfsstore (myhdfs) writeonly");
        st.execute("create hdfsstore mynewhdfs namenode 'localhost' homedir './mynewhdfs'");
        st.execute("create table mytab3 (col1 int primary key) hdfsstore (mynewhdfs) writeonly");
        st.execute("drop table mytab");
        st.execute("create table mytab4 (col1 int primary key) hdfsstore (myhdfs) writeonly");
        st.execute("create alias x for 'y'");
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "localhost");
        props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs,./mynewhdfs");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("select * from sys.syshdfsstores where name='MYHDFS'");
        ResultSet rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        st.execute("select * from sys.syshdfsstores where name='MYNEWHDFS'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB1'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB2'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB4'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB3'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        DDLPersistenceHDFSTest.assertEquals((String)"MYTAB3", (String)rs.getString(2));
    }

    public void testDDLReplayColocatedRegions() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create diskstore hdfsStoreDisk 'hdfsStoreData' autocompact false");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' DISKSTORENAME hdfsStoreDisk");
        st.execute("create table mytab (col1 int primary key) persistent hdfsstore (myhdfs)");
        st.execute("create table mytab_colocated (col2 int primary key, col1 int) persistent hdfsstore (myhdfs) partition by column (col1) colocate with (mytab)");
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("select * from sys.syshdfsstores");
        ResultSet rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        DDLPersistenceHDFSTest.assertEquals((String)"MYHDFS", (String)rs.getString(1));
        st.execute("select * from sys.systables where tablename='MYTAB'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB_COLOCATED'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
    }

    public void testDDLReplayHDFSRegionColocatedWithNonHDFS() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create diskstore hdfsStoreDisk 'hdfsStoreData' autocompact false");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' DISKSTORENAME hdfsStoreDisk");
        st.execute("create table mytab (col1 int primary key) hdfsstore (myhdfs) persistent");
        st.execute("create table mytab_colocated (col2 int primary key, col1 int) persistent partition by column (col1) colocate with (mytab)");
        st.execute("insert into mytab (col1) values (1)");
        st.execute("insert into mytab_colocated (col1,col2) values (1,1)");
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("select * from sys.syshdfsstores");
        ResultSet rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        DDLPersistenceHDFSTest.assertEquals((String)"MYHDFS", (String)rs.getString(1));
        st.execute("select * from sys.systables where tablename='MYTAB'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertTrue((boolean)rs.next());
        st.execute("select * from sys.systables where tablename='MYTAB_COLOCATED'");
        rs = st.getResultSet();
        DDLPersistenceHDFSTest.assertFalse((boolean)rs.next());
    }

    public void testCreateTableConstraintsDuringReplay() throws Exception {
        Set ids;
        LocalRegion r;
        Statement st;
        block6: {
            Properties props = new Properties();
            int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            props.put("server-groups", "SG1");
            props.put("mcast-port", String.valueOf(mcastPort));
            Connection conn = TestUtil.getConnection(props);
            st = conn.createStatement();
            st.execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.internal.hadoop.DDLPersistenceHDFSTest$TestAsyncListener' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
            st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs'");
            st.execute("create table Child ( id2 int primary key, sector_id2 int unique, subsector_id2 int  ) persistent hdfsstore (myhdfs) buckets 11 eviction by criteria (id2 > 1000) evict incoming ASYNCEVENTLISTENER(myListener)");
            boolean exceptionthrown = false;
            st.execute("insert into Child (id2, sector_id2, subsector_id2) values (1, 1, 1)");
            try {
                st.execute("insert into Child (id2, sector_id2, subsector_id2) values (1, 2, 2)");
            }
            catch (Exception e) {
                exceptionthrown = true;
            }
            DDLPersistenceHDFSTest.assertTrue((boolean)exceptionthrown);
            exceptionthrown = false;
            try {
                st.execute("insert into Child (id2, sector_id2, subsector_id2) values (2, 1, 2)");
            }
            catch (Exception e) {
                exceptionthrown = true;
            }
            DDLPersistenceHDFSTest.assertTrue((boolean)exceptionthrown);
            r = GemFireCacheImpl.getInstance().getRegionByPath("/APP/CHILD", false);
            DDLPersistenceHDFSTest.assertTrue((boolean)r.getCustomEvictionAttributes().isEvictIncoming());
            DDLPersistenceHDFSTest.assertEquals((String)r.getHDFSStoreName(), (String)"MYHDFS");
            DDLPersistenceHDFSTest.assertTrue((r.getDiskStoreName() != null && !r.getDiskStoreName().equals("") ? 1 : 0) != 0);
            DDLPersistenceHDFSTest.assertEquals((int)((PartitionedRegion)r).getTotalNumberOfBuckets(), (int)11);
            ids = r.getAsyncEventQueueIds();
            DDLPersistenceHDFSTest.assertTrue((boolean)ids.contains("MYLISTENER"));
            TestUtil.shutDown();
            props = new Properties();
            props.put("mcast-port", "0");
            props.put("persist-dd", "false");
            props.put("hadoop.gemfirexd.loner.mode", "true");
            props.put("hadoop.gemfirexd.loner.namenodeurl", "");
            props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
            conn = TestUtil.getConnection(props);
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(0);
            st = conn.createStatement();
            st.execute("insert into Child (id2, sector_id2, subsector_id2) values (1, 1, 1)");
            try {
                st.execute("insert into Child (id2, sector_id2, subsector_id2) values (1, 2, 2)");
            }
            catch (SQLException expected) {
                if (expected.getSQLState().equals("23505")) break block6;
                throw expected;
            }
        }
        st.execute("insert into Child (id2, sector_id2, subsector_id2) values (2, 1, 2)");
        r = GemFireCacheImpl.getInstance().getRegionByPath("/APP/CHILD", false);
        DDLPersistenceHDFSTest.assertEquals((String)r.getHDFSStoreName(), (String)"MYHDFS");
        DDLPersistenceHDFSTest.assertEquals((Object)r.getEvictionAttributes().getAlgorithm(), (Object)EvictionAlgorithm.LRU_HEAP);
        DDLPersistenceHDFSTest.assertTrue((r.getDiskStoreName() == null || r.getDiskStoreName().equals("") ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertEquals((int)((PartitionedRegion)r).getTotalNumberOfBuckets(), (int)11);
        ids = r.getAsyncEventQueueIds();
        DDLPersistenceHDFSTest.assertFalse((boolean)ids.contains("MYLISTENER"));
        TestUtil.shutDown();
    }

    public void testAlterTableConstraintsDuringReplay() throws Exception {
        Set ids;
        LocalRegion r;
        Statement st;
        block8: {
            TestUtil.shutDown();
            Properties props = new Properties();
            int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            props.put("mcast-port", String.valueOf(mcastPort));
            props.put("server-groups", "SG1");
            Connection conn = TestUtil.getConnection(props);
            st = conn.createStatement();
            st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs'");
            st.execute("create table sector (sector_id int primary key, sector_info int)");
            st.execute("create table Child ( id2 int not null, sector_id2 int ) persistent hdfsstore (myhdfs) buckets 11 ");
            st.execute("alter table Child add constraint child_pk primary key (id2)");
            st.execute("alter table Child add constraint child_uk unique (sector_id2)");
            st.execute("alter table Child add column subsector_id2 int");
            st.execute("ALTER TABLE Child ADD CONSTRAINT FK_sector_id FOREIGN KEY (sector_id2) REFERENCES sector (sector_id) ON DELETE RESTRICT");
            st.execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.internal.hadoop.DDLPersistenceHDFSTest$TestAsyncListener' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
            st.execute("ALTER TABLE Child SET ASYNCEVENTLISTENER (myListener) ");
            boolean exceptionthrown = false;
            st.execute("insert into sector (sector_id, sector_info) values (1, 1)");
            st.execute("insert into Child (id2, sector_id2, subsector_id2) values (1, 1, 1)");
            try {
                st.execute("insert into Child (id2, sector_id2, subsector_id2) values (1, 2, 2)");
            }
            catch (Exception e) {
                exceptionthrown = true;
            }
            DDLPersistenceHDFSTest.assertTrue((boolean)exceptionthrown);
            exceptionthrown = false;
            try {
                st.execute("insert into Child (id2, sector_id2, subsector_id2) values (2, 1, 2)");
            }
            catch (Exception e) {
                exceptionthrown = true;
            }
            DDLPersistenceHDFSTest.assertTrue((boolean)exceptionthrown);
            exceptionthrown = false;
            try {
                st.execute("insert into Child (id2, sector_id2, subsector_id2) values (2, 3, 2)");
            }
            catch (Exception e) {
                exceptionthrown = true;
            }
            DDLPersistenceHDFSTest.assertTrue((boolean)exceptionthrown);
            r = GemFireCacheImpl.getInstance().getRegionByPath("/APP/CHILD", false);
            DDLPersistenceHDFSTest.assertEquals((String)r.getHDFSStoreName(), (String)"MYHDFS");
            DDLPersistenceHDFSTest.assertTrue((r.getDiskStoreName() != null && !r.getDiskStoreName().equals("") ? 1 : 0) != 0);
            DDLPersistenceHDFSTest.assertEquals((int)((PartitionedRegion)r).getTotalNumberOfBuckets(), (int)11);
            ids = r.getAsyncEventQueueIds();
            DDLPersistenceHDFSTest.assertTrue((boolean)ids.contains("MYLISTENER"));
            TestUtil.shutDown();
            props = new Properties();
            props.put("mcast-port", "0");
            props.put("persist-dd", "false");
            props.put("hadoop.gemfirexd.loner.mode", "true");
            props.put("hadoop.gemfirexd.loner.namenodeurl", "");
            props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
            conn = TestUtil.getConnection(props);
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(0);
            st = conn.createStatement();
            st.execute("insert into Child (id2, sector_id2, subsector_id2) values (1, 1, 1)");
            try {
                st.execute("insert into Child (id2, sector_id2, subsector_id2) values (1, 2, 2)");
            }
            catch (SQLException expected) {
                if (expected.getSQLState().equals("23505")) break block8;
                throw expected;
            }
        }
        st.execute("insert into Child (id2, sector_id2, subsector_id2) values (2, 1, 2)");
        st.execute("insert into Child (id2, sector_id2, subsector_id2) values (3, 3, 2)");
        r = GemFireCacheImpl.getInstance().getRegionByPath("/APP/CHILD", false);
        DDLPersistenceHDFSTest.assertEquals((String)r.getHDFSStoreName(), (String)"MYHDFS");
        DDLPersistenceHDFSTest.assertEquals((Object)r.getEvictionAttributes().getAlgorithm(), (Object)EvictionAlgorithm.LRU_HEAP);
        DDLPersistenceHDFSTest.assertTrue((r.getDiskStoreName() == null || r.getDiskStoreName().equals("") ? 1 : 0) != 0);
        DDLPersistenceHDFSTest.assertEquals((int)((PartitionedRegion)r).getTotalNumberOfBuckets(), (int)11);
        ids = r.getAsyncEventQueueIds();
        DDLPersistenceHDFSTest.assertFalse((boolean)ids.contains("MYLISTENER"));
    }

    private ArrayList<DDLConflatable> getDDLConflatables(HDFSStoreImpl store) throws IOException, ClassNotFoundException {
        DDLHoplogOrganizer organizer = store.getDDLHoplogOrganizer();
        DDLHoplogOrganizer.DDLHoplog ddlhoplog = organizer.getDDLStatementsForReplay();
        ArrayList ddls = ddlhoplog.getDDLStatements();
        ArrayList<DDLConflatable> ddlconflatables = new ArrayList<DDLConflatable>();
        for (byte[] ddl : ddls) {
            ddlconflatables.add((DDLConflatable)BlobHelper.deserializeBlob((byte[])ddl, (Version)ddlhoplog.getDDLVersion(), null));
        }
        return ddlconflatables;
    }

    public void testReadHoplogSplitRWTable() throws Exception {
        this.doReadHoplogSplitTest(false);
    }

    public void testReadHoplogSplitWOTable() throws Exception {
        this.doReadHoplogSplitTest(true);
    }

    public void doReadHoplogSplitTest(boolean writeOnly) throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' batchsize 5");
        String doWriteOnly = writeOnly ? " WRITEONLY" : "";
        st.execute("create table emp.mytab1 (col1 int primary key, col2 blob(131072)) persistent hdfsstore (myhdfs)" + doWriteOnly);
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        byte[] value = new byte[131072];
        int NUM_ENTRIES = 100;
        for (int i = 0; i < NUM_ENTRIES; ++i) {
            ps.setInt(1, i);
            ps.setBytes(2, value);
            ps.execute();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/EMP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        HDFSStoreImpl hdfsStore = GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS");
        FileSystem fs = hdfsStore.getFileSystem();
        Configuration conf2 = hdfsStore.getFileSystem().getConf();
        GFInputFormat gfInputFormat = new GFInputFormat();
        Job job = Job.getInstance((Configuration)conf2, (String)"test");
        conf2 = job.getConfiguration();
        conf2.set("mapreduce.input.gfinputformat.inputregion", "/EMP/MYTAB1");
        conf2.set("mapreduce.input.gfinputformat.homedir", "myhdfs");
        conf2.setBoolean("mapreduce.input.gfinputformat.checkpoint", false);
        List splits = gfInputFormat.getSplits((JobContext)job);
        TreeSet<Integer> seenEntries = new TreeSet<Integer>();
        for (InputSplit split : splits) {
            CombineFileSplit cSplit = (CombineFileSplit)split;
            Path[] paths = cSplit.getPaths();
            long[] starts = cSplit.getStartOffsets();
            long[] lengths = cSplit.getLengths();
            HDFSSplitIterator splitIterator = HDFSSplitIterator.newInstance((FileSystem)fs, (Path[])paths, (long[])starts, (long[])lengths, (long)0L, (long)0L);
            LanguageConnectionContext context = ((EmbedConnection)conn).getLanguageConnectionContext();
            context.setHDFSSplit((Object)splitIterator);
            st = conn.createStatement();
            ResultSet rs = st.executeQuery("select * from emp.mytab1");
            while (rs.next()) {
                if (!seenEntries.add(rs.getInt("col1"))) {
                    DDLPersistenceHDFSTest.fail("Did not expect to see a duplicate primary key. key=" + rs.getInt("col1") + ", seen=" + seenEntries);
                }
                EmbedResultSet embedSet = (EmbedResultSet)rs;
                embedSet.getCurrentRow();
                TableScanResultSet sourceSet = (TableScanResultSet)embedSet.getSourceResultSet();
                HDFSEventRowLocationRegionEntry rowLocation = (HDFSEventRowLocationRegionEntry)sourceSet.getRowLocation();
                PersistedEventImpl event = rowLocation.getEvent();
                DDLPersistenceHDFSTest.assertTrue((boolean)event.getOperation().isCreate());
            }
        }
        DDLPersistenceHDFSTest.assertEquals((String)("Did not find all of the entries. seen entries - " + seenEntries), (int)NUM_ENTRIES, (int)seenEntries.size());
        DDLPersistenceHDFSTest.assertTrue((String)"Should have at least used a couple splits", (splits.size() >= 1 ? 1 : 0) != 0);
    }

    public void testReadHoplogSplitNoLobs() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' batchsize 5");
        st.execute("create table emp.mytab1 (col1 int primary key, col2 int) persistent hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        int NUM_ENTRIES = 100;
        for (int i = 0; i < NUM_ENTRIES; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.execute();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/EMP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        HDFSStoreImpl hdfsStore = GemFireCacheImpl.getInstance().findHDFSStore("MYHDFS");
        FileSystem fs = hdfsStore.getFileSystem();
        Configuration conf2 = hdfsStore.getFileSystem().getConf();
        GFInputFormat gfInputFormat = new GFInputFormat();
        Job job = Job.getInstance((Configuration)conf2, (String)"test");
        conf2 = job.getConfiguration();
        conf2.set("mapreduce.input.gfinputformat.inputregion", "/EMP/MYTAB1");
        conf2.set("mapreduce.input.gfinputformat.homedir", "myhdfs");
        conf2.setBoolean("mapreduce.input.gfinputformat.checkpoint", false);
        List splits = gfInputFormat.getSplits((JobContext)job);
        TreeSet<Integer> seenEntries = new TreeSet<Integer>();
        for (InputSplit split : splits) {
            CombineFileSplit cSplit = (CombineFileSplit)split;
            Path[] paths = cSplit.getPaths();
            long[] starts = cSplit.getStartOffsets();
            long[] lengths = cSplit.getLengths();
            HDFSSplitIterator splitIterator = HDFSSplitIterator.newInstance((FileSystem)fs, (Path[])paths, (long[])starts, (long[])lengths, (long)0L, (long)0L);
            LanguageConnectionContext context = ((EmbedConnection)conn).getLanguageConnectionContext();
            context.setHDFSSplit((Object)splitIterator);
            st = conn.createStatement();
            ResultSet rs = st.executeQuery("select * from emp.mytab1");
            while (rs.next()) {
                if (!seenEntries.add(rs.getInt("col1"))) {
                    DDLPersistenceHDFSTest.fail("Did not expect to see a duplicate primary key. key=" + rs.getInt("col1") + ", seen=" + seenEntries);
                }
                EmbedResultSet embedSet = (EmbedResultSet)rs;
                embedSet.getCurrentRow();
                TableScanResultSet sourceSet = (TableScanResultSet)embedSet.getSourceResultSet();
                HDFSEventRowLocationRegionEntry rowLocation = (HDFSEventRowLocationRegionEntry)sourceSet.getRowLocation();
                PersistedEventImpl event = rowLocation.getEvent();
                DDLPersistenceHDFSTest.assertTrue((boolean)event.getOperation().isCreate());
            }
        }
        DDLPersistenceHDFSTest.assertEquals((String)("Did not find all of the entries. seen entries - " + seenEntries), (int)NUM_ENTRIES, (int)seenEntries.size());
    }

    public void testForeignKeyConstraint() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE HDFSSTORE airlines NAMENODE '' HOMEDIR 'gemfirexd' BATCHTIMEINTERVAL 1000 milliseconds");
        st.execute("CREATE TABLE FLIGHTS   ( FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , ORIG_AIRPORT CHAR(3), DEPART_TIME TIME, DEST_AIRPORT CHAR(3), ARRIVE_TIME TIME, MEAL CHAR(1), FLYING_TIME DOUBLE PRECISION, MILES INTEGER, AIRCRAFT VARCHAR(6), CONSTRAINT FLIGHTS_PK PRIMARY KEY ( FLIGHT_ID, SEGMENT_NUMBER), CONSTRAINT MEAL_CONSTRAINT CHECK (meal IN ('B', 'L', 'D', 'S')))");
        st.execute("CREATE TABLE FLIGHTAVAILABILITY ( FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , FLIGHT_DATE DATE NOT NULL , ECONOMY_SEATS_TAKEN INTEGER DEFAULT 0, BUSINESS_SEATS_TAKEN INTEGER DEFAULT 0, FIRSTCLASS_SEATS_TAKEN INTEGER DEFAULT 0, CONSTRAINT FLIGHTAVAIL_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER,FLIGHT_DATE),       CONSTRAINT FLIGHTS_FK2 Foreign Key ( FLIGHT_ID, SEGMENT_NUMBER)         REFERENCES FLIGHTS (FLIGHT_ID, SEGMENT_NUMBER) ) PARTITION BY COLUMN (FLIGHT_ID) REDUNDANCY 1 RECOVERYDELAY 1000 BUCKETS 5  HDFSSTORE (airlines)");
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./gemfirexd");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        try {
            conn = TestUtil.getConnection(props);
            st = conn.createStatement();
        }
        catch (Exception e) {
            DDLPersistenceHDFSTest.fail("Exception thrown while replaying DDLs", e);
        }
        TestUtil.shutDown();
    }

    public void testCannotConnect() throws Exception {
        block3: {
            Properties props = new Properties();
            int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            props.put("mcast-port", String.valueOf(mcastPort));
            Connection conn = TestUtil.getConnection(props);
            Statement st = conn.createStatement();
            st.execute("create schema emp");
            st.execute("set schema emp");
            int port = AvailablePortHelper.getRandomAvailableTCPPort();
            DDLPersistenceHDFSTest.addExpectedException(ConnectException.class);
            try {
                st.execute("create hdfsstore myhdfs namenode 'hdfs://localhost:" + port + "' homedir '" + this.HDFS_DIR + "'");
                DDLPersistenceHDFSTest.fail("expected exception in connecting to unavailable HDFS store");
            }
            catch (SQLException e) {
                if (!"X0Z30".equals(e.getSQLState())) {
                    throw e;
                }
                if (HDFSIOException.class.equals(e.getCause().getClass())) break block3;
                throw e;
            }
        }
        DDLPersistenceHDFSTest.removeExpectedException(ConnectException.class);
    }

    public void testInsertWithHDFSDown() throws Exception {
        int clusterPort = AvailablePortHelper.getRandomAvailableTCPPort();
        System.setProperty("test.build.data", this.HDFS_DIR);
        HdfsConfiguration hconf = new HdfsConfiguration();
        hconf.setInt("dfs.replication", 1);
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder((Configuration)hconf);
        builder.numDataNodes(2);
        builder.nameNodePort(clusterPort);
        MiniDFSCluster cluster = builder.build();
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        DDLPersistenceHDFSTest.addExpectedException(ConnectException.class);
        st.execute("create hdfsstore myhdfs namenode 'hdfs://localhost:" + clusterPort + "' homedir '" + this.HDFS_DIR + "' BATCHTIMEINTERVAL 1 milliseconds");
        GemFireCacheImpl.getInstance().getLogger().info("<ExpectedException action=add>" + this.expectedExceptions + "</ExpectedException>");
        st.execute("create table mytab (col1 int primary key) hdfsstore (myhdfs) eviction by criteria (col1 < 1000) evict incoming");
        st.execute("insert into mytab values (5)");
        Thread.sleep(5000L);
        st.execute("select * from mytab  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1=5");
        cluster.shutdownNameNodes();
        cluster.restartNameNode(new String[0]);
        cluster.restartDataNodes();
        Thread.sleep(10000L);
        st.execute("insert into mytab values (118)");
        st.execute("select * from mytab  -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        GemFireCacheImpl.getInstance().getLogger().info("<ExpectedException action=remove>" + this.expectedExceptions + "</ExpectedException>");
        st.execute("drop table mytab");
        st.execute("drop hdfsstore myhdfs");
        cluster.shutdownDataNodes();
        cluster.shutdownNameNodes();
        TestUtil.shutDown();
    }

    public void testBug50574() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute(" create hdfsstore sensorStore  NameNode 'localhost'  HomeDir './sensorStore' BatchTimeInterval 10 milliseconds WriteOnlyFileRolloverInterval 1 seconds");
        st.execute(" create table raw_sensor(   id bigint primary key,   timestamp bigint, house_id integer   ) partition by column (house_id) persistent hdfsstore (sensorStore) writeonly");
        st.execute("insert into raw_sensor (   id,   timestamp , house_id ) values (1,1,1)");
        st.execute("insert into raw_sensor (   id,   timestamp , house_id ) values (11,11,11)");
        Thread.sleep(2000L);
        TestUtil.shutDown();
        this.deleteOplogs();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "localhost");
        props.put("hadoop.gemfirexd.loner.homedirs", "./sensorStore");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        this.noOplogsCreatedCheck();
        TestUtil.shutDown();
    }

    public void testEvictionCriteriaFunction() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create diskstore hdfsStoreDisk 'hdfsStoreData' autocompact false");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' DISKSTORENAME hdfsStoreDisk");
        st.execute("create function testsubstring(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        st.execute(" create table raw_sensor ( id bigint, timestamp bigint, age integer, sensortype varchar(10))eviction by criteria (testsubstring(sensortype, 0, 3) = 'DEL') eviction frequency 600 seconds hdfsstore (myhdfs) writeonly;");
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String gmtStrDate = sdf.format(Calendar.getInstance().getTime());
        Date date = new Date(gmtStrDate);
        st.execute("ALTER TABLE raw_sensor SET EVICTION FREQUENCY 5 SECONDS START T '" + new Time(date.getTime()) + "'");
        st.execute("insert into raw_sensor (id, timestamp, age, sensortype) values (1, 100, 7, 'DEL_RECORD')");
        st.execute("insert into raw_sensor (id, timestamp, age, sensortype) values (1, 200, 3, 'ADD_RECORD')");
        LocalRegion r = GemFireCacheImpl.getInstance().getRegionByPath("/APP/RAW_SENSOR", false);
        DDLPersistenceHDFSTest.assertNotNull((Object)r.getCustomEvictionAttributes());
        TestUtil.shutDown();
        props = new Properties();
        props.put("mcast-port", "0");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("hadoop.gemfirexd.loner.namenodeurl", "");
        props.put("hadoop.gemfirexd.loner.homedirs", "./myhdfs");
        Configuration conf = new Configuration();
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        r = GemFireCacheImpl.getInstance().getRegionByPath("/APP/RAW_SENSOR", false);
        DDLPersistenceHDFSTest.assertNull((Object)r.getCustomEvictionAttributes());
        TestUtil.shutDown();
    }

    public void deleteOplogs() {
        String currDir = System.getProperty("user.dir");
        File cdir = new File(currDir);
        String[] files = cdir.list();
        if (files != null) {
            for (String file : files) {
                if (!file.startsWith("DRLK") && !file.startsWith("BACKUP") && !file.startsWith("OVERFLOW")) continue;
                File f = new File(file);
                f.delete();
            }
        }
    }

    public void noOplogsCreatedCheck() {
        String currDir = System.getProperty("user.dir");
        File cdir = new File(currDir);
        String[] files = cdir.list();
        if (files != null) {
            for (String file : files) {
                if (!file.startsWith("DRLK") && !file.startsWith("BACKUP") && !file.startsWith("OVERFLOW")) continue;
                DDLPersistenceHDFSTest.assertTrue((String)("GemFire created an oplog on local disk. Oplog name: " + file), (boolean)false);
            }
        }
    }

    public static class TestAsyncListener
    implements AsyncEventListener {
        public boolean processEvents(List<Event> events) {
            return true;
        }

        public void close() {
        }

        public void init(String initParamStr) {
        }

        public void start() {
        }
    }
}

