/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.catalog.DefaultInfo;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.DefaultInfoImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RowFormatterTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(RowFormatterTest.class));
    }

    public RowFormatterTest(String name) {
        super(name);
    }

    public void testReadAndWriteInts() {
        byte[] bytes = new byte[256];
        int numToTest = 1024;
        Random rand = new Random();
        boolean testedNeg = false;
        for (int i = 0; i < numToTest || !testedNeg; ++i) {
            int nextInt = rand.nextInt();
            if (nextInt < 0) {
                testedNeg = true;
            }
            RowFormatterTest.assertEquals((int)4, (int)RowFormatter.writeInt((byte[])bytes, (int)nextInt, (int)42));
            RowFormatterTest.assertEquals((int)nextInt, (int)RowFormatter.readInt((byte[])bytes, (int)42));
        }
    }

    public void testReadAndWriteCompactInts() throws IOException {
        int[] intsToTest;
        byte[] bytes = new byte[256];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bos);
        int numToTest = 1024;
        TIntArrayList allInts = new TIntArrayList(1024);
        Random rand = new Random();
        boolean testedNeg = false;
        for (int i = 0; i < 1024 || !testedNeg; ++i) {
            int nextInt = rand.nextInt();
            if (nextInt < 0) {
                testedNeg = true;
            }
            RowFormatterTest.assertTrue((RowFormatter.writeCompactInt((byte[])bytes, (int)nextInt, (int)42) < 47 ? 1 : 0) != 0);
            InternalDataSerializer.writeSignedVL((long)nextInt, (DataOutput)dout);
            RowFormatterTest.assertTrue((RowFormatter.getCompactIntNumBytes((int)nextInt) <= 5 ? 1 : 0) != 0);
            allInts.add(nextInt);
            RowFormatterTest.assertEquals((int)nextInt, (int)RowFormatter.readCompactInt((byte[])bytes, (int)42));
        }
        for (int intToTest : intsToTest = new int[]{64, 63, 127, 128, 120, -192, -128, -64, -237}) {
            RowFormatterTest.assertTrue((RowFormatter.writeCompactInt((byte[])bytes, (int)intToTest, (int)42) < 44 ? 1 : 0) != 0);
            InternalDataSerializer.writeSignedVL((long)intToTest, (DataOutput)dout);
            RowFormatterTest.assertTrue((RowFormatter.getCompactIntNumBytes((int)intToTest) <= 2 ? 1 : 0) != 0);
            allInts.add(intToTest);
            RowFormatterTest.assertEquals((int)intToTest, (int)RowFormatter.readCompactInt((byte[])bytes, (int)42));
        }
        for (int intToTest : intsToTest = new int[]{28671, Short.MAX_VALUE, 36863, 32768, 16384, 40960, 45056, 49152, 0x1FFFFF, 0x3FFFFF, 0x5FFFFF, 0x7FFFFF, 0x8FFFFF, 0x800000, 0x400000, 0xA00000, 0xB00000, 0xC00000, 0xFFFFFFF, 0x1FFFFFFF, 0x5FFFFFFF, Integer.MAX_VALUE, -1879048193, -1, 0x4000000, 0x8000000, 0x40000000, Integer.MIN_VALUE, -1610612736, -1342177280, -1073741824, -268435456, Short.MIN_VALUE, -49152, -57344, -4096, -512, -1048577, -2097152, -15728640, -17760256, -8388608, -10485760, -251658240, -33554432, -218103808, -2130706432, -1426063360}) {
            RowFormatterTest.assertTrue((RowFormatter.writeCompactInt((byte[])bytes, (int)intToTest, (int)42) < 47 ? 1 : 0) != 0);
            InternalDataSerializer.writeSignedVL((long)intToTest, (DataOutput)dout);
            RowFormatterTest.assertTrue((RowFormatter.getCompactIntNumBytes((int)intToTest) <= 5 ? 1 : 0) != 0);
            allInts.add(intToTest);
            RowFormatterTest.assertEquals((int)intToTest, (int)RowFormatter.readCompactInt((byte[])bytes, (int)42));
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
        for (int i = 0; i < allInts.size(); ++i) {
            RowFormatterTest.assertEquals((int)allInts.get(i), (int)((int)InternalDataSerializer.readSignedVL((DataInput)in)));
        }
    }

    public void testReadAndWriteLongs() throws IOException {
        byte[] bytes = new byte[256];
        int numToTest = 1024;
        Random rand = new Random();
        boolean testedNeg = false;
        for (int i = 0; i < numToTest || !testedNeg; ++i) {
            long nextLong = rand.nextLong();
            if (nextLong < 0L) {
                testedNeg = true;
            }
            RowFormatterTest.assertEquals((int)8, (int)RowFormatter.writeLong((byte[])bytes, (long)nextLong, (int)42));
            RowFormatterTest.assertEquals((long)nextLong, (long)RowFormatter.readLong((byte[])bytes, (int)42));
        }
    }

    public void testReadAndWriteSmallInts() {
        byte[] bytes = new byte[256];
        int numToTest = 1024;
        Random rand = new Random();
        boolean testedNeg = false;
        for (int i = 0; i < numToTest || !testedNeg; ++i) {
            short nextShort = (short)rand.nextInt();
            if (nextShort < 0) {
                testedNeg = true;
            }
            RowFormatterTest.assertEquals((int)2, (int)new SQLSmallint(nextShort).writeBytes(bytes, 42, null));
            SQLSmallint newSmallInt = new SQLSmallint();
            RowFormatterTest.assertEquals((int)2, (int)newSmallInt.readBytes(bytes, 42, 2));
            RowFormatterTest.assertEquals((int)nextShort, (int)((Integer)newSmallInt.getObject()));
        }
    }

    public void testBug49310() throws Exception {
        Connection conn = RowFormatterTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))  partition by list (tid) (VALUES (14, 1, 2, 10, 4, 5), VALUES (6, 7, 16, 9, 3, 11), VALUES (12, 13, 0, 15, 8, 17))");
        stmt.execute("create index idx_1 on trade.customers(cust_name)");
        byte[] bytes1 = new byte[]{2, 0, 0, 65, 8, 111, 32, 99, 7, -42, 6, 25, 97, 100, 100, 114, 101, 115, 115, 32, 105, 115, 32, 111, 32, 99, 0, 0, 0, 17, 5, 0, 8, 0, 12, 0, 26, 0};
        byte[] bytes2 = new byte[]{2, 0, 0, 59, -68, 111, 7, -48, 4, 3, 121, 97, 116, 101, 109, 121, 113, 97, 106, 106, 102, 122, 32, 109, 107, 114, 122, 105, 107, 121, 98, 97, 32, 108, 112, 98, 121, 101, 32, 32, 105, 110, 115, 32, 120, 108, 102, 108, 116, 101, 120, 118, 115, 101, 118, 98, 115, 106, 114, 121, 97, 119, 106, 0, 0, 0, 12, 5, 0, 6, 0, 10, 0, 63, 0};
        RowFormatter rf = ((GemFireContainer)Misc.getRegion((String)"/TRADE/CUSTOMERS", (boolean)true, (boolean)false).getUserAttribute()).getCurrentRowFormatter();
        DataValueDescriptor[] dvds1 = new DataValueDescriptor[rf.getNumColumns()];
        rf.getColumns(bytes1, dvds1, null);
        RowFormatterTest.assertEquals((String)"o c", (String)dvds1[1].toString());
        DataValueDescriptor[] dvds2 = new DataValueDescriptor[rf.getNumColumns()];
        rf.getColumns(bytes2, dvds2, null);
        RowFormatterTest.assertEquals((String)"o", (String)dvds2[1].toString());
        RowFormatterTest.assertTrue((dvds1[1].compare(dvds2[1]) > 0 ? 1 : 0) != 0);
        RowFormatterTest.assertTrue((dvds2[1].compare(dvds1[1]) < 0 ? 1 : 0) != 0);
        long off1 = rf.getOffsetAndWidth(2, bytes1);
        int columnWidth1 = (int)(off1 & 0xFFFFFFFFFFFFFFFFL);
        int offset1 = (int)(off1 >>> 32);
        long off2 = rf.getOffsetAndWidth(2, bytes2);
        int columnWidth2 = (int)(off2 & 0xFFFFFFFFFFFFFFFFL);
        int offset2 = (int)(off2 >>> 32);
        RowFormatterTest.assertTrue((SQLChar.compareString((byte[])bytes1, (int)offset1, (int)columnWidth1, (byte[])bytes2, (int)offset2, (int)columnWidth2) > 0 ? 1 : 0) != 0);
        RowFormatterTest.assertTrue((SQLChar.compareString((byte[])bytes2, (int)offset2, (int)columnWidth2, (byte[])bytes1, (int)offset1, (int)columnWidth1) < 0 ? 1 : 0) != 0);
    }

    public void testGenerateRowWithNotNullableIntegers() throws StandardException, IOException {
        int hiValue = 10;
        int loValue = -10;
        int numFields = (hiValue - loValue) / 2 + 1;
        int numBytes = numFields * 4 + 1;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        InternalDataSerializer.writeSignedVL((long)1L, (DataOutput)dos);
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        int index = 0;
        int v = -10;
        while (v <= 10) {
            dvds[index] = new SQLInteger(v);
            dos.writeInt(v);
            v += 2;
            ++index;
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER_NOT_NULL, null, null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        byte[] expectedBytes = bos.toByteArray();
        RowFormatterTest.assertNotNull((Object)bytes);
        RowFormatterTest.assertEquals((int)numBytes, (int)bytes.length);
        RowFormatterTest.assertTrue((boolean)Arrays.equals(expectedBytes, bytes));
    }

    public void testGetNotNullableIntegers() throws StandardException {
        int hiValue = 10;
        int loValue = -10;
        int increment = 2;
        int numFields = (hiValue - loValue) / increment + 1;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        int index = 0;
        int v = -10;
        while (v <= 10) {
            dvds[index] = new SQLInteger(v);
            v += 2;
            ++index;
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER_NOT_NULL, (DataValueDescriptor)new SQLInteger(0), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        index = 0;
        int v2 = -10;
        while (v2 <= 10) {
            RowFormatterTest.assertEquals((String)("for index=" + index), (Object)v2, (Object)outDvds[index].getObject());
            v2 += 2;
            ++index;
        }
    }

    public void testGetNullableIntegersNoNulls() throws StandardException {
        int hiValue = 10;
        int loValue = -10;
        int increment = 2;
        int numFields = (hiValue - loValue) / increment + 1;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        int index = 0;
        int v = -10;
        while (v <= 10) {
            dvds[index] = new SQLInteger(v);
            v += 2;
            ++index;
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        index = 0;
        int v2 = -10;
        while (v2 <= 10) {
            RowFormatterTest.assertEquals((String)("for index=" + index), (Object)v2, (Object)outDvds[index].getObject());
            v2 += 2;
            ++index;
        }
    }

    public void testFixedWidthCharsWithPadding() throws StandardException {
        int numFields = 10;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        String[] strings = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            char[] cha = new char[i];
            Arrays.fill(cha, (char)(65 + i));
            strings[i] = new String(cha);
            dvds[i] = new SQLChar(new String(strings[i]));
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        int expectedBytesLength = 1;
        for (int p = 1; p <= dvds.length; ++p) {
            DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)1, (boolean)false, (int)(p + 4));
            expectedBytesLength += p - 1;
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLChar(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        int numOffsetBytes = rf.getNumOffsetBytes();
        byte[] bytes = rf.generateBytes(dvds);
        RowFormatterTest.assertEquals((int)(expectedBytesLength += numOffsetBytes * dvds.length), (int)bytes.length);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        char[] paddingChars = new char[5];
        Arrays.fill(paddingChars, ' ');
        for (int i = 0; i < numFields; ++i) {
            String expectedString = strings[i];
            RowFormatterTest.assertEquals((String)("for index=" + i), (Object)expectedString, (Object)outDvds[i].getObject());
        }
    }

    public void testNullableCharsWithPadding() throws StandardException {
        int numFields = 10;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        String[] strings = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            char[] cha = new char[i];
            Arrays.fill(cha, (char)(65 + i));
            strings[i] = new String(cha);
            dvds[i] = new SQLChar(new String(strings[i]));
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        int expectedBytesLength = 1;
        for (int p = 1; p <= dvds.length; ++p) {
            DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)1, (boolean)true, (int)(p + 4));
            expectedBytesLength += p - 1;
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLChar(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        int numOffsetBytes = rf.getNumOffsetBytes();
        byte[] bytes = rf.generateBytes(dvds);
        RowFormatterTest.assertEquals((int)(expectedBytesLength += numOffsetBytes * dvds.length), (int)bytes.length);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        char[] paddingChars = new char[5];
        Arrays.fill(paddingChars, ' ');
        for (int i = 0; i < numFields; ++i) {
            String expectedString = strings[i];
            RowFormatterTest.assertEquals((String)("for index=" + i), (Object)expectedString, (Object)outDvds[i].getObject());
        }
    }

    public void testGetVarchars() throws StandardException {
        int numFields = 10;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        String[] strings = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            char[] cha = new char[i];
            Arrays.fill(cha, (char)(65 + i));
            strings[i] = new String(cha);
            dvds[i] = new SQLVarchar(new String(strings[i]));
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)12), (DataValueDescriptor)new SQLVarchar(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        for (int i = 0; i < numFields; ++i) {
            RowFormatterTest.assertEquals((String)("for index=" + i), (Object)strings[i], (Object)outDvds[i].getObject());
        }
    }

    public void testGetNullableIntegersWithNulls() throws StandardException {
        List<Integer> nullPositions = Arrays.asList(1, 7, 13);
        int hiValue = 10;
        int loValue = -10;
        int increment = 2;
        int numFields = (hiValue - loValue) / increment + nullPositions.size() + 1;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        int v = -10;
        for (int index = 0; index < numFields; ++index) {
            if (nullPositions.contains(index + 1)) {
                dvds[index] = new SQLInteger();
                continue;
            }
            dvds[index] = new SQLInteger(v);
            v += 2;
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        v = -10;
        for (int index = 0; index < numFields; ++index) {
            if (nullPositions.contains(index + 1)) {
                RowFormatterTest.assertEquals((String)("for index=" + index), null, (Object)outDvds[index].getObject());
                continue;
            }
            RowFormatterTest.assertEquals((String)("for index=" + index), (Object)v, (Object)outDvds[index].getObject());
            v += 2;
        }
    }

    public void testBug41168() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLLongint();
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLLongint(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        NullHolder wasNull = new NullHolder();
        RowFormatterTest.assertEquals((long)0L, (long)rf.getAsLong(1, bytes, (ResultWasNull)wasNull));
        RowFormatterTest.assertTrue((boolean)wasNull.wasNull);
    }

    public void testGetAsDoubleForNullableDoubleWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLDouble();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)8, (boolean)true);
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLDouble(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        NullHolder wasNull = new NullHolder();
        RowFormatterTest.assertEquals((Object)0.0, (Object)rf.getAsDouble(1, bytes, (ResultWasNull)wasNull));
        RowFormatterTest.assertTrue((boolean)wasNull.wasNull);
    }

    public void testGetAsStringForNullableStringWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLVarchar();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)1, (boolean)true);
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLChar(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        NullHolder wasNull = new NullHolder();
        RowFormatterTest.assertNull((Object)rf.getAsString(1, bytes, (ResultWasNull)wasNull));
        RowFormatterTest.assertTrue((boolean)wasNull.wasNull);
    }

    public void testGetAsByteForNullableByteWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLTinyint();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)-6, (boolean)true);
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLTinyint(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        NullHolder wasNull = new NullHolder();
        RowFormatterTest.assertEquals((int)0, (int)rf.getAsByte(1, bytes, (ResultWasNull)wasNull));
        RowFormatterTest.assertTrue((boolean)wasNull.wasNull);
    }

    public void testGetAsShortForNullableShortWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLSmallint();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.SMALLINT;
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLSmallint(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        NullHolder wasNull = new NullHolder();
        RowFormatterTest.assertEquals((int)0, (int)rf.getAsShort(1, bytes, (ResultWasNull)wasNull));
        RowFormatterTest.assertTrue((boolean)wasNull.wasNull);
    }

    public void testGetAsIntForNullableIntWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLInteger();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.INTEGER;
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLInteger(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        NullHolder wasNull = new NullHolder();
        RowFormatterTest.assertEquals((int)0, (int)rf.getAsInt(1, bytes, (ResultWasNull)wasNull));
        RowFormatterTest.assertTrue((boolean)wasNull.wasNull);
    }

    public void testGetAsFloatForNullableFloatWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLReal();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)6, (boolean)true);
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLReal(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        NullHolder wasNull = new NullHolder();
        RowFormatterTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(rf.getAsFloat(1, bytes, (ResultWasNull)wasNull)));
        RowFormatterTest.assertTrue((boolean)wasNull.wasNull);
    }

    public void testGetAsDateForNullableDateWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLDate();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)91, (boolean)true);
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLDate(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        RowFormatterTest.assertNull((Object)rf.getAsDate(1, bytes, Calendar.getInstance(), null));
    }

    public void testGetAsTimeStampForNullableTimeStampWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLTimestamp();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)93, (boolean)true);
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLTimestamp(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        RowFormatterTest.assertNull((Object)rf.getAsTimestamp(1, bytes, Calendar.getInstance(), null));
    }

    public void testGetAsTimeForNullableTimeWithNull() throws StandardException {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        for (int index = 0; index < 1; ++index) {
            dvds[index] = new SQLTime();
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)92, (boolean)true);
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, dtd, (DataValueDescriptor)new SQLTime(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        RowFormatterTest.assertNull((Object)rf.getAsTime(1, bytes, Calendar.getInstance(), null));
    }

    public void testSetColumnsNotNullableIntegers() throws StandardException {
        int hiValue = 10;
        int loValue = -10;
        int increment = 2;
        int numFields = (hiValue - loValue) / increment + 1;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        int index = 0;
        int v = -10;
        while (v <= 10) {
            dvds[index] = new SQLInteger(v);
            v += 2;
            ++index;
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER_NOT_NULL, (DataValueDescriptor)new SQLInteger(0), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        FormatableBitSet bitSet = new FormatableBitSet(cdl.size());
        bitSet.set(0);
        bitSet.set(5);
        DataValueDescriptor[] newDvds = new DataValueDescriptor[cdl.size()];
        newDvds[0] = new SQLInteger(42);
        newDvds[5] = new SQLInteger(-42);
        bytes = rf.setColumns(bitSet, newDvds, bytes, rf);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        RowFormatterTest.assertEquals((String)"for index=0", (Object)42, (Object)outDvds[0].getObject());
        index = 1;
        int v2 = -8;
        while (v2 <= 10) {
            if (index == 5) {
                RowFormatterTest.assertEquals((String)"for index=5", (Object)-42, (Object)outDvds[5].getObject());
            } else {
                RowFormatterTest.assertEquals((String)("for index=" + index), (Object)v2, (Object)outDvds[index].getObject());
            }
            v2 += 2;
            ++index;
        }
    }

    public void testGetMixedTypes() throws StandardException {
        int numFields = 2;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        dvds[0] = new SQLInteger(-42);
        dvds[1] = new SQLVarchar("Carpe Diem");
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        ColumnDescriptor cd = new ColumnDescriptor("c1", 1, DataTypeDescriptor.INTEGER_NOT_NULL, (DataValueDescriptor)new SQLInteger(0), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
        cdl.add((Object)cd);
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)12, (boolean)true, (int)255);
        cd = new ColumnDescriptor("c2", 2, dtd, (DataValueDescriptor)new SQLVarchar(""), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
        cdl.add((Object)cd);
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        RowFormatterTest.assertEquals((int)2, (int)outDvds.length);
        RowFormatterTest.assertEquals((Object)-42, (Object)outDvds[0].getObject());
        RowFormatterTest.assertEquals((Object)"Carpe Diem", (Object)outDvds[1].getObject());
    }

    public void test1BytesOffset() throws Exception {
        List<Integer> nullPositions = Arrays.asList(1, 7, 13);
        int hiValue = 10;
        int loValue = -10;
        int increment = 2;
        int numFields = (hiValue - loValue) / increment + nullPositions.size() + 1;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        int v = -10;
        for (int index = 0; index < numFields; ++index) {
            if (nullPositions.contains(index + 1)) {
                dvds[index] = new SQLInteger();
                continue;
            }
            dvds[index] = new SQLInteger(v);
            v += 2;
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        RowFormatterTest.assertEquals((String)"Should use a 1 byte offset ", (int)1, (int)rf.getNumOffsetBytes());
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        v = -10;
        for (int index = 0; index < numFields; ++index) {
            if (nullPositions.contains(index + 1)) {
                RowFormatterTest.assertEquals((String)("for index=" + index), null, (Object)outDvds[index].getObject());
                continue;
            }
            RowFormatterTest.assertEquals((String)("for index=" + index), (Object)v, (Object)outDvds[index].getObject());
            v += 2;
        }
    }

    public void test2BytesOffset() throws Exception {
        List<Integer> nullPositions = Arrays.asList(1, 7, 13);
        int hiValue = 100;
        int loValue = -100;
        int increment = 2;
        int numFields = (hiValue - loValue) / increment + nullPositions.size() + 1;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        int v = -100;
        for (int index = 0; index < numFields; ++index) {
            if (nullPositions.contains(index + 1)) {
                dvds[index] = new SQLInteger();
                continue;
            }
            dvds[index] = new SQLInteger(v);
            v += 2;
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        RowFormatterTest.assertEquals((String)"Should use a 2 byte offset ", (int)2, (int)rf.getNumOffsetBytes());
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        v = -100;
        for (int index = 0; index < numFields; ++index) {
            if (nullPositions.contains(index + 1)) {
                RowFormatterTest.assertEquals((String)("for index=" + index), null, (Object)outDvds[index].getObject());
                continue;
            }
            RowFormatterTest.assertEquals((String)("for index=" + index), (Object)v, (Object)outDvds[index].getObject());
            v += 2;
        }
    }

    public void test3BytesOffsetStartingValue() throws Exception {
        int numFields = 20;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        String value = "XXXX";
        for (int index = 0; index < numFields; ++index) {
            dvds[index] = index == 0 ? new SQLVarchar(value) : (index == numFields - 1 ? new SQLInteger(10) : new SQLInteger());
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = null;
            if (p == 1) {
                cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)12), (DataValueDescriptor)new SQLVarchar(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
                cdl.add((Object)cd);
                continue;
            }
            if (p == dvds.length) {
                cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER_NOT_NULL, (DataValueDescriptor)new SQLInteger(10), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
                cdl.add((Object)cd);
                continue;
            }
            cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(10), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        RowFormatterTest.assertEquals((String)"Should use a 3 byte offset ", (int)3, (int)rf.getNumOffsetBytes());
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        assert (dvds.length == outDvds.length);
    }

    public void test4BytesOffsetEndValue() throws Exception {
        ColumnDescriptor cd;
        int p;
        int index;
        int numFields = 5018;
        DataValueDescriptor[] dvds = new DataValueDescriptor[numFields];
        for (index = 0; index < 256; ++index) {
            dvds[index] = new SQLVarchar("XXXX");
        }
        for (index = 256; index < 5017; ++index) {
            dvds[index] = new SQLInteger();
        }
        for (index = 5017; index < 5018; ++index) {
            dvds[index] = new SQLChar("XXXX");
        }
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (p = 1; p <= 256; ++p) {
            cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)12), (DataValueDescriptor)new SQLVarchar(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        for (p = 257; p <= 5017; ++p) {
            cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        for (p = 5018; p <= 5018; ++p) {
            cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)1, (boolean)false, (int)1), (DataValueDescriptor)new SQLChar(), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        RowFormatterTest.assertEquals((String)"Should use a 4 byte offset ", (int)4, (int)rf.getNumOffsetBytes());
        byte[] bytes = rf.generateBytes(dvds);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        assert (dvds.length == outDvds.length);
    }

    public void testSingleDVDDefaultValue1ByteOffset() throws Exception {
        DataValueDescriptor[] dvds = new DataValueDescriptor[1];
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(1), null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        RowFormatterTest.assertEquals((String)"Should use a 1 byte offset ", (int)dvds.length, (int)rf.getNumOffsetBytes());
        byte[] bytes = rf.generateBytes(dvds);
        RowFormatterTest.assertEquals((int)2, (int)bytes.length);
    }

    public void testMultiDVDDefaultValue1ByteOffset() throws Exception {
        DataValueDescriptor[] dvds = new DataValueDescriptor[25];
        int defaultValue = -11;
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(-11), (DefaultInfo)new DefaultInfoImpl(false, "defalueValue-11", (DataValueDescriptor)new SQLInteger(-11)), (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        RowFormatterTest.assertEquals((String)"Should use a 1 byte offset ", (int)1, (int)rf.getNumOffsetBytes());
        for (int i = 0; i < dvds.length; ++i) {
            dvds[i] = new SQLInteger(-11);
        }
        byte[] bytes = rf.generateBytes(dvds);
        RowFormatterTest.assertEquals((int)(dvds.length + 1), (int)bytes.length);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        for (int index = 0; index < dvds.length; ++index) {
            RowFormatterTest.assertEquals((String)("for index=" + index), (int)-11, (int)outDvds[index].getInt());
        }
    }

    public void testMultiDVDDefaultValue2ByteOffset() throws Exception {
        DataValueDescriptor[] dvds = new DataValueDescriptor[100];
        int defaultValue = -11;
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int p = 1; p <= dvds.length; ++p) {
            ColumnDescriptor cd = new ColumnDescriptor("c" + p, p, DataTypeDescriptor.INTEGER, (DataValueDescriptor)new SQLInteger(-11), (DefaultInfo)new DefaultInfoImpl(false, "defalueValue-11", (DataValueDescriptor)new SQLInteger(-11)), (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            cdl.add((Object)cd);
        }
        RowFormatter rf = new RowFormatter(cdl, null, null, 1, null);
        RowFormatterTest.assertEquals((String)"Should use a 1 byte offset ", (int)2, (int)rf.getNumOffsetBytes());
        for (int i = 0; i < dvds.length; ++i) {
            dvds[i] = new SQLInteger(-11);
        }
        byte[] bytes = rf.generateBytes(dvds);
        RowFormatterTest.assertEquals((int)(dvds.length * 2 + 1), (int)bytes.length);
        DataValueDescriptor[] outDvds = rf.getAllColumns(bytes);
        for (int index = 0; index < dvds.length; ++index) {
            RowFormatterTest.assertEquals((String)("for index=" + index), (int)-11, (int)outDvds[index].getInt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionKeyHashEquals() throws Exception {
        int id;
        Connection conn = RowFormatterTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table test.table1 (c1 int, c2 varchar(100), c3 char(20) not null, c4 int not null, c5 decimal(30,20), c6 varchar(20) default 'testing', c7 real, primary key (c2, c4))");
        PreparedStatement pstmt = conn.prepareStatement("insert into test.table1 (c2, c3, c1, c5, c4) values (?, ?, ?, ?, ?)");
        for (int id2 = 1; id2 <= 20; ++id2) {
            pstmt.setString(1, "id" + id2);
            pstmt.setString(2, "fixed" + id2);
            pstmt.setInt(3, id2 + 1);
            pstmt.setBigDecimal(4, new BigDecimal("0.1" + id2));
            pstmt.setInt(5, id2);
            pstmt.execute();
        }
        CompactCompositeRegionKey[] keys1 = new CompactCompositeRegionKey[20];
        CompactCompositeRegionKey[] keys2 = new CompactCompositeRegionKey[20];
        CompactCompositeRegionKey[] keys3 = new CompactCompositeRegionKey[20];
        CompactCompositeRegionKey[] keys4 = new CompactCompositeRegionKey[20];
        LocalRegion reg = (LocalRegion)Misc.getRegionForTable((String)"TEST.TABLE1", (boolean)true);
        ExtraTableInfo tabInfo = ((GemFireContainer)reg.getUserAttribute()).getExtraTableInfo();
        RowFormatter rf = tabInfo.getRowFormatter();
        for (id = 1; id <= 20; ++id) {
            SQLVarchar dvd2 = new SQLVarchar("id" + id);
            SQLInteger dvd4 = new SQLInteger(id);
            keys1[id - 1] = new CompactCompositeRegionKey(new DataValueDescriptor[]{dvd2, dvd4}, tabInfo);
        }
        for (Object key : reg.keySet()) {
            CompactCompositeRegionKey ccrk = (CompactCompositeRegionKey)key;
            id = ccrk.getKeyColumn(1).getInt();
            RowFormatterTest.assertTrue((String)("unexpected ID=" + id), (id >= 1 && id <= 20 ? 1 : 0) != 0);
            RowFormatterTest.assertNull((String)("unexpected existing value for ID=" + id + ": " + keys2[id - 1]), (Object)keys2[id - 1]);
            keys2[id - 1] = ccrk;
        }
        for (id = 1; id <= 20; ++id) {
            RowFormatterTest.assertEquals((int)id, (int)keys1[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((int)id, (int)keys2[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys1[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys2[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((int)keys1[id - 1].hashCode(), (int)keys2[id - 1].hashCode());
            RowFormatterTest.assertEquals((Object)keys1[id - 1], (Object)keys2[id - 1]);
        }
        for (id = 1; id <= 20; ++id) {
            Object valBytes = keys2[id - 1].getValueByteSource();
            try {
                keys3[id - 1] = new CompactCompositeRegionKey((byte[])valBytes, keys2[id - 1].getTableInfo());
                continue;
            }
            finally {
                keys2[id - 1].releaseValueByteSource(valBytes);
            }
        }
        for (id = 1; id <= 20; ++id) {
            RowFormatterTest.assertEquals((int)id, (int)keys2[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((int)id, (int)keys3[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys2[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys3[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((int)keys2[id - 1].hashCode(), (int)keys3[id - 1].hashCode());
            RowFormatterTest.assertEquals((Object)keys2[id - 1], (Object)keys3[id - 1]);
        }
        for (id = 1; id <= 20; ++id) {
            keys2[id - 1].snapshotKeyFromValue();
        }
        for (id = 1; id <= 20; ++id) {
            RowFormatterTest.assertEquals((int)id, (int)keys1[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((int)id, (int)keys2[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((int)id, (int)keys3[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys1[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys2[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys3[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((int)keys1[id - 1].hashCode(), (int)keys2[id - 1].hashCode());
            RowFormatterTest.assertEquals((int)keys1[id - 1].hashCode(), (int)keys3[id - 1].hashCode());
            RowFormatterTest.assertEquals((Object)keys1[id - 1], (Object)keys2[id - 1]);
            RowFormatterTest.assertEquals((Object)keys1[id - 1], (Object)keys3[id - 1]);
        }
        for (id = 1; id <= 20; ++id) {
            keys4[id - 1] = new CompactCompositeRegionKey(rf.generateBytes(new DataValueDescriptor[]{new SQLInteger(id + 5), new SQLVarchar("id" + id), new SQLChar("testvalue" + id), new SQLInteger(id), new SQLDecimal("75." + id), new SQLVarchar("test" + id), new SQLReal(10.5f)}), tabInfo);
        }
        for (id = 1; id <= 20; ++id) {
            RowFormatterTest.assertEquals((int)id, (int)keys1[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((int)id, (int)keys4[id - 1].getKeyColumn(1).getInt());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys1[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((String)("id" + id), (String)keys4[id - 1].getKeyColumn(0).getString());
            RowFormatterTest.assertEquals((int)keys1[id - 1].hashCode(), (int)keys4[id - 1].hashCode());
            RowFormatterTest.assertEquals((int)keys2[id - 1].hashCode(), (int)keys4[id - 1].hashCode());
            RowFormatterTest.assertEquals((int)keys3[id - 1].hashCode(), (int)keys4[id - 1].hashCode());
            RowFormatterTest.assertEquals((Object)keys1[id - 1], (Object)keys4[id - 1]);
            RowFormatterTest.assertEquals((Object)keys2[id - 1], (Object)keys4[id - 1]);
            RowFormatterTest.assertEquals((Object)keys3[id - 1], (Object)keys4[id - 1]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        for (id = 1; id <= 20; ++id) {
            DataSerializer.writeObject((Object)keys1[id - 1], (DataOutput)out);
            DataSerializer.writeObject((Object)keys2[id - 1], (DataOutput)out);
            DataSerializer.writeObject((Object)keys3[id - 1], (DataOutput)out);
            DataSerializer.writeObject((Object)keys4[id - 1], (DataOutput)out);
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
        for (id = 1; id <= 20; ++id) {
            for (int i = 1; i <= 4; ++i) {
                block21: {
                    keys4[id - 1] = (CompactCompositeRegionKey)DataSerializer.readObject((DataInput)in);
                    try {
                        RowFormatterTest.assertEquals((String)("id" + id), (String)keys4[id - 1].getKeyColumn(0).getString());
                        RowFormatterTest.fail("expected an internal error");
                    }
                    catch (RuntimeException err) {
                        if (err.getMessage().contains("tableInfo")) break block21;
                        throw err;
                    }
                }
                keys4[id - 1].setRegionContext(reg);
                RowFormatterTest.assertEquals((String)("id" + id), (String)keys4[id - 1].getKeyColumn(0).getString());
                RowFormatterTest.assertEquals((int)id, (int)keys4[id - 1].getKeyColumn(1).getInt());
                RowFormatterTest.assertEquals((int)keys1[id - 1].hashCode(), (int)keys4[id - 1].hashCode());
                RowFormatterTest.assertEquals((int)keys2[id - 1].hashCode(), (int)keys4[id - 1].hashCode());
                RowFormatterTest.assertEquals((int)keys3[id - 1].hashCode(), (int)keys4[id - 1].hashCode());
                RowFormatterTest.assertEquals((Object)keys1[id - 1], (Object)keys4[id - 1]);
                RowFormatterTest.assertEquals((Object)keys2[id - 1], (Object)keys4[id - 1]);
                RowFormatterTest.assertEquals((Object)keys3[id - 1], (Object)keys4[id - 1]);
            }
        }
        RowFormatterTest.assertEquals((int)0, (int)in.available());
        for (id = 1; id <= 20; ++id) {
            RowFormatterTest.assertNotNull((String)("failed1 for ID=" + id), (Object)reg.get((Object)keys1[id - 1]));
            RowFormatterTest.assertNotNull((String)("failed2 for ID=" + id), (Object)reg.get((Object)keys2[id - 1]));
            RowFormatterTest.assertNotNull((String)("failed3 for ID=" + id), (Object)reg.get((Object)keys3[id - 1]));
            RowFormatterTest.assertNotNull((String)("failed4 for ID=" + id), (Object)reg.get((Object)keys4[id - 1]));
        }
        byte[] col1Bytes = (byte[])reg.get((Object)keys1[0]);
        RowFormatterTest.assertNotNull((Object)col1Bytes);
        RowFormatterTest.assertEquals((int)61, (int)col1Bytes.length);
        RowFormatterTest.assertEquals((Object)new SQLVarchar("testing"), (Object)rf.getColumn(6, col1Bytes));
        pstmt = conn.prepareStatement("select c2, c5, c6, c3 from test.table1 where c4=? and c2=?");
        for (id = 1; id <= 20; ++id) {
            pstmt.setInt(1, id);
            pstmt.setString(2, "id" + id);
            ResultSet rs = pstmt.executeQuery();
            RowFormatterTest.assertTrue((boolean)rs.next());
            RowFormatterTest.assertEquals((String)("id" + id), (String)rs.getString(1));
            RowFormatterTest.assertEquals((Object)new BigDecimal("0.1" + id).setScale(20), (Object)rs.getObject(2));
            RowFormatterTest.assertEquals((Object)new BigDecimal("0.1" + id).setScale(20), (Object)rs.getBigDecimal(2));
            RowFormatterTest.assertEquals((Object)"testing", (Object)rs.getObject(3));
            String fixedStr = "fixed" + id;
            for (int index = fixedStr.length(); index < 20; ++index) {
                fixedStr = fixedStr + ' ';
            }
            RowFormatterTest.assertEquals((String)fixedStr, (String)rs.getString(4));
            RowFormatterTest.assertEquals((Object)fixedStr, (Object)rs.getObject(4));
            RowFormatterTest.assertFalse((boolean)rs.next());
        }
        stmt.execute("drop table test.table1");
    }

    public void testHashDistribution_43271() throws Exception {
        Connection conn = RowFormatterTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table tpcc.customer (c_w_id         integer        not null,c_d_id         integer        not null,c_id           integer        not null,c_discount     decimal(4,4),c_credit       char(2),c_last         varchar(16),c_first        varchar(16),c_credit_lim   decimal(12,2),c_balance      decimal(12,2),c_ytd_payment  float,c_payment_cnt  integer,c_delivery_cnt integer,c_street_1     varchar(20),c_street_2     varchar(20),c_city         varchar(20),c_state        char(2),c_zip          char(9),c_phone        char(16),c_since        timestamp,c_middle       char(2),c_data         varchar(500)) partition by column(c_w_id) BUCKETS 270");
        stmt.execute("create table tpcc.stock (s_w_id       integer       not null,s_i_id       integer       not null,s_quantity   decimal(4,0),s_ytd        decimal(8,2),s_order_cnt  integer,s_remote_cnt integer,s_data       varchar(50),s_dist_01    char(24),s_dist_02    char(24),s_dist_03    char(24),s_dist_04    char(24),s_dist_05    char(24),s_dist_06    char(24),s_dist_07    char(24),s_dist_08    char(24),s_dist_09    char(24),s_dist_10    char(24)) partition by column (s_w_id) colocate with (tpcc.customer) BUCKETS 270");
        int numInserts = 270;
        PreparedStatement pstmt = conn.prepareStatement("insert into tpcc.customer(c_w_id, c_d_id, c_id) values (?, ?, ?)");
        PreparedStatement pstmt2 = conn.prepareStatement("insert into tpcc.stock(s_w_id, s_i_id) values (?, ?)");
        for (int id = 1; id <= 270; ++id) {
            pstmt.setInt(1, id);
            pstmt.setInt(2, id << 1);
            pstmt.setInt(3, id + 1);
            pstmt.execute();
            pstmt2.setInt(1, id);
            pstmt2.setInt(2, id + 2);
            pstmt2.execute();
        }
        PartitionedRegion prCust = (PartitionedRegion)Misc.getRegionForTable((String)"TPCC.CUSTOMER", (boolean)true);
        PartitionedRegion stCust = (PartitionedRegion)Misc.getRegionForTable((String)"TPCC.STOCK", (boolean)true);
        Set prBucketIds = prCust.getDataStore().getAllLocalBucketIds();
        Set stBucketIds = stCust.getDataStore().getAllLocalBucketIds();
        RowFormatterTest.assertTrue((String)("less than expected buckets created " + prBucketIds.size() + ": " + prBucketIds), (prBucketIds.size() == 270 ? 1 : 0) != 0);
        RowFormatterTest.assertTrue((String)("less than expected buckets created " + stBucketIds.size() + ": " + stBucketIds), (stBucketIds.size() == 270 ? 1 : 0) != 0);
    }

    public void testHashDistributionUDF_43271() throws Exception {
        Connection conn = RowFormatterTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table tpcc.customer (c_w_id         integer        not null,c_d_id         integer        not null,c_id           integer        not null,c_discount     decimal(4,4),c_credit       char(2),c_last         varchar(16),c_first        varchar(16),c_credit_lim   decimal(12,2),c_balance      decimal(12,2),c_ytd_payment  float,c_payment_cnt  integer,c_delivery_cnt integer,c_street_1     varchar(20),c_street_2     varchar(20),c_city         varchar(20),c_state        char(2),c_zip          char(9),c_phone        char(16),c_since        timestamp,c_middle       char(2),c_data         varchar(500)) partition by(c_w_id)");
        stmt.execute("create table tpcc.stock (s_w_id       integer       not null,s_i_id       integer       not null,s_quantity   decimal(4,0),s_ytd        decimal(8,2),s_order_cnt  integer,s_remote_cnt integer,s_data       varchar(50),s_dist_01    char(24),s_dist_02    char(24),s_dist_03    char(24),s_dist_04    char(24),s_dist_05    char(24),s_dist_06    char(24),s_dist_07    char(24),s_dist_08    char(24),s_dist_09    char(24),s_dist_10    char(24)) partition by (s_w_id) colocate with (tpcc.customer)");
        int numInserts = 72;
        PreparedStatement pstmt = conn.prepareStatement("insert into tpcc.customer(c_w_id, c_d_id, c_id) values (?, ?, ?)");
        PreparedStatement pstmt2 = conn.prepareStatement("insert into tpcc.stock(s_w_id, s_i_id) values (?, ?)");
        for (int id = 1; id <= 72; ++id) {
            pstmt.setInt(1, id);
            pstmt.setInt(2, id << 1);
            pstmt.setInt(3, id + 1);
            pstmt.execute();
            pstmt2.setInt(1, id);
            pstmt2.setInt(2, id + 2);
            pstmt2.execute();
        }
        PartitionedRegion prCust = (PartitionedRegion)Misc.getRegionForTable((String)"TPCC.CUSTOMER", (boolean)true);
        PartitionedRegion stCust = (PartitionedRegion)Misc.getRegionForTable((String)"TPCC.STOCK", (boolean)true);
        Set prBucketIds = prCust.getDataStore().getAllLocalBucketIds();
        Set stBucketIds = stCust.getDataStore().getAllLocalBucketIds();
        RowFormatterTest.assertEquals((String)("less than expected buckets created " + prBucketIds.size() + ": " + prBucketIds), (int)72, (int)prBucketIds.size());
        RowFormatterTest.assertEquals((String)("less than expected buckets created " + stBucketIds.size() + ": " + stBucketIds), (int)72, (int)stBucketIds.size());
    }

    public void testProjectionWithClobs() throws SQLException {
        Properties cp = new Properties();
        cp.setProperty("host-data", "true");
        cp.put(PartitionedRegion.rand.nextBoolean() ? "user" : "UserName", "Soubhik");
        cp.put("password", "Soubhik");
        cp.setProperty("mcast-port", String.valueOf(AvailablePort.getRandomAvailablePort((int)1)));
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create table Layout (     uuid_ varchar(75),      plid bigint not null primary key,       groupId bigint, companyId bigint,       privateLayout smallint, layoutId bigint,        parentLayoutId bigint,  name varchar(4000),     title varchar(4000),    description varchar(4000),      type_ varchar(75),      typeSettings clob,      hidden_ smallint,       friendlyURL varchar(255),       iconImage smallint,     iconImageId bigint,     themeId varchar(75),    colorSchemeId varchar(75),      wapThemeId varchar(75), wapColorSchemeId varchar(75),   css varchar(4000),      priority integer,       layoutPrototypeId bigint,       dlFolderId bigint)");
        st.execute("insert into Layout (uuid_, groupId, companyId, privateLayout, layoutId, parentLayoutId, name, title, description, type_, typeSettings, hidden_, friendlyURL, iconImage, iconImageId, themeId, colorSchemeId, wapThemeId, wapColorSchemeId, css, priority, layoutPrototypeId, dlFolderId, plid) values ('3333-2332-3323-3332', 112, 3323, 33, 3323, 33232, 'NAME : CHAKRABORTY, KUMAR CHAKRABORTY, PRANAB KUMAR CHAKRABORTY, KUMAR PRANAB KUMAR CHAKRABORTY, SOUBHIK KUMAR PRANAB KUMAR CHAKRABORTY', 'title: MISTER, MONSIEUR, \u3060\u3093\u306a (Dan''na), don, \u091c\u0940, ', ' description is self descriptive in name / title. what else ?', 'TYPE-1',  cast ( 'dafaafsasfasdfasdfasdfasdfasddfasfasdfasd' as clob), 1, 'http://sb.blogspot.com', 1, 1122, 'THEME-1', 'dfadfa',  'wapTheme-2' , 'wapColorScheme-11', '<html> <!css type fo scripts> ', 1, 1, 1, 1000) ");
        ResultSet rs = st.executeQuery("select layoutimpl0_.uuid_ as uuid2_13_0_, layoutimpl0_.plid as plid13_0_, layoutimpl0_.typeSettings as typeSet12_13_0_, layoutimpl0_.hidden_ as hidden13_13_0_, title from Layout layoutimpl0_ where layoutimpl0_.plid=1000");
        while (rs.next()) {
            RowFormatterTest.assertEquals((String)rs.getString(1), (String)"3333-2332-3323-3332");
            RowFormatterTest.assertEquals((long)rs.getLong(2), (long)1000L);
            RowFormatterTest.assertEquals((String)rs.getString(3), (String)"dafaafsasfasdfasdfasdfasdfasddfasfasdfasd");
            RowFormatterTest.assertEquals((int)rs.getInt(4), (int)1);
            RowFormatterTest.assertEquals((String)"title: MISTER, MONSIEUR, \u3060\u3093\u306a (Dan'na), don, \u091c\u0940, ", (String)rs.getString(5));
        }
    }

    public void testDecimalString() throws Exception {
        Random rnd = new Random();
        int numTimes = 1000000;
        byte[][] rows = new byte[1000000][];
        for (int i = 0; i < 1000000; ++i) {
            int j;
            char[] chars;
            int offset;
            boolean bias = rnd.nextInt(5) != 0;
            int precision = bias ? 1 + rnd.nextInt(38) : 1 + rnd.nextInt(127);
            int scale = rnd.nextInt(precision + 1);
            boolean negate = rnd.nextBoolean();
            if (negate) {
                offset = 1;
                chars = new char[precision + 2];
                chars[0] = 45;
            } else {
                offset = 0;
                chars = new char[precision + 1];
            }
            for (j = scale; j < precision; ++j) {
                chars[offset++] = (char)(rnd.nextInt(10) + 48);
            }
            chars[offset++] = 46;
            for (j = 1; j <= scale; ++j) {
                chars[offset++] = (char)(rnd.nextInt(10) + 48);
            }
            if (offset != chars.length) {
                RowFormatterTest.fail("offset=" + offset + " chars.length=" + chars.length);
            }
            SQLDecimal dec = new SQLDecimal(chars);
            rows[i] = new byte[dec.getLengthInBytes(null)];
            dec.writeBytes(rows[i], 0, null);
        }
        for (byte[] row : rows) {
            String s1 = SQLDecimal.getAsBigDecimal((byte[])row, (int)0, (int)row.length).toPlainString();
            String s2 = SQLDecimal.getAsString((byte[])row, (int)0, (int)row.length);
            RowFormatterTest.assertEquals((String)s1, (String)s2);
        }
        for (int i = 1; i <= 4; ++i) {
            long start = System.nanoTime();
            for (byte[] row : rows) {
                SQLDecimal.getAsBigDecimal((byte[])row, (int)0, (int)row.length).toPlainString();
            }
            long end = System.nanoTime();
            System.out.println("Time taken with BigDecimal " + (double)(end - start) / 1000000.0 + "ms");
            start = System.nanoTime();
            for (byte[] row : rows) {
                SQLDecimal.getAsString((byte[])row, (int)0, (int)row.length);
            }
            end = System.nanoTime();
            System.out.println("Time taken with optimized impl " + (double)(end - start) / 1000000.0 + "ms");
        }
    }

    public void DEBUG_testPXFPerf() throws Exception {
        Random rnd = new Random();
        String availableChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        byte[][] byteArrays = new byte[10][];
        int totalBytes = 0;
        for (int i = 0; i < byteArrays.length; ++i) {
            byteArrays[i] = new byte[512 + rnd.nextInt(512)];
            byte[] bytes = byteArrays[i];
            for (int j = 0; j < bytes.length; ++j) {
                bytes[j] = (byte)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_".charAt(rnd.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_".length()));
            }
            totalBytes += bytes.length;
        }
        ByteArrayDataOutput out = new ByteArrayDataOutput();
        int numTimes = 500000;
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)12);
        for (int i = 0; i < 100000; ++i) {
            for (byte[] bytes : byteArrays) {
                DataTypeUtilities.writeAsUTF8BytesForPXF((byte[])bytes, (int)0, (int)bytes.length, (DataTypeDescriptor)dtd, (ByteArrayDataOutput)out);
            }
            out.clearForReuse();
        }
        for (int cnt = 1; cnt <= 5; ++cnt) {
            long start = System.nanoTime();
            for (int i = 0; i < 500000; ++i) {
                for (byte[] bytes : byteArrays) {
                    DataTypeUtilities.writeAsUTF8BytesForPXF((byte[])bytes, (int)0, (int)bytes.length, (DataTypeDescriptor)dtd, (ByteArrayDataOutput)out);
                }
                out.clearForReuse();
            }
            long end = System.nanoTime();
            double rateMB = 1000.0 * (double)totalBytes * 500000.0 / (double)(end - start);
            System.out.println("Total time taken " + (double)(end - start) / 1000000.0 + "ms at the rate of " + rateMB + " MB/s");
        }
    }

    public void DEBUG_testBytes() throws Exception {
        Connection conn = TestUtil.getConnection();
        conn.createStatement().execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        RowFormatter rf = ((GemFireContainer)Misc.getRegion((String)"/TRADE/CUSTOMERS", (boolean)true, (boolean)false).getUserAttribute()).getCurrentRowFormatter();
        byte[] bytes1 = new byte[]{0, 0, 3, -107, 110, 97, 109, 101, 57, 54, 7, -45, 4, 4, 97, 100, 100, 114, 101, 115, 115, 32, 105, 115, 32, 110, 97, 109, 101, 57, 54, 0, 0, 0, 16, 4, 0, 10, 0, 14, 0, 31, 0};
        byte[] bytes2 = new byte[]{0, 0, 3, -107, 110, 97, 109, 101, 57, 49, 55, 7, -45, 4, 4, 97, 100, 100, 114, 101, 115, 115, 32, 105, 115, 32, 110, 97, 109, 101, 57, 49, 55, 0, 0, 0, 16, 4, 0, 11, 0, 15, 0, 33, 0};
        Object[] dvds1 = new DataValueDescriptor[5];
        Object[] dvds2 = new DataValueDescriptor[5];
        rf.getColumns(bytes1, (DataValueDescriptor[])dvds1, null);
        rf.getColumns(bytes2, (DataValueDescriptor[])dvds2, null);
        System.out.println("Row1 is: " + Arrays.toString(dvds1));
        System.out.println("Row2 is: " + Arrays.toString(dvds2));
    }

    public static final class NullHolder
    implements ResultWasNull {
        boolean wasNull;

        public void setWasNull() {
            this.wasNull = true;
        }

        public boolean wasNull() {
            return this.wasNull;
        }
    }
}

