/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.TestCase;

public class GFECompatibilityTest
extends TestCase {
    private final String[] exclusions = new String[]{"NonLocalRegionEntry", "NonLocalRegionEntryWithStats", "ProxyRegionEntry", "GfxdTXEntryState", "OplogDiskEntry", "ValidatingDiskEntry", "HDFSEventRowLocationRegionEntry"};

    public GFECompatibilityTest(String name) {
        super(name);
    }

    public void testExtendedRegionEntryClasses() throws Exception {
        TestUtil.getConnection();
        String gfeJar = GemFireCacheImpl.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        String gemfirexdJar = GemFireStore.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (System.getProperty("os.name").contains("Windows")) {
            if (gfeJar.charAt(0) == '/') {
                gfeJar = gfeJar.substring(1);
            }
            if (gemfirexdJar.charAt(0) == '/') {
                gemfirexdJar = gemfirexdJar.substring(1);
            }
        }
        List<Class> gfeREClasses = this.getRegionEntryClassesFromJar(gfeJar, "com.gemstone.gemfire.internal.cache");
        List<Class> gfxdREClasses = this.getRegionEntryClassesFromJar(gemfirexdJar, "com.pivotal.gemfirexd.internal.engine.store.entry");
        GFECompatibilityTest.assertFalse((boolean)gfeREClasses.isEmpty());
        GFECompatibilityTest.assertFalse((boolean)gfxdREClasses.isEmpty());
        Iterator<Class> gfeClassesItr = gfeREClasses.iterator();
        while (gfeClassesItr.hasNext()) {
            Class gfeClass = gfeClassesItr.next();
            Iterator<Class> gfxdClassItr = gfxdREClasses.iterator();
            int numFound = 0;
            HashMap<Class, Class> assignableClasses = new HashMap<Class, Class>();
            while (gfxdClassItr.hasNext()) {
                Class gfxdClass = gfxdClassItr.next();
                Class gfxdSuper = gfxdClass.getSuperclass();
                while (gfxdSuper.getName().contains("RowLocation")) {
                    gfxdSuper = gfxdSuper.getSuperclass();
                }
                if (!gfeClass.equals(gfxdSuper)) continue;
                ++numFound;
                assignableClasses.put(gfxdClass, gfeClass);
                gfxdClassItr.remove();
            }
            String gfeClassName = gfeClass.getName();
            if (gfeClassName.endsWith("OffHeap") || gfeClassName.endsWith("Heap")) {
                GFECompatibilityTest.assertEquals((String)("Assignable classes: " + assignableClasses + " for " + gfeClassName), (int)0, (int)numFound);
            } else {
                GFECompatibilityTest.assertEquals((String)("Assignable classes: " + assignableClasses + " for " + gfeClassName), (int)9, (int)numFound);
            }
            gfeClassesItr.remove();
        }
        GFECompatibilityTest.assertTrue((boolean)gfxdREClasses.isEmpty());
        GFECompatibilityTest.assertTrue((boolean)gfeREClasses.isEmpty());
    }

    private List<Class> getRegionEntryClassesFromJar(String jarFile, String pkg) throws Exception {
        LinkedList<Class> regionEntryClasses = new LinkedList<Class>();
        JarFile gfJar = new JarFile(jarFile, true);
        Enumeration<JarEntry> enm = gfJar.entries();
        while (enm.hasMoreElements()) {
            Class<?> jeClass;
            JarEntry je = enm.nextElement();
            String name = je.getName().replace('/', '.');
            if (!name.startsWith(pkg) || !name.endsWith(".class") || (jeClass = Class.forName(name.replaceAll(".class", ""))).isInterface() || !RegionEntry.class.isAssignableFrom(jeClass) || this.isInExclusionList(jeClass) || jeClass.getSimpleName().startsWith("Abstract")) continue;
            regionEntryClasses.add(jeClass);
        }
        return regionEntryClasses;
    }

    private boolean isInExclusionList(Class jeClass) {
        String name = jeClass.getSimpleName();
        for (String toExclude : this.exclusions) {
            if (!toExclude.equals(name)) continue;
            return true;
        }
        return false;
    }
}

