/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.raw.store.FileStreamInputOutput;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.store.CompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.StreamContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.UserType;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CountAggregator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FileStreamIOTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(FileStreamIOTest.class));
    }

    public FileStreamIOTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRowOverflow() throws SQLException, StandardException {
        EmbedConnection conn = (EmbedConnection)TestUtil.getConnection();
        Statement st = conn.createStatement();
        try {
            st.execute("drop table test");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int i;
            int i2;
            st.execute("create table test (id int primary key , description varchar(1024), add_1 varchar(1024), add_2 varchar(1024) ) replicate ");
            PreparedStatement ps = conn.prepareStatement("insert into test values( ?, ? ,? , ?) ");
            ps.setInt(1, 1);
            ps.setString(2, "description");
            ps.setString(3, "address");
            ps.setString(4, "address");
            ps.execute();
            TransactionManager tm = (TransactionManager)conn.getLanguageConnection().getTransactionExecute();
            Transaction t = tm.getRawStoreXact();
            EmbedResultSet ers = (EmbedResultSet)st.executeQuery("select * from test");
            ByteBuffer b = FileStreamInputOutput.allocateBuffer((int)50, (TransactionController)tm);
            long containerId = t.addAndLoadStreamContainer(-1L, null, (RowSource)new TestRowSource(ers), b);
            ers.close();
            StreamContainerHandle sh = t.openStreamContainer(-1L, containerId, false);
            containerId = 0L;
            Region r = Misc.getRegion((String)Misc.getRegionPath((String)TestUtil.currentUserName, (String)"TEST", (LanguageConnectionContext)conn.getLanguageConnection()), (boolean)true, (boolean)false);
            RowFormatter rf = ((GemFireContainer)r.getUserAttribute()).getCurrentRowFormatter();
            CompactExecRow row = new CompactExecRow(rf);
            FileStreamIOTest.assertTrue((boolean)sh.fetchNext((ExecRow)row));
            FileStreamIOTest.assertEquals((int)1, (int)row.getColumn(1).getInt());
            FileStreamIOTest.assertFalse((boolean)sh.fetchNext((ExecRow)row));
            for (int i3 = 2; i3 < 10; ++i3) {
                ps.setInt(1, i3);
                ps.setString(2, "desc_" + i3);
                if (i3 % 2 == 0) {
                    ps.setString(3, "add_" + i3);
                } else {
                    ps.setString(3, "my address of sea facing juhu bunglow is " + i3);
                }
                if (i3 % 3 == 0) {
                    ps.setString(4, "address_" + i3);
                } else {
                    ps.setString(4, "\u0985 \u0986 \u0987 \u0988 \u0989 \u098a \u098b \u098f \u0990 \u0993 \u0994 \u0995 \u0996 \u0997 \u0998 \u0999 \u099a \u099b \u099c \u099d \u099e \u099f \u09a0 " + i3);
                }
                ps.execute();
            }
            ers = (EmbedResultSet)st.executeQuery("select * from test");
            containerId = t.addAndLoadStreamContainer(-1L, null, (RowSource)new TestRowSource(ers), b);
            sh = t.openStreamContainer(-1L, containerId, false);
            containerId = 0L;
            int[] rmap = new int[9];
            for (i2 = 1; i2 < 10; ++i2) {
                FileStreamIOTest.assertTrue((boolean)sh.fetchNext((ExecRow)row));
                int val = row.getColumn(1).getInt() - 1;
                FileStreamIOTest.assertTrue((String)("val[" + i2 + "]=" + val), (val >= 0 && val < rmap.length ? 1 : 0) != 0);
                int n = val;
                rmap[n] = rmap[n] + 1;
            }
            FileStreamIOTest.assertFalse((boolean)sh.fetchNext((ExecRow)row));
            for (i2 = 1; i2 < 10; ++i2) {
                FileStreamIOTest.assertTrue((String)(i2 + "th index repeated " + rmap[i2 - 1]), (rmap[i2 - 1] == 1 ? 1 : 0) != 0);
            }
            row = new ValueRow(rf.getNumColumns());
            ers = (EmbedResultSet)st.executeQuery("select id, length(description) from test order by id");
            containerId = t.addAndLoadStreamContainer(-1L, null, (RowSource)new TestRowSource(ers), b);
            sh = t.openStreamContainer(-1L, containerId, false);
            for (i = 1; i < 10; ++i) {
                FileStreamIOTest.assertTrue((boolean)sh.fetchNext((ExecRow)row));
                int val = row.getColumn(1).getInt();
                FileStreamIOTest.assertEquals((int)i, (int)val);
            }
            FileStreamIOTest.assertFalse((boolean)sh.fetchNext((ExecRow)row));
            ers = (EmbedResultSet)st.executeQuery("select description from test order by id");
            containerId = t.addAndLoadStreamContainer(-1L, null, (RowSource)new TestRowSource(ers), b);
            sh = t.openStreamContainer(-1L, containerId, false);
            for (i = 1; i < 10; ++i) {
                FileStreamIOTest.assertTrue((boolean)sh.fetchNext((ExecRow)row));
                String val = row.getColumn(1).getString();
                FileStreamIOTest.assertEquals((String)"desc", (String)val.substring(0, 4));
            }
            FileStreamIOTest.assertFalse((boolean)sh.fetchNext((ExecRow)row));
        }
        finally {
            TestUtil.shutDown();
        }
    }

    public void testUserTypeFileIO() throws SQLException, StandardException, IOException, ClassNotFoundException {
        UserType ut = new UserType();
        CountAggregator ca = new CountAggregator();
        ca.setup("count(*)", (DataValueDescriptor)new SQLInteger(122));
        ut.setValue((Object)ca);
        Connection conn = TestUtil.getConnection();
        FileStreamInputOutput fileIO = new FileStreamInputOutput(-1L, FileStreamInputOutput.allocateBuffer((int)10, null));
        ut.toData((DataOutput)fileIO);
        fileIO.flushAndSync(false);
        fileIO.flipToRead();
        UserType res = null;
        res = (UserType)DataType.readDVD((DataInput)fileIO);
        ca = (CountAggregator)res.getObject();
        FileStreamIOTest.assertEquals((long)122L, (long)ca.getResult().getLong());
        conn.close();
        TestUtil.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleMergeRuns() throws SQLException, StandardException, IOException, ClassNotFoundException {
        EmbedConnection conn = (EmbedConnection)TestUtil.getConnection();
        Statement st = conn.createStatement();
        try {
            st.execute("drop table test");
        }
        catch (Exception exception) {
            // empty catch block
        }
        st.execute("create table test (id int primary key , description varchar(1024), add_1 varchar(1024), add_2 varchar(1024), t_val bigint ) replicate ");
        PreparedStatement ps = conn.prepareStatement("insert into test values( ?,?,?,?,?) ");
        for (int i = 1; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "desc_" + i % 10);
            ps.setString(3, "add_" + i % 10);
            ps.setString(4, "address2_" + i % 10);
            ps.setLong(5, i % 10);
            ps.execute();
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
            private static final long serialVersionUID = 1L;

            public int overrideSortBufferSize(ColumnOrdering[] columnOrdering, int sortBufferMax) {
                return 3;
            }

            public boolean avoidMergeRuns() {
                return false;
            }
        });
        try {
            ResultSet rs = st.executeQuery("select description, count(1) from test group by t_val, description");
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            TestUtil.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllDataTypesDiskWrite() throws SQLException {
        EmbedConnection conn = (EmbedConnection)TestUtil.getConnection();
        Statement st = conn.createStatement();
        try {
            st.execute("drop table test");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            st.execute("create table test (id int primary key, lv bigint, si smallint, fl float, dbl double, nmr numeric(10,2), dml decimal(30,20), dt date, tm time, ts timestamp, cr char(254), vcr varchar(8192), id2 int, id3 int )");
            PreparedStatement ps = conn.prepareStatement("insert into test values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
            String vstr = "\u0999 \u099a \u099b \u099c \u099d \u099e \u099f This is varchar max upto 8k bytes ... so I suppose this should test long  enought string for now .... with some more bytes added for randomization ";
            for (int row = 1; row < 1000; ++row) {
                ps.setInt(1, row);
                ps.setLong(2, row);
                ps.setShort(3, (short)row);
                ps.setFloat(4, (float)row * 1.3f);
                ps.setDouble(5, (double)row + 1.3333333333333333);
                ps.setBigDecimal(6, BigDecimal.valueOf((double)row / 1.34));
                ps.setBigDecimal(7, BigDecimal.valueOf((double)row / 1.43 * (double)row));
                int d = row % 20 + 1;
                ps.setDate(8, Date.valueOf("2011-04-" + (d < 10 ? "0" + d : Integer.valueOf(d))));
                ps.setTime(9, Time.valueOf("12:00:01"));
                ps.setTimestamp(10, Timestamp.valueOf("2011-02-28 11:59:59.99999"));
                ps.setString(11, "This is char fixed width upto 254 ...  \u098b \u098f \u0990 \u0993 ");
                int begin = PartitionedRegion.rand.nextInt(vstr.length() - 1);
                ps.setString(12, vstr.substring(begin, vstr.length()));
                ps.setInt(13, row + 1);
                ps.setInt(14, row + 2);
                ps.executeUpdate();
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private static final long serialVersionUID = 1L;

                public int overrideSortBufferSize(ColumnOrdering[] columnOrdering, int sortBufferMax) {
                    return 100;
                }

                public boolean avoidMergeRuns() {
                    return false;
                }
            });
            ResultSet rs = st.executeQuery("select id, id2, id3, dml, ts from test order by id2 desc, dml");
            while (rs.next()) {
                System.out.println(rs.getInt("id"));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            TestUtil.shutDown();
        }
    }

    public void test43041() throws Exception {
        SQLChar[] chars = new SQLChar[]{new SQLChar("abcd ef gh ij"), new SQLChar("another huge string that will cross buffer boundary ")};
        SQLTimestamp ts = new SQLTimestamp("2011-04-08 19:35:00.995", true, null);
        Connection conn = TestUtil.getConnection();
        FileStreamInputOutput fileIO = new FileStreamInputOutput(-1L, FileStreamInputOutput.allocateBuffer((int)10, null));
        chars[0].toData((DataOutput)fileIO);
        chars[1].toData((DataOutput)fileIO);
        ts.toData((DataOutput)fileIO);
        fileIO.flushAndSync(false);
        fileIO.flipToRead();
        SQLChar[] readchars = new SQLChar[]{(SQLChar)DataType.readDVD((DataInput)fileIO), (SQLChar)DataType.readDVD((DataInput)fileIO)};
        SQLTimestamp readts = (SQLTimestamp)DataType.readDVD((DataInput)fileIO);
        FileStreamIOTest.assertTrue((boolean)chars[0].equals((Object)readchars[0]));
        FileStreamIOTest.assertTrue((boolean)chars[1].equals((Object)readchars[1]));
        FileStreamIOTest.assertTrue((boolean)ts.equals((Object)readts));
        fileIO = new FileStreamInputOutput(-2L, FileStreamInputOutput.allocateBuffer((int)5, null));
        fileIO.writeByte(127);
        fileIO.writeByte(126);
        fileIO.writeByte(125);
        chars[0].toData((DataOutput)fileIO);
        chars[0].toData((DataOutput)fileIO);
        fileIO.flushAndSync(false);
        fileIO.flipToRead();
        FileStreamIOTest.assertEquals((int)127, (int)fileIO.readByte());
        FileStreamIOTest.assertEquals((int)126, (int)fileIO.readByte());
        FileStreamIOTest.assertEquals((int)125, (int)fileIO.readByte());
        SQLChar c = (SQLChar)DataType.readDVD((DataInput)fileIO);
        FileStreamIOTest.assertEquals((Object)c, (Object)chars[0]);
        c = (SQLChar)DataType.readDVD((DataInput)fileIO);
        FileStreamIOTest.assertEquals((Object)c, (Object)chars[0]);
        conn.close();
        TestUtil.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PERF_testSortPerformance() throws Exception {
        System.setProperty("gemfirexd.TraceTempFileIO", "true");
        Properties p = new Properties();
        p.setProperty("log-level", "config");
        p.setProperty("critical-heap-percentage", "95");
        p.setProperty("eviction-heap-percentage", "72");
        TestUtil.reduceLogLevel("config");
        Connection conn = TestUtil.getConnection(p);
        Statement st = conn.createStatement();
        try {
            st.execute("drop table if exists test");
        }
        catch (Exception exception) {
            // empty catch block
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
            private static final long serialVersionUID = 1L;

            public int overrideSortBufferSize(ColumnOrdering[] columnOrdering, int sortBufferMax) {
                return sortBufferMax;
            }

            public boolean avoidMergeRuns() {
                return false;
            }
        });
        try {
            st.execute("create table test (id varchar(40), id1 varchar(2000), id2 int, id3 int) replicate persistent asynchronous eviction by lruheappercent evictaction overflow");
            PreparedStatement ps = conn.prepareStatement("insert into test values(?, ?, ?, ?) ");
            for (int c = 1; c <= 3; ++c) {
                char[] pre = new char[1990];
                Arrays.fill(pre, 'a');
                String prefix = new String(pre);
                int numItems = 500000;
                int maxId2 = 10;
                for (int i = 1; i <= 500000; ++i) {
                    int rnd = PartitionedRegion.rand.nextInt(500000);
                    ps.setString(1, "strkey-" + rnd);
                    ps.setString(2, prefix + rnd);
                    ps.setInt(3, i % 10);
                    ps.setInt(4, i % 50);
                    ps.execute();
                }
                System.gc();
                System.runFinalization();
                GfxdHeapThresholdListener heapListener = Misc.getMemStore().thresholdListener();
                while (heapListener.isEviction() || heapListener.isCritical()) {
                    SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)"waiting for EVICTION_DOWN...");
                    System.gc();
                    System.runFinalization();
                    Thread.sleep(1000L);
                }
                SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)"starting ORDER BY query");
                long start = System.nanoTime();
                int n = 0;
                ResultSet rs = st.executeQuery("select * from test order by id");
                String prev = "";
                while (rs.next()) {
                    String str = rs.getString(1);
                    if (c % 2 == 1 && str.compareTo(prev) < 0) {
                        FileStreamIOTest.fail((String)("incorrect ordering for '" + str + "', prev='" + prev + "'"));
                    }
                    prev = str;
                    ++n;
                }
                rs.close();
                rs = null;
                if (n != 500000) {
                    FileStreamIOTest.fail((String)("inserted 500000 but got " + n));
                }
                long end = System.nanoTime();
                System.out.println("Time taken for sorting: " + (double)(end - start) / 1000000.0 + " millis");
                System.gc();
                System.runFinalization();
                SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)"starting SUM+GROUP BY+ORDER BY query");
                start = System.nanoTime();
                n = 0;
                rs = st.executeQuery("select id2, sum(id3) from test group by id2 order by id2");
                int prevId2 = Integer.MIN_VALUE;
                while (rs.next()) {
                    int id2 = rs.getInt(1);
                    if (c % 2 == 1 && id2 < prevId2) {
                        FileStreamIOTest.fail((String)("incorrect ordering for " + id2 + ", prev=" + prevId2));
                    }
                    prevId2 = id2;
                    ++n;
                }
                rs.close();
                rs = null;
                if (n != 10) {
                    FileStreamIOTest.fail((String)("inserted 10 groups but got " + n));
                }
                end = System.nanoTime();
                System.out.println("Time taken for aggregate+sorting: " + (double)(end - start) / 1000000.0 + " millis");
                st.execute("truncate table test");
                System.gc();
                System.runFinalization();
            }
        }
        finally {
            System.clearProperty("gemfirexd.TraceTempFileIO");
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            TestUtil.shutDown();
        }
    }

    public void noneeded_test43041() throws SQLException {
        EmbedConnection conn = (EmbedConnection)TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table trade.customers  (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))    partition by range (cid)  ( VALUES BETWEEN 0 AND 599, VALUES BETWEEN 599 AND 902,    VALUES BETWEEN 902 AND 1255, VALUES BETWEEN 1255 AND 1678,    VALUES BETWEEN 1678 AND 100000)");
        st.execute("create table trade.portfolio  (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int,   constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict,   constraint sec_fk foreign key (sid) references trade.securities (sec_id),   constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))     partition by range (cid) ( VALUES BETWEEN 0 AND 599, VALUES BETWEEN 599 AND 902,   VALUES BETWEEN 902 AND 1255, VALUES BETWEEN 1255 AND 1678,   VALUES BETWEEN 1678 AND 100000)  colocate with (trade.customers)");
        st.execute("create table trade.sellorders  (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10) default 'open', tid int,  constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict,  constraint status_ch check (status in ('cancelled', 'open', 'filled')))    partition by range (cid) ( VALUES BETWEEN 0 AND 599, VALUES BETWEEN 599 AND 902,   VALUES BETWEEN 902 AND 1255, VALUES BETWEEN 1255 AND 1678, VALUES BETWEEN 1678 AND 100000)  colocate with (trade.customers) ");
        PreparedStatement psC = conn.prepareStatement("insert into trade.customers values (?, ?, ?, ?, ?) ");
        PreparedStatement psP = conn.prepareStatement("insert into trade.portfolio values (?, ?, ?, ?, ?, ?) ");
        PreparedStatement psS = conn.prepareStatement("insert into trade.sellorders values (?, ?, ?, ?, ?, ?, ?) ");
        st.executeQuery("select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, oid, order_time, ask from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and subTotal >10000 and f.cid>? order by order_time");
    }

    private class TestRowSource
    implements RowSource {
        private final EmbedResultSet ers;

        TestRowSource(EmbedResultSet _ers) {
            this.ers = _ers;
        }

        public ExecRow getNextRowFromRowSource() throws StandardException {
            try {
                this.ers.next();
            }
            catch (SQLException e) {
                throw StandardException.newException((String)"SQLException occured in test row source", (Throwable)e);
            }
            return this.ers.getCurrentRow();
        }

        public void closeRowSource() {
        }

        public FormatableBitSet getValidColumns() {
            return null;
        }

        public boolean needsToClone() {
            return false;
        }
    }
}

