/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.concurrent.AtomicUpdaterFactory;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import junit.framework.TestCase;
import org.apache.derbyTesting.junit.JDBC;

public class ConcurrentMapOpsTest
extends JdbcTestBase {
    protected int isolationLevel;
    protected int netPort;
    private volatile int intJDKCounter;
    private volatile long longJDKCounter;
    private volatile LongRef refJDKCounter;
    private volatile int intUnsafeCounter;
    private volatile long longUnsafeCounter;
    private volatile LongRef refUnsafeCounter;
    private volatile LongRef refCounter;

    public ConcurrentMapOpsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.statsDisabled", "true");
        System.setProperty("gemfire.WRITE_LOCK_TIMEOUT", "500");
        System.setProperty("gemfire.READ_LOCK_TIMEOUT", "1000");
        this.isolationLevel = 0;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("gemfire.statsDisabled");
        System.clearProperty("gemfire.WRITE_LOCK_TIMEOUT");
        System.clearProperty("gemfire.READ_LOCK_TIMEOUT");
        this.isolationLevel = 0;
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    protected Connection createConnection() throws Exception {
        Connection conn = this.netPort > 0 ? ConcurrentMapOpsTest.getNetConnection(this.netPort, "", null) : ConcurrentMapOpsTest.getConnection();
        if (this.isolationLevel == 0) {
            conn.setAutoCommit(false);
        }
        conn.setTransactionIsolation(this.isolationLevel);
        return conn;
    }

    public void testOpsWithCSLM() throws Throwable {
        ConcurrentMapOpsTest.setupConnection();
        this.netPort = ConcurrentMapOpsTest.startNetserverAndReturnPort();
        this.isolationLevel = 0;
        ConcurrentMapOpsTest.addExpectedException("Statistics sampler");
        this.runOpsWithCSLM(5000);
        this.runOpsWithCSLM(60000);
        ConcurrentMapOpsTest.removeExpectedException("Statistics sampler");
    }

    public void _BUG49712_testOpsWithCSLM_TX() throws Throwable {
        this.isolationLevel = 2;
        ConcurrentMapOpsTest.setupConnection();
        ConcurrentMapOpsTest.addExpectedExceptions(new Object[]{"Statistics sampler", "X0Z02"});
        this.runOpsWithCSLM(5000);
        this.runOpsWithCSLM(60000);
        ConcurrentMapOpsTest.removeExpectedExceptions(new Object[]{"Statistics sampler", "X0Z02"});
    }

    public void DISABLED_testOpsWithCSLM_RRTX() throws Throwable {
        this.isolationLevel = 4;
        ConcurrentMapOpsTest.setupConnection();
        ConcurrentMapOpsTest.addExpectedExceptions(new Object[]{"Statistics sampler", "X0Z02"});
        this.runOpsWithCSLM(5000);
        this.runOpsWithCSLM(60000);
        ConcurrentMapOpsTest.removeExpectedExceptions(new Object[]{"Statistics sampler", "X0Z02"});
    }

    public void testCompareAtomicOps() {
        AtomicIntegerFieldUpdater<ConcurrentMapOpsTest> intJDKCounter = AtomicIntegerFieldUpdater.newUpdater(ConcurrentMapOpsTest.class, "intJDKCounter");
        AtomicLongFieldUpdater<ConcurrentMapOpsTest> longJDKCounter = AtomicLongFieldUpdater.newUpdater(ConcurrentMapOpsTest.class, "longJDKCounter");
        AtomicReferenceFieldUpdater<ConcurrentMapOpsTest, LongRef> refJDKCounter = AtomicReferenceFieldUpdater.newUpdater(ConcurrentMapOpsTest.class, LongRef.class, "refJDKCounter");
        AtomicIntegerFieldUpdater intUnsafeCounter = AtomicUpdaterFactory.newIntegerFieldUpdater(ConcurrentMapOpsTest.class, (String)"intUnsafeCounter");
        AtomicLongFieldUpdater longUnsafeCounter = AtomicUpdaterFactory.newLongFieldUpdater(ConcurrentMapOpsTest.class, (String)"longUnsafeCounter");
        AtomicReferenceFieldUpdater refUnsafeCounter = AtomicUpdaterFactory.newReferenceFieldUpdater(ConcurrentMapOpsTest.class, LongRef.class, (String)"refUnsafeCounter");
        this.runAtomicOps(1, 50000, intJDKCounter, longJDKCounter, refJDKCounter, intUnsafeCounter, longUnsafeCounter, refUnsafeCounter);
        this.runAtomicOps(1, 50000000, intJDKCounter, longJDKCounter, refJDKCounter, intUnsafeCounter, longUnsafeCounter, refUnsafeCounter);
        this.runAtomicOps(5, 2000000, intJDKCounter, longJDKCounter, refJDKCounter, intUnsafeCounter, longUnsafeCounter, refUnsafeCounter);
    }

    public void runOpsWithCSLM(int runtimeInMillis) throws Throwable {
        int i;
        Connection conn = this.createConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("drop table if exists t.test");
        stmt.execute("create table t.test (id1 varchar(100), id2 varchar(100), id3 varchar(100), id4 varchar(100)) replicate concurrency level 60");
        stmt.execute("create unique index t.idx1 on t.test(id1)");
        stmt.execute("create index t.idx2 on t.test(id2)");
        stmt.execute("create index t.idx3 on t.test(id3)");
        stmt.execute("create index t.idx4 on t.test(id4)");
        long startTime = System.currentTimeMillis();
        final AtomicLong endTime1 = new AtomicLong(startTime + (long)runtimeInMillis);
        final Throwable[] failure = new Throwable[1];
        final AtomicInteger offset1 = new AtomicInteger();
        final AtomicInteger offset2 = new AtomicInteger();
        final AtomicInteger offset3 = new AtomicInteger();
        final AtomicInteger offset4 = new AtomicInteger();
        int numInsertThreads = 15;
        final AtomicInteger numDeleteThreads = new AtomicInteger(10);
        int numUpdateThreads = 10;
        int numSelectThreads = 10;
        final AtomicInteger insertOps = new AtomicInteger();
        final AtomicInteger deleteOps = new AtomicInteger();
        final AtomicInteger updateOps = new AtomicInteger();
        final AtomicInteger selectOps = new AtomicInteger();
        final GemFireContainer rc = (GemFireContainer)Misc.getRegionForTable((String)"T.TEST", (boolean)true).getUserAttribute();
        Runnable doInserts = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = ConcurrentMapOpsTest.this.createConnection();
                    PreparedStatement pstmt = conn.prepareStatement("insert into t.test values (?, ?, ?, ?)");
                    int myOffset = offset1.incrementAndGet();
                    int rowIdx = ConcurrentMapOpsTest.getRowIdxOffset(myOffset, 15);
                    block6: while (System.currentTimeMillis() < endTime1.get()) {
                        int initRowIdx = rowIdx;
                        while (true) {
                            for (int i = 0; i < 1000; ++i) {
                                boolean breakLoop = false;
                                while (!breakLoop) {
                                    pstmt.setString(1, "id1_" + rowIdx);
                                    pstmt.setString(2, "id2_" + rowIdx / (50 + i % 100));
                                    pstmt.setString(3, "id3_" + rowIdx % 3000);
                                    pstmt.setString(4, "id4_" + rowIdx % 5);
                                    try {
                                        TestCase.assertEquals((int)1, (int)pstmt.executeUpdate());
                                        insertOps.incrementAndGet();
                                        breakLoop = true;
                                    }
                                    catch (SQLException sqle) {
                                        if ("X0Z02".equals(sqle.getSQLState())) continue;
                                        if ("23505".equals(sqle.getSQLState())) {
                                            breakLoop = true;
                                            continue;
                                        }
                                        throw sqle;
                                    }
                                }
                                rowIdx = ConcurrentMapOpsTest.incRowIdx(rowIdx, myOffset, 15);
                            }
                            try {
                                conn.commit();
                                continue block6;
                            }
                            catch (SQLException sqle) {
                                if (!"X0Z02".equals(sqle.getSQLState())) {
                                    throw sqle;
                                }
                                rowIdx = initRowIdx;
                                continue;
                            }
                            break;
                        }
                    }
                    conn.commit();
                }
                catch (Throwable t) {
                    TestUtil.getLogger().error((Object)t);
                    failure[0] = t;
                }
            }
        };
        Runnable doDeletes = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = ConcurrentMapOpsTest.this.createConnection();
                    PreparedStatement pstmt = conn.prepareStatement("delete from t.test where id1=?");
                    int myOffset = offset2.incrementAndGet();
                    int numThreads = numDeleteThreads.get();
                    SanityManager.DEBUG_PRINT((String)"info:TEST", (String)("myOffset=" + myOffset));
                    int rowIdx = ConcurrentMapOpsTest.getRowIdxOffset(myOffset, numThreads);
                    block6: while (System.currentTimeMillis() < endTime1.get() && rc.getRegion().size() > 0) {
                        int initRowIdx = rowIdx;
                        while (true) {
                            for (int i = 0; i < 100; ++i) {
                                while (true) {
                                    pstmt.setString(1, "id1_" + rowIdx);
                                    try {
                                        pstmt.executeUpdate();
                                        deleteOps.incrementAndGet();
                                    }
                                    catch (SQLException sqle) {
                                        if ("X0Z02".equals(sqle.getSQLState())) continue;
                                        throw sqle;
                                    }
                                    break;
                                }
                                rowIdx = ConcurrentMapOpsTest.incRowIdx(rowIdx, myOffset, numThreads);
                            }
                            try {
                                conn.commit();
                                continue block6;
                            }
                            catch (SQLException sqle) {
                                if (!"X0Z02".equals(sqle.getSQLState())) {
                                    throw sqle;
                                }
                                rowIdx = initRowIdx;
                                continue;
                            }
                            break;
                        }
                    }
                    conn.commit();
                }
                catch (Throwable t) {
                    TestUtil.getLogger().error((Object)t);
                    failure[0] = t;
                }
            }
        };
        final long endTime2 = endTime1.get() + (long)runtimeInMillis;
        Runnable doUpdates = new Runnable(){

            @Override
            public void run() {
                try {
                    long currentTime;
                    Connection conn = ConcurrentMapOpsTest.this.createConnection();
                    PreparedStatement pstmt1 = conn.prepareStatement("update t.test set id2=?, id3=?, id4=? where id1=?");
                    PreparedStatement pstmt3 = conn.prepareStatement("update t.test set id2=?, id3=?, id4=? where id3=?");
                    int myOffset = offset3.incrementAndGet();
                    int rowIdx = ConcurrentMapOpsTest.getRowIdxOffset(myOffset, 10);
                    int updateIdx = ConcurrentMapOpsTest.getRowIdxOffset(myOffset, 10);
                    PreparedStatement pstmt = pstmt1;
                    boolean useId3 = false;
                    block6: while ((currentTime = System.currentTimeMillis()) < endTime2) {
                        if (!useId3 && currentTime > endTime1.get()) {
                            pstmt = pstmt3;
                            rowIdx = ConcurrentMapOpsTest.getRowIdxOffset(myOffset, 10);
                            useId3 = true;
                            SanityManager.DEBUG_PRINT((String)"TEST", (String)("Current table size=" + Misc.getRegionForTable((String)"T.TEST", (boolean)true).size()));
                        }
                        int initRowIdx = rowIdx;
                        int initUpdateIdx = updateIdx;
                        while (true) {
                            for (int i = 0; i < 10; ++i) {
                                while (true) {
                                    pstmt.setString(1, "id2_" + updateIdx / (95 + i));
                                    pstmt.setString(2, "id3_" + updateIdx % 3000);
                                    pstmt.setString(3, "id4_" + updateIdx % 5);
                                    if (useId3) {
                                        pstmt.setString(4, "id3_" + rowIdx % 3000);
                                    } else {
                                        pstmt.setString(4, "id1_" + rowIdx);
                                    }
                                    try {
                                        pstmt.executeUpdate();
                                        updateOps.incrementAndGet();
                                    }
                                    catch (SQLException sqle) {
                                        if ("X0Z02".equals(sqle.getSQLState())) continue;
                                        throw sqle;
                                    }
                                    break;
                                }
                                rowIdx = ConcurrentMapOpsTest.incRowIdx(rowIdx, myOffset, 10);
                                updateIdx = ConcurrentMapOpsTest.incRowIdx(updateIdx, myOffset, 10);
                            }
                            try {
                                conn.commit();
                                continue block6;
                            }
                            catch (SQLException sqle) {
                                if (!"X0Z02".equals(sqle.getSQLState())) {
                                    throw sqle;
                                }
                                rowIdx = initRowIdx;
                                updateIdx = initUpdateIdx;
                                continue;
                            }
                            break;
                        }
                    }
                    conn.commit();
                }
                catch (Throwable t) {
                    TestUtil.getLogger().error((Object)t);
                    failure[0] = t;
                }
            }
        };
        final AtomicInteger qualifiedRows = new AtomicInteger();
        final AtomicInteger requalifySkipped = new AtomicInteger();
        final AtomicInteger requalifySuccess = new AtomicInteger();
        final AtomicInteger requalifyFailed = new AtomicInteger();
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public void afterIndexRowRequalification(Boolean success, CompactCompositeIndexKey ccKey, ExecRow row, Activation activation) {
                if (activation.getPreparedStatement().getSource().contains("select * from t.test where id3")) {
                    if (success == null) {
                        requalifySkipped.incrementAndGet();
                    } else if (success.booleanValue()) {
                        requalifySuccess.incrementAndGet();
                    } else {
                        requalifyFailed.incrementAndGet();
                    }
                }
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Runnable doSelects = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = ConcurrentMapOpsTest.this.createConnection();
                    PreparedStatement pstmt1 = conn.prepareStatement("select * from t.test where id1=?");
                    PreparedStatement pstmt2 = conn.prepareStatement("select * from t.test where id2=?");
                    PreparedStatement pstmt3 = conn.prepareStatement("select * from t.test where id3=?");
                    PreparedStatement pstmt4 = conn.prepareStatement("select * from t.test where id3>=? and id3<?");
                    int myOffset = offset4.incrementAndGet();
                    int rowIdx = ConcurrentMapOpsTest.getRowIdxOffset(myOffset, 10);
                    int selectIdx = ConcurrentMapOpsTest.getRowIdxOffset(myOffset, 10);
                    while (System.currentTimeMillis() < endTime2) {
                        String id1 = "id1_" + rowIdx;
                        pstmt1.setString(1, id1);
                        String id2 = "id2_" + selectIdx / (50 + rowIdx % 89);
                        pstmt2.setString(1, id2);
                        String id3 = "id3_" + rowIdx % 3000;
                        pstmt3.setString(1, id3);
                        String id3_2 = "id3_" + (rowIdx % 3000 + 3);
                        pstmt4.setString(1, id3);
                        pstmt4.setString(2, id3_2);
                        ResultSet rs1 = pstmt1.executeQuery();
                        ResultSet rs2 = pstmt2.executeQuery();
                        ResultSet rs3 = pstmt3.executeQuery();
                        ResultSet rs4 = pstmt4.executeQuery();
                        ConcurrentMapOpsTest.this.checkIndexColumn(rs1, 1, id1, null);
                        ConcurrentMapOpsTest.this.checkIndexColumn(rs2, 2, id2, null);
                        ConcurrentMapOpsTest.this.checkIndexColumn(rs3, 3, id3, qualifiedRows);
                        ConcurrentMapOpsTest.this.checkIndexColumn(rs4, 3, (Comparable)((Object)id3), (Comparable)((Object)id3_2), qualifiedRows);
                        conn.commit();
                        rowIdx = ConcurrentMapOpsTest.incRowIdx(rowIdx, myOffset, 10);
                        selectIdx = ConcurrentMapOpsTest.incRowIdx(rowIdx, myOffset, 10);
                        selectOps.addAndGet(4);
                    }
                    conn.commit();
                }
                catch (Throwable t) {
                    TestUtil.getLogger().error((Object)t);
                    failure[0] = t;
                }
            }
        };
        Thread[] insertThreads = new Thread[15];
        Thread[] deleteThreads = new Thread[numDeleteThreads.get()];
        Thread[] updateThreads = new Thread[10];
        Thread[] selectThreads = new Thread[10];
        for (i = 0; i < 15; ++i) {
            insertThreads[i] = new Thread(doInserts);
            insertThreads[i].start();
        }
        for (i = 0; i < numDeleteThreads.get(); ++i) {
            deleteThreads[i] = new Thread(doDeletes);
            deleteThreads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            updateThreads[i] = new Thread(doUpdates);
            updateThreads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            selectThreads[i] = new Thread(doSelects);
            selectThreads[i].start();
        }
        for (i = 0; i < 15; ++i) {
            insertThreads[i].join();
        }
        for (i = 0; i < numDeleteThreads.get(); ++i) {
            deleteThreads[i].join();
        }
        for (i = 0; i < 10; ++i) {
            updateThreads[i].join();
        }
        for (i = 0; i < 10; ++i) {
            selectThreads[i].join();
        }
        if (requalifySuccess.intValue() < requalifyFailed.intValue() * 2) {
            ConcurrentMapOpsTest.fail("Too many requalifications failed: qualifiedRows=" + requalifySuccess.intValue() + ", requalifyFailed=" + requalifyFailed.intValue());
        }
        if (this.isolationLevel == 0 && requalifySkipped.intValue() < (requalifySuccess.intValue() + requalifyFailed.intValue()) / 10000) {
            ConcurrentMapOpsTest.fail("Not enough requalifications skipped: requalifySkipped=" + requalifySkipped.intValue() + ", requalifySuccess=" + requalifySuccess.intValue() + ", requalifyFailed=" + requalifyFailed.intValue());
        }
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: duration=" + (System.currentTimeMillis() - startTime) + "ms numInserts=" + insertOps.get() + " numDeletes=" + deleteOps.get() + " numUpdates=" + updateOps.get() + " numSelects=" + selectOps.get()));
        if (failure[0] != null) {
            throw failure[0];
        }
        GemFireXDQueryObserverHolder.clearInstance();
        ResultSet rs = stmt.executeQuery("values SYSCS_UTIL.CHECK_TABLE('T', 'TEST')");
        JDBC.assertSingleValueResultSet(rs, "1");
        rs.close();
        conn.commit();
        if (this.isolationLevel == 0) {
            int i2;
            offset2.set(0);
            deleteOps.set(0);
            int ndelthrs = 30;
            numDeleteThreads.set(30);
            endTime1.set(Long.MAX_VALUE);
            Thread[] deleteThreads2 = new Thread[30];
            System.setProperty("gemfirexd.language.stalePlanCheckInterval", "99999999");
            PreparedStatement pstmt = conn.prepareStatement("put into t.test values (?, ?, ?, ?)");
            for (i2 = 1; i2 <= 100; ++i2) {
                pstmt.setString(1, "id1_" + i2);
                pstmt.setString(2, "id2_" + i2 / (50 + i2 % 100));
                pstmt.setString(3, "id3_" + i2 % 3000);
                pstmt.setString(4, "id4_" + i2 % 5);
                try {
                    ConcurrentMapOpsTest.assertEquals((int)1, (int)pstmt.executeUpdate());
                    continue;
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) continue;
                    throw sqle;
                }
            }
            conn.commit();
            for (i2 = 0; i2 < 30; ++i2) {
                deleteThreads2[i2] = new Thread(doDeletes);
                deleteThreads2[i2].start();
            }
            boolean allJoined = false;
            while (!allJoined) {
                allJoined = true;
                for (int i3 = 0; i3 < 30; ++i3) {
                    deleteThreads2[i3].join(1000L);
                    allJoined &= !deleteThreads2[i3].isAlive();
                }
                if (failure[0] == null) continue;
                endTime1.set(System.currentTimeMillis());
            }
            if (failure[0] != null) {
                throw failure[0];
            }
            conn.commit();
            rs = stmt.executeQuery("select count(*) from t.test");
            JDBC.assertSingleValueResultSet(rs, "0");
            rs.close();
            rs = stmt.executeQuery("values SYSCS_UTIL.CHECK_TABLE('T', 'TEST')");
            JDBC.assertSingleValueResultSet(rs, "1");
            rs.close();
        }
        stmt.execute("drop table t.test");
        conn.commit();
    }

    private static int incRowIdx(int rowIdx, int myOffset, int numThreads) {
        return ((rowIdx += numThreads) - 1) % 300000 + 1;
    }

    private static int getRowIdxOffset(int myOffset, int numThreads) {
        int rnd = PartitionedRegion.rand.nextInt(300000);
        return rnd / numThreads * numThreads + myOffset;
    }

    private void checkIndexColumn(ResultSet rs, int columnNumber, Object expectedValue, AtomicInteger numRows) throws Exception {
        Object[] failedRow = null;
        while (rs.next()) {
            if (!expectedValue.equals(rs.getObject(columnNumber))) {
                failedRow = new Object[rs.getMetaData().getColumnCount()];
                for (int index = 0; index < failedRow.length; ++index) {
                    failedRow[index] = rs.getObject(index + 1);
                }
                continue;
            }
            if (numRows == null) continue;
            numRows.incrementAndGet();
        }
        rs.close();
        if (failedRow != null) {
            ConcurrentMapOpsTest.fail("unexpected index column [" + failedRow[columnNumber - 1] + "] expected [" + expectedValue + "] for row: " + Arrays.toString(failedRow));
        }
    }

    private <T> void checkIndexColumn(ResultSet rs, int columnNumber, Comparable<T> expectedValue1, Comparable<T> expectedValue2, AtomicInteger numRows) throws Exception {
        Object[] failedRow = null;
        while (rs.next()) {
            Object col = rs.getObject(columnNumber);
            if (expectedValue1.compareTo(col) > 0 || expectedValue2.compareTo(col) <= 0) {
                failedRow = new Object[rs.getMetaData().getColumnCount()];
                for (int index = 0; index < failedRow.length; ++index) {
                    failedRow[index] = rs.getObject(index + 1);
                }
                continue;
            }
            if (numRows == null) continue;
            numRows.incrementAndGet();
        }
        rs.close();
        if (failedRow != null) {
            ConcurrentMapOpsTest.fail("unexpected index column [" + failedRow[columnNumber - 1] + "] expected [" + expectedValue1 + ", " + expectedValue2 + ") for row: " + Arrays.toString(failedRow));
        }
    }

    private void runAtomicOps(int numThreads, final int numRuns, final AtomicIntegerFieldUpdater<ConcurrentMapOpsTest> intJDKCounter, final AtomicLongFieldUpdater<ConcurrentMapOpsTest> longJDKCounter, final AtomicReferenceFieldUpdater<ConcurrentMapOpsTest, LongRef> refJDKCounter, final AtomicIntegerFieldUpdater<ConcurrentMapOpsTest> intUnsafeCounter, final AtomicLongFieldUpdater<ConcurrentMapOpsTest> longUnsafeCounter, final AtomicReferenceFieldUpdater<ConcurrentMapOpsTest, LongRef> refUnsafeCounter) {
        final AtomicInteger atomicIntCounter = new AtomicInteger();
        final AtomicLong atomicLongCounter = new AtomicLong();
        final AtomicReference<LongRef> atomicRefCounter = new AtomicReference<LongRef>(new LongRef(0L));
        Thread[] threads = new Thread[numThreads];
        atomicIntCounter.set(0);
        atomicLongCounter.set(0L);
        atomicRefCounter.set(new LongRef(0L));
        intJDKCounter.set(this, 0);
        longJDKCounter.set(this, 0L);
        refJDKCounter.set(this, new LongRef(0L));
        intUnsafeCounter.set(this, 0);
        longUnsafeCounter.set(this, 0L);
        refUnsafeCounter.set(this, new LongRef(0L));
        this.refCounter = new LongRef(0L);
        final CyclicBarrier barrier = new CyclicBarrier(numThreads + 1);
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LongRef update;
                    LongRef expect;
                    int i;
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        atomicIntCounter.incrementAndGet();
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        atomicLongCounter.incrementAndGet();
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        do {
                            update = new LongRef(0L);
                            expect = (LongRef)atomicRefCounter.get();
                            update.v = expect.v + 1L;
                        } while (!atomicRefCounter.compareAndSet(expect, update));
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        intJDKCounter.incrementAndGet(ConcurrentMapOpsTest.this);
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        longJDKCounter.incrementAndGet(ConcurrentMapOpsTest.this);
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        do {
                            update = new LongRef(0L);
                            expect = (LongRef)refJDKCounter.get(ConcurrentMapOpsTest.this);
                            update.v = expect.v + 1L;
                        } while (!refJDKCounter.compareAndSet(ConcurrentMapOpsTest.this, expect, update));
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        intUnsafeCounter.incrementAndGet(ConcurrentMapOpsTest.this);
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        longUnsafeCounter.incrementAndGet(ConcurrentMapOpsTest.this);
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        do {
                            update = new LongRef(0L);
                            expect = (LongRef)refUnsafeCounter.get(ConcurrentMapOpsTest.this);
                            update.v = expect.v + 1L;
                        } while (!refUnsafeCounter.compareAndSet(ConcurrentMapOpsTest.this, expect, update));
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                    for (i = 0; i < numRuns; ++i) {
                        ConcurrentMapOpsTest concurrentMapOpsTest = ConcurrentMapOpsTest.this;
                        synchronized (concurrentMapOpsTest) {
                            ConcurrentMapOpsTest.this.refCounter = new LongRef(((ConcurrentMapOpsTest)ConcurrentMapOpsTest.this).refCounter.v + 1L);
                            continue;
                        }
                    }
                    ConcurrentMapOpsTest.awaitBarrier(barrier);
                }
            });
            threads[i].start();
        }
        long start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        long end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: AtomicInteger time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((int)(numRuns * numThreads), (int)atomicIntCounter.get());
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: AtomicLong time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((long)(numRuns * numThreads), (long)atomicLongCounter.get());
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: AtomicReference time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((Object)new LongRef(numRuns * numThreads), (Object)atomicRefCounter.get());
        ConcurrentMapOpsTest.doGC();
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: AtomicIntegerFieldUpdater time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((int)(numRuns * numThreads), (int)intJDKCounter.get(this));
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: AtomicLongFieldUpdater time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((long)(numRuns * numThreads), (long)longJDKCounter.get(this));
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: AtomicReferenceFieldUpdater time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((Object)new LongRef(numRuns * numThreads), (Object)refJDKCounter.get(this));
        ConcurrentMapOpsTest.doGC();
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: UnsafeIntegerFieldUpdater time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((int)(numRuns * numThreads), (int)intUnsafeCounter.get(this));
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: UnsafeLongFieldUpdater time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((long)(numRuns * numThreads), (long)longUnsafeCounter.get(this));
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: UnsafeRefFieldUpdater time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((Object)new LongRef(numRuns * numThreads), (Object)refUnsafeCounter.get(this));
        ConcurrentMapOpsTest.doGC();
        start = System.currentTimeMillis();
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        ConcurrentMapOpsTest.awaitBarrier(barrier);
        end = System.currentTimeMillis();
        ConcurrentMapOpsTest.getLogger().info((Object)("PERF: Ref sync time for " + numRuns + " ops with " + numThreads + " threads: " + (end - start) + " millis"));
        ConcurrentMapOpsTest.assertEquals((Object)new LongRef(numRuns * numThreads), (Object)this.refCounter);
        ConcurrentMapOpsTest.doGC();
        for (int i = 0; i < numThreads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (Exception e) {
                ConcurrentMapOpsTest.fail("unexpected exception in join", e);
            }
        }
        ConcurrentMapOpsTest.getLogger().info((Object)"=====================================================");
        ConcurrentMapOpsTest.doGC();
    }

    private static final void awaitBarrier(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (Exception e) {
            ConcurrentMapOpsTest.fail("unexpected exception in barrier await", e);
        }
    }

    private static void doGC() {
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            ConcurrentMapOpsTest.fail("unexepected exception in sleep", e);
        }
        System.gc();
        System.runFinalization();
    }

    public static class LongRef {
        long v;

        public LongRef(long v) {
            this.v = v;
        }

        public final long getLong() {
            return this.v;
        }

        public boolean equals(Object o) {
            if (o instanceof LongRef) {
                LongRef lr = (LongRef)o;
                return this.v == lr.v;
            }
            return false;
        }

        public int hashCode() {
            int hi = (int)(this.v >>> 32);
            int lo = (int)(this.v & 0xFFFFFFFFFFFFFFFFL);
            return hi ^ lo;
        }

        public String toString() {
            return "LongRef=" + this.v;
        }
    }
}

