/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdManagementTestBase;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.Serializable;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.junit.Test;

public class InternalManagementServiceDUnit
extends GfxdManagementTestBase {
    private static final String GROUP1_NAME = InternalManagementServiceDUnit.class.getSimpleName() + "_Group1";
    private static final String GROUP2_NAME = InternalManagementServiceDUnit.class.getSimpleName() + "_Group2";
    static final String CREATE_TABLE_SQL = "CREATE TABLE APP.BOOKS (ID VARCHAR(10) NOT NULL, NAME VARCHAR(25), TAG VARCHAR(25), SIZE BIGINT, LOCATION VARCHAR(25), CONSTRAINT BOOK_PK PRIMARY KEY (ID) )";
    static final String DROP_TABLE_SQL = "DROP TABLE APP.BOOKS;";

    public InternalManagementServiceDUnit(String name) {
        super(name);
    }

    @Test
    public void testGfxdMemberMBeanCreation() throws Exception {
        this.startServerVMs(1, 0, GROUP1_NAME + "," + GROUP2_NAME);
        VM vm = Host.getHost((int)0).getVM(0);
        String memberNameOrId = (String)vm.invoke(InternalManagementServiceDUnit.class, "verifyMemberMBeanCreation");
        this.stopVMNum(-1);
        vm.invoke(InternalManagementServiceDUnit.class, "verifyMemberMBeanCleanUp", new Object[]{memberNameOrId});
    }

    static String verifyMemberMBeanCreation() {
        String memberNameOrId;
        ObjectName memberObjectNamePattern;
        MBeanServer mBeanServer = MBeanJMXAdapter.getMBeanServer();
        Set<ObjectInstance> queryMBeans = mBeanServer.queryMBeans(memberObjectNamePattern = InternalManagementServiceDUnit.getMemberObjectNamePattern(memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)Misc.getDistributedSystem().getDistributedMember())), null);
        InternalManagementServiceDUnit.assertTrue((String)"Gfxd Member MBean didn't get created.", (!queryMBeans.isEmpty() ? 1 : 0) != 0);
        return memberNameOrId;
    }

    static void verifyMemberMBeanCleanUp(String memberNameOrId) {
        MBeanServer mBeanServer = MBeanJMXAdapter.getMBeanServer();
        Set<ObjectInstance> queryMBeans = mBeanServer.queryMBeans(InternalManagementServiceDUnit.getMemberObjectNamePattern(memberNameOrId), null);
        InternalManagementServiceDUnit.assertTrue((String)"Gfxd Member MBean didn't get unregistered.", (boolean)queryMBeans.isEmpty());
        queryMBeans = mBeanServer.queryMBeans(InternalManagementServiceDUnit.getObjectName("GemFireXD:*"), null);
        InternalManagementServiceDUnit.assertTrue((String)"All Gfxd MBeans didn't get unregistered.", (boolean)queryMBeans.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testMemoryAnalyticsQueryInterval() throws Exception {
        block11: {
            boolean serverStarted = false;
            boolean tableCreated = false;
            InternalManagementServiceDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                public void run() {
                    System.setProperty("gemfirexd.tableAnalyticsUpdateIntervalSeconds", "30");
                }
            });
            try {
                this.startServerVMs(1, 0, GROUP1_NAME + "," + GROUP2_NAME);
                serverStarted = true;
                final VM vm = Host.getHost((int)0).getVM(0);
                long lastUpdateTime = (Long)vm.invoke(InternalManagementServiceDUnit.class, "getMemoryAnalyticsQueryTime");
                InternalManagementServiceDUnit.assertFalse((String)"TableMBeanBridge updater is not initialized yet.", (-2L == lastUpdateTime ? 1 : 0) != 0);
                InternalManagementServiceDUnit.assertEquals((String)"Without any updatable TableMBeanBridge lastUpdateTime should be -1.", (long)-1L, (long)lastUpdateTime);
                int updateRate = (Integer)vm.invoke(InternalManagementServiceDUnit.class, "getUpdateSchedulerRate");
                InternalManagementServiceDUnit.assertFalse((String)"UpdateScheduler is not initalized.", (-2 == updateRate ? 1 : 0) != 0);
                this.serverSQLExecute(1, CREATE_TABLE_SQL);
                tableCreated = true;
                InternalManagementServiceDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                    public String description() {
                        return "Waiting for TableMBeanBridge lastUpdateTime to get updated";
                    }

                    public boolean done() {
                        long returnedLastUpdateTime = (Long)vm.invoke(InternalManagementServiceDUnit.class, "getMemoryAnalyticsQueryTime");
                        boolean done = -1L != returnedLastUpdateTime;
                        return done;
                    }
                }, (long)(updateRate * 4), (long)1000L, (boolean)true);
                lastUpdateTime = (Long)vm.invoke(InternalManagementServiceDUnit.class, "getMemoryAnalyticsQueryTime");
                InternalManagementServiceDUnit.assertFalse((String)"TableMBeanBridge lastUpdateTime should not be -1.", (-1L == lastUpdateTime ? 1 : 0) != 0);
                long latestUpdateTime = lastUpdateTime;
                do {
                    this.sleep(updateRate);
                } while ((latestUpdateTime = ((Long)vm.invoke(InternalManagementServiceDUnit.class, "getMemoryAnalyticsQueryTime")).longValue()) == lastUpdateTime);
                long timeBetweenUpdates = latestUpdateTime - lastUpdateTime;
                this.getLogWriter().info((Object)("MemoryAnalyticsQueryInterval:: latestUpdateTime=" + latestUpdateTime + ",lastUpdateTime=" + lastUpdateTime + ". Diff(millis): " + timeBetweenUpdates));
                InternalManagementServiceDUnit.assertTrue((String)"MemoryAnalytics Query is running more frequent than expected.", (timeBetweenUpdates >= 600L ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                block12: {
                    try {
                        if (tableCreated) {
                            this.serverSQLExecute(1, DROP_TABLE_SQL);
                        }
                        if (!serverStarted) break block12;
                    }
                    catch (Throwable throwable2) {
                        if (serverStarted) {
                            this.stopVMNum(-1);
                        }
                        InternalManagementServiceDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                            public void run() {
                                System.clearProperty("gemfirexd.tableAnalyticsUpdateIntervalSeconds");
                            }
                        });
                        throw throwable2;
                    }
                    this.stopVMNum(-1);
                }
                InternalManagementServiceDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            try {
                if (tableCreated) {
                    this.serverSQLExecute(1, DROP_TABLE_SQL);
                }
                if (!serverStarted) break block11;
            }
            catch (Throwable throwable) {
                if (serverStarted) {
                    this.stopVMNum(-1);
                }
                InternalManagementServiceDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            this.stopVMNum(-1);
        }
        InternalManagementServiceDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static long getMemoryAnalyticsQueryTime() {
        GemFireStore bootedInstance = GemFireStore.getBootedInstance();
        InternalManagementServiceDUnit.assertNotNull((String)"GemFireStore is booted instance is null.", (Object)bootedInstance);
        InternalManagementService internalMS = InternalManagementService.getInstance((GemFireStore)bootedInstance);
        return internalMS.getLastMemoryAnalyticsQueryTime();
    }

    static int getUpdateSchedulerRate() {
        GemFireStore bootedInstance = GemFireStore.getBootedInstance();
        InternalManagementServiceDUnit.assertNotNull((String)"GemFireStore is booted instance is null.", (Object)bootedInstance);
        InternalManagementService internalMS = InternalManagementService.getInstance((GemFireStore)bootedInstance);
        return internalMS.getUpdateSchedulerRate();
    }

    public void testUnregisterByPattern() throws Exception {
        this.startServerVMs(1, 0, GROUP1_NAME + "," + GROUP2_NAME);
        VM vm = Host.getHost((int)0).getVM(0);
        ObjectName emp1 = (ObjectName)vm.invoke(InternalManagementServiceDUnit.class, "addEmployee", new Object[]{"DIV01", "Employee01_01"});
        ObjectName emp2 = (ObjectName)vm.invoke(InternalManagementServiceDUnit.class, "addEmployee", new Object[]{"DIV01", "Employee01_02"});
        ObjectName emp3 = (ObjectName)vm.invoke(InternalManagementServiceDUnit.class, "addEmployee", new Object[]{"DIV02", "Employee02_03"});
        ObjectName emp4 = (ObjectName)vm.invoke(InternalManagementServiceDUnit.class, "addEmployee", new Object[]{"DIV03", "Employee03_04"});
        Exception expectedException = null;
        try {
            vm.invoke(InternalManagementServiceDUnit.class, "addEmployee", new Object[]{"DIV01", "Employee01_01"});
        }
        catch (Exception e) {
            expectedException = e;
            this.getLogWriter().info((Object)e);
        }
        InternalManagementServiceDUnit.assertNotNull((String)"Expected an exception on re-registration of employee MBean.", (Object)expectedException);
        Exception unexpectedException = null;
        try {
            vm.invoke(InternalManagementServiceDUnit.class, "removeEmployee", new Object[]{emp1});
            vm.invoke(InternalManagementServiceDUnit.class, "addEmployee", new Object[]{"DIV01", "Employee01_01"});
        }
        catch (Exception e) {
            unexpectedException = e;
            this.getLogWriter().info((Object)e);
        }
        InternalManagementServiceDUnit.assertNull((String)"Unexpected exception on re-registration of employee MBean.", (Object)unexpectedException);
        vm.invoke(InternalManagementServiceDUnit.class, "removeAllEmployees");
        this.stopVMNum(-1);
    }

    static ObjectName addEmployee(String uid, String employeeId) {
        InternalManagementService ims = InternalManagementService.getInstance((GemFireStore)GemFireStore.getBootedInstance());
        InternalManagementServiceDUnit.assertNotNull((String)"InternalManagementService not found.", (Object)ims);
        EmployeeMBean employeeMBean = new EmployeeMBean(uid, employeeId);
        ObjectName registeredMBean = ims.registerMBean((Object)employeeMBean, InternalManagementServiceDUnit.getEmployeeObjectName(uid, employeeId));
        InternalManagementServiceDUnit.assertNotNull((String)"registeredMBean is null.", (Object)registeredMBean);
        return registeredMBean;
    }

    static void removeEmployee(ObjectName employeeMBeanName) {
        InternalManagementService ims = InternalManagementService.getInstance((GemFireStore)GemFireStore.getBootedInstance());
        EmployeeMBean employeeMBean = (EmployeeMBean)ims.getMBeanInstance(employeeMBeanName, EmployeeMBean.class);
        InternalManagementServiceDUnit.assertNotNull((String)"InternalManagementService not found.", (Object)ims);
        ims.unregisterMBean(InternalManagementServiceDUnit.getEmployeeObjectName(employeeMBean.getDivision(), employeeMBean.getEmployeeId()));
    }

    static void removeAllEmployees() {
        InternalManagementService ims = InternalManagementService.getInstance((GemFireStore)GemFireStore.getBootedInstance());
        InternalManagementServiceDUnit.assertNotNull((String)"InternalManagementService not found.", (Object)ims);
        ObjectName employeesPattern = InternalManagementServiceDUnit.getEmployeeObjectName("*", "*");
        Set unregisteredMBeans = ims.unregisterMBeanByPattern(employeesPattern);
        InternalManagementServiceDUnit.assertTrue((String)"No MBeans unregstered", (!unregisteredMBeans.isEmpty() ? 1 : 0) != 0);
        InternalManagementServiceDUnit.getGlobalLogger().info((Object)("Unregstered MBeans " + unregisteredMBeans));
    }

    static ObjectName getEmployeeObjectName(String uid, String employeeId) {
        return MBeanJMXAdapter.getObjectName((String)("GemFireXD:type=Employee,uid=" + uid + ",eid=" + employeeId));
    }

    public static class EmployeeMBean
    implements EmployeeMXBean,
    Serializable {
        private String employeeId;
        private String division;
        private double salary;

        EmployeeMBean(String division, String employeeId) {
            this.division = division;
            this.employeeId = employeeId;
            this.salary = 1000.0;
        }

        @Override
        public String getDivision() {
            return this.division;
        }

        @Override
        public String getEmployeeId() {
            return this.employeeId;
        }

        @Override
        public double calculateBonus(Double performanceIndex) {
            return this.salary * performanceIndex / 100.0;
        }

        @Override
        public void paySalary(boolean withBouns, double bonusPercent) {
            if (withBouns) {
                System.out.println("Paying " + this.salary + " with bonus " + this.calculateBonus(bonusPercent));
            } else {
                System.out.println("Paying " + this.salary);
            }
        }

        @Override
        public void updateSalary(Double salary) {
            this.salary = salary;
        }
    }

    public static interface EmployeeMXBean {
        public String getDivision();

        public String getEmployeeId();

        public double calculateBonus(Double var1);

        public void paySalary(boolean var1, double var2);

        public void updateSalary(Double var1);
    }
}

