/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class GfxdManagementTestBase
extends DistributedSQLTestBase {
    private JMXConnector connector;

    public GfxdManagementTestBase(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return LogWriterImpl.levelToString((int)500);
    }

    public static JMXServiceURL getJMXServiceURL(String managerJmxBindAddress, int managerJmxPort) {
        JMXServiceURL url = null;
        try {
            url = new JMXServiceURL(MessageFormat.format("service:jmx:rmi://{0}/jndi/rmi://{0}:{1}/jmxrmi", managerJmxBindAddress, "" + managerJmxPort));
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }

    public MBeanServerConnection startJmxClient(String managerJmxBindAddress, int managerJmxPort) throws IOException {
        this.connector = JMXConnectorFactory.connect(GfxdManagementTestBase.getJMXServiceURL(managerJmxBindAddress, managerJmxPort));
        return this.connector.getMBeanServerConnection();
    }

    public void stopJmxClient() throws IOException {
        if (this.connector != null) {
            this.connector.close();
        }
    }

    public static ConnectionEndpoint retrieveJmxHostPort() {
        try {
            DistributionConfig config = Misc.getDistributedSystem().getConfig();
            return new ConnectionEndpoint(config.getJmxManagerBindAddress(), config.getJmxManagerPort());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.stopJmxClient();
        this.connector = null;
        super.tearDown2();
    }

    protected static ObjectName getObjectName(String objectNameString) {
        return MBeanJMXAdapter.getObjectName((String)objectNameString);
    }

    protected static String getMemberNameOrId() {
        return MBeanJMXAdapter.getMemberNameOrId((DistributedMember)Misc.getDistributedSystem().getDistributedMember());
    }

    protected static ObjectName getMemberObjectNamePattern() {
        return GfxdManagementTestBase.getMemberObjectNamePattern(GfxdManagementTestBase.getMemberNameOrId());
    }

    protected static ObjectName getMemberObjectNamePattern(String memberNameOrId) {
        return ManagementUtils.getMemberMBeanNamePattern((String)memberNameOrId);
    }

    protected static void logInfo(String statementToLog) {
        LogWriterI18n loggerI18n = InternalDistributedSystem.getLoggerI18n();
        if (loggerI18n != null) {
            loggerI18n.convertToLogWriter().info(statementToLog);
        } else {
            System.out.println(statementToLog);
        }
    }

    protected static void logFine(String statementToLog) {
        LogWriterI18n loggerI18n = InternalDistributedSystem.getLoggerI18n();
        if (loggerI18n != null) {
            loggerI18n.convertToLogWriter().fine(statementToLog);
        } else {
            System.out.println(statementToLog);
        }
    }

    protected static class ConnectionEndpoint
    implements Serializable {
        private static final long serialVersionUID = 4850423084173302704L;
        public String host;
        public int port;

        public ConnectionEndpoint(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }
}

