/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.StatementMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdManagementTestBase;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.management.impl.StatementMBean;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.VM;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class StatementMBeanDUnit
extends GfxdManagementTestBase {
    static final String QNNumTimesCompiled = "QNNumTimesCompiled";
    static final String QNNumExecutions = "QNNumExecutions";
    static final String QNNumExecutionsInProgress = "QNNumExecutionsInProgress";
    static final String QNNumTimesGlobalIndexLookup = "QNNumTimesGlobalIndexLookup";
    static final String QNNumRowsModified = "QNNumRowsModified";
    static final String QNParseTime = "QNParseTime";
    static final String QNBindTime = "QNBindTime";
    static final String QNOptimizeTime = "QNOptimizeTime";
    static final String QNRoutingInfoTime = "QNRoutingInfoTime";
    static final String QNGenerateTime = "QNGenerateTime";
    static final String QNTotalCompilationTime = "QNTotalCompilationTime";
    static final String QNExecuteTime = "QNExecuteTime";
    static final String QNProjectionTime = "QNProjectionTime";
    static final String QNTotalExecutionTime = "QNTotalExecutionTime";
    static final String QNRowsModificationTime = "QNRowsModificationTime";
    static final String DNNumProjectedRows = "DNNumProjectedRows";
    static final String NumNLJoinRowsReturned = "NumNLJoinRowsReturned";
    static final String NumHASHJoinRowsReturned = "NumHASHJoinRowsReturned";
    static final String DNNumTableRowsScanned = "DNNumTableRowsScanned";
    static final String DNSubQueryNumRowsSeen = "DNSubQueryNumRowsSeen";
    static final String DNSubQueryExecutionTime = "DNSubQueryExecutionTime";
    static final String DNNumTimesCompiled = "DNNumTimesCompiled";
    static final String DNNumExecution = "DNNumExecution";
    static final String DNNumExecutionsInProgress = "DNNumExecutionsInProgress";
    static final String DNNumTimesGlobalIndexLookup = "DNNumTimesGlobalIndexLookup";
    static final String DNNumRowsModified = "DNNumRowsModified";
    static final String DNParseTime = "DNParseTime";
    static final String DNBindTime = "DNBindTime";
    static final String DNOptimizeTime = "DNOptimizeTime";
    static final String DNRoutingInfoTime = "DNRoutingInfoTime";
    static final String DNGenerateTime = "DNGenerateTime";
    static final String DNTotalCompilationTime = "DNTotalCompilationTime";
    static final String DNExecutionTime = "DNExecutionTime";
    static final String DNProjectionTime = "DNProjectionTime";
    static final String DNTotalExecutionTime = "DNTotalExecutionTime";
    static final String DNRowsModificationTime = "DNRowsModificationTime";
    static final String QNNumRowsSeen = "QNNumRowsSeen";
    static final String QNMsgSendTime = "QNMsgSendTime";
    static final String QNMsgSerTime = "QNMsgSerTime";
    static final String QNRespDeSerTime = "QNRespDeSerTime";
    private static final long serialVersionUID = 1L;
    static final String grp1 = "GRP1";
    static final String grp2 = "GRP2";
    static final String grp3 = "GRP3";
    static final int numberOfInserts = 500;
    static final int numberOfDeletes = 100;
    static final String SCHEMA = "TRADE";
    static final String TABLE = "CUSTOMERS";
    static final String POLICY = "REPLICATE";
    static final String column1 = "CID";
    static final String column2 = "CUST_NAME";
    static final String column3 = "SINCE";
    static final String column4 = "ADDR";
    static final String column5 = "TID";
    static final String PERSISTENCE_SCHEME = "SYNCHRONOUS";
    private static List<String> grps = new ArrayList<String>();
    static final String statemetTextForReplicatedTable = "create table TRADE.CUSTOMERS (CID int not null, CUST_NAME varchar(100), SINCE date, ADDR varchar(100), TID int ) REPLICATE PERSISTENT SYNCHRONOUS";
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public StatementMBeanDUnit(String name) {
        super(name);
        grps.add(grp1);
        grps.add(grp2);
        grps.add("DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatementstats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            this.startServerVMs(1, 0, grp1, serverInfo);
            serverInfo.setProperty("jmx-manager", "true");
            serverInfo.setProperty("jmx-manager-start", "true");
            serverInfo.setProperty("jmx-manager-port", "0");
            this.startServerVMs(1, 0, grp2, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, grp3, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            this.createTableForVerification(conn, true, 1);
            conn.close();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    private void createTableForVerification(Connection conn, boolean enableStats, int numTimesSampled) throws Exception {
        VM serverVM = (VM)this.serverVMs.get(1);
        Statement stmt = conn.createStatement();
        String createSchemaOrder = "create schema TRADE";
        stmt.execute("create schema TRADE");
        stmt.execute(statemetTextForReplicatedTable);
        PreparedStatement psInsertCust = conn.prepareStatement("insert into TRADE.CUSTOMERS values (?,?,?,?,?)");
        for (int i = 0; i < 500; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            Date since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        PreparedStatement psInsertCust2 = conn.prepareStatement("delete from TRADE.CUSTOMERS where CID = ?");
        for (int i = 0; i < 100; ++i) {
            psInsertCust2.setInt(1, i);
            psInsertCust2.executeUpdate();
        }
        String stmtId = ((EmbedStatement)stmt).getStatementStats().getStatsId();
        serverVM.invoke(((Object)((Object)this)).getClass(), "verifyStatementMbean", new Object[]{stmtId});
        psInsertCust.close();
        psInsertCust2.close();
        stmt.close();
        StatementMBeanDUnit.logInfo("done verifyTableMbeans");
    }

    public static void verifyStatementMbean(String stmtId) {
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        InternalDistributedMember member = cache.getDistributedSystem().getDistributedMember();
        String memberName = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)member);
        InternalDistributedSystem dsys = InternalDistributedSystem.getConnectedInstance();
        StatisticsType st = dsys.findType("StatementStats");
        Statistics[] statsFromDS = dsys.findStatisticsByType(st);
        final ObjectName statementObjectName = ManagementUtils.getStatementMBeanName((String)memberName, (String)stmtId);
        StatementMBeanDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the statement Mbean to get reflected at managing node";
            }

            public boolean done() {
                StatementMXBean bean = (StatementMXBean)service.getMBeanInstance(statementObjectName, StatementMXBean.class);
                boolean done = bean != null;
                return done;
            }
        }, (long)8000L, (long)500L, (boolean)true);
        StatementMBean statementMBean = (StatementMBean)service.getMBeanInstance(statementObjectName, StatementMXBean.class);
        for (Statistics stat : statsFromDS) {
            if (!stat.getTextId().equals(stmtId)) continue;
            Number valueFromStats = 0;
            valueFromStats = stat.get(DNBindTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNBindTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNBindTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNBindTime());
            valueFromStats = stat.get(DNGenerateTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNGenerateTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNGenerateTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNGenerateTime());
            valueFromStats = stat.get(DNNumExecutionsInProgress);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNNumExecutionsInProgress stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNNumExecutionsInProgress());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNNumExecutionsInProgress());
            valueFromStats = stat.get(DNNumRowsModified);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNNumRowsModified stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNNumRowsModified());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNNumRowsModified());
            valueFromStats = stat.get(DNNumTimesCompiled);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNNumTimesCompiled stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNNumTimesCompiled());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNNumTimesCompiled());
            valueFromStats = stat.get(DNNumTimesGlobalIndexLookup);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNNumTimesGlobalIndexLookup stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNNumTimesGlobalIndexLookup());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNNumTimesGlobalIndexLookup());
            valueFromStats = stat.get(DNOptimizeTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNOptimizeTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNOptimizeTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNOptimizeTime());
            valueFromStats = stat.get(DNParseTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNParseTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNParseTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNParseTime());
            valueFromStats = stat.get(DNProjectionTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNProjectionTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNProjectionTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNProjectionTime());
            valueFromStats = stat.get(DNRoutingInfoTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNRoutingInfoTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNRoutingInfoTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNRoutingInfoTime());
            valueFromStats = stat.get(DNRowsModificationTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNRowsModificationTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNRowsModificationTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNRowsModificationTime());
            valueFromStats = stat.get(DNTotalCompilationTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNTotalCompilationTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNTotalCompilationTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNTotalCompilationTime());
            valueFromStats = stat.get(DNTotalExecutionTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNTotalExecutionTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getDNTotalExecutionTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getDNTotalExecutionTime());
            valueFromStats = stat.get(QNBindTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNBindTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNBindTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNBindTime());
            valueFromStats = stat.get(QNExecuteTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNExecuteTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNExecuteTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNExecuteTime());
            valueFromStats = stat.get(QNGenerateTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNGenerateTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNGenerateTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNGenerateTime());
            valueFromStats = stat.get(QNMsgSendTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNMsgSendTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNMsgSendTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNMsgSendTime());
            valueFromStats = stat.get(QNMsgSerTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNMsgSerTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNMsgSerTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNMsgSerTime());
            valueFromStats = stat.get(QNNumExecutions);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNNumExecutions stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNNumExecutions());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNNumExecutions());
            valueFromStats = stat.get(QNNumExecutionsInProgress);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNNumExecutionsInProgress stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNNumExecutionsInProgress());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNNumExecutionsInProgress());
            valueFromStats = stat.get(QNNumRowsModified);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNNumRowsModified stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNNumRowsModified());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNNumRowsModified());
            valueFromStats = stat.get(QNNumRowsSeen);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNNumRowsSeen stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNNumRowsSeen());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNNumRowsSeen());
            valueFromStats = stat.get(QNNumTimesCompiled);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNNumTimesCompiled stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNNumTimesCompiled());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNNumTimesCompiled());
            valueFromStats = stat.get(QNNumTimesGlobalIndexLookup);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNNumTimesGlobalIndexLookup stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNNumTimesGlobalIndexLookup());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNNumTimesGlobalIndexLookup());
            valueFromStats = stat.get(QNOptimizeTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNOptimizeTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNOptimizeTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNOptimizeTime());
            valueFromStats = stat.get(QNParseTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNParseTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNParseTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNParseTime());
            valueFromStats = stat.get(QNProjectionTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNProjectionTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNProjectionTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNProjectionTime());
            valueFromStats = stat.get(QNRespDeSerTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=QNRespDeSerTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getQNRespDeSerTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getQNRespDeSerTime());
            valueFromStats = stat.get(DNNumProjectedRows);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNNumProjectedRows stats value==" + valueFromStats + " from mbean==" + statementMBean.getNumProjectedRows());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getNumProjectedRows());
            valueFromStats = stat.get(DNNumTableRowsScanned);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNNumTableRowsScanned stats value==" + valueFromStats + " from mbean==" + statementMBean.getNumTableRowsScanned());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getNumTableRowsScanned());
            valueFromStats = stat.get(DNSubQueryNumRowsSeen);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNSubQueryNumRowsSeen stats value==" + valueFromStats + " from mbean==" + statementMBean.getSubQueryNumRowsSeen());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getSubQueryNumRowsSeen());
            valueFromStats = stat.get(DNSubQueryExecutionTime);
            StatementMBeanDUnit.logInfo("verifyStatementMbean attr=DNSubQueryExecutionTime stats value==" + valueFromStats + " from mbean==" + statementMBean.getSubQueryExecutionTime());
            StatementMBeanDUnit.assertEquals((long)valueFromStats.longValue(), (long)statementMBean.getSubQueryExecutionTime());
            break;
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

