/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import javax.management.MBeanServer;
import junit.framework.TestCase;

public class PRRegionReadWriteStatsDUnit
extends DistributedSQLTestBase {
    private static final long serialVersionUID = 1L;
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public PRRegionReadWriteStatsDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateStatsNonTxn() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            serverInfo.setProperty("server-groups", "MYGROUP");
            this.startServerVMs(1, 0, null, serverInfo);
            this.startServerVMs(1, 0, null, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, null, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            conn.setTransactionIsolation(0);
            conn.setAutoCommit(false);
            this.createTable(conn);
            this.insertRow(conn);
            PRRegionReadWriteStatsDUnit.validatePutStats(2);
            conn.close();
            for (VM vm : this.serverVMs) {
                this.validatePutStats(vm, false, 1);
            }
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateStatsTxn() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            serverInfo.setProperty("server-groups", "MYGROUP");
            this.startServerVMs(1, 0, null, serverInfo);
            this.startServerVMs(1, 0, null, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, null, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            conn.setTransactionIsolation(1);
            conn.setAutoCommit(false);
            this.createTable(conn);
            this.insertRowWithTxn(conn);
            Thread.sleep(2000L);
            PRRegionReadWriteStatsDUnit.validatePutStats(0);
            for (VM vm : this.serverVMs) {
                this.validatePutStats(vm, true, 1);
            }
            conn.close();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateStatsTxn() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            serverInfo.setProperty("server-groups", "MYGROUP");
            this.startServerVMs(1, 0, null, serverInfo);
            this.startServerVMs(1, 0, null, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, null, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            conn.setTransactionIsolation(1);
            conn.setAutoCommit(false);
            this.createTable(conn);
            this.insertRowWithTxn(conn);
            this.updateRowWithTxn(conn);
            Thread.sleep(2000L);
            PRRegionReadWriteStatsDUnit.validatePutStats(0);
            for (VM vm : this.serverVMs) {
                this.validatePutStats(vm, true, 2);
            }
            conn.close();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetConvertibleQueryStats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            serverInfo.setProperty("server-groups", "MYGROUP");
            this.startServerVMs(1, 0, null, serverInfo);
            this.startServerVMs(1, 0, null, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, null, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            conn.setTransactionIsolation(1);
            this.createTable(conn);
            this.insertRowWithTxn(conn);
            this.queryRowWithPrimaryKey(conn);
            Thread.sleep(2000L);
            PRRegionReadWriteStatsDUnit.validateGetStats(2);
            conn.close();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IGNORE_testGetAllConvertibleQueryStats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            serverInfo.setProperty("server-groups", "MYGROUP");
            this.startServerVMs(1, 0, null, serverInfo);
            this.startServerVMs(1, 0, null, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, null, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            this.createTable(conn);
            this.insertRowWithTxn(conn);
            this.queryRowWithPrimaryKeyWithIN(conn);
            Thread.sleep(2000L);
            PRRegionReadWriteStatsDUnit.validateGetStats(2);
            conn.close();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
        }
    }

    protected static void validatePutStats(int expectedVal) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Region r = cache.getRegion("/TRADE/CUSTOMERS");
        PRRegionReadWriteStatsDUnit.assertNotNull((Object)r);
        assert (r instanceof PartitionedRegion);
        PartitionedRegion parRegion = (PartitionedRegion)r;
        int val = parRegion.getPrStats().getStats().get("createsCompleted").intValue();
        PRRegionReadWriteStatsDUnit.assertEquals((int)val, (int)expectedVal);
    }

    protected static void validateGetStats(int expectedVal) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Region r = cache.getRegion("/TRADE/CUSTOMERS");
        PRRegionReadWriteStatsDUnit.assertNotNull((Object)r);
        assert (r instanceof PartitionedRegion);
        PartitionedRegion parRegion = (PartitionedRegion)r;
        int val = parRegion.getPrStats().getStats().get("getsCompleted").intValue();
        PRRegionReadWriteStatsDUnit.assertEquals((int)expectedVal, (int)val);
        Region r1 = cache.getRegion("/TRADE/PROSPECTIVES");
        assert (r1 instanceof DistributedRegion);
        LocalRegion lRegion = (LocalRegion)r1;
        val = lRegion.getCachePerfStats().getStats().get("gets").intValue();
        PRRegionReadWriteStatsDUnit.assertEquals((int)expectedVal, (int)val);
    }

    protected void validatePutStats(VM vm, final boolean isTxn, final int expectedVal) {
        SerializableRunnable validatePutStats = new SerializableRunnable("Validate Put Stats"){

            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Region r = cache.getRegion("/TRADE/CUSTOMERS");
                TestCase.assertNotNull((Object)r);
                assert (r instanceof PartitionedRegion);
                PartitionedRegion parRegion = (PartitionedRegion)r;
                int actualVal = parRegion.getPrStats().getStats().get("putsCompleted").intValue();
                if (isTxn) {
                    TestCase.assertEquals((int)expectedVal, (int)actualVal);
                } else {
                    TestCase.assertEquals((int)0, (int)actualVal);
                }
            }
        };
        vm.invoke((Runnable)validatePutStats);
    }

    protected void validateGetStats(VM vm, final int expectedVal) {
        SerializableRunnable validatePutStats = new SerializableRunnable("Validate Put Stats"){

            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Region r = cache.getRegion("/TRADE/CUSTOMERS");
                TestCase.assertNotNull((Object)r);
                assert (r instanceof PartitionedRegion);
                PartitionedRegion parRegion = (PartitionedRegion)r;
                int actualVal = parRegion.getPrStats().getStats().get("getsCompleted").intValue();
                TestCase.assertEquals((int)expectedVal, (int)actualVal);
            }
        };
        vm.invoke((Runnable)validatePutStats);
    }

    private void createTable(Connection conn) throws Exception {
        Statement stmt = conn.createStatement();
        String createSchemaOrder = "create schema trade";
        stmt.execute("create schema trade");
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))  PARTITION BY primary key SERVER GROUPS (MYGROUP)");
        stmt.execute("create table trade.prospectives (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))  REPLICATE SERVER GROUPS (MYGROUP)");
        stmt.close();
    }

    private void insertRow(Connection conn) throws Exception {
        int i;
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        Date since = new Date(System.currentTimeMillis());
        for (i = 0; i < 2; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        psInsertCust = conn.prepareStatement("insert into trade.prospectives values (?,?,?,?,?)");
        for (i = 0; i < 2; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        psInsertCust.close();
    }

    private void insertRowWithTxn(Connection conn) throws Exception {
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        Date since = new Date(System.currentTimeMillis());
        for (int i = 0; i < 2; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        conn.commit();
        psInsertCust.close();
    }

    private void updateRowWithTxn(Connection conn) throws Exception {
        PreparedStatement psUpdateCust = conn.prepareStatement("update trade.customers set addr=? where cid=?");
        for (int i = 0; i < 2; ++i) {
            psUpdateCust.setString(1, "YYYY" + i);
            psUpdateCust.setInt(2, i);
            psUpdateCust.executeUpdate();
        }
        conn.commit();
        psUpdateCust.close();
    }

    private void queryRowWithPrimaryKey(Connection conn) throws Exception {
        ResultSet rs;
        int i;
        PreparedStatement psSelectCust = conn.prepareStatement("select addr from trade.customers where cid=?");
        for (i = 0; i < 2; ++i) {
            psSelectCust.setInt(1, i);
            rs = psSelectCust.executeQuery();
            rs.next();
        }
        psSelectCust = conn.prepareStatement("select addr from trade.prospectives where cid=?");
        for (i = 0; i < 2; ++i) {
            psSelectCust.setInt(1, i);
            rs = psSelectCust.executeQuery();
            rs.next();
        }
        conn.commit();
        psSelectCust.close();
    }

    private void queryRowWithPrimaryKeyWithIN(Connection conn) throws Exception {
        PreparedStatement psSelectCust = conn.prepareStatement("select addr from trade.customers where cid in(?,?)");
        psSelectCust.setInt(1, 1);
        psSelectCust.setInt(2, 2);
        ResultSet rs = psSelectCust.executeQuery();
        rs.next();
        psSelectCust.close();
    }
}

