/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.RegionMXBean;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.VM;
import java.io.File;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Callable;

public class HDFSRegionManagementDUnit
extends DistributedSQLTestBase {
    private static final long serialVersionUID = 1L;
    private static final String REGION_NAME = "/APP/BIGTABLE1";

    public HDFSRegionManagementDUnit(String name) {
        super(name);
    }

    public void testHDFSRegionCount() throws Exception {
        int i;
        Properties serverInfo = new Properties();
        serverInfo.setProperty("gemfire.enable-time-statistics", "true");
        serverInfo.setProperty("gemfirexd.tableAnalyticsUpdateIntervalSeconds", "1");
        serverInfo.setProperty("statistic-sample-rate", "100");
        serverInfo.setProperty("statistic-sampling-enabled", "true");
        this.startServerVMs(1, 0, "GRP1", serverInfo);
        VM serverVM0 = (VM)this.serverVMs.get(0);
        Properties info = new Properties();
        info.setProperty("host-data", "false");
        info.setProperty("gemfire.enable-time-statistics", "true");
        this.startClientVMs(1, 0, null, info);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
        Connection conn = TestUtil.getConnection(info);
        Statement st = conn.createStatement();
        Object rs = null;
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "' BatchTimeInterval 100 milliseconds ");
        st.execute("create table app.bigtable1 (big_id INT NOT NULL PRIMARY KEY , big_date DATE NOT NULL, big_data VARCHAR(2000)) PARTITION BY PRIMARY KEY EVICTION BY CRITERIA ( big_id < 300000 ) EVICTION FREQUENCY 180 SECONDS hdfsstore (myhdfs)");
        for (i = 0; i < 1000; ++i) {
            st.execute("insert into app.bigtable1 values (" + i + "," + "'1/2/2012'" + "," + "'XXXX')");
        }
        for (i = 0; i < 500; ++i) {
            st.execute("delete from app.bigtable1 where big_id=" + i);
        }
        HDFSRegionManagementDUnit.pause((int)10000);
        long estimate2 = (Long)serverVM0.invoke((Callable)new SerializableCallable(){

            public Object call() throws Exception {
                return HDFSRegionManagementDUnit.this.estimateRegionSize(true);
            }
        });
        st.execute("drop table app.bigtable1");
        st.execute("drop hdfsstore myhdfs");
        HDFSRegionManagementDUnit.delete(homeDirFile);
        this.stopVMNums(1, -1);
    }

    private long estimateRegionSize(boolean validate) {
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ManagementService service = ManagementService.getExistingManagementService((Cache)cache);
        RegionMXBean bean = service.getLocalRegionMBean(REGION_NAME);
        long entryCount = bean.getEntryCount();
        Region r = cache.getRegion(REGION_NAME);
        LocalRegion lr = (LocalRegion)r;
        long estimate = 0L;
        for (int i = 0; i < 11; ++i) {
            estimate = bean.getEstimatedSizeForHDFSRegion();
        }
        System.out.println(" Estimate = " + estimate);
        if (validate) {
            HDFSRegionManagementDUnit.assertTrue((estimate > 0L ? 1 : 0) != 0);
        }
        return estimate;
    }

    private void checkDirExistence(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            HDFSRegionManagementDUnit.delete(dir);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

