/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.EvictionAttributesData;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.beans.RegionMBeanCompositeDataFactory;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.diag.MemoryAnalyticsVTI;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.management.TableMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdManagementTestBase;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.management.impl.TableMBean;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import io.snappydata.test.dunit.AvailablePortHelper;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.VM;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class GfxdTableMBeanDUnit
extends GfxdManagementTestBase {
    private static final long serialVersionUID = 1L;
    static final String grp1 = "GRP1";
    static final String grp2 = "GRP2";
    static final String grp3 = "GRP3";
    static final int numberOfInserts = 10;
    static final int numberOfDeletes = 2;
    static final int numberOfUpdates = 2;
    static final String SCHEMA = "TRADE";
    static final String TABLE = "CUSTOMERS";
    static final String PARTITION_TABLE = "PARTITION_CUSTOMERS";
    static final String POLICY = "REPLICATE";
    static final String PARTITION_POLICY = "PERSISTENT_PARTITION";
    static final String PARTITION_SCHEME = "PARTITION BY PRIMARY KEY";
    static final String PERSISTENCE_SCHEME = "SYNCHRONOUS";
    static final String column1 = "CID";
    static final String column2 = "CUST_NAME";
    static final String column3 = "SINCE";
    static final String column4 = "ADDR";
    static final String column5 = "TID";
    static final String ALTER_TABLE = "ALTER_CUSTOMERS";
    static final int redundancyValue = 2;
    static final String redundancyClause = "REDUNDANCY 2";
    private static List<String> grps = new ArrayList<String>();
    static final String statemetTextForReplicatedTable = "create table TRADE.CUSTOMERS (CID int not null, CUST_NAME varchar(100), SINCE date, ADDR varchar(100), TID int ) REPLICATE SERVER GROUPS (GRP1, GRP2) PERSISTENT SYNCHRONOUS";
    static final String statemetTextForPartitionTable = "create table TRADE.PARTITION_CUSTOMERS (CID int not null, CUST_NAME varchar(100), SINCE date, ADDR varchar(100), TID int  , PRIMARY KEY (CID) ) PARTITION BY PRIMARY KEY REDUNDANCY 2 SERVER GROUPS (GRP1, GRP2) PERSISTENT SYNCHRONOUS";
    static final String statementTextForAlterTable = "create table TRADE.ALTER_CUSTOMERS (CID int not null, CUST_NAME varchar(100), SINCE date, ADDR varchar(100), TID int  ) ";
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public GfxdTableMBeanDUnit(String name) {
        super(name);
        grps.add(grp1);
        grps.add(grp2);
        grps.add("DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggregateMemberstats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("gemfirexd.tableAnalyticsUpdateIntervalSeconds", "1");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            this.startServerVMs(1, 0, grp1, serverInfo);
            serverInfo.setProperty("jmx-manager", "true");
            serverInfo.setProperty("jmx-manager-start", "true");
            serverInfo.setProperty("jmx-manager-port", "0");
            this.startServerVMs(1, 0, grp2, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            info.setProperty("gemfirexd.tableAnalyticsUpdateIntervalSeconds", "1");
            this.startClientVMs(1, 0, grp3, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            this.createTableForVerification(conn, true, 1);
            conn.close();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    private void createTableForVerification(Connection conn, boolean enableStats, int numTimesSampled) throws Exception {
        System.out.println("serverVMs= " + this.serverVMs.size());
        VM serverVM = (VM)this.serverVMs.get(1);
        Statement stmt = conn.createStatement();
        String createSchemaOrder = "create schema TRADE";
        stmt.execute("create schema TRADE");
        System.out.println("statemetTextForReplicatedTable= create table TRADE.CUSTOMERS (CID int not null, CUST_NAME varchar(100), SINCE date, ADDR varchar(100), TID int ) REPLICATE SERVER GROUPS (GRP1, GRP2) PERSISTENT SYNCHRONOUS");
        System.out.println("statemetTextForPartitionTable= create table TRADE.PARTITION_CUSTOMERS (CID int not null, CUST_NAME varchar(100), SINCE date, ADDR varchar(100), TID int  , PRIMARY KEY (CID) ) PARTITION BY PRIMARY KEY REDUNDANCY 2 SERVER GROUPS (GRP1, GRP2) PERSISTENT SYNCHRONOUS");
        System.out.println("statementTextForAlterTable= create table TRADE.ALTER_CUSTOMERS (CID int not null, CUST_NAME varchar(100), SINCE date, ADDR varchar(100), TID int  ) ");
        GfxdTableMBeanDUnit.logInfo("Executing statemetTextForReplicatedTable");
        stmt.execute(statemetTextForReplicatedTable);
        GfxdTableMBeanDUnit.logInfo("Executing statemetTextForPartitionTable");
        stmt.execute(statemetTextForPartitionTable);
        GfxdTableMBeanDUnit.logInfo("Executing statementTextForAlterTable");
        stmt.execute(statementTextForAlterTable);
        GfxdTableMBeanDUnit.logInfo("Executing psInsertCust");
        PreparedStatement psInsertCust = conn.prepareStatement("insert into TRADE.CUSTOMERS values (?,?,?,?,?)");
        for (int i = 0; i < 10; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            Date since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        GfxdTableMBeanDUnit.logInfo("Executing psDeleteCust");
        PreparedStatement psDeleteCust = conn.prepareStatement("delete from TRADE.CUSTOMERS where CID = ?");
        for (int i = 0; i < 2; ++i) {
            psDeleteCust.setInt(1, i);
            psDeleteCust.executeUpdate();
        }
        GfxdTableMBeanDUnit.logInfo("Executing psInsertPartitionCust");
        PreparedStatement psInsertPartitionCust = conn.prepareStatement("insert into TRADE.PARTITION_CUSTOMERS values (?,?,?,?,?)");
        for (int i = 0; i < 10; ++i) {
            psInsertPartitionCust.setInt(1, i);
            psInsertPartitionCust.setString(2, "XXXX" + i);
            Date since = new Date(System.currentTimeMillis());
            psInsertPartitionCust.setDate(3, since);
            psInsertPartitionCust.setString(4, "XXXX" + i);
            psInsertPartitionCust.setInt(5, i);
            psInsertPartitionCust.executeUpdate();
        }
        GfxdTableMBeanDUnit.logInfo("Executing psDeletePartition");
        PreparedStatement psDeletePartition = conn.prepareStatement("delete from TRADE.PARTITION_CUSTOMERS where CID = ?");
        for (int i = 0; i < 2; ++i) {
            psDeletePartition.setInt(1, i);
            psDeletePartition.executeUpdate();
        }
        GfxdTableMBeanDUnit.logInfo("Executing psUpdateCust");
        PreparedStatement psUpdateCust = conn.prepareStatement("update TRADE.CUSTOMERS set ADDR = 'new address' where CID >  (?)");
        for (int i = 0; i < 2; ++i) {
            psUpdateCust.setInt(1, 10 - i);
            psUpdateCust.executeUpdate();
        }
        GfxdTableMBeanDUnit.logInfo("Executing psAlterTable");
        PreparedStatement psAlterTable = conn.prepareStatement("alter table TRADE.ALTER_CUSTOMERS drop column ADDR");
        psAlterTable.executeUpdate();
        GfxdTableMBeanDUnit.logInfo("Executing verifyReplicateTableMbeans");
        serverVM.invoke(((Object)((Object)this)).getClass(), "verifyReplicateTableMbeans");
        GfxdTableMBeanDUnit.logInfo("Executing verifyPartitionTableMbeans");
        serverVM.invoke(((Object)((Object)this)).getClass(), "verifyPartitionTableMbeans");
        GfxdTableMBeanDUnit.logInfo("Executing verifyAlterTableMbeans");
        serverVM.invoke(((Object)((Object)this)).getClass(), "verifyAlterTableMbeans");
        PreparedStatement psDropTable = conn.prepareStatement("drop  table TRADE.ALTER_CUSTOMERS");
        psDropTable.executeUpdate();
        GfxdTableMBeanDUnit.logInfo("Executing verifyDropTableMbeans");
        serverVM.invoke(((Object)((Object)this)).getClass(), "verifyDropTableMbeans");
        psInsertCust.close();
        psDeleteCust.close();
        psInsertPartitionCust.close();
        psDeletePartition.close();
        psUpdateCust.close();
        psAlterTable.close();
        psDropTable.close();
        stmt.close();
        GfxdTableMBeanDUnit.logInfo("done verifyTableMbeans");
    }

    public static void verifyDropTableMbeans() {
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        GemFireCacheImpl cache = Misc.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        final ObjectName distrObjectName = ManagementUtils.getTableMBeanName((String)"DEFAULT", (String)memberNameOrId, (String)"TRADE.ALTER_CUSTOMERS");
        GfxdTableMBeanDUnit.logInfo("verifyDropTableMbeans distrObjectName=" + distrObjectName);
        GfxdTableMBeanDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the partition verifyDropTableMbeans to get reflected at managing node";
            }

            public boolean done() {
                TableMXBean bean = (TableMXBean)service.getMBeanInstance(distrObjectName, TableMXBean.class);
                boolean done = bean == null;
                return done;
            }
        }, (long)10000L, (long)500L, (boolean)false);
        GfxdTableMBeanDUnit.logInfo("verifyDropTableMbeans did not get MBean for =" + distrObjectName);
        TableMXBean bean = (TableMXBean)service.getMBeanInstance(distrObjectName, TableMXBean.class);
        GfxdTableMBeanDUnit.assertNull((Object)bean);
    }

    public static void verifyAlterTableMbeans() {
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        GemFireCacheImpl cache = Misc.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        final ObjectName distrObjectName = ManagementUtils.getTableMBeanName((String)"DEFAULT", (String)memberNameOrId, (String)"TRADE.ALTER_CUSTOMERS");
        GfxdTableMBeanDUnit.logInfo("verifyAlterTableMbeans distrObjectName=" + distrObjectName);
        GfxdTableMBeanDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the partition verifyAlterTableMbeans to get reflected at managing node";
            }

            public boolean done() {
                TableMXBean bean = (TableMXBean)service.getMBeanInstance(distrObjectName, TableMXBean.class);
                boolean done = bean != null;
                return done;
            }
        }, (long)10000L, (long)500L, (boolean)true);
        GfxdTableMBeanDUnit.logInfo("verifyPartitionTableMbeans got MBean for =" + distrObjectName);
        TableMXBean bean = (TableMXBean)service.getMBeanInstance(distrObjectName, TableMXBean.class);
        List definition = bean.getDefinition();
        GfxdTableMBeanDUnit.logInfo("verifyAlterTableMbeans From bean Name=" + definition.size() + " definition = " + definition);
        GfxdTableMBeanDUnit.assertEquals((int)definition.size(), (int)4);
        boolean colmn4Validated = false;
        for (String def : definition) {
            GfxdTableMBeanDUnit.logInfo("verifyAlterTableMbeans def=" + def);
            if (!def.contains(column4)) continue;
            colmn4Validated = true;
        }
        GfxdTableMBeanDUnit.assertFalse((boolean)colmn4Validated);
    }

    public static void verifyPartitionTableMbeans() {
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        HashSet<String> serverGroupsToUse = new HashSet<String>();
        serverGroupsToUse.add(grp1);
        serverGroupsToUse.add(grp2);
        GemFireCacheImpl cache = Misc.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        final ObjectName distrObjectName = ManagementUtils.getTableMBeanName((String)grp2, (String)memberNameOrId, (String)"TRADE.PARTITION_CUSTOMERS");
        GfxdTableMBeanDUnit.logInfo("verifyPartitionTableMbeans distrObjectName=" + distrObjectName);
        GfxdTableMBeanDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the partition tablembean to get reflected at managing node";
            }

            public boolean done() {
                TableMXBean bean = (TableMXBean)service.getMBeanInstance(distrObjectName, TableMXBean.class);
                boolean done = bean != null && bean.getDeletes() > 0;
                return done;
            }
        }, (long)10000L, (long)500L, (boolean)true);
        GfxdTableMBeanDUnit.logInfo("verifyPartitionTableMbeans got MBean for =" + distrObjectName);
        TableMXBean bean = (TableMXBean)service.getMBeanInstance(distrObjectName, TableMXBean.class);
        String statsTxtId = "RegionStats-partition-" + ((TableMBean)bean).getRegion().getName();
        GfxdTableMBeanDUnit.logInfo("partition statsTxtId=  " + statsTxtId);
        int inserts = 0;
        int updates = 0;
        int deletes = 0;
        Statistics[] regionPerfStats = cache.getDistributedSystem().findStatisticsByTextId(statsTxtId);
        if (regionPerfStats.length > 0) {
            GfxdTableMBeanDUnit.logInfo("regionPerfStats size=" + regionPerfStats.length);
            for (int i = 0; i < regionPerfStats.length && i < 5; ++i) {
                inserts = regionPerfStats[i].get("creates").intValue();
                updates = regionPerfStats[i].get("puts").intValue();
                deletes = regionPerfStats[i].get("destroys").intValue();
            }
        } else {
            GfxdTableMBeanDUnit.logInfo("verifyPartitionTableMbeans did not get regionPerfStats.  Fail the test");
            GfxdTableMBeanDUnit.fail();
        }
        GfxdTableMBeanDUnit.logInfo("From partition bean Inserts=" + bean.getInserts() + " and actual =" + inserts);
        GfxdTableMBeanDUnit.assertEquals((int)bean.getInserts(), (int)inserts);
        GfxdTableMBeanDUnit.logInfo("From partition bean updates=" + bean.getUpdates() + " and actual =" + updates);
        GfxdTableMBeanDUnit.assertEquals((int)bean.getUpdates(), (int)updates);
        GfxdTableMBeanDUnit.logInfo("From partition bean deletes=" + bean.getDeletes() + " and actual =" + deletes);
        GfxdTableMBeanDUnit.assertEquals((int)bean.getDeletes(), (int)deletes);
        GfxdTableMBeanDUnit.logInfo("From partition bean parentschema=" + bean.getParentSchema() + " and actual =" + SCHEMA);
        GfxdTableMBeanDUnit.assertEquals((String)bean.getParentSchema(), (String)SCHEMA);
        GfxdTableMBeanDUnit.logInfo("From partition bean partitioningScheme=" + bean.getPartitioningScheme() + " and actual =" + PARTITION_SCHEME);
        GfxdTableMBeanDUnit.assertEquals((String)bean.getPartitioningScheme(), (String)PARTITION_SCHEME);
        GfxdTableMBeanDUnit.logInfo("From partition bean policy=" + bean.getPolicy() + " and actual =" + PARTITION_POLICY);
        GfxdTableMBeanDUnit.assertEquals((String)bean.getPolicy(), (String)PARTITION_POLICY);
        GfxdTableMBeanDUnit.assertTrue((boolean)grps.contains(bean.getServerGroups()[0]));
        GfxdTableMBeanDUnit.assertTrue((boolean)grps.contains(bean.getServerGroups()[1]));
        GfxdTableMBeanDUnit.logInfo("From partition bean entrySize=" + bean.getEntrySize());
        GfxdTableMBeanDUnit.assertTrue((bean.getEntrySize() >= 0.0 ? 1 : 0) != 0);
        GfxdTableMBeanDUnit.logInfo("From partition bean keySize=" + bean.getKeySize());
        GfxdTableMBeanDUnit.assertTrue((bean.getKeySize() >= 0.0 ? 1 : 0) != 0);
        GfxdTableMBeanDUnit.logInfo("From partition bean Name=" + bean.getName() + " and actual =" + PARTITION_TABLE);
        GfxdTableMBeanDUnit.assertEquals((String)bean.getName(), (String)PARTITION_TABLE);
        List definition = bean.getDefinition();
        GfxdTableMBeanDUnit.logInfo("From partition bean Name=" + definition.size() + " definition = " + definition);
        GfxdTableMBeanDUnit.assertEquals((int)definition.size(), (int)5);
        boolean colmn1Validated = false;
        boolean colmn2Validated = false;
        boolean colmn3Validated = false;
        boolean colmn4Validated = false;
        boolean colmn5Validated = false;
        for (String def : definition) {
            GfxdTableMBeanDUnit.logInfo("partition def=" + def);
            if (def.contains(column1)) {
                colmn1Validated = true;
                continue;
            }
            if (def.contains(column2)) {
                colmn2Validated = true;
                continue;
            }
            if (def.contains(column3)) {
                colmn3Validated = true;
                continue;
            }
            if (def.contains(column4)) {
                colmn4Validated = true;
                continue;
            }
            if (!def.contains(column5)) continue;
            colmn5Validated = true;
        }
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn1Validated);
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn2Validated);
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn3Validated);
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn4Validated);
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn5Validated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyReplicateTableMbeans() {
        System.setProperty("gemfirexd.tableAnalyticsUpdateIntervalSeconds", "1");
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        HashSet<String> serverGroupsToUse = new HashSet<String>();
        serverGroupsToUse.add(grp1);
        serverGroupsToUse.add(grp2);
        GemFireCacheImpl cache = Misc.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        final ObjectName distrObjectName = ManagementUtils.getTableMBeanName((String)grp2, (String)memberNameOrId, (String)"TRADE.CUSTOMERS");
        GfxdTableMBeanDUnit.logInfo("verifyReplicateTableMbeans distrObjectName=" + distrObjectName);
        GfxdTableMBeanDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the tablembean to get reflected at managing node";
            }

            public boolean done() {
                TableMXBean bean = (TableMXBean)service.getMBeanInstance(distrObjectName, TableMXBean.class);
                boolean done = bean != null && bean.getInserts() == 10 && bean.getDeletes() == 2;
                return done;
            }
        }, (long)10000L, (long)500L, (boolean)true);
        GfxdTableMBeanDUnit.logInfo("verifyReplicateTableMbeans got Mbeanfor =" + distrObjectName);
        TableMXBean bean = (TableMXBean)service.getMBeanInstance(distrObjectName, TableMXBean.class);
        GfxdTableMBeanDUnit.logInfo("From replicated bean Inserts=" + bean.getInserts() + " and actual =" + 10);
        GfxdTableMBeanDUnit.assertEquals((int)bean.getInserts(), (int)10);
        GfxdTableMBeanDUnit.logInfo("From replicated bean numberOfrows=" + bean.getInserts() + " and actual =" + 8);
        GfxdTableMBeanDUnit.assertEquals((long)bean.getNumberOfRows(), (long)8L);
        GfxdTableMBeanDUnit.logInfo("From replicated bean parentschema=" + bean.getParentSchema() + " and actual =" + SCHEMA);
        GfxdTableMBeanDUnit.assertEquals((String)bean.getParentSchema(), (String)SCHEMA);
        GfxdTableMBeanDUnit.logInfo("From replicated bean partitioningScheme=" + bean.getPartitioningScheme() + " and actual =" + "NA");
        GfxdTableMBeanDUnit.assertEquals((String)bean.getPartitioningScheme(), (String)"NA");
        GfxdTableMBeanDUnit.logInfo("From replicated bean policy=" + bean.getPolicy() + " and actual =" + "PERSISTENT_REPLICATE");
        GfxdTableMBeanDUnit.assertTrue((boolean)bean.getPolicy().contains(POLICY.toUpperCase()));
        GfxdTableMBeanDUnit.assertTrue((boolean)grps.contains(bean.getServerGroups()[0]));
        GfxdTableMBeanDUnit.assertTrue((boolean)grps.contains(bean.getServerGroups()[1]));
        int inserts = 0;
        int updates = 0;
        int deletes = 0;
        String statsTxtId = "RegionStats-" + ((TableMBean)bean).getRegion().getName();
        GfxdTableMBeanDUnit.logInfo("for replicated table statsTxtId= " + statsTxtId);
        Statistics[] regionPerfStats = cache.getDistributedSystem().findStatisticsByTextId(statsTxtId);
        if (regionPerfStats.length > 0) {
            GfxdTableMBeanDUnit.logInfo("replicated regionPerfStats size=" + regionPerfStats.length);
            int i = 0;
            if (i < regionPerfStats.length) {
                inserts = regionPerfStats[i].get("creates").intValue();
                updates = regionPerfStats[i].get("puts").intValue();
                deletes = regionPerfStats[i].get("destroys").intValue();
            }
            GfxdTableMBeanDUnit.logInfo("For replciated table from regionstats inserts=" + inserts);
            GfxdTableMBeanDUnit.logInfo("For replciated table from regionstats updates=" + updates);
            GfxdTableMBeanDUnit.logInfo("For replciated table from regionstats deletes=" + deletes);
        }
        GfxdTableMBeanDUnit.logInfo("From replicated bean updates=" + bean.getUpdates() + " and actual =" + Math.abs(updates - inserts));
        GfxdTableMBeanDUnit.assertEquals((int)bean.getUpdates(), (int)Math.abs(updates - inserts));
        GfxdTableMBeanDUnit.logInfo("From replicated bean deletes=" + bean.getDeletes() + " and actual =" + 2);
        GfxdTableMBeanDUnit.assertEquals((int)bean.getDeletes(), (int)2);
        GfxdTableMBeanDUnit.logInfo("From replicated bean entrySize=" + bean.getEntrySize());
        GfxdTableMBeanDUnit.assertEquals((boolean)true, (bean.getEntrySize() >= 0.0 ? 1 : 0) != 0);
        GfxdTableMBeanDUnit.logInfo("From replicated bean keySize=" + bean.getKeySize());
        GfxdTableMBeanDUnit.assertEquals((boolean)true, (bean.getKeySize() >= 0.0 ? 1 : 0) != 0);
        GfxdTableMBeanDUnit.logInfo("From replicated bean Name=" + bean.getName() + " and actual =" + TABLE);
        GfxdTableMBeanDUnit.assertEquals((String)bean.getName(), (String)TABLE);
        List definition = bean.getDefinition();
        GfxdTableMBeanDUnit.logInfo("From replicated bean Name=" + definition.size() + " definition = " + definition);
        GfxdTableMBeanDUnit.assertEquals((int)definition.size(), (int)5);
        boolean colmn1Validated = false;
        boolean colmn2Validated = false;
        boolean colmn3Validated = false;
        boolean colmn4Validated = false;
        boolean colmn5Validated = false;
        for (String def : definition) {
            GfxdTableMBeanDUnit.logInfo("replicated def=" + def);
            if (def.contains(column1)) {
                colmn1Validated = true;
                continue;
            }
            if (def.contains(column2)) {
                colmn2Validated = true;
                continue;
            }
            if (def.contains(column3)) {
                colmn3Validated = true;
                continue;
            }
            if (def.contains(column4)) {
                colmn4Validated = true;
                continue;
            }
            if (!def.contains(column5)) continue;
            colmn5Validated = true;
        }
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn1Validated);
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn2Validated);
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn3Validated);
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn4Validated);
        GfxdTableMBeanDUnit.assertTrue((boolean)colmn5Validated);
        GfxdConnectionWrapper connWrapper = InternalManagementService.getAnyInstance().getConnectionWrapperForTEST();
        ResultSet resultSet = null;
        try {
            PreparedStatement metadataStatement = connWrapper.getConnectionOrNull().prepareStatement("<local>SELECT * FROM SYS.SYSTABLES WHERE TABLENAME=? and TABLESCHEMANAME=?");
            metadataStatement.setString(1, bean.getName());
            metadataStatement.setString(2, bean.getParentSchema());
            resultSet = metadataStatement.executeQuery();
            TableMXBean.TableMetadata tableMetadata = bean.fetchMetadata();
            String tableMetadataStr = tableMetadata.toString();
            GfxdTableMBeanDUnit.logInfo("replicated tableMetadataStr=" + tableMetadataStr);
            if (resultSet.next()) {
                TableMXBean.TableMetadata tableMetadataFromResultSet = new TableMXBean.TableMetadata(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13), resultSet.getString(14), resultSet.getString(15), resultSet.getString(16), resultSet.getString(17), resultSet.getString(18), resultSet.getString(19), resultSet.getString(20));
                GfxdTableMBeanDUnit.logInfo("replicated tableMetadataFromResultSet=" + tableMetadataFromResultSet.toString());
                GfxdTableMBeanDUnit.assertTrue((boolean)tableMetadataStr.toString().equals(tableMetadataFromResultSet.toString()));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            GfxdTableMBeanDUnit.logInfo("Exception while verifying table meta data =" + e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
            connWrapper.close();
        }
        EvictionAttributesData evictionAttributesDataFromMbean = bean.showEvictionAttributes();
        EvictionAttributesData evictionAttributesData = RegionMBeanCompositeDataFactory.getEvictionAttributesData((RegionAttributes)((TableMBean)bean).getRegion().getAttributes());
        GfxdTableMBeanDUnit.assertTrue((boolean)evictionAttributesDataFromMbean.getAction().equals(evictionAttributesData.getAction()));
        GfxdTableMBeanDUnit.assertTrue((boolean)evictionAttributesDataFromMbean.getAlgorithm().equals(evictionAttributesData.getAlgorithm()));
        GfxdTableMBeanDUnit.assertEquals((Object)evictionAttributesDataFromMbean.getMaximum(), (Object)evictionAttributesData.getMaximum());
    }

    static double getEntrySize() {
        MemoryAnalyticsVTI memoryAnalyticsVTI = new MemoryAnalyticsVTI(true);
        int entrySizeIndex = 0;
        int tableNameIndex = 0;
        try {
            ResultSetMetaData metaData = memoryAnalyticsVTI.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                if (metaData.getColumnName(i).equals("TABLE_NAME")) {
                    tableNameIndex = i;
                } else if (metaData.getColumnName(i).equals("ENTRY_SIZE")) {
                    entrySizeIndex = i;
                }
                if (entrySizeIndex != 0 && tableNameIndex != 0) break;
            }
            while (memoryAnalyticsVTI.next()) {
                try {
                    String tableName = memoryAnalyticsVTI.getString(tableNameIndex);
                    GfxdTableMBeanDUnit.logInfo("replicated mbean tableName from VTI =" + tableName);
                    if (!tableName.equals("TRADE.CUSTOMERS")) continue;
                    String entrySizeIndexStr = memoryAnalyticsVTI.getString(entrySizeIndex);
                    GfxdTableMBeanDUnit.logInfo("replicated mbean entrySizeIndexStr from VTI =" + entrySizeIndexStr);
                    return Double.parseDouble(entrySizeIndexStr);
                }
                catch (Exception e) {
                    GfxdTableMBeanDUnit.logInfo("replicated mbean exception in  memoryAnalyticsVTI =" + e);
                }
            }
        }
        catch (SQLException e) {
            GfxdTableMBeanDUnit.logInfo("Did not get memoryAnalyticsVTI " + e);
            GfxdTableMBeanDUnit.fail();
        }
        return 0.0;
    }

    private String getSqlQuery(String CREATE_TABLE_SQL, String SPACE, String partitionByClause, String policyClause, String persistenceClause, String redundancyClause) {
        return CREATE_TABLE_SQL + SPACE + (policyClause != null ? policyClause : partitionByClause) + SPACE + (redundancyClause != null ? redundancyClause : redundancyClause) + SPACE + (persistenceClause != null ? persistenceClause : persistenceClause);
    }

    static Properties getManagerConfig(boolean startManager) {
        Properties p = new Properties();
        p.setProperty("jmx-manager", "true");
        p.setProperty("jmx-manager-start", String.valueOf(startManager));
        p.setProperty("jmx-manager-port", String.valueOf(AvailablePortHelper.getRandomAvailableTCPPort()));
        return p;
    }

    static void commitTx() throws SQLException {
        Connection connection = TestUtil.jdbcConn;
        if (connection != null && !connection.getAutoCommit()) {
            connection.commit();
        }
    }

    void doInserts(int start, int numOfInserts, String fullTableName) throws Exception {
        String insertTableSql = null;
        for (int i = start; i < start + numOfInserts; ++i) {
            insertTableSql = "INSERT INTO " + fullTableName + " VALUES ('" + i + "', 'Spring" + i + "','TAG" + i + "'," + (int)(Math.random() * 200.0) + ",'city" + i + "')";
            GfxdTableMBeanDUnit.logInfo("doInserts: insertTableSql :: " + insertTableSql);
            this.serverSQLExecute(1, insertTableSql);
        }
        VM vm = Host.getHost((int)0).getVM(0);
        vm.invoke(GfxdTableMBeanDUnit.class, "commitTx");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetIndexInfo() throws Exception {
        String SPACE = " ";
        String TABLE_SCHEMA = "APP";
        String TABLE_NAME = "BOOKS";
        String CREATE_TABLE_SQL = "CREATE TABLE APP.BOOKS (ID VARCHAR(10) NOT NULL, NAME VARCHAR(25), TAG VARCHAR(25), SIZE BIGINT, LOCATION VARCHAR(25), CONSTRAINT BOOK_PK PRIMARY KEY (ID) )";
        String INDEX_BY_NAME = "CREATE INDEX INDEX_NAME ON APP.BOOKS(NAME)";
        String INDEX_BY_LOCATION = "CREATE INDEX INDEX_LOCATION ON APP.BOOKS(LOCATION)";
        String INDEX_BY_TAG = "CREATE INDEX INDEX_TAG ON APP.BOOKS(TAG)";
        String partitionByClause = PARTITION_SCHEME;
        int redundancyValue = 2;
        String redundancyClause = "REDUNDANCY " + redundancyValue;
        String persistenceClause = "EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW PERSISTENT ASYNCHRONOUS";
        boolean serverVmStarted = false;
        try {
            String createTableSql = this.getSqlQuery("CREATE TABLE APP.BOOKS (ID VARCHAR(10) NOT NULL, NAME VARCHAR(25), TAG VARCHAR(25), SIZE BIGINT, LOCATION VARCHAR(25), CONSTRAINT BOOK_PK PRIMARY KEY (ID) )", " ", partitionByClause, partitionByClause, persistenceClause, redundancyClause);
            this.startVMs(0, 1, AvailablePortHelper.getRandomAvailableTCPPort(), "DEFAULT", GfxdTableMBeanDUnit.getManagerConfig(true));
            serverVmStarted = true;
            this.serverSQLExecute(1, createTableSql);
            String fullTableName = TestUtil.getFullTableName("APP", "BOOKS");
            int inserts = 100;
            this.serverSQLExecute(1, "CREATE INDEX INDEX_LOCATION ON APP.BOOKS(LOCATION)");
            this.serverSQLExecute(1, "CREATE INDEX INDEX_NAME ON APP.BOOKS(NAME)");
            this.serverSQLExecute(1, "CREATE INDEX INDEX_TAG ON APP.BOOKS(TAG)");
            this.doInserts(1, inserts, fullTableName);
            VM serverVM = Host.getHost((int)0).getVM(0);
            GfxdManagementTestBase.ConnectionEndpoint jmxHostPort = (GfxdManagementTestBase.ConnectionEndpoint)serverVM.invoke(GfxdTableMBeanDUnit.class, "retrieveJmxHostPort");
            MBeanServerConnection mbsc = this.startJmxClient(jmxHostPort.host, jmxHostPort.port);
            String memberNameOrId = (String)serverVM.invoke(GfxdTableMBeanDUnit.class, "getMemberNameOrId");
            ObjectName tableMBeanName = ManagementUtils.getTableMBeanName((String)"DEFAULT", (String)memberNameOrId, (String)TestUtil.getFullTableName("APP", "BOOKS"));
            Thread.sleep(0L);
            GfxdTableMBeanDUnit.logInfo("Validating index info for all indexes ");
            HashSet<String> indexNames = new HashSet<String>();
            String pkIndexName = "2__BOOKS__ID";
            indexNames.add("INDEX_LOCATION");
            indexNames.add("INDEX_TAG");
            indexNames.add("INDEX_NAME");
            indexNames.add(pkIndexName);
            CompositeData[] data = (CompositeData[])mbsc.invoke(tableMBeanName, "listIndexInfo", null, null);
            GfxdTableMBeanDUnit.assertEquals((int)4, (int)data.length);
            for (CompositeData indexInfo : data) {
                String indexName = (String)indexInfo.get("indexName");
                GfxdTableMBeanDUnit.logInfo("Validating index info for " + indexName);
                GfxdTableMBeanDUnit.assertTrue((boolean)indexNames.contains(indexName));
                if ("INDEX_LOCATION".contains(indexName)) {
                    GfxdTableMBeanDUnit.assertEquals((Object)"+LOCATION", (Object)indexInfo.get("columnsAndOrder"));
                } else if ("INDEX_TAG".contains(indexName)) {
                    GfxdTableMBeanDUnit.assertEquals((Object)"+TAG", (Object)indexInfo.get("columnsAndOrder"));
                } else if ("INDEX_NAME".contains(indexName)) {
                    GfxdTableMBeanDUnit.assertEquals((Object)"+NAME", (Object)indexInfo.get("columnsAndOrder"));
                } else {
                    GfxdTableMBeanDUnit.assertEquals((String)pkIndexName, (String)indexName);
                    GfxdTableMBeanDUnit.assertEquals((Object)"+ID", (Object)indexInfo.get("columnsAndOrder"));
                }
                GfxdTableMBeanDUnit.assertTrue((((String)indexInfo.get("indexType")).contains("LOCAL") || indexInfo.get("indexType").equals("PRIMARY KEY") ? 1 : 0) != 0);
            }
            CompositeData[] indexStats = (CompositeData[])mbsc.invoke(tableMBeanName, "listIndexStats", null, null);
            GfxdTableMBeanDUnit.assertEquals((int)3, (int)indexStats.length);
            for (CompositeData indexStat : indexStats) {
                String indexName = (String)indexStat.get("indexName");
                GfxdTableMBeanDUnit.logInfo("Validating index stats for " + indexName + " rowCount = " + indexStat.get("rowCount") + " entrySize " + indexStat.get("entrySize"));
                GfxdTableMBeanDUnit.logInfo(indexName + " index entry size " + indexStat.get("entrySize"));
                GfxdTableMBeanDUnit.logInfo(indexName + " index key size " + indexStat.get("keySize"));
                GfxdTableMBeanDUnit.assertTrue((boolean)indexNames.contains(indexName));
                long rowCount = (Long)indexStat.get("rowCount");
                GfxdTableMBeanDUnit.assertEquals((int)inserts, (int)((int)rowCount));
                double entrySize = (Double)indexStat.get("entrySize");
                GfxdTableMBeanDUnit.assertTrue((entrySize > 0.0 ? 1 : 0) != 0);
            }
            this.serverSQLExecute(1, "DROP INDEX  APP.INDEX_LOCATION");
            data = (CompositeData[])mbsc.invoke(tableMBeanName, "listIndexInfo", null, null);
            GfxdTableMBeanDUnit.assertEquals((int)3, (int)data.length);
            indexStats = (CompositeData[])mbsc.invoke(tableMBeanName, "listIndexStats", null, null);
            GfxdTableMBeanDUnit.assertEquals((int)2, (int)indexStats.length);
        }
        finally {
            this.stopJmxClient();
            if (serverVmStarted) {
                this.stopVMNum(-1);
            }
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

