/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.AggregateMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.GfxdMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerNestedConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdManagementTestBase;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.VM;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class GfxdMemberMBeanDUnit
extends GfxdManagementTestBase {
    private static final long serialVersionUID = 1L;
    static final String grp1 = "GRP1";
    static final String grp2 = "GRP2";
    private static List<String> grps = new ArrayList<String>();
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public GfxdMemberMBeanDUnit(String name) {
        super(name);
        grps.add(grp1);
        grps.add(grp2);
        grps.add("DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemberstats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            this.startServerVMs(1, 0, grp1, serverInfo);
            serverInfo.setProperty("jmx-manager", "true");
            serverInfo.setProperty("jmx-manager-start", "true");
            serverInfo.setProperty("jmx-manager-port", "0");
            this.startServerVMs(1, 0, grp2, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, grp1, info);
            this.checkMemberMBeanStats();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    private void checkMemberMBeanStats() throws Exception {
        VM serverVM1 = (VM)this.serverVMs.get(1);
        serverVM1.invoke(((Object)((Object)this)).getClass(), "verifyMemberMbeans");
    }

    public static void verifyMemberMbeans() {
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        final ObjectName distrObjectName = MBeanJMXAdapter.getObjectName((String)"GemFireXD:service=Cluster");
        GfxdMemberMBeanDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the testAggregateMemberstats to get reflected at managing node";
            }

            public boolean done() {
                AggregateMemberMXBean bean = (AggregateMemberMXBean)service.getMBeanInstance(distrObjectName, AggregateMemberMXBean.class);
                boolean done = bean != null && bean.getMembers().length == 4 && bean.getNetworkServerPeerConnectionStats().getConnectionsAttempted() > 0L;
                return done;
            }
        }, (long)8000L, (long)500L, (boolean)true);
        Set dsMembers = CliUtil.getAllMembers((Cache)Misc.getGemFireCacheNoThrow());
        Iterator it = dsMembers.iterator();
        InternalDistributedSystem system = Misc.getGemFireCacheNoThrow().getDistributedSystem();
        StatisticsType connectionStatsType = system.findType(ConnectionStats.name);
        long peerConnectionsOpened = 0L;
        long peerConnectionsClosed = 0L;
        long peerConnectionsAttempted = 0L;
        long peerConnectionsFailed = 0L;
        long peerConnectionsLifeTime = 0L;
        long clientConnectionsOpened = 0L;
        long clientConnectionsClosed = 0L;
        long clientConnectionsAttempted = 0L;
        long clientConnectionsFailed = 0L;
        long clientConnectionsLifeTime = 0L;
        long clientConnectionsIdle = 0L;
        long nestedConnectionsOpened = 0L;
        long nestedConnectionsClosed = 0L;
        long nestedConnectionsOpen = 0L;
        long internalConnectionsOpened = 0L;
        long internalConnectionsClosed = 0L;
        long internalConnectionsOpen = 0L;
        if (connectionStatsType != null) {
            Statistics[] foundStatistics;
            for (Statistics statistics : foundStatistics = system.findStatisticsByType(connectionStatsType)) {
                peerConnectionsOpened = statistics.getLong("peerConnectionsOpened");
                peerConnectionsClosed = statistics.getLong("peerConnectionsClosed");
                peerConnectionsAttempted = statistics.getLong("peerConnectionsAttempted");
                peerConnectionsFailed = statistics.getLong("peerConnectionsFailed");
                peerConnectionsLifeTime = statistics.getLong("peerConnectionsLifeTime");
                clientConnectionsOpened = statistics.getLong("clientConnectionsOpened");
                clientConnectionsClosed = statistics.getLong("clientConnectionsClosed");
                clientConnectionsAttempted = statistics.getLong("clientConnectionsAttempted");
                clientConnectionsFailed = statistics.getLong("clientConnectionsFailed");
                clientConnectionsLifeTime = statistics.getLong("clientConnectionsLifeTime");
                clientConnectionsIdle = statistics.getLong("clientConnectionsIdle");
                nestedConnectionsOpened = statistics.getLong("nestedConnectionsOpened");
                nestedConnectionsClosed = statistics.getLong("nestedConnectionsClosed");
                nestedConnectionsOpen = statistics.getLong("nestedConnectionsOpen");
                internalConnectionsOpened = statistics.getLong("internalConnectionsOpened");
                internalConnectionsClosed = statistics.getLong("internalConnectionsClosed");
                internalConnectionsOpen = statistics.getLong("internalConnectionsOpen");
            }
        } else {
            GfxdMemberMBeanDUnit.logInfo("For member=" + system.getMemberId() + " connectionStatsType is null");
            GfxdMemberMBeanDUnit.fail();
        }
        while (it.hasNext()) {
            DistributedMember dsMember = (DistributedMember)it.next();
            if (!dsMember.getId().equals(system.getMemberId())) continue;
            ObjectName memberMBeanName = ManagementUtils.getMemberMBeanName((String)MBeanJMXAdapter.getMemberNameOrId((DistributedMember)dsMember), (String)"DEFAULT");
            GfxdMemberMXBean mbean = (GfxdMemberMXBean)InternalManagementService.getAnyInstance().getMBeanInstance(memberMBeanName, GfxdMemberMXBean.class);
            if (mbean == null) continue;
            NetworkServerConnectionStats clientStats = mbean.getNetworkServerClientConnectionStats();
            NetworkServerNestedConnectionStats internalStats = mbean.getNetworkServerInternalConnectionStats();
            NetworkServerNestedConnectionStats nestedStats = mbean.getNetworkServerNestedConnectionStats();
            NetworkServerConnectionStats peerStats = mbean.getNetworkServerPeerConnectionStats();
            GfxdMemberMBeanDUnit.assertEquals((boolean)true, (clientStats != null ? 1 : 0) != 0);
            GfxdMemberMBeanDUnit.assertEquals((boolean)true, (internalStats != null ? 1 : 0) != 0);
            GfxdMemberMBeanDUnit.assertEquals((boolean)true, (nestedStats != null ? 1 : 0) != 0);
            GfxdMemberMBeanDUnit.assertEquals((boolean)true, (peerStats != null ? 1 : 0) != 0);
            GfxdMemberMBeanDUnit.assertEquals((boolean)true, (mbean.fetchMetadata() != null ? 1 : 0) != 0);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " clientConnectionsLifeTime=" + clientConnectionsLifeTime + " from clientStats =" + clientStats.getConnectionLifeTime());
            GfxdMemberMBeanDUnit.assertEquals((long)clientStats.getConnectionLifeTime(), (long)clientConnectionsLifeTime);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " clientConnectionsAttempted=" + clientConnectionsAttempted + " from clientStats =" + clientStats.getConnectionsAttempted());
            GfxdMemberMBeanDUnit.assertEquals((long)clientStats.getConnectionsAttempted(), (long)clientConnectionsAttempted);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " clientConnectionsClosed=" + clientConnectionsClosed + " from clientStats =" + clientStats.getConnectionsClosed());
            GfxdMemberMBeanDUnit.assertEquals((long)clientStats.getConnectionsClosed(), (long)clientConnectionsClosed);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " clientConnectionsFailed=" + clientConnectionsFailed + " from clientStats =" + clientStats.getConnectionsFailed());
            GfxdMemberMBeanDUnit.assertEquals((long)clientStats.getConnectionsFailed(), (long)clientConnectionsFailed);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " clientConnectionsOpened=" + clientConnectionsOpened + " from clientStats =" + clientStats.getConnectionsOpened());
            GfxdMemberMBeanDUnit.assertEquals((long)clientStats.getConnectionsOpened(), (long)clientConnectionsOpened);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " clientConnectionsIdle=" + clientConnectionsIdle + " from clientStats =" + clientStats.getConnectionsIdle());
            GfxdMemberMBeanDUnit.assertEquals((long)clientStats.getConnectionsIdle(), (long)clientConnectionsIdle);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " peerConnectionsLifeTime=" + peerConnectionsLifeTime + " from peerStats =" + peerStats.getConnectionLifeTime());
            GfxdMemberMBeanDUnit.assertEquals((long)peerStats.getConnectionLifeTime(), (long)peerConnectionsLifeTime);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " peerConnectionsAttempted=" + peerConnectionsAttempted + " from peerStats =" + peerStats.getConnectionsAttempted());
            GfxdMemberMBeanDUnit.assertEquals((long)peerStats.getConnectionsAttempted(), (long)peerConnectionsAttempted);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " peerConnectionsClosed=" + peerConnectionsClosed + " from peerStats =" + peerStats.getConnectionsClosed());
            GfxdMemberMBeanDUnit.assertEquals((long)peerStats.getConnectionsClosed(), (long)peerConnectionsClosed);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " peerConnectionsFailed=" + peerConnectionsFailed + " from peerStats =" + peerStats.getConnectionsFailed());
            GfxdMemberMBeanDUnit.assertEquals((long)peerStats.getConnectionsFailed(), (long)peerConnectionsFailed);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " peerConnectionsOpened=" + peerConnectionsOpened + " from peerStats =" + peerStats.getConnectionsOpened());
            GfxdMemberMBeanDUnit.assertEquals((long)peerStats.getConnectionsOpened(), (long)peerConnectionsOpened);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " internalConnectionsOpen=" + internalConnectionsOpen + " from internalStats =" + internalStats.getConnectionsOpened());
            GfxdMemberMBeanDUnit.assertEquals((long)internalStats.getConnectionsActive(), (long)internalConnectionsOpen);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " internalConnectionsClosed=" + internalConnectionsClosed + " from internalStats =" + internalStats.getConnectionsClosed());
            GfxdMemberMBeanDUnit.assertEquals((long)internalStats.getConnectionsClosed(), (long)internalConnectionsClosed);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " internalConnectionsOpened=" + internalConnectionsOpened + " from internalStats =" + internalStats.getConnectionsOpened());
            GfxdMemberMBeanDUnit.assertEquals((long)internalStats.getConnectionsOpened(), (long)internalConnectionsOpened);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " nestedConnectionsOpen=" + nestedConnectionsOpen + " from nestedStats =" + nestedStats.getConnectionsActive());
            GfxdMemberMBeanDUnit.assertEquals((long)nestedStats.getConnectionsActive(), (long)nestedConnectionsOpen);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " nestedConnectionsClosed=" + nestedConnectionsClosed + " from nestedStats =" + nestedStats.getConnectionsClosed());
            GfxdMemberMBeanDUnit.assertEquals((long)nestedStats.getConnectionsClosed(), (long)nestedConnectionsClosed);
            GfxdMemberMBeanDUnit.logInfo("for member = " + dsMember.getId() + " nestedConnectionsOpened=" + nestedConnectionsOpened + " from nestedStats =" + nestedStats.getConnectionsOpened());
            GfxdMemberMBeanDUnit.assertEquals((long)nestedStats.getConnectionsOpened(), (long)nestedConnectionsOpened);
            float evictionPercentage = 45.5f;
            mbean.updateEvictionPercent(evictionPercentage);
            GfxdMemberMBeanDUnit.logInfo("mbean.fetchEvictionPercent=" + mbean.fetchEvictionPercent());
            GfxdMemberMBeanDUnit.assertEquals((Object)Float.valueOf(mbean.fetchEvictionPercent()), (Object)Float.valueOf(evictionPercentage));
            GfxdMemberMBeanDUnit.logInfo("mbean.getGroups().length==" + mbean.getGroups().length);
            GfxdMemberMBeanDUnit.assertEquals((boolean)true, (mbean.getGroups().length >= 1 ? 1 : 0) != 0);
            for (String str : mbean.getGroups()) {
                GfxdMemberMBeanDUnit.logInfo("member grp = " + str);
                GfxdMemberMBeanDUnit.assertEquals((boolean)true, (grps.contains(str) ? 1 : 0) != 0);
            }
            GfxdMemberMBeanDUnit.logInfo("mbean member name=" + mbean.getName() + " from DS=" + dsMember.getName());
            GfxdMemberMBeanDUnit.assertEquals((String)mbean.getName(), (String)dsMember.getName());
            GfxdMemberMBeanDUnit.logInfo("mbean member id=" + mbean.getId() + " from DS=" + dsMember.getId());
            GfxdMemberMBeanDUnit.assertEquals((String)mbean.getId(), (String)dsMember.getId());
            GfxdMemberMBeanDUnit.logInfo("mbean.isDataStore=" + mbean.isDataStore());
            GfxdMemberMBeanDUnit.assertEquals((boolean)true, (boolean)(mbean.isDataStore() ? true : !mbean.isDataStore()));
            GfxdMemberMBeanDUnit.logInfo("mbean.isLocator=" + mbean.isLocator());
            GfxdMemberMBeanDUnit.assertEquals((boolean)true, (boolean)(mbean.isLocator() ? true : !mbean.isLocator()));
            float criticalPercentage = evictionPercentage + 0.5f;
            mbean.updateCriticalPercent(criticalPercentage);
            GfxdMemberMBeanDUnit.logInfo("mbean.fetchCriticalPercent=" + mbean.fetchCriticalPercent());
            GfxdMemberMBeanDUnit.assertEquals((Object)Float.valueOf(mbean.fetchCriticalPercent()), (Object)Float.valueOf(criticalPercentage));
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

