/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.AggregateTableMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.AggregateTableMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdManagementTestBase;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.VM;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class AggregateTableMBeanDUnit
extends GfxdManagementTestBase {
    private static final long serialVersionUID = 1L;
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public AggregateTableMBeanDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggregateMemberstats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            this.startServerVMs(1, 0, null, serverInfo);
            serverInfo.setProperty("jmx-manager", "true");
            serverInfo.setProperty("jmx-manager-start", "true");
            serverInfo.setProperty("jmx-manager-port", "0");
            this.startServerVMs(1, 0, null, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, null, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            this.checkAggregateTableMBean(conn);
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
        }
    }

    private void checkAggregateTableMBean(Connection conn) throws Exception {
        VM serverVM = (VM)this.serverVMs.get(1);
        Statement stmt = conn.createStatement();
        String createSchemaOrder = "create schema trade";
        stmt.execute("create schema trade");
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        Date since = new Date(System.currentTimeMillis());
        for (int i = 0; i < 10; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        serverVM.invoke(((Object)((Object)this)).getClass(), "getAggregateTableMBean");
    }

    public static void getAggregateTableMBean() {
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        final ObjectName distrObjectName = ManagementUtils.getAggrgateTableMBeanName((String)"TRADE.CUSTOMERS");
        AggregateTableMBeanDUnit.logInfo("AggregateTableMXBean distrObjectName==" + distrObjectName);
        AggregateTableMBeanDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the getAggregateTableMBean to get reflected at managing node";
            }

            public boolean done() {
                AggregateTableMXBean bean = (AggregateTableMXBean)service.getMBeanInstance(distrObjectName, AggregateTableMXBean.class);
                boolean done = bean != null;
                return done;
            }
        }, (long)8000L, (long)500L, (boolean)true);
        AggregateTableMBeanDUnit.logInfo("AggregateTableMXBean after wait criteria ");
        AggregateTableMBean aggregateTableMBean = (AggregateTableMBean)service.getMBeanInstance(distrObjectName, AggregateTableMXBean.class);
        if (aggregateTableMBean != null) {
            AggregateTableMBeanDUnit.logInfo("AggregateTableMXBean aggregateTableMBean.getEntrySize()==" + aggregateTableMBean.getEntrySize());
            AggregateTableMBeanDUnit.logInfo("AggregateTableMXBean aggregateTableMBean.getNumberOfRows()==" + aggregateTableMBean.getNumberOfRows());
            AggregateTableMBeanDUnit.assertEquals((boolean)true, (aggregateTableMBean.getEntrySize() >= 0.0 ? 1 : 0) != 0);
            AggregateTableMBeanDUnit.assertEquals((boolean)true, (aggregateTableMBean.getNumberOfRows() >= 0L ? 1 : 0) != 0);
        } else {
            AggregateTableMBeanDUnit.logInfo("AggregateTableMXBean is null");
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

