/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.AggregateStatementMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.AggregateStatementMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.stats.StatementStatsDUnit;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.VM;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class AggregateStatementStatsDUnit
extends DistributedSQLTestBase {
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private static StatementStatsDUnit.StatementStatsObserver ob1;
    private static StatementStatsDUnit.StatementStatsObserver ob2;

    public AggregateStatementStatsDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatementStats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            this.startServerVMs(1, 0, null, serverInfo);
            serverInfo.setProperty("jmx-manager", "true");
            serverInfo.setProperty("jmx-manager-start", "true");
            serverInfo.setProperty("jmx-manager-port", "0");
            this.startServerVMs(1, 0, null, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, null, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            this.checkAggregateMBean(conn, true, 1);
            conn.close();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
        }
    }

    private void checkAggregateMBean(Connection conn, boolean enableStats, int numTimesSampled) throws Exception {
        VM serverVM = (VM)this.serverVMs.get(1);
        Statement stmt = conn.createStatement();
        String createSchemaOrder = "create schema trade";
        stmt.execute("create schema trade");
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        Date since = new Date(System.currentTimeMillis());
        for (int i = 0; i < 10; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        PreparedStatement psSelectCust = conn.prepareStatement("select * from trade.customers where cust_name = ?");
        for (int i = 0; i < 10; ++i) {
            psSelectCust.setString(1, "XXXX" + i);
            ResultSet rs = psSelectCust.executeQuery();
            AggregateStatementStatsDUnit.assertTrue((String)"Should return one row", (boolean)rs.next());
            AggregateStatementStatsDUnit.assertFalse((String)"Should not return more than one row", (boolean)rs.next());
            rs.close();
        }
        String stmtId = ((EmbedStatement)psSelectCust).getStatementStats().getStatsId();
        System.out.println("Statement Id = " + stmtId);
        AggregateStatementStatsDUnit.printStatementMBeans();
        serverVM.invoke(((Object)((Object)this)).getClass(), "isAggregateStatementMBeanCreated", new Object[]{stmtId});
        psSelectCust.close();
        psInsertCust.close();
        stmt.close();
    }

    public static void isAggregateStatementMBeanCreated(String stmtId) {
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        final ObjectName statementObjectName = ManagementUtils.getAggregateStatementMBeanName((String)stmtId);
        AggregateStatementStatsDUnit.printStatementMBeans();
        AggregateStatementStatsDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the statement aggregator to get reflected at managing node";
            }

            public boolean done() {
                AggregateStatementMXBean bean = (AggregateStatementMXBean)service.getMBeanInstance(statementObjectName, AggregateStatementMXBean.class);
                boolean done = bean != null;
                return done;
            }
        }, (long)8000L, (long)500L, (boolean)true);
        AggregateStatementMBean aggStatementMBean = (AggregateStatementMBean)service.getMBeanInstance(statementObjectName, AggregateStatementMXBean.class);
        AggregateStatementStatsDUnit.printValues(AggregateStatementMXBean.class, aggStatementMBean);
    }

    private static void printValues(Class<?> mbeanInterface, Object mbeanObject) {
        Method[] methodArray = mbeanInterface.getMethods();
        Object[] args = null;
        for (Method m : methodArray) {
            String name = m.getName();
            String attrName = "";
            if (name.startsWith("get")) {
                attrName = name.substring(3);
            } else if (name.startsWith("is") && m.getReturnType() == Boolean.TYPE) {
                attrName = name.substring(2);
            }
            try {
                Object val = m.invoke(mbeanObject, args);
                System.out.println(attrName + " = " + val);
            }
            catch (IllegalArgumentException e) {
                AggregateStatementStatsDUnit.fail((String)("printValues failed" + e));
            }
            catch (IllegalAccessException e) {
                AggregateStatementStatsDUnit.fail((String)("printValues failed" + e));
            }
            catch (InvocationTargetException e) {
                AggregateStatementStatsDUnit.fail((String)("printValues failed" + e));
            }
        }
    }

    public static void printStatementMBeans() {
        try {
            Set<ObjectInstance> objNames = mbeanServer.queryMBeans(new ObjectName("GemFireXD:service=Statement,*"), null);
            System.out.println(objNames);
        }
        catch (MalformedObjectNameException e) {
            AggregateStatementStatsDUnit.fail((String)("printStatementMBeans failed" + e));
        }
        catch (NullPointerException e) {
            AggregateStatementStatsDUnit.fail((String)("printStatementMBeans failed" + e));
        }
    }

    @Override
    public void tearDown2() throws Exception {
        ob1 = null;
        ob2 = null;
        super.tearDown2();
    }
}

