/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.gemstone.gemfire.management.internal.beans.MemberMBean;
import com.gemstone.gemfire.management.internal.beans.SequenceNumber;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.AggregateMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.GfxdMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerNestedConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.impl.AggregateMemberMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdManagementTestBase;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import io.snappydata.test.dunit.AvailablePortHelper;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class AggregateMemberMBeanDUnit
extends GfxdManagementTestBase {
    private static final long serialVersionUID = 1L;
    static final List<Notification> notifList = new ArrayList<Notification>();
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final String NOTIF_STR = "NOTIF_STR";
    private static final int MAX_WAIT = 20000;

    public AggregateMemberMBeanDUnit(String name) {
        super(name);
    }

    static Properties getManagerConfig(boolean startManager, boolean startAgent) {
        Properties p = new Properties();
        p.setProperty("jmx-manager", "true");
        p.setProperty("jmx-manager-start", String.valueOf(startManager));
        if (startAgent) {
            p.setProperty("jmx-manager-port", String.valueOf(AvailablePortHelper.getRandomAvailableTCPPort()));
        } else {
            p.setProperty("jmx-manager-port", String.valueOf(0));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggregateMemberstats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            this.startServerVMs(1, 0, "grp1", serverInfo);
            serverInfo.setProperty("jmx-manager", "true");
            serverInfo.setProperty("jmx-manager-start", "true");
            serverInfo.setProperty("jmx-manager-port", "0");
            this.startServerVMs(1, 0, "grp2", serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, "grp1", info);
            this.checkAggregateMemberMBeanStats(1);
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggregateMemberstatsManagerFirst() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            Properties managerInfo = new Properties();
            managerInfo.putAll((Map<?, ?>)serverInfo);
            managerInfo.setProperty("jmx-manager", "true");
            managerInfo.setProperty("jmx-manager-start", "true");
            managerInfo.setProperty("jmx-manager-port", "0");
            this.startServerVMs(1, 0, "CG,Peer", managerInfo);
            this.startServerVMs(1, 0, "CG,Peer", serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, "grp1", info);
            this.checkAggregateMemberMBeanStats(0);
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotification() throws Exception {
        try {
            this.startServerVMs(1, 0, "DEFAULT", AggregateMemberMBeanDUnit.getManagerConfig(false, false));
            this.startServerVMs(1, 0, "DEFAULT", AggregateMemberMBeanDUnit.getManagerConfig(true, false));
            VM serverVM = (VM)this.serverVMs.get(0);
            VM managerVM = (VM)this.serverVMs.get(1);
            DistributedMember serverMember = this.getMember(serverVM);
            this.attchListenerToDSMBean(managerVM);
            this.waitForManagerToRegisterListener(serverVM);
            this.sendNotifications(serverVM, 15);
            this.countNotifications(managerVM, 10, 15, serverMember);
            this.sendNotifications(serverVM, 35);
            this.countNotifications(managerVM, 10, 50, serverMember);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public DistributedMember getMember(VM vm) {
        SerializableCallable getMember = new SerializableCallable("Get Member"){

            public Object call() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        return (DistributedMember)vm.invoke((Callable)getMember);
    }

    protected void attchListenerToDSMBean(VM vm) {
        SerializableRunnable attchListenerToDSMBean = new SerializableRunnable("Attach Listener to DS MBean"){

            public void run() {
                SystemManagementService service = (SystemManagementService)SystemManagementService.getExistingManagementService((Cache)Misc.getMemStore().getGemFireCache());
                TestCase.assertTrue((boolean)service.isManager());
                notifList.clear();
                NotificationListener nt = new NotificationListener(){

                    @Override
                    public void handleNotification(Notification notification, Object handback) {
                        if (notification.getMessage().contains(AggregateMemberMBeanDUnit.NOTIF_STR)) {
                            notifList.add(notification);
                        }
                    }
                };
                try {
                    mbeanServer.addNotificationListener(MBeanJMXAdapter.getDistributedSystemName(), nt, null, null);
                }
                catch (InstanceNotFoundException e) {
                    TestCase.fail((String)("Failed With Exception " + e));
                }
            }
        };
        vm.invoke((Runnable)attchListenerToDSMBean);
    }

    public void waitForManagerToRegisterListener(VM vm) {
        SerializableRunnable waitForManagerToRegisterListener = new SerializableRunnable("Wait for Manager to register Listener"){
            private static final long serialVersionUID = 1L;

            public void run() {
                SystemManagementService service = (SystemManagementService)SystemManagementService.getExistingManagementService((Cache)Misc.getMemStore().getGemFireCache());
                GemFireCacheImpl cache = Misc.getMemStore().getGemFireCache();
                InternalDistributedMember member = cache.getDistributedSystem().getDistributedMember();
                final ObjectName memberMBeanName = service.getMemberMBeanName((DistributedMember)member);
                final Map hubMap = service.getNotificationHub().getListenerObjectMap();
                DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                    public String description() {
                        return "Waiting for manager to register the listener";
                    }

                    public boolean done() {
                        boolean done = hubMap.get(memberMBeanName) != null;
                        return done;
                    }
                }, (long)20000L, (long)500L, (boolean)true);
            }
        };
        vm.invoke((Runnable)waitForManagerToRegisterListener);
    }

    public void sendNotifications(VM vm, final int count) {
        SerializableRunnable sendNotifications = new SerializableRunnable("Send Notifications"){
            private static final long serialVersionUID = 1L;

            public void run() {
                SystemManagementService service = (SystemManagementService)SystemManagementService.getExistingManagementService((Cache)Misc.getMemStore().getGemFireCache());
                MemberMBean memberMBean = (MemberMBean)service.getMemberMXBean();
                for (int i = 1; i <= count; ++i) {
                    Notification notification = new Notification(AggregateMemberMBeanDUnit.NOTIF_STR + i, memberMBean.getName(), SequenceNumber.next(), System.currentTimeMillis(), AggregateMemberMBeanDUnit.NOTIF_STR + i);
                    memberMBean.sendNotification(notification);
                }
            }
        };
        vm.invoke((Runnable)sendNotifications);
    }

    public void countNotifications(VM vm, final int expectedCount, final int expectedNotifListSize, final DistributedMember notifSendingmember) {
        SerializableRunnable countNotifications = new SerializableRunnable("Count Notifications"){
            private static final long serialVersionUID = 1L;

            public void run() {
                GemFireCacheImpl cache = Misc.getMemStore().getGemFireCache();
                String appender = MBeanJMXAdapter.getUniqueIDForMember((DistributedMember)notifSendingmember);
                DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                    public String description() {
                        return "Waiting for " + expectedNotifListSize + " notifications to reach the manager while size of notifList = " + notifList.size();
                    }

                    public boolean done() {
                        boolean done = expectedNotifListSize == notifList.size();
                        return done;
                    }
                }, (long)20000L, (long)500L, (boolean)true);
                TestCase.assertEquals((int)expectedNotifListSize, (int)notifList.size());
                Region member1NotifRegion = cache.getRegion("_notificationRegion_" + appender);
                TestCase.assertEquals((int)expectedCount, (int)member1NotifRegion.size());
            }
        };
        vm.invoke((Runnable)countNotifications);
    }

    private void checkAggregateMemberMBeanStats(int index) throws Exception {
        VM serverVM = (VM)this.serverVMs.get(index);
        serverVM.invoke(((Object)((Object)this)).getClass(), "getAggregateMemberMBean");
    }

    public static void getAggregateMemberMBean() {
        final InternalManagementService service = InternalManagementService.getInstance((GemFireStore)Misc.getMemStore());
        final ObjectName distrObjectName = MBeanJMXAdapter.getObjectName((String)"GemFireXD:service=Cluster");
        AggregateMemberMBeanDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "Waiting for the testAggregateMemberstats to get reflected at managing node";
            }

            public boolean done() {
                AggregateMemberMXBean bean = (AggregateMemberMXBean)service.getMBeanInstance(distrObjectName, AggregateMemberMXBean.class);
                boolean done = bean != null && bean.getMembers().length == 4;
                return done;
            }
        }, (long)8000L, (long)500L, (boolean)true);
        AggregateMemberMBean aggregateMemberMBean = (AggregateMemberMBean)service.getMBeanInstance(distrObjectName, AggregateMemberMXBean.class);
        AggregateMemberMBeanDUnit.assertTrue((aggregateMemberMBean != null ? 1 : 0) != 0);
        Set set = InternalDistributedSystem.getConnectedInstance().getAllOtherMembers();
        HashSet<InternalDistributedMember> memberSet = new HashSet<InternalDistributedMember>();
        memberSet.add(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        memberSet.addAll(set);
        String[] members = aggregateMemberMBean.getMembers();
        ArrayList<String> memberList = new ArrayList<String>();
        for (String member : members) {
            memberList.add(member);
        }
        AggregateMemberMBeanDUnit.logInfo("JMX API members = " + ((Object)memberList).toString());
        AggregateMemberMBeanDUnit.logInfo("Gem API members = " + ((Object)memberSet).toString());
        AggregateMemberMBeanDUnit.assertEquals((int)members.length, (int)memberSet.size());
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (aggregateMemberMBean.getProcedureCallsInProgress() >= 0 ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (aggregateMemberMBean.getNetworkServerClientConnectionStats() != null ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (aggregateMemberMBean.getNetworkServerInternalConnectionStats() != null ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (aggregateMemberMBean.getNetworkServerNestedConnectionStats() != null ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (aggregateMemberMBean.getNetworkServerPeerConnectionStats() != null ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (aggregateMemberMBean.getProcedureCallsCompleted() >= 0 ? 1 : 0) != 0);
        long NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED = 0L;
        long NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED = 0L;
        long NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED = 0L;
        long NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED = 0L;
        long NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME = 0L;
        long NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN = 0L;
        long NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE = 0L;
        long NETWORK_SERVER_PEER_CONNECTIONS_OPENED = 0L;
        long NETWORK_SERVER_PEER_CONNECTIONS_CLOSED = 0L;
        long NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED = 0L;
        long NETWORK_SERVER_PEER_CONNECTIONS_FAILED = 0L;
        long NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME = 0L;
        long NETWORK_SERVER_PEER_CONNECTIONS_OPEN = 0L;
        long NETWORK_SERVER_PEER_CONNECTIONS_IDLE = 0L;
        long NETWORK_SERVER_NESTED_CONNECTIONS_OPEN = 0L;
        long NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED = 0L;
        long NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE = 0L;
        long NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN = 0L;
        long NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED = 0L;
        long NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE = 0L;
        Set dsMembers = CliUtil.getAllMembers((Cache)Misc.getGemFireCacheNoThrow());
        for (DistributedMember dsMember : dsMembers) {
            ObjectName memberMBeanName = ManagementUtils.getMemberMBeanName((String)MBeanJMXAdapter.getMemberNameOrId((DistributedMember)dsMember), (String)"DEFAULT");
            GfxdMemberMXBean mbean = (GfxdMemberMXBean)InternalManagementService.getAnyInstance().getMBeanInstance(memberMBeanName, GfxdMemberMXBean.class);
            if (mbean == null) continue;
            NetworkServerConnectionStats clientStats = mbean.getNetworkServerClientConnectionStats();
            NetworkServerNestedConnectionStats internalStats = mbean.getNetworkServerInternalConnectionStats();
            NetworkServerNestedConnectionStats nestedStats = mbean.getNetworkServerNestedConnectionStats();
            NetworkServerConnectionStats peerStats = mbean.getNetworkServerPeerConnectionStats();
            if (clientStats != null) {
                NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED += clientStats.getConnectionsOpened();
                NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED += clientStats.getConnectionsClosed();
                NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED += clientStats.getConnectionsAttempted();
                NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED += clientStats.getConnectionsFailed();
                NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME += clientStats.getConnectionLifeTime();
                NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN += clientStats.getConnectionsOpen();
                NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE += clientStats.getConnectionsIdle();
            }
            if (peerStats != null) {
                NETWORK_SERVER_PEER_CONNECTIONS_OPENED += peerStats.getConnectionsOpened();
                NETWORK_SERVER_PEER_CONNECTIONS_CLOSED += peerStats.getConnectionsClosed();
                NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED += peerStats.getConnectionsAttempted();
                NETWORK_SERVER_PEER_CONNECTIONS_FAILED += peerStats.getConnectionsFailed();
                NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME += peerStats.getConnectionLifeTime();
                NETWORK_SERVER_PEER_CONNECTIONS_OPEN += peerStats.getConnectionsOpen();
                NETWORK_SERVER_PEER_CONNECTIONS_IDLE += peerStats.getConnectionsIdle();
            }
            if (nestedStats != null) {
                NETWORK_SERVER_NESTED_CONNECTIONS_OPEN += nestedStats.getConnectionsOpened();
                NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED += nestedStats.getConnectionsClosed();
                NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE += nestedStats.getConnectionsActive();
            }
            if (internalStats == null) continue;
            NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN += internalStats.getConnectionsOpened();
            NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED += internalStats.getConnectionsClosed();
            NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE += internalStats.getConnectionsActive();
        }
        NetworkServerConnectionStats clientStats = aggregateMemberMBean.getNetworkServerClientConnectionStats();
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN==" + NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED==" + NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED==" + NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED==" + NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME==" + NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN==" + NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_CLIENT_CONNECTIONS_ACTIVE==" + NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean clientStats.getConnectionsOpened()==" + clientStats.getConnectionsOpened());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean clientStats.getConnectionsClosed()==" + clientStats.getConnectionsClosed());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean clientStats.getConnectionsAttempted()==" + clientStats.getConnectionsAttempted());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean clientStats.getConnectionsFailed()==" + clientStats.getConnectionsFailed());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean clientStats.getConnectionLifeTime()==" + clientStats.getConnectionLifeTime());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean clientStats.getConnectionsOpen()==" + clientStats.getConnectionsOpen());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean clientStats.getConnectionsIdle()==" + clientStats.getConnectionsIdle());
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (clientStats.getConnectionsOpened() == NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (clientStats.getConnectionsClosed() == NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (clientStats.getConnectionsAttempted() == NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (clientStats.getConnectionsFailed() == NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (clientStats.getConnectionLifeTime() == NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (clientStats.getConnectionsOpen() == NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (clientStats.getConnectionsIdle() == NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (clientStats.getConnectionStatsType().equals("Client") ? 1 : 0) != 0);
        NetworkServerConnectionStats peerStats = aggregateMemberMBean.getNetworkServerPeerConnectionStats();
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_PEER_CONNECTIONS_OPEN==" + NETWORK_SERVER_PEER_CONNECTIONS_OPENED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_PEER_CONNECTIONS_CLOSED==" + NETWORK_SERVER_PEER_CONNECTIONS_CLOSED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED==" + NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_PEER_CONNECTIONS_FAILED==" + NETWORK_SERVER_PEER_CONNECTIONS_FAILED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME==" + NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_PEER_CONNECTIONS_OPEN==" + NETWORK_SERVER_PEER_CONNECTIONS_OPEN);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_PEER_CONNECTIONS_IDLE==" + NETWORK_SERVER_PEER_CONNECTIONS_IDLE);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean peerStats.getConnectionsOpened()==" + peerStats.getConnectionsOpened());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean peerStats.getConnectionsClosed()==" + peerStats.getConnectionsClosed());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean peerStats.getConnectionsAttempted()==" + peerStats.getConnectionsAttempted());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean peerStats.getConnectionsFailed()==" + peerStats.getConnectionsFailed());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean peerStats.getConnectionLifeTime()==" + peerStats.getConnectionLifeTime());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean peerStats.getConnectionsActive()==" + peerStats.getConnectionsIdle());
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (peerStats.getConnectionsOpened() == NETWORK_SERVER_PEER_CONNECTIONS_OPENED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (peerStats.getConnectionsClosed() == NETWORK_SERVER_PEER_CONNECTIONS_CLOSED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (peerStats.getConnectionsAttempted() == NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (peerStats.getConnectionsFailed() == NETWORK_SERVER_PEER_CONNECTIONS_FAILED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (peerStats.getConnectionLifeTime() == NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (peerStats.getConnectionsOpen() == NETWORK_SERVER_PEER_CONNECTIONS_OPEN ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (peerStats.getConnectionsIdle() == NETWORK_SERVER_PEER_CONNECTIONS_IDLE ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (peerStats.getConnectionStatsType().equals("Peer") ? 1 : 0) != 0);
        NetworkServerNestedConnectionStats nestedStats = aggregateMemberMBean.getNetworkServerNestedConnectionStats();
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_NESTED_CONNECTIONS_OPEN==" + NETWORK_SERVER_NESTED_CONNECTIONS_OPEN);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED==" + NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE==" + NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean nestedStats.getConnectionsOpened()==" + nestedStats.getConnectionsOpened());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean nestedStats.getConnectionsClosed()==" + nestedStats.getConnectionsClosed());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean nestedStats.getConnectionsActive()==" + nestedStats.getConnectionsActive());
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (nestedStats.getConnectionsOpened() == NETWORK_SERVER_NESTED_CONNECTIONS_OPEN ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (nestedStats.getConnectionsClosed() == NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (nestedStats.getConnectionsActive() == NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (nestedStats.getConnectionStatsType().equals("Nested") ? 1 : 0) != 0);
        NetworkServerNestedConnectionStats internalStats = aggregateMemberMBean.getNetworkServerInternalConnectionStats();
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN==" + NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED==" + NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE==" + NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE);
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean internalStats.getConnectionsOpened()==" + internalStats.getConnectionsOpened());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean internalStats.getConnectionsClosed()==" + internalStats.getConnectionsClosed());
        AggregateMemberMBeanDUnit.logInfo("AggregateMemberMBean internalStats.getConnectionsActive()==" + internalStats.getConnectionsActive());
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (internalStats.getConnectionsOpened() == NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (internalStats.getConnectionsClosed() == NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (internalStats.getConnectionsActive() == NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE ? 1 : 0) != 0);
        AggregateMemberMBeanDUnit.assertEquals((boolean)true, (internalStats.getConnectionStatsType().equals("Internal") ? 1 : 0) != 0);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

