/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.hadoop.mapreduce.Key;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce.OutputFormatUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

public class GfxdOutputFormatTest
extends JdbcTestBase {
    public void testMR2OutputWriter() throws Exception {
        FabricServer server = FabricServiceManager.getFabricServerInstance();
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", String.valueOf(mcastPort));
        server.start(props);
        int clientPort = AvailablePort.getRandomAvailablePort((int)1);
        server.startNetworkServer("localhost", clientPort, props);
        Connection conn = DriverManager.getConnection("jdbc:gemfirexd://localhost:" + clientPort + "/");
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create table emp.usrtable (col1 int primary key, col2 varchar(100))");
        Configuration conf = new Configuration();
        conf.set("gfxd.output.tablename", "emp.usrtable");
        conf.set("gfxd.output.dburl", "jdbc:gemfirexd://localhost:" + clientPort + "/");
        RowOutputFormat format = new RowOutputFormat();
        TaskAttemptContextImpl task = new TaskAttemptContextImpl(conf, new TaskAttemptID());
        format.checkOutputSpecs((JobContext)task);
        org.apache.hadoop.mapreduce.RecordWriter writer = format.getRecordWriter((TaskAttemptContext)task);
        class DataObject {
            int col1;
            String col2;

            public DataObject(int col1, String col2) {
                this.col1 = col1;
                this.col2 = col2;
            }

            public void setCol1(int index, PreparedStatement ps) throws SQLException {
                ps.setInt(index, this.col1);
            }

            public void setCol2(int i, PreparedStatement ps) throws SQLException {
                ps.setString(i, this.col2);
            }

            public String toString() {
                return this.col1 + "-" + this.col2;
            }
        }
        writer.write((Object)new Key(), (Object)new DataObject(1, "1"));
        writer.write((Object)new Key(), (Object)new DataObject(2, "2"));
        writer.close((TaskAttemptContext)task);
        ResultSet rs = st.executeQuery("select * from emp.usrtable");
        ArrayList<String> rows = new ArrayList<String>();
        while (rs.next()) {
            rows.add(rs.getInt(1) + "-" + rs.getString(2));
        }
        GfxdOutputFormatTest.assertEquals((int)2, (int)rows.size());
        GfxdOutputFormatTest.assertTrue((boolean)rows.contains("1-1"));
        GfxdOutputFormatTest.assertTrue((boolean)rows.contains("2-2"));
        st.close();
        conn.close();
        server.stop(props);
    }

    public void testMR1OutputWriter() throws Exception {
        FabricServer server = FabricServiceManager.getFabricServerInstance();
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", String.valueOf(mcastPort));
        server.start(props);
        int clientPort = AvailablePort.getRandomAvailablePort((int)1);
        server.startNetworkServer("localhost", clientPort, props);
        Connection conn = DriverManager.getConnection("jdbc:gemfirexd://localhost:" + clientPort + "/");
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create table emp.usrtable (col1 int, col2 varchar(100))");
        com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat mr1Instance = new com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat();
        JobConf conf = new JobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        conf.set("gfxd.output.tablename", "emp.usrtable");
        conf.set("gfxd.output.dburl", "jdbc:gemfirexd://localhost:" + clientPort + "/");
        mr1Instance.checkOutputSpecs(FileSystem.get((Configuration)conf), conf);
        RecordWriter writer = mr1Instance.getRecordWriter(fs, conf, "name", null);
        class DataObject {
            int col1;
            String col2;

            public DataObject(int col1, String col2) {
                this.col1 = col1;
                this.col2 = col2;
            }

            public void setCol1(int index, PreparedStatement ps) throws SQLException {
                ps.setInt(index, this.col1);
            }

            public void setCol2(int i, PreparedStatement ps) throws SQLException {
                ps.setString(i, this.col2);
            }

            public String toString() {
                return this.col1 + "-" + this.col2;
            }
        }
        writer.write((Object)new Key(), (Object)new DataObject(1, "1"));
        writer.write((Object)new Key(), (Object)new DataObject(2, "2"));
        writer.close(null);
        ResultSet rs = st.executeQuery("select * from emp.usrtable");
        ArrayList<String> rows = new ArrayList<String>();
        while (rs.next()) {
            rows.add(rs.getInt(1) + "-" + rs.getString(2));
        }
        GfxdOutputFormatTest.assertEquals((int)2, (int)rows.size());
        GfxdOutputFormatTest.assertTrue((boolean)rows.contains("1-1"));
        GfxdOutputFormatTest.assertTrue((boolean)rows.contains("2-2"));
        st.close();
        conn.close();
        server.stop(props);
    }

    public void testMR1BatchWriter() throws Exception {
        class DataObject {
            int col1;
            String col2;

            public DataObject(int col1, String col2) {
                this.col1 = col1;
                this.col2 = col2;
            }

            public void setCol1(int index, PreparedStatement ps) throws SQLException {
                ps.setInt(index, this.col1);
            }

            public void setCol2(int i, PreparedStatement ps) throws SQLException {
                ps.setString(i, this.col2);
            }

            public String toString() {
                return this.col1 + "-" + this.col2;
            }
        }
        FabricServer server = FabricServiceManager.getFabricServerInstance();
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", String.valueOf(mcastPort));
        server.start(props);
        int clientPort = AvailablePort.getRandomAvailablePort((int)1);
        server.startNetworkServer("localhost", clientPort, props);
        Connection conn = DriverManager.getConnection("jdbc:gemfirexd://localhost:" + clientPort + "/");
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        st.execute("create table emp.usrtable (col1 int, col2 varchar(100))");
        com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat mr1Instance = new com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat();
        JobConf conf = new JobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        conf.set("gfxd.output.tablename", "emp.usrtable");
        conf.set("gfxd.output.dburl", "jdbc:gemfirexd://localhost:" + clientPort + "/");
        mr1Instance.checkOutputSpecs(FileSystem.get((Configuration)conf), conf);
        RecordWriter writer = mr1Instance.getRecordWriter(fs, conf, "name", null);
        for (int i = 1; i <= 20005; ++i) {
            writer.write((Object)new Key(), (Object)new DataObject(i, "" + i));
            if (i % 10000 == 0) {
                GfxdOutputFormatTest.assertEquals((int)10000, (int)OutputFormatUtil.resultCountTest);
                continue;
            }
            GfxdOutputFormatTest.assertEquals((int)0, (int)OutputFormatUtil.resultCountTest);
        }
        writer.close(null);
        GfxdOutputFormatTest.assertEquals((int)5, (int)OutputFormatUtil.resultCountTest);
        ResultSet rs = st.executeQuery("select * from emp.usrtable");
        ArrayList<String> rows = new ArrayList<String>();
        while (rs.next()) {
            rows.add(rs.getInt(1) + "-" + rs.getString(2));
        }
        GfxdOutputFormatTest.assertEquals((int)20005, (int)rows.size());
        conf.set("gfxd.output.batchsize", "10");
        writer = mr1Instance.getRecordWriter(fs, conf, "name", null);
        for (int i = 50001; i <= 50025; ++i) {
            writer.write((Object)new Key(), (Object)new DataObject(i, "" + i));
            if (i % 10 == 0) {
                GfxdOutputFormatTest.assertEquals((int)10, (int)OutputFormatUtil.resultCountTest);
                continue;
            }
            GfxdOutputFormatTest.assertEquals((int)0, (int)OutputFormatUtil.resultCountTest);
        }
        writer.close(null);
        GfxdOutputFormatTest.assertEquals((int)5, (int)OutputFormatUtil.resultCountTest);
        rs = st.executeQuery("select * from emp.usrtable");
        rows = new ArrayList();
        while (rs.next()) {
            rows.add(rs.getInt(1) + "-" + rs.getString(2));
        }
        GfxdOutputFormatTest.assertEquals((int)20030, (int)rows.size());
        st.close();
        conn.close();
        server.stop(props);
    }

    public void testCreateQueryFromObj() throws Exception {
        Configuration conf = new Configuration();
        conf.set("gfxd.output.tablename", "table");
        class DataObject {
            DataObject() {
            }

            public void setCol1(int index, PreparedStatement ps) {
            }

            public void setA(int i, PreparedStatement ps) {
            }

            private void setPrivate(int i, PreparedStatement ps) {
            }

            private void SetCol2(int i, PreparedStatement ps) {
            }

            public void set(int i, PreparedStatement ps) {
            }

            public void no(int i, PreparedStatement ps) {
            }

            public void setNotThis1(PreparedStatement ps, int i) {
            }

            public void setNotThis1(int i, PreparedStatement ps, Object o) {
            }
        }
        DataObject obj = new DataObject();
        OutputFormatUtil util2 = new OutputFormatUtil();
        List columns = util2.spotTableColumnSetters((Object)obj);
        GfxdOutputFormatTest.assertEquals((int)2, (int)columns.size());
        GfxdOutputFormatTest.assertTrue((boolean)columns.contains(DataObject.class.getMethod("setCol1", Integer.TYPE, PreparedStatement.class)));
        GfxdOutputFormatTest.assertTrue((boolean)columns.contains(DataObject.class.getMethod("setA", Integer.TYPE, PreparedStatement.class)));
        String query = util2.createQuery("table", columns);
        if (!query.equals("PUT INTO table(col1, a) VALUES (?, ?);") && !query.equals("PUT INTO table(a, col1) VALUES (?, ?);")) {
            GfxdOutputFormatTest.fail("unexpected query string: " + query);
        }
    }

    public GfxdOutputFormatTest(String name) {
        super(name);
    }
}

