/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.hadoop.mapred.hive;

import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.gemstone.gemfire.internal.FileUtil;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.hive.GFXDHiveInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.hive.GFXDHiveRowRecordReader;
import com.pivotal.gemfirexd.hadoop.mapred.hive.GFXDHiveSplit;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public class GFXDHiveInputFormatTest
extends JdbcTestBase {
    String HDFS_DIR = "./myhdfs";

    public GFXDHiveInputFormatTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        FileUtil.delete((File)new File(this.HDFS_DIR));
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        FileUtil.delete((File)new File(this.HDFS_DIR));
    }

    public void testHiveInputFormat() throws Exception {
        GFXDHiveInputFormatTest.getConnection();
        Connection conn = GFXDHiveInputFormatTest.startNetserverAndGetLocalNetConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' batchtimeinterval 5000 milliseconds");
        st.execute("create table app.mytab1 (col1 int primary key, col2 varchar(100)) persistent hdfsstore (myhdfs) BUCKETS 1");
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        int NUM_ENTRIES = 20;
        for (int i = 0; i < NUM_ENTRIES; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "Value-" + System.nanoTime());
            ps.execute();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] list = fs.listStatus(new Path(this.HDFS_DIR + "/APP_MYTAB1/0/"));
        GFXDHiveInputFormatTest.assertEquals((int)1, (int)list.length);
        conf.set("gfxd.input.tablename", "MYTAB1");
        conf.set("gfxd.input.homedir", this.HDFS_DIR);
        JobConf job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        GFXDHiveInputFormat ipformat = new GFXDHiveInputFormat();
        InputSplit[] splits = ipformat.getSplits(job, 2);
        GFXDHiveInputFormatTest.assertEquals((int)1, (int)splits.length);
        GFXDHiveSplit split = (GFXDHiveSplit)splits[0];
        GFXDHiveInputFormatTest.assertEquals((int)1, (int)split.getPaths().length);
        GFXDHiveInputFormatTest.assertEquals((String)list[0].getPath().toString(), (String)split.getPath(0).toString());
        GFXDHiveInputFormatTest.assertEquals((long)0L, (long)split.getOffset(0));
        GFXDHiveInputFormatTest.assertEquals((long)list[0].getLen(), (long)split.getLength(0));
        RecordReader rr = ipformat.getRecordReader((InputSplit)split, job, null);
        GFXDHiveInputFormatTest.assertTrue((String)("Row record reader should be an instace of GFXDHiveRowRecordReader but it is an instance of " + rr.getClass()), (boolean)(rr instanceof GFXDHiveRowRecordReader));
        Key key = (Key)rr.createKey();
        Row value = (Row)rr.createValue();
        int count = 0;
        while (rr.next((Object)key, (Object)value)) {
            GFXDHiveInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        GFXDHiveInputFormatTest.assertEquals((int)20, (int)count);
        TestUtil.shutDown();
    }
}

