/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.hadoop.mapred;

import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.gemstone.gemfire.internal.FileUtil;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class EventInputFormatTest
extends JdbcTestBase {
    String HDFS_DIR = "./myhdfs";

    public void testEventInputFormat() throws Exception {
        EventInputFormatTest.getConnection();
        Connection conn = EventInputFormatTest.startNetserverAndGetLocalNetConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' batchtimeinterval 5000 milliseconds");
        st.execute("create table app.mytab1 (col1 int primary key, col2 varchar(100)) persistent hdfsstore (myhdfs) BUCKETS 1");
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        int NUM_ENTRIES = 20;
        for (int i = 0; i < NUM_ENTRIES; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "Value-" + System.nanoTime());
            ps.execute();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] list = fs.listStatus(new Path(this.HDFS_DIR + "/APP_MYTAB1/0/"));
        EventInputFormatTest.assertEquals((int)1, (int)list.length);
        conf.set("gfxd.input.tablename", "MYTAB1");
        conf.set("gfxd.input.homedir", this.HDFS_DIR);
        JobConf job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        RowInputFormat ipformat = new RowInputFormat();
        InputSplit[] splits = ipformat.getSplits(job, 2);
        EventInputFormatTest.assertEquals((int)1, (int)splits.length);
        CombineFileSplit split = (CombineFileSplit)splits[0];
        EventInputFormatTest.assertEquals((int)1, (int)split.getPaths().length);
        EventInputFormatTest.assertEquals((String)list[0].getPath().toString(), (String)split.getPath(0).toString());
        EventInputFormatTest.assertEquals((long)0L, (long)split.getOffset(0));
        EventInputFormatTest.assertEquals((long)list[0].getLen(), (long)split.getLength(0));
        RecordReader rr = ipformat.getRecordReader((InputSplit)split, job, null);
        Key key = (Key)rr.createKey();
        Row value = (Row)rr.createValue();
        int count = 0;
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)20, (int)count);
        TestUtil.shutDown();
    }

    public void testNoSecureHdfsCheck() throws Exception {
        EventInputFormatTest.getConnection();
        Connection conn = EventInputFormatTest.startNetserverAndGetLocalNetConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "'  batchtimeinterval 5000 milliseconds");
        st.execute("create table app.mytab1 (col1 int primary key, col2 varchar(100)) persistent hdfsstore (myhdfs) BUCKETS 1");
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        int NUM_ENTRIES = 20;
        for (int i = 0; i < NUM_ENTRIES; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "Value-" + System.nanoTime());
            ps.execute();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        EventInputFormatTest.stopNetServer();
        FabricServiceManager.currentFabricServiceInstance().stop(new Properties());
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] list = fs.listStatus(new Path(this.HDFS_DIR + "/APP_MYTAB1/0/"));
        EventInputFormatTest.assertEquals((int)1, (int)list.length);
        conf.set("gfxd.input.tablename", "MYTAB1");
        conf.set("gfxd.input.homedir", this.HDFS_DIR);
        conf.set("hadoop.security.authentication", "kerberos");
        JobConf job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        RowInputFormat ipformat = new RowInputFormat();
        InputSplit[] splits = ipformat.getSplits(job, 2);
        EventInputFormatTest.assertEquals((int)1, (int)splits.length);
        CombineFileSplit split = (CombineFileSplit)splits[0];
        EventInputFormatTest.assertEquals((int)1, (int)split.getPaths().length);
        EventInputFormatTest.assertEquals((String)list[0].getPath().toString(), (String)split.getPath(0).toString());
        EventInputFormatTest.assertEquals((long)0L, (long)split.getOffset(0));
        EventInputFormatTest.assertEquals((long)list[0].getLen(), (long)split.getLength(0));
        RecordReader rr = ipformat.getRecordReader((InputSplit)split, job, null);
        Key key = (Key)rr.createKey();
        Row value = (Row)rr.createValue();
        int count = 0;
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)20, (int)count);
        TestUtil.shutDown();
    }

    public void testNBuckets1Split() throws Exception {
        int[] check;
        EventInputFormatTest.getConnection();
        Connection conn = EventInputFormatTest.startNetserverAndGetLocalNetConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' batchtimeinterval 5000 milliseconds");
        st.execute("create table app.mytab1 (col1 int primary key, col2 varchar(100)) persistent hdfsstore (myhdfs) BUCKETS 5");
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        int NUM_ENTRIES = 20;
        for (int i = 0; i < NUM_ENTRIES; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "Value-" + System.nanoTime());
            ps.execute();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] list = fs.listStatus(new Path(this.HDFS_DIR + "/APP_MYTAB1/"));
        EventInputFormatTest.assertEquals((int)5, (int)list.length);
        int hopCount = 0;
        for (FileStatus bucket : list) {
            FileStatus[] hops = fs.listStatus(bucket.getPath());
            hopCount += hops.length;
        }
        EventInputFormatTest.assertEquals((int)5, (int)hopCount);
        conf.set("gfxd.input.tablename", "MYTAB1");
        conf.set("gfxd.input.homedir", this.HDFS_DIR);
        JobConf job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        RowInputFormat ipformat = new RowInputFormat();
        InputSplit[] splits = ipformat.getSplits(job, 2);
        EventInputFormatTest.assertEquals((int)1, (int)splits.length);
        CombineFileSplit split = (CombineFileSplit)splits[0];
        EventInputFormatTest.assertEquals((int)hopCount, (int)split.getPaths().length);
        RecordReader rr = ipformat.getRecordReader((InputSplit)split, job, null);
        Key key = (Key)rr.createKey();
        Row value = (Row)rr.createValue();
        for (int i : check = new int[NUM_ENTRIES]) {
            check[i] = 0;
        }
        while (rr.next((Object)key, (Object)value)) {
            int index;
            int n = index = value.getRowAsResultSet().getInt("col1");
            check[n] = check[n] + 1;
        }
        for (int i : check) {
            EventInputFormatTest.assertEquals((int)check[i], (int)1);
        }
        TestUtil.shutDown();
    }

    public void testTimeFilters() throws Exception {
        EventInputFormatTest.getConnection();
        Connection conn = EventInputFormatTest.startNetserverAndGetLocalNetConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' batchtimeinterval 5000 milliseconds");
        st.execute("create table app.mytab1 (col1 int primary key, col2 varchar(100)) persistent hdfsstore (myhdfs) BUCKETS 1");
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        int NUM_ENTRIES = 10;
        for (int i = 0; i < NUM_ENTRIES; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "Value-" + System.nanoTime());
            ps.execute();
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] list = fs.listStatus(new Path(this.HDFS_DIR + "/APP_MYTAB1/0/"));
        EventInputFormatTest.assertEquals((int)1, (int)list.length);
        conf.set("gfxd.input.tablename", "MYTAB1");
        conf.set("gfxd.input.homedir", this.HDFS_DIR);
        JobConf job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        RowInputFormat ipformat = new RowInputFormat();
        InputSplit[] splits = ipformat.getSplits(job, 2);
        EventInputFormatTest.assertEquals((int)1, (int)splits.length);
        RecordReader rr = ipformat.getRecordReader(splits[0], job, null);
        Key key = (Key)rr.createKey();
        Row value = (Row)rr.createValue();
        int count = 0;
        long ts0 = 0L;
        long ts3 = 0L;
        long ts5 = 0L;
        long ts9 = 0L;
        while (rr.next((Object)key, (Object)value)) {
            switch (count) {
                case 0: {
                    ts0 = value.getTimestamp();
                    break;
                }
                case 3: {
                    ts3 = value.getTimestamp();
                    break;
                }
                case 5: {
                    ts5 = value.getTimestamp();
                    break;
                }
                case 9: {
                    ts9 = value.getTimestamp();
                }
            }
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)10, (int)count);
        EventInputFormatTest.assertTrue((ts0 > 0L ? 1 : 0) != 0);
        EventInputFormatTest.assertTrue((ts3 > 0L ? 1 : 0) != 0);
        EventInputFormatTest.assertTrue((ts5 > 0L ? 1 : 0) != 0);
        EventInputFormatTest.assertTrue((ts9 > 0L ? 1 : 0) != 0);
        job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        job.setLong("gfxd.input.starttimemillis", ts0 - 1L);
        rr = ipformat.getRecordReader(splits[0], job, null);
        key = (Key)rr.createKey();
        value = (Row)rr.createValue();
        count = 0;
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)10, (int)count);
        job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        job.setLong("gfxd.input.starttimemillis", ts3);
        rr = ipformat.getRecordReader(splits[0], job, null);
        key = (Key)rr.createKey();
        value = (Row)rr.createValue();
        count = 3;
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)10, (int)count);
        job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        job.setLong("gfxd.input.starttimemillis", ts9);
        rr = ipformat.getRecordReader(splits[0], job, null);
        key = (Key)rr.createKey();
        value = (Row)rr.createValue();
        count = 9;
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)10, (int)count);
        job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        job.setLong("gfxd.input.starttimemillis", ts9 + 1L);
        rr = ipformat.getRecordReader(splits[0], job, null);
        key = (Key)rr.createKey();
        value = (Row)rr.createValue();
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.fail();
        }
        job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        job.setLong("gfxd.input.endtimemillis", ts9);
        rr = ipformat.getRecordReader(splits[0], job, null);
        key = (Key)rr.createKey();
        value = (Row)rr.createValue();
        count = 0;
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)10, (int)count);
        job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        job.setLong("gfxd.input.endtimemillis", ts5 - 1L);
        rr = ipformat.getRecordReader(splits[0], job, null);
        key = (Key)rr.createKey();
        value = (Row)rr.createValue();
        count = 0;
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)5, (int)count);
        job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        job.setLong("gfxd.input.starttimemillis", ts3);
        job.setLong("gfxd.input.endtimemillis", ts5);
        rr = ipformat.getRecordReader(splits[0], job, null);
        key = (Key)rr.createKey();
        value = (Row)rr.createValue();
        count = 3;
        while (rr.next((Object)key, (Object)value)) {
            EventInputFormatTest.assertEquals((int)count++, (int)value.getRowAsResultSet().getInt("col1"));
        }
        EventInputFormatTest.assertEquals((int)6, (int)count);
        TestUtil.shutDown();
    }

    public void testRowSerDe() throws Exception {
        this.doTestRowSerDe(true);
    }

    public void testRowSerDeNoConcurrencyChecks() throws Exception {
        this.doTestRowSerDe(false);
    }

    private void doTestRowSerDe(boolean concurrencyChecks) throws Exception {
        EventInputFormatTest.getConnection();
        Connection conn = EventInputFormatTest.startNetserverAndGetLocalNetConnection();
        long statTS = System.currentTimeMillis();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' batchtimeinterval 5000 milliseconds");
        String concurrency = "persistent ENABLE CONCURRENCY CHECKS";
        st.execute("create table app.mytab1 (col1 int primary key, col2 varchar(100)) partition by primary key buckets 1 hdfsstore (myhdfs) " + (concurrencyChecks ? concurrency : ""));
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        ps.setInt(1, 1);
        ps.setString(2, "Value-1");
        ps.execute();
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] list = fs.listStatus(new Path(this.HDFS_DIR + "/APP_MYTAB1/0/"));
        EventInputFormatTest.assertEquals((int)1, (int)list.length);
        conf.set("gfxd.input.tablename", "MYTAB1");
        conf.set("gfxd.input.homedir", this.HDFS_DIR);
        JobConf job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        RowInputFormat ipformat = new RowInputFormat();
        InputSplit[] splits = ipformat.getSplits(job, 2);
        EventInputFormatTest.assertEquals((int)1, (int)splits.length);
        RecordReader rr = ipformat.getRecordReader(splits[0], job, null);
        Key key = (Key)rr.createKey();
        Row value = (Row)rr.createValue();
        EventInputFormatTest.assertTrue((boolean)rr.next((Object)key, (Object)value));
        EventInputFormatTest.assertEquals((int)1, (int)value.getRowAsResultSet().getInt(1));
        EventInputFormatTest.assertEquals((String)"Value-1", (String)value.getRowAsResultSet().getString(2));
        EventInputFormatTest.assertTrue((value.getTimestamp() > statTS ? 1 : 0) != 0);
        EventInputFormatTest.assertFalse((boolean)value.getRowAsResultSet().next());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        value.write((DataOutput)dos);
        dos.close();
        byte[] buf = baos.toByteArray();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        Row row = new Row();
        row.readFields((DataInput)dis);
        dis.close();
        EventInputFormatTest.assertEquals((int)1, (int)row.getRowAsResultSet().getInt(1));
        EventInputFormatTest.assertEquals((String)"Value-1", (String)row.getRowAsResultSet().getString(2));
        EventInputFormatTest.assertFalse((boolean)value.getRowAsResultSet().next());
        TestUtil.shutDown();
    }

    public void testDeleteForRW() throws Exception {
        this.deleteTest(false, true);
    }

    public void testDeleteForWriteOnly() throws Exception {
        this.deleteTest(true, true);
    }

    public void testDeleteForWriteOnly_transactional() throws Exception {
        this.deleteTest(true, true, true);
    }

    public void testDeleteForRWNoPk() throws Exception {
        this.deleteTest(false, false);
    }

    public void testDeleteForWriteOnlyNoPK() throws Exception {
        this.deleteTest(true, false);
    }

    public void testDeleteForWriteOnlyNoPK_transactional() throws Exception {
        this.deleteTest(true, false, true);
    }

    private void deleteTest(boolean writeOnly, boolean primaryKey) throws Exception {
        this.deleteTest(writeOnly, primaryKey, false);
    }

    public static Connection getTxConnection() throws SQLException {
        Connection conn = EventInputFormatTest.getConnection();
        conn.setAutoCommit(true);
        conn.setTransactionIsolation(2);
        return conn;
    }

    private void deleteTest(boolean writeOnly, boolean primaryKey, boolean isTransactional) throws Exception {
        Connection conn = null;
        conn = isTransactional ? EventInputFormatTest.getTxConnection() : EventInputFormatTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + this.HDFS_DIR + "' batchtimeinterval 2000 milliseconds");
        String primaryKeyString = primaryKey ? "primary key" : "";
        st.execute("create table app.mytab1 (col1 int " + primaryKeyString + ", col2 varchar(100)) BUCKETS 1 persistent hdfsstore (myhdfs) " + (writeOnly ? " WRITEONLY " : ""));
        PreparedStatement ps = conn.prepareStatement("insert into mytab1 values (?, ?)");
        for (int i = 0; i < 3; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "Value-" + System.nanoTime());
            ps.execute();
        }
        st.execute("delete from mytab1 where col1 = 1");
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        TestUtil.shutDown();
        FileStatus[] list = null;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (int i = 0; i < 20 && (list = fs.listStatus(new Path(this.HDFS_DIR + "/APP_MYTAB1/0/"))).length != 1; ++i) {
            Thread.sleep(500L);
        }
        if (list.length != 1) {
            EventInputFormatTest.fail("unexpected files: " + Arrays.toString(list));
        }
        conf.set("gfxd.input.tablename", "MYTAB1");
        conf.set("gfxd.input.homedir", this.HDFS_DIR);
        JobConf job = new JobConf(conf);
        job.setBoolean("gfxd.input.checkpointmode", false);
        RowInputFormat ipformat = new RowInputFormat();
        InputSplit[] splits = ipformat.getSplits(job, 2);
        RecordReader rr = ipformat.getRecordReader(splits[0], job, null);
        Key key = (Key)rr.createKey();
        Row value = (Row)rr.createValue();
        rr.next((Object)key, (Object)value);
        EventInputFormatTest.assertEquals((int)0, (int)value.getRowAsResultSet().getInt("col1"));
        if (!writeOnly) {
            rr.next((Object)key, (Object)value);
            this.checkForDeletedRow(value, primaryKey);
        }
        rr.next((Object)key, (Object)value);
        EventInputFormatTest.assertEquals((int)1, (int)value.getRowAsResultSet().getInt("col1"));
        rr.next((Object)key, (Object)value);
        EventInputFormatTest.assertEquals((int)2, (int)value.getRowAsResultSet().getInt("col1"));
        if (writeOnly) {
            rr.next((Object)key, (Object)value);
            this.checkForDeletedRow(value, primaryKey);
        }
        EventInputFormatTest.assertFalse((boolean)rr.next((Object)key, (Object)value));
        TestUtil.shutDown();
    }

    private void checkForDeletedRow(Row value, boolean primaryKey) throws IOException, SQLException {
        EventInputFormatTest.assertTrue((String)("Operation shoud be destroy but it is " + value.getEventType()), (boolean)value.getEventType().equals((Object)Event.Type.AFTER_DELETE));
        ResultSet rs = value.getRowAsResultSet();
        if (primaryKey) {
            EventInputFormatTest.assertEquals((int)1, (int)rs.getInt("col1"));
        } else {
            EventInputFormatTest.assertEquals(null, (Object)rs.getObject("col1"));
        }
        EventInputFormatTest.assertEquals(null, (String)rs.getString("col2"));
    }

    @Override
    public void setUp() throws Exception {
        FileUtil.delete((File)new File(this.HDFS_DIR));
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        FileUtil.delete((File)new File(this.HDFS_DIR));
    }

    public EventInputFormatTest(String name) {
        super(name);
    }
}

