/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VarcharPartitionTest
extends JdbcTestBase {
    private static volatile Connection derbyConn = null;
    private static volatile Connection gfxdConn = null;
    private ResultSet rsGfxd = null;
    private ResultSet rsDerby = null;
    private static int mcastPort;

    public VarcharPartitionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(VarcharPartitionTest.class));
    }

    public static ResultSet executeQueryOnDerby(String sql) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            VarcharPartitionTest.loadDerbyDriver();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        ResultSet rs = null;
        rs = derbyConn.createStatement().executeQuery(sql);
        return rs;
    }

    public static int executeUpdateOnDerby(String sql) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            VarcharPartitionTest.loadDerbyDriver();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        int ret = 0;
        ret = derbyConn.createStatement().executeUpdate(sql);
        return ret;
    }

    public static ResultSet executeQueryOnGfxd(String sql) throws Exception {
        if (gfxdConn == null) {
            Properties props = new Properties();
            props.put("mcast-port", String.valueOf(mcastPort));
            gfxdConn = TestUtil.getConnection(props);
        }
        ResultSet rs = null;
        rs = gfxdConn.createStatement().executeQuery(sql);
        return rs;
    }

    public static int executeUpdateOnGfxd(String sql) throws Exception {
        if (gfxdConn == null) {
            Properties props = new Properties();
            props.put("mcast-port", String.valueOf(mcastPort));
            gfxdConn = TestUtil.getConnection(props);
        }
        int ret = 0;
        ret = gfxdConn.createStatement().executeUpdate(sql);
        return ret;
    }

    private void compareResultSets(ResultSet rsGfxd, ResultSet rsDerby) throws Exception {
        VarcharPartitionTest.validateResults(rsDerby, rsGfxd, false);
    }

    public void testBug46046() throws Exception {
        mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        String partitionStrategy = "";
        this.partitionBy(partitionStrategy);
        if (gfxdConn != null) {
            gfxdConn.close();
        }
        if (derbyConn != null) {
            derbyConn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionBy(String partitionStrategy) throws Exception {
        try {
            VarcharPartitionTest.executeUpdateOnGfxd("create table varchartab (c1 varchar(1), c2 varchar(1), c3 varchar(5), c4 varchar(5))" + partitionStrategy);
            VarcharPartitionTest.executeUpdateOnDerby("create table varchartab (c1 varchar(1), c2 varchar(1), c3 varchar(5), c4 varchar(5))");
            VarcharPartitionTest.executeUpdateOnGfxd("insert into varchartab values ('', '', '', '')");
            VarcharPartitionTest.executeUpdateOnGfxd("insert into varchartab values ('a', 'a', 'a', 'a')");
            VarcharPartitionTest.executeUpdateOnGfxd("insert into varchartab values ('b', 'b', 'bcdef', 'bcdef')");
            VarcharPartitionTest.executeUpdateOnGfxd("insert into varchartab values (null, null, null, null)");
            VarcharPartitionTest.executeUpdateOnGfxd("insert into varchartab values ('', null, '', null)");
            VarcharPartitionTest.executeUpdateOnGfxd("insert into varchartab values ('a', 'b', 'a', 'b')");
            VarcharPartitionTest.executeUpdateOnGfxd("insert into varchartab values ('b', '', 'b', 'bcdef')");
            VarcharPartitionTest.executeUpdateOnDerby("insert into varchartab values ('', '', '', '')");
            VarcharPartitionTest.executeUpdateOnDerby("insert into varchartab values ('a', 'a', 'a', 'a')");
            VarcharPartitionTest.executeUpdateOnDerby("insert into varchartab values ('b', 'b', 'bcdef', 'bcdef')");
            VarcharPartitionTest.executeUpdateOnDerby("insert into varchartab values (null, null, null, null)");
            VarcharPartitionTest.executeUpdateOnDerby("insert into varchartab values ('', null, '', null)");
            VarcharPartitionTest.executeUpdateOnDerby("insert into varchartab values ('a', 'b', 'a', 'b')");
            VarcharPartitionTest.executeUpdateOnDerby("insert into varchartab values ('b', '', 'b', 'bcdef')");
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 = c2");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 = c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 = c4");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 = c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 = '                 '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 = '                 '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 = ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 = ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 = 'a '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 = 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 = 'b                               '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 = 'b                               '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 = 'bb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 = 'bb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 = ' '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 = ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 = ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 = ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 = 'a    '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 = 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 = 'bcdef                   '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 = 'bcdef                   '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 = 'bbbb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 = 'bbbb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '                 ' = c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '                 ' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '' = c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'a ' = c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'a ' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'b                               ' = c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'b                               ' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'bb' = c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'bb' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where ' ' = c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where ' ' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where '' = c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where '' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'a    ' = c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'a    ' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bcdef                   ' = c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bcdef                   ' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bbbb' = c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bbbb' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <> c2");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <> c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <> c4");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <> c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <> '                 '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <> '                 '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <> ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <> ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <> 'a '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <> 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <> 'b                               '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <> 'b                               '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <> 'bb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <> 'bb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <> ' '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <> ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <> ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <> ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <> 'a    '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <> 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <> 'bcdef                   '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <> 'bcdef                   '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <> 'bbbb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <> 'bbbb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 != '                 '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 != '                 '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 != ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 != ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 != 'a '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 != 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 != 'b                               '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 != 'b                               '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 != 'bb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 != 'bb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 != ' '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 != ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 != ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 != ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 != 'a    '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 != 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 != 'bcdef                   '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 != 'bcdef                   '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 != 'bbbb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 != 'bbbb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '                 ' <> c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '                 ' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '' <> c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'a ' <> c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'a ' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'b                               ' <> c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'b                               ' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'bb' <> c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'bb' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where ' ' <> c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where ' ' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where '' <> c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where '' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'a    ' <> c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'a    ' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bcdef                   ' <> c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bcdef                   ' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bbbb' <> c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bbbb' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 < c2");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 < c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 < c4");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 < c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 < '                 '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 < '                 '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 < ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 < ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 < 'a '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 < 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 < 'b                               '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 < 'b                               '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 < 'bb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 < 'bb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 < ' '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 < ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 < ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 < ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 < 'a    '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 < 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 < 'bcdef                   '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 < 'bcdef                   '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 < 'bbbb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 < 'bbbb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '                 ' < c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '                 ' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '' < c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'a ' < c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'a ' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'b                               ' < c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'b                               ' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'bb' < c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'bb' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where ' ' < c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where ' ' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where '' < c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where '' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'a    ' < c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'a    ' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bcdef                   ' < c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bcdef                   ' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bbbb' < c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bbbb' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 > c2");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 > c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 > c4");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 > c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 > '                 '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 > '                 '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 > ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 > ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 > 'a '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 > 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 > 'b                               '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 > 'b                               '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 > 'bb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 > 'bb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 > ' '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 > ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 > ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 > ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 > 'a    '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 > 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 > 'bcdef                   '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 > 'bcdef                   '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 > 'bbbb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 > 'bbbb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '                 ' > c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '                 ' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '' > c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'a ' > c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'a ' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'b                               ' > c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'b                               ' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'bb' > c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'bb' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where ' ' > c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where ' ' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where '' > c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where '' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'a    ' > c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'a    ' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bcdef                   ' > c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bcdef                   ' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bbbb' > c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bbbb' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <= c2");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <= c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <= c4");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <= c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <= '                 '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <= '                 '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <= ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <= ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <= 'a '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <= 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <= 'b                               '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <= 'b                               '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 <= 'bb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 <= 'bb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <= ' '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <= ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <= ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <= ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <= 'a    '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <= 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <= 'bcdef                   '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <= 'bcdef                   '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 <= 'bbbb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 <= 'bbbb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '                 ' <= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '                 ' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '' <= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'a ' <= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'a ' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'b                               ' <= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'b                               ' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'bb' <= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'bb' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where ' ' <= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where ' ' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where '' <= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where '' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'a    ' <= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'a    ' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bcdef                   ' <= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bcdef                   ' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bbbb' <= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bbbb' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 >= c2");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 >= c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 >= c4");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 >= c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 >= '                 '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 >= '                 '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 >= ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 >= ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 >= 'a '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 >= 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 >= 'b                               '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 >= 'b                               '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 >= 'bb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 >= 'bb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 >= ' '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 >= ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 >= ''");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 >= ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 >= 'a    '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 >= 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 >= 'bcdef                   '");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 >= 'bcdef                   '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where c3 >= 'bbbb'");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where c3 >= 'bbbb'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '                 ' >= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '                 ' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where '' >= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where '' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'a ' >= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'a ' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'b                               ' >= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'b                               ' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where 'bb' >= c1");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where 'bb' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where ' ' >= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where ' ' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where '' >= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where '' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'a    ' >= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'a    ' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bcdef                   ' >= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bcdef                   ' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c3 from varchartab where 'bbbb' >= c3");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c3 from varchartab where 'bbbb' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 is null");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 is null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where c1 is not null");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where c1 is not null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharPartitionTest.executeQueryOnGfxd("select c1 from varchartab where not c1 is null");
            this.rsDerby = VarcharPartitionTest.executeQueryOnDerby("select c1 from varchartab where not c1 is null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
        }
        finally {
            if (this.rsGfxd != null) {
                this.rsGfxd.close();
            }
            if (this.rsDerby != null) {
                this.rsDerby.close();
            }
            VarcharPartitionTest.executeUpdateOnGfxd("drop table varchartab");
            VarcharPartitionTest.executeUpdateOnDerby("drop table varchartab");
        }
    }
}

