/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import io.snappydata.test.util.TestException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VarcharForBitDataPartitionTest
extends JdbcTestBase {
    private static volatile Connection derbyConn = null;
    private static volatile Connection gfxdConn = null;
    private ResultSet rsGfxd = null;
    private ResultSet rsDerby = null;
    private static int mcastPort;

    public VarcharForBitDataPartitionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(VarcharForBitDataPartitionTest.class));
    }

    public static ResultSet executeQueryOnDerby(String sql) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            VarcharForBitDataPartitionTest.loadDerbyDriver();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        ResultSet rs = null;
        rs = derbyConn.createStatement().executeQuery(sql);
        return rs;
    }

    public static int executeUpdateOnDerby(String sql) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            VarcharForBitDataPartitionTest.loadDerbyDriver();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        int ret = 0;
        ret = derbyConn.createStatement().executeUpdate(sql);
        return ret;
    }

    public static ResultSet executeQueryOnGfxd(String sql) throws Exception {
        if (gfxdConn == null) {
            Properties props = new Properties();
            props.put("mcast-port", String.valueOf(mcastPort));
            gfxdConn = TestUtil.getConnection(props);
        }
        ResultSet rs = null;
        rs = gfxdConn.createStatement().executeQuery(sql);
        return rs;
    }

    public static int executeUpdateOnGfxd(String sql) throws Exception {
        if (gfxdConn == null) {
            Properties props = new Properties();
            props.put("mcast-port", String.valueOf(mcastPort));
            gfxdConn = TestUtil.getConnection(props);
        }
        int ret = 0;
        ret = gfxdConn.createStatement().executeUpdate(sql);
        return ret;
    }

    private Vector<byte[]> convertToVector(ResultSet rs) throws Exception {
        Vector<byte[]> v = new Vector<byte[]>();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                v.add(rs.getBytes(i));
            }
        }
        return v;
    }

    private String vectorToString(Vector<byte[]> v) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("The size of list is " + v.size() + "\n");
        for (int i = 0; i < v.size(); ++i) {
            byte[] aStruct = v.get(i);
            for (int j = 0; j < aStruct.length; ++j) {
                aStr.append(aStruct[j]);
            }
            aStr.append("\n");
        }
        return aStr.toString();
    }

    private int findInVector(Vector<byte[]> v, byte[] b) {
        for (int i = 0; i < v.size(); ++i) {
            if (!Arrays.equals(v.get(i), b)) continue;
            return i;
        }
        return -1;
    }

    private void compareResultSets(ResultSet rsGfxd, ResultSet rsDerby) throws Exception {
        Vector<byte[]> gfxdV = this.convertToVector(rsGfxd);
        Vector<byte[]> derbyV = this.convertToVector(rsDerby);
        Vector<byte[]> derbyVCopy = new Vector<byte[]>(derbyV);
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < gfxdV.size(); ++i) {
            int idx = this.findInVector(derbyVCopy, gfxdV.get(i));
            if (idx == -1) continue;
            derbyVCopy.remove(idx);
        }
        Vector<byte[]> missing = derbyVCopy;
        if (gfxdV.size() != derbyV.size() || missing.size() > 0) {
            Vector<byte[]> gfxdVCopy = new Vector<byte[]>(gfxdV);
            for (int i = 0; i < derbyV.size(); ++i) {
                int idx = this.findInVector(gfxdVCopy, derbyV.get(i));
                if (idx == -1) continue;
                gfxdVCopy.remove(idx);
            }
            Vector<byte[]> unexpected = gfxdVCopy;
            if (unexpected.size() > 0) {
                aStr.append("the following " + unexpected.size() + " elements are unexpected from GemFireXD: " + this.vectorToString(unexpected));
            }
        }
        if (missing.size() > 0) {
            aStr.append("the following " + missing.size() + " elements are missing in GemFireXD: " + this.vectorToString(missing));
        }
        if (aStr.length() != 0) {
            this.logger.info((Object)("ResultSet from GemFireXD is " + this.vectorToString(gfxdV)));
            this.logger.info((Object)("ResultSet from Derby is " + this.vectorToString(derbyV)));
            this.logger.info((Object)("ResultSet difference is " + aStr.toString()));
            throw new TestException(aStr.toString());
        }
        if (gfxdV.size() != derbyV.size()) {
            if (gfxdV.size() < derbyV.size()) {
                throw new TestException("There are more data in Derby ResultSet");
            }
            throw new TestException("There are fewer data in Derby ResultSet");
        }
        this.logger.info((Object)"verified that results are correct");
        rsGfxd.close();
        rsDerby.close();
    }

    public void testBug46046() throws Exception {
        mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        String partitionStrategy = "";
        this.partitionBy(partitionStrategy);
        if (gfxdConn != null) {
            gfxdConn.close();
        }
        if (derbyConn != null) {
            derbyConn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionBy(String partitionStrategy) throws Exception {
        try {
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("create table varcharfbdtab (c1 varchar(1) for bit data, c2 varchar(1) for bit data, c3 varchar(5) for bit data, c4 varchar(5) for bit data)" + partitionStrategy);
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("create table varcharfbdtab (c1 varchar(1) for bit data, c2 varchar(1) for bit data, c3 varchar(5) for bit data, c4 varchar(5) for bit data)");
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("insert into varcharfbdtab values (x'', x'', x'', x'')");
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("insert into varcharfbdtab values (x'41', x'41', x'41', x'41')");
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("insert into varcharfbdtab values (x'42', x'42', x'4243444546', x'4243444546')");
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("insert into varcharfbdtab values (null, null, null, null)");
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("insert into varcharfbdtab values (x'', null, x'', null)");
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("insert into varcharfbdtab values (x'41', x'42', x'41', x'42')");
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("insert into varcharfbdtab values (x'42', x'', x'42', x'4243444546')");
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("insert into varcharfbdtab values (x'', x'', x'', x'')");
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("insert into varcharfbdtab values (x'41', x'41', x'41', x'41')");
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("insert into varcharfbdtab values (x'42', x'42', x'4243444546', x'4243444546')");
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("insert into varcharfbdtab values (null, null, null, null)");
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("insert into varcharfbdtab values (x'', null, x'', null)");
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("insert into varcharfbdtab values (x'41', x'42', x'41', x'42')");
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("insert into varcharfbdtab values (x'42', x'', x'42', x'4243444546')");
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 = c2");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 = c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 = c4");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 = c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 = x'202020202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 = x'202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 = x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 = x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 = x'4120'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 = x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 = x'4220202020202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 = x'4220202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 = x'4242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 = x'4242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 = x'20'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 = x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 = x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 = x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 = x'4120202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 = x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 = x'4243444546202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 = x'4243444546202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 = x'42424242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 = x'42424242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'2020202020202020' = c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'2020202020202020' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'' = c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4120' = c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4120' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4220202020202020' = c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4220202020202020' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4242' = c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4242' = c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'20' = c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'20' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'' = c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'4120202020' = c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'4120202020' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'424344454620202020202020' = c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'424344454620202020202020' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'42424242' = c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'42424242' = c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <> c2");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <> c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <> c4");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <> c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <> x'20202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <> x'20202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <> x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <> x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <> x'4120'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <> x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <> x'4220202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <> x'4220202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <> x'4242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <> x'4242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <> x'20'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <> x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <> x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <> x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <> x'4120202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <> x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <> x'424344454620202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <> x'424344454620202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <> x'42424242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <> x'42424242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 != x'20202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 != x'20202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 != x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 != x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 != x'4120'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 != x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 != x'4220202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 != x'4220202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 != x'4242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 != x'4242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 != x'20'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 != x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 != x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 != x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 != x'4120202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 != x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 != x'424344454620202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 != x'424344454620202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 != x'42424242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 != x'42424242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'20202020202020' <> c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'20202020202020' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'' <> c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4120' <> c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4120' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4220202020202020' <> c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4220202020202020' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4242' <> c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4242' <> c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'20' <> c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'20' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'' <> c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'4120202020' <> c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'4120202020' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'424344454620202020202020' <> c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'424344454620202020202020' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'42424242' <> c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'42424242' <> c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 < c2");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 < c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 < c4");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 < c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 < x'20202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 < x'20202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 < x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 < x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 < x'4120'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 < x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 < x'4220202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 < x'4220202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 < x'4242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 < x'4242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 < x'20'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 < x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 < x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 < x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 < x'4120202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 < x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 < x'424344454620202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 < x'424344454620202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 < x'42424242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 < x'42424242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'20202020202020' < c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'20202020202020' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'' < c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4120' < c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4120' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4220202020202020' < c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4220202020202020' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4242' < c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4242' < c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'20' < c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'20' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'' < c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'4120202020' < c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'4120202020' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'424344454620202020202020' < c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'424344454620202020202020' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'42424242' < c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'42424242' < c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 > c2");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 > c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 > c4");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 > c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 > x'20202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 > x'20202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 > x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 > x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 > x'4120'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 > x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 > x'4220202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 > x'4220202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 > x'4242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 > x'4242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 > x'20'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 > x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 > x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 > x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 > x'4120202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 > x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 > x'424344454620202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 > x'424344454620202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 > x'42424242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 > x'42424242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'20202020202020' > c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'20202020202020' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'' > c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4120' > c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4120' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4220202020202020' > c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4220202020202020' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4242' > c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4242' > c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'20' > c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'20' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'' > c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'4120202020' > c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'4120202020' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'424344454620202020202020' > c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'424344454620202020202020' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'42424242' > c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'42424242' > c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <= c2");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <= c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <= c4");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <= c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <= x'20202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <= x'20202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <= x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <= x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <= x'4120'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <= x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <= x'4220202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <= x'4220202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 <= x'4242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 <= x'4242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <= x'20'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <= x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <= x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <= x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <= x'4120202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <= x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <= x'424344454620202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <= x'424344454620202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 <= x'42424242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 <= x'42424242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'20202020202020' <= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'20202020202020' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'' <= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4120' <= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4120' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4220202020202020' <= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4220202020202020' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4242' <= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4242' <= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'20' <= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'20' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'' <= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'4120202020' <= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'4120202020' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'424344454620202020202020' <= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'424344454620202020202020' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'42424242' <= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'42424242' <= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 >= c2");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 >= c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 >= c4");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 >= c4");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 >= x'20202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 >= x'20202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 >= x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 >= x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 >= x'4120'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 >= x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 >= x'4220202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 >= x'4220202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 >= x'4242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 >= x'4242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 >= x'20'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 >= x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 >= x''");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 >= x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 >= x'4120202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 >= x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 >= x'424344454620202020202020'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 >= x'424344454620202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where c3 >= x'42424242'");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where c3 >= x'42424242'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'20202020202020' >= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'20202020202020' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'' >= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4120' >= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4120' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4220202020202020' >= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4220202020202020' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where x'4242' >= c1");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where x'4242' >= c1");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'20' >= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'20' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'' >= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'4120202020' >= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'4120202020' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'424344454620202020202020' >= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'424344454620202020202020' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c3 from varcharfbdtab where x'42424242' >= c3");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c3 from varcharfbdtab where x'42424242' >= c3");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 is null");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 is null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where c1 is not null");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where c1 is not null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = VarcharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from varcharfbdtab where not c1 is null");
            this.rsDerby = VarcharForBitDataPartitionTest.executeQueryOnDerby("select c1 from varcharfbdtab where not c1 is null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
        }
        finally {
            if (this.rsGfxd != null) {
                this.rsGfxd.close();
            }
            if (this.rsDerby != null) {
                this.rsDerby.close();
            }
            VarcharForBitDataPartitionTest.executeUpdateOnGfxd("drop table varcharfbdtab");
            VarcharForBitDataPartitionTest.executeUpdateOnDerby("drop table varcharfbdtab");
        }
    }
}

