/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.OSType;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class StatementStatsTest
extends JdbcTestBase {
    public StatementStatsTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(StatementStatsTest.class));
    }

    @Override
    protected void setUp() throws Exception {
        System.setProperty("gemfire.loadLibrary.debug", "true");
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("gemfire.loadLibrary.debug");
    }

    public void testBug44661() throws SQLException {
        Statistics[] stats;
        Properties p = new Properties();
        p.setProperty("enable-stats", "true");
        Connection conn = StatementStatsTest.getConnection(p);
        Statement st = conn.createStatement();
        DatabaseMetaData dbm = conn.getMetaData();
        ResultSet rs = dbm.getTables(null, null, "course".toUpperCase(), new String[]{"TABLE"});
        boolean found = rs.next();
        rs.close();
        if (found) {
            st.execute("drop table course ");
        }
        rs = dbm.getTables(null, null, "games".toUpperCase(), new String[]{"TABLE"});
        found = rs.next();
        rs.close();
        if (found) {
            st.execute("drop table games ");
        }
        st.execute("CREATE TABLE GAMES ( PLAYER_ID CHAR(8) NOT NULL,YEAR_NO      BIGINT NOT NULL,TEAM      CHAR(3) NOT NULL,WEEK      BIGINT NOT NULL,OPPONENT  CHAR(3) ,COMPLETES BIGINT ,ATTEMPTS  BIGINT ,PASSING_YARDS BIGINT ,PASSING_TD    BIGINT ,INTERCEPTIONS BIGINT ,RUSHES BIGINT ,RUSH_YARDS BIGINT ,RECEPTIONS BIGINT ,RECEPTIONS_YARDS BIGINT ,TOTAL_TD BIGINT) ");
        ResultSet colM = conn.getMetaData().getColumns(null, null, "GAMES", "YEAR_NO");
        while (colM.next()) {
            String cname = colM.getString("COLUMN_NAME");
            int ctype = colM.getInt("DATA_TYPE");
            System.out.println(cname + " of type " + ctype);
        }
        st.execute("create table course (course_id int, i int, course_name varchar(10),  primary key(course_id)) partition by primary key ");
        st.execute("insert            into course values (1, 1, 'd')");
        st.execute("insert\n\ninto course values (2, 2, 'd')");
        st.execute("insert into \"COURSE\" (\"COURSE_ID\", \"I\", \"COURSE_NAME\") values (3, 3, 'd')");
        ResultSet qRs = st.executeQuery("SELECT \"COURSE_ID\", \"I\", \"COURSE_NAME\" from -- GEMFIREXD-PROPERTIES statementAlias=\"QUOTE\"D_S\"ELECT_\"NO_\"SPACE\" \n \"COURSE\" ");
        int row = 0;
        while (qRs.next()) {
            ++row;
        }
        StatementStatsTest.assertEquals((int)row, (int)3);
        qRs = st.executeQuery("SELECT \"COURSE_ID\", \"I\", \"COURSE_NAME\" from -- GEMFIREXD-PROPERTIES statementAlias=\"\"QUOTED    SELECT\"\" \n \"COURSE\" ");
        row = 0;
        while (qRs.next()) {
            ++row;
        }
        StatementStatsTest.assertEquals((int)row, (int)3);
        qRs = st.executeQuery("SELECT \"COURSE_ID\", \"I\", \"COURSE_NAME\" from -- GEMFIREXD-PROPERTIES statementAlias=\"QUOTE\"D    S\"ELECT\" \n \"COURSE\" ");
        row = 0;
        while (qRs.next()) {
            ++row;
        }
        StatementStatsTest.assertEquals((int)row, (int)3);
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        StatisticsType statsType = dsys.findType("StatementStats");
        for (Statistics s : stats = dsys.findStatisticsByType(statsType)) {
            String statementDesc = s.getTextId();
            System.out.println(statementDesc);
            StatementStatsTest.assertFalse((boolean)statementDesc.contains("SYS.\"getTables"));
            if (!statementDesc.contains("\"QUOTE\\\"D") && !statementDesc.contains("\"QUOTED")) {
                StatementStatsTest.assertTrue((String)(statementDesc + " contains space "), (!statementDesc.contains(" ") ? 1 : 0) != 0);
                StatementStatsTest.assertTrue((String)(statementDesc + " contains white space "), (statementDesc.split("\\s+").length == 1 ? 1 : 0) != 0);
            }
            if (!statementDesc.contains("\"")) continue;
            StatementStatsTest.assertTrue((String)(statementDesc + " contains unescaped quotes "), (statementDesc.startsWith("\"") && statementDesc.endsWith("\"") ? 1 : 0) != 0);
            int escapedQuoteIndex = statementDesc.indexOf("\\\"");
            if (escapedQuoteIndex <= -1) {
                StatementStatsTest.assertTrue((String)(statementDesc + " contains no nested quotes "), (statementDesc.indexOf("\"", 1) == statementDesc.lastIndexOf("\"") ? 1 : 0) != 0);
                continue;
            }
            StatementStatsTest.assertTrue((String)statementDesc, (escapedQuoteIndex > -1 ? 1 : 0) != 0);
            escapedQuoteIndex = statementDesc.indexOf("\\\"", escapedQuoteIndex + 1);
            StatementStatsTest.assertTrue((String)(statementDesc + " contains unpaired unescaped quotes "), (escapedQuoteIndex > -1 && escapedQuoteIndex != statementDesc.lastIndexOf("\"") - 1 ? 1 : 0) != 0);
        }
    }

    public void testNanoTime() throws Exception {
        Connection conn = TestUtil.getConnection();
        conn.close();
        Thread[] Ts = new Thread[10];
        TestUtil.assertTimerLibraryLoaded();
        Runnable _run = new Runnable(){

            @Override
            public void run() {
                long[] a = new long[1000];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = NanoTimer.nativeNanoTime((int)3, (boolean)true);
                }
                long p = -1L;
                long min = -1L;
                long max = 0L;
                long total = 0L;
                for (long v : a) {
                    if (p == -1L) {
                        min = p = v;
                        continue;
                    }
                    long diff = v - p;
                    if (diff > max) {
                        max = diff;
                    }
                    if (diff < min) {
                        min = diff;
                    }
                    total += diff;
                    if (NativeCalls.getInstance().getOSType() == OSType.GENERIC_POSIX) {
                        TestCase.assertTrue((String)("nanoseconds difference must be greater than zero v=" + v + " p=" + p), (diff > 0L ? 1 : 0) != 0);
                    }
                    p = v;
                }
                TestUtil.getLogger().info((Object)("min=" + min + " max=" + max + " avg=" + total / (long)a.length));
            }
        };
        for (int z = 0; z < Ts.length; ++z) {
            Ts[z] = new Thread(_run, "Thread" + z);
        }
        for (Thread t : Ts) {
            t.start();
        }
        for (Thread t : Ts) {
            t.join();
        }
    }

    public void testNanoTimeWithLongPause() throws Exception {
        Connection conn = TestUtil.getConnection();
        conn.close();
        Thread[] Ts = new Thread[100];
        TestUtil.assertTimerLibraryLoaded();
        Runnable _run = new Runnable(){

            @Override
            public void run() {
                int nestUpto = 80;
                int numTimes = 5;
                long begin = XPLAINUtil.nanoTime();
                for (int i = 0; i < 5; ++i) {
                    StatementStatsTest.populateNestedCalls(80);
                }
                long elapsed = XPLAINUtil.recordTiming((long)begin);
                TestUtil.getLogger().info((Object)(Thread.currentThread().getName() + " ended. took " + elapsed + " ns"));
            }
        };
        for (int z = 0; z < Ts.length; ++z) {
            Ts[z] = new Thread(_run, "Thread" + z);
        }
        for (Thread t : Ts) {
            t.start();
        }
        for (Thread t : Ts) {
            t.join();
        }
    }

    private static int populateNestedCalls(int nestingLevel) {
        long elapsed;
        if (nestingLevel < 0) {
            return nestingLevel;
        }
        long begin = XPLAINUtil.nanoTime();
        StatementStatsTest.populateNestedCalls(nestingLevel - 1);
        if (nestingLevel % 2 == 0) {
            try {
                Thread.sleep(nestingLevel * 5, nestingLevel * 100);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        StatementStatsTest.assertTrue(((elapsed = XPLAINUtil.recordTiming((long)begin)) >= 0L ? 1 : 0) != 0);
        return nestingLevel;
    }
}

