/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.sql.GeneralizedStatement;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSetImpl;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.security.SecurityTestUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicIntegerArray;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class StatementCachingTest
extends JdbcTestBase {
    private volatile boolean shouldWait = true;
    private AtomicIntegerArray stmtCompileState = null;
    private static final ThreadLocal<GemFireXDQueryObserver> tObserver = new ThreadLocal();
    private CountDownLatch countNumThreads = null;
    private boolean ignorePKViolation = false;

    public StatementCachingTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(StatementCachingTest.class));
        System.setProperty("gemfirexd.debug.true", "StatementMatching");
    }

    public void testLike() throws Exception {
        StatementCachingTest.setupConnection();
        Connection conn = StatementCachingTest.startNetserverAndGetLocalNetConnection();
        Statement st = conn.createStatement();
        st.execute("create table e.employee ( id int PRIMARY KEY, fname varchar (50) NOT NULL, lname varchar (50) NULL, email varchar(50) NULL)");
        PreparedStatement ps = conn.prepareStatement("insert into \"E\".employee values (?, ?, ?, ?)");
        int sumId = 0;
        for (int id = 1000; id <= 1500; ++id) {
            ps.setInt(1, id);
            ps.setString(2, "gfxd" + id);
            ps.setString(3, "gem" + id);
            ps.setString(4, "test" + id + "@pivotal.io");
            ps.addBatch();
            sumId += id;
        }
        ps.executeBatch();
        ResultSet rs = st.executeQuery("select sum(id) from e.employee where id >= 1000");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)sumId, (int)rs.getInt(1));
        rs.close();
        Connection conn2 = jdbcConn;
        Statement st2 = conn2.createStatement();
        rs = st2.executeQuery("select sum(id) from e.employee where lname like 'gem%'");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)sumId, (int)rs.getInt(1));
        rs.close();
        rs = st.executeQuery("select sum(id) from e.employee where lname like 'gem%'");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)sumId, (int)rs.getInt(1));
        rs.close();
        StatementCachingTest.stopNetServer();
    }

    public void _testTriggerInvocation() throws SQLException {
        Connection conn = StatementCachingTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table x (x int, constraint ck check (x > 0))");
        st.execute("create trigger tokv1 NO CASCADE before insert on x for each statement values 2");
        st.execute("insert into x values 1");
        st.execute("insert into x values (1) , (3), (4), (5) ");
    }

    public void testUserQueryRestore() {
        String query1 = "Insert into TESTTABLE values(<?>,<?>,<?>,<?>)";
        String expected1 = "Insert into TESTTABLE values(1,'desc1','Add1',1)";
        int[] tokentypes1 = new int[]{522, 525, 525, 522};
        String[] tokenstrings1 = new String[]{"1", "desc1", "Add1", "1"};
        ConstantValueSetImpl cvs1 = new ConstantValueSetImpl(tokentypes1, tokenstrings1);
        String userquery1 = GeneralizedStatement.recreateUserQuery((String)"Insert into TESTTABLE values(<?>,<?>,<?>,<?>)", (ConstantValueSet)cvs1);
        StatementCachingTest.assertEquals((String)"Insert into TESTTABLE values(1,'desc1','Add1',1)", (String)userquery1);
        String expected = "update trade.customers set cust_name ='name1' , addr ='address is name 1' where cid=83 and tid =5";
        String query = "update trade.customers set cust_name =<?> , addr =<?> where cid=<?> and tid =<?>";
        int[] tokentypes = new int[]{525, 525, 522, 522};
        String[] tokenstrings = new String[]{"name1", "address is name 1", "83", "5"};
        ConstantValueSetImpl cvs = new ConstantValueSetImpl(tokentypes, tokenstrings);
        String userquery = GeneralizedStatement.recreateUserQuery((String)"update trade.customers set cust_name =<?> , addr =<?> where cid=<?> and tid =<?>", (ConstantValueSet)cvs);
        StatementCachingTest.assertEquals((String)"update trade.customers set cust_name ='name1' , addr ='address is name 1' where cid=83 and tid =5", (String)userquery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicStatementReuse() throws SQLException {
        Connection conn = StatementCachingTest.getConnection();
        conn.createStatement().execute("create table flights (id int, val varchar(10))");
        Statement dmlSt = conn.createStatement();
        dmlSt.execute("delete from flights where id = 1");
        dmlSt.execute("insert into flights values (1, 'one')");
        dmlSt.executeQuery("select * from flights where id = 1");
        dmlSt.execute("update flights set id = 3, val = 'three' where 1=1 ");
        GemFireXDQueryObserver old = null;
        try {
            final boolean[] shouldParseQuery = new boolean[]{true};
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void afterQueryParsing(String query, StatementNode qt, LanguageConnectionContext lcc) {
                    if (!shouldParseQuery[0]) {
                        throw new AssertionError((Object)("parsing shouldn't have happened for " + query));
                    }
                }

                public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
                    throw new AssertionError((Object)("optimization phase should NOT have been called for " + query));
                }
            });
            String query = "";
            shouldParseQuery[0] = false;
            ResultSet rs = dmlSt.executeQuery("select * from flights where id = 1");
            while (rs.next()) {
                StatementCachingTest.getLogger().info((Object)("read data " + rs.getInt(1)));
            }
            shouldParseQuery[0] = false;
            rs = dmlSt.executeQuery("select * from flights where id = 3");
            while (rs.next()) {
                StatementCachingTest.getLogger().info((Object)("read data " + rs.getInt(1)));
            }
            shouldParseQuery[0] = true;
            query = "insert into flights values (2, 'two')";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'one row effected'"), (dmlSt.getUpdateCount() == 1 ? 1 : 0) != 0);
            shouldParseQuery[0] = false;
            query = "insert into flights values (1, 'one')";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'one row effected'"), (dmlSt.getUpdateCount() == 1 ? 1 : 0) != 0);
            shouldParseQuery[0] = true;
            query = "update flights set id = 4, val = 'four' where 1=1 ";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'three row effected' " + "but effected with " + dmlSt.getUpdateCount()), (dmlSt.getUpdateCount() == 3 ? 1 : 0) != 0);
            shouldParseQuery[0] = false;
            query = "update flights set id = 4, val = 'four' where 1=1 ";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'three row effected'"), (dmlSt.getUpdateCount() == 3 ? 1 : 0) != 0);
            shouldParseQuery[0] = false;
            query = "delete from flights where id = 1";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'zero row effected'"), (dmlSt.getUpdateCount() == 0 ? 1 : 0) != 0);
            shouldParseQuery[0] = true;
            query = "delete from flights where id = 4";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'zero row effected'"), (dmlSt.getUpdateCount() == 3 ? 1 : 0) != 0);
            shouldParseQuery[0] = false;
            query = "delete from flights where id = 4";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'zero row effected'"), (dmlSt.getUpdateCount() == 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            try {
                conn.createStatement().execute("drop table flights");
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            throw throwable;
        }
        try {
            conn.createStatement().execute("drop table flights");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (old != null) {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicStatementReuse_Replicate() throws SQLException {
        Connection conn = StatementCachingTest.getConnection();
        conn.createStatement().execute("create table flights (id int, val varchar(10)) replicate");
        Statement dmlSt = conn.createStatement();
        dmlSt.execute("delete from flights where id = 1");
        dmlSt.execute("insert into flights values (1, 'one')");
        dmlSt.executeQuery("select * from flights where id = 1");
        dmlSt.execute("update flights set id = 3, val = 'three' where 1=1 ");
        GemFireXDQueryObserver old = null;
        try {
            final boolean[] shouldParseQuery = new boolean[]{true};
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void afterQueryParsing(String query, StatementNode qt, LanguageConnectionContext lcc) {
                    if (!shouldParseQuery[0]) {
                        throw new AssertionError((Object)("parsing shouldn't have happened for " + query));
                    }
                }

                public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
                    throw new AssertionError((Object)("optimization phase should NOT have been called for " + query));
                }
            });
            String query = "";
            shouldParseQuery[0] = false;
            ResultSet rs = dmlSt.executeQuery("select * from flights where id = 3");
            while (rs.next()) {
                StatementCachingTest.getLogger().info((Object)("read data " + rs.getInt(1)));
            }
            shouldParseQuery[0] = true;
            query = "insert into flights values (2, 'two')";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'one row effected'"), (dmlSt.getUpdateCount() == 1 ? 1 : 0) != 0);
            shouldParseQuery[0] = false;
            query = "insert into flights values (1, 'one')";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'one row effected'"), (dmlSt.getUpdateCount() == 1 ? 1 : 0) != 0);
            shouldParseQuery[0] = true;
            query = "update flights set id = 4, val = 'four' where 1=1 ";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'three row effected' " + "but effected with " + dmlSt.getUpdateCount()), (dmlSt.getUpdateCount() == 3 ? 1 : 0) != 0);
            shouldParseQuery[0] = false;
            query = "update flights set id = 4, val = 'four' where 1=1 ";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'three row effected'"), (dmlSt.getUpdateCount() == 3 ? 1 : 0) != 0);
            shouldParseQuery[0] = false;
            query = "delete from flights where id = 1";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'zero row effected'"), (dmlSt.getUpdateCount() == 0 ? 1 : 0) != 0);
            shouldParseQuery[0] = true;
            query = "delete from flights where id = 4";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'zero row effected'"), (dmlSt.getUpdateCount() == 3 ? 1 : 0) != 0);
            shouldParseQuery[0] = false;
            query = "delete from flights where id = 4";
            dmlSt.execute(query);
            StatementCachingTest.assertTrue((String)(query + " should have resulted into 'zero row effected'"), (dmlSt.getUpdateCount() == 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            try {
                conn.createStatement().execute("drop table flights");
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            throw throwable;
        }
        try {
            conn.createStatement().execute("drop table flights");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (old != null) {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
    }

    public void testQuotedTables() throws SQLException {
        Connection conn = StatementCachingTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("create table \"my table\" (x int)");
        stmt.executeUpdate("insert into \"my table\" values (1), (2), (3) ");
        ResultSet rs = stmt.executeQuery("select * from \"my table\"");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from \"my table\" order by x");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)1, (int)rs.getInt(1));
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)2, (int)rs.getInt(1));
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)3, (int)rs.getInt(1));
        StatementCachingTest.assertFalse((boolean)rs.next());
    }

    public void testQuotedCursorsUpdate() throws SQLException {
        Connection conn = StatementCachingTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("create table \"my table\" (x int)");
        stmt.executeUpdate("insert into \"my table\" values (1), (2), (3) ");
        stmt.close();
        stmt = conn.createStatement(1003, 1008);
        stmt.setCursorName("\"\"my quoted cursor\"\" \"\"with quotes in middle\"\"and last \"\"");
        ResultSet rs = stmt.executeQuery("select * from \"my table\"");
        rs.next();
        int updatedInt = rs.getInt(1);
        rs.updateInt(1, 4);
        rs.updateRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my table\" order by x");
        ArrayList<Integer> expected = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
        expected.remove((Object)updatedInt);
        expected.add(4);
        for (int i = 2; i <= 4; ++i) {
            StatementCachingTest.assertTrue((String)"there is a row", (boolean)rs.next());
            StatementCachingTest.assertTrue((String)"row contains correct value", (boolean)expected.remove((Object)rs.getInt(1)));
        }
        StatementCachingTest.assertTrue((String)"table correct size", (boolean)expected.isEmpty());
        rs.close();
        stmt.close();
    }

    public void testStatementPreparedStatementMixing() throws SQLException {
        Connection conn = StatementCachingTest.getConnection();
        Statement st = conn.createStatement();
        conn.createStatement().execute(" create table course ( course_id int, course_name varchar(20),primary key(course_id)) replicate ");
        conn.createStatement().execute(" create table student ( st_id int, c_id int,primary key(st_id, c_id)) replicate ");
        st.execute("insert into student values(1, 1)");
        st.execute("insert into student values(1, 2)");
        st.execute("insert into student values(1, 3)");
        st.execute("insert into student values(2, 1)");
        st.execute("insert into student values(2, 4)");
        st.execute("insert into course values(1, 'ONE')");
        st.execute("insert into course values(2, 'TWO')");
        st.execute("insert into course values(3, 'THREE')");
        st.execute("insert into course values(4, 'FOUR')");
        st.execute("insert into course values(5, 'FIVE')");
        long[] res = new long[]{3L, 2L, 1L};
        ResultSet st_st = st.executeQuery("select c_id from student where st_id = 1 and c_id not in (select distinct course_id from course) order by c_id desc NULLS first ");
        PreparedStatement c_ps = conn.prepareStatement("select * from course where course_id = ? ");
        while (st_st.next()) {
            int i;
            c_ps.setInt(1, i);
            ResultSet rc = c_ps.executeQuery();
            int r = 0;
            for (i = st_st.getInt(1); i < res.length; ++i) {
                StatementCachingTest.assertEquals((long)res[r], (long)rc.getLong("course_id"));
                rc.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentInsertGenericStmtSeeking() throws SQLException, InterruptedException {
        this.shouldWait = true;
        Connection conn = StatementCachingTest.getConnection();
        conn.createStatement().execute("create table flights (id int primary key, val varchar(10))");
        Statement dmlSt = conn.createStatement();
        dmlSt.execute("insert into flights values (1, 'one')");
        dmlSt.execute("delete from flights where id = 1");
        try {
            Object sync = new Object();
            Thread[] parThds = new Thread[3];
            this.countNumThreads = new CountDownLatch(parThds.length);
            this.stmtCompileState = new AtomicIntegerArray(1);
            parThds[0] = this.getExecutionThread("insert into flights values (1, 'one')", false, false, null, 0);
            parThds[1] = this.getExecutionThread("insert into flights values (2, 'two')", sync);
            parThds[2] = this.getExecutionThread("insert into flights values (3, 'three')", sync);
            for (Thread t : parThds) {
                t.start();
            }
            this.countNumThreads.await();
            Object object = sync;
            synchronized (object) {
                this.shouldWait = false;
                sync.notifyAll();
            }
            for (Thread t : parThds) {
                t.join();
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            ResultSet resultSet = dmlSt.executeQuery("select count(*) from flights");
            StatementCachingTest.assertTrue((boolean)resultSet.next());
            StatementCachingTest.assertTrue((resultSet.getInt(1) == 3 ? 1 : 0) != 0);
            StatementCachingTest.assertFalse((boolean)resultSet.next());
        }
        finally {
            try {
                conn.createStatement().execute("drop table flights");
            }
            catch (Throwable throwable) {}
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentInsertStmtCompilation() throws SQLException, InterruptedException {
        this.shouldWait = true;
        Connection conn = StatementCachingTest.getConnection();
        conn.createStatement().execute("create table flights (id int, val varchar(20),  primary key (id, val) )");
        try {
            Object sync = new Object();
            Thread[] parThds = new Thread[20];
            this.countNumThreads = new CountDownLatch(parThds.length);
            this.stmtCompileState = new AtomicIntegerArray(1);
            parThds[0] = this.getExecutionThread("insert into flights values (1, 'one')", sync);
            parThds[1] = this.getExecutionThread("insert into flights values (2, 'two')", sync);
            parThds[2] = this.getExecutionThread("insert into flights values (3, 'three')", sync);
            parThds[3] = this.getExecutionThread("insert into flights values (4, 'four')", sync);
            parThds[4] = this.getExecutionThread("insert into flights values (5, 'five')", sync);
            parThds[5] = this.getExecutionThread("insert into flights values (6, 'six')", sync);
            parThds[6] = this.getExecutionThread("insert into flights values (7, 'seven')", sync);
            parThds[7] = this.getExecutionThread("insert into flights values (8, 'eight')", sync);
            parThds[8] = this.getExecutionThread("insert into flights values (9, 'nine')", sync);
            parThds[9] = this.getExecutionThread("insert into flights values (10, 'ten')", sync);
            parThds[10] = this.getExecutionThread("insert into flights values (11, 'eleven')", sync);
            parThds[11] = this.getExecutionThread("insert into flights values (12, 'twelve')", sync);
            parThds[12] = this.getExecutionThread("insert into flights values (13, 'thirteen')", sync);
            parThds[13] = this.getExecutionThread("insert into flights values (14, 'fourteen')", sync);
            parThds[14] = this.getExecutionThread("insert into flights values (15, 'fiveteen')", sync);
            parThds[15] = this.getExecutionThread("insert into flights values (16, 'sixteen')", sync);
            parThds[16] = this.getExecutionThread("insert into flights values (17, 'seventeen')", sync);
            parThds[17] = this.getExecutionThread("insert into flights values (18, 'eighteen')", sync);
            parThds[18] = this.getExecutionThread("insert into flights values (19, 'nineteen')", sync);
            parThds[19] = this.getExecutionThread("insert into flights values (20, 'twenty')", sync);
            for (Thread t : parThds) {
                t.start();
            }
            this.countNumThreads.await();
            Object object = sync;
            synchronized (object) {
                this.shouldWait = false;
                sync.notifyAll();
            }
            for (Thread t : parThds) {
                t.join();
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery("select count(*) from flights");
            StatementCachingTest.assertTrue((boolean)rs.next());
            StatementCachingTest.assertTrue((rs.getInt(1) == 20 ? 1 : 0) != 0);
            StatementCachingTest.assertFalse((boolean)rs.next());
        }
        finally {
            try {
                conn.createStatement().execute("drop table flights");
            }
            catch (Throwable throwable) {}
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertStmtCompilationSomeThrowingError() throws SQLException, InterruptedException {
        this.shouldWait = true;
        this.ignorePKViolation = true;
        Connection conn = StatementCachingTest.getConnection();
        conn.createStatement().execute("create table flights (id int, val varchar(20),  primary key (id, val) )");
        try {
            Thread[] parThds;
            Object sync;
            block14: {
                sync = new Object();
                parThds = new Thread[20];
                this.countNumThreads = new CountDownLatch(parThds.length);
                this.stmtCompileState = new AtomicIntegerArray(1);
                try {
                    conn.createStatement().executeQuery("insert into flights values (null, null)");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("23502")) break block14;
                    throw sQLException;
                }
            }
            parThds[0] = this.getExecutionThread("insert into flights values (1, 'one')", sync);
            parThds[1] = this.getExecutionThread("insert into flights values (2, 'two')", sync);
            parThds[2] = this.getExecutionThread("insert into flights values (3, 'three')", sync);
            parThds[3] = this.getExecutionThread("insert into flights values (4, 'four')", sync);
            parThds[4] = this.getExecutionThread("insert into flights values (5, 'five')", sync);
            parThds[5] = this.getExecutionThread("insert into flights values (6, 'six')", sync);
            parThds[6] = this.getExecutionThread("insert into flights values (7, 'seven')", sync);
            parThds[7] = this.getExecutionThread("insert into flights values (8, 'eight')", sync);
            parThds[8] = this.getExecutionThread("insert into flights values (9, 'nine')", sync);
            parThds[9] = this.getExecutionThread("insert into flights values (10, 'ten')", sync);
            parThds[10] = this.getExecutionThread("insert into flights values (1, 'one')", sync);
            parThds[11] = this.getExecutionThread("insert into flights values (2, 'two')", sync);
            parThds[12] = this.getExecutionThread("insert into flights values (3, 'three')", sync);
            parThds[13] = this.getExecutionThread("insert into flights values (4, 'four')", sync);
            parThds[14] = this.getExecutionThread("insert into flights values (5, 'five')", sync);
            parThds[15] = this.getExecutionThread("insert into flights values (6, 'six')", sync);
            parThds[16] = this.getExecutionThread("insert into flights values (7, 'seven')", sync);
            parThds[17] = this.getExecutionThread("insert into flights values (8, 'eight')", sync);
            parThds[18] = this.getExecutionThread("insert into flights values (9, 'nine')", sync);
            parThds[19] = this.getExecutionThread("insert into flights values (10, 'ten')", sync);
            for (Thread t : parThds) {
                t.start();
            }
            this.countNumThreads.await();
            Object object = sync;
            synchronized (object) {
                this.shouldWait = false;
                sync.notifyAll();
            }
            for (Thread t : parThds) {
                t.join();
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery("select count(*) from flights");
            StatementCachingTest.assertTrue((boolean)rs.next());
            StatementCachingTest.assertTrue((rs.getInt(1) == 10 ? 1 : 0) != 0);
            StatementCachingTest.assertFalse((boolean)rs.next());
        }
        finally {
            try {
                conn.createStatement().execute("drop table flights");
            }
            catch (Throwable throwable) {}
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.ignorePKViolation = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void testConcurrentSelectStmtCompilation() throws SQLException, InterruptedException {
        this.shouldWait = true;
        this.ignorePKViolation = false;
        Connection conn = StatementCachingTest.getConnection();
        conn.createStatement().execute("create table flights (id int, val varchar(20),  primary key (id, val) )");
        PreparedStatement ps = conn.prepareStatement("insert into flights values (?, ?)");
        int totalRows = 1000;
        for (int i = 1000; i > 0; --i) {
            ps.setInt(1, i);
            ps.setString(2, "DUMMY");
            ps.execute();
        }
        Statement dmlSt = conn.createStatement();
        ResultSet rs = dmlSt.executeQuery("select count(*) from flights");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertTrue((rs.getInt(1) == 1000 ? 1 : 0) != 0);
        StatementCachingTest.assertFalse((boolean)rs.next());
        try {
            void var10_15;
            int i;
            Object sync = new Object();
            Thread[] parThds = new Thread[40];
            this.countNumThreads = new CountDownLatch(parThds.length);
            this.stmtCompileState = new AtomicIntegerArray(1);
            String baseQueries = "select * from flights where id > ";
            for (i = 0; i < 10; ++i) {
                parThds[i] = this.getSelectExecutionThread("select * from flights where id > 990", sync);
            }
            for (i = 10; i < 20; ++i) {
                parThds[i] = this.getSelectExecutionThread("select * from flights where id > 998", sync);
            }
            for (i = 20; i < 30; ++i) {
                parThds[i] = this.getSelectExecutionThread("select * from flights where id > 10", sync);
            }
            Random rand = PartitionedRegion.rand;
            int n = 30;
            while (var10_15 < 40) {
                parThds[var10_15] = this.getSelectExecutionThread("select * from flights where id > " + rand.nextInt(1000), sync);
                ++var10_15;
            }
            for (Thread t : parThds) {
                t.start();
            }
            this.countNumThreads.await();
            Object object = sync;
            synchronized (object) {
                this.shouldWait = false;
                sync.notifyAll();
            }
            for (Thread t : parThds) {
                t.join();
            }
        }
        catch (Throwable t) {
            StatementCachingTest.getLogger().error((Object)"ERROR: ", t);
            throw new RuntimeException(t);
        }
        finally {
            try {
                conn.createStatement().execute("drop table flights");
            }
            catch (Throwable sync) {}
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.ignorePKViolation = false;
        }
    }

    public void testSchemaSwitching_Simple() throws SQLException {
        String tab22;
        String schemaName = "COMMON_SCHEMA";
        Connection conn = StatementCachingTest.getConnection();
        Statement stmts = conn.createStatement();
        stmts.execute("create schema COMMON_SCHEMA");
        String curSchema = SecurityTestUtils.currentSchema(conn.createStatement());
        stmts.execute("set schema COMMON_SCHEMA");
        SecurityTestUtils.assertCurrentSchema(stmts, "COMMON_SCHEMA");
        stmts.execute("create table test_table (c1 int, c2 int, primary key (c1) ) replicate");
        stmts.execute("create table test_table_pr (c1 int, c2 int, primary key(c1) )");
        conn.close();
        conn = StatementCachingTest.getConnection();
        stmts = conn.createStatement();
        curSchema = SecurityTestUtils.currentSchema(conn.createStatement());
        stmts.execute("set schema " + curSchema);
        SecurityTestUtils.assertCurrentSchema(conn.createStatement(), curSchema);
        ResultSet tabexist = stmts.executeQuery("select tablename from sys.systables where tablename = 'test_table'");
        if (tabexist.next() && (tab22 = tabexist.getString(1)) != null) {
            StatementCachingTest.assertEquals((String)"test_table", (String)tab22);
        }
        try {
            stmts.execute("drop table test_table");
        }
        catch (SQLException tab22) {
            // empty catch block
        }
        tabexist = stmts.executeQuery("select tablename from sys.systables where tablename = 'test_table_pr'");
        if (tabexist.next() && (tab22 = tabexist.getString(1)) != null) {
            StatementCachingTest.assertEquals((String)"test_table_pr", (String)tab22);
        }
        try {
            stmts.execute("drop table test_table_pr");
        }
        catch (SQLException tab) {
            // empty catch block
        }
        stmts.execute("create table test_table (c1 int, c2 varchar(1), primary key (c1) ) replicate");
        stmts.execute("create table test_table_pr (c1 int, c2 varchar(1), primary key(c1) )");
        stmts.execute("set schema COMMON_SCHEMA");
        SecurityTestUtils.assertCurrentSchema(stmts, "COMMON_SCHEMA");
        stmts.execute("insert into test_table values(1,1), (2,2)");
        stmts.execute("insert into test_table_pr values(1,1), (2,2)");
        ResultSet rs = stmts.executeQuery("select count(1) from test_table where c2 = 2");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)1, (int)rs.getInt(1));
        ResultSet rs1 = stmts.executeQuery("select count(1) from test_table where c2 = 2");
        StatementCachingTest.assertTrue((boolean)rs1.next());
        StatementCachingTest.assertEquals((int)1, (int)rs1.getInt(1));
        stmts.execute("set schema " + curSchema);
        SecurityTestUtils.assertCurrentSchema(stmts, curSchema);
        rs = stmts.executeQuery("select count(1) from test_table where c2 = '3'");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)0, (int)rs.getInt(1));
        rs1 = stmts.executeQuery("select count(1) from test_table where c2 = '3'");
        StatementCachingTest.assertTrue((boolean)rs1.next());
        StatementCachingTest.assertEquals((int)0, (int)rs1.getInt(1));
        stmts.execute("set schema COMMON_SCHEMA");
        SecurityTestUtils.assertCurrentSchema(stmts, "COMMON_SCHEMA");
        stmts.execute("update test_table set c2 = 3 ");
        stmts.execute("update test_table set c2 = 3 ");
        rs = stmts.executeQuery("select count(1) from test_table where c2 = 3");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertEquals((int)2, (int)rs.getInt(1));
        rs1 = stmts.executeQuery("select count(1) from test_table where c2 = 3");
        StatementCachingTest.assertTrue((boolean)rs1.next());
        StatementCachingTest.assertEquals((int)2, (int)rs1.getInt(1));
    }

    public void testGroupByHavingWithWhereClause() throws SQLException {
        Connection conn = StatementCachingTest.getConnection();
        conn.createStatement().execute("create table flights (id int, val varchar(20),  primary key (id, val) )");
        PreparedStatement ps = conn.prepareStatement("insert into flights values (?, ?)");
        int totalRows = 10;
        for (int i = 10; i > 0; --i) {
            ps.setInt(1, i);
            ps.setString(2, "DUMMY" + i % 2);
            ps.execute();
        }
        ResultSet rs = conn.createStatement().executeQuery("select val from flights where id > 1 group by val having count(val) > 0");
        while (rs.next()) {
            System.out.println(rs.getObject(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void testMultipleSelectStmtCompilation() throws SQLException, InterruptedException {
        this.shouldWait = true;
        this.ignorePKViolation = false;
        Connection conn = StatementCachingTest.getConnection();
        conn.createStatement().execute("create table flights (id int, val varchar(20),  primary key (id, val) )");
        PreparedStatement ps = conn.prepareStatement("insert into flights values (?, ?)");
        int totalRows = 1000;
        for (int i = 1000; i > 0; --i) {
            ps.setInt(1, i);
            ps.setString(2, "DUMMY" + i % 2);
            ps.execute();
        }
        Statement dmlSt = conn.createStatement();
        ResultSet rs = dmlSt.executeQuery("select count(*) from flights");
        StatementCachingTest.assertTrue((boolean)rs.next());
        StatementCachingTest.assertTrue((rs.getInt(1) == 1000 ? 1 : 0) != 0);
        StatementCachingTest.assertFalse((boolean)rs.next());
        try {
            void var10_15;
            int i;
            Object sync = new Object();
            Thread[] parThds = new Thread[40];
            this.countNumThreads = new CountDownLatch(parThds.length);
            String[] baseQueries = new String[]{"select * from flights where id > ", "select * from flights where id > ? order by 1", "select val from flights where id > ? group by val", "select * from flights where id > ? and (case when val like 'DUMMY2' then 1 else 2 end) > 0 "};
            this.stmtCompileState = new AtomicIntegerArray(baseQueries.length);
            for (i = 0; i < 10; ++i) {
                parThds[i] = this.getExecutionThread(baseQueries[0] + "990", true, true, sync, 0);
            }
            for (i = 10; i < 20; ++i) {
                parThds[i] = this.getExecutionThread(baseQueries[1].replace("?", "998"), true, true, sync, 1);
            }
            for (i = 20; i < 30; ++i) {
                parThds[i] = this.getExecutionThread(baseQueries[2].replace("?", Integer.toString(10)), true, true, sync, 2);
            }
            Random rand = PartitionedRegion.rand;
            int n = 30;
            while (var10_15 < 40) {
                parThds[var10_15] = this.getExecutionThread(baseQueries[3].replace("?", Integer.toString(rand.nextInt(1000))), true, true, sync, 3);
                ++var10_15;
            }
            for (Thread t : parThds) {
                t.start();
            }
            this.countNumThreads.await();
            Object object = sync;
            synchronized (object) {
                this.shouldWait = false;
                sync.notifyAll();
            }
            for (Thread t : parThds) {
                t.join();
            }
        }
        catch (Throwable t) {
            StatementCachingTest.getLogger().error((Object)"ERROR: ", t);
            throw new RuntimeException(t);
        }
        finally {
            try {
                conn.createStatement().execute("drop table flights");
            }
            catch (Throwable sync) {}
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.ignorePKViolation = false;
        }
    }

    private Thread getExecutionThread(String query, Object waitOn) {
        return this.getExecutionThread(query, false, true, waitOn, 0);
    }

    private Thread getSelectExecutionThread(String query, Object waitOn) {
        return this.getExecutionThread(query, true, true, waitOn, 0);
    }

    private Thread getExecutionThread(final String query, final boolean isSelect, final boolean shouldParsingOccur, final Object waitOn, final int queryNo) {
        return new Thread(new Runnable(){
            private final GemFireXDQueryObserver observer = new GemFireXDQueryObserverAdapter(){

                private final String prefix() {
                    return Thread.currentThread().toString() + "@" + Integer.toHexString(System.identityHashCode((Object)this)) + " ";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterQueryParsing(String query, StatementNode qt, LanguageConnectionContext lcc) {
                    if (tObserver.get() != this) {
                        return;
                    }
                    if (!shouldParsingOccur) {
                        TestCase.assertTrue((String)"Won't wait, so wait object must be null ", (waitOn == null ? 1 : 0) != 0);
                        throw new AssertionError((Object)(this.prefix() + System.identityHashCode(shouldParsingOccur) + " parsing shouldn't have happened for " + query));
                    }
                    while (StatementCachingTest.this.shouldWait) {
                        Object object = waitOn;
                        synchronized (object) {
                            if (!StatementCachingTest.this.shouldWait) {
                                break;
                            }
                            try {
                                waitOn.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                throw new RuntimeException("Got Interrupted for " + query + "... ", e);
                            }
                        }
                    }
                }

                public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
                    if (tObserver.get() != this) {
                        return;
                    }
                    TestCase.assertTrue((StatementCachingTest.this.stmtCompileState != null ? 1 : 0) != 0);
                    if (StatementCachingTest.this.stmtCompileState.getAndIncrement(queryNo) > 0) {
                        throw new AssertionError((Object)(this.prefix() + "for query " + queryNo + " " + query + " optimization phase should NOT have been called. "));
                    }
                    Misc.getGemFireCache().getLogger().info(this.prefix() + query + " SUCCESS compilation");
                }
            };

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StatementCachingTest.this.countNumThreads.countDown();
                Connection conn = null;
                try {
                    conn = TestUtil.getConnection();
                    GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.observer);
                    tObserver.set(this.observer);
                    if (!isSelect) {
                        conn.createStatement().execute(query);
                    } else {
                        ResultSet rs = conn.createStatement().executeQuery(query);
                        ResultSetMetaData rsM = rs.getMetaData();
                        int colCnt = rsM.getColumnCount();
                        while (rs.next()) {
                            StringBuilder row = new StringBuilder();
                            row.append("\n");
                            if (colCnt > 1) {
                                row.append(rs.getInt(1)).append(rs.getObject(2));
                                continue;
                            }
                            row.append(rs.getObject(1));
                        }
                        rs.close();
                        TestUtil.getLogger().info((Object)("Done for " + query));
                    }
                }
                catch (SQLException e) {
                    if (!StatementCachingTest.this.ignorePKViolation || !e.getSQLState().equals("23505")) {
                        TestUtil.fail("test failed because of SQLException=", e);
                    }
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            TestUtil.getLogger().error((Object)"close failed because of SQLException=", (Throwable)e);
                        }
                    }
                    GemFireXDQueryObserverHolder.removeObserver((QueryObserver)this.observer);
                }
            }
        });
    }
}

