/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.ParseException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.Token;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.tools.GfxdDistributionLocator;
import com.pivotal.gemfirexd.tools.internal.GfxdServerLauncher;
import com.pivotal.gemfirexd.tools.planexporter.CreateXML;
import com.pivotal.gemfirexd.tools.utils.ExecutionPlanUtils;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectsToGetTest
extends JdbcTestBase {
    private static String available_port;
    private final boolean withIndex = false;
    public static boolean LAUNCH_PEER_SERVER;
    public static int debugNumSecondaryServer;
    public static final String baseLaunchPath = "/soubhikc1/builds/gemfirexd110X_maint/logs/";
    public static int secServerCount;
    public static boolean launchIndividualLocator;
    public static boolean runNetServer;

    public SelectsToGetTest(String name) {
        super(name);
        available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
    }

    public static void main(String[] args) {
        available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        TestRunner.run((Test)new TestSuite(SelectsToGetTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testDJ() throws Exception {
        System.setProperty("gemfirexd.optimizer.trace", "true");
        System.setProperty("gemfirexd.debug.true", "TraceNCJ");
        System.getProperty("optimize-ncj", "true");
        Properties p = new Properties();
        p.setProperty("mcast-port", available_port);
        p.setProperty("SKIP_SPS_PRECOMPILE", "true");
        SelectsToGetTest.setupConnection(p);
        Connection conn = SelectsToGetTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table Customer (cust_id varchar(32), cust_type char(1), primary key(cust_id, cust_type)) partition by primary key");
        st.execute("create table Product (p_id varchar(32), p_type varchar(32), primary key(p_id, p_type) ) partition by column (p_type, p_id)");
        st.execute("create table OOrder (o_id varchar(32) primary key, cust_id varchar(32), cust_type char(1), p_id varchar(32), p_type varchar(32), o_dt date default CURRENT_DATE, foreign key (cust_id, cust_type) references customer(cust_id, cust_type), foreign key (p_id, p_type) references product(p_id, p_type)) partition by column (o_dt) ");
        st.execute("insert into customer values ('c-1', 'a'), ('c-2', 'a'), ('c-3', 'b'), ('c-4', 'b')");
        st.execute("insert into product values ('p-1', 'typ1'), ('p-2', 'typ2'),  ('p-3', 'typ1'), ('p-4', 'typ2'),  ('p-5', 'typ1'), ('p-6', 'typ2'),  ('p-7', 'typ1'), ('p-8', 'typ2'),  ('p-9', 'typ1'), ('p-10', 'typ2'),  ('p-11', 'typ1'), ('p-12', 'typ2'),  ('p-13', 'typ1'), ('p-14', 'typ2'),  ('p-15', 'typ1'), ('p-16', 'typ2'),  ('p-17', 'typ1'), ('p-18', 'typ2'),  ('p-19', 'typ1'), ('p-20', 'typ2') ");
        st.execute("insert into oorder (o_id, cust_id, cust_type, p_id, p_type) values ('o-1' , 'c-1', 'a', 'p-1', 'typ1'), ('o-2', 'c-1', 'a', 'p-2', 'typ2'), ('o-3' , 'c-1', 'a', 'p-1', 'typ1'), ('o-4', 'c-1', 'a', 'p-2', 'typ2'), ('o-5' , 'c-1', 'a', 'p-1', 'typ1'), ('o-6', 'c-1', 'a', 'p-2', 'typ2'), ('o-7' , 'c-1', 'a', 'p-1', 'typ1'), ('o-8', 'c-1', 'a', 'p-2', 'typ2'), ('o-9' , 'c-1', 'a', 'p-1', 'typ1'), ('o-10', 'c-1','a', 'p-2', 'typ2'), ('o-11' , 'c-1','a', 'p-1', 'typ1'), ('o-12', 'c-1','a', 'p-2', 'typ2'), ('o-13' , 'c-1','a', 'p-1', 'typ1'), ('o-14', 'c-1','a', 'p-2', 'typ2'), ('o-15' , 'c-1','a', 'p-1', 'typ1'), ('o-16', 'c-1','a', 'p-2', 'typ2'), ('o-17' , 'c-1','a', 'p-1', 'typ1'), ('o-18', 'c-1','a', 'p-2', 'typ2'), ('o-19' , 'c-1','a', 'p-1', 'typ1'), ('o-20', 'c-1','a', 'p-2', 'typ2') ");
        try {
            ResultSet r = st.executeQuery("select * from OOrder o , Product p , Customer c where o.p_id = p.p_id and o.p_type = p.p_type and o.cust_id = c.cust_id and o.cust_type = c.cust_type ");
            while (r.next()) {
                System.out.println(r.getString(1));
            }
        }
        finally {
            System.out.println(((EmbedConnection)conn).getLanguageConnection().getOptimizerTraceOutput());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionVTI() throws Exception {
        try {
            Properties p = new Properties();
            p.setProperty("table-default-partitioned", "false");
            SelectsToGetTest.setupConnection(p);
            Connection conn = SelectsToGetTest.getConnection();
            Statement st = conn.createStatement();
            st.execute("CREATE TABLE hydra_test (id integer NOT NULL,conf clob(5M),full_test_spec clob(5M),hydra_testsuite_id integer NOT NULL)");
            PreparedStatement ps = conn.prepareStatement("insert into hydra_test(id, hydra_testsuite_id) values (?, ?)");
            st.execute("CREATE TABLE hydra_testsuite (id integer NOT NULL,name varchar(256) NOT NULL)");
            ps = conn.prepareStatement("insert into hydra_testsuite(id, name) values (?, ?)");
            st.execute("CREATE TABLE hydra_testsuite_detail (id integer NOT NULL,date timestamp,elapsed_time varchar(256),disk_usage varchar(256),passcount integer,failcount integer,hangcount integer,local_conf clob(5M),hydra_testsuite_id integer NOT NULL,hydra_run_id integer,host_id integer,comment long varchar)");
            ps = conn.prepareStatement("insert into hydra_testsuite_detail(id, hydra_testsuite_id, elapsed_time) values (?, ?, ?)");
            ResultSet r = st.executeQuery("SELECT HYDRA_TESTSUITE_ID, NAME, cnt, mx FROM HYDRA_TESTSUITE, (SELECT HYDRA_TESTSUITE_ID, COUNT(*) as cnt FROM HYDRA_TEST GROUP BY HYDRA_TESTSUITE_ID) AS FOO, (SELECT HYDRA_TESTSUITE_ID AS HTID, MAX(ELAPSED_TIME) as mx FROM HYDRA_TESTSUITE_DETAIL GROUP BY HYDRA_TESTSUITE_ID) AS POO WHERE HYDRA_TESTSUITE_ID = ID AND ID = HTID ORDER BY cnt; ");
            while (r.next()) {
                System.out.println(r.getString(1) + " " + r.getInt(2) + " " + r.getInt(3));
            }
        }
        finally {
            TestUtil.shutDown();
            SelectsToGetTest.shutdownSecondaryServers();
        }
    }

    public void testDummy() throws Exception {
        Pattern p = Pattern.compile(":\\s*(?!\\s*rgb).*\\(.*\\)");
        System.out.println(p.matcher(": rgb (22)").replaceAll(":"));
        System.out.println(p.matcher(": xxrgb (22)").replaceAll(":"));
        System.out.println(p.matcher(": rgbxx (22)").replaceAll(":"));
        System.out.println(p.matcher(": rggb (22)").replaceAll(":"));
        System.out.println(p.matcher(": rrrgb (22)").replaceAll(":"));
        System.out.println(p.matcher(": rg (22)").replaceAll(":"));
        System.out.println(p.matcher(": expression (22)").replaceAll(":"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testXATest() throws Exception {
        try {
            LAUNCH_PEER_SERVER = true;
            debugNumSecondaryServer = 0;
            secServerCount = 2;
            launchIndividualLocator = true;
            runNetServer = true;
            SelectsToGetTest.launchSecondaryServers();
            Properties cp = new Properties();
            SelectsToGetTest.makeClient(cp);
            ClientXADataSource xaDataSource = new ClientXADataSource();
            xaDataSource.setServerName("localhost");
            xaDataSource.setPortNumber(33210);
            xaDataSource.setDatabaseName("GemFireXD");
            xaDataSource.setConnectionAttributes("logConnections=true;traceDirectory=/soubhik/builds/gfxd.1/logs/;");
            xaDataSource.setSecurityMechanism((short)3);
            byte[] gid = new byte[64];
            byte[] bid = new byte[64];
            for (int i = 0; i < 64; ++i) {
                gid[i] = (byte)i;
                bid[i] = (byte)(64 - i);
            }
        }
        finally {
            TestUtil.shutDown();
            SelectsToGetTest.shutdownSecondaryServers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryPlan() throws Exception {
        try {
            LAUNCH_PEER_SERVER = false;
            debugNumSecondaryServer = 2;
            secServerCount = 2;
            launchIndividualLocator = false;
            SelectsToGetTest.launchSecondaryServers();
            Properties cp = new Properties();
            SelectsToGetTest.makeClient(cp);
            Connection conn = TestUtil.getConnection(cp);
            DatabaseMetaData dbm = conn.getMetaData();
            System.out.println(dbm.getDriverName());
            Statement st = conn.createStatement();
            ResultSet rs = dbm.getTables(null, null, "course".toUpperCase(), new String[]{"TABLE"});
            boolean found = rs.next();
            rs.close();
            if (found) {
                st.execute("drop table course ");
            }
            rs = dbm.getTables(null, null, "games".toUpperCase(), new String[]{"TABLE"});
            found = rs.next();
            rs.close();
            if (found) {
                st.execute("drop table games ");
            }
            st.execute("CREATE TABLE GAMES ( PLAYER_ID CHAR(8) NOT NULL,YEAR_NO      BIGINT NOT NULL,TEAM      CHAR(3) NOT NULL,WEEK      BIGINT NOT NULL,OPPONENT  CHAR(3) ,COMPLETES BIGINT ,ATTEMPTS  BIGINT ,PASSING_YARDS BIGINT ,PASSING_TD    BIGINT ,INTERCEPTIONS BIGINT ,RUSHES BIGINT ,RUSH_YARDS BIGINT ,RECEPTIONS BIGINT ,RECEPTIONS_YARDS BIGINT ,TOTAL_TD BIGINT) ");
            ResultSet colM = conn.getMetaData().getColumns(null, null, "GAMES", "YEAR_NO");
            while (colM.next()) {
                String cname = colM.getString("COLUMN_NAME");
                int ctype = colM.getInt("DATA_TYPE");
                System.out.println(cname + " of type " + ctype);
            }
            st.execute("create table course (course_id int, i int, course_name varchar(10),  primary key(course_id)) partition by primary key ");
            st.execute("insert into course values (1, 1, 'd'), (2, 2, 'd'), (3, 1, 'd'), (4, 3, 'd'), (5, 1, 'd')");
            st.execute("insert into course values (11, 1, 'd'), (12, 2, 'd'), (13, 1, 'd'), (14, 3, 'd'), (15, 1, 'd')");
            st.execute("insert into course values (21, 1, 'd'), (22, 2, 'd'), (23, 1, 'd'), (24, 3, 'd'), (25, 1, 'd')");
            st.execute("insert into course values (31, 1, 'd'), (32, 3, 'd'), (33, 1, 'd'), (34, 3, 'd'), (35, 1, 'd')");
            st.execute("insert into course values (41, 1, 'd'), (42, 4, 'd'), (43, 1, 'd'), (44, 3, 'd'), (45, 1, 'd')");
            for (int i = 0; i < 1; ++i) {
                rs = st.executeQuery("explain select * from course where course_name = ? parameter values ('d') ");
                boolean row = false;
                while (rs.next()) {
                    System.out.println(rs.getString(1));
                }
                rs.close();
            }
            Connection eConn = TestUtil.getConnection(cp);
            ResultSet qp = eConn.createStatement().executeQuery("select stmt_id, stmt_text from sys.statementplans");
            boolean atleastOnePlan = false;
            while (qp.next()) {
                String uuid = qp.getString(1);
                System.out.println("Extracting plan for " + uuid);
                ExecutionPlanUtils plan = new ExecutionPlanUtils(eConn, uuid, null, true);
                System.out.println("plan : " + new String(plan.getPlanAsText(null)));
                atleastOnePlan = true;
            }
            SelectsToGetTest.assertTrue((boolean)atleastOnePlan);
        }
        finally {
            TestUtil.shutDown();
            SelectsToGetTest.shutdownSecondaryServers();
        }
    }

    public void __testGrant() throws Exception {
        System.setProperty("gemfirexd.sql-authorization", "true");
        Connection conn = SelectsToGetTest.getConnection();
        Statement st = conn.createStatement();
        conn.createStatement().execute(" create table student ( st_id int, c_id int,primary key(st_id, c_id)) replicate ");
        st.execute("grant select (st_id,c_id) on student to public");
    }

    public void __testPrimayKeyGets() throws Exception {
        Connection conn = SelectsToGetTest.getConnection();
        int totalRows = 20;
        SelectsToGetTest.prepareTableWithOneKey(totalRows, conn);
        SelectsToGetTest.prepareTableWithTwoKey(totalRows, conn);
        Object[][][] queries = new Object[][][]{{{conn.prepareStatement("select * from Account where id = ?")}, {new Integer(4)}}, {{conn.prepareStatement("select * from finOrder where id = ? and account = ?")}, {new Integer(4)}, {new Integer(12), new Integer(1), "Account "}}, {{conn.prepareStatement("select * from finOrder where account = ? and id = ?")}, {new Integer(12), new Integer(1), "Account "}, {new Integer(4)}}};
        int totqry = queries.length;
        for (int qryRow = 0; qryRow < totqry; ++qryRow) {
            for (int pkey = 1; pkey <= totalRows; ++pkey) {
                ResultSet rs = null;
                PreparedStatement ps = (PreparedStatement)queries[qryRow][0][0];
                block5: for (int prm_1 = 1; prm_1 < queries[qryRow].length; ++prm_1) {
                    int paramType = (Integer)queries[qryRow][prm_1][0];
                    switch (paramType) {
                        case 12: {
                            if ((Integer)queries[qryRow][prm_1][1] != 1) continue block5;
                            ps.setObject(prm_1, (Object)(String.valueOf(queries[qryRow][prm_1][2]) + String.valueOf(pkey)), 12);
                            continue block5;
                        }
                        default: {
                            ps.setObject(prm_1, (Object)new Integer(pkey), (Integer)queries[qryRow][prm_1][0]);
                        }
                    }
                }
                rs = ps.executeQuery();
                SelectsToGetTest.assertTrue((String)("Got no result for query " + ((EmbedPreparedStatement)ps).getSQLText()), (rs != null && rs.next() ? 1 : 0) != 0);
                SelectsToGetTest.assertEquals((String)rs.getObject("id").toString(), (String)String.valueOf(pkey));
                SelectsToGetTest.assertFalse((boolean)rs.next());
                rs.close();
            }
        }
    }

    public void __testForumIssue() throws Exception {
        Connection oracon = null;
        Statement st = oracon.createStatement();
        st.execute("drop table course ");
        st.execute("create table course (course_id int, course_name varchar(20),  primary key(course_id)) ");
        st.execute("insert into course values(1, 'ONE')");
        st.execute("insert into course values(2, 'TWO')");
        st.execute("insert into course values(3, 'THREE')");
        st.execute("insert into course values(4, 'FOUR')");
        st.execute("insert into course values(5, 'FIVE')");
        st.close();
        oracon.close();
        Connection conn = SelectsToGetTest.getConnection();
        st = conn.createStatement();
        conn.createStatement().execute(" create table student ( st_id int, c_id int,primary key(st_id, c_id)) replicate ");
        st.execute("insert into student values(1, 1)");
        st.execute("insert into student values(1, 2)");
        st.execute("insert into student values(1, 3)");
        st.execute("insert into student values(2, 1)");
        st.execute("insert into student values(2, 4)");
        ResultSet st_st = st.executeQuery("select c_id from student where st_id = 1 and c_id not in (select distinct course_id from course) ");
        PreparedStatement c_ps = conn.prepareStatement("select * from course where course_id = ? ");
        while (st_st.next()) {
            int i = st_st.getInt(1);
            c_ps.setInt(1, i);
            ResultSet r = c_ps.executeQuery();
            while (r.next()) {
                System.out.println(r.getLong("course_id"));
                System.out.println(r.getString("course_name"));
            }
        }
        st_st = st.executeQuery("select c_id from student where st_id = 2 and c_id not in (select distinct course_id from course) ");
        while (st_st.next()) {
            c_ps.setInt(1, st_st.getInt(1));
            ResultSet r = c_ps.executeQuery();
            while (r.next()) {
                System.out.println(r.getLong("course_id"));
                System.out.println(r.getString("course_name"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testSQLMatcher() throws ParseException, StandardException, SQLException {
        LanguageConnectionContext lcc;
        CompilerContext cc;
        block9: {
            EmbedConnection conn = (EmbedConnection)SelectsToGetTest.getConnection();
            StatementContext stmtctx = null;
            cc = null;
            lcc = null;
            try {
                String sql = "select * from tab where ID = 'ePp@cXB8187@aEwuVo587w~HLjD&3618uqY!$qE053^@^@^@^@^@ ^@^@^@^@' ";
                lcc = conn.getLanguageConnection();
                stmtctx = lcc.pushStatementContext(true, true, sql, null, false, 0L);
                cc = lcc.pushCompilerContext();
                Parser p = cc.getMatcher();
                p.matchStatement(sql, null);
                StringBuilder generalizedStmtStr = new StringBuilder(sql.length());
                ArrayList constList = cc.getConstantTokenLists();
                if (constList.size() == 0) {
                    SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)"NO Constants found ");
                }
                int srcPos = 0;
                for (Token v : constList) {
                    int beginC = v.beginOffset;
                    assert (beginC > srcPos);
                    int cLen = beginC - srcPos;
                    char[] c = new char[cLen];
                    sql.getChars(srcPos, beginC, c, 0);
                    srcPos = v.endOffset;
                    SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)(sql + " skipping constant: " + v));
                    generalizedStmtStr.append(c).append("<?>");
                }
                int cLen = sql.length();
                if (srcPos < cLen) {
                    char[] c = new char[cLen - srcPos];
                    sql.getChars(srcPos, cLen, c, 0);
                    generalizedStmtStr.append(c);
                }
                SanityManager.DEBUG_PRINT((String)"sb", (String)("Generic Stmt " + generalizedStmtStr.toString()));
                if (stmtctx == null) break block9;
            }
            catch (Throwable throwable) {
                if (stmtctx != null) {
                    lcc.popStatementContext(stmtctx, null);
                }
                if (cc != null) {
                    lcc.popCompilerContext(cc);
                }
                throw throwable;
            }
            lcc.popStatementContext(stmtctx, null);
        }
        if (cc != null) {
            lcc.popCompilerContext(cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupBy() throws Exception {
        try {
            LAUNCH_PEER_SERVER = false;
            debugNumSecondaryServer = 1;
            secServerCount = 1;
            launchIndividualLocator = false;
            SelectsToGetTest.launchSecondaryServers();
            Properties cp = new Properties();
            SelectsToGetTest.makeClient(cp);
            Connection conn = TestUtil.getConnection(cp);
            Statement st = conn.createStatement();
            st.execute("drop table if exists course ");
            st.execute("create table course (course_id int, i int, course_name varchar(10) , primary key(course_id)) partition by primary key");
            st.execute("create index c_name on course(course_name) ");
            st.execute("create view course_view as select course_name, i, course_id from course");
            st.execute("insert into course values (1, 11, 'one'), (2, 22, 'two'), (3,33, 'three')");
            ResultSet r = st.executeQuery("select count(course_name) from (select course_name, i, course_id from course) T group by course_name ");
            while (r.next()) {
                System.out.println(r.getObject(1));
            }
        }
        finally {
            TestUtil.shutDown();
            SelectsToGetTest.shutdownSecondaryServers();
        }
    }

    public void __testOverflow() throws SQLException {
        Connection conn = SelectsToGetTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 varchar(10), c2 int, c3 char(20), primary key (c1, c2) ) ");
        s.execute("insert into t1 (c1, c2, c3) values ('10', 10, 'YYYY')");
        s.execute("insert into t1 (c1, c2, c3) values ('20', 20, 'YYYY')");
        s.execute("insert into t1 (c1, c2, c3) values ('30', 30, 'YYYY')");
        s.execute("create index i1 on t1 (c2,c3)");
        s.execute("delete  from t1 where c1='10'");
        s.executeQuery("select * from t1 where c1 < '30' order by c1");
        s.execute("update t1 set c3 = 'xxx'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testDebugAnyQuery() throws SQLException {
        try {
            Properties info = new Properties();
            if (LAUNCH_PEER_SERVER) {
                info.setProperty("host-data", "false");
                info.setProperty("gemfire.mcast-port", "0");
            } else {
                info.setProperty("mcast-port", "0");
            }
            info.setProperty("log-level", "fine");
            if (!info.containsKey("host-data")) {
                info.setProperty("host-data", "true");
            }
            info.put("user", "Soubhik");
            info.put("password", "Soubhik");
            Connection conn = TestUtil.getConnection(info);
            Statement st = conn.createStatement();
            st.execute("CALL SYSCS_UTIL.SET_STATEMENT_STATISTICS(1)");
            st.execute("CALL SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
            try {
                st.execute("drop table flights");
            }
            catch (Exception exception) {
                // empty catch block
            }
            st.execute("CREATE TABLE FLIGHTS(FLIGHT_ID int NOT NULL, DUM_ID int not null, upd_id int,  primary key(flight_id) ) ");
            conn.commit();
            st.execute("insert into flights(flight_id, dum_id, upd_id) values(2,1,1) ,(4, 1, 3),(3, 4, 2)");
            st.execute("update flights set upd_id = 3 where flight_id = 4");
            ResultSet mem = st.executeQuery("select afght.flight_id as fla_id, afght.*, bfght.flight_id as flb_id from flights afght join flights bfght on afght.flight_id = bfght.flight_id ");
            while (mem.next()) {
                System.out.println(mem.getObject(1).toString());
            }
            conn.close();
            return;
        }
        catch (Exception ignore) {
            System.out.println("exception in SelectsToGetTest: " + ignore);
        }
        finally {
            TestUtil.shutDown();
        }
    }

    public void __testExecuteStatement_1PrimaryKey() throws SQLException, InstantiationException, IllegalAccessException {
        Connection conn = SelectsToGetTest.getConnection();
        int totalRows = 20;
        this.prepareTableWithOneKey(conn, 1, totalRows);
        Random rand = new Random(System.currentTimeMillis());
        PreparedStatement ps = conn.prepareStatement("select * from Account where id  = ?");
        for (int i = 1; i <= 10; ++i) {
            int pkey = rand.nextInt(totalRows) + 1;
            ps.setString(1, String.valueOf(pkey));
            ResultSet rs = ps.executeQuery();
            SelectsToGetTest.assertTrue((boolean)rs.next());
            SelectsToGetTest.assertTrue((Integer.valueOf((String)rs.getObject("id")) == pkey ? 1 : 0) != 0);
            System.out.println("lookup " + pkey + ": (" + rs.getObject("id") + "," + rs.getObject("name") + "," + rs.getObject("type") + ")");
            SelectsToGetTest.assertFalse((boolean)rs.next());
            rs.close();
        }
    }

    public void _testExecuteStatement_2PrimaryKey() throws SQLException {
        Connection conn = SelectsToGetTest.getConnection();
        int totalRows = 20;
        this.prepareTableWithTwoKey(conn, totalRows);
        Random rand = new Random(System.currentTimeMillis());
        PreparedStatement ps = conn.prepareStatement("select name, account, type, id  from finOrder where id = ? and account = ?");
        for (int i = 1; i <= 10; ++i) {
            int pkey = rand.nextInt(totalRows) + 1;
            ps.setInt(1, pkey);
            ps.setString(2, "Account " + String.valueOf(pkey));
            ResultSet rs = ps.executeQuery();
            rs.next();
            SelectsToGetTest.assertTrue(((Long)rs.getObject("id") == (long)pkey ? 1 : 0) != 0);
            SelectsToGetTest.assertEquals((String)rs.getString(2), (String)("Account " + String.valueOf(pkey)));
            SelectsToGetTest.assertTrue((!rs.next() ? 1 : 0) != 0);
        }
    }

    public void __testQueryPlanPattern() {
        String samplePlan = "Slowest Member Plan:member   pc27(24827)<v1>:40987/57389 begin_execution  2012-02-17 19:39:49.888 end_execution  2012-02-17 19:39:50.061QUERY-RECEIVE execute_time 172454281 member_node pc27(24739)<v3>:45000/47964 RESULT-SEND execute_time 178437 member_node pc27(24739)<v3>:45000/47964  RESULT-HOLDER returned_rows 2 no_opens 1 execute_time 2054449  SORT input_rows 2 returned_rows 2 no_opens 1 execute_time 8505857 sort_type IN sorter_output 2   NLJOIN returned_rows 2 no_opens 1 execute_time 155661TABLESCAN returned_rows 2 no_opens 1 execute_time 68144194 scan_qualifiers 42Z37.U :  scanned_object COURSE scan_type HEAPFILTER returned_rows 2 no_opens 2 execute_time 174608ROWIDSCAN returned_rows 2 no_opens 2 execute_time 210261CONSTRAINTSCAN returned_rows 2 no_opens 2 execute_time 33192353 scan_qualifiers 42Z37.U :  scanned_object SQL120217193949320 scan_type";
        StringBuilder patternString = new StringBuilder();
        String timeStampPattern = "[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9](\\.[0-9][0-9][0-9])?";
        String memberIdPattern = ".*\\<v[0-9]([0-9]*)?\\>:[0-9]([0-9]*)?/[0-9]([0-9]*)?";
        String executeNanos = "[0-9]([0-9]*)?";
        patternString.append("Slowest Member Plan:\\s*member\\s*").append(memberIdPattern).append("\\s*begin_execution\\s*").append(timeStampPattern).append("\\s*end_execution\\s*").append(timeStampPattern);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] planMemberDone = planMatcher.split(samplePlan);
        System.out.println(Arrays.toString(planMemberDone));
        assert (planMemberDone.length == 2);
        patternString = new StringBuilder();
        patternString.append("\\s*QUERY-RECEIVE\\s*execute_time\\s*[0-9]([0-9]*)?\\s*member_node\\s*").append(memberIdPattern).append("\\s*RESULT-SEND execute_time ").append(executeNanos).append(" member_node ").append(memberIdPattern);
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] queryRecRespSendDone = planMatcher.split((CharSequence)planMemberDone[1]);
        System.out.println(Arrays.toString(queryRecRespSendDone));
        assert (queryRecRespSendDone.length == 2);
        patternString = new StringBuilder();
        patternString.append("\\s*RESULT-HOLDER returned_rows 2 no_opens 1 execute_time ").append(executeNanos);
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] resultHolderDone = planMatcher.split((CharSequence)queryRecRespSendDone[1]);
        System.out.println(Arrays.toString(resultHolderDone));
        assert (resultHolderDone.length == 2);
        patternString = new StringBuilder();
        patternString.append("SORT input_rows 2 returned_rows 2 no_opens 1 execute_time ").append(executeNanos).append(" sort_type IN sorter_output 2");
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] sortDone = planMatcher.split((CharSequence)resultHolderDone[1]);
        System.out.println(Arrays.toString(sortDone));
        assert (sortDone.length == 2);
        patternString = new StringBuilder();
        patternString.append("NLJOIN returned_rows 2 no_opens 1 execute_time ").append(executeNanos);
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] nlJoinDone = planMatcher.split((CharSequence)sortDone[1]);
        System.out.println(Arrays.toString(nlJoinDone));
        assert (nlJoinDone.length == 2);
        patternString = new StringBuilder();
        patternString.append("TABLESCAN returned_rows 2 no_opens 1 execute_time ").append(executeNanos).append(" scan_qualifiers 42Z37.U :  scanned_object COURSE scan_type HEAP");
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] tableScanDone = planMatcher.split((CharSequence)nlJoinDone[1]);
        System.out.println(Arrays.toString(tableScanDone));
        assert (tableScanDone.length == 2);
        patternString = new StringBuilder();
        patternString.append("FILTER returned_rows 2 no_opens 2 execute_time ").append(executeNanos);
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] filterDone = planMatcher.split((CharSequence)tableScanDone[1]);
        System.out.println(Arrays.toString(filterDone));
        assert (filterDone.length == 2);
        patternString = new StringBuilder();
        patternString.append("ROWIDSCAN returned_rows 2 no_opens 2 execute_time ").append(executeNanos);
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] rowIDScanDone = planMatcher.split((CharSequence)filterDone[1]);
        System.out.println(Arrays.toString(rowIDScanDone));
        assert (rowIDScanDone.length == 2);
        patternString = new StringBuilder();
        patternString.append("CONSTRAINTSCAN returned_rows 2 no_opens 2 execute_time ").append(executeNanos).append(" scan_qualifiers 42Z37.U :  scanned_object SQL120217193949320 scan_type");
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] constraintScanDone = planMatcher.split((CharSequence)rowIDScanDone[1]);
        System.out.println(Arrays.toString(constraintScanDone));
        assert (constraintScanDone.length == 0);
    }

    public void __testXML() {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- GemFireXD Query Plan --><plan>            <member>pc27(21012)&lt;v0&gt;:11477/51156</member>        <member>pc27(21012)&lt;v0&gt;:11477/51156</member>        <statement> select * from course c join course d on c.course_id = d.course_id where c.course_id &gt; 1 or d.course_id &lt;= 1 order by c.i desc </statement>            <time>2012-02-17 17:45:16.623</time>             <begin_exe_time>2012-02-17 17:45:16.544</begin_exe_time>     <end_exe_time>2012-02-17 17:45:16.623</end_exe_time>              <details>                 <node name=\"QUERY-RECEIVE\" execute_time=\"76666204\" member_node=\"pc27(20977)&lt;v1&gt;:31945/42892\"  depth=\"0\">                     <node name=\"RESULT-SEND\" execute_time=\"183604\" member_node=\"pc27(20977)&lt;v1&gt;:31945/42892\"  depth=\"1\">                         <node name=\"RESULT-HOLDER\" returned_rows=\"5\" no_opens=\"1\" execute_time=\"2127292\"  depth=\"2\">                             <node name=\"SORT\" input_rows=\"5\" returned_rows=\"5\" no_opens=\"1\" sort_type=\"IN\" sorter_output=\"5\" execute_time=\"1054252\"  depth=\"3\">                                 <node name=\"NLJOIN\" returned_rows=\"5\" no_opens=\"1\" execute_time=\"170409\"  depth=\"4\">                                     <node name=\"TABLESCAN\" returned_rows=\"5\" no_opens=\"1\" scan_qualifiers=\"42Z37.U : \" scanned_object=\"COURSE\" scan_type=\"HEAP\" execute_time=\"6837633\"  depth=\"5\">                                     </node>                                     <node name=\"FILTER\" returned_rows=\"5\" no_opens=\"5\" execute_time=\"187241\"  depth=\"5\">                                     </node>                                 </node>                             </node>                         </node>                     </node>                 </node>             </details>     </plan> ";
        Element e = CreateXML.transformToXML((char[])s.toCharArray());
        NodeList nl = e.getChildNodes();
        Timestamp begin = null;
        Timestamp end = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n == null) continue;
            if (n.getNodeName().equalsIgnoreCase("begin_exe_time")) {
                begin = Timestamp.valueOf(n.getTextContent());
                continue;
            }
            if (!n.getNodeName().equalsIgnoreCase("end_exe_time")) continue;
            end = Timestamp.valueOf(n.getTextContent());
        }
        System.out.println(" time taken " + (end.getTime() - begin.getTime()) + " millis ");
    }

    private void prepareTableWithOneKey(Connection conn, int mode, int rows) throws SQLException, InstantiationException, IllegalAccessException {
        Statement s = conn.createStatement();
        switch (mode) {
            case 1: {
                s.execute("create table Account ( id varchar(10) primary key, name varchar(100), type int )");
                s.execute("create index acc_idx1 on Account(id)");
                conn.commit();
                PreparedStatement ps = conn.prepareStatement("insert into Account values(?,?,?)");
                int baseChar = 65;
                for (int numRow = rows; numRow > 0; --numRow) {
                    try {
                        String id = String.valueOf(numRow);
                        String name = String.valueOf(new char[]{(char)(baseChar + numRow % 5)}) + "First";
                        int type = rows - numRow + 1;
                        ps.setString(1, id);
                        ps.setString(2, name);
                        ps.setInt(3, type);
                        System.out.println("inserting (" + id + "," + name + "," + type + ")");
                        ps.executeUpdate();
                        continue;
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                    }
                }
                return;
            }
            case 2: {
                s.execute("create table Account ( id varchar(10) primary key, name varchar(100), type int ) partition by range(id)   ( values between 'A'  and 'B'    ,values between 'C'  and 'D'    ,values between 'E'  and 'F'    ,values between 'G'  and 'Z'    ,values between '1'  and '5'    ,values between '5'  and '15'    ,values between '15' and '20'   )");
                break;
            }
            case 3: {
                s.execute("create table Account ( id varchar(10) primary key, name varchar(100), type int ) partition by list(id) (   values ('00','01')   ,values ('02','03')   ,values ('04','05')   ,values ('06','07','08','09')   ,values ('10','11','12','13')   ,values ('14','15')   ,values ('16','17')    )");
                break;
            }
            case 4: {
                s.execute("create table Account ( id varchar(10) primary key, name varchar(100), type int ) partition by range(id)   ( values between 'AA'  and 'AC'    ,values between 'AC'  and 'AE'    ,values between 'AE'  and 'AF'    ,values between 'AF'  and 'AG'    ,values between 'AG'  and 'AZ'    ,values between 'AZ'  and 'BA'    ,values between 'BA'  and 'BG'    ,values between 'BGA'  and 'BGF'    ,values between 'BGF'  and 'BGX'    ,values between 'BGX'  and 'BZ'    ,values between 'BZ'  and 'Z'    ,values between 'Z'  and 'a'    ,values between 'a'  and 'z'    ,values between '1'  and '5'    ,values between '5'  and '15'    ,values between '15' and '20'   )");
                break;
            }
            case 5: {
                s.execute("create table Account (ID int not null,  NAME varchar(1024), ADDRESS varchar(1024), primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 8 )");
                break;
            }
            case 6: {
                s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, NAME varchar(1024) not null, primary key (ID, DESCRIPTION,NAME))PARTITION BY COLUMN ( DESCRIPTION,NAME )");
                break;
            }
            case 7: {
                s.execute("create table TESTTABLE (ID int primary key,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, NAME varchar(1024) not null, quantity int , price int)");
                conn.commit();
                PreparedStatement ps = conn.prepareStatement("insert into TestTable values(?,?,?,?,?,?)");
                int baseChar = 65;
                for (int numRow = rows; numRow > 0; --numRow) {
                    try {
                        ps.setInt(1, numRow);
                        ps.setString(2, String.valueOf(new char[]{(char)(baseChar + numRow % 5)}) + "First");
                        ps.setString(3, numRow % 7 == 0 ? "J 604" : (numRow % 5 == 0 ? "A 604" : "B 604"));
                        ps.setString(4, numRow % 5 == 0 ? "INDIA" : (numRow % 3 == 0 ? "US" : "ROWLD"));
                        try {
                            ps.setInt(5, Integer.MAX_VALUE);
                            ps.setInt(6, ((Random)Random.class.newInstance()).nextInt(700));
                        }
                        catch (InstantiationException e) {
                            throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                        }
                        ps.executeUpdate();
                        continue;
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                    }
                }
                return;
            }
            case 8: {
                int numRow;
                s.execute("create table Source (ID varchar(20) constraint src_pk_id primary key, DESCRIPTION varchar(1024) not null,  ADDRESS varchar(1024) not null  ) PARTITION BY COLUMN (ID)");
                s.execute("create table Depend1 (ID int constraint Depend_pkID primary key, DESCRIPTION varchar(1024) not null, ID1 varchar(20), ADDRESS varchar(1024) not null, amount real, quantity int, discount int, price double, constraint id1_fk foreign key (ID1) references source(id) ) PARTITION BY COLUMN (ID1) COLOCATE WITH (Source)");
                s.execute("create index depend1_idx on Depend1(ID1) ");
                s.execute("create index depend1_desc on Depend1(DESCRIPTION) ");
                s.execute("create index depend1_add on Depend1(ADDRESS) ");
                conn.commit();
                PreparedStatement ps = conn.prepareStatement("insert into Source values(?,?,?)");
                int baseChar = 65;
                for (numRow = rows; numRow >= 0; --numRow) {
                    try {
                        ps.setString(1, String.valueOf(numRow) + String.valueOf(numRow));
                        ps.setString(2, String.valueOf(new char[]{(char)(baseChar + numRow % 5)}) + "First");
                        ps.setString(3, "J 604");
                        ps.executeUpdate();
                        continue;
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                    }
                }
                ps = conn.prepareStatement("insert into Depend1 values(?,?,?,?,?,?,?,?)");
                baseChar = 65;
                for (numRow = rows; numRow >= 0; --numRow) {
                    try {
                        ps.setInt(1, numRow);
                        ps.setString(2, numRow % 2 == 0 ? "third" : (numRow % 5 <= 2 ? "First" : "second"));
                        ps.setString(3, String.valueOf(numRow % 5) + String.valueOf(numRow % 5));
                        ps.setString(4, numRow % 3 == 0 ? "J 604" : (numRow % 5 == 0 ? "J 605" : "J 600"));
                        ps.setFloat(5, (float)(numRow % 5) * 7.98f);
                        ps.setLong(6, Integer.MAX_VALUE);
                        ps.setInt(7, numRow * 10 - numRow);
                        ps.setDouble(8, ((Random)Random.class.newInstance()).nextDouble());
                        ps.executeUpdate();
                        continue;
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                    }
                }
                return;
            }
            case 9: {
                s.execute("create table Source (ID int primary key, DESCRIPTION varchar(1024) not null,  ADDRESS varchar(1024) ) REPLICATE ");
                conn.commit();
                s.execute("Insert into SOURCE (ID, DESCRIPTION) values  (1, 'ONE'),(2, 'TWO'),(3, 'THREE'),(4, 'FOUR'),(5, 'FIVE')");
                break;
            }
            case 10: {
                s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) , ADDRESS varchar(1024), COUNTRY varchar(1024),  QUANTITY bigint, PRICE double, DISCOUNT int, AMOUNT real, MULTIPLY double, INT_OVERFLOW int,  SRC int, SRC2 int, primary key (ID) ) PARTITION BY RANGE ( SRC )  ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 8 ) redundancy 3");
                s.execute("create table Source (ID int primary key, DESCRIPTION varchar(1024) ,  ADDRESS varchar(1024) not null, price real, yoy int) Partition By Range (ID)   ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 8 )  COLOCATE WITH (TESTTABLE)  redundancy 3");
                s.execute("Create Index SIdx1 on Source(ID)");
                conn.commit();
                s.execute("Insert into SOURCE values  (1, null, 'US', 10.938, 5),(2, 'First1', 'ROWLD',20.8, 5),(3, 'First1', 'US',30.7, 4),(4, 'First11', 'US',40.938, 6),(5, 'First12', 'INDIA',1.38, 3),(6, null, 'INDIA',1000.938, 34),(7, 'First12', 'INDIA',53.558, 7),(8, 'First13', 'INDIA',45210.938, 5),(9, 'First13', 'INDIA',1321.938, 2),(10, 'First1', 'US',13240.938, 4),(11, 'First1', 'ROWLD',10.938, 6),(12, 'First13', 'INDIA',30.7, 7),(13, 'First1', 'ROWLD',40.938, 5)");
                Double dblPrice = ((Random)Random.class.newInstance()).nextDouble();
                for (int i = 1; i <= 13; ++i) {
                    conn.createStatement().execute("insert into TESTTABLE values (" + i + (i % 2 == 0 ? ", null" : ", 'First" + i + "'") + "," + (i % 2 == 0 && i > 4 ? "null" : (i % 3 == 0 ? "'J 604'" : "'J 987'")) + (i % 5 == 0 ? ",'INDIA'" : (i % 3 == 0 ? ",'US'" : ",'ROWLD'")) + "," + i * 100 + "," + dblPrice + "," + (i * 10 - i) + "," + (float)i * 3.45f + "," + ((double)i + 0.98746) + "," + Integer.MAX_VALUE + "," + (i % 5 + 1) + "," + (i % 2 + 1) + ")");
                }
                return;
            }
        }
        conn.commit();
        PreparedStatement ps = conn.prepareStatement("insert into Source values(?,?,?)");
        int baseChar = 65;
        for (int numRow = rows; numRow > 0; --numRow) {
            try {
                ps.setInt(1, numRow);
                ps.setString(2, String.valueOf(new char[]{(char)(baseChar + numRow % 5)}) + "First");
                ps.setString(3, "J 604");
                ps.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void prepareTableWithTwoKey(Connection conn, int rows) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table finOrder ( id bigint, name varchar(100), type int, account varchar(100),  constraint order_pk primary key(account, id ) )");
        PreparedStatement ps = conn.prepareStatement("insert into finOrder values(?,?,?,?)");
        while (rows > 0) {
            ps.setLong(1, rows);
            ps.setString(2, "Dummy Order " + String.valueOf(rows));
            ps.setInt(3, rows % 4);
            ps.setString(4, "Account " + String.valueOf(rows));
            ps.executeUpdate();
            --rows;
        }
    }

    private static void prepareTableWithOneKey(int rows, Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        SelectsToGetTest.getLogger().info((Object)" creating tables ");
        s.execute("create table Account ( id varchar(10) primary key, name varchar(100), type int )");
        conn.commit();
        SelectsToGetTest.getLogger().info((Object)" populating values ");
        PreparedStatement ps = conn.prepareStatement("insert into Account values(?,?,?)");
        while (rows > 0) {
            ps.setString(1, String.valueOf(rows));
            ps.setString(2, "Dummy Account " + String.valueOf(rows));
            ps.setInt(3, rows % 2);
            ps.executeUpdate();
            --rows;
        }
    }

    private static void prepareTableWithTwoKey(int rows, Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table finOrder ( id bigint, name varchar(100), type int, account varchar(100),  constraint order_pk primary key(account, id ) )");
        conn.commit();
        SelectsToGetTest.getLogger().info((Object)" populating values ");
        PreparedStatement ps = conn.prepareStatement("insert into finOrder values(?,?,?,?)");
        while (rows > 0) {
            ps.setLong(1, rows);
            ps.setString(2, "Dummy Order " + String.valueOf(rows));
            ps.setInt(3, rows % 4);
            ps.setString(4, "Account " + String.valueOf(rows));
            ps.executeUpdate();
            --rows;
        }
    }

    public static void launchSecondaryServers() throws Exception {
        available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        boolean before = LAUNCH_PEER_SERVER;
        System.setProperty("gemfire.CacheServerLauncher.dontExitAfterLaunch", Boolean.toString(LAUNCH_PEER_SERVER));
        LAUNCH_PEER_SERVER = Boolean.getBoolean("gemfire.CacheServerLauncher.dontExitAfterLaunch");
        assert (LAUNCH_PEER_SERVER == before);
        String hostname = InetAddress.getLocalHost().getCanonicalHostName() + ".pune.gemstone.com";
        if (LAUNCH_PEER_SERVER) {
            boolean locatorConfigured = false;
            int debugPort = 1044;
            int clientPort = 33314;
            int currentServerCount = 0;
            if (launchIndividualLocator) {
                GfxdDistributionLocator.main((String[])new String[]{"start", "-peer-discovery-port=" + available_port, "-mcast-port=0", "-dir=/soubhikc1/builds/gemfirexd110X_maint/logs/loc", "-log-level=fine", "-host-data=false", runNetServer ? "-client-port=" + clientPort : "-run-netserver=false", runNetServer ? "-client-bind-address=" + hostname : "", "-gemfire.enable-time-statistics=true", "-statistic-sample-rate=100", "-statistic-sampling-enabled=true", "-statistic-archive-file=server-loc.gfs", "-J-Dp2p.discoveryTimeout=1000", "-J-Dp2p.joinTimeout=2000", "-J-Dp2p.leaveTimeout=1000", "-J-Dp2p.socket_timeout=4000", "-J-Dp2p.disconnectDelay=500", "-J-Dp2p.handshakeTimeoutMs=2000", "-J-Dp2p.lingerTime=500", "-J-Dp2p.listenerCloseTimeout=4000", "-J-Dgemfirexd.user.Soubhik=Soubhik", "-security-log-level=finest", debugNumSecondaryServer > 0 ? "-J-Xdebug" : null, debugNumSecondaryServer > 0 ? "-J-Xrunjdwp:transport=dt_socket,suspend=y,server=y,address=localhost:" + debugPort : null, debugNumSecondaryServer > 0 ? "-J-Xms1g" : null, debugNumSecondaryServer > 0 ? "-J-Xmx1g" : null});
                locatorConfigured = true;
                ++currentServerCount;
                ++clientPort;
            }
            while (currentServerCount <= secServerCount) {
                GfxdServerLauncher.main((String[])new String[]{"start", !locatorConfigured ? "-start-locator=localhost[" + available_port + "]" : null, "-locators=localhost[" + available_port + "]", "-mcast-port=0", "-dir=/soubhikc1/builds/gemfirexd110X_maint/logs/" + currentServerCount, "-log-level=fine", "-host-data=true", runNetServer ? "-client-port=" + clientPort : "-run-netserver=false", runNetServer ? "-client-bind-address=" + hostname : "", "-gemfire.enable-time-statistics=true", "-statistic-sample-rate=100", "-statistic-sampling-enabled=true", "-statistic-archive-file=server-" + currentServerCount + ".gfs", "-J-Dgemfirexd.user.Soubhik=" + AuthenticationServiceBase.encryptPassword((String)"Soubhik", (String)"Soubhik"), "-security-log-level=finest", "-user=Soubhik", "-password=Soubhik", debugNumSecondaryServer > 0 ? "-J-Xdebug" : null, debugNumSecondaryServer > 0 ? "-J-Xrunjdwp:transport=dt_socket,suspend=y,server=y,address=localhost:" + debugPort : null, debugNumSecondaryServer > 0 ? "-J-Xms1g" : null, debugNumSecondaryServer > 0 ? "-J-Xmx1g" : null, "-J-javaagent:/soubhikc1/builds/gemfirexd110X_maint/logs/../build-artifacts/linux/hidden/lib/gemfirexd_unsealed.jar"});
                locatorConfigured = true;
                --debugNumSecondaryServer;
                ++debugPort;
                ++clientPort;
                ++currentServerCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownSecondaryServers() {
        if (LAUNCH_PEER_SERVER) {
            int serverCount = launchIndividualLocator ? 1 : 0;
            for (int currentServerCount = secServerCount + serverCount; currentServerCount > serverCount; --currentServerCount) {
                GfxdServerLauncher.main((String[])new String[]{"stop", "-dir=/soubhikc1/builds/gemfirexd110X_maint/logs/" + (currentServerCount - serverCount)});
            }
            if (launchIndividualLocator) {
                GfxdDistributionLocator.main((String[])new String[]{"stop", "-dir=/soubhikc1/builds/gemfirexd110X_maint/logs/loc"});
            }
        }
    }

    public static void makeClient(Properties p) {
        if (LAUNCH_PEER_SERVER) {
            p.setProperty("host-data", "false");
            p.setProperty("gemfire.mcast-port", "0");
            p.setProperty("locators", "localhost[" + available_port + "]");
        } else {
            p.setProperty("host-data", "true");
            p.setProperty("mcast-port", "0");
        }
        p.setProperty("log-level", "fine");
        p.setProperty("gemfire.enable-time-statistics", "false");
        p.setProperty("statistic-sample-rate", "1000");
        p.setProperty("statistic-sampling-enabled", "false");
        p.setProperty("enable-stats", "false");
        p.setProperty("enable-timestats", "false");
        p.setProperty("statistic-archive-file", "client-1.gfs");
        p.put(PartitionedRegion.rand.nextBoolean() ? "user" : "UserName", "Soubhik");
        p.put("password", "Soubhik");
    }

    static {
        debugNumSecondaryServer = 0;
        secServerCount = 1;
        launchIndividualLocator = false;
        runNetServer = true;
    }
}

