/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class QueryChecksTest
extends JdbcTestBase {
    public QueryChecksTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(QueryChecksTest.class));
    }

    public void testSimpleAvg() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        String derbyConn = "jdbc:derby:newDerbySecDB;";
        String sysConnUrl = "jdbc:derby:newDerbySecDB;create=true;user=" + bootUserName + ";password=" + bootUserPassword;
        Connection derby = DriverManager.getConnection(sysConnUrl);
        derby.setAutoCommit(true);
        if (GemFireXDUtils.hasTable((Connection)derby, (String)"test_t")) {
            derby.createStatement().execute("drop table test_t");
        }
        derby.createStatement().execute("create table test_t ( pk_col int primary key, col_ints int ) ");
        derby.createStatement().execute("insert into test_t values ( 1, 2302), ( 2, 4690), ( 3, 4901)");
        ResultSet dr = derby.createStatement().executeQuery("select avg(cast(col_ints as real)) from test_t ");
        QueryChecksTest.assertTrue((boolean)dr.next());
        QueryChecksTest.assertEquals((Object)Float.valueOf(3964.3333f), (Object)dr.getObject(1));
        derby.commit();
        Connection c = TestUtil.getConnection();
        c.createStatement().execute("create table test_t ( pk_col int primary key, col_ints int ) ");
        c.createStatement().execute("insert into test_t values ( 1, 2302), ( 2, 4690), ( 3, 4901)");
        ResultSet r = c.createStatement().executeQuery("select avg(cast(col_ints as real)) from test_t ");
        QueryChecksTest.assertTrue((boolean)r.next());
        QueryChecksTest.assertEquals((Object)Float.valueOf(3964.3333f), (Object)Float.valueOf(r.getFloat(1)));
    }

    public void testOverflowAvg() throws Exception {
        ResultSet r;
        Connection c;
        float derbyVal;
        block3: {
            derbyVal = 0.0f;
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            String derbyConn = "jdbc:derby:newDerbySecDB;";
            String sysConnUrl = "jdbc:derby:newDerbySecDB;create=true;user=" + bootUserName + ";password=" + bootUserPassword;
            Connection derby = DriverManager.getConnection(sysConnUrl);
            derby.setAutoCommit(true);
            if (GemFireXDUtils.hasTable((Connection)derby, (String)"test_t")) {
                derby.createStatement().execute("drop table test_t");
            }
            derby.createStatement().execute("create table test_t ( pk_col int primary key, col_ints int ) ");
            derby.createStatement().execute("insert into test_t values ( 1, 2147483647), ( 2, 2147483646), (3, 2147483645)");
            ResultSet r2 = derby.createStatement().executeQuery("select avg(cast(col_ints as float)) from test_t ");
            QueryChecksTest.assertTrue((boolean)r2.next());
            derbyVal = r2.getFloat(1);
            QueryChecksTest.assertFalse((boolean)r2.next());
            derby.commit();
            c = TestUtil.getConnection();
            c.createStatement().execute("create table test_t ( pk_col int primary key, col_ints int ) ");
            c.createStatement().execute("insert into test_t values ( 1, 2147483647), ( 2, 2147483646), (3, 2147483645)");
            r = c.createStatement().executeQuery("select avg(col_ints) from test_t ");
            QueryChecksTest.assertTrue((boolean)r.next());
            QueryChecksTest.assertEquals((Object)0x7FFFFFFEL, (Object)r.getObject(1));
            QueryChecksTest.assertFalse((boolean)r.next());
            r = c.createStatement().executeQuery("select sum(col_ints) from test_t ");
            try {
                QueryChecksTest.assertTrue((boolean)r.next());
                QueryChecksTest.fail("expected overflow exception");
            }
            catch (SQLException sqle) {
                if ("22003".equals(sqle.getSQLState())) break block3;
                throw sqle;
            }
        }
        r = c.createStatement().executeQuery("select avg(cast(col_ints as float)) from test_t ");
        QueryChecksTest.assertTrue((boolean)r.next());
        QueryChecksTest.assertEquals((Object)Float.valueOf(derbyVal), (Object)Float.valueOf(r.getFloat(1)));
        QueryChecksTest.assertFalse((boolean)r.next());
    }

    public void testTypePromotionOfSum() throws Exception {
        ResultSet r;
        Connection c;
        float derbySum;
        block3: {
            derbySum = 0.0f;
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            String derbyConn = "jdbc:derby:newDerbySecDB;";
            String sysConnUrl = "jdbc:derby:newDerbySecDB;create=true;user=" + bootUserName + ";password=" + bootUserPassword;
            Connection derby = DriverManager.getConnection(sysConnUrl);
            derby.setAutoCommit(true);
            if (GemFireXDUtils.hasTable((Connection)derby, (String)"test_t")) {
                derby.createStatement().execute("drop table test_t");
            }
            derby.createStatement().execute("create table test_t ( pk_col int primary key, col_ints int ) ");
            derby.createStatement().execute("insert into test_t values ( 1, 2147483647), ( 2, 2147483647)");
            ResultSet r2 = derby.createStatement().executeQuery("select sum(cast(col_ints as real)) from test_t ");
            QueryChecksTest.assertTrue((boolean)r2.next());
            derbySum = r2.getFloat(1);
            QueryChecksTest.assertFalse((boolean)r2.next());
            derby.commit();
            c = TestUtil.getConnection();
            c.createStatement().execute("create table test_t ( pk_col int primary key, col_ints int ) ");
            c.createStatement().execute("insert into test_t values ( 1, 2147483647), ( 2, 2147483647)");
            r = c.createStatement().executeQuery("select sum(col_ints) from test_t ");
            try {
                QueryChecksTest.assertTrue((boolean)r.next());
                QueryChecksTest.fail("expected overflow exception");
            }
            catch (SQLException sqle) {
                if ("22003".equals(sqle.getSQLState())) break block3;
                throw sqle;
            }
        }
        r = c.createStatement().executeQuery("select sum(cast(col_ints as real)) from test_t ");
        QueryChecksTest.assertTrue((boolean)r.next());
        QueryChecksTest.assertEquals((Object)Float.valueOf(derbySum), (Object)Float.valueOf(r.getFloat(1)));
        QueryChecksTest.assertFalse((boolean)r.next());
    }

    public void testBug42889() throws Exception {
        QueryChecksTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("create table t1 (i int, x xml)");
        stmt.executeUpdate("create table t2 (x2 xml not null)");
        stmt.executeUpdate("alter table t2 add column x1 xml");
        QueryChecksTest.assertUpdateCount(stmt, 1, "insert into t1 values (1, null)");
        QueryChecksTest.assertUpdateCount(stmt, 1, "insert into t1 values (2, cast (null as xml))");
        QueryChecksTest.assertUpdateCount(stmt, 1, "insert into t1 (i) values (4)");
        QueryChecksTest.assertUpdateCount(stmt, 1, "insert into t1 values (3, default)");
        QueryChecksTest.assertUpdateCount(stmt, 1, "insert into t1 values (5, xmlparse(document '<hmm/>' preserve whitespace))");
        QueryChecksTest.assertUpdateCount(stmt, 1, " insert into t1 values (6, xmlparse(document '<half> <masted> bass </masted> boosted. </half>' preserve whitespace))");
        QueryChecksTest.assertUpdateCount(stmt, 1, " insert into t2 (x1, x2) values (null, xmlparse(document '<notnull/>' preserve whitespace))");
        QueryChecksTest.assertUpdateCount(stmt, 1, " insert into t1 values (7, xmlparse(document '<?xml version=\"1.0\" encoding= \"UTF-8\"?><umm> decl check </umm>' preserve whitespace))");
        QueryChecksTest.assertUpdateCount(stmt, 1, "insert into t1 values (8, xmlparse(document '<lets> <try> this out </try> </lets>' preserve whitespace))");
        QueryChecksTest.assertUpdateCount(stmt, 1, " update t1 set x = xmlparse(document '<update> document was inserted as part of an UPDATE </update>' preserve whitespace) where i = 1");
        QueryChecksTest.assertUpdateCount(stmt, 1, " update t1 set x = xmlparse(document '<update2> document was inserted as part of an UPDATE </update2>' preserve whitespace) where xmlexists('/update' passing by ref x)");
        ResultSet rs = stmt.executeQuery("select xmlserialize(x as char(100)) from t1");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = stmt.executeQuery("select xmlexists('//lets' passing by ref x) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true, !conn.getClass().getName().contains("EmbedConnection"));
        stmt.executeUpdate("create table xqUpdate (i int, x xml default null)");
        QueryChecksTest.assertUpdateCount(stmt, 2, "insert into xqUpdate (i) values 29, 30");
        QueryChecksTest.assertUpdateCount(stmt, 1, "insert into xqUpdate values (  9,  xmlparse(document '<here><is><my height=\"4.4\">attribute</my></is></here>' preserve whitespace))");
        QueryChecksTest.assertUpdateCount(stmt, 1, "update xqUpdate  set x =     xmlquery('.' passing by ref      xmlparse(document '<none><here/></none>' preserve whitespace)    returning sequence empty on empty)where i = 29");
        QueryChecksTest.assertUpdateCount(stmt, 1, " update xqUpdate  set x =     xmlquery('self::node()[//@height]' passing by ref      (select        xmlquery('.' passing by ref x empty on empty)        from xqUpdate        where i = 9      )    empty on empty)where i = 30");
        stmt.close();
        conn.close();
    }

    public void testCaseInsensitiveSearch() throws Exception {
        QueryChecksTest.checkCaseInsensitiveSearch(QueryChecksTest.getConnection(), true, true);
    }

    public static void checkCaseInsensitiveSearch(Connection conn, boolean checkScanTypes, boolean dropTable) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE T.TABLE_DATA (   ID VARCHAR (36) NOT NULL,   F1 VARCHAR (100),   F2 VARCHAR (100),   F3 VARCHAR (100),   F4 VARCHAR (100),   F5 VARCHAR (100),   F6 TIMESTAMP,   F7 DECIMAL (16,2),   F8 VARCHAR (20),   F9 VARCHAR (100),   F10 VARCHAR (100),   F11 VARCHAR (100),   F12 VARCHAR (100) WITH DEFAULT 'UNKNOWN',   F13 VARCHAR (100),   F14 VARCHAR (100),   F15 VARCHAR (100),   F16 VARCHAR (100),   F17 VARCHAR (100),   F18 VARCHAR (256),   F19 VARCHAR (100),   F20 TIMESTAMP,   F21 TIMESTAMP,   F22 CLOB NOT NULL,   F23 SMALLINT NOT NULL,   F24 SMALLINT WITH DEFAULT 1,   F25 TIMESTAMP,   F26 INTEGER,   F27 CHAR (1) WITH DEFAULT 'N',   F28 CHAR (1) WITH DEFAULT 'N',   F29 VARCHAR (36) NOT NULL,   F30 INTEGER NOT NULL,   F31 VARCHAR (100) WITH DEFAULT 'UNKNOWN',   F32 VARCHAR (30) WITH DEFAULT 'UNKNOWN',   F34 SMALLINT,   F35 TIMESTAMP,   F36 TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,   CONSTRAINT DATA_PK PRIMARY KEY(ID))PARTITION BY PRIMARY KEY REDUNDANCY 1 EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW PERSISTENT ASYNCHRONOUS");
        stmt.execute("create index t.if3 on T.TABLE_DATA(F3) --gemfirexd-properties caseSensitive=false");
        stmt.execute("create index T.if4 on T.TABLE_DATA(F4)");
        stmt.execute("create index t.if5 on T.TABLE_DATA(F5)");
        stmt.execute("create index t.if6 on T.TABLE_DATA(F6)");
        stmt.execute("create index t.if7 on T.TABLE_DATA(F7)");
        stmt.execute("create index t.if8 on T.TABLE_DATA(F8)");
        stmt.execute("create index t.if3_4_5 on T.TABLE_DATA(F3, F4, F5) --gemfirexd-properties caseSensitive=false");
        StringBuilder sb = new StringBuilder().append("insert into T.TABLE_DATA values (");
        for (int i = 1; i <= 35; ++i) {
            sb.append("?,");
        }
        sb.append("?)");
        PreparedStatement ps = conn.prepareStatement(sb.toString());
        for (int row = 1; row <= 100; ++row) {
            int r = row >>> 1;
            block8: for (int i = 1; i <= 36; ++i) {
                switch (i) {
                    case 7: 
                    case 21: 
                    case 22: 
                    case 26: 
                    case 35: 
                    case 36: {
                        ps.setTimestamp(i, new Timestamp(System.currentTimeMillis()));
                        continue block8;
                    }
                    case 4: 
                    case 5: {
                        ps.setString(i, "TestValue" + r * i);
                        continue block8;
                    }
                    case 6: {
                        ps.setString(i, "TestValue" + row * i);
                        continue block8;
                    }
                    case 28: 
                    case 29: {
                        ps.setString(i, "Y");
                        continue block8;
                    }
                    default: {
                        ps.setString(i, String.valueOf(row * i));
                    }
                }
            }
            QueryChecksTest.assertEquals((int)1, (int)ps.executeUpdate());
        }
        QueryChecksTest.caseInsensitiveQueries(conn, checkScanTypes);
        if (dropTable) {
            stmt.execute("drop table T.TABLE_DATA");
        }
        conn.close();
    }

    public static void caseInsensitiveQueries(Connection conn, boolean checkScanTypes) throws SQLException {
        TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
        PreparedStatement ps = conn.prepareStatement("SELECT ID FROM T.TABLE_DATA --gemfirexd-properties index=IF3_4_5 \nwhere F3=? AND F4=? AND F5=?");
        ps.setString(1, "testvalue100");
        ps.setString(2, "TestValue125");
        ps.setString(3, "TestValue300");
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        ResultSet rs = ps.executeQuery();
        QueryChecksTest.assertTrue((boolean)rs.next());
        QueryChecksTest.assertEquals((String)"50", (String)rs.getString(1));
        QueryChecksTest.assertFalse((boolean)rs.next());
        rs.close();
        if (checkScanTypes) {
            observer.addExpectedScanType("t.table_data", "t.if3_4_5", TestUtil.ScanType.SORTEDMAPINDEX);
            observer.checkAndClear();
        }
        ps = conn.prepareStatement("SELECT ID FROM T.TABLE_DATA --gemfirexd-properties index=IF3_4_5 \nwhere F3=? AND F4=?");
        ps.setString(1, "testvalue100");
        ps.setString(2, "TestValue125");
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        rs = ps.executeQuery();
        QueryChecksTest.assertTrue((boolean)rs.next());
        boolean first = false;
        if (rs.getInt(1) == 50) {
            first = true;
            QueryChecksTest.assertEquals((String)"50", (String)rs.getString(1));
        } else {
            QueryChecksTest.assertEquals((String)"51", (String)rs.getString(1));
        }
        QueryChecksTest.assertTrue((boolean)rs.next());
        if (first) {
            QueryChecksTest.assertEquals((String)"51", (String)rs.getString(1));
        } else {
            QueryChecksTest.assertEquals((String)"50", (String)rs.getString(1));
        }
        QueryChecksTest.assertFalse((boolean)rs.next());
        rs.close();
        if (checkScanTypes) {
            observer.addExpectedScanType("t.table_data", "t.if3_4_5", TestUtil.ScanType.SORTEDMAPINDEX);
            observer.checkAndClear();
        }
        ps = conn.prepareStatement("SELECT ID FROM T.TABLE_DATA where F3=? AND UPPER(F4)=? AND UPPER(F5)=?");
        ps.setString(1, "TESTVALUE112");
        ps.setString(2, "TESTVALUE140");
        ps.setString(3, "TESTVALUE336");
        rs = ps.executeQuery();
        QueryChecksTest.assertTrue((boolean)rs.next());
        QueryChecksTest.assertEquals((int)56, (int)rs.getInt(1));
        QueryChecksTest.assertFalse((boolean)rs.next());
        rs.close();
        if (checkScanTypes) {
            observer.addExpectedScanType("t.table_data", "t.if3", TestUtil.ScanType.SORTEDMAPINDEX);
            observer.checkAndClear();
        }
        ps = conn.prepareStatement("SELECT ID FROM T.TABLE_DATA where F3=? AND UPPER(F4)=?");
        ps.setString(1, "TESTVALUE112");
        ps.setString(2, "TESTVALUE140");
        rs = ps.executeQuery();
        QueryChecksTest.assertTrue((boolean)rs.next());
        first = false;
        if (rs.getInt(1) == 56) {
            first = true;
            QueryChecksTest.assertEquals((String)"56", (String)rs.getString(1));
        } else {
            QueryChecksTest.assertEquals((String)"57", (String)rs.getString(1));
        }
        QueryChecksTest.assertTrue((boolean)rs.next());
        if (first) {
            QueryChecksTest.assertEquals((String)"57", (String)rs.getString(1));
        } else {
            QueryChecksTest.assertEquals((String)"56", (String)rs.getString(1));
        }
        QueryChecksTest.assertFalse((boolean)rs.next());
        rs.close();
        if (checkScanTypes) {
            observer.addExpectedScanType("t.table_data", "t.if3", TestUtil.ScanType.SORTEDMAPINDEX);
            observer.checkAndClear();
        }
        GemFireXDQueryObserverHolder.clearInstance();
    }

    public static void assertUpdateCount(Statement st, int expectedRC, String sql) throws SQLException {
        QueryChecksTest.assertEquals((String)"Update count does not match:", (int)expectedRC, (int)st.executeUpdate(sql));
    }
}

