/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class NCJoinQueryTest
extends JdbcTestBase {
    public NCJoinQueryTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(NCJoinQueryTest.class));
    }

    @Override
    protected void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleDistributedNode_PRoth_PRoth() throws SQLException {
        System.setProperty("gemfirexd.optimizer.trace", "true");
        System.setProperty("gemfirexd.debug.true", "TraceNCJ");
        Properties props = new Properties();
        String available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        props.setProperty("mcast-port", available_port);
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        st.execute("create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        conn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            st.execute("Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            st.execute("Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        try {
            String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
            PreparedStatement s1 = conn.prepareStatement(query);
            s1.setInt(1, 6);
            s1.setInt(2, 16);
            ResultSet rs = s1.executeQuery();
            while (rs.next()) {
                NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getString(2)));
            }
            NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
            s1.close();
        }
        finally {
            System.out.println("<IgnoreGrepLogsStart/>");
            System.out.println(((EmbedConnection)conn).getLanguageConnection().getOptimizerTraceOutput());
            System.out.println("<IgnoreGrepLogsStop/>");
        }
        conn.commit();
    }

    public void testSingleDistributedNode_PRpk_PRpk() throws SQLException {
        Properties props = new Properties();
        String available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        props.setProperty("mcast-port", available_port);
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        st.execute("create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        conn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            st.execute("Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            st.execute("Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        conn.commit();
    }

    public void testSingleDistributedNode_PRpk_REPpk() throws SQLException {
        Properties props = new Properties();
        String available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        props.setProperty("mcast-port", available_port);
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        st.execute("create table tdriver ( id int primary key, vid varchar(10), sid int) replicate");
        conn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            st.execute("Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            st.execute("Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        conn.commit();
    }

    public void testSingleDistributedNode_REPpk_REPpk() throws SQLException {
        Properties props = new Properties();
        String available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        props.setProperty("mcast-port", available_port);
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table tpk ( id int primary key, vid varchar(10), sid int) replicate");
        st.execute("create table tdriver ( id int primary key, vid varchar(10), sid int) replicate");
        conn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            st.execute("Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            st.execute("Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        conn.commit();
    }

    public void testSingleDistributedNode_PRpk_COLoth_COLoth_COLoth_REP() throws SQLException {
        int i;
        System.setProperty("gemfirexd.optimizer.trace", "true");
        Properties props = new Properties();
        String available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        props.setProperty("mcast-port", available_port);
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table tpk ( id int not null, vid varchar(10) primary key, sid int not null) partition by primary key");
        st.execute("create table tcol ( id int not null, vid varchar(10), sid int primary key) partition by column(id)");
        st.execute("create table tcol2 ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tcol)");
        st.execute("create table tcol3 ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tcol)");
        st.execute("create table trep ( id int primary key, vid varchar(10), sid int not null) replicate");
        conn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        int baseId = 50;
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into tpk values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        securities[0] = "NULL";
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into trep values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        securities[1] = "NULL";
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into tcol values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        securities[2] = "NULL";
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into tcol2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        securities[3] = "NULL";
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into tcol3 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i2 = 5; i2 < 9; ++i2) {
            expected.add(securities[i2]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID, C.ID, C.VID, D.ID, D.VID, E.ID, E.VID from  tpk A inner join tcol B on A.VID = B.VID and A.ID = B.ID inner join tcol2 C on B.ID = C.ID and B.VID = C.VID inner join tcol3 D on C.ID = D.ID and D.VID = C.VID inner join trep E on E.ID = D.ID and E.VID = D.VID where A.SID < ? and B.SID != ? ";
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        conn.commit();
    }

    public void testLonerVmNode_PRoth_PRoth() throws SQLException {
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(0));
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        st.execute("create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        conn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            st.execute("Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            st.execute("Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        conn.commit();
    }

    public void testLonerVmNode_PRpk_PRpk() throws SQLException {
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(0));
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        st.execute("create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        conn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            st.execute("Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            st.execute("Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        conn.commit();
    }

    public void testLonerVmNode_PRpk_COLoth_COLoth_COLoth_REP() throws SQLException {
        int i;
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(0));
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table tpk ( id int not null, vid varchar(10) primary key, sid int not null) partition by primary key");
        st.execute("create table tcol ( id int not null, vid varchar(10), sid int primary key) partition by column(id)");
        st.execute("create table tcol2 ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tcol)");
        st.execute("create table tcol3 ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tcol)");
        st.execute("create table trep ( id int primary key, vid varchar(10), sid int not null) replicate");
        conn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        int baseId = 50;
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into tpk values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        securities[0] = "NULL";
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into trep values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        securities[1] = "NULL";
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into tcol values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        securities[2] = "NULL";
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into tcol2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        securities[3] = "NULL";
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into tcol3 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i2 = 5; i2 < 9; ++i2) {
            expected.add(securities[i2]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID, C.ID, C.VID, D.ID, D.VID, E.ID, E.VID from  tpk A inner join tcol B on A.VID = B.VID and A.ID = B.ID inner join tcol2 C on B.ID = C.ID and B.VID = C.VID inner join tcol3 D on C.ID = D.ID and D.VID = C.VID inner join trep E on E.ID = D.ID and E.VID = D.VID where A.SID < ? and B.SID != ? ";
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        conn.commit();
    }

    public void testMix_3NC_1REP_2COL_Tables() throws Exception {
        int i;
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(0));
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        st.execute("create table trade.DRIVER (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        st.execute("create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        st.execute("create table trade.rep ( rid int not null, rsid int primary key, rvid varchar(10)) replicate");
        st.execute("create table trade.col ( cid int not null, csid int primary key, cvid varchar(10)) partition by column(csid) colocate with (trade.DRIVER)");
        st.execute("create table trade.dcol ( dcid int not null, dcsid int primary key, dcvid varchar(10)) partition by column(dcsid) colocate with (trade.DRIVER)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        Connection conn2 = NCJoinQueryTest.getConnection(props);
        PreparedStatement psInsert = conn2.prepareStatement("insert into trade.orders values (?, ?, ?)");
        for (i = 1; i < 61; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setString(3, securities[i % 10]);
            psInsert.executeUpdate();
        }
        psInsert = conn2.prepareStatement("insert into trade.DRIVER values (?, ?, ?)");
        for (i = 11; i < 71; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setString(3, "2" + securities[i % 10]);
            psInsert.executeUpdate();
        }
        psInsert = conn2.prepareStatement("insert into trade.TRIPLI values (?, ?, ?)");
        for (i = 21; i < 81; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setString(3, "3" + securities[i % 10]);
            psInsert.executeUpdate();
        }
        psInsert = conn2.prepareStatement("insert into trade.rep values (?, ?, ?)");
        for (i = 31; i < 91; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setString(3, "4" + securities[i % 10]);
            psInsert.executeUpdate();
        }
        psInsert = conn2.prepareStatement("insert into trade.col values (?, ?, ?)");
        for (i = 41; i < 101; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setString(3, "5" + securities[i % 10]);
            psInsert.executeUpdate();
        }
        psInsert = conn2.prepareStatement("insert into trade.dcol values (?, ?, ?)");
        for (i = 51; i < 111; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setString(3, "6" + securities[i % 10]);
            psInsert.executeUpdate();
        }
        HashSet<String> expected2 = new HashSet<String>();
        HashSet<String> expected8 = new HashSet<String>();
        for (i = 0; i < 10; ++i) {
            expected2.add(securities[i]);
            expected8.add("4" + securities[i]);
        }
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID, D.RID, D.RVID, E.CID, E.CVID, F.DCID, F.DCVID from  trade.ORDERS A  inner join trade.DRIVER B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  inner join trade.REP D on C.TID = D.RID  inner join trade.COL E on D.RSID = E.CSID  inner join trade.DCOL F on E.CSID = F.DCSID ";
        Connection conn3 = TestUtil.getConnection();
        PreparedStatement s1 = conn3.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected2.remove(rs.getString(2)));
            NCJoinQueryTest.assertTrue((boolean)expected8.remove(rs.getString(8)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected2.isEmpty());
        NCJoinQueryTest.assertTrue((boolean)expected8.isEmpty());
        s1.close();
        conn2 = TestUtil.getConnection(props);
        Statement st2 = conn2.createStatement();
        st2.execute("drop table trade.REP");
        st2.execute("drop table trade.col");
        st2.execute("drop table trade.dcol");
        st2.execute("drop table trade.TRIPLI");
        st2.execute("drop table trade.DRIVER");
        st2.execute("drop table trade.orders");
        st2.execute("drop schema trade restrict");
    }

    public void test_Predicate_ThreeTables() throws Exception {
        int i;
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(0));
        Connection conn = NCJoinQueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.ORDERS (OID int not null, OSID int primary key, OVID varchar(10)) partition by primary key");
        st.execute("create table trade.DUPLI (DID int not null, DSID int primary key, DVID varchar(10)) partition by column (DSID)");
        st.execute("create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 31; ++i) {
            st.execute("Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 11; i < 41; ++i) {
            st.execute("Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 21; i < 51; ++i) {
            st.execute("Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  where A.OID > ? and B.DID <> ? and C.TID < ?";
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement s1 = conn2.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID  where A.OID > ? and B.DID <> ? and C.TID < ?";
        conn2 = TestUtil.getConnection();
        s1 = conn2.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinQueryTest.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinQueryTest.assertTrue((boolean)expected.isEmpty());
        s1.close();
        conn = NCJoinQueryTest.getConnection(props);
        st = conn.createStatement();
        st.execute("drop table trade.TRIPLI");
        st.execute("drop table trade.DUPLI");
        st.execute("drop table trade.orders");
        st.execute("drop schema trade restrict");
    }
}

