/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.query.HeapThresholdHelper;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class HeapThresholdTest
extends JdbcTestBase {
    private static volatile boolean queryExecutionSuccess = true;

    public HeapThresholdTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)true);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)false);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(HeapThresholdTest.class));
        SanityManager.DEBUG_SET((String)"TraceHeapThreshold");
    }

    public void testBug41438() throws Exception {
        HeapThresholdTest.setupConnection();
        HeapThresholdTest.addExpectedException("heap critical threshold");
        Connection conn = TestUtil.startNetserverAndGetLocalNetConnection();
        HeapThresholdHelper.prepareTables(conn);
        conn.close();
        conn = null;
        TestUtil.stopNetServer();
        conn = TestUtil.startNetserverAndGetLocalNetConnection();
        HeapThresholdHelper.prepareTables(conn);
        conn.close();
        conn = null;
        TestUtil.stopNetServer();
    }

    public void testQueryCancellation_1() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        HeapThresholdHelper.prepareTables(null);
        HeapThresholdTest.addExpectedException("heap critical threshold");
        TestUtil.getLogger().info((Object)"BEGIN testQueryCancellation_1");
        String[] query = new String[]{"Select ID1 from testtable1 where id1 > 2"};
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_OPTIMIZATION, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_QUERY_EXECUTE, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_BEFORE_GENERIC_PREP_STMT_QUERY_EXECUTE, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_GENERIC_PREP_STMT_QUERY_EXECUTE, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_RESULT_SET_OPEN, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_ON_RESULT_SET_NEXT, query, null);
        TestUtil.getLogger().info((Object)"END testQueryCancellation_1");
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
    }

    public void testQueryCancellation_2() throws Exception {
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        HeapThresholdHelper.prepareTables(null);
        HeapThresholdTest.addExpectedException("heap critical threshold");
        TestUtil.getLogger().info((Object)"BEGIN testQueryCancellation_2");
        String[] query = new String[]{"Select ID1 from testtable1 where id1 > 2"};
        String[][] constantList = new String[][]{{"2"}};
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_OPTIMIZATION, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_QUERY_EXECUTE, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_BEFORE_GENERIC_PREP_STMT_QUERY_EXECUTE, query, constantList);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_GENERIC_PREP_STMT_QUERY_EXECUTE, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_RESULT_SET_OPEN, query, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_ON_RESULT_SET_NEXT, query, null);
        TestUtil.getLogger().info((Object)"END testQueryCancellation_2");
    }

    public void testMultipleQueryCancellation_1() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = HeapThresholdTest.getConnection();
        HeapThresholdTest.addExpectedException("heap critical threshold");
        HeapThresholdHelper.prepareTables(conn);
        TestUtil.getLogger().info((Object)"BEGIN testMultipleQueryCancellation_1");
        String[] queries = new String[]{"Select ID1 from testtable1 where id1 > 12", "Select * from testtable1 where id1 > 10", "Select ID1, DESCRIPTION1 from testtable1 where id1 > 9"};
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_OPTIMIZATION, queries, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_QUERY_EXECUTE, queries, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_BEFORE_GENERIC_PREP_STMT_QUERY_EXECUTE, queries, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_GENERIC_PREP_STMT_QUERY_EXECUTE, queries, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_RESULT_SET_OPEN, queries, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_ON_RESULT_SET_NEXT, queries, null);
        TestUtil.getLogger().info((Object)"END testMultipleQueryCancellation_1");
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
    }

    public void testMultipleQueryCancellation_2() throws Exception {
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        Connection conn = HeapThresholdTest.getConnection();
        HeapThresholdTest.addExpectedException("heap critical threshold");
        HeapThresholdHelper.prepareTables(conn);
        TestUtil.getLogger().info((Object)"BEGIN testMultipleQueryCancellation_2");
        String[] queries = new String[]{"Select ID1 from testtable1 where id1 > 12", "Select * from testtable1 where id1 > 10", "Select ID1, DESCRIPTION1 from testtable1 where id1 > 9"};
        String[][] constantList = new String[][]{{"12"}, {"10"}, {"9"}};
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_OPTIMIZATION, queries, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_BEFORE_QUERY_EXECUTE, queries, null);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_QUERY_EXECUTE, queries, constantList);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_BEFORE_GENERIC_PREP_STMT_QUERY_EXECUTE, queries, constantList);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_GENERIC_PREP_STMT_QUERY_EXECUTE, queries, constantList);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_AFTER_RESULT_SET_OPEN, queries, constantList);
        this.checkCriticalUp(HeapThresholdHelper.PauseVariants.PAUSE_ON_RESULT_SET_NEXT, queries, constantList);
        TestUtil.getLogger().info((Object)"END testMultipleQueryCancellation_2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemoryEstimationOfQueries() throws SQLException {
        HeapThresholdHelper.prepareTables(null);
        HeapThresholdTest.addExpectedException("heap critical threshold");
        String[] queries = new String[]{"Select ID1 from testtable1 where id1 > 12", "Select * from testtable1 where id1 > 10", "Select ID1 from testtable1 where id1 > 9 order by description1", "Select ID1 from testtable1 order by description1", "Select ID1, ADDRESS1 from testtable1 order by address1", "Select ID1 from testtable1 t1 join testtable2 t2 on t1.id1 = t2.id2", "Select t1.id1, t2.id2 from testtable1 t1 left outer join testtable2 t2 on t1.id1 = t2.id2", "Select * from testtable1 t1 join testtable2 t2 on t1.id1 = t2.id2"};
        Connection conn = HeapThresholdTest.getConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public long estimatedMemoryUsage(String stmtText, long memused) {
                    SanityManager.DEBUG_PRINT(null, (String)("Memory computed for " + stmtText + " " + memused));
                    return memused;
                }
            });
            Activation[] acts = new Activation[queries.length];
            Statement s = conn.createStatement();
            for (int i = 0; i < queries.length; ++i) {
                ResultSet r = s.executeQuery(queries[i]);
                acts[i] = ((EmbedConnection)conn).getLanguageConnection().getLastActivation();
                acts[i].estimateMemoryUsage();
                for (int z = 0; z < 6; ++z) {
                    r.next();
                }
                acts[i].estimateMemoryUsage();
            }
        }
        catch (StandardException e) {
            e.printStackTrace();
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    private void checkCriticalUp(HeapThresholdHelper.PauseVariants variant, String[] queries, String[][] constantList) throws SQLException, InterruptedException, InstantiationException, IllegalAccessException {
        this.reset();
        TestUtil.getLogger().info((Object)("Begin Checking " + variant.name()));
        Thread[] executionThrds = new Thread[queries.length];
        UnitTestQueryExecutor[] executors = new UnitTestQueryExecutor[queries.length];
        int i = 0;
        for (int qi = 0; qi < queries.length; ++qi) {
            executors[i] = new UnitTestQueryExecutor(queries[qi], variant, constantList != null && qi < constantList.length ? constantList[qi] : null);
            executionThrds[i] = HeapThresholdHelper.executeQueryInThread(executors[i]);
            ++i;
        }
        for (int j = 0; j < executors.length; ++j) {
            executors[j].waitForCompilation();
        }
        TestUtil.getLogger().info((Object)"Resuming as the query is in the midst of execution ");
        HeapThresholdHelper.raiseMemoryEvent(true, false);
        for (UnitTestQueryExecutor unitTestQueryExecutor : executors) {
            unitTestQueryExecutor.notifyMemoryEvent();
        }
        for (Runnable runnable : executionThrds) {
            ((Thread)runnable).join();
        }
        HeapThresholdHelper.raiseMemoryEvent(false, true);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        if (!queryExecutionSuccess) {
            HeapThresholdTest.fail("Execution failed for " + (Object)((Object)variant));
        }
        TestUtil.getLogger().info((Object)("Done Checking " + variant.name()));
    }

    private void reset() {
        queryExecutionSuccess = true;
    }

    class UnitTestQueryExecutor
    extends HeapThresholdHelper.QueryExecutor {
        UnitTestQueryExecutor(String queryStr, HeapThresholdHelper.PauseVariants variant, String[] constantList) {
            super(queryStr, variant, constantList);
            this.useThreadLocal = true;
        }

        @Override
        public void run() {
            try {
                this.execute(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void setFailedStatus(String query, String failmsg) {
            queryExecutionSuccess = false;
        }
    }
}

