/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryMonitorJUnitTest;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.test.dunit.DistributedTestBase;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class HeapThresholdHelper {
    private static final ThreadLocal<GemFireXDQueryObserver> tObserver = new ThreadLocal();
    private static final ThreadLocal<String> queryExecuted = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void raiseMemoryEvent(boolean criticalUp, boolean waitForEventToHonor) throws InterruptedException {
        TestUtil.getLogger().info((Object)("About to raise memory event " + (criticalUp ? "CRITICAL_UP" : "CRITICAL_DOWN")));
        GemFireCacheImpl gfCache = Misc.getGemFireCache();
        InternalResourceManager resMgr = gfCache.getResourceManager();
        resMgr.getHeapMonitor().setTestMaxMemoryBytes(100L);
        HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)50L);
        resMgr.setCriticalHeapPercentage(90.0f);
        if (criticalUp) {
            TestUtil.getLogger().info((Object)"About to raise CRITICAL_UP event ");
            gfCache.getLoggerI18n().fine(MemoryMonitorJUnitTest.addExpectedAbove);
            resMgr.getHeapMonitor().updateStateAndSendEvent(92L);
            gfCache.getLoggerI18n().fine(MemoryMonitorJUnitTest.removeExpectedAbove);
        } else {
            final boolean[] criticalDownHonoredArr = new boolean[]{false};
            GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

                public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) {
                    queryExecuted.set(stmt.getUserQueryString(lcc));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void criticalDownMemoryEvent(GfxdHeapThresholdListener listener) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        criticalDownHonoredArr[0] = true;
                        TestUtil.getLogger().info((Object)("Notifying CRITICAL_DOWN event to the waiters " + criticalDownHonoredArr[0]));
                        ((Object)((Object)this)).notify();
                    }
                }
            };
            GemFireXDQueryObserver old = null;
            try {
                if (waitForEventToHonor) {
                    old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                }
                TestUtil.getLogger().info((Object)"About to raise CRITICAL_DOWN event ");
                gfCache.getLoggerI18n().fine(MemoryMonitorJUnitTest.addExpectedBelow);
                resMgr.getHeapMonitor().updateStateAndSendEvent(19L);
                gfCache.getLoggerI18n().fine(MemoryMonitorJUnitTest.removeExpectedBelow);
                if (waitForEventToHonor) {
                    GemFireXDQueryObserverAdapter gemFireXDQueryObserverAdapter = observer;
                    synchronized (gemFireXDQueryObserverAdapter) {
                        while (!criticalDownHonoredArr[0]) {
                            TestUtil.getLogger().info((Object)("Waiting for CRITICAL_DOWN event to be honored " + criticalDownHonoredArr[0]));
                            observer.wait();
                        }
                    }
                }
                Thread.yield();
            }
            finally {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
                }
            }
        }
    }

    public static void prepareTables(Connection connection) throws SQLException {
        Connection conn = null;
        if (connection == null) {
            TestUtil.setupConnection();
            conn = TestUtil.jdbcConn;
        } else {
            conn = connection;
        }
        Statement s = conn.createStatement();
        try {
            s.execute("drop table testtable2");
            s.execute("drop table testtable1");
        }
        catch (SQLException ignore) {
            TestUtil.getLogger().info((Object)("Ignoring Drop exception " + ignore));
        }
        s.execute("create table TESTTABLE1 (ID1 int primary key , DESCRIPTION1 varchar(1024) , ADDRESS1 varchar(1024)) partition by primary key");
        s.execute("create table TESTTABLE2 (ID2 int primary key , DESCRIPTION2 varchar(1024) , ADDRESS2 varchar(1024)) partition by primary key colocate with (TestTable1)");
        s.execute("create index tt2_idx1 on TESTTABLE2(DESCRIPTION2) ");
        String tab1 = HeapThresholdHelper.getData(new StringBuilder("insert into testtable1 (ID1, DESCRIPTION1, ADDRESS1) values "));
        s.executeUpdate(tab1);
        String tab2 = HeapThresholdHelper.getData(new StringBuilder("insert into testtable2 (ID2, DESCRIPTION2, ADDRESS2) values "));
        s.executeUpdate(tab2);
        conn.close();
    }

    private static String getData(StringBuilder sb) {
        for (int i = 0; i < 20; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("(" + i);
            sb.append(",'DESC'");
            sb.append(",'ADD')");
        }
        return sb.toString();
    }

    public static Thread executeQueryInThread(QueryExecutor executor) throws SQLException, InterruptedException {
        Thread executeQ = new Thread(executor, "[" + executor.query() + "]"){

            @Override
            public void start() {
                super.start();
                TestUtil.getLogger().info((Object)("starting " + this));
            }
        };
        executeQ.setDaemon(true);
        executeQ.setPriority(1);
        executeQ.start();
        Thread.yield();
        return executeQ;
    }

    public static enum PauseVariants {
        PAUSE_AFTER_OPTIMIZATION{

            @Override
            GemFireXDQueryObserver observer(final QueryExecutor executor) {
                return new GemFireXDQueryObserverAdapter(){

                    public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) {
                        queryExecuted.set(stmt.getUserQueryString(lcc));
                    }

                    public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
                        if (executor.useThreadLocal && tObserver.get() != this) {
                            return;
                        }
                        if (!executor.useThreadLocal && !query.equals(executor.query())) {
                            return;
                        }
                        queryStr = executor.query();
                        TestUtil.getLogger().info((Object)("afterOptimizedParsedTree: honoring callback " + query));
                        executor.waitForMemoryEvent();
                    }

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
                        PauseVariants.delayNext(newRow, executor.query(), theResults);
                    }

                    public long estimatedMemoryUsage(String stmtText, long memused) {
                        TestUtil.getLogger().info((Object)("afterOptimizedParsedTree: estimated memory for " + stmtText + " is " + memused));
                        return memused;
                    }
                };
            }
        }
        ,
        PAUSE_BEFORE_QUERY_EXECUTE{

            @Override
            GemFireXDQueryObserver observer(final QueryExecutor executor) {
                return new GemFireXDQueryObserverAdapter(){

                    public void beforeQueryExecution(EmbedStatement stmt, Activation activation) {
                        queryExecuted.set(stmt.getSQLText());
                        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
                        if (executor.useThreadLocal && tObserver.get() != this) {
                            return;
                        }
                        if (!executor.useThreadLocal && !stmt.getSQLText().equals(executor.getGenericQuery())) {
                            return;
                        }
                        queryStr = stmt.getSQLText();
                        TestUtil.getLogger().info((Object)("beforeQueryExecution: honoring callback " + stmt.getSQLText()));
                        executor.waitForMemoryEvent();
                    }

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
                        PauseVariants.delayNext(newRow, executor.query(), theResults);
                    }

                    public long estimatedMemoryUsage(String stmtText, long memused) {
                        TestUtil.getLogger().info((Object)("afterQueryExecution: estimated memory for " + stmtText + " is " + memused));
                        return memused;
                    }
                };
            }
        }
        ,
        PAUSE_AFTER_QUERY_EXECUTE{

            @Override
            GemFireXDQueryObserver observer(final QueryExecutor executor) {
                return new GemFireXDQueryObserverAdapter(){

                    public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) {
                        queryExecuted.set(stmt.getUserQueryString(lcc));
                    }

                    public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) {
                        if (executor.useThreadLocal && tObserver.get() != this) {
                            return false;
                        }
                        if (!executor.useThreadLocal && !((String)queryExecuted.get()).equals(executor.query())) {
                            return false;
                        }
                        queryStr = (String)queryExecuted.get();
                        TestUtil.getLogger().info((Object)("afterQueryExecution: honoring callback " + (String)queryExecuted.get()));
                        executor.waitForMemoryEvent();
                        return false;
                    }

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
                        PauseVariants.delayNext(newRow, executor.query(), theResults);
                    }

                    public long estimatedMemoryUsage(String stmtText, long memused) {
                        TestUtil.getLogger().info((Object)("afterQueryExecution: estimated memory for " + stmtText + " is " + memused));
                        return memused;
                    }
                };
            }
        }
        ,
        PAUSE_BEFORE_GENERIC_PREP_STMT_QUERY_EXECUTE{

            @Override
            GemFireXDQueryObserver observer(final QueryExecutor executor) {
                return new GemFireXDQueryObserverAdapter(){

                    public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) {
                        queryExecuted.set(stmt.getUserQueryString(lcc));
                        if (executor.useThreadLocal && tObserver.get() != this) {
                            return;
                        }
                        if (!executor.useThreadLocal && !stmt.getUserQueryString(lcc).equals(executor.query())) {
                            return;
                        }
                        queryStr = executor.query();
                        TestUtil.getLogger().info((Object)("beforeGenericPSQueryExecution: honoring callback " + queryStr));
                        executor.waitForMemoryEvent();
                    }

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
                        PauseVariants.delayNext(newRow, executor.query(), theResults);
                    }

                    public long estimatedMemoryUsage(String stmtText, long memused) {
                        TestUtil.getLogger().info((Object)("beforeGenericPSQueryExecution: estimated memory for " + stmtText + " is " + memused));
                        return memused;
                    }
                };
            }
        }
        ,
        PAUSE_AFTER_GENERIC_PREP_STMT_QUERY_EXECUTE{

            @Override
            GemFireXDQueryObserver observer(final QueryExecutor executor) {
                return new GemFireXDQueryObserverAdapter(){

                    public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) {
                        queryExecuted.set(stmt.getUserQueryString(lcc));
                    }

                    public void afterQueryExecution(GenericPreparedStatement stmt, Activation activation) throws StandardException {
                        if (executor.useThreadLocal && tObserver.get() != this) {
                            return;
                        }
                        if (!executor.useThreadLocal && !((String)queryExecuted.get()).equals(executor.query())) {
                            return;
                        }
                        queryStr = executor.query();
                        TestUtil.getLogger().info((Object)("afterGenericPSQueryExecution: honoring callback " + (String)queryExecuted.get()));
                        executor.waitForMemoryEvent();
                    }

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
                        PauseVariants.delayNext(newRow, executor.query(), theResults);
                    }

                    public long estimatedMemoryUsage(String stmtText, long memused) {
                        TestUtil.getLogger().info((Object)("afterGenericPSQueryExecution: estimated memory for " + stmtText + " is " + memused));
                        return memused;
                    }
                };
            }
        }
        ,
        PAUSE_AFTER_RESULT_SET_OPEN{

            @Override
            GemFireXDQueryObserver observer(final QueryExecutor executor) {
                return new GemFireXDQueryObserverAdapter(){

                    public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) {
                        queryExecuted.set(stmt.getUserQueryString(lcc));
                    }

                    public void afterResultSetOpen(GenericPreparedStatement stmt, LanguageConnectionContext lcc, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        if (executor.useThreadLocal && tObserver.get() != this) {
                            return;
                        }
                        if (!executor.useThreadLocal && !((String)queryExecuted.get()).equals(executor.query())) {
                            return;
                        }
                        queryStr = executor.query();
                        TestUtil.getLogger().info((Object)("afterResultSetOpen: honoring callback " + stmt.getUserQueryString(lcc)));
                        executor.waitForMemoryEvent();
                    }

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
                        PauseVariants.delayNext(newRow, executor.query(), theResults);
                    }

                    public long estimatedMemoryUsage(String stmtText, long memused) {
                        TestUtil.getLogger().info((Object)("afterResultOpen: estimated memory for " + stmtText + " is " + memused));
                        return memused;
                    }
                };
            }
        }
        ,
        PAUSE_ON_RESULT_SET_NEXT{

            @Override
            GemFireXDQueryObserver observer(final QueryExecutor executor) {
                return new GemFireXDQueryObserverAdapter(){

                    public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) {
                        queryExecuted.set(stmt.getUserQueryString(lcc));
                    }

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
                        if (executor.useThreadLocal && tObserver.get() != this) {
                            return;
                        }
                        String query = executor.query();
                        if (!executor.useThreadLocal && !query.equals(queryExecuted.get())) {
                            return;
                        }
                        queryStr = executor.query();
                        TestUtil.getLogger().info((Object)("onEmbedResultSetMovePosition: honoring callback " + (String)queryExecuted.get()));
                        PauseVariants.delayNext(newRow, query, theResults);
                        executor.waitForMemoryEvent();
                    }

                    public long estimatedMemoryUsage(String stmtText, long memused) {
                        TestUtil.getLogger().info((Object)("afterResultSetNext: estimated memory for " + stmtText + " is " + memused));
                        return memused;
                    }
                };
            }

            @Override
            int minExpectedRows() {
                return 4;
            }
        };

        String queryStr;

        abstract GemFireXDQueryObserver observer(QueryExecutor var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void delayNext(ExecRow newRow, String execQryStr, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
            if (newRow == null) {
                return;
            }
            if (!execQryStr.equals(queryExecuted.get())) {
                TestUtil.getLogger().info((Object)("NOT Delaying next for [" + execQryStr + "]"));
                return;
            }
            try {
                Thread t;
                Thread thread = t = Thread.currentThread();
                synchronized (thread) {
                    TestUtil.getLogger().info((Object)("Delaying next on [" + execQryStr + "]"));
                    t.wait(GfxdHeapThresholdListener.queryCancellationTimeInterval + 1500);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        int minExpectedRows() {
            return -1;
        }

        public String toString() {
            return "QueryString " + (this.queryStr != null ? this.queryStr : " null ") + " with PauseVariant " + this.name();
        }
    }

    public static abstract class QueryExecutor
    implements Runnable,
    Serializable {
        protected String queryStr;
        protected String[] constantList;
        protected GemFireXDQueryObserver observer;
        protected final PauseVariants variant;
        protected int numOfNexts = 0;
        protected final int minRowsExpected;
        protected int numRowsFetched = 0;
        protected boolean useThreadLocal;
        private volatile boolean wait4MemoryEvent = true;
        private volatile boolean observerCallbackInvoked = false;

        protected QueryExecutor() {
            this.minRowsExpected = -1;
            this.variant = null;
        }

        protected QueryExecutor(String queryStr, PauseVariants variant, String[] constantList) {
            this.queryStr = queryStr;
            this.constantList = constantList;
            this.minRowsExpected = variant.minExpectedRows();
            this.observer = variant.observer(this);
            this.variant = variant;
        }

        protected abstract void setFailedStatus(String var1, String var2);

        protected Connection getConnection() throws SQLException {
            return TestUtil.getConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(boolean setLocalObserver) throws SQLException {
            Connection conn = this.getConnection();
            try {
                if (setLocalObserver) {
                    GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.observer);
                    tObserver.set(this.observer);
                }
                Statement s = conn.createStatement();
                ResultSet rs = s.executeQuery(this.queryStr);
                while (rs.next()) {
                    ++this.numRowsFetched;
                    TestUtil.getLogger().info((Object)("got result " + rs.getInt(1)));
                }
                String failmsg = "Expected StandardException indicating statement cancelled due to low resources";
                this.setFailedStatus(this.queryStr, failmsg);
                DistributedTestBase.fail((String)failmsg);
            }
            catch (SQLException e) {
                if (!"XCL54".equals(e.getSQLState())) {
                    String failmsg = "got unexpected exception " + e.getSQLState() + " " + SanityManager.getStackTrace((Throwable)e);
                    this.setFailedStatus(this.queryStr, failmsg);
                    DistributedTestBase.fail((String)failmsg, (Throwable)e);
                } else if (this.minRowsExpected != -1 && this.numRowsFetched < this.minRowsExpected) {
                    String failmsg = "Expected " + this.minRowsExpected + " rows and got " + this.numRowsFetched + " rows before query is canceled";
                    this.setFailedStatus(this.queryStr, failmsg);
                    DistributedTestBase.fail((String)failmsg);
                }
            }
            finally {
                if (setLocalObserver) {
                    GemFireXDQueryObserverHolder.removeObserver((QueryObserver)this.observer);
                    this.notifyCompilation();
                }
                conn.close();
            }
        }

        public synchronized void waitForCompilation() throws InterruptedException {
            while (!this.observerCallbackInvoked) {
                TestUtil.getLogger().info((Object)("Waiting for compilation of " + this.queryStr));
                this.wait();
            }
        }

        public synchronized void notifyCompilation() {
            TestUtil.getLogger().info((Object)("Done compilation of " + this.queryStr + " "));
            this.observerCallbackInvoked = true;
            this.notify();
            Thread.yield();
        }

        public synchronized void waitForMemoryEvent() {
            if (this.minRowsExpected != -1 && ++this.numOfNexts < this.minRowsExpected) {
                return;
            }
            this.notifyCompilation();
            TestUtil.getLogger().info((Object)"Start waiting for memory event ");
            while (this.wait4MemoryEvent) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            TestUtil.getLogger().info((Object)"Done waiting for memory event ");
        }

        public synchronized void notifyMemoryEvent() {
            TestUtil.getLogger().info((Object)("Notifying memoryEvent for " + this.queryStr + " "));
            this.wait4MemoryEvent = false;
            this.notify();
        }

        public String getGenericQuery() {
            if (this.constantList == null) {
                return this.queryStr;
            }
            String q = this.queryStr;
            for (String s : this.constantList) {
                q = q.replaceFirst(s, "<?>");
            }
            return q;
        }

        public String query() {
            return this.queryStr;
        }

        public GemFireXDQueryObserver observer() {
            return this.observer;
        }

        public PauseVariants variant() {
            return this.variant;
        }

        public synchronized boolean isWaitingForMemoryEvent() {
            return this.wait4MemoryEvent;
        }
    }
}

