/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CustomerUsecasesTest
extends JdbcTestBase {
    private static final boolean analyzeMode = false;

    public CustomerUsecasesTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(CustomerUsecasesTest.class));
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testBet365_Top1_Ordered_Subquery_NetClient() throws Exception {
        CustomerUsecasesTest.setupConnection();
        Connection conn = TestUtil.startNetserverAndGetLocalNetConnection();
        this.executeFetch_1_OrderBy_Subquery(conn);
        TestUtil.stopNetServer();
    }

    public void testBet365_Top1_Ordered_Subquery() throws Exception {
        TestUtil.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        this.executeFetch_1_OrderBy_Subquery(conn);
        TestUtil.shutDown();
    }

    private void executeFetch_1_OrderBy_Subquery(Connection conn) {
        try {
            conn.createStatement().execute("drop table Account");
            conn.createStatement().execute("drop table AccountHolder");
            conn.createStatement().execute("drop table OuterTable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int i;
            conn.createStatement().execute("create table Account (acid int primary key, acname varchar(100), actype int)");
            conn.createStatement().execute("create table AccountHolder (ahid int primary key, ahname varchar(100), ahacid int, ahotid int, ahtype int)");
            conn.createStatement().execute("create index acc_type on AccountHolder(ahotid asc, ahacid asc, ahtype desc)");
            conn.createStatement().execute("create table OuterTable (otid int primary key, oname varchar(100), otaotid int)");
            conn.createStatement().execute("create table AnotherOuterTable (aotid int primary key, aoname varchar(100), blank int)");
            PreparedStatement ps = conn.prepareStatement("insert into Account values(?,?,?)");
            for (int i2 = 1; i2 <= 100; ++i2) {
                ps.setInt(1, i2);
                ps.setString(2, "naAcc " + i2);
                ps.setInt(3, i2 * 4);
                ps.addBatch();
                if (i2 % 100 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            HashMap<Integer, Integer> checker = new HashMap<Integer, Integer>(100);
            ps = conn.prepareStatement("insert into AccountHolder values(?,?,?,?,?)");
            for (i = 1; i <= 100; ++i) {
                int t;
                ps.setInt(1, i);
                ps.setString(2, "na -- " + i);
                ps.setInt(3, i);
                ps.setInt(4, i);
                ps.setInt(5, 1);
                ps.execute();
                checker.put(i, t);
                for (t = PartitionedRegion.rand.nextInt(100) + 2; t > 1; --t) {
                    ps.setInt(1, i * 1000 + t);
                    ps.setString(2, "na ++ " + i);
                    ps.setInt(3, i);
                    ps.setInt(4, i);
                    ps.setInt(5, t);
                    ps.execute();
                }
            }
            ps = conn.prepareStatement("insert into OuterTable values(?,?,?)");
            for (i = 1; i <= 100; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "naOut " + i);
                ps.setInt(3, i * 4);
                ps.addBatch();
                if (i % 100 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            ps = conn.prepareStatement("insert into AnotherOuterTable values(?,?,?)");
            for (i = 1; i <= 100; ++i) {
                ps.setInt(1, i * 4);
                ps.setString(2, "naAnOut " + i);
                ps.setInt(3, i * 3930);
                ps.addBatch();
                if (i % 100 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            ResultSet cnt = conn.createStatement().executeQuery("select count(1) from AccountHolder");
            cnt.next();
            CustomerUsecasesTest.getLogger().info((Object)("AccountHolder have = " + cnt.getInt(1)));
            cnt.close();
            String queryStr = "select O.otid, (select ah.ahtype from AccountHolder AS ah --GEMFIREXD-PROPERTIES index=acc_type \r  join Account ac on ah.ahacid = ac.acid where ah.ahotid = O.otid fetch first row only)   from OuterTable O join AnotherOuterTable aO on O.otaotid = aO.aotid  where O.otid in (?,?,?,?,?) ";
            CustomerUsecasesTest.getLogger().info((Object)"about to execute query select O.otid, (select ah.ahtype from AccountHolder AS ah --GEMFIREXD-PROPERTIES index=acc_type \r  join Account ac on ah.ahacid = ac.acid where ah.ahotid = O.otid fetch first row only)   from OuterTable O join AnotherOuterTable aO on O.otaotid = aO.aotid  where O.otid in (?,?,?,?,?) ");
            PreparedStatement qu = conn.prepareStatement("select O.otid, (select ah.ahtype from AccountHolder AS ah --GEMFIREXD-PROPERTIES index=acc_type \r  join Account ac on ah.ahacid = ac.acid where ah.ahotid = O.otid fetch first row only)   from OuterTable O join AnotherOuterTable aO on O.otaotid = aO.aotid  where O.otid in (?,?,?,?,?) ");
            qu.setInt(1, 10);
            qu.setInt(2, 99);
            qu.setInt(3, 34);
            qu.setInt(4, 45);
            qu.setInt(5, 7);
            long beginTime = System.currentTimeMillis();
            ResultSet rs = qu.executeQuery();
            while (rs.next()) {
                int num1 = rs.getInt(1);
                int num2 = rs.getInt(2);
                CustomerUsecasesTest.assertEquals((String)"Bet365 select top 1 subquery failure : ", (int)num2, (int)((Integer)checker.get(num1)));
            }
            long endTime = System.currentTimeMillis();
            CustomerUsecasesTest.getLogger().info((Object)("closing resultset time took (milliseconds) = " + (endTime - beginTime)));
            rs.close();
            CallableStatement cs = conn.prepareCall("CALL SYSIBM.SQLTABLES('', '', '', '', 'GETCATALOGS=1')");
            ResultSet ts = cs.executeQuery();
            ResultSetMetaData rsm = ts.getMetaData();
            int c = rsm.getColumnCount();
            int j = 0;
            CustomerUsecasesTest.getLogger().info((Object)("Trying to browse " + c));
            while (ts.next()) {
                for (int i3 = 1; i3 <= c; ++i3) {
                    Object ob = ts.getObject(i3);
                    CustomerUsecasesTest.getLogger().info((Object)("Col " + i3 + " = " + ob));
                }
                CustomerUsecasesTest.getLogger().info((Object)("Row Completed " + ++j));
            }
            ts.close();
        }
        catch (Exception ex) {
            CustomerUsecasesTest.getLogger().error((Object)("Exception " + ex));
            CustomerUsecasesTest.getLogger().error((Object)SanityManager.getStackTrace((Throwable)ex));
        }
    }
}

