/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CharPartitionTest
extends JdbcTestBase {
    private static volatile Connection derbyConn = null;
    private static volatile Connection gfxdConn = null;
    private ResultSet rsGfxd = null;
    private ResultSet rsDerby = null;
    private static int mcastPort;

    public CharPartitionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(CharPartitionTest.class));
    }

    public static ResultSet executeQueryOnDerby(String sql) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        ResultSet rs = null;
        rs = derbyConn.createStatement().executeQuery(sql);
        return rs;
    }

    public static int executeUpdateOnDerby(String sql) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        int ret = 0;
        ret = derbyConn.createStatement().executeUpdate(sql);
        return ret;
    }

    public static ResultSet executeQueryOnGfxd(String sql) throws Exception {
        if (gfxdConn == null) {
            Properties props = new Properties();
            props.put("mcast-port", String.valueOf(mcastPort));
            gfxdConn = TestUtil.getConnection(props);
        }
        ResultSet rs = null;
        rs = gfxdConn.createStatement().executeQuery(sql);
        return rs;
    }

    public static int executeUpdateOnGfxd(String sql) throws Exception {
        if (gfxdConn == null) {
            Properties props = new Properties();
            props.put("mcast-port", String.valueOf(mcastPort));
            gfxdConn = TestUtil.getConnection(props);
        }
        int ret = 0;
        ret = gfxdConn.createStatement().executeUpdate(sql);
        return ret;
    }

    private void compareResultSets(ResultSet rsGfxd, ResultSet rsDerby) throws Exception {
        CharPartitionTest.validateResults(rsDerby, rsGfxd, false);
    }

    public void testBug46046() throws Exception {
        mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        String partitionStrategy = "";
        this.partitionBy(partitionStrategy);
        partitionStrategy = " partition by column (c1)";
        this.partitionBy(partitionStrategy);
        partitionStrategy = " partition by range (c1) (values between ' ' and 'a', values between 'b' and 'c')";
        this.partitionBy(partitionStrategy);
        partitionStrategy = " partition by (c1)";
        this.partitionBy(partitionStrategy);
        if (gfxdConn != null) {
            gfxdConn.close();
        }
        if (derbyConn != null) {
            derbyConn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionBy(String partitionStrategy) throws Exception {
        try {
            CharPartitionTest.executeUpdateOnGfxd("create table chartab (c1 char(10), c2 char(5))" + partitionStrategy);
            CharPartitionTest.executeUpdateOnDerby("create table chartab (c1 char(10), c2 char(5))");
            CharPartitionTest.executeUpdateOnGfxd("insert into chartab values (' ', '     ')");
            CharPartitionTest.executeUpdateOnGfxd("insert into chartab values ('a', 'a    ')");
            CharPartitionTest.executeUpdateOnGfxd("insert into chartab values ('b', 'bcdef')");
            CharPartitionTest.executeUpdateOnGfxd("insert into chartab values (null, null)");
            CharPartitionTest.executeUpdateOnDerby("insert into chartab values (' ', '     ')");
            CharPartitionTest.executeUpdateOnDerby("insert into chartab values ('a', 'a    ')");
            CharPartitionTest.executeUpdateOnDerby("insert into chartab values ('b', 'bcdef')");
            CharPartitionTest.executeUpdateOnDerby("insert into chartab values (null, null)");
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 = ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 = ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = '     '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = '     '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 = 'a'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 = 'a'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = 'a    '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 = 'b'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 = 'b'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = 'bcdef'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = 'bcdef'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 = ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 = ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 = '                      '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 = '                      '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = '                           '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = '                           '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 = 'a        '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 = 'a        '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = 'a '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 = 'b             '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 = 'b             '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = 'bcdef                '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = 'bcdef                '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = 'bcde       '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = 'bcde       '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1, c2 from chartab where c1 = c2");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1, c2 from chartab where c1 = c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 is null");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 is null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 is not null");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 is not null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where not c1 is null");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where not c1 is null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <> ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <> ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> '     '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> '     '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <> 'a'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <> 'a'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> 'a    '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <> 'b'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <> 'b'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> 'bcdef'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> 'bcdef'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 != ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 != ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 != '     '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 != '     '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 != 'a'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 != 'a'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 != 'a    '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 != 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 != 'b'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 != 'b'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 != 'bcdef'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 != 'bcdef'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <> ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <> ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <> '                      '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <> '                      '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> '                           '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> '                           '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <> 'a        '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <> 'a        '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> 'a '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <> 'b             '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <> 'b             '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> 'bcdef                '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> 'bcdef                '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <> 'bcde       '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <> 'bcde       '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1, c2 from chartab where c1 <> c2");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1, c2 from chartab where c1 <> c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 < ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 < ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < '     '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < '     '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 < 'a'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 < 'a'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < 'a    '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 < 'b'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 < 'b'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < 'bcdef'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < 'bcdef'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 < ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 < ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 < '                      '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 < '                      '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < '                           '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < '                           '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 < 'a        '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 < 'a        '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < 'a '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 < 'b             '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 < 'b             '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < 'bcdef                '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < 'bcdef                '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 < 'bcde       '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 < 'bcde       '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1, c2 from chartab where c1 < c2");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1, c2 from chartab where c1 < c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 > '     '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 > '     '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > 'a'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > 'a'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 > 'a    '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 > 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > 'b'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > 'b'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 > 'bcdef'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 > 'bcdef'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > '                      '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > '                      '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 > ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 > ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 > '                           '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 > '                           '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > 'a        '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > 'a        '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 > 'a '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 > 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 > 'b             '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 > 'b             '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 > 'bcdef                '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 > 'bcdef                '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 > 'bcde       '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 > 'bcde       '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1, c2 from chartab where c1 > c2");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1, c2 from chartab where c1 > c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <= ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <= ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= '     '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= '     '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <= 'a'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <= 'a'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= 'a    '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <= 'b'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <= 'b'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= 'bcdef'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= 'bcdef'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <= ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <= ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <= '                      '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <= '                      '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= '                           '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= '                           '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <= 'a        '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <= 'a        '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= 'a '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 <= 'b             '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 <= 'b             '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= 'bcdef                '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= 'bcdef                '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 <= 'bcde       '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 <= 'bcde       '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1, c2 from chartab where c1 <= c2");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1, c2 from chartab where c1 <= c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 >= ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 >= ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= '     '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= '     '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 >= 'a'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 >= 'a'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= 'a    '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= 'a    '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 >= 'b'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 >= 'b'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= 'bcdef'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= 'bcdef'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 >= ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 >= ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 >= '                      '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 >= '                      '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= ''");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= ''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= ' '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= ' '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= '                           '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= '                           '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 >= 'a        '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 >= 'a        '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= 'a '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= 'a '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 >= 'b             '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 >= 'b             '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= 'bcdef                '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= 'bcdef                '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 >= 'bcde       '");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 >= 'bcde       '");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1, c2 from chartab where c1 >= c2");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1, c2 from chartab where c1 >= c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c2 from chartab where c2 = 'bcdeff'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c2 from chartab where c2 = 'bcdeff'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharPartitionTest.executeQueryOnGfxd("select c1 from chartab where c1 = 'a         a'");
            this.rsDerby = CharPartitionTest.executeQueryOnDerby("select c1 from chartab where c1 = 'a         a'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
        }
        finally {
            if (this.rsGfxd != null) {
                this.rsGfxd.close();
            }
            if (this.rsDerby != null) {
                this.rsDerby.close();
            }
            CharPartitionTest.executeUpdateOnGfxd("drop table chartab");
            CharPartitionTest.executeUpdateOnDerby("drop table chartab");
        }
    }
}

