/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.query;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import io.snappydata.test.util.TestException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CharForBitDataPartitionTest
extends JdbcTestBase {
    private static volatile Connection derbyConn = null;
    private static volatile Connection gfxdConn = null;
    private ResultSet rsGfxd = null;
    private ResultSet rsDerby = null;
    private static volatile int mcastPort;

    public CharForBitDataPartitionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(CharForBitDataPartitionTest.class));
    }

    public static ResultSet executeQueryOnDerby(String sql) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        ResultSet rs = null;
        rs = derbyConn.createStatement().executeQuery(sql);
        return rs;
    }

    public static int executeUpdateOnDerby(String sql) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        int ret = 0;
        ret = derbyConn.createStatement().executeUpdate(sql);
        return ret;
    }

    public static ResultSet executeQueryOnGfxd(String sql) throws Exception {
        if (gfxdConn == null) {
            Properties props = new Properties();
            props.put("mcast-port", String.valueOf(mcastPort));
            gfxdConn = TestUtil.getConnection(props);
        }
        ResultSet rs = null;
        rs = gfxdConn.createStatement().executeQuery(sql);
        return rs;
    }

    public static int executeUpdateOnGfxd(String sql) throws Exception {
        if (gfxdConn == null) {
            Properties props = new Properties();
            props.put("mcast-port", String.valueOf(mcastPort));
            gfxdConn = TestUtil.getConnection(props);
        }
        int ret = 0;
        ret = gfxdConn.createStatement().executeUpdate(sql);
        return ret;
    }

    private Vector<byte[]> convertToVector(ResultSet rs) throws Exception {
        Vector<byte[]> v = new Vector<byte[]>();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                v.add(rs.getBytes(i));
            }
        }
        return v;
    }

    private String vectorToString(Vector<byte[]> v) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("The size of list is " + v.size() + "\n");
        for (int i = 0; i < v.size(); ++i) {
            byte[] aStruct = v.get(i);
            for (int j = 0; j < aStruct.length; ++j) {
                aStr.append(aStruct[j]);
            }
            aStr.append("\n");
        }
        return aStr.toString();
    }

    private int findInVector(Vector<byte[]> v, byte[] b) {
        for (int i = 0; i < v.size(); ++i) {
            if (!Arrays.equals(v.get(i), b)) continue;
            return i;
        }
        return -1;
    }

    private void compareResultSets(ResultSet rsGfxd, ResultSet rsDerby) throws Exception {
        Vector<byte[]> gfxdV = this.convertToVector(rsGfxd);
        Vector<byte[]> derbyV = this.convertToVector(rsDerby);
        Vector<byte[]> derbyVCopy = new Vector<byte[]>(derbyV);
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < gfxdV.size(); ++i) {
            int idx = this.findInVector(derbyVCopy, gfxdV.get(i));
            if (idx == -1) continue;
            derbyVCopy.remove(idx);
        }
        Vector<byte[]> missing = derbyVCopy;
        if (gfxdV.size() != derbyV.size() || missing.size() > 0) {
            Vector<byte[]> gfxdVCopy = new Vector<byte[]>(gfxdV);
            for (int i = 0; i < derbyV.size(); ++i) {
                int idx = this.findInVector(gfxdVCopy, derbyV.get(i));
                if (idx == -1) continue;
                gfxdVCopy.remove(idx);
            }
            Vector<byte[]> unexpected = gfxdVCopy;
            if (unexpected.size() > 0) {
                aStr.append("the following " + unexpected.size() + " elements are unexpected from GemFireXD: " + this.vectorToString(unexpected));
            }
        }
        if (missing.size() > 0) {
            aStr.append("the following " + missing.size() + " elements are missing in GemFireXD: " + this.vectorToString(missing));
        }
        if (aStr.length() != 0) {
            this.logger.info((Object)("ResultSet from GemFireXD is " + this.vectorToString(gfxdV)));
            this.logger.info((Object)("ResultSet from Derby is " + this.vectorToString(derbyV)));
            this.logger.info((Object)("ResultSet difference is " + aStr.toString()));
            throw new TestException(aStr.toString());
        }
        if (gfxdV.size() != derbyV.size()) {
            if (gfxdV.size() < derbyV.size()) {
                throw new TestException("There are more data in Derby ResultSet");
            }
            throw new TestException("There are fewer data in Derby ResultSet");
        }
        this.logger.info((Object)"verified that results are correct");
        rsGfxd.close();
        rsDerby.close();
    }

    public void testBug46046() throws Exception {
        mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        String partitionStrategy = "";
        this.partitionBy(partitionStrategy);
        if (gfxdConn != null) {
            gfxdConn.close();
        }
        if (derbyConn != null) {
            derbyConn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionBy(String partitionStrategy) throws Exception {
        try {
            CharForBitDataPartitionTest.executeUpdateOnGfxd("create table charfbdtab (c1 char(10) for bit data, c2 char(5) for bit data)" + partitionStrategy);
            CharForBitDataPartitionTest.executeUpdateOnDerby("create table charfbdtab (c1 char(10) for bit data, c2 char(5) for bit data)");
            CharForBitDataPartitionTest.executeUpdateOnGfxd("insert into charfbdtab values (x'20', x'2020202020')");
            CharForBitDataPartitionTest.executeUpdateOnGfxd("insert into charfbdtab values (x'41', x'4120202020')");
            CharForBitDataPartitionTest.executeUpdateOnGfxd("insert into charfbdtab values (x'42', x'4243444546')");
            CharForBitDataPartitionTest.executeUpdateOnGfxd("insert into charfbdtab values (null, null)");
            CharForBitDataPartitionTest.executeUpdateOnDerby("insert into charfbdtab values (x'20', x'2020202020')");
            CharForBitDataPartitionTest.executeUpdateOnDerby("insert into charfbdtab values (x'41', x'4120202020')");
            CharForBitDataPartitionTest.executeUpdateOnDerby("insert into charfbdtab values (x'42', x'4243444546')");
            CharForBitDataPartitionTest.executeUpdateOnDerby("insert into charfbdtab values (null, null)");
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 = x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 = x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'2020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'2020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 = x'41'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 = x'41'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'4120202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 = x'42'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 = x'42'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'4243444546'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'4243444546'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 = x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 = x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 = x'202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 = x'202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 = x'412020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 = x'412020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'4220'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'4220'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 = x'4220202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 = x'4220202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'4243444546202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'4243444546202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'4243444520202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'4243444520202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1, c2 from charfbdtab where c1 = c2");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1, c2 from charfbdtab where c1 = c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 is null");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 is null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 is not null");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 is not null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where not c1 is null");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where not c1 is null");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <> x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <> x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x'2020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x'2020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <> x'41'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <> x'41'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x'4120202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <> x'42'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <> x'42'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x'4243444546'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x'4243444546'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 != x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 != x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 != x'2020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 != x'2020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 != x'41'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 != x'41'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 != x'4120202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 != x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 != x'42'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 != x'42'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 != x'4243444546'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 != x'4243444546'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <> x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <> x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <> x'20202020202020202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <> x'20202020202020202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x'20202020202020202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x'20202020202020202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <> x'412020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <> x'412020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x'4120'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <> x'422020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <> x'422020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x'424344454620202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x'424344454620202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <> x'4243444520202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <> x'4243444520202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1, c2 from charfbdtab where c1 <> c2");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1, c2 from charfbdtab where c1 <> c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 < x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 < x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x'2020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x'2020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 < x'41'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 < x'41'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x'4120202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 < x'42'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 < x'42'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x'4243444546'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x'4243444546'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 < x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 < x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 < x'2020202020202020202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 < x'2020202020202020202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x'2020202020202020202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x'2020202020202020202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 < x'412020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 < x'412020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x'4120'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 < x'422020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 < x'422020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x'424344454620202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x'424344454620202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 < x'42434445202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 < x'42434445202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1, c2 from charfbdtab where c1 < c2");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1, c2 from charfbdtab where c1 < c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 > x'2020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 > x'2020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x'41'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x'41'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 > x'4120202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 > x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x'42'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x'42'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 > x'4243444546'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 > x'4243444546'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x'20202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x'20202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 > x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 > x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 > x'20202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 > x'20202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x'41202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x'41202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 > x'4120'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 > x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 > x'422020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 > x'422020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 > x'42434445462020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 > x'42434445462020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 > x'4243444520202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 > x'4243444520202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1, c2 from charfbdtab where c1 > c2");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1, c2 from charfbdtab where c1 > c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <= x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <= x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x'2020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x'2020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <= x'41'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <= x'41'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x'4120202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <= x'42'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <= x'42'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x'4243444546'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x'4243444546'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <= x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <= x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <= x'20202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <= x'20202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x'20202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x'20202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <= x'412020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <= x'412020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x'4120'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 <= x'4220202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 <= x'4220202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x'424344454620202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x'424344454620202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 <= x'4243444520202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 <= x'4243444520202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1, c2 from charfbdtab where c1 <= c2");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1, c2 from charfbdtab where c1 <= c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 >= x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 >= x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x'2020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x'2020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 >= x'41'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 >= x'41'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x'4120202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x'4120202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 >= x'42'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 >= x'42'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x'4243444546'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x'4243444546'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 >= x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 >= x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 >= x'20202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 >= x'20202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x''");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x''");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x'20'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x'20'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x'20202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x'20202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 >= x'412020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 >= x'412020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x'4120'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x'4120'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 >= x'422020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 >= x'422020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x'42434445462020202020202020202020202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x'42434445462020202020202020202020202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 >= x'4243444520202020202020'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 >= x'4243444520202020202020'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1, c2 from charfbdtab where c1 >= c2");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1, c2 from charfbdtab where c1 >= c2");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c2 from charfbdtab where c2 = x'424344454646'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c2 from charfbdtab where c2 = x'424344454646'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
            this.rsGfxd = CharForBitDataPartitionTest.executeQueryOnGfxd("select c1 from charfbdtab where c1 = x'412020202020202041'");
            this.rsDerby = CharForBitDataPartitionTest.executeQueryOnDerby("select c1 from charfbdtab where c1 = x'412020202020202041'");
            this.compareResultSets(this.rsGfxd, this.rsDerby);
        }
        finally {
            if (this.rsGfxd != null) {
                this.rsGfxd.close();
            }
            if (this.rsDerby != null) {
                this.rsDerby.close();
            }
            CharForBitDataPartitionTest.executeUpdateOnGfxd("drop table charfbdtab");
            CharForBitDataPartitionTest.executeUpdateOnDerby("drop table charfbdtab");
        }
    }
}

