/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.net.BindException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UpdateStatementConstraintCheckTest
extends JdbcTestBase {
    private boolean callbackInvoked = false;
    private final int index = 0;

    public UpdateStatementConstraintCheckTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(UpdateStatementConstraintCheckTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForeignKeyCheckForRegionPutConvertibleStatement_SingleColumnForeignKey() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int) PARTITION BY COLUMN (sector_id1) " + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) " + this.getSuffix());
        s.execute("insert into instruments values (1,1,1)");
        s.execute("insert into Child values (1,1,1)");
        String query = "update Child set sector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        GemFireXDQueryObserver old = null;
        UpdateStatementConstraintCheckTest.addExpectedException(new Object[]{FunctionException.class, EntryNotFoundException.class});
        try {
            ps.executeUpdate();
            UpdateStatementConstraintCheckTest.fail("Update should not have occured as foreign key violation should occur");
        }
        catch (SQLException sqle) {
            try {
                UpdateStatementConstraintCheckTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
            }
            catch (Throwable throwable) {
                UpdateStatementConstraintCheckTest.removeExpectedException(new Object[]{FunctionException.class, EntryNotFoundException.class});
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                this.callbackInvoked = false;
                throw throwable;
            }
            UpdateStatementConstraintCheckTest.removeExpectedException(new Object[]{FunctionException.class, EntryNotFoundException.class});
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
        UpdateStatementConstraintCheckTest.removeExpectedException(new Object[]{FunctionException.class, EntryNotFoundException.class});
        if (old != null) {
            GemFireXDQueryObserverHolder.setInstance(old);
        }
        this.callbackInvoked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39995() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnectionWithRandomMcastPort();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int) PARTITION BY COLUMN (id1) " + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) " + this.getSuffix());
        s.execute("insert into instruments values (1,1,1)");
        s.execute("insert into Child values (1,1,1)");
        String query = "update Child set subsector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        GemFireXDQueryObserver old = null;
        try {
            ps.executeUpdate();
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOtherConstraintCheckForRegionPutConvertibleStatement_SingleColumn_Bug40017() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table Child ( id2 int primary key, sector_id2 int unique, subsector_id2 int  ) " + this.getSuffix());
        s.execute("insert into Child values (1,1,1)");
        s.execute("insert into Child values (2,2,2)");
        String query = "update Child set sector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        GemFireXDQueryObserver old = null;
        TestUtil.addExpectedException(EntryExistsException.class);
        try {
            ps.executeUpdate();
            UpdateStatementConstraintCheckTest.fail("Update should not have occured as unique constraint violation would occur");
        }
        catch (SQLException sqle) {
            UpdateStatementConstraintCheckTest.assertTrue((sqle.getMessage().indexOf("duplicate key value in a unique or primary key constraint") != -1 ? 1 : 0) != 0);
        }
        finally {
            TestUtil.removeExpectedException(EntryExistsException.class);
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoUniqueConstraintViolationForRegionPutConvertibleStatement_SingleColumn() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table Child ( id2 int primary key, sector_id2 int unique, subsector_id2 int  ) " + this.getSuffix());
        s.execute("insert into Child values (1,1,1)");
        s.execute("insert into Child values (2,2,2)");
        String query = "update Child set sector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 2);
        ps.setInt(2, 2);
        GemFireXDQueryObserver old = null;
        try {
            int n = ps.executeUpdate();
            UpdateStatementConstraintCheckTest.assertTrue((n == 1 ? 1 : 0) != 0);
        }
        catch (SQLException sqle) {
            UpdateStatementConstraintCheckTest.fail("Update should be allowed as the column is being updated to the existing value only");
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiColumnForeignKeyViolation_1_Bug39987() throws Exception {
        GemFireXDQueryObserver old = null;
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int , sector_id1 int, subsector_id1 int , primary key(id1,sector_id1)) PARTITION BY Primary key " + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (subsector_id2,sector_id2) references instruments (id1,sector_id1) ) partition by primary key " + this.getSuffix());
        s.execute("insert into instruments values (1,1,1)");
        s.execute("insert into instruments values (2,2,1)");
        s.execute("insert into Child values (1,1,1)");
        String query = "update Child set sector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        UpdateStatementConstraintCheckTest.addExpectedException(FunctionException.class);
        try {
            ps.executeUpdate();
            UpdateStatementConstraintCheckTest.fail("Update should have failed as it is violation of foreign key constraint");
        }
        catch (SQLException sqle) {
            UpdateStatementConstraintCheckTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
        }
        finally {
            UpdateStatementConstraintCheckTest.removeExpectedException(FunctionException.class);
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiColumnForeignKeyViolation_3_Bug39987() throws Exception {
        GemFireXDQueryObserver old = null;
        try {
            Connection conn = UpdateStatementConstraintCheckTest.getConnectionWithRandomMcastPort();
            Statement s = conn.createStatement();
            s.execute("create table INSTRUMENTS (id1 int , sector_id1 int, subsector_id1 int , primary key(id1,sector_id1)) PARTITION BY Primary key " + this.getSuffix());
            s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (subsector_id2,sector_id2) references instruments (id1,sector_id1) ) partition by primary key " + this.getSuffix());
            s.execute("insert into instruments values (1,1,1)");
            s.execute("insert into instruments values (2,2,1)");
            s.execute("insert into instruments values (1,2,1)");
            s.execute("insert into Child values (1,1,1)");
            String query = "update Child set sector_id2 = ? where id2 = ?";
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setInt(1, 2);
            ps.setInt(2, 1);
            ps.executeUpdate();
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiColumnForeignKeyViolation_2_Bug39987() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int , sector_id1 int, subsector_id1 int , primary key(id1,sector_id1)) PARTITION BY Primary key " + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (subsector_id2,sector_id2) references instruments (id1,sector_id1) ) partition by primary key" + this.getSuffix());
        s.execute("insert into instruments values (1,1,1)");
        s.execute("insert into instruments values (2,2,1)");
        s.execute("insert into instruments values (3,2,2)");
        s.execute("insert into instruments values (1,2,3)");
        s.execute("insert into Child values (1,1,1)");
        String query = "update Child set sector_id2 = ?, subsector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        ps.setInt(3, 1);
        GemFireXDQueryObserver old = null;
        try {
            ps.executeUpdate();
        }
        catch (SQLException sqle) {
            UpdateStatementConstraintCheckTest.fail("Update should have occured as foreign key violation is not the case");
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiColumnForeignKeyViolation_4_Bug39987() throws Exception {
        GemFireXDQueryObserver old = null;
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 varchar(5) , sector_id1 int, subsector_id1 int , primary key(id1,sector_id1)) PARTITION BY Primary key " + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 varchar(5), foreign key (subsector_id2,sector_id2) references instruments (id1,sector_id1) ) partition by primary key " + this.getSuffix());
        s.execute("insert into instruments values ('1',1,1)");
        s.execute("insert into instruments values ('2',2,1)");
        s.execute("insert into Child values (1,1,'1')");
        String query = "update Child set sector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        UpdateStatementConstraintCheckTest.addExpectedException(FunctionException.class);
        try {
            ps.executeUpdate();
            UpdateStatementConstraintCheckTest.fail("Update should have failed as it is violation of foreign key constraint");
        }
        catch (SQLException sqle) {
            UpdateStatementConstraintCheckTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
        }
        finally {
            UpdateStatementConstraintCheckTest.removeExpectedException(FunctionException.class);
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotNullConstraintForRegionPutConvertibleStatement_Bug40018() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int  ) " + this.getSuffix());
        s.execute("insert into Child values (1,1,1)");
        s.execute("insert into Child values (2,2,2)");
        String query = "update Child set sector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setNull(1, 4);
        ps.setInt(2, 2);
        GemFireXDQueryObserver old = null;
        try {
            ps.executeUpdate();
            UpdateStatementConstraintCheckTest.fail("Update should not  be allowed as the not null constraint check is violated");
        }
        catch (SQLException sqle) {
            UpdateStatementConstraintCheckTest.assertTrue((sqle.getMessage().indexOf("cannot accept a NULL value") != -1 ? 1 : 0) != 0);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoDoubleFKCheckForPutConvertibleStatement_SingleColumnForeignKey_Bug40000() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnectionWithRandomMcastPort();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int) PARTITION BY COLUMN (sector_id1) " + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) " + this.getSuffix());
        s.execute("insert into instruments values (1,1,1)");
        s.execute("insert into Child values (1,1,1)");
        String query = "update Child set sector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        final boolean[] regnLevelCheckInvoked = new boolean[]{false};
        GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void beforeForeignKeyConstraintCheckAtRegionLevel() {
                regnLevelCheckInvoked[0] = true;
            }
        });
        UpdateStatementConstraintCheckTest.addExpectedException(new Object[]{FunctionException.class, EntryNotFoundException.class});
        try {
            ps.executeUpdate();
            UpdateStatementConstraintCheckTest.fail("Update should not have occured as foreign key violation should occur");
        }
        catch (SQLException sqle) {
            try {
                UpdateStatementConstraintCheckTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
                UpdateStatementConstraintCheckTest.assertTrue((boolean)regnLevelCheckInvoked[0]);
            }
            catch (Throwable throwable) {
                UpdateStatementConstraintCheckTest.removeExpectedException(new Object[]{FunctionException.class, EntryNotFoundException.class});
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
                }
                this.callbackInvoked = false;
                throw throwable;
            }
            UpdateStatementConstraintCheckTest.removeExpectedException(new Object[]{FunctionException.class, EntryNotFoundException.class});
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            this.callbackInvoked = false;
        }
        UpdateStatementConstraintCheckTest.removeExpectedException(new Object[]{FunctionException.class, EntryNotFoundException.class});
        if (old != null) {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        this.callbackInvoked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testNoDoubleUniqueConstraintCheckForPutConvertibleStatement_Bug40000() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table Child ( id2 int primary key, sector_id2 int unique, subsector_id2 int  ) " + this.getSuffix());
        s.execute("insert into Child values (1,1,1)");
        s.execute("insert into Child values (2,2,2)");
        String query = "update Child set sector_id2 = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 3);
        ps.setInt(2, 2);
        final boolean[] regnLevelCheckInvoked = new boolean[]{false};
        GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void beforeUniqueConstraintCheckAtRegionLevel() {
                regnLevelCheckInvoked[0] = true;
            }
        });
        try {
            ps.executeUpdate();
            UpdateStatementConstraintCheckTest.assertTrue((boolean)regnLevelCheckInvoked[0]);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPartialConstraintCheckBehaviourForRegionPutStatement_Bug40000() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int , sector_id1 int, subsector_id1 int , primary key(id1,sector_id1)) PARTITION BY Primary key " + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, temp int unique , foreign key (subsector_id2,sector_id2) references instruments (id1,sector_id1)) partition by primary key  " + this.getSuffix());
        s.execute("insert into instruments values (1,1,1)");
        s.execute("insert into instruments values (2,2,1)");
        s.execute("insert into instruments values (1,2,1)");
        s.execute("insert into Child values (1,1,1,1)");
        final boolean[] regnLevelCheckInvoked = new boolean[]{false, false};
        GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void beforeUniqueConstraintCheckAtRegionLevel() {
                regnLevelCheckInvoked[0] = true;
            }

            public void beforeForeignKeyConstraintCheckAtRegionLevel() {
                regnLevelCheckInvoked[1] = true;
            }

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                try {
                    TestCase.assertTrue((boolean)qInfo.isPrimaryKeyBased());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestUtil.fail(e.toString());
                }
            }
        });
        String query = "update Child set sector_id2 = ? , temp = ? where id2 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 2);
        ps.setInt(2, 3);
        ps.setInt(3, 1);
        try {
            ps.executeUpdate();
            UpdateStatementConstraintCheckTest.assertTrue((boolean)regnLevelCheckInvoked[1]);
        }
        catch (SQLException sqle) {
            UpdateStatementConstraintCheckTest.fail("Update should have occured as foreign key violation is not the case");
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            this.callbackInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonRegionPutDueToCheckConstraint() throws Exception {
        Connection conn = UpdateStatementConstraintCheckTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int , sector_id1 int, subsector_id1 int , primary key(id1),constraint myconstraint check (subsector_id1 in (1, 2,3,4))) PARTITION BY Primary key " + this.getSuffix());
        s.execute("insert into instruments values (1,1,1)");
        s.execute("insert into instruments values (2,2,2)");
        s.execute("insert into instruments values (3,2,3)");
        GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                UpdateStatementConstraintCheckTest.this.callbackInvoked = true;
                try {
                    TestCase.assertFalse((boolean)qInfo.isPrimaryKeyBased());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestUtil.fail(e.toString());
                }
            }

            public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                TestUtil.fail("Activation used should be of Derby.");
            }
        });
        String query = "update instruments set subsector_id1 = ?  where id1 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 4);
        ps.setInt(2, 3);
        try {
            int n = ps.executeUpdate();
            UpdateStatementConstraintCheckTest.assertEquals((int)1, (int)n);
            UpdateStatementConstraintCheckTest.assertTrue((boolean)this.callbackInvoked);
        }
        catch (SQLException sqle) {
            UpdateStatementConstraintCheckTest.fail("Update should have occured");
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            this.callbackInvoked = false;
        }
    }

    private static Connection getConnectionWithRandomMcastPort() throws SQLException {
        Properties props = new Properties();
        block2: while (true) {
            int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            props.setProperty("mcast-port", String.valueOf(mcastPort));
            try {
                return UpdateStatementConstraintCheckTest.getConnection(props);
            }
            catch (SQLException ex) {
                if ("XJ040".equals(ex.getSQLState())) {
                    Throwable t = ex;
                    while ((t = t.getCause()) != null) {
                        if (!(t instanceof BindException)) continue;
                        continue block2;
                    }
                }
                throw ex;
            }
            break;
        }
    }

    protected String getSuffix() {
        return " ";
    }
}

