/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.UpdateQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UpdateQueryInfoInternalsTest
extends JdbcTestBase {
    private boolean callbackInvoked = false;

    public UpdateQueryInfoInternalsTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(UpdateQueryInfoInternalsTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicUpdate() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Update  TESTTABLE set  ADDRESS = 'your foot', DESCRIPTION = 'myfoot'  where ID = 1 ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof UpdateQueryInfo) {
                        UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                    }
                }
            });
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604')");
            Statement s2 = conn.createStatement();
            try {
                s2.executeUpdate(query);
                ResultSet rs = s2.executeQuery("Select * from TESTTABLE where ID = 1");
                UpdateQueryInfoInternalsTest.assertTrue((boolean)rs.next());
                UpdateQueryInfoInternalsTest.assertEquals((String)"myfoot", (String)rs.getString(2));
                UpdateQueryInfoInternalsTest.assertEquals((String)"your foot", (String)rs.getString(3));
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParameterizedRegionPutConvertibleUpdate_Bug39652() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), type int)");
        String query = "Update  TESTTABLE set  type = ?  where ID = 1 ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof UpdateQueryInfo) {
                        UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                    }
                }
            });
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604',1)");
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setInt(1, 2);
            try {
                int n = ps.executeUpdate();
                UpdateQueryInfoInternalsTest.assertEquals((int)n, (int)1);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateHavingParameterizedExpression() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), type int)");
        String query = "Update  TESTTABLE set  type = type +?  where ID = ? ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof UpdateQueryInfo) {
                        UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                    }
                }
            });
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604',1)");
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setInt(1, 1);
            ps.setInt(2, 1);
            try {
                int n = ps.executeUpdate();
                UpdateQueryInfoInternalsTest.assertEquals((int)n, (int)1);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateWithExpressionIsNotPrimaryKeyBased() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), type int)");
        String query = "Update  TESTTABLE set  type = type + 1  where ID = 5 ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof UpdateQueryInfo) {
                        UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                        UpdateQueryInfo uqi = (UpdateQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)uqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)uqi.isDynamic());
                        TestCase.assertFalse((boolean)uqi.isPreparedStatementQuery());
                    }
                }
            });
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604',1)");
            s.executeUpdate(query);
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39921Behaviour() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int  , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), type int)");
        String query = "Update  TESTTABLE set  type = type + 1  where ID = 5 ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof UpdateQueryInfo) {
                        UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                        UpdateQueryInfo uqi = (UpdateQueryInfo)qInfo;
                        PartitionedRegion rgn = (PartitionedRegion)uqi.getRegion();
                        GfxdPartitionByExpressionResolver defRslvr = (GfxdPartitionByExpressionResolver)rgn.getPartitionResolver();
                        TestCase.assertFalse((boolean)defRslvr.isUsedInPartitioning("nocol"));
                    }
                }
            });
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604',1)");
            s.executeUpdate(query);
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void testBug39973() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id varchar(20) not null primary key, sector_id int, subsector_id int) PARTITION BY COLUMN (sector_id)");
        String query = "update INSTRUMENTS set subsector_id = ? where id = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 1);
        ps.setString(2, "ONE");
        int n = ps.executeUpdate();
        UpdateQueryInfoInternalsTest.assertEquals((int)0, (int)n);
    }

    public void testBug39974() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id varchar(20) not null primary key, sector_id int, subsector_id int) PARTITION BY RANGE (sector_id) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 )");
        String query = "update INSTRUMENTS set subsector_id = ? where id = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 1);
        ps.setString(2, "ONE");
        int n = ps.executeUpdate();
        UpdateQueryInfoInternalsTest.assertEquals((int)0, (int)n);
    }

    public void testBug39975() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id varchar(20) not null primary key, sector_id int not null, subsector_id int) PARTITION BY LIST (sector_id) ( VALUES (20, 40), VALUES (50, 60) )");
        String query = "update INSTRUMENTS set subsector_id = ? where id = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 1);
        ps.setString(2, "ONE");
        int n = ps.executeUpdate();
        UpdateQueryInfoInternalsTest.assertEquals((int)0, (int)n);
    }

    public void testBug39976() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id varchar(20) not null primary key, sector_id int, subsector_id int)");
        String query = "update INSTRUMENTS set subsector_id = ? where id = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 1);
        ps.setString(2, "ONE");
        int n = ps.executeUpdate();
        UpdateQueryInfoInternalsTest.assertEquals((int)0, (int)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39982() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id varchar(20) not null primary key, sector_id int, subsector_id int) PARTITION BY COLUMN (id) ");
        String query = "update INSTRUMENTS set subsector_id = ? where id = ?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                    UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                }
            });
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setInt(1, 1);
            ps.setString(2, "ONE");
            int n = ps.executeUpdate();
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            UpdateQueryInfoInternalsTest.assertEquals((int)n, (int)0);
            this.callbackInvoked = false;
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateHavingParameterizedExpression_Bug39646_1() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), type int)");
        String query = "Update TESTTABLE set type = type + ? where ID >= ? AND ID < ?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof UpdateQueryInfo) {
                        UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                        QueryInfoContext qic = ((UpdateQueryInfo)qInfo).qic;
                        TestCase.assertEquals((int)3, (int)qic.getParamerCount());
                    }
                }
            });
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604',1)");
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setInt(1, 1);
            ps.setInt(2, 1);
            ps.setInt(3, 2);
            try {
                int n = ps.executeUpdate();
                UpdateQueryInfoInternalsTest.assertEquals((int)n, (int)1);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug4002() throws Exception {
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.customers (cid int not null, cust_name varchar(100), since int, addr varchar(100), tid int, primary key (cid))");
        s.execute("insert into trade.customers values (1, 'XXXX1', 1, 'BEAV1', 1)");
        String query = "update trade.customers set since=2 where cid=1";
        Statement s1 = conn.createStatement();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                    UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                }
            });
            s1.executeUpdate(query);
            ResultSet rs = s.executeQuery("select cust_name,cid,since,addr,tid from trade.customers where cid=1 ");
            UpdateQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            UpdateQueryInfoInternalsTest.assertEquals((String)"XXXX1", (String)rs.getString(1));
            UpdateQueryInfoInternalsTest.assertEquals((int)1, (int)rs.getInt(2));
            UpdateQueryInfoInternalsTest.assertEquals((int)2, (int)rs.getInt(3));
            UpdateQueryInfoInternalsTest.assertEquals((String)"BEAV1", (String)rs.getString(4));
            UpdateQueryInfoInternalsTest.assertEquals((int)1, (int)rs.getInt(5));
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRangeQueryInfoWithStatementCaching() throws Exception {
        try {
            String createTable = "create table TESTTABLE (ID bigint primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024)) ";
            Connection conn = UpdateQueryInfoInternalsTest.getConnection();
            Statement s = conn.createStatement();
            s.execute(createTable);
            for (int i = 0; i < 10; ++i) {
                s.execute("insert into TESTTABLE values(" + i + ", 'First', 'J 604')");
            }
            s.executeUpdate("update TestTable set Description = 'Third' where ID > 5 ");
            s.executeUpdate("update TestTable set Description = 'Third' where ID > 4 ");
        }
        finally {
            try {
                Connection conn = UpdateQueryInfoInternalsTest.getConnection();
                Statement s = conn.createStatement();
                s.execute("drop table TESTTABLE");
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug43700ForUpdate() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        String subquery = "select cid from trade.portfolio where tid =? and sid >? and sid < ?";
        String dml = "update trade.networth set loanlimit = loanlimit*100 where tid = ? and cid IN (select cid from trade.portfolio where tid =? and sid >? and sid < ?)";
        Connection conn = UpdateQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table trade.networth (cid int not null,    loanlimit int,  tid int, constraint netw_pk primary key (cid))  partition by (tid) ");
        s.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, tid int, constraint portf_pk primary key (cid, sid))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))");
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof UpdateQueryInfo));
                    UpdateQueryInfo uqi = (UpdateQueryInfo)qInfo;
                    TestCase.assertFalse((boolean)uqi.hasCorrelatedSubQuery());
                    TestCase.assertEquals((int)uqi.getSubqueryInfoList().size(), (int)1);
                    SubQueryInfo subQi = (SubQueryInfo)uqi.getSubqueryInfoList().iterator().next();
                    TestCase.assertEquals((String)subQi.getSubqueryString(), (String)"select cid from trade.portfolio where tid =? and sid >? and sid < ?");
                    TestCase.assertTrue((boolean)uqi.isRemoteGfxdSubActivationNeeded());
                    TestCase.assertFalse((boolean)uqi.isSubqueryFlatteningAllowed());
                }
            });
            PreparedStatement ps = conn.prepareStatement(dml);
            UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug42428ForUpdate() throws Exception {
        block4: {
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
            Connection conn = UpdateQueryInfoInternalsTest.getConnection();
            Statement s = conn.createStatement();
            GemFireXDQueryObserver old = null;
            String subquery = "select ID2 from TESTTABLE2";
            String dml = "Update TESTTABLE1 set DESCRIPTION1 = 'no description' where ID1 IN (select ID2 from TESTTABLE2) ";
            try {
                String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ";
                String table2 = "create table TESTTABLE2 (ID int not null,ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID) ) ";
                s.execute(table1 + " replicate");
                s.execute(table2);
                String insert = "Insert into  TESTTABLE1 values(1,'desc1_1','add1_1')";
                s.execute(insert);
                for (int i = 1; i < 3; ++i) {
                    insert = "Insert into  TESTTABLE2 values(" + i + ",1,'desc2_" + "', 'add2_')";
                    s.execute(insert);
                }
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private int index = 0;

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (!qInfo.isSelect()) {
                            UpdateQueryInfoInternalsTest.this.callbackInvoked = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof UpdateQueryInfo));
                            UpdateQueryInfo uqi = (UpdateQueryInfo)qInfo;
                            TestCase.assertFalse((boolean)uqi.hasCorrelatedSubQuery());
                            TestCase.assertEquals((int)uqi.getSubqueryInfoList().size(), (int)1);
                            SubQueryInfo subQi = (SubQueryInfo)uqi.getSubqueryInfoList().iterator().next();
                            TestCase.assertEquals((String)subQi.getSubqueryString(), (String)"select ID2 from TESTTABLE2");
                            TestCase.assertTrue((boolean)uqi.isRemoteGfxdSubActivationNeeded());
                            TestCase.assertFalse((boolean)uqi.isSubqueryFlatteningAllowed());
                        }
                    }
                });
                s.executeUpdate(dml);
                UpdateQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
                if (old == null) break block4;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
                SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
    }

    public void createTableWithPrimaryKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createTableWithCompositeKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100), Primary Key (id, cust_name))");
        s.close();
    }

    public void createTable(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createTableWithThreeCompositeKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100), Primary Key (id, cust_name,vol))");
        s.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.callbackInvoked = false;
        super.tearDown();
    }
}

