/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class StatementTest
extends JdbcTestBase {
    private boolean callbackInvoked = false;
    private int index = 0;

    public StatementTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(StatementTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionGetMultipleTimesWithSameStmnt() throws SQLException {
        Connection conn = StatementTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        String query = "Select * from orders where id =8";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    StatementTest.this.callbackInvoked = true;
                    ++StatementTest.this.index;
                }
            });
            conn = StatementTest.getConnection();
            int numExecution = 5;
            Statement s = conn.createStatement();
            for (int i = 0; i < 5; ++i) {
                try {
                    s.executeQuery(query);
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
                }
            }
            StatementTest.assertTrue((boolean)this.callbackInvoked);
            StatementTest.assertEquals((int)1, (int)this.index);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42447() throws SQLException {
        Properties props = new Properties();
        props.put("host-data", "false");
        Connection conn = StatementTest.getConnection(props);
        Statement s = conn.createStatement();
        try {
            s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100)) replicate");
            StatementTest.fail("Test should fail because of insufficient data stores");
        }
        catch (SQLException sqle) {
            if (!"X0Z08".equals(sqle.getSQLState())) {
                throw sqle;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40595() throws SQLException {
        Connection conn = StatementTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s = conn.createStatement();
        String query = "Select * from orders where id =8";
        final boolean[] usedGfxdActivn = new boolean[]{false};
        GemFireXDQueryObserver old = null;
        try {
            ResultSet rs;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                    usedGfxdActivn[0] = true;
                }
            });
            PreparedStatement ps = conn.prepareStatement(query);
            try {
                rs = ps.executeQuery();
                rs.next();
                rs.close();
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            StatementTest.assertTrue((boolean)usedGfxdActivn[0]);
            usedGfxdActivn[0] = false;
            s.execute("drop table orders");
            s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
            try {
                rs = ps.executeQuery();
                rs.next();
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e);
            }
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionGetMultipleTimesWithDiffStmnt() throws SQLException {
        Connection conn = StatementTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        String query = "Select * from orders where id =8";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                }

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    StatementTest.this.callbackInvoked = true;
                    ++StatementTest.this.index;
                }
            });
            int numExecution = 5;
            for (int i = 0; i < 5; ++i) {
                try {
                    conn = StatementTest.getConnection();
                    Statement s = conn.createStatement();
                    s.executeQuery(query);
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
                }
            }
            StatementTest.assertTrue((boolean)this.callbackInvoked);
            StatementTest.assertEquals((int)1, (int)this.index);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void createTableWithPrimaryKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createTableWithCompositeKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100), Primary Key (id, cust_name))");
        s.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.callbackInvoked = false;
        this.index = 0;
        super.tearDown();
    }
}

