/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AndJunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.CompositeDynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ConstantConditionsWrapperQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ConstantQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.InQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.JunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.OrJunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterizedConditionsWrapperQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.PrimaryDynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RangeQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.reflect.GemFireActivationClass;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireSelectActivation;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedDatabaseMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class SelectQueryInfoInternalsTest
extends JdbcTestBase {
    private boolean callbackInvoked = false;

    public SelectQueryInfoInternalsTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(SelectQueryInfoInternalsTest.class));
    }

    public void testWhereClauseWithNoIndex() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        this.createTable(conn);
        this.whereClauseTest();
    }

    public void testWhereClauseWithPrimaryKey() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        this.whereClauseTest();
    }

    public void testWhereClauseWithCompositeKey() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        this.createTableWithCompositeKey(conn);
        this.whereClauseTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexProjectionAttributes() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        this.createTable(conn);
        String[] queries = new String[]{"select max(id), (select id from orders t2) from orders"};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                    ++this.index;
                }
            });
            Statement s = conn.createStatement();
            for (int i = 0; i < queries.length; ++i) {
                try {
                    s.executeQuery(queries[i]);
                    continue;
                }
                catch (SQLException e) {
                    throw new Exception(" Exception in executing query = " + queries[i], e);
                }
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void whereClauseTest() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        String[] queries = new String[]{"Select * from orders where id =8", "Select * from orders where id =8 and cust_name = 'asif'", "Select * from orders where id =8 and cust_name = 'asif' and  vol > 9 "};
        final boolean[] isJunctionTypeWhereClause = new boolean[]{false, true, true};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                    AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                    if (isJunctionTypeWhereClause[this.index]) {
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        TestCase.assertEquals((int)((JunctionQueryInfo)acqi).getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertTrue((boolean)SelectQueryInfoInternalsTest.this.validateJunctionQueryInfo(jqi, this.index));
                    } else {
                        TestCase.assertTrue((boolean)(acqi instanceof ComparisonQueryInfo));
                        ComparisonQueryInfo cqi = (ComparisonQueryInfo)acqi;
                        TestCase.assertTrue((boolean)SelectQueryInfoInternalsTest.this.validateComparisonQueryInfo(cqi, this.index));
                    }
                    ++this.index;
                }
            });
            Statement s = conn.createStatement();
            for (int i = 0; i < queries.length; ++i) {
                s.executeQuery(queries[i]);
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testWhereClauseWith3CompositeKey() throws Exception {
        block6: {
            System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            Connection conn = SelectQueryInfoInternalsTest.getConnection();
            SelectQueryInfoInternalsTest.createTableWithThreeCompositeKey(conn);
            String[] queries = new String[]{"Select * from orders where vol = 9  and id = 8 and  cust_name = 'asif' "};
            final boolean[] isGetConvertible = new boolean[]{true};
            final boolean[] usedGemfireActivation = new boolean[]{false};
            Region tableRegion = Misc.getRegionForTable((String)(SelectQueryInfoInternalsTest.getCurrentDefaultSchemaName() + ".orders".toUpperCase()), (boolean)true);
            final Object[] pks = new Object[]{new CompactCompositeRegionKey(new DataValueDescriptor[]{new SQLInteger(8), new SQLVarchar("asif"), new SQLInteger(9)}, ((GemFireContainer)tableRegion.getUserAttribute()).getExtraTableInfo())};
            GemFireXDQueryObserver old = null;
            try {
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private int index = 0;

                    public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                        usedGemfireActivation[0] = true;
                    }

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                        try {
                            TestCase.assertTrue((qInfo.isPrimaryKeyBased() == isGetConvertible[this.index] ? 1 : 0) != 0);
                            if (qInfo.isPrimaryKeyBased()) {
                                RegionKey actual = (RegionKey)qInfo.getPrimaryKey();
                                RegionKey expected = (RegionKey)pks[this.index];
                                TestCase.assertEquals((Object)expected, (Object)actual);
                            }
                        }
                        catch (StandardException e) {
                            TestUtil.fail("Test failed because of exception=" + (Object)((Object)e));
                        }
                        ++this.index;
                    }
                });
                Statement s = conn.createStatement();
                for (int i = 0; i < queries.length; ++i) {
                    try {
                        s.executeQuery(queries[i]);
                        SelectQueryInfoInternalsTest.assertTrue((boolean)usedGemfireActivation[i]);
                        continue;
                    }
                    catch (SQLException e) {
                        throw new SQLException(e.toString() + " Exception in executing query = " + queries[i], e.getSQLState());
                    }
                }
                SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
                if (old == null) break block6;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testANDWhereClauseMultipleFieldsNoPrimaryKey() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null  , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query1 = "Select * from TESTTABLE where ID = 1 and DESCRIPTION = 'asif' and ADDRESS = 'asif'";
        String query2 = "Select * from TESTTABLE where ID = 1 and ADDRESS = 'asif' and DESCRIPTION = 'asif'";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)3);
                    }
                }
            });
            try {
                s.executeQuery(query1);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query1, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604')");
            Statement s2 = conn.createStatement();
            try {
                s2.executeQuery(query2);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query2, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testANDWhereClauseMultipleFieldsNoPrimaryKeyWithPrepStmnt() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query1 = "Select * from TESTTABLE where ID = ? and DESCRIPTION = ? and ADDRESS = ?";
        String query2 = "Select * from TESTTABLE where ID = ? and ADDRESS = ? and DESCRIPTION = ?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)3);
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                    }
                }
            });
            conn.prepareStatement(query1);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604')");
            conn.prepareStatement(query2);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testANDWhereClauseMultipleFieldsSinglePrimaryKey() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query1 = "Select * from TESTTABLE where ID = 1 and DESCRIPTION = 'asif' and ADDRESS = 'asif'";
        String query2 = "Select * from TESTTABLE where ADDRESS = 'asif' and DESCRIPTION = 'asif' and ID = 1";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)3);
                    }
                }
            });
            try {
                s.executeQuery(query1);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query1, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604')");
            Statement s2 = conn.createStatement();
            try {
                s2.executeQuery(query2);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query2, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testANDWhereClauseMultipleFieldsSinglePrimaryKeyUsingPrepStmnt() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query1 = "Select * from TESTTABLE where ID = ? and DESCRIPTION = ? and ADDRESS = ?";
        String query2 = "Select * from TESTTABLE where ID = ? and ADDRESS = ? and DESCRIPTION = ?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)3);
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                    }
                }
            });
            conn.prepareStatement(query1);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604')");
            conn.prepareStatement(query2);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testANDWhereClauseMultipleFieldsWithOneFieldIndexed() throws SQLException {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        s.execute("create index indx on TESTTABLE (ID)");
        String query1 = "Select * from TESTTABLE where ID = 1 and DESCRIPTION = 'asif' and ADDRESS = 'asif'";
        String query2 = "Select * from TESTTABLE where ID = 1 and ADDRESS = 'asif' and DESCRIPTION = 'asif'";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)3);
                    }
                }
            });
            s.executeQuery(query1);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604')");
            Statement s2 = conn.createStatement();
            s2.executeQuery(query2);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testANDWhereClauseMultipleFieldsWithOneFieldIndexedUsingPrepStmnt() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        s.execute("create index indx on TESTTABLE (ID)");
        String query1 = "Select * from TESTTABLE where ID = ? and DESCRIPTION = ? and ADDRESS = ?";
        String query2 = "Select * from TESTTABLE where ID = ? and ADDRESS = ? and DESCRIPTION = ?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)3);
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                    }
                }
            });
            conn.prepareStatement(query1);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604')");
            conn.prepareStatement(query2);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void testBug() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement st = conn.createStatement();
        String schemaScript = TestUtil.getResourcesDir() + "/lib/amexSchema.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{schemaScript}, (boolean)false, (Logger)SelectQueryInfoInternalsTest.getLogger(), null, null, (boolean)false);
        String query = "SELECT * FROM FLAT_FILE as FLAT_FILE_AND_MR WHERE ( ('' = '')   AND (FLAT_FILE_AND_MR.ACTIVE = 1.00)   AND ('Table' = 'Table')  AND (1 = 1)   AND (CAST(FLAT_FILE_AND_MR.MR_ACTIVE_IND AS CHAR(23)) = '1.00')   AND (((FLAT_FILE_AND_MR.MR_REDEMPTION_REDEEMED_PTS >= 0)  AND (FLAT_FILE_AND_MR.MR_REDEMPTION_REDEEMED_PTS <= 52172000)) OR (FLAT_FILE_AND_MR.MR_REDEMPTION_REDEEMED_PTS IS NULL)) )";
        st.executeQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testORWhereClauseMultipleFieldsNoPrimaryKey() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null  , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query1 = "Select * from TESTTABLE where ID = 1 OR DESCRIPTION = 'asif' OR ADDRESS = 'asif'";
        String query2 = "Select * from TESTTABLE where ID = 1 OR ADDRESS = 'asif' OR DESCRIPTION = 'asif'";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)2);
                        TestCase.assertTrue((boolean)(jqi instanceof OrJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)3);
                    }
                }
            });
            try {
                s.executeQuery(query1);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(e.toString() + " Exception in executing query = " + query1, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
            s.executeUpdate("insert into TESTTABLE values (1, 'First', 'J 604')");
            Statement s2 = conn.createStatement();
            try {
                s2.executeQuery(query2);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query2, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testORWhereClauseMultipleFieldsNoPrimaryKeyAsPreparedStatement() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID = ?  OR DESCRIPTION = ?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)2);
                        TestCase.assertTrue((boolean)(jqi instanceof OrJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)2);
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39326() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.customers (tid int not null  , cid int , since date , addr varchar(1024) , cust_name varchar(1024) )");
        String query = "select since, addr, cust_name from trade.customers where (tid<? or cid <=?) and since >?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ComparisonQueryInfo cqi = (ComparisonQueryInfo)jqi.getOperands().get(0);
                        QueryInfo[] ops = cqi.getOperands();
                        ColumnQueryInfo colQI = ops[0] instanceof ColumnQueryInfo ? (ColumnQueryInfo)ops[0] : (ColumnQueryInfo)ops[1];
                        TestCase.assertEquals((String)colQI.getExposedName().toLowerCase(), (String)"since");
                        JunctionQueryInfo jqi1 = jqi.children[0];
                        TestCase.assertEquals((int)jqi1.getJunctionType(), (int)2);
                        TestCase.assertTrue((boolean)(jqi1 instanceof OrJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi1.getOperands().size(), (int)2);
                        for (int i = 0; i < 2; ++i) {
                            ComparisonQueryInfo cqi1 = (ComparisonQueryInfo)jqi1.getOperands().get(i);
                            QueryInfo[] operands = cqi1.getOperands();
                            ColumnQueryInfo colQI1 = operands[0] instanceof ColumnQueryInfo ? (ColumnQueryInfo)operands[0] : (ColumnQueryInfo)operands[1];
                            TestCase.assertTrue((colQI1.getExposedName().toLowerCase().equals("tid") || colQI1.getExposedName().toLowerCase().equals("cid") ? 1 : 0) != 0);
                        }
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            this.callbackInvoked = false;
            query = "select addr, since, cust_name from trade.customers where cid >? or since <?";
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                        JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)2);
                        TestCase.assertTrue((boolean)(jqi instanceof OrJunctionQueryInfo));
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)2);
                        for (int i = 0; i < 2; ++i) {
                            ComparisonQueryInfo cqi1 = (ComparisonQueryInfo)jqi.getOperands().get(i);
                            QueryInfo[] operands = cqi1.getOperands();
                            ColumnQueryInfo colQI1 = operands[0] instanceof ColumnQueryInfo ? (ColumnQueryInfo)operands[0] : (ColumnQueryInfo)operands[1];
                            TestCase.assertTrue((colQI1.getExposedName().toLowerCase().equals("cid") || colQI1.getExposedName().toLowerCase().equals("since") ? 1 : 0) != 0);
                        }
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39290() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        String query = "select type, id, name from t1 where id = ?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        ColumnQueryInfo[] cqis = sqi.getProjectionColumnQueryInfo();
                        TestCase.assertEquals((int)cqis[0].getActualColumnPosition(), (int)3);
                        TestCase.assertEquals((int)cqis[1].getActualColumnPosition(), (int)1);
                        TestCase.assertEquals((int)cqis[2].getActualColumnPosition(), (int)2);
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINWithPrimaryKeyAsSingleParamter() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select type, id, name from t1 where id IN (?)";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)1);
                        TestCase.assertFalse((boolean)(sqi.getWhereClause() instanceof InQueryInfo));
                        TestCase.assertTrue((boolean)(sqi.getPrimaryKey() instanceof PrimaryDynamicKey));
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            java.sql.ResultSet rs = ps1.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(2), (int)1);
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)2);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(3), (String)"asif");
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINWithPrimaryKeyAsSingleFieldConstant() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select type, id, name from t1 where id IN (1)";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertFalse((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)0);
                        TestCase.assertFalse((boolean)(sqi.getWhereClause() instanceof InQueryInfo));
                        try {
                            TestCase.assertEquals((Object)sqi.getPrimaryKey(), (Object)TestUtil.getGemFireKey(1, sqi.getRegion()));
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            java.sql.ResultSet rs = ps1.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(2), (int)1);
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)2);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(3), (String)"asif");
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINWithMultipleParameters() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                        TestCase.assertTrue((boolean)(sqi.getWhereClause() instanceof InQueryInfo));
                        InQueryInfo iqi = (InQueryInfo)sqi.getWhereClause();
                        QueryInfo[] operands = iqi.getOperands();
                        TestCase.assertEquals((int)operands.length, (int)4);
                        TestCase.assertTrue((boolean)(operands[0] instanceof ColumnQueryInfo));
                        for (int i = 1; i < 4; ++i) {
                            TestCase.assertTrue((boolean)(operands[i] instanceof ParameterQueryInfo));
                        }
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)pks.length, (int)3);
                        for (int i = 0; i < pks.length; ++i) {
                            TestCase.assertTrue((boolean)(pks[i] instanceof PrimaryDynamicKey));
                        }
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            java.sql.ResultSet rs = ps1.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(2), (int)1);
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)2);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(3), (String)"asif");
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINWithConstantAndParameterizedFields() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select type, id, name from t1 where id IN (?,?,3,4)";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        int i;
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)2);
                        TestCase.assertTrue((boolean)(sqi.getWhereClause() instanceof InQueryInfo));
                        InQueryInfo iqi = (InQueryInfo)sqi.getWhereClause();
                        QueryInfo[] operands = iqi.getOperands();
                        TestCase.assertEquals((int)operands.length, (int)5);
                        TestCase.assertTrue((boolean)(operands[0] instanceof ColumnQueryInfo));
                        for (i = 1; i < 3; ++i) {
                            TestCase.assertTrue((boolean)(operands[i] instanceof ParameterQueryInfo));
                        }
                        for (i = 3; i < 5; ++i) {
                            TestCase.assertTrue((boolean)(operands[i] instanceof ConstantQueryInfo));
                        }
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)pks.length, (int)4);
                        for (int i2 = 0; i2 < pks.length; ++i2) {
                            if (i2 < 2) {
                                TestCase.assertTrue((boolean)(pks[i2] instanceof PrimaryDynamicKey));
                                continue;
                            }
                            TestCase.assertTrue((boolean)(pks[i2] instanceof RegionKey));
                        }
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            java.sql.ResultSet rs = ps1.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(2), (int)1);
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)2);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(3), (String)"asif");
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINWithMultipleConstantFields() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10))");
        s.execute("Insert into  t1 values(1, 'asif')");
        GfxdCallbacksTest.addLoader(null, "t1", "com.pivotal.gemfirexd.jdbc.TestRowLoader", "");
        String query = "select id, name from t1 where id IN (1, 2, 1000, 2000)";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertFalse((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)0);
                        TestCase.assertTrue((boolean)(sqi.getWhereClause() instanceof InQueryInfo));
                        InQueryInfo iqi = (InQueryInfo)sqi.getWhereClause();
                        QueryInfo[] operands = iqi.getOperands();
                        TestCase.assertEquals((int)5, (int)operands.length);
                        TestCase.assertTrue((boolean)(operands[0] instanceof ColumnQueryInfo));
                        for (int i = 1; i < 5; ++i) {
                            TestCase.assertTrue((boolean)(operands[i] instanceof ConstantQueryInfo));
                        }
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)4, (int)pks.length);
                        for (int i = 0; i < pks.length; ++i) {
                            TestCase.assertTrue((boolean)(pks[i] instanceof RegionKey));
                        }
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            java.sql.ResultSet rs = ps1.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)1, (int)rs.getInt(1));
            SelectQueryInfoInternalsTest.assertEquals((String)"asif", (String)rs.getString(2));
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)1000, (int)rs.getInt(1));
            SelectQueryInfoInternalsTest.assertEquals((String)"Mark Black", (String)rs.getString(2));
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRangeQueryInfoGeneration_1() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID > 1  AND ID < 8";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        RangeQueryInfo rqi = (RangeQueryInfo)jqi.getOperands().get(0);
                        TestCase.assertEquals((Object)rqi.getLowerBound(), (Object)new SQLInteger(1));
                        TestCase.assertEquals((Object)rqi.getUpperBound(), (Object)new SQLInteger(8));
                        TestCase.assertEquals((int)rqi.getUpperBoundOperator(), (int)5);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)3);
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRangeQueryInfoGeneration_2() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID > 1  AND ID < 8 AND ID >=4";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        RangeQueryInfo rqi = (RangeQueryInfo)jqi.getOperands().get(0);
                        TestCase.assertEquals((Object)rqi.getLowerBound(), (Object)new SQLInteger(4));
                        TestCase.assertEquals((Object)rqi.getUpperBound(), (Object)new SQLInteger(8));
                        TestCase.assertEquals((int)rqi.getUpperBoundOperator(), (int)5);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)4);
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRangeQueryInfoGeneration_3() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null  , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID > 1  AND ID < 8 AND ID >=4  AND  ID <=7";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        RangeQueryInfo rqi = (RangeQueryInfo)jqi.getOperands().get(0);
                        TestCase.assertEquals((Object)rqi.getLowerBound(), (Object)new SQLInteger(4));
                        TestCase.assertEquals((Object)rqi.getUpperBound(), (Object)new SQLInteger(7));
                        TestCase.assertEquals((int)rqi.getUpperBoundOperator(), (int)6);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)4);
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRangeQueryInfoGeneration_4() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID > 1  AND ID < 8 AND ID >=4  AND  ID <=7 AND ID >12";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ConstantConditionsWrapperQueryInfo ccwqi = (ConstantConditionsWrapperQueryInfo)jqi.getOperands().get(0);
                        List operands = ccwqi.getOperands();
                        TestCase.assertEquals((int)operands.size(), (int)2);
                        Iterator itr = operands.iterator();
                        AbstractConditionQueryInfo condition1 = (AbstractConditionQueryInfo)itr.next();
                        AbstractConditionQueryInfo condition2 = (AbstractConditionQueryInfo)itr.next();
                        ComparisonQueryInfo cqi = condition1 instanceof ComparisonQueryInfo ? (ComparisonQueryInfo)condition1 : (ComparisonQueryInfo)condition2;
                        RangeQueryInfo rqi = condition1 instanceof RangeQueryInfo ? (RangeQueryInfo)condition1 : (RangeQueryInfo)condition2;
                        TestCase.assertEquals((Object)rqi.getLowerBound(), (Object)new SQLInteger(4));
                        TestCase.assertEquals((Object)rqi.getUpperBound(), (Object)new SQLInteger(7));
                        TestCase.assertEquals((int)rqi.getUpperBoundOperator(), (int)6);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)4);
                        try {
                            TestCase.assertEquals((Object)((ValueQueryInfo)cqi.rightOperand).evaluateToGetDataValueDescriptor(null), (Object)new SQLInteger(12));
                        }
                        catch (StandardException se) {
                            TestUtil.fail("test  failed because of exception=" + (Object)((Object)se));
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRangeQueryInfoGeneration_5() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID > 1  AND ID < 8 AND ID >=4  AND  ID <=7 AND ID < -2 AND ID > 12";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ConstantConditionsWrapperQueryInfo ccwqi = (ConstantConditionsWrapperQueryInfo)jqi.getOperands().get(0);
                        List operands = ccwqi.getOperands();
                        TestCase.assertEquals((int)operands.size(), (int)3);
                        Iterator itr = operands.iterator();
                        AbstractConditionQueryInfo condition1 = (AbstractConditionQueryInfo)itr.next();
                        AbstractConditionQueryInfo condition2 = (AbstractConditionQueryInfo)itr.next();
                        AbstractConditionQueryInfo condition3 = (AbstractConditionQueryInfo)itr.next();
                        RangeQueryInfo rqi = null;
                        ComparisonQueryInfo cqi1 = null;
                        ComparisonQueryInfo cqi2 = null;
                        if (condition1 instanceof RangeQueryInfo) {
                            rqi = (RangeQueryInfo)condition1;
                            cqi1 = (ComparisonQueryInfo)condition2;
                            cqi2 = (ComparisonQueryInfo)condition3;
                        }
                        if (condition2 instanceof RangeQueryInfo) {
                            rqi = (RangeQueryInfo)condition2;
                            cqi1 = (ComparisonQueryInfo)condition1;
                            cqi2 = (ComparisonQueryInfo)condition3;
                        }
                        if (condition3 instanceof RangeQueryInfo) {
                            rqi = (RangeQueryInfo)condition3;
                            cqi1 = (ComparisonQueryInfo)condition1;
                            cqi2 = (ComparisonQueryInfo)condition2;
                        }
                        TestCase.assertEquals((Object)rqi.getLowerBound(), (Object)new SQLInteger(4));
                        TestCase.assertEquals((Object)rqi.getUpperBound(), (Object)new SQLInteger(7));
                        TestCase.assertEquals((int)rqi.getUpperBoundOperator(), (int)6);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)4);
                        try {
                            TestCase.assertTrue((((ValueQueryInfo)cqi1.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(-2)) || ((ValueQueryInfo)cqi1.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(12)) ? 1 : 0) != 0);
                            TestCase.assertTrue((((ValueQueryInfo)cqi2.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(-2)) || ((ValueQueryInfo)cqi2.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(12)) ? 1 : 0) != 0);
                        }
                        catch (StandardException se) {
                            TestUtil.fail("test  failed because of exception=" + (Object)((Object)se));
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleRangeQueryInfoGeneration_1() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null  , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID >= 1  AND ID >=9  AND  ID <= 11 AND ID <= 8";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ConstantConditionsWrapperQueryInfo ccwqi = (ConstantConditionsWrapperQueryInfo)jqi.getOperands().get(0);
                        List operands = ccwqi.getOperands();
                        TestCase.assertEquals((int)operands.size(), (int)2);
                        Iterator itr = operands.iterator();
                        AbstractConditionQueryInfo condition1 = (AbstractConditionQueryInfo)itr.next();
                        AbstractConditionQueryInfo condition2 = (AbstractConditionQueryInfo)itr.next();
                        ComparisonQueryInfo cqi = condition1 instanceof ComparisonQueryInfo ? (ComparisonQueryInfo)condition1 : (ComparisonQueryInfo)condition2;
                        RangeQueryInfo rqi = condition1 instanceof RangeQueryInfo ? (RangeQueryInfo)condition1 : (RangeQueryInfo)condition2;
                        TestCase.assertTrue((boolean)rqi.getLowerBound().equals(new SQLInteger(9)));
                        TestCase.assertTrue((boolean)rqi.getUpperBound().equals(new SQLInteger(11)));
                        TestCase.assertTrue((rqi.getUpperBoundOperator() == 6 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)4);
                        try {
                            TestCase.assertTrue((boolean)((ValueQueryInfo)cqi.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(8)));
                        }
                        catch (StandardException se) {
                            TestUtil.fail("test  failed because of exception=" + (Object)((Object)se));
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleRangeQueryInfoGeneration_2() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID >= 1  AND ID <=9  AND  ID >= 11 AND ID <= 13";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ConstantConditionsWrapperQueryInfo ccwqi = (ConstantConditionsWrapperQueryInfo)jqi.getOperands().get(0);
                        List operands = ccwqi.getOperands();
                        TestCase.assertEquals((int)operands.size(), (int)2);
                        Iterator itr = operands.iterator();
                        RangeQueryInfo rqi1 = (RangeQueryInfo)itr.next();
                        RangeQueryInfo rqi2 = (RangeQueryInfo)itr.next();
                        TestCase.assertTrue((rqi1.getLowerBound().equals(new SQLInteger(1)) || rqi1.getLowerBound().equals(new SQLInteger(11)) ? 1 : 0) != 0);
                        TestCase.assertTrue((rqi2.getLowerBound().equals(new SQLInteger(1)) || rqi2.getLowerBound().equals(new SQLInteger(11)) ? 1 : 0) != 0);
                        TestCase.assertTrue((rqi1.getUpperBound().equals(new SQLInteger(9)) || rqi1.getUpperBound().equals(new SQLInteger(13)) ? 1 : 0) != 0);
                        TestCase.assertTrue((rqi2.getUpperBound().equals(new SQLInteger(9)) || rqi2.getUpperBound().equals(new SQLInteger(13)) ? 1 : 0) != 0);
                        TestCase.assertTrue((rqi1.getUpperBoundOperator() == 6 ? 1 : 0) != 0);
                        TestCase.assertTrue((rqi2.getUpperBoundOperator() == 6 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)rqi1.getLowerBoundOperator(), (int)4);
                        TestCase.assertEquals((int)rqi2.getLowerBoundOperator(), (int)4);
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleRangeQueryInfoGeneration_3() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID >= 1 AND  ID =7  AND ID <=9  ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)2);
                        List operands = jqi.getOperands();
                        Iterator itr = operands.iterator();
                        AbstractConditionQueryInfo condition1 = (AbstractConditionQueryInfo)itr.next();
                        AbstractConditionQueryInfo condition2 = (AbstractConditionQueryInfo)itr.next();
                        ComparisonQueryInfo cqi = condition1 instanceof ComparisonQueryInfo ? (ComparisonQueryInfo)condition1 : (ComparisonQueryInfo)condition2;
                        RangeQueryInfo rqi = condition1 instanceof RangeQueryInfo ? (RangeQueryInfo)condition1 : (RangeQueryInfo)condition2;
                        TestCase.assertTrue((boolean)rqi.getLowerBound().equals(new SQLInteger(1)));
                        TestCase.assertTrue((boolean)rqi.getUpperBound().equals(new SQLInteger(9)));
                        TestCase.assertTrue((rqi.getUpperBoundOperator() == 6 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)4);
                        try {
                            TestCase.assertTrue((boolean)((ValueQueryInfo)cqi.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(7)));
                        }
                        catch (StandardException se) {
                            TestUtil.fail("test  failed because of exception=" + (Object)((Object)se));
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleNonRangeConditions() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID <= -10 AND ID >= 1  AND ID <= 9  ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ConstantConditionsWrapperQueryInfo ccwqi = (ConstantConditionsWrapperQueryInfo)jqi.getOperands().get(0);
                        List operands = ccwqi.getOperands();
                        TestCase.assertEquals((int)operands.size(), (int)2);
                        Iterator itr = operands.iterator();
                        ComparisonQueryInfo cqi1 = (ComparisonQueryInfo)itr.next();
                        ComparisonQueryInfo cqi2 = (ComparisonQueryInfo)itr.next();
                        try {
                            TestCase.assertTrue((((ValueQueryInfo)cqi1.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(-10)) || ((ValueQueryInfo)cqi1.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(1)) ? 1 : 0) != 0);
                            TestCase.assertTrue((((ValueQueryInfo)cqi2.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(-10)) || ((ValueQueryInfo)cqi2.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(1)) ? 1 : 0) != 0);
                        }
                        catch (StandardException se) {
                            TestUtil.fail("test  failed because of exception=" + (Object)((Object)se));
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParameterizedConditionsWrapper_1() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID > 1  AND ID < ?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ParameterizedConditionsWrapperQueryInfo pcwqi = (ParameterizedConditionsWrapperQueryInfo)jqi.getOperands().get(0);
                        List paramOps = pcwqi.getParameterizedOperands();
                        ComparisonQueryInfo constandOp = (ComparisonQueryInfo)pcwqi.getConstantOperand();
                        TestCase.assertTrue((boolean)(constandOp instanceof ComparisonQueryInfo));
                        TestCase.assertEquals((int)paramOps.size(), (int)1);
                        ComparisonQueryInfo cqi2 = (ComparisonQueryInfo)paramOps.get(0);
                        try {
                            TestCase.assertTrue((boolean)((ValueQueryInfo)constandOp.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(1)));
                            TestCase.assertTrue((boolean)(cqi2.rightOperand instanceof ParameterQueryInfo));
                        }
                        catch (StandardException se) {
                            TestUtil.fail("test  failed because of exception=" + (Object)((Object)se));
                        }
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParameterizedConditionsWrapper_2() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID > 1  AND ID < ? AND ID <10";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ParameterizedConditionsWrapperQueryInfo pcw = (ParameterizedConditionsWrapperQueryInfo)jqi.getOperands().get(0);
                        List paramOps = pcw.getParameterizedOperands();
                        RangeQueryInfo rqi = (RangeQueryInfo)pcw.getConstantOperand();
                        TestCase.assertEquals((int)paramOps.size(), (int)1);
                        ComparisonQueryInfo cqi2 = (ComparisonQueryInfo)paramOps.get(0);
                        TestCase.assertTrue((boolean)(cqi2.rightOperand instanceof ParameterQueryInfo));
                        TestCase.assertTrue((boolean)rqi.getLowerBound().equals(new SQLInteger(1)));
                        TestCase.assertTrue((boolean)rqi.getUpperBound().equals(new SQLInteger(10)));
                        TestCase.assertTrue((rqi.getUpperBoundOperator() == 5 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)3);
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testANDJunctionWithInClause() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID IN (1,2,3)  AND ADDRESS = 'first'";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)2);
                        if (jqi.getOperands().get(0) instanceof InQueryInfo) {
                            TestCase.assertTrue((jqi.getOperands().get(1) instanceof ComparisonQueryInfo && !(jqi.getOperands().get(1) instanceof InQueryInfo) ? 1 : 0) != 0);
                        } else {
                            TestCase.assertTrue((boolean)(jqi.getOperands().get(1) instanceof InQueryInfo));
                            TestCase.assertTrue((jqi.getOperands().get(0) instanceof ComparisonQueryInfo && !(jqi.getOperands().get(0) instanceof InQueryInfo) ? 1 : 0) != 0);
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEqualityConditions_1() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID = 1   AND ADDRESS = 'first' AND  DESCRIPTION = 'xxx'";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)3);
                        Map eqMap = jqi.getEqualityConditionsMap();
                        TestCase.assertEquals((int)eqMap.size(), (int)1);
                        Collection operands = ((Map)eqMap.values().iterator().next()).values();
                        TestCase.assertEquals((int)operands.size(), (int)3);
                        Iterator opItr = operands.iterator();
                        HashSet<String> colNames = new HashSet<String>();
                        colNames.add("ID");
                        colNames.add("ADDRESS");
                        colNames.add("DESCRIPTION");
                        while (opItr.hasNext()) {
                            ComparisonQueryInfo cqi = (ComparisonQueryInfo)opItr.next();
                            TestCase.assertTrue((boolean)colNames.remove(((ColumnQueryInfo)cqi.leftOperand).getActualColumnName()));
                        }
                        TestCase.assertTrue((boolean)colNames.isEmpty());
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEqualityConditions_2() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID = 1   AND ADDRESS = 'first' AND  DESCRIPTION = 'xxx' AND ID > -1";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)4);
                        Map eqMap = jqi.getEqualityConditionsMap();
                        TestCase.assertEquals((int)eqMap.size(), (int)1);
                        Collection operands = ((Map)eqMap.values().iterator().next()).values();
                        TestCase.assertEquals((int)operands.size(), (int)3);
                        Iterator opItr = operands.iterator();
                        HashSet<String> colNames = new HashSet<String>();
                        colNames.add("ID");
                        colNames.add("ADDRESS");
                        colNames.add("DESCRIPTION");
                        while (opItr.hasNext()) {
                            ComparisonQueryInfo cqi = (ComparisonQueryInfo)opItr.next();
                            TestCase.assertTrue((boolean)colNames.remove(((ColumnQueryInfo)cqi.leftOperand).getActualColumnName()));
                        }
                        TestCase.assertTrue((boolean)colNames.isEmpty());
                        Map inequalityOp = jqi.getInEqualityConditionsMap();
                        TestCase.assertEquals((int)inequalityOp.size(), (int)1);
                        ComparisonQueryInfo cqi = (ComparisonQueryInfo)inequalityOp.values().iterator().next();
                        TestCase.assertEquals((int)cqi.getRelationalOperator(), (int)3);
                        TestCase.assertEquals((String)((ColumnQueryInfo)cqi.leftOperand).getActualColumnName(), (String)"ID");
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkGetConvertibleInClauseWithMultiColumnPrimaryKey_1() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id, name ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        String query = "select type, id, name from t1 where id IN (?,?,?) AND name  IN (?,?,?)";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)6);
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)2);
                        TestCase.assertTrue((boolean)(jqi.getOperands().get(0) instanceof InQueryInfo));
                        TestCase.assertTrue((boolean)(jqi.getOperands().get(1) instanceof InQueryInfo));
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)pks.length, (int)9);
                        for (int i = 0; i < pks.length; ++i) {
                            TestCase.assertTrue((boolean)(pks[i] instanceof CompositeDynamicKey));
                        }
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ps1.setString(4, "j 604");
            ps1.setString(5, "j 604");
            ps1.setString(6, "j 604");
            ps1.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkGetConvertibleInClauseWithMultiColumnPrimaryKey_2() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id, name ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        String query = "select type, id, name from t1 where id IN (1,2,3) AND name  IN ('a','b','c')";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        int i;
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertFalse((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)0);
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)2);
                        TestCase.assertTrue((boolean)(jqi.getOperands().get(0) instanceof InQueryInfo));
                        TestCase.assertTrue((boolean)(jqi.getOperands().get(1) instanceof InQueryInfo));
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)pks.length, (int)9);
                        HashSet<String> keys = new HashSet<String>();
                        for (i = 1; i < 4; ++i) {
                            for (int j = 97; j < 100; ++j) {
                                keys.add(i + "" + (char)j);
                            }
                        }
                        try {
                            for (i = 0; i < pks.length; ++i) {
                                TestCase.assertTrue((boolean)(pks[i] instanceof RegionKey));
                                RegionKey gfk = (RegionKey)pks[i];
                                DataValueDescriptor[] dvdArr = new DataValueDescriptor[gfk.nCols()];
                                gfk.getKeyColumns(dvdArr);
                                TestCase.assertEquals((int)dvdArr.length, (int)2);
                                String temp = dvdArr[0].getInt() + "" + dvdArr[1].getString();
                                TestCase.assertTrue((boolean)keys.remove(temp));
                            }
                        }
                        catch (StandardException se) {
                            se.printStackTrace();
                            TestUtil.fail(se.toString());
                        }
                        TestCase.assertTrue((boolean)keys.isEmpty());
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testANDJunctionConditionNotSupportingRange() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where (ID > 1 AND ID < 10)  AND ID < -1";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        ConstantConditionsWrapperQueryInfo ccwqi = (ConstantConditionsWrapperQueryInfo)jqi.getOperands().get(0);
                        TestCase.assertEquals((int)ccwqi.getOperands().size(), (int)2);
                        if (ccwqi.getOperands().get(0) instanceof RangeQueryInfo || ccwqi.getOperands().get(1) instanceof RangeQueryInfo) {
                            ComparisonQueryInfo cqi;
                            RangeQueryInfo rqi;
                            if (ccwqi.getOperands().get(0) instanceof RangeQueryInfo) {
                                rqi = (RangeQueryInfo)ccwqi.getOperands().get(0);
                                cqi = (ComparisonQueryInfo)ccwqi.getOperands().get(1);
                            } else {
                                rqi = (RangeQueryInfo)ccwqi.getOperands().get(1);
                                cqi = (ComparisonQueryInfo)ccwqi.getOperands().get(0);
                            }
                            try {
                                TestCase.assertEquals((int)1, (int)rqi.getLowerBound().getInt());
                                TestCase.assertEquals((int)3, (int)rqi.getLowerBoundOperator());
                                TestCase.assertEquals((int)10, (int)rqi.getUpperBound().getInt());
                                TestCase.assertEquals((int)5, (int)rqi.getUpperBoundOperator());
                                TestCase.assertEquals((Object)((ValueQueryInfo)cqi.rightOperand).evaluateToGetDataValueDescriptor(null), (Object)new SQLInteger(-1));
                            }
                            catch (StandardException se) {
                                se.printStackTrace();
                                TestUtil.fail("Test failed because of .Exception= " + (Object)((Object)se));
                            }
                        } else {
                            ComparisonQueryInfo cqi1 = (ComparisonQueryInfo)ccwqi.getOperands().get(0);
                            ComparisonQueryInfo cqi2 = (ComparisonQueryInfo)ccwqi.getOperands().get(1);
                            try {
                                TestCase.assertTrue((((ValueQueryInfo)cqi1.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(-1)) || ((ValueQueryInfo)cqi1.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(1)) ? 1 : 0) != 0);
                                TestCase.assertTrue((((ValueQueryInfo)cqi2.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(-1)) || ((ValueQueryInfo)cqi2.rightOperand).evaluateToGetDataValueDescriptor(null).equals(new SQLInteger(1)) ? 1 : 0) != 0);
                            }
                            catch (StandardException se) {
                                se.printStackTrace();
                                TestUtil.fail("Test failed because of .Exception= " + (Object)((Object)se));
                            }
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39530_1() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "Select * from TESTTABLE where ID > 1 AND ID >= 4   AND ID < 8 AND ID <= 4";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        RangeQueryInfo rqi = (RangeQueryInfo)jqi.getOperands().get(0);
                        TestCase.assertEquals((Object)rqi.getLowerBound(), (Object)new SQLInteger(4));
                        TestCase.assertEquals((Object)rqi.getUpperBound(), (Object)new SQLInteger(4));
                        TestCase.assertEquals((int)rqi.getUpperBoundOperator(), (int)6);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)4);
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39530_2() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024))");
        String query = "select ID, DESCRIPTION from TESTTABLE where ID  >= 1 And ID <= 5  AND ID <= 7 AND ID >= 5";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo jqi = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)jqi.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)jqi.getOperands().size(), (int)1);
                        RangeQueryInfo rqi = (RangeQueryInfo)jqi.getOperands().get(0);
                        TestCase.assertEquals((Object)rqi.getLowerBound(), (Object)new SQLInteger(5));
                        TestCase.assertEquals((Object)rqi.getUpperBound(), (Object)new SQLInteger(5));
                        TestCase.assertEquals((int)rqi.getUpperBoundOperator(), (int)6);
                        TestCase.assertEquals((int)rqi.getLowerBoundOperator(), (int)4);
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeTwoAndJunctionsToFormORJunction() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024) , TYPE int)");
        String query = "select ID, DESCRIPTION from TESTTABLE where ((DESCRIPTION  = ? and ADDRESS < ?) OR (DESCRIPTION =? and ADDRESS >?))  and ID IN (?, ?, ?, ?, ?) and TYPE = ? ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)acqi.isStaticallyNotGetConvertible());
                        TestCase.assertTrue((boolean)acqi.isWhereClauseDynamic());
                        TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                        AndJunctionQueryInfo root = (AndJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)root.getJunctionType(), (int)1);
                        TestCase.assertEquals((int)root.getOperands().size(), (int)2);
                        List Ops = root.getOperands();
                        for (AbstractConditionQueryInfo temp : Ops) {
                            TestCase.assertTrue((temp instanceof InQueryInfo || temp instanceof ComparisonQueryInfo ? 1 : 0) != 0);
                        }
                        OrJunctionQueryInfo ojqi = (OrJunctionQueryInfo)root.children[0];
                        TestCase.assertTrue((boolean)ojqi.isStaticallyNotGetConvertible());
                        TestCase.assertTrue((boolean)ojqi.isWhereClauseDynamic());
                        TestCase.assertTrue((boolean)ojqi.getOperands().isEmpty());
                        TestCase.assertEquals((int)ojqi.children.length, (int)2);
                        TestCase.assertTrue((boolean)(ojqi.children[0] instanceof AndJunctionQueryInfo));
                        TestCase.assertTrue((boolean)ojqi.children[0].isStaticallyNotGetConvertible());
                        TestCase.assertEquals((int)ojqi.children[0].getOperands().size(), (int)2);
                        TestCase.assertTrue((boolean)(ojqi.children[1] instanceof AndJunctionQueryInfo));
                        TestCase.assertTrue((boolean)ojqi.children[1].isStaticallyNotGetConvertible());
                        TestCase.assertEquals((int)ojqi.children[1].getOperands().size(), (int)2);
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeTwoORJunctionsToFormANDJunction() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024) , TYPE int)");
        String query = "select ID, DESCRIPTION from TESTTABLE where ((DESCRIPTION  = 'a' OR ADDRESS < 'c') AND (DESCRIPTION ='d' OR ADDRESS > 'b'))  OR ID IN (1, 2, 3, 4, 5) OR TYPE = 3 ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof OrJunctionQueryInfo));
                        OrJunctionQueryInfo root = (OrJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)root.getJunctionType(), (int)2);
                        TestCase.assertTrue((boolean)root.isStaticallyNotGetConvertible());
                        TestCase.assertFalse((boolean)root.isWhereClauseDynamic());
                        TestCase.assertEquals((int)root.getOperands().size(), (int)2);
                        List Ops = root.getOperands();
                        for (AbstractConditionQueryInfo temp : Ops) {
                            TestCase.assertTrue((temp instanceof InQueryInfo || temp instanceof ComparisonQueryInfo ? 1 : 0) != 0);
                        }
                        AndJunctionQueryInfo ajqi = (AndJunctionQueryInfo)root.children[0];
                        TestCase.assertTrue((boolean)ajqi.getOperands().isEmpty());
                        TestCase.assertEquals((int)ajqi.children.length, (int)2);
                        TestCase.assertTrue((boolean)(ajqi.children[0] instanceof OrJunctionQueryInfo));
                        TestCase.assertEquals((int)ajqi.children[0].getOperands().size(), (int)2);
                        TestCase.assertTrue((boolean)(ajqi.children[1] instanceof OrJunctionQueryInfo));
                        TestCase.assertEquals((int)ajqi.children[1].getOperands().size(), (int)2);
                    }
                }
            });
            Statement stmnt = conn.createStatement();
            stmnt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeTwoORJunctionsToFormANDJunctionWithParameters() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024) , TYPE int)");
        String query = "select ID, DESCRIPTION from TESTTABLE where ((DESCRIPTION  = 'a' OR ADDRESS < 'c') AND (DESCRIPTION =? OR ADDRESS > ? OR ID > 3))  OR ID IN (1, 2, 3, 4, 5) OR TYPE = 3 ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof OrJunctionQueryInfo));
                        OrJunctionQueryInfo root = (OrJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)root.getJunctionType(), (int)2);
                        TestCase.assertTrue((boolean)root.isStaticallyNotGetConvertible());
                        TestCase.assertTrue((boolean)root.isWhereClauseDynamic());
                        TestCase.assertEquals((int)root.getOperands().size(), (int)2);
                        List Ops = root.getOperands();
                        for (AbstractConditionQueryInfo temp : Ops) {
                            TestCase.assertTrue((temp instanceof InQueryInfo || temp instanceof ComparisonQueryInfo ? 1 : 0) != 0);
                            if (!(temp instanceof InQueryInfo)) continue;
                            TestCase.assertFalse((boolean)temp.isStaticallyNotGetConvertible());
                        }
                        AndJunctionQueryInfo ajqi = (AndJunctionQueryInfo)root.children[0];
                        TestCase.assertTrue((boolean)ajqi.getOperands().isEmpty());
                        TestCase.assertTrue((boolean)ajqi.isWhereClauseDynamic());
                        TestCase.assertTrue((boolean)ajqi.isStaticallyNotGetConvertible());
                        TestCase.assertEquals((int)ajqi.children.length, (int)2);
                        TestCase.assertTrue((boolean)(ajqi.children[0] instanceof OrJunctionQueryInfo));
                        TestCase.assertTrue((boolean)(ajqi.children[1] instanceof OrJunctionQueryInfo));
                        if (ajqi.children[0].getOperands().size() == 3) {
                            TestCase.assertTrue((boolean)ajqi.children[0].isWhereClauseDynamic());
                            TestCase.assertTrue((boolean)ajqi.children[0].isStaticallyNotGetConvertible());
                        }
                        if (ajqi.children[1].getOperands().size() == 2) {
                            TestCase.assertFalse((boolean)ajqi.children[1].isWhereClauseDynamic());
                            TestCase.assertTrue((boolean)ajqi.children[1].isStaticallyNotGetConvertible());
                        }
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeTwoANDJunctionsToFormANDJunctionWithParameters() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key,  TYPE int, ADDRESS varchar(1024),DESCRIPTION varchar(1024)  )");
        String query = "select ID, DESCRIPTION from TESTTABLE where ((DESCRIPTION  = 'a' AND ADDRESS < 'c') AND (TYPE =? AND ADDRESS > ? AND ID > 3))  OR ID IN (1, 2, 3, 4, 5) OR TYPE = 3 ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                        TestCase.assertTrue((boolean)(acqi instanceof OrJunctionQueryInfo));
                        OrJunctionQueryInfo root = (OrJunctionQueryInfo)acqi;
                        TestCase.assertEquals((int)root.getJunctionType(), (int)2);
                        TestCase.assertTrue((boolean)root.isStaticallyNotGetConvertible());
                        TestCase.assertTrue((boolean)root.isWhereClauseDynamic());
                        TestCase.assertEquals((int)root.getOperands().size(), (int)2);
                        List Ops = root.getOperands();
                        for (AbstractConditionQueryInfo temp : Ops) {
                            TestCase.assertTrue((temp instanceof InQueryInfo || temp instanceof ComparisonQueryInfo ? 1 : 0) != 0);
                            if (!(temp instanceof InQueryInfo)) continue;
                            TestCase.assertFalse((boolean)temp.isStaticallyNotGetConvertible());
                        }
                        AndJunctionQueryInfo ajqi = (AndJunctionQueryInfo)root.children[0];
                        TestCase.assertEquals((int)ajqi.getOperands().size(), (int)4);
                        TestCase.assertTrue((boolean)ajqi.isWhereClauseDynamic());
                        TestCase.assertTrue((boolean)ajqi.isStaticallyNotGetConvertible());
                        TestCase.assertTrue((ajqi.children == null ? 1 : 0) != 0);
                        Iterator iter = ajqi.getOperands().iterator();
                        ComparisonQueryInfo cqi = (ComparisonQueryInfo)iter.next();
                        TestCase.assertEquals((String)((ColumnQueryInfo)cqi.leftOperand).getActualColumnName(), (String)"TYPE");
                        cqi = (ComparisonQueryInfo)iter.next();
                        TestCase.assertEquals((String)((ColumnQueryInfo)cqi.leftOperand).getActualColumnName(), (String)"DESCRIPTION");
                        AbstractConditionQueryInfo third = (AbstractConditionQueryInfo)iter.next();
                        AbstractConditionQueryInfo fourth = (AbstractConditionQueryInfo)iter.next();
                        if (third instanceof ParameterizedConditionsWrapperQueryInfo) {
                            TestCase.assertTrue((boolean)(fourth instanceof ComparisonQueryInfo));
                            TestCase.assertTrue((boolean)(((ParameterizedConditionsWrapperQueryInfo)third).getConstantOperand() instanceof ComparisonQueryInfo));
                            TestCase.assertEquals((int)((ParameterizedConditionsWrapperQueryInfo)third).getParameterizedOperands().size(), (int)1);
                        } else {
                            TestCase.assertTrue((boolean)(third instanceof ComparisonQueryInfo));
                            TestCase.assertTrue((boolean)(fourth instanceof ParameterizedConditionsWrapperQueryInfo));
                            TestCase.assertTrue((boolean)(((ParameterizedConditionsWrapperQueryInfo)fourth).getConstantOperand() instanceof ComparisonQueryInfo));
                            TestCase.assertEquals((int)((ParameterizedConditionsWrapperQueryInfo)fourth).getParameterizedOperands().size(), (int)1);
                        }
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39680() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024),primary key (ID))");
        String query = "select * from TESTTABLE where DESCRIPTION  = 'asif' And ID = 5";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        GfxdPartitionResolver resolver = (GfxdPartitionResolver)((PartitionedRegion)sqi.getRegion()).getPartitionResolver();
                        TestCase.assertNotNull((Object)resolver);
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquijoinQueryForPRAndReplicatedRegion() throws Exception {
        SelectQueryInfoInternalsTest.setupConnection();
        SelectQueryInfoInternalsTest.sqlExecute("create table TESTTABLE1 (ID1 int not null, DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1)) PARTITION BY Column ( ID1 )", false);
        SelectQueryInfoInternalsTest.sqlExecute("create table TESTTABLE2 (ID2 int not null, DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE", true);
        String query = "select * from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID2 = 1";
        LanguageConnectionContext lcc = ((EmbedConnection)jdbcConn).getLanguageConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                        actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                        try {
                            GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                            sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            try {
                SelectQueryInfoInternalsTest.sqlExecute(query, false);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void testEquijoinQueryForTwoReplicatedRegions() throws Exception {
        SelectQueryInfoInternalsTest.setupConnection();
        SelectQueryInfoInternalsTest.sqlExecute("create table TESTTABLE1 (ID1 int not null, DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1)) REPLICATE", true);
        SelectQueryInfoInternalsTest.sqlExecute("create table TESTTABLE2 (ID2 int not null, DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE", false);
        SelectQueryInfoInternalsTest.sqlExecute("insert into TESTTABLE1 values (1, 'First1', 'Addr11')", true);
        SelectQueryInfoInternalsTest.sqlExecute("insert into TESTTABLE1 values (2, 'Second1', 'Addr12')", true);
        SelectQueryInfoInternalsTest.sqlExecute("insert into TESTTABLE1 values (3, 'Third1', 'Addr13')", true);
        SelectQueryInfoInternalsTest.sqlExecute("insert into TESTTABLE2 values (1, 'First2', 'Addr21')", true);
        SelectQueryInfoInternalsTest.sqlExecute("insert into TESTTABLE2 values (2, 'Second2', 'Addr22')", true);
        SelectQueryInfoInternalsTest.sqlExecute("insert into TESTTABLE2 values (3, 'Third2', 'Addr23')", true);
        SelectQueryInfoInternalsTest.sqlExecuteVerifyText("select * from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID2 = 1", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "query_repl", false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiColumnResolverNodesPruningForMultipleINClause() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ID_1 int not null, primary key (ID)) Partition by Column(ID, ID_1)");
        String query = "select ID, DESCRIPTION from TESTTABLE where ID_1  IN (5003,9837,1000101) AND ID IN (76542,138371,91332783)";
        for (int i = 0; i < 7; ++i) {
            s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "'," + (i + 1) + ")");
        }
        LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                        actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                        try {
                            GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                            sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                            HashSet<Object> externallyCmputed = new HashSet<Object>();
                            GfxdPartitionResolver spr = (GfxdPartitionResolver)((PartitionedRegion)sqi.getRegion()).getPartitionResolver();
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(76542), new SQLInteger(5003)}));
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(138371), new SQLInteger(5003)}));
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(91332783), new SQLInteger(5003)}));
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(76542), new SQLInteger(9837)}));
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(138371), new SQLInteger(9837)}));
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(91332783), new SQLInteger(9837)}));
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(76542), new SQLInteger(1000101)}));
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(138371), new SQLInteger(1000101)}));
                            externallyCmputed.add(spr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(91332783), new SQLInteger(1000101)}));
                            TestCase.assertFalse((boolean)actualRoutingKeys.contains(ResolverUtils.TOK_ALL_NODES));
                            TestCase.assertEquals((int)externallyCmputed.size(), (int)actualRoutingKeys.size());
                            TestCase.assertTrue((boolean)externallyCmputed.removeAll(actualRoutingKeys));
                            TestCase.assertTrue((boolean)externallyCmputed.isEmpty());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail("test failed because of exception=" + e.toString());
                        }
                    }
                }
            });
            s.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    public void testBug41299() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ID_1 int not null, ID_2 int not null, ID_3 int not null, primary key (ID)) Partition by ( ((ID + ID_1)*ID_2)/ID_3 )");
        s.execute("create table TESTTABLE1 (ID int not null,  DESCRIPTION varchar(1024) not null, ID_1 int not null, ID_2 int not null, ID_3 int not null, primary key (ID)) Partition by ( (ID + ID_1)*ID_2 )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingPartitionByExpression_Bug40857_2() throws Exception {
        try {
            System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            Connection conn = SelectQueryInfoInternalsTest.getConnection();
            Statement s = conn.createStatement();
            s.execute("create table TESTTABLE (a int not null,  DESCRIPTION varchar(1024) not null, b int not null, c int not null,d int not null, primary key (a)) Partition by ( ((c  + b)*a)/d )");
            String[] queries = new String[]{"select * from TESTTABLE where   ((c  + b)*a )/d = 5", "select * from TESTTABLE where a = 7 and  b = 8 and  c = 1 and d = 3", "select * from TESTTABLE where  ((c  + b)*a)/d = 5 and Description = 'abc'", "select * from TESTTABLE where  (c  + b)*a/d = 5 and Description = 'abc'", "select * from TESTTABLE where  (c  + b)*a/d = 5 and a = 7 and b =8  and c=1 and d =3  and Description = 'abc'", "select * from TESTTABLE where  (c  + b)*a/d = 5 OR ( a = 7 and b =8  and c=1 and d =3 ) and Description = 'abc'", "select * from TESTTABLE x where  (x.c  + x.b)*x.a/d = 5 OR ( a = 7 and b =8  and c=1 and d =3 ) and Description = 'abc'", "select * from TESTTABLE x where  (x.c  + x.b)*x.a/d = 5 OR ( a IN (7,5) and b IN (8,7)  and c=1 and d =3 ) and Description = 'abc'"};
            Object[] expectedRoutingKeys = new Object[]{new Integer(5), new Integer(21), new Integer(5), new Integer(5), new Object[]{new Integer(21)}, new Object[]{new Integer(5), new Integer(21)}, new Object[]{new Integer(5), new Integer(21)}, new Object[]{new Integer(5), new Integer(21), new Integer(15), new Integer(13), new Integer(18)}};
            LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
            for (int i = 0; i < queries.length; ++i) {
                final Object expectedRoutingKey = expectedRoutingKeys[i];
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectAfterPreparedStatementCompletion(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                            actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                            try {
                                GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                                ((BaseActivation)act).initFromContext(lcc, true, (ExecPreparedStatement)gps);
                                sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                                if (expectedRoutingKey instanceof Object[]) {
                                    Object[] keys;
                                    for (Object key : keys = (Object[])expectedRoutingKey) {
                                        TestCase.assertTrue((boolean)actualRoutingKeys.remove(key));
                                    }
                                    TestCase.assertTrue((boolean)actualRoutingKeys.isEmpty());
                                } else {
                                    TestCase.assertTrue((boolean)actualRoutingKeys.remove(expectedRoutingKey));
                                    TestCase.assertTrue((boolean)actualRoutingKeys.isEmpty());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestUtil.fail("test failed because of exception=" + e.toString());
                            }
                        }
                    }
                });
                s.executeQuery(queries[i]);
                SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
                this.callbackInvoked = false;
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingPartitionByExpression_Bug40857_1() throws Exception {
        try {
            System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            Connection conn = SelectQueryInfoInternalsTest.getConnection();
            Statement s = conn.createStatement();
            s.execute("create table TESTTABLE (a int not null,  DESCRIPTION varchar(1024) not null, b int not null, c int not null,d int not null, primary key (a)) Partition by  (c * a + b)");
            String[] queries = new String[]{"select * from TESTTABLE where c * a = 3", "select * from TESTTABLE where  (c * a + b) = 5", "select * from TESTTABLE where a = 7 and  b = 8 and  c = 1 and d = 3", "select * from TESTTABLE where  (c *a + b) = 5 and Description = 'abc'"};
            Object[] expectedRoutingKeys = new Object[]{ResolverUtils.TOK_ALL_NODES, new Integer(5), new Integer(15), new Integer(5)};
            LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
            for (int i = 0; i < queries.length; ++i) {
                final Object expectedRoutingKey = expectedRoutingKeys[i];
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectAfterPreparedStatementCompletion(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                            actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                            try {
                                GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                                ((BaseActivation)act).initFromContext(lcc, true, (ExecPreparedStatement)gps);
                                sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                                if (expectedRoutingKey instanceof Object[]) {
                                    Object[] keys;
                                    for (Object key : keys = (Object[])expectedRoutingKey) {
                                        TestCase.assertTrue((boolean)actualRoutingKeys.remove(key));
                                    }
                                    TestCase.assertTrue((boolean)actualRoutingKeys.isEmpty());
                                } else {
                                    TestCase.assertTrue((boolean)actualRoutingKeys.remove(expectedRoutingKey));
                                    TestCase.assertTrue((boolean)actualRoutingKeys.isEmpty());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestUtil.fail("test failed because of exception=" + e.toString());
                            }
                        }
                    }
                });
                s.executeQuery(queries[i]);
                SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
                this.callbackInvoked = false;
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40329() throws Exception {
        SelectQueryInfoInternalsTest.setupConnection();
        SelectQueryInfoInternalsTest.sqlExecute("create table TESTTABLE1 (ID1 int not null, DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, PRICE1 int not null, primary key (ID1)) ", true);
        SelectQueryInfoInternalsTest.sqlExecute("create table TESTTABLE2 (ID2 int not null, DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, PRICE2 int not null, primary key (ID2)) replicate ", false);
        SelectQueryInfoInternalsTest.sqlExecute("create table TESTTABLE3 (ID3 int not null, DESCRIPTION3 varchar(1024) not null, ADDRESS3 varchar(1024) not null,  PRICE3 int not null, SUBTOTAL3 int not null,primary key (ID3)) ", false);
        SelectQueryInfoInternalsTest.sqlExecute("create table TESTTABLE4 (ID4 int not null, DESCRIPTION4 varchar(1024) not null, ADDRESS4 varchar(1024) not null, primary key (ID4)) ", false);
        String query = " select * from TESTTABLE1 c, TESTTABLE2 s, TESTTABLE3 f where c.ID1= f.ID3 and s.PRICE2 = f.PRICE3 and c.ID1 > ? and (f.SUBTOTAL3 >10000 or (s.PRICE2 >= ? and s.PRICE2 <= ?))";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    }
                }
            });
            try {
                Connection conn = SelectQueryInfoInternalsTest.getConnection();
                conn.prepareStatement(query);
            }
            catch (SQLException e) {
                e.getCause().printStackTrace();
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void testBug40209() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        conn.getMetaData().getIndexInfo(null, null, "SYS", true, true);
    }

    public void testBug40220() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        ((EmbedDatabaseMetaData)conn.getMetaData()).getClientInfoProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40503_1() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id, name ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        String query = "select type, id, name from t1 where ( id = ? and name = ? ) OR (id = ? and name = ? ) ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setString(2, "asif");
            ps1.setInt(3, 2);
            ps1.setString(4, "neeraj");
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            java.sql.ResultSet rs = ps1.executeQuery();
            HashSet<Integer> hash = new HashSet<Integer>();
            hash.add(new Integer(1));
            hash.add(new Integer(2));
            while (rs.next()) {
                SelectQueryInfoInternalsTest.assertTrue((boolean)hash.remove(new Integer(rs.getInt(2))));
            }
            SelectQueryInfoInternalsTest.assertTrue((String)"hashset is non empty", (boolean)hash.isEmpty());
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40503_2() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id, name ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        String query = "select type, id, name from t1 where ( id = 1 and name = 'asif' ) OR (id = 2 and name = 'neeraj' ) ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertFalse((boolean)sqi.isPreparedStatementQuery());
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            Statement stmt = conn.createStatement();
            java.sql.ResultSet rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            HashSet<Integer> hash = new HashSet<Integer>();
            hash.add(new Integer(1));
            hash.add(new Integer(2));
            while (rs.next()) {
                SelectQueryInfoInternalsTest.assertTrue((boolean)hash.remove(new Integer(rs.getInt(2))));
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)hash.isEmpty());
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40503_3() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id, name ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        String query = "select type, id, name from t1 where ( id = ? OR id = ? ) AND (name = ? OR name = ? ) ";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setString(3, "asif");
            ps1.setString(4, "neeraj");
            ps1.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _testDebugBug40413() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        String query = "select substr(name,1,2) from t1 where  id = 1 ";
        GemFireXDQueryObserver old = null;
        final boolean[] createdGFEResultSet = new boolean[]{false};
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(ResultSet rs) {
                    createdGFEResultSet[0] = true;
                }
            });
            Statement stmt = conn.createStatement();
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  id  from t1 where  id IN (1,3)  order by id desc ";
            stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  address, id  from t1 where  id IN (1,3)  group by id, address  ";
            stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testDefaultOrderByBehaviourForGFEActivation() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        s.execute("Insert into  t1 values(4,'eric',2, 'J 604')");
        GemFireXDQueryObserver old = null;
        final boolean[] createdGFEResultSet = new boolean[]{false};
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(ResultSet rs) {
                    createdGFEResultSet[0] = true;
                }
            });
            Statement stmt = conn.createStatement();
            String query = "select  id  from t1 where  id IN (3,1,4,2) ";
            java.sql.ResultSet rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            HashSet<Integer> actual = new HashSet<Integer>();
            HashSet<Integer> expected = new HashSet<Integer>();
            for (int i = 1; i < 5; ++i) {
                rs.next();
                actual.add(rs.getInt(1));
                expected.add(i);
            }
            SelectQueryInfoInternalsTest.assertEquals(actual, expected);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_1() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        s.execute("Insert into  t1 values(4,'eric',2, 'J 604')");
        String query = "select substr(name,1,2) from t1 where  id IN (1,1)";
        GemFireXDQueryObserver old = null;
        final boolean[] createdGFEResultSet = new boolean[]{false};
        try {
            int i;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(ResultSet rs) {
                    createdGFEResultSet[0] = true;
                }
            });
            Statement stmt = conn.createStatement();
            java.sql.ResultSet rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            HashSet<String> hash = new HashSet<String>();
            hash.add("as");
            while (rs.next()) {
                SelectQueryInfoInternalsTest.assertTrue((boolean)hash.remove(rs.getString(1)));
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)hash.isEmpty());
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1, 3)";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(1), (String)"604");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3) order by id  asc , address desc";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3) group by id, address   order by id ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  distinct type, AVG(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  distinct type, AVG(type), MAX(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  address, id  from t1 where  id IN (1,3) group by id, address  order by id";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct address  from t1 where  id IN (1,3) ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  address  from t1 where  id IN (1,3)  group by address ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  id  from t1 where  id IN (3,1,4,2)  order by id ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            for (i = 1; i < 5; ++i) {
                rs.next();
                SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)i);
            }
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  id  from t1 where  id IN (1,3,4,2)  order by id desc ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            for (i = 4; i > 0; --i) {
                rs.next();
                SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)i);
            }
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  id  from t1 where  id IN (3,1,4,2)  order by id asc ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            for (i = 1; i < 5; ++i) {
                rs.next();
                SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)i);
            }
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_2() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        GfxdCallbacksTest.addLoader(null, "t1", "com.pivotal.gemfirexd.jdbc.TestRowLoader", "");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        s.execute("Insert into  t1 values(4,'eric',2, 'J 604')");
        String query = "select substr(name,1,2) from t1 where  id = 1";
        GemFireXDQueryObserver old = null;
        final boolean[] createdGFEResultSet = new boolean[]{false};
        try {
            int i;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(ResultSet rs) {
                    createdGFEResultSet[0] = true;
                }
            });
            Statement stmt = conn.createStatement();
            java.sql.ResultSet rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            HashSet<String> hash = new HashSet<String>();
            hash.add("as");
            while (rs.next()) {
                SelectQueryInfoInternalsTest.assertTrue((boolean)hash.remove(rs.getString(1)));
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)hash.isEmpty());
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1, 3)";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(1), (String)"604");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3) order by id  asc , address desc";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3) group by id, address   order by id ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  distinct type, AVG(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  distinct type, AVG(type), MAX(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  address, id  from t1 where  id IN (1,3) group by id, address  order by id";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct address  from t1 where  id IN (1,3) ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  address  from t1 where  id IN (1,3)  group by address ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  id  from t1 where  id IN (3,1,4,2)  order by id ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            for (i = 1; i < 5; ++i) {
                rs.next();
                SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)i);
            }
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  id  from t1 where  id IN (1,3,4,2)  order by id desc ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            for (i = 4; i > 0; --i) {
                rs.next();
                SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)i);
            }
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select  id  from t1 where  id IN (3,1,4,2)  order by id asc ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            for (i = 1; i < 5; ++i) {
                rs.next();
                SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)i);
            }
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_3() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        s.execute("Insert into  t1 values(1,'asif',8, 'J 601')");
        s.execute("Insert into  t1 values(2,'neeraj',9, 'J 602')");
        s.execute("Insert into  t1 values(4,'sumedh',11, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',10, 'J 603')");
        String query = "select substr(address,4,5),substr(name,1,2) from t1 where  id  IN (1,3,4) order by name desc";
        final boolean[] createdGFEResultSet = new boolean[]{false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(ResultSet rs) {
                    createdGFEResultSet[0] = true;
                }
            });
            Statement stmt = conn.createStatement();
            java.sql.ResultSet rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(1), (String)"04");
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"su");
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(1), (String)"03");
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"sh");
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(1), (String)"01");
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"as");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_4() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s1 = conn.createStatement();
        s1.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        s.execute("create index i1 on t1 (type)");
        s.execute("Insert into  t1 values(1,'asif',3, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',4, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',5, 'J 604')");
        String query = "select type,TestUDF(name,1,4) from t1 where id IN (1,3) order by name desc";
        final boolean[] createdGFEResultSet = new boolean[]{false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(ResultSet rs) {
                    createdGFEResultSet[0] = true;
                }
            });
            Statement stmt = conn.createStatement();
            java.sql.ResultSet rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            rs.next();
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)5);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"hou");
            rs.next();
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)3);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"sif");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct address from t1 where  id IN (1,3) ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            rs.next();
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(1), (String)"J 604");
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            this.callbackInvoked = false;
            createdGFEResultSet[0] = false;
            query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1,3) ";
            rs = stmt.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            rs.next();
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(1), (String)"604");
            SelectQueryInfoInternalsTest.assertTrue((boolean)createdGFEResultSet[0]);
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41041() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int primary key,  TYPE int, ADDRESS varchar(1024),DESCRIPTION varchar(1024))");
        GemFireXDQueryObserver old = null;
        try {
            java.sql.ResultSet rs = conn.getMetaData().getColumnPrivileges(null, SelectQueryInfoInternalsTest.getCurrentDefaultSchemaName(), "TESTTABLE", null);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            System.out.println("Column Names are:");
            for (int i = 1; i <= numCols; ++i) {
                System.out.print(rsmd.getColumnName(i) + "   ");
            }
            System.out.println("Data is");
            while (rs.next()) {
                for (int j = 1; j <= numCols; ++j) {
                    System.out.print(rs.getObject(j) + "   ");
                }
                System.out.println();
                System.out.println();
            }
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorrelatedSubQueryOnPR_PR_UNSUPPORTED() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        String derbyDbUrl = "jdbc:derby:newDB;create=true;";
        if (currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        final Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement stmt = conn.createStatement();
        final Statement derbyStmt = derbyConn.createStatement();
        stmt.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1)) PARTITION BY COLUMN ( ID1 )");
        stmt.execute("create table TESTTABLE2 (ID2 int not null, DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))");
        derbyStmt.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))");
        derbyStmt.execute("create table TESTTABLE2 (ID2 int not null, DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))");
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2   where description2 > description1)";
        try {
            try {
                stmt.execute("select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2   where description2 > description1)");
                SelectQueryInfoInternalsTest.fail("The query should not get executed");
            }
            catch (SQLException snse) {
                SelectQueryInfoInternalsTest.assertEquals((String)"0A000", (String)snse.getSQLState());
                SelectQueryInfoInternalsTest.assertEquals((String)"0A000.S.9", (String)((DerbySQLException)snse).getMessageId());
            }
            catch (Exception e) {
                System.out.println(e);
                SelectQueryInfoInternalsTest.fail(e.getMessage(), e);
            }
            try {
                conn.prepareStatement("select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2   where description2 > description1)");
                SelectQueryInfoInternalsTest.fail("The query should not get executed");
            }
            catch (SQLException snse) {
                SelectQueryInfoInternalsTest.assertEquals((String)"0A000", (String)snse.getSQLState());
                SelectQueryInfoInternalsTest.assertEquals((String)"0A000.S.9", (String)((DerbySQLException)snse).getMessageId());
            }
            catch (Exception e) {
                System.out.println(e);
                SelectQueryInfoInternalsTest.fail(e.getMessage(), e);
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public PreparedStatement afterQueryPrepareFailure(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, SQLException sqle) throws SQLException {
                    if (sqle != null && "0A000".equals(sqle.getSQLState())) {
                        return derbyConn.prepareStatement("select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2   where description2 > description1)");
                    }
                    return null;
                }

                public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) throws SQLException {
                    if (sqle != null && "0A000".equals(sqle.getSQLState())) {
                        stmt.setResultSet(derbyStmt.executeQuery("select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2   where description2 > description1)"));
                        return true;
                    }
                    return false;
                }
            });
            derbyStmt.execute("insert into TESTTABLE1 values (1, 'ONE', 'ADDR1')");
            derbyStmt.execute("insert into TESTTABLE1 values (2, 'TWO', 'ADDR2')");
            derbyStmt.execute("insert into TESTTABLE1 values (3, 'THREE', 'ADDR3')");
            derbyStmt.execute("insert into TESTTABLE2 values (1, 'ZONE', 'ADDR1')");
            derbyStmt.execute("insert into TESTTABLE2 values (2, 'ATWO', 'ADDR2')");
            derbyStmt.execute("insert into TESTTABLE2 values (3, 'ATHREE', 'ADDR3')");
            java.sql.ResultSet rs = stmt.executeQuery("select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2   where description2 > description1)");
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)1, (int)rs.getInt(1));
            SelectQueryInfoInternalsTest.assertEquals((String)"ONE", (String)rs.getString(2));
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            rs.close();
            PreparedStatement ps = conn.prepareStatement("select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2   where description2 > description1)");
            rs = ps.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)1, (int)rs.getInt(1));
            SelectQueryInfoInternalsTest.assertEquals((String)"ONE", (String)rs.getString(2));
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            rs.close();
            ps.close();
        }
        finally {
            block15: {
                derbyStmt.execute("drop table TESTTABLE1");
                derbyStmt.execute("drop table TESTTABLE2");
                stmt.execute("drop table TESTTABLE1");
                stmt.execute("drop table TESTTABLE2");
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block15;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorrelatedSubQueryOnPR_RRSupport_SameServerGroup() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1)) PARTITION BY COLUMN ( ID1 )");
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) replicate ");
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.hasCorrelatedSubQuery());
                    }
                }
            });
            String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2 where description2 > description1)";
            s.execute(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerbySubactivation_DerbyResultset() throws Exception {
        String subqueryStr = "Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?";
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN (Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?)";
        try {
            int i;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void subqueryNodeProcessedData(SelectQueryInfo sqi, GenericPreparedStatement gps, String subquery, List<Integer> paramPositions) {
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                    TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                    TestCase.assertEquals((String)subquery.trim(), (String)"Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?");
                    TestCase.assertEquals((int)paramPositions.size(), (int)2);
                    TestCase.assertEquals((int)paramPositions.get(0), (int)0);
                    TestCase.assertEquals((int)paramPositions.get(1), (int)1);
                    try {
                        TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        TestCase.assertFalse((boolean)(gps.getActivationClass() instanceof GemFireActivationClass));
                    }
                    catch (StandardException e) {
                        e.printStackTrace();
                        throw new GemFireXDRuntimeException(e.toString());
                    }
                }
            });
            Connection conn = SelectQueryInfoInternalsTest.getConnection();
            Statement s = conn.createStatement();
            s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
            for (i = 35; i < 56; ++i) {
                s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'add1_" + i + "')");
            }
            s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
            for (i = 1; i < 11; ++i) {
                s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'add2_')");
            }
            EmbedPreparedStatement eps = (EmbedPreparedStatement)((EmbedConnection)conn).prepareStatementByPassQueryInfo(-1L, "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN (Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?)", true, true, false, null, 0L, 0);
            eps.setString(1, "desc2_");
            eps.setString(2, "add2_");
            java.sql.ResultSet rs = eps.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)55);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"desc1_55");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryParametersMapping() throws Exception {
        String subqueryStr = "Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?";
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where description1 = ? and address1 = ?  and  ID1 IN ( Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ? ) ";
        try {
            int i;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void subqueryNodeProcessedData(SelectQueryInfo sqi, GenericPreparedStatement gps, String subquery, List<Integer> paramPositions) {
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                    TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                    TestCase.assertEquals((String)subquery.trim(), (String)"Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?");
                    try {
                        TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        TestCase.assertFalse((boolean)(gps.getActivationClass() instanceof GemFireActivationClass));
                    }
                    catch (StandardException e) {
                        throw new GemFireXDRuntimeException(e.toString());
                    }
                    TestCase.assertEquals((int)paramPositions.size(), (int)2);
                    TestCase.assertEquals((int)paramPositions.get(0), (int)2);
                    TestCase.assertEquals((int)paramPositions.get(1), (int)3);
                }
            });
            Connection conn = SelectQueryInfoInternalsTest.getConnection();
            Statement s = conn.createStatement();
            s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
            for (i = 35; i < 56; ++i) {
                s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'add1_" + i + "')");
            }
            s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
            for (i = 1; i < 11; ++i) {
                s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'add2_')");
            }
            EmbedPreparedStatement eps = (EmbedPreparedStatement)((EmbedConnection)conn).prepareStatementByPassQueryInfo(1L, query, true, true, false, null, 0L, 0);
            eps.setString(3, "desc2_");
            eps.setString(4, "add2_");
            eps.setString(1, "desc1_55");
            eps.setString(2, "add1_55");
            java.sql.ResultSet rs = eps.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)55);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"desc1_55");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryDerbyActivationDerbyResultset() throws Exception {
        int i;
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        String subquery = "Select SUM(ID2) from Testtable2 where description2 = 'desc2_'";
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN (Select SUM(ID2) from Testtable2 where description2 = 'desc2_')";
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        for (i = 35; i < 56; ++i) {
            s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'ADD_1" + i + "')");
        }
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        for (i = 1; i < 11; ++i) {
            s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'ADD_2" + i + "')");
        }
        final boolean[] secondaryCallback = new boolean[]{false};
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void independentSubqueryResultsetFetched(Activation activation, ResultSet results) {
                    TestCase.assertFalse((boolean)(activation instanceof AbstractGemFireActivation));
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                }

                public void subqueryNodeProcessedData(SelectQueryInfo qInfo, GenericPreparedStatement gps, String subqry, List<Integer> paramPositions) {
                    TestCase.assertEquals((String)"Select SUM(ID2) from Testtable2 where description2 = 'desc2_'", (String)subqry);
                    secondaryCallback[0] = true;
                }
            });
            java.sql.ResultSet rs = ((EmbedStatement)s).executeQueryByPassQueryInfo(query, true, true, 0, null);
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)55);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"desc1_55");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)secondaryCallback[0]);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReuseOfSubqueryResultset() throws Exception {
        int i;
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        String subquery = "Select ID2 from Testtable2 where description2 = 'desc2_'";
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN (Select ID2 from Testtable2 where description2 = 'desc2_' ) OR DESCRIPTION1 = 'desc1_20'";
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        for (i = 1; i < 11; ++i) {
            s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'ADD_1" + i + "')");
        }
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        for (i = 4; i < 9; ++i) {
            s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'ADD_2" + i + "')");
        }
        final ResultSet[] rsArray = new ResultSet[1];
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void independentSubqueryResultsetFetched(Activation activation, ResultSet results) {
                    if (rsArray[0] == null) {
                        rsArray[0] = results;
                    } else {
                        TestCase.assertTrue((rsArray[0] == results ? 1 : 0) != 0);
                    }
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                }
            });
            EmbedResultSet rs = (EmbedResultSet)((EmbedStatement)s).executeQueryByPassQueryInfo(query, true, true, 0, null);
            HashSet<Integer> set = new HashSet<Integer>();
            for (int i2 = 4; i2 < 9; ++i2) {
                set.add(i2);
            }
            while (rs.lightWeightNext()) {
                int val = rs.getInt(1);
                set.remove(val);
                SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)("desc1_" + val));
            }
            rs.lightWeightClose();
            SelectQueryInfoInternalsTest.assertTrue((boolean)set.isEmpty());
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCorrelatedPR_PR_subquerySelectQueryInfoBehaviour() throws Exception {
        int i;
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        String subquery_c = "Select SUM(ID2) from Testtable2 where description2 like 'desc2_%'";
        String subquery_p = "Select SUM(ID2) from Testtable2 where description2 like <?>";
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN (Select SUM(ID2) from Testtable2 where description2 like 'desc2_%')  or DESCRIPTION1 = 'desc1_55'";
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        for (i = 35; i < 56; ++i) {
            s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'ADD_1" + i + "')");
        }
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        for (i = 1; i < 11; ++i) {
            s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'ADD_2" + i + "')");
        }
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo && !((DMLQueryInfo)qInfo).isSubQuery()) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.hasCorrelatedSubQuery());
                        TestCase.assertEquals((int)sqi.getSubqueryInfoList().size(), (int)1);
                        SubQueryInfo subQi = (SubQueryInfo)sqi.getSubqueryInfoList().iterator().next();
                        TestCase.assertEquals((String)subQi.getSubqueryString(), (String)"Select SUM(ID2) from Testtable2 where description2 like <?>");
                    }
                }
            });
            java.sql.ResultSet rs = ((EmbedStatement)s).executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)55);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"desc1_55");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCorrelatedPR_PR_subqueryWithMultipleRows() throws Exception {
        int i;
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        String subquery = "Select ID2 from Testtable2 where description2 = 'desc2_'";
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN (Select ID2 from Testtable2 where description2 = 'desc2_') or DESCRIPTION1 like 'desc1_%'";
        final boolean[] secondaryCallback = new boolean[]{false};
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        for (i = 4; i < 9; ++i) {
            s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'ADD_1" + i + "')");
        }
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        for (i = 1; i < 11; ++i) {
            s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'ADD_2" + i + "')");
        }
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void independentSubqueryResultsetFetched(Activation activation, ResultSet results) {
                    TestCase.assertFalse((boolean)(activation instanceof AbstractGemFireActivation));
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                }

                public void subqueryNodeProcessedData(SelectQueryInfo qInfo, GenericPreparedStatement gps, String subqry, List<Integer> paramPositions) {
                    TestCase.assertEquals((String)"Select ID2 from Testtable2 where description2 = 'desc2_'", (String)subqry);
                    secondaryCallback[0] = true;
                }
            });
            EmbedResultSet rs = (EmbedResultSet)((EmbedStatement)s).executeQueryByPassQueryInfo(query, true, true, 0, null);
            HashSet<Integer> set = new HashSet<Integer>();
            for (int i2 = 4; i2 < 9; ++i2) {
                set.add(i2);
            }
            while (rs.lightWeightNext()) {
                int val = rs.getInt(1);
                set.remove(val);
                SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)("desc1_" + val));
            }
            rs.lightWeightClose();
            SelectQueryInfoInternalsTest.assertTrue((boolean)set.isEmpty());
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            SelectQueryInfoInternalsTest.assertTrue((boolean)secondaryCallback[0]);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCorrelatedPR_PR_subqueryWithMultipleRowsAnyClause() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        String subquery = "Select  TEMP2 from Testtable2 where description2 = 'desc2_'";
        String query = "select TEMP1, DESCRIPTION1 from TESTTABLE1 where TEMP1  >= ANY (Select  TEMP2 from Testtable2 where description2 = 'desc2_') OR ADDRESS1 like 'MDD_1%'";
        final boolean[] secondaryCallback = new boolean[]{false};
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, TEMP1 int , primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        for (int i = -500; i < 11; ++i) {
            s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'ADD_1" + i + "'," + i + ")");
        }
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, TEMP2 int, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        String createFunction = "CREATE FUNCTION max1 ( v1 integer, v2 integer) RETURNS int LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.BugsTest.maxFunc(java.lang.Integer,java.lang.Integer)' PARAMETER STYLE JAVA NO SQL ";
        s.execute(createFunction);
        for (int i = 10; i < 20; ++i) {
            s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'ADD_2" + i + "'," + i + ")");
        }
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void independentSubqueryResultsetFetched(Activation activation, ResultSet results) {
                    TestCase.assertFalse((boolean)(activation instanceof AbstractGemFireActivation));
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                }

                public void subqueryNodeProcessedData(SelectQueryInfo qInfo, GenericPreparedStatement gps, String subqry, List<Integer> paramPositions) {
                    TestCase.assertEquals((String)"Select  TEMP2 from Testtable2 where description2 = 'desc2_'", (String)subqry);
                    secondaryCallback[0] = true;
                }
            });
            EmbedResultSet rs = (EmbedResultSet)((EmbedStatement)s).executeQueryByPassQueryInfo(query, true, true, 0, null);
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.lightWeightNext());
            int val = rs.getInt(1);
            SelectQueryInfoInternalsTest.assertEquals((int)val, (int)10);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)("desc1_" + val));
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.lightWeightNext());
            rs.lightWeightClose();
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCorrelatedPR_PR_subqueryWithMultipleRowsExistsClause() throws Exception {
        String subquery = "Select  ID2 from Testtable2 where description2 = 'desc2_'";
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where exists (Select  ID2 from Testtable2 where description2 = 'desc2_' ) OR  ADDRESS1 like 'ADD_1%'";
        final boolean[] secondaryCallback = new boolean[]{false};
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, TEMP1 int , primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        for (int i = 1; i < 11; ++i) {
            s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'ADD_1" + i + "'," + i + ")");
        }
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, TEMP2 int, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        String createFunction = "CREATE FUNCTION max1 ( v1 integer, v2 integer) RETURNS int LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.BugsTest.maxFunc(java.lang.Integer,java.lang.Integer)' PARAMETER STYLE JAVA NO SQL ";
        s.execute(createFunction);
        for (int i = 10; i < 20; ++i) {
            s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'ADD_2" + i + "'," + i + ")");
        }
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void independentSubqueryResultsetFetched(Activation activation, ResultSet results) {
                    TestCase.assertFalse((boolean)(activation instanceof AbstractGemFireActivation));
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                }

                public void subqueryNodeProcessedData(SelectQueryInfo qInfo, GenericPreparedStatement gps, String subqry, List<Integer> paramPositions) {
                    TestCase.assertEquals((String)"Select  ID2 from Testtable2 where description2 = 'desc2_'", (String)subqry);
                    secondaryCallback[0] = true;
                }
            });
            EmbedResultSet rs = (EmbedResultSet)((EmbedStatement)s).executeQueryByPassQueryInfo(query, true, true, 0, null);
            HashSet<Integer> set = new HashSet<Integer>();
            for (int i = 1; i < 11; ++i) {
                set.add(i);
            }
            while (rs.lightWeightNext()) {
                int val = rs.getInt(1);
                set.remove(val);
                SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)("desc1_" + val));
            }
            SelectQueryInfoInternalsTest.assertTrue((boolean)set.isEmpty());
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.lightWeightNext());
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
            rs.lightWeightClose();
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testNonCorrelatedPR_PR_subquery() throws Exception {
        int i;
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        for (i = 35; i < 56; ++i) {
            s.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'ADD_1" + i + "')");
        }
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        for (i = 1; i < 11; ++i) {
            s.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'ADD_2" + i + "')");
        }
        try {
            String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select SUM(ID2) from Testtable2 where description2 = 'desc2_')";
            java.sql.ResultSet rs = ((EmbedStatement)s).executeQueryByPassQueryInfo(query, true, true, 0, null);
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)rs.getInt(1), (int)55);
            SelectQueryInfoInternalsTest.assertEquals((String)rs.getString(2), (String)"desc1_55");
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorrelatedSubQueryDetection() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1)) PARTITION BY COLUMN ( ID1 )");
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.hasCorrelatedSubQuery());
                    }
                }
            });
            String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2 where ID2 > ID1)";
            try {
                conn.prepareStatement(query);
                SelectQueryInfoInternalsTest.fail("query not supported , should have  thrown exception");
            }
            catch (SQLException snse) {
                SelectQueryInfoInternalsTest.assertEquals((String)snse.getSQLState(), (String)"0A000");
                SelectQueryInfoInternalsTest.assertEquals((String)((DerbySQLException)snse).getMessageId(), (String)"0A000.S.10");
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41617_1_single_column_global_index_pruning_IN() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, tid int) partition by column (cid )");
        String query = "select * from  sellorders where oid IN (1, 2, 3, 4, 5) and tid < 41 ";
        String insertquery = "insert into sellorders values(?,?,?,?)";
        PreparedStatement ps = conn.prepareStatement(insertquery);
        for (int i = 1; i < 11; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 2 * i);
            ps.setInt(3, 3 * i);
            ps.setInt(4, 4 * i);
            ps.executeUpdate();
        }
        LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                        actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                        try {
                            Object[] routingObjs;
                            GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                            sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                            HashSet<Object> externallyCmputed = new HashSet<Object>();
                            GfxdPartitionResolver spr = (GfxdPartitionResolver)((PartitionedRegion)sqi.getRegion()).getPartitionResolver();
                            for (Object obj : routingObjs = spr.getRoutingObjectsForList(new DataValueDescriptor[]{new SQLInteger(2), new SQLInteger(4), new SQLInteger(6), new SQLInteger(8), new SQLInteger(10)})) {
                                externallyCmputed.add(obj);
                            }
                            TestCase.assertFalse((boolean)actualRoutingKeys.contains(ResolverUtils.TOK_ALL_NODES));
                            TestCase.assertEquals((int)externallyCmputed.size(), (int)actualRoutingKeys.size());
                            TestCase.assertTrue((boolean)externallyCmputed.removeAll(actualRoutingKeys));
                            TestCase.assertTrue((boolean)externallyCmputed.isEmpty());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail("test failed because of exception=" + e.toString());
                        }
                    }
                }
            });
            s.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCorrelated_PR_PR_44206() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        s.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1)");
        s.execute("insert into TESTTABLE1 values (1, 'Desc1', 'Addr1')");
        s.execute("insert into TESTTABLE1 values (2, 'Desc2', 'Addr2')");
        s.execute("insert into TESTTABLE2 values (2, 'Desc22', 'Addr22')");
        try {
            String prepQuery = "select ID1, DESCRIPTION1 from TESTTABLE1 alias1 where alias1.ID1 IN ( Select AVG(alias2.ID2) from Testtable2 alias2 where alias2.ID2 > ? ) AND 5 = ?";
            PreparedStatement ps = conn.prepareStatement(prepQuery);
            ps.setInt(1, 1);
            ps.setInt(2, 7);
            java.sql.ResultSet rs = ps.executeQuery();
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            ps.setInt(2, 5);
            rs = ps.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)2, (int)rs.getInt(1));
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            String query = "select ID1, DESCRIPTION1 from TESTTABLE1 alias1 where alias1.ID1 IN ( Select AVG(alias2.ID2) from Testtable2 alias2 where alias2.ID2 > 222 ) AND 5 = 7";
            rs = s.executeQuery(query);
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            query = "select ID1, DESCRIPTION1 from TESTTABLE1 alias1 where alias1.ID1 > 0 AND alias1.ID1 IN ( Select AVG(alias2.ID2) from Testtable2 alias2 where alias2.ID2 > 1 ) AND 5 = 5";
            rs = s.executeQuery(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)2, (int)rs.getInt(1));
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            SelectQueryInfoInternalsTest.assertTrue((boolean)rs.next());
            SelectQueryInfoInternalsTest.assertEquals((int)2, (int)rs.getInt(1));
            SelectQueryInfoInternalsTest.assertFalse((boolean)rs.next());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug43663() throws Exception {
        String query = " SELECT *   FROM   T1 LEFT JOIN T2 ON (T2.ID2 = 10024) AND (T2.ID1 = T1.ID1)  INNER JOIN T3 ON (T3.ID2 = ?)   WHERE  (T3.ID1 = T1.ID1)    AND  (T1.ID2 = ?) AND   (T1.ID3 != ?) AND ( ((lower(T1.name) LIKE ? OR ? IS NULL)) AND   (((lower(T2.street1) LIKE ? OR ? IS NULL)) OR((lower(T2.street2) LIKE ? OR ? IS NULL)) OR((lower(T2.street3) LIKE ? OR ? IS NULL)) ) AND((lower(T2.city) LIKE ? OR ? IS NULL)) AND((lower(T2.zip) LIKE ? OR ? IS NULL))  )       ORDER BY   T1.ID1 ASC fetch first 10 rows only";
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table T1 (ID1 int not null, ID2 int not null,  name varchar(1024) not null, ID3 int not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        s.execute("create table T2 (ID1 int not null, ID2 int not null,  name varchar(1024) not null, street1 varchar(1024) not null, street2 varchar(1024) not null, street3 varchar(1024) not null, city varchar(1024) not null,zip varchar(1024) not null,primary key (ID1)) partition by column( ID1)  colocate with (T1) ");
        s.execute("create table T3 (ID1 int not null, ID2 int not null ,primary key (ID1)) partition by column( ID1)  colocate with (T1) ");
        try {
            conn.prepareStatement(query);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            SelectQueryInfoInternalsTest.fail(sqle.toString());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug43666_1() throws Exception {
        String query = "SELECT COUNT(DISTINCT articleId) AS COUNT_VALUE FROM JournalArticle WHERE (companyId = ?) AND (groupId = ?) AND ( ((articleId LIKE ? OR ? IS NULL)) AND  ((lower(title) LIKE ? OR ? IS NULL)) AND ((description LIKE ? OR ? IS NULL)) AND ((content LIKE ? OR ? IS NULL)) )";
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table JournalArticle (companyId int not null, groupId int not null,  articleId varchar(1024) not null, title varchar(1024) not null, description varchar(1024) not null ,content varchar(1024) not null, type_ varchar(1024) ,structureId int not null,templateId int not null, displayDate varchar(1024) not null,status varchar(1024) not null, reviewDate varchar(1024) not null,primary key (companyId))");
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private final int index = 0;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                    AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                    TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                    TestCase.assertEquals((int)((JunctionQueryInfo)acqi).getJunctionType(), (int)1);
                    TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                    JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                    List ops = jqi.getOperands();
                    TestCase.assertEquals((int)ops.size(), (int)2);
                    AbstractConditionQueryInfo acqi1 = (AbstractConditionQueryInfo)ops.get(0);
                    AbstractConditionQueryInfo acqi2 = (AbstractConditionQueryInfo)ops.get(1);
                    TestCase.assertTrue((boolean)(acqi1 instanceof ComparisonQueryInfo));
                    TestCase.assertTrue((boolean)(acqi2 instanceof ComparisonQueryInfo));
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug43666_2() throws Exception {
        String query = "SELECT COUNT(DISTINCT articleId) AS COUNT_VALUE FROM JournalArticle WHERE (companyId = ?) AND (groupId = ?) AND ( ((articleId > ? OR groupId > ?)) AND  ((title < ? OR title != ?)) AND ((description =? OR description = ?)) AND ((content = ? OR content = ?)) )";
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table JournalArticle (companyId int not null, groupId int not null,  articleId varchar(1024) not null, title varchar(1024) not null, description varchar(1024) not null ,content varchar(1024) not null, type_ varchar(1024) ,structureId int not null,templateId int not null, displayDate varchar(1024) not null,status varchar(1024) not null, reviewDate varchar(1024) not null,primary key (companyId))");
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private final int index = 0;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                    AbstractConditionQueryInfo acqi = sqi.getWhereClause();
                    TestCase.assertTrue((boolean)(acqi instanceof JunctionQueryInfo));
                    TestCase.assertEquals((int)((JunctionQueryInfo)acqi).getJunctionType(), (int)1);
                    TestCase.assertTrue((boolean)(acqi instanceof AndJunctionQueryInfo));
                    JunctionQueryInfo jqi = (JunctionQueryInfo)acqi;
                    List ops = jqi.getOperands();
                    TestCase.assertEquals((int)4, (int)ops.size());
                    int numCQI = 0;
                    int numIQI = 0;
                    for (AbstractConditionQueryInfo temp : ops) {
                        if (temp instanceof InQueryInfo) {
                            ++numIQI;
                            continue;
                        }
                        if (!(temp instanceof ComparisonQueryInfo)) continue;
                        ++numCQI;
                    }
                    TestCase.assertEquals((int)2, (int)numCQI);
                    TestCase.assertEquals((int)2, (int)numIQI);
                    TestCase.assertEquals((int)2, (int)jqi.children.length);
                    for (JunctionQueryInfo temp : jqi.children) {
                        TestCase.assertEquals((int)2, (int)temp.getJunctionType());
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    public void testBug42623() throws Exception {
        String query = "SELECT tab_b.Id FROM tab_b JOIN tab_c ON (tab_b.OId = tab_c.PAId OR tab_b.OId = tab_c.PBId) LEFT OUTER JOIN tab_a ON tab_b.OId = PId WHERE EXISTS(SELECT 'X' FROM tab_d  WHERE (PAId = 141 AND PBId = tab_b.Id) OR (PBId = 141 AND PAId = tab_b.Id) )  AND EXISTS ( SELECT 'X' FROM tab_v  WHERE OId = tab_b.OId AND UGId = 31 AND val = 'A')";
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("CREATE TABLE tab_b (Id BIGINT NOT NULL PRIMARY KEY, OId BIGINT NOT NULL)");
        s.execute("CREATE TABLE tab_c (Id BIGINT NOT NULL PRIMARY KEY,PAId BIGINT NOT NULL, PBId BIGINT NOT NULL) ");
        s.execute("CREATE TABLE tab_a (PId BIGINT NOT NULL) ");
        s.execute("CREATE TABLE tab_d (Id BIGINT NOT NULL PRIMARY KEY, PAId BIGINT NOT NULL, PBId BIGINT NOT NULL)");
        s.execute("CREATE TABLE tab_v (OId BIGINT NOT NULL, UGId BIGINT NOT NULL, val CHAR(1) NOT NULL)");
        Statement st = conn.createStatement();
        st.executeQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryInfoStructureForBug42673() throws Exception {
        String query = " select * from securities where sec_id IN (select sid from portfolio f where cid = (select c.cid from customers c where  c.cid = f.cid))";
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table customers (cid int not null, cust_name varchar(100),  addr varchar(100), tid int, primary key (cid))");
        s.execute("create table securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, price decimal(30,20),tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  replicate");
        s.execute("create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by column (cid) colocate with (customers)");
        s.execute("create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, status varchar(10) default 'open', tid int, constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict, constraint status_ch check (status in ('cancelled', 'open', 'filled')))  partition by column (cid) colocate with (customers)");
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo && !((DMLQueryInfo)qInfo).isSubQuery()) {
                        SelectQueryInfoInternalsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.hasCorrelatedSubQuery());
                        TestCase.assertEquals((int)sqi.getSubqueryInfoList().size(), (int)1);
                        TestCase.assertTrue((boolean)sqi.isRemoteGfxdSubActivationNeeded());
                    }
                }
            });
            conn.prepareStatement(query);
            SelectQueryInfoInternalsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            s.execute("drop table sellorders");
            s.execute("drop table portfolio");
            s.execute("drop table customers");
            s.execute("drop table securities");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testDebug1() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        GemFireXDQueryObserver old = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            java.sql.ResultSet rs = dbmd.getCatalogs();
            while (rs.next()) {
                System.out.println("..");
            }
            rs = dbmd.getSchemas();
            while (rs.next()) {
                System.out.println("..");
            }
            rs = dbmd.getProcedures(null, null, null);
            while (rs.next()) {
                System.out.println("..");
            }
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testDebug2() throws Exception {
        Connection conn = SelectQueryInfoInternalsTest.getConnection();
        String query = "EXECUTE STATEMENT SYS.\"getCrossReference\"";
        GemFireXDQueryObserver old = null;
        try {
            String[] types = new String[]{"TABLE"};
            conn.getMetaData().getTables(null, null, null, types);
            conn.prepareStatement(query);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    private boolean validateComparisonQueryInfo(ComparisonQueryInfo cqi, int indx) {
        boolean ok = false;
        switch (indx) {
            default: 
        }
        ok = true;
        return ok;
    }

    private boolean validateJunctionQueryInfo(JunctionQueryInfo jqi, int indx) {
        boolean ok = false;
        switch (indx) {
            case 2: {
                SelectQueryInfoInternalsTest.assertEquals((int)jqi.getJunctionType(), (int)1);
                SelectQueryInfoInternalsTest.assertTrue((boolean)(jqi instanceof AndJunctionQueryInfo));
                List ops = jqi.getOperands();
                SelectQueryInfoInternalsTest.assertEquals((int)ops.size(), (int)3);
                AbstractConditionQueryInfo acqi1 = (AbstractConditionQueryInfo)ops.get(0);
                AbstractConditionQueryInfo acqi2 = (AbstractConditionQueryInfo)ops.get(1);
                AbstractConditionQueryInfo acqi3 = (AbstractConditionQueryInfo)ops.get(2);
                SelectQueryInfoInternalsTest.assertTrue((boolean)(acqi1 instanceof ComparisonQueryInfo));
                SelectQueryInfoInternalsTest.assertTrue((boolean)(acqi2 instanceof ComparisonQueryInfo));
                SelectQueryInfoInternalsTest.assertTrue((boolean)(acqi3 instanceof ComparisonQueryInfo));
                ok = true;
                break;
            }
            default: {
                ok = true;
            }
        }
        return ok;
    }

    public void createTableWithPrimaryKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createTableWithCompositeKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100), Primary Key (id, cust_name))");
        s.close();
    }

    public void createTable(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int not null , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public static void createTableWithThreeCompositeKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100), Primary Key (id, cust_name,vol))");
        s.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.callbackInvoked = false;
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
        super.tearDown();
    }
}

