/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.cache.Region;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QueryInfoTest
extends JdbcTestBase {
    private boolean callbackInvoked = false;

    public QueryInfoTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(QueryInfoTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testConvertibleToGet_1() throws SQLException, StandardException {
        Connection conn = QueryInfoTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        String[] queries = new String[]{"Select * from orders where id =8", "Select id, cust_name, vol, security_id, num, addr from orders where id =8", "Select  id, cust_name, vol, security_id, num, addr  from orders where id > 8", "Select id as id, cust_name as cust_name, vol, security_id, num, addr from orders where id =8"};
        final boolean[] getConvertibles = new boolean[]{true, true, false, true};
        RegionKey gfk = QueryInfoTest.getGemFireKey(8, Misc.getRegionForTable((String)(QueryInfoTest.getCurrentDefaultSchemaName() + ".ORDERS"), (boolean)true));
        final Object[] primaryKeys = new Object[]{gfk, gfk, null, gfk};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;
                private DynamicKey dk = null;
                private QueryInfo qi;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    QueryInfoTest.this.callbackInvoked = true;
                    try {
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        TestCase.assertTrue((qInfo.isPrimaryKeyBased() == getConvertibles[this.index] ? 1 : 0) != 0);
                        try {
                            TestCase.assertTrue((qInfo.createGFEActivation() == qInfo.isPrimaryKeyBased() ? 1 : 0) != 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                        this.dk = (DynamicKey)qInfo.getPrimaryKey();
                        TestCase.assertNotNull((Object)qInfo.getRegion());
                        this.qi = qInfo;
                    }
                    catch (StandardException se) {
                        TestUtil.fail("Test failed becaus eof exception=" + (Object)((Object)se));
                    }
                }

                public void beforeQueryExecution(EmbedStatement stmt, Activation activation) {
                    try {
                        if (primaryKeys[this.index] == null) {
                            TestCase.assertTrue((this.dk == null ? 1 : 0) != 0);
                        } else {
                            QueryInfoTest.this.validatePrimaryKey(this.dk.getEvaluatedPrimaryKey(activation, (GemFireContainer)this.qi.getRegion().getUserAttribute(), false), primaryKeys[this.index]);
                        }
                        ++this.index;
                    }
                    catch (StandardException e) {
                        TestUtil.fail("Unexpected exception while validating key " + (Object)((Object)e));
                    }
                }
            });
            Statement s = conn.createStatement();
            for (int i = 0; i < queries.length; ++i) {
                try {
                    s.executeQuery(queries[i]);
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + queries[i], e);
                }
            }
            QueryInfoTest.assertTrue((boolean)this.callbackInvoked);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testPreparedStatementConvertibleToGet_1() throws SQLException, StandardException {
        Connection conn = QueryInfoTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        final boolean[] usedGemFireXDActivation = new boolean[]{false, false, false, false};
        String[] queries = new String[]{"Select * from orders where id =?", "Select id, cust_name, vol, security_id, num, addr from orders where id =?", "Select  id, cust_name, vol, security_id, num, addr  from orders where id > ?", "Select id as id, cust_name as cust_name, vol, security_id, num, addr from orders where id =?"};
        final boolean[] getConvertibles = new boolean[]{true, true, false, true};
        RegionKey gfk = QueryInfoTest.getGemFireKey(8, Misc.getRegionForTable((String)(QueryInfoTest.getCurrentDefaultSchemaName() + ".ORDERS"), (boolean)true));
        final Object[] primaryKeys = new Object[]{gfk, gfk, null, gfk};
        GemFireXDQueryObserver old = null;
        try {
            int i;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;
                private DynamicKey dk = null;
                private QueryInfo qi;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    QueryInfoTest.this.callbackInvoked = true;
                    try {
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        TestCase.assertTrue((qInfo.isPrimaryKeyBased() == getConvertibles[this.index] ? 1 : 0) != 0);
                        if (getConvertibles[this.index]) {
                            TestCase.assertTrue((boolean)(qInfo.getPrimaryKey() instanceof DynamicKey));
                            this.dk = (DynamicKey)qInfo.getPrimaryKey();
                        } else {
                            this.dk = null;
                        }
                        TestCase.assertNotNull((Object)qInfo.getRegion());
                        ++this.index;
                        this.qi = qInfo;
                    }
                    catch (StandardException se) {
                        TestUtil.fail("Test failed becaus eof exception=" + (Object)((Object)se));
                    }
                }

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                    usedGemFireXDActivation[this.index - 1] = true;
                    try {
                        TestCase.assertEquals((Object)primaryKeys[this.index - 1], (Object)this.dk.getEvaluatedPrimaryKey((Activation)activation, (GemFireContainer)this.qi.getRegion().getUserAttribute(), false));
                    }
                    catch (StandardException se) {
                        TestUtil.fail("Test failed because of exception=" + (Object)((Object)se));
                    }
                }
            });
            for (i = 0; i < queries.length; ++i) {
                PreparedStatement s = conn.prepareStatement(queries[i]);
                try {
                    s.setInt(1, 8);
                    s.executeQuery();
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + queries[i], e.getSQLState());
                }
            }
            for (i = 0; i < queries.length; ++i) {
                QueryInfoTest.assertTrue((usedGemFireXDActivation[i] == getConvertibles[i] ? 1 : 0) != 0);
            }
            QueryInfoTest.assertTrue((boolean)this.callbackInvoked);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testConvertibleToGet_2() throws SQLException, StandardException {
        Connection conn = QueryInfoTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        String[] queries = new String[]{"Select id as id1, cust_name , vol, security_id, num, addr from orders where id =8", "Select id as id, id ,id, id, id, id from orders where id =8", "Select id , vol, cust_name , security_id, num, addr from orders where id =8"};
        final boolean[] getConvertibles = new boolean[]{true, true, true};
        RegionKey gfk = QueryInfoTest.getGemFireKey(8, Misc.getRegionForTable((String)(QueryInfoTest.getCurrentDefaultSchemaName() + ".ORDERS"), (boolean)true));
        final Object[] primaryKeys = new Object[]{gfk, gfk, gfk};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;
                private DynamicKey dk = null;
                private QueryInfo qi;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    QueryInfoTest.this.callbackInvoked = true;
                    try {
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        TestCase.assertTrue((qInfo.isPrimaryKeyBased() == getConvertibles[this.index] ? 1 : 0) != 0);
                        try {
                            TestCase.assertTrue((qInfo.createGFEActivation() == qInfo.isPrimaryKeyBased() ? 1 : 0) != 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                        this.dk = (DynamicKey)qInfo.getPrimaryKey();
                        TestCase.assertNotNull((Object)qInfo.getRegion());
                        this.qi = qInfo;
                    }
                    catch (StandardException se) {
                        TestUtil.fail("Test failed becaus eof exception=" + (Object)((Object)se));
                    }
                }

                public void beforeQueryExecution(EmbedStatement stmt, Activation activation) {
                    try {
                        if (primaryKeys[this.index] == null) {
                            TestCase.assertTrue((this.dk == null ? 1 : 0) != 0);
                        } else {
                            QueryInfoTest.this.validatePrimaryKey(this.dk.getEvaluatedPrimaryKey(activation, (GemFireContainer)this.qi.getRegion().getUserAttribute(), false), primaryKeys[this.index]);
                        }
                        ++this.index;
                    }
                    catch (StandardException e) {
                        TestUtil.fail("Unexpected exception while validating key " + (Object)((Object)e));
                    }
                }
            });
            Statement s = conn.createStatement();
            for (int i = 0; i < queries.length; ++i) {
                try {
                    s.executeQuery(queries[i]);
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + queries[i], e.getSQLState());
                }
            }
            QueryInfoTest.assertTrue((boolean)this.callbackInvoked);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testPreparedStatementConvertibleToGetForCompositeKeys() throws SQLException, IOException, StandardException {
        Connection conn = QueryInfoTest.getConnection();
        this.createTableWithCompositeKey(conn);
        final boolean[] usedGemFireXDActivation = new boolean[]{false, true};
        String[] queries = new String[]{"Select * from orders where id =?", "Select * from orders where id =? and cust_name= ?"};
        Region tableRegion = Misc.getRegionForTable((String)(QueryInfoTest.getCurrentDefaultSchemaName() + ".orders".toUpperCase()), (boolean)true);
        GemFireContainer container = (GemFireContainer)tableRegion.getUserAttribute();
        CompactCompositeRegionKey gfk = new CompactCompositeRegionKey(new DataValueDescriptor[]{new SQLInteger(8), new SQLVarchar("asif")}, container.getExtraTableInfo());
        final boolean[] getConvertibles = new boolean[]{false, true};
        final Object[] primaryKeys = new Object[]{null, gfk};
        GemFireXDQueryObserver old = null;
        try {
            int i;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;
                private DynamicKey dk = null;
                private QueryInfo qi;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    QueryInfoTest.this.callbackInvoked = true;
                    try {
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        TestCase.assertTrue((qInfo.isPrimaryKeyBased() == getConvertibles[this.index] ? 1 : 0) != 0);
                        if (getConvertibles[this.index]) {
                            TestCase.assertTrue((boolean)(qInfo.getPrimaryKey() instanceof DynamicKey));
                            this.dk = (DynamicKey)qInfo.getPrimaryKey();
                        } else {
                            this.dk = null;
                        }
                        TestCase.assertNotNull((Object)qInfo.getRegion());
                        ++this.index;
                        this.qi = qInfo;
                    }
                    catch (StandardException se) {
                        TestUtil.fail("Test failed becaus eof exception=" + (Object)((Object)se));
                    }
                }

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                    usedGemFireXDActivation[this.index - 1] = true;
                    try {
                        QueryInfoTest.this.validatePrimaryKey(primaryKeys[this.index - 1], this.dk.getEvaluatedPrimaryKey((Activation)activation, (GemFireContainer)this.qi.getRegion().getUserAttribute(), false));
                    }
                    catch (StandardException se) {
                        TestUtil.fail("Test failed because of exception=" + (Object)((Object)se));
                    }
                }
            });
            for (i = 0; i < queries.length; ++i) {
                PreparedStatement s = conn.prepareStatement(queries[i]);
                s.setInt(1, 8);
                if (i == 1) {
                    s.setString(2, "asif");
                }
                s.executeQuery();
            }
            for (i = 0; i < queries.length; ++i) {
                QueryInfoTest.assertTrue((usedGemFireXDActivation[i] == getConvertibles[i] ? 1 : 0) != 0);
            }
            QueryInfoTest.assertTrue((boolean)this.callbackInvoked);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testConvertibleToGetForCompositeKeys() throws SQLException, IOException, StandardException {
        Connection conn = QueryInfoTest.getConnection();
        this.createTableWithCompositeKey(conn);
        String[] queries = new String[]{"Select * from orders where id =8", "Select * from orders where id =8 and cust_name='asif'"};
        final boolean[] getConvertibles = new boolean[]{false, true};
        Region tableRegion = Misc.getRegionForTable((String)(QueryInfoTest.getCurrentDefaultSchemaName() + ".orders".toUpperCase()), (boolean)true);
        CompactCompositeRegionKey gfk = new CompactCompositeRegionKey(new DataValueDescriptor[]{new SQLInteger(8), new SQLVarchar("asif")}, ((GemFireContainer)tableRegion.getUserAttribute()).getExtraTableInfo());
        final Object[] primaryKeys = new Object[]{null, gfk};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;
                private DynamicKey dk = null;
                private QueryInfo qi;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    QueryInfoTest.this.callbackInvoked = true;
                    try {
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        TestCase.assertTrue((qInfo.isPrimaryKeyBased() == getConvertibles[this.index] ? 1 : 0) != 0);
                        try {
                            TestCase.assertTrue((qInfo.createGFEActivation() == qInfo.isPrimaryKeyBased() ? 1 : 0) != 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail(e.toString());
                        }
                        this.dk = (DynamicKey)qInfo.getPrimaryKey();
                        TestCase.assertNotNull((Object)qInfo.getRegion());
                        this.qi = qInfo;
                    }
                    catch (StandardException se) {
                        TestUtil.fail("Test failed becaus eof exception=" + (Object)((Object)se));
                    }
                }

                public void beforeQueryExecution(EmbedStatement stmt, Activation activation) {
                    try {
                        if (primaryKeys[this.index] == null) {
                            TestCase.assertTrue((this.dk == null ? 1 : 0) != 0);
                        } else {
                            QueryInfoTest.this.validatePrimaryKey(this.dk.getEvaluatedPrimaryKey(activation, (GemFireContainer)this.qi.getRegion().getUserAttribute(), false), primaryKeys[this.index]);
                        }
                        ++this.index;
                    }
                    catch (StandardException e) {
                        TestUtil.fail("Unexpected exception while validating key " + (Object)((Object)e));
                    }
                }
            });
            Statement s = conn.createStatement();
            for (int i = 0; i < queries.length; ++i) {
                try {
                    s.executeQuery(queries[i]);
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + queries[i], e.getSQLState());
                }
            }
            QueryInfoTest.assertTrue((boolean)this.callbackInvoked);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInconvertibleToGetQuery() throws Exception {
        Connection conn = QueryInfoTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        String[] queries = new String[]{"Select * from orders where id > 8"};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private int index = 0;

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    QueryInfoTest.this.callbackInvoked = true;
                    TestCase.assertNotNull((Object)qInfo.getRegion());
                    ++this.index;
                }
            });
            Statement s = conn.createStatement();
            for (int i = 0; i < queries.length; ++i) {
                try {
                    s.executeQuery(queries[i]);
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + queries[i], e.getSQLState());
                }
            }
            QueryInfoTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    private void validatePrimaryKey(Object actual, Object expected) {
        if (expected instanceof byte[]) {
            QueryInfoTest.assertTrue((boolean)(actual instanceof byte[]));
            byte[] act = (byte[])actual;
            byte[] expct = (byte[])expected;
            QueryInfoTest.assertTrue((act.length == expct.length ? 1 : 0) != 0);
            for (int i = 0; i < act.length; ++i) {
                QueryInfoTest.assertEquals((byte)act[i], (byte)expct[i]);
            }
        } else {
            QueryInfoTest.assertEquals((String)("got: " + actual), (Object)actual, (Object)expected);
        }
    }

    public void createTableWithPrimaryKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createTableWithCompositeKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100), Primary Key (id, cust_name))");
        s.close();
    }

    public void testSortLogic() {
        int[] test1 = new int[]{0, 1, 2, 3};
        this.sort(test1);
        for (int i = 0; i < 4; ++i) {
            QueryInfoTest.assertEquals((int)i, (int)test1[i]);
        }
        int[] test2 = new int[]{0};
        this.sort(test2);
        for (int i = 0; i < 1; ++i) {
            QueryInfoTest.assertEquals((int)i, (int)test2[i]);
        }
        int[] test3 = new int[]{0, 1};
        this.sort(test3);
        for (int i = 0; i < 2; ++i) {
            QueryInfoTest.assertEquals((int)i, (int)test3[i]);
        }
        int[] test4 = new int[]{1, 0};
        this.sort(test4);
        for (int i = 0; i < 2; ++i) {
            QueryInfoTest.assertEquals((int)i, (int)test4[i]);
        }
        int[] test5 = new int[]{1, 2, 0};
        this.sort(test5);
        for (int i = 0; i < 3; ++i) {
            QueryInfoTest.assertEquals((int)i, (int)test5[i]);
        }
        int[] test6 = new int[]{1, 2, 0, 5, 4, 3, 9, 6, 7, 8};
        this.sort(test6);
        for (int i = 0; i < 10; ++i) {
            QueryInfoTest.assertEquals((int)i, (int)test6[i]);
        }
    }

    private void sort(int[] test) {
        int len = test.length;
        block0: for (int j = 0; j < len; ++j) {
            int toSort = test[j];
            for (int i = j - 1; i > -1; --i) {
                int currSorted = test[i];
                if (currSorted < toSort) {
                    if (i + 1 == j) continue block0;
                    test[i + 1] = toSort;
                    continue block0;
                }
                test[i + 1] = currSorted;
                if (i != 0) continue;
                test[0] = toSort;
            }
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.callbackInvoked = false;
        super.tearDown();
    }
}

