/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PreparedStatementTest
extends JdbcTestBase {
    private boolean callbackInvoked = false;
    private int index = 0;

    public PreparedStatementTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(PreparedStatementTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionGetMultipleTimesWithPrepStmnt() throws SQLException {
        Connection conn = PreparedStatementTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        String query = "Select * from orders where id =?";
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private AbstractGemFireActivation origAct = null;

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                    if (PreparedStatementTest.this.index == 0) {
                        this.origAct = activation;
                    } else {
                        TestCase.assertEquals((Object)activation, (Object)this.origAct);
                    }
                    ++PreparedStatementTest.this.index;
                }

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    PreparedStatementTest.this.callbackInvoked = true;
                }
            });
            conn = PreparedStatementTest.getConnection();
            int numExecution = 5;
            PreparedStatement ps = conn.prepareStatement(query);
            for (int i = 0; i < 5; ++i) {
                try {
                    ps.setInt(1, i);
                    ps.executeQuery();
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
                }
            }
            PreparedStatementTest.assertTrue((boolean)this.callbackInvoked);
            PreparedStatementTest.assertEquals((int)5, (int)this.index);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void createTableWithPrimaryKey(Connection conn) throws SQLException {
        PreparedStatement s = conn.prepareStatement("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.execute();
        s = conn.prepareStatement("select * from orders where id=1");
        s.execute();
        PreparedStatementTest.assertEquals((int)0, (int)s.getParameterMetaData().getParameterCount());
        s.close();
    }

    public void createTableWithCompositeKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100), Primary Key (id, cust_name))");
        s.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.callbackInvoked = false;
        this.index = 0;
        super.tearDown();
    }
}

