/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireSelectActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GlobalIndexTest
extends JdbcTestBase {
    private boolean callbackInvoked = false;

    public GlobalIndexTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(GlobalIndexTest.class));
    }

    @Override
    public void tearDown() throws Exception {
        this.callbackInvoked = false;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGlobalIndexCaching_selectToGet() throws Exception {
        block6: {
            GemFireXDQueryObserver old = null;
            try {
                System.setProperty("gemfirexd.cacheGlobalIndex", "true");
                Properties props1 = new Properties();
                int mport = AvailablePort.getRandomAvailablePort((int)1);
                props1.put("mcast-port", String.valueOf(mport));
                Connection conn = TestUtil.getConnection(props1);
                Statement s = conn.createStatement();
                s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(address)");
                String query = "select ID, DESCRIPTION from TESTTABLE where ID = 1";
                LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
                final Object[] robjsArr = new Object[2];
                final Object[] gIdkKeys = new Object[2];
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void afterPuttingInCached(Serializable globalIndexKey, Object result) {
                        robjsArr[0] = result;
                        gIdkKeys[0] = globalIndexKey;
                    }

                    public void beforeReturningCachedVal(Serializable globalIndexKey, Object cachedVal) {
                        robjsArr[1] = cachedVal;
                        gIdkKeys[1] = globalIndexKey;
                    }
                });
                for (int i = 0; i < 1; ++i) {
                    s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
                }
                try {
                    ResultSet rs = s.executeQuery(query);
                    GlobalIndexTest.assertTrue((boolean)rs.next());
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + query, e);
                }
                GlobalIndexTest.assertNotNull((Object)robjsArr[0]);
                GlobalIndexTest.assertNotNull((Object)gIdkKeys[0]);
                GlobalIndexTest.assertEquals((Object)robjsArr[0], (Object)robjsArr[1]);
                GlobalIndexTest.assertEquals((Object)gIdkKeys[0], (Object)gIdkKeys[1]);
                System.out.println("robjsArr[0]=" + robjsArr[0]);
                System.out.println("gIdkKeys[0]=" + gIdkKeys[0]);
                if (old == null) break block6;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.clearProperty("gemfirexd.cacheGlobalIndex");
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.clearProperty("gemfirexd.cacheGlobalIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGlobalIndexCaching_selectToGetPS() throws Exception {
        block6: {
            GemFireXDQueryObserver old = null;
            try {
                System.setProperty("gemfirexd.cacheGlobalIndex", "true");
                Properties props1 = new Properties();
                int mport = AvailablePort.getRandomAvailablePort((int)1);
                props1.put("mcast-port", String.valueOf(mport));
                Connection conn = TestUtil.getConnection(props1);
                Statement s = conn.createStatement();
                s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(address)");
                String query = "select ID, DESCRIPTION from TESTTABLE where ID = ?";
                LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
                final Object[] robjsArr = new Object[2];
                final Object[] gIdkKeys = new Object[2];
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void afterPuttingInCached(Serializable globalIndexKey, Object result) {
                        robjsArr[0] = result;
                        gIdkKeys[0] = globalIndexKey;
                    }

                    public void beforeReturningCachedVal(Serializable globalIndexKey, Object cachedVal) {
                        robjsArr[1] = cachedVal;
                        gIdkKeys[1] = globalIndexKey;
                    }
                });
                for (int i = 0; i < 1; ++i) {
                    s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
                }
                try {
                    PreparedStatement ps = conn.prepareStatement(query);
                    ps.setInt(1, 1);
                    ResultSet rs = ps.executeQuery();
                    GlobalIndexTest.assertTrue((boolean)rs.next());
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + query, e);
                }
                GlobalIndexTest.assertNotNull((Object)robjsArr[0]);
                GlobalIndexTest.assertNotNull((Object)gIdkKeys[0]);
                GlobalIndexTest.assertEquals((Object)robjsArr[0], (Object)robjsArr[1]);
                GlobalIndexTest.assertEquals((Object)gIdkKeys[0], (Object)gIdkKeys[1]);
                System.out.println("robjsArr[0]=" + robjsArr[0]);
                System.out.println("gIdkKeys[0]=" + gIdkKeys[0]);
                if (old == null) break block6;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.clearProperty("gemfirexd.cacheGlobalIndex");
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.clearProperty("gemfirexd.cacheGlobalIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGlobalIndexCaching_selectToFuncExn() throws Exception {
        block6: {
            GemFireXDQueryObserver old = null;
            try {
                System.setProperty("gemfirexd.cacheGlobalIndex", "true");
                Properties props1 = new Properties();
                int mport = AvailablePort.getRandomAvailablePort((int)1);
                props1.put("mcast-port", String.valueOf(mport));
                Connection conn = TestUtil.getConnection(props1);
                Statement s = conn.createStatement();
                s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(address)");
                String query = "select ID, DESCRIPTION from TESTTABLE where ID = 1 and DESCRIPTION = 'First1'";
                final Object[] robjsArr = new Object[2];
                final Object[] gIdkKeys = new Object[2];
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void afterPuttingInCached(Serializable globalIndexKey, Object result) {
                        robjsArr[0] = result;
                        gIdkKeys[0] = globalIndexKey;
                    }

                    public void beforeReturningCachedVal(Serializable globalIndexKey, Object cachedVal) {
                        robjsArr[1] = cachedVal;
                        gIdkKeys[1] = globalIndexKey;
                    }
                });
                for (int i = 0; i < 1; ++i) {
                    s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
                }
                try {
                    ResultSet rs = s.executeQuery(query);
                    GlobalIndexTest.assertTrue((boolean)rs.next());
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + query, e);
                }
                GlobalIndexTest.assertNotNull((Object)robjsArr[0]);
                GlobalIndexTest.assertNotNull((Object)gIdkKeys[0]);
                GlobalIndexTest.assertEquals((Object)robjsArr[0], (Object)robjsArr[1]);
                GlobalIndexTest.assertEquals((Object)gIdkKeys[0], (Object)gIdkKeys[1]);
                System.out.println("robjsArr[0]=" + robjsArr[0]);
                System.out.println("gIdkKeys[0]=" + gIdkKeys[0]);
                if (old == null) break block6;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.clearProperty("gemfirexd.cacheGlobalIndex");
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.clearProperty("gemfirexd.cacheGlobalIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGlobalIndexCaching_updateToFuncExn() throws Exception {
        block6: {
            GemFireXDQueryObserver old = null;
            try {
                System.setProperty("gemfirexd.cacheGlobalIndex", "true");
                Properties props1 = new Properties();
                int mport = AvailablePort.getRandomAvailablePort((int)1);
                props1.put("mcast-port", String.valueOf(mport));
                Connection conn = TestUtil.getConnection(props1);
                Statement s = conn.createStatement();
                s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(address)");
                String query = "update TESTTABLE set description = 'somed' where ID = 1 and DESCRIPTION = 'First1'";
                final Object[] robjsArr = new Object[2];
                final Object[] gIdkKeys = new Object[2];
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void afterPuttingInCached(Serializable globalIndexKey, Object result) {
                        robjsArr[0] = result;
                        gIdkKeys[0] = globalIndexKey;
                    }

                    public void beforeReturningCachedVal(Serializable globalIndexKey, Object cachedVal) {
                        robjsArr[1] = cachedVal;
                        gIdkKeys[1] = globalIndexKey;
                    }
                });
                for (int i = 0; i < 1; ++i) {
                    s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
                }
                try {
                    int cnt = s.executeUpdate(query);
                    GlobalIndexTest.assertEquals((int)1, (int)cnt);
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + query, e);
                }
                GlobalIndexTest.assertNotNull((Object)robjsArr[0]);
                GlobalIndexTest.assertNotNull((Object)gIdkKeys[0]);
                GlobalIndexTest.assertEquals((Object)robjsArr[0], (Object)robjsArr[1]);
                GlobalIndexTest.assertEquals((Object)gIdkKeys[0], (Object)gIdkKeys[1]);
                System.out.println("robjsArr[0]=" + robjsArr[0]);
                System.out.println("gIdkKeys[0]=" + gIdkKeys[0]);
                if (old == null) break block6;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.clearProperty("gemfirexd.cacheGlobalIndex");
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.clearProperty("gemfirexd.cacheGlobalIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGlobalIndexCaching_deleteToFuncExn() throws Exception {
        block6: {
            GemFireXDQueryObserver old = null;
            try {
                System.setProperty("gemfirexd.cacheGlobalIndex", "true");
                Properties props1 = new Properties();
                int mport = AvailablePort.getRandomAvailablePort((int)1);
                props1.put("mcast-port", String.valueOf(mport));
                Connection conn = TestUtil.getConnection(props1);
                Statement s = conn.createStatement();
                s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(address)");
                String query = "delete from TESTTABLE where ID = 1 and DESCRIPTION = 'First1'";
                final Object[] robjsArr = new Object[2];
                final Object[] gIdkKeys = new Object[2];
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void afterPuttingInCached(Serializable globalIndexKey, Object result) {
                        robjsArr[0] = result;
                        gIdkKeys[0] = globalIndexKey;
                    }

                    public void beforeReturningCachedVal(Serializable globalIndexKey, Object cachedVal) {
                        robjsArr[1] = cachedVal;
                        gIdkKeys[1] = globalIndexKey;
                    }
                });
                for (int i = 0; i < 1; ++i) {
                    s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
                }
                try {
                    int cnt = s.executeUpdate(query);
                    GlobalIndexTest.assertEquals((int)1, (int)cnt);
                }
                catch (SQLException e) {
                    throw new SQLException(e.toString() + " Exception in executing query = " + query, e);
                }
                GlobalIndexTest.assertNotNull((Object)robjsArr[0]);
                GlobalIndexTest.assertNotNull((Object)gIdkKeys[0]);
                GlobalIndexTest.assertEquals((Object)robjsArr[0], (Object)robjsArr[1]);
                GlobalIndexTest.assertEquals((Object)gIdkKeys[0], (Object)gIdkKeys[1]);
                System.out.println("robjsArr[0]=" + robjsArr[0]);
                System.out.println("gIdkKeys[0]=" + gIdkKeys[0]);
                if (old == null) break block6;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.clearProperty("gemfirexd.cacheGlobalIndex");
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.clearProperty("gemfirexd.cacheGlobalIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingGlobalIndex_2() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = GlobalIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID), unique( DESCRIPTION,ADDRESS))");
        String query = "select ID, DESCRIPTION from TESTTABLE where ADDRESS = 'abc2' AND DESCRIPTION = 'First2'";
        for (int i = 0; i < 7; ++i) {
            s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
        }
        LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectAfterPreparedStatementCompletion(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        GlobalIndexTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                        actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                        try {
                            GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                            ((BaseActivation)act).initFromContext(lcc, true, (ExecPreparedStatement)gps);
                            sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                            TestCase.assertEquals((int)actualRoutingKeys.size(), (int)1);
                            TestCase.assertTrue((boolean)actualRoutingKeys.contains(2));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail("test failed because of exception=" + e.toString());
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e);
            }
            GlobalIndexTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingGlobalIndex_3() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = GlobalIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))");
        s.execute("CREATE  GLOBAL HASH  INDEX address_description_global ON TESTTABLE ( ADDRESS, DESCRIPTION)");
        String query = "select ID, DESCRIPTION from TESTTABLE where ADDRESS = 'abc2' AND DESCRIPTION = 'First2'";
        for (int i = 0; i < 7; ++i) {
            s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
        }
        LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectAfterPreparedStatementCompletion(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        GlobalIndexTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                        actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                        try {
                            GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                            ((BaseActivation)act).initFromContext(lcc, true, (ExecPreparedStatement)gps);
                            sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                            TestCase.assertEquals((int)actualRoutingKeys.size(), (int)1);
                            TestCase.assertTrue((boolean)actualRoutingKeys.contains(2));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail("test failed because of exception=" + e.toString());
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            GlobalIndexTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingGlobalIndex_1() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = GlobalIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID), unique(ADDRESS))");
        String query = "select ID, DESCRIPTION from TESTTABLE where ADDRESS = 'abc2'";
        for (int i = 0; i < 7; ++i) {
            s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
        }
        LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectAfterPreparedStatementCompletion(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        GlobalIndexTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                        actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                        try {
                            GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                            ((BaseActivation)act).initFromContext(lcc, true, (ExecPreparedStatement)gps);
                            sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                            TestCase.assertEquals((int)actualRoutingKeys.size(), (int)1);
                            TestCase.assertTrue((boolean)actualRoutingKeys.contains(2));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail("test failed because of exception=" + e.toString());
                        }
                    }
                }
            });
            s.executeQuery(query);
            GlobalIndexTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingGlobalIndex_4_Bug39956() throws Exception {
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        Connection conn = GlobalIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ID_1 int not null, primary key (ID), unique(ID_1))");
        String query = "select ID, DESCRIPTION from TESTTABLE where ID_1  >= 3";
        for (int i = 0; i < 7; ++i) {
            s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "'," + (i + 1) + ")");
        }
        LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectAfterPreparedStatementCompletion(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        GlobalIndexTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                        actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                        try {
                            GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                            ((BaseActivation)act).initFromContext(lcc, true, (ExecPreparedStatement)gps);
                            sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                            TestCase.assertEquals((int)actualRoutingKeys.size(), (int)1);
                            TestCase.assertTrue((boolean)actualRoutingKeys.contains(ResolverUtils.TOK_ALL_NODES));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestUtil.fail("test failed because of exception=" + e.toString());
                        }
                    }
                }
            });
            try {
                s.executeQuery(query);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + query, e.getSQLState());
            }
            GlobalIndexTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
    }
}

