/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.NodesPruningHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateDistributionActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import junit.framework.TestCase;

public class UpdateStatementDUnit
extends DistributedSQLTestBase {
    static volatile boolean isQueryExecutedOnNode = false;

    public UpdateStatementDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicNodePruningNoPrimaryKey() throws Exception {
        try {
            this.startServerVMs(3, 0, "SG1");
            this.startClientVMs(1, 0, null);
            String updateQuery = "Update EMP.TESTTABLE set ADDRESS = 'gemstone' where ID > 0 AND ID < 3";
            this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null ) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 0 and 3, VALUES BETWEEN  3 and 6 , VALUES BETWEEN 6 and  +Infinity )" + this.getOverflowSuffix());
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "')");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStore();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            NodesPruningHelper.setupObserverOnClient(qi);
            TestUtil.setupConnection();
            EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            int n = es.executeUpdate(updateQuery);
            UpdateStatementDUnit.assertEquals((int)2, (int)n);
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(0), Boolean.FALSE, new SQLInteger(3), Boolean.FALSE}};
            Set<DistributedMember> expectedNodesToUpdate = NodesPruningHelper.getExpectedNodes(updateQuery, qi[0], routingInfo, this.getLogWriter());
            Set allNodes = ((PartitionedRegion)qi[0].getRegion()).getRegionAdvisor().adviseDataStore();
            SerializableRunnable validateNoQuerySend = UpdateStatementDUnit.getQueryNonExecutionValidator();
            SerializableRunnable validateQuerySend = UpdateStatementDUnit.getQueryExecutionValidator();
            this.executeOnVMs(expectedNodesToUpdate, validateQuerySend);
            allNodes.removeAll(expectedNodesToUpdate);
            this.executeOnVMs(allNodes, validateNoQuerySend);
            ResultSet rs = es.executeQuery("Select ID, ADDRESS from EMP.TESTTABLE");
            while (rs.next()) {
                if (rs.getInt(1) > 0 && rs.getInt(1) < 3) {
                    UpdateStatementDUnit.assertEquals((String)rs.getString(2), (String)"gemstone");
                    continue;
                }
                UpdateStatementDUnit.assertFalse((boolean)rs.getString(2).equals("gemstone"));
            }
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicNodePruningWithPrimaryKey() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        String updateQuery = "Update EMP.TESTTABLE set ADDRESS = 'gemstone' where ID > 0 AND ID < 3";
        this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null) PARTITION BY RANGE ( ID ) (VALUES BETWEEN 0 and 3, VALUES BETWEEN 3 and 6, VALUES BETWEEN 6 and +Infinity)" + this.getOverflowSuffix());
        try {
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "')");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStore();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            NodesPruningHelper.setupObserverOnClient(qi);
            TestUtil.setupConnection();
            EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            int n = es.executeUpdate(updateQuery);
            UpdateStatementDUnit.assertEquals((int)2, (int)n);
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(0), Boolean.FALSE, new SQLInteger(3), Boolean.FALSE}};
            Set<DistributedMember> expectedNodesToUpdate = NodesPruningHelper.getExpectedNodes(updateQuery, qi[0], routingInfo, this.getLogWriter());
            Set allNodes = ((PartitionedRegion)qi[0].getRegion()).getRegionAdvisor().adviseDataStore();
            SerializableRunnable validateNoQuerySend = UpdateStatementDUnit.getQueryNonExecutionValidator();
            SerializableRunnable validateQuerySend = UpdateStatementDUnit.getQueryExecutionValidator();
            this.executeOnVMs(expectedNodesToUpdate, validateQuerySend);
            allNodes.removeAll(expectedNodesToUpdate);
            this.executeOnVMs(allNodes, validateNoQuerySend);
            ResultSet rs = es.executeQuery("Select ID, ADDRESS from EMP.TESTTABLE");
            while (rs.next()) {
                if (rs.getInt(1) > 0 && rs.getInt(1) < 3) {
                    UpdateStatementDUnit.assertEquals((String)rs.getString(2), (String)"gemstone");
                    continue;
                }
                UpdateStatementDUnit.assertFalse((boolean)rs.getString(2).equals("gemstone"));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateMissPrimaryKey() throws Exception {
        try {
            this.startVMs(1, 3);
            String updateQuery = "Update EMP.TESTTABLE set ADDRESS = 'gemstone' where ID = ?";
            this.clientSQLExecute(1, "create schema EMP");
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null ) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 0 and 3, VALUES BETWEEN  3 and 6 , VALUES BETWEEN 6 and  +Infinity )" + this.getOverflowSuffix());
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "')");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStore();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            NodesPruningHelper.setupObserverOnClient(qi);
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(updateQuery);
            this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, EntryNotFoundException.class);
            try {
                for (int i = 42; i <= 420; i += 42) {
                    ps.setInt(1, i);
                    int n = ps.executeUpdate();
                    UpdateStatementDUnit.assertEquals((int)0, (int)n);
                }
            }
            catch (Throwable throwable) {
                this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, EntryNotFoundException.class);
                throw throwable;
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, EntryNotFoundException.class);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicNodePruningWithParameter() throws Exception {
        try {
            this.startServerVMs(3, 0, "SG1");
            this.startClientVMs(1, 0, null);
            String updateQuery = "Update EMP.TESTTABLE set ADDRESS = ? where ID > ? AND ID < ?";
            this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null ) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 0 and 3, VALUES BETWEEN  3 and 6 , VALUES BETWEEN 6 and  +Infinity )");
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "')");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStoreForPrepStmnt();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            Activation[] actArr = new Activation[1];
            NodesPruningHelper.setupObserverOnClient(qi, actArr);
            TestUtil.setupConnection();
            EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
            es.setString(1, "gemstone");
            es.setInt(2, 0);
            es.setInt(3, 3);
            int n = es.executeUpdate();
            UpdateStatementDUnit.assertEquals((int)2, (int)n);
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(0), Boolean.FALSE, new SQLInteger(3), Boolean.FALSE}};
            Set<DistributedMember> expectedNodesToUpdate = NodesPruningHelper.getExpectedNodes(updateQuery, qi[0], routingInfo, this.getLogWriter());
            Set allNodes = ((PartitionedRegion)qi[0].getRegion()).getRegionAdvisor().adviseDataStore();
            SerializableRunnable validateNoQuerySend = UpdateStatementDUnit.getQueryNonExecutionValidator();
            SerializableRunnable validateQuerySend = UpdateStatementDUnit.getQueryExecutionValidator();
            this.executeOnVMs(expectedNodesToUpdate, validateQuerySend);
            allNodes.removeAll(expectedNodesToUpdate);
            this.executeOnVMs(allNodes, validateNoQuerySend);
            EmbedStatement s = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            ResultSet rs = s.executeQuery("Select ID, ADDRESS from EMP.TESTTABLE");
            while (rs.next()) {
                if (rs.getInt(1) > 0 && rs.getInt(1) < 3) {
                    UpdateStatementDUnit.assertEquals((String)rs.getString(2), (String)"gemstone");
                    continue;
                }
                UpdateStatementDUnit.assertFalse((boolean)rs.getString(2).equals("gemstone"));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateHavingParameterizedExpression_Bug39646_1() throws Exception {
        this.startVMs(1, 3);
        String updateQuery = "Update EMP.TESTTABLE set type = type + ? where ID > ? AND ID < ?";
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) ,type int ) PARTITION BY RANGE ( ID ) (VALUES BETWEEN 0 and 3, VALUES BETWEEN 3 and 6, VALUES BETWEEN 6 and +Infinity)" + this.getOverflowSuffix());
        try {
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "'," + (i + 1) + ")");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStoreForPrepStmnt();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            Activation[] actArr = new Activation[1];
            NodesPruningHelper.setupObserverOnClient(qi, actArr);
            TestUtil.setupConnection();
            EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
            es.setInt(1, 1);
            es.setInt(2, 0);
            es.setInt(3, 3);
            int n = es.executeUpdate();
            UpdateStatementDUnit.assertEquals((int)2, (int)n);
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(0), Boolean.FALSE, new SQLInteger(3), Boolean.FALSE}};
            Set<DistributedMember> expectedNodesToUpdate = NodesPruningHelper.getExpectedNodes(updateQuery, qi[0], routingInfo, this.getLogWriter());
            Set allNodes = ((PartitionedRegion)qi[0].getRegion()).getRegionAdvisor().adviseDataStore();
            SerializableRunnable validateNoQuerySend = UpdateStatementDUnit.getQueryNonExecutionValidator();
            SerializableRunnable validateQuerySend = UpdateStatementDUnit.getQueryExecutionValidator();
            this.executeOnVMs(expectedNodesToUpdate, validateQuerySend);
            allNodes.removeAll(expectedNodesToUpdate);
            this.executeOnVMs(allNodes, validateNoQuerySend);
            EmbedStatement s = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            ResultSet rs = s.executeQuery("Select ID, TYPE from EMP.TESTTABLE");
            while (rs.next()) {
                if (rs.getInt(1) > 0 && rs.getInt(1) < 3) {
                    UpdateStatementDUnit.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) + 1));
                    continue;
                }
                UpdateStatementDUnit.assertEquals((int)rs.getInt(2), (int)rs.getInt(1));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateWithoutInsert() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        String updateQuery = "Update EMP.TESTTABLE set type = ? where ID = ? ";
        this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) ,type int ) " + this.getOverflowSuffix());
        try {
            TestUtil.setupConnection();
            EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
            es.setInt(1, 1);
            es.setInt(2, 2);
            int n = es.executeUpdate();
            UpdateStatementDUnit.assertEquals((int)0, (int)n);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateHavingExpression_Bug39646_2() throws Exception {
        this.startVMs(1, 3);
        try {
            String updateQuery = "Update EMP.TESTTABLE set type = type + 1 where ID > 0 AND ID < 3";
            this.clientSQLExecute(1, "create schema EMP");
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) ,type int ) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 0 and 3, VALUES BETWEEN  3 and 6 , VALUES BETWEEN 6 and  +Infinity )" + this.getOverflowSuffix());
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "'," + (i + 1) + ")");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStore();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            Activation[] actArr = new Activation[1];
            NodesPruningHelper.setupObserverOnClient(qi, actArr);
            TestUtil.setupConnection();
            EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            int n = es.executeUpdate(updateQuery);
            UpdateStatementDUnit.assertEquals((int)2, (int)n);
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(0), Boolean.FALSE, new SQLInteger(3), Boolean.FALSE}};
            Set<DistributedMember> expectedNodesToUpdate = NodesPruningHelper.getExpectedNodes(updateQuery, qi[0], routingInfo, this.getLogWriter());
            Set allNodes = ((PartitionedRegion)qi[0].getRegion()).getRegionAdvisor().adviseDataStore();
            SerializableRunnable validateNoQuerySend = UpdateStatementDUnit.getQueryNonExecutionValidator();
            SerializableRunnable validateQuerySend = UpdateStatementDUnit.getQueryExecutionValidator();
            this.executeOnVMs(expectedNodesToUpdate, validateQuerySend);
            allNodes.removeAll(expectedNodesToUpdate);
            this.executeOnVMs(allNodes, validateNoQuerySend);
            EmbedStatement s = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            ResultSet rs = s.executeQuery("Select ID, TYPE from EMP.TESTTABLE");
            while (rs.next()) {
                if (rs.getInt(1) > 0 && rs.getInt(1) < 3) {
                    UpdateStatementDUnit.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) + 1));
                    continue;
                }
                UpdateStatementDUnit.assertEquals((int)rs.getInt(2), (int)rs.getInt(1));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateOnTableHavingNoPrimaryOrPartitionKeyDefined_Bug39921() throws Exception {
        try {
            this.startServerVMs(3, 0, "SG1");
            this.startClientVMs(1, 0, null);
            String updateQuery = "Update EMP.TESTTABLE set type = 10 where ID > 0 ";
            this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) , ADDRESS varchar(1024) ,type int ) " + this.getOverflowSuffix());
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "'," + (i + 1) + ")");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStore();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            Activation[] actArr = new Activation[1];
            NodesPruningHelper.setupObserverOnClient(qi, actArr);
            TestUtil.setupConnection();
            EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            int n = es.executeUpdate(updateQuery);
            UpdateStatementDUnit.assertEquals((int)8, (int)n);
            Object[][] routingInfo = new Object[][]{{new Integer(6)}};
            Set<DistributedMember> expectedNodesToUpdate = NodesPruningHelper.getExpectedNodes(updateQuery, qi[0], routingInfo, this.getLogWriter());
            Set allNodes = ((PartitionedRegion)qi[0].getRegion()).getRegionAdvisor().adviseDataStore();
            SerializableRunnable validateNoQuerySend = UpdateStatementDUnit.getQueryNonExecutionValidator();
            SerializableRunnable validateQuerySend = UpdateStatementDUnit.getQueryExecutionValidator();
            this.executeOnVMs(expectedNodesToUpdate, validateQuerySend);
            allNodes.removeAll(expectedNodesToUpdate);
            this.executeOnVMs(allNodes, validateNoQuerySend);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40025() throws Exception {
        try {
            this.startVMs(1, 3);
            String updateQuery = "update Child set sector_id2 = ? where id2 = ?";
            this.clientSQLExecute(1, "create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int)  replicate");
            this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) replicate");
            this.clientSQLExecute(1, "insert into instruments values (1,1,1)");
            this.clientSQLExecute(1, "insert into Child values (1,1,1)");
            TestUtil.setupConnection();
            final boolean[] executedOnGFEDistributionActvn = new boolean[]{false};
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                    executedOnGFEDistributionActvn[0] = activation instanceof GemFireUpdateDistributionActivation;
                    System.out.println("Type of Activation" + activation);
                }
            });
            EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
            es.setInt(1, 2);
            es.setInt(2, 1);
            try {
                es.executeUpdate();
                UpdateStatementDUnit.assertTrue((boolean)executedOnGFEDistributionActvn[0]);
                UpdateStatementDUnit.fail((String)"Expected foreign key violation");
            }
            catch (SQLException sqle) {
                this.getLogWriter().info((Object)"Got exception: ", (Throwable)sqle);
                if (!"23503".equals(sqle.getSQLState())) {
                    throw sqle;
                }
                UpdateStatementDUnit.assertTrue((String)("Unexpected exception " + sqle), (sqle.getMessage().indexOf("violation of foreign key constraint") != -1 ? 1 : 0) != 0);
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
            this.clientSQLExecute(1, "Drop table INSTRUMENTS ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40025WithOutUpdatesToPut() throws Exception {
        this.startVMs(1, 1);
        String updateQuery = "update Child set sector_id2 = ?, subsector_id2= subsector_id2-5 where id2 = ?";
        this.clientSQLExecute(1, "create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int)  replicate");
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) replicate");
        try {
            this.clientSQLExecute(1, "insert into instruments values (1,1,1)");
            this.clientSQLExecute(1, "insert into Child values (1,1,10)");
            TestUtil.setupConnection();
            EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
            es.setInt(1, 2);
            es.setInt(2, 1);
            try {
                es.executeUpdate();
                UpdateStatementDUnit.fail((String)"Update should not have occured due to foreign key violation");
            }
            catch (SQLException sqle) {
                this.getLogWriter().info((Object)("Expected exception=" + sqle.getMessage()));
                UpdateStatementDUnit.assertTrue((sqle.getMessage().indexOf("violation of foreign key constraint") != -1 ? 1 : 0) != 0);
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            this.clientSQLExecute(1, "Drop table Child ");
            this.clientSQLExecute(1, "Drop table INSTRUMENTS ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40025_1() throws Exception {
        try {
            block5: {
                this.startVMs(1, 3);
                String updateQuery = "update Child set sector_id2 = ? where id2 = ?";
                this.clientSQLExecute(1, "create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int)  partition by primary key");
                this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) partition by primary key");
                this.clientSQLExecute(1, "insert into instruments values (1,1,1)");
                this.clientSQLExecute(1, "insert into Child values (1,1,1)");
                TestUtil.setupConnection();
                EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
                es.setInt(1, 2);
                es.setInt(2, 1);
                this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, FunctionException.class);
                try {
                    es.executeUpdate();
                    UpdateStatementDUnit.fail((String)"Update should not have occured as foreign key violation would occur");
                }
                catch (SQLException sqle) {
                    if ("23503".equals(sqle.getSQLState())) break block5;
                    throw sqle;
                }
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, FunctionException.class);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
            this.clientSQLExecute(1, "Drop table INSTRUMENTS ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstraintExceptionForPartitionedRegionTable_Bug40016_2() throws Exception {
        this.startVMs(1, 3);
        try {
            block5: {
                String updateQuery = "update Child set sector_id2 = ? where subsector_id2 = ?";
                this.clientSQLExecute(1, "create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int)  partition by primary key");
                this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) partition by primary key");
                this.clientSQLExecute(1, "insert into instruments values (1,1,1)");
                this.clientSQLExecute(1, "insert into Child values (1,1,1)");
                TestUtil.setupConnection();
                EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
                es.setInt(1, 2);
                es.setInt(2, 1);
                this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, FunctionException.class);
                try {
                    es.executeUpdate();
                    UpdateStatementDUnit.fail((String)"Update should not have occured as foreign key violation would occur");
                }
                catch (SQLException sqle) {
                    if ("23503".equals(sqle.getSQLState())) break block5;
                    throw sqle;
                }
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, FunctionException.class);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
            this.clientSQLExecute(1, "Drop table INSTRUMENTS ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstraintExceptionForReplicatedRegionTable_Bug40016_1() throws Exception {
        this.startVMs(1, 3);
        String updateQuery = "update Child set sector_id2 = ? where subsector_id2 = ?";
        try {
            this.clientSQLExecute(1, "create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int)  replicate");
            this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) replicate");
            this.clientSQLExecute(1, "insert into instruments values (1,1,1)");
            this.clientSQLExecute(1, "insert into Child values (1,1,1)");
            TestUtil.setupConnection();
            EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
            es.setInt(1, 2);
            es.setInt(2, 1);
            try {
                es.executeUpdate();
                UpdateStatementDUnit.fail((String)"Update should not have occured as foreign key violation would occur");
            }
            catch (SQLException sqle) {
                this.getLogWriter().info((Object)("Expected exception=" + sqle.getMessage()));
                UpdateStatementDUnit.assertTrue((sqle.getMessage().indexOf("violation of foreign key constraint") != -1 ? 1 : 0) != 0);
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
            this.clientSQLExecute(1, "Drop table INSTRUMENTS ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotNullCheck_Bug40018_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int)" + this.getOverflowSuffix());
        try {
            String updateQuery = "update Child set sector_id2 = ? where subsector_id2 = ?";
            this.clientSQLExecute(1, "insert into Child values (1,1,1)");
            this.clientSQLExecute(1, "insert into Child values (2,1,1)");
            this.clientSQLExecute(1, "insert into Child values (3,1,1)");
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(updateQuery);
            ps.setNull(1, 4);
            ps.setInt(2, 1);
            try {
                ps.executeUpdate();
                UpdateStatementDUnit.fail((String)"Update should not have occured as not null column should not get assigned null value");
            }
            catch (SQLException sqle) {
                this.getLogWriter().info((Object)("Expected exception=" + sqle.getMessage()));
                UpdateStatementDUnit.assertTrue((sqle.getMessage().indexOf("cannot accept a NULL value") != -1 ? 1 : 0) != 0);
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotNullCheck_Bug40018_2() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int)" + this.getOverflowSuffix());
        try {
            String updateQuery = "update Child set subsector_id2 = ?, sector_id2 = sector_id2 + ? where subsector_id2 = ?";
            this.clientSQLExecute(1, "insert into Child values (1,1,1)");
            this.clientSQLExecute(1, "insert into Child values (2,1,1)");
            this.clientSQLExecute(1, "insert into Child values (3,1,1)");
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(updateQuery);
            ps.setNull(1, 4);
            ps.setInt(2, 2);
            ps.setInt(3, 1);
            int n = ps.executeUpdate();
            UpdateStatementDUnit.assertEquals((int)3, (int)n);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41985() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int)" + this.getOverflowSuffix());
        try {
            String updateQuery = "update Child set subsector_id2 = ?, sector_id2 =  ? where id2 = ?";
            this.clientSQLExecute(1, "insert into Child values (1,1,1)");
            this.clientSQLExecute(1, "insert into Child values (2,1,1)");
            this.clientSQLExecute(1, "insert into Child values (3,1,1)");
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(updateQuery);
            ps.setNull(1, 4);
            ps.setInt(2, 2);
            ps.setInt(3, 1);
            int n = ps.executeUpdate();
            UpdateStatementDUnit.assertEquals((int)1, (int)n);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41985_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int)" + this.getOverflowSuffix());
        try {
            TestUtil.setupConnection();
            Statement stmt = TestUtil.jdbcConn.createStatement();
            int n = stmt.executeUpdate("insert into Child values (1,1,1)");
            UpdateStatementDUnit.assertEquals((int)1, (int)n);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotNullCheck_Bug40018_3() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int not null)" + this.getOverflowSuffix());
        try {
            String updateQuery = "update Child set subsector_id2 = ?, sector_id2 = sector_id2 + ? where subsector_id2 = ?";
            this.clientSQLExecute(1, "insert into Child values (1,1,1)");
            this.clientSQLExecute(1, "insert into Child values (2,1,1)");
            this.clientSQLExecute(1, "insert into Child values (3,1,1)");
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(updateQuery);
            ps.setNull(1, 4);
            ps.setInt(2, 2);
            ps.setInt(3, 1);
            try {
                ps.executeUpdate();
                UpdateStatementDUnit.fail((String)"Update should not have occured as not null column should not get assigned null value");
            }
            catch (SQLException sqle) {
                this.getLogWriter().info((Object)("Expected exception=" + sqle.getMessage()));
                UpdateStatementDUnit.assertTrue((sqle.getMessage().indexOf("cannot accept a NULL value") != -1 ? 1 : 0) != 0);
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPKUpdateOnNonExistentRowForReplicateTable_Bug42862() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int not null) replicate" + this.getOverflowSuffix());
        try {
            this.clientSQLExecute(1, "insert into Child values (3,1,1)");
            String updateQuery = "update Child set subsector_id2 = ? where id2 = ?";
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(updateQuery);
            ps.setInt(1, 1);
            ps.setInt(2, 2);
            int num = ps.executeUpdate();
            UpdateStatementDUnit.assertEquals((int)0, (int)num);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPKUpdateOnNonExistentRowForPartitionedTable_Bug42862() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int not null) " + this.getOverflowSuffix());
        try {
            this.clientSQLExecute(1, "insert into Child values (3,1,1)");
            String updateQuery = "update Child set subsector_id2 = ? where id2 = ?";
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(updateQuery);
            ps.setInt(1, 1);
            ps.setInt(2, 2);
            int num = ps.executeUpdate();
            UpdateStatementDUnit.assertEquals((int)0, (int)num);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPKUpdateOnExistingRowForPartitionedTable_Bug42862() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Child ( id2 int primary key, sector_id2 int not null, subsector_id2 int not null) PARTITION BY RANGE (id2) (VALUES BETWEEN 0 and 3, VALUES BETWEEN 3 and 6, VALUES BETWEEN 6 and +Infinity)" + this.getOverflowSuffix());
        try {
            this.clientSQLExecute(1, "insert into Child values (1,1,1)");
            this.clientSQLExecute(1, "insert into Child values (2,1,1)");
            this.clientSQLExecute(1, "insert into Child values (3,1,1)");
            String updateQuery = "update Child set subsector_id2 = ? where id2 = ?";
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(updateQuery);
            ps.setInt(1, 1);
            ps.setInt(2, 2);
            int num = ps.executeUpdate();
            UpdateStatementDUnit.assertEquals((int)1, (int)num);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table Child ");
        }
    }

    public static final void reset() {
        isQueryExecutedOnNode = false;
    }

    private void executeOnVMs(Set<DistributedMember> members, SerializableRunnable runnable) {
        for (DistributedMember member : members) {
            VM vm = this.getHostVMForMember(member);
            vm.invoke((Runnable)runnable);
        }
    }

    private SerializableRunnable getGfxdQueryObserverIntializerForDataStore() {
        return new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
                            isQueryExecutedOnNode = true;
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private SerializableRunnable getGfxdQueryObserverIntializerForDataStoreForPrepStmnt() {
        return new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                            isQueryExecutedOnNode = true;
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private static SerializableRunnable getQueryExecutionValidator() {
        return new SerializableRunnable("validate Query execution"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertTrue((boolean)isQueryExecutedOnNode);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private static SerializableRunnable getQueryNonExecutionValidator() {
        return new SerializableRunnable("validate no query execution"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertFalse((boolean)isQueryExecutedOnNode);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    public String getOverflowSuffix() {
        return " ";
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
        UpdateStatementDUnit.reset();
    }
}

