/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.NodesPruningHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import java.sql.ResultSet;
import java.util.Arrays;

public class UpdatePreparedStatementDUnit
extends DistributedSQLTestBase {
    protected static volatile boolean isQueryExecutedOnNode = false;

    public UpdatePreparedStatementDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullUpdate() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION decimal(5,2) , ADDRESS varchar(1024) , primary key (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 8 )" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + "," + (i + 1) + ", 'J 604')");
        }
        Object[][] queries = new Object[][]{{"Update TESTTABLE SET DESCRIPTION = ?  where ID  > ?  ", new Object[][]{{new Integer(1), new SQLInteger(6), Boolean.FALSE, null, null}}, new Object[]{null, new Integer(6)}, new Integer(3), new int[]{3, 4}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                QueryInfo[] uArr = new QueryInfo[1];
                Activation[] actArr = new Activation[1];
                NodesPruningHelper.setupObserverOnClient(uArr, actArr);
                String queryString = (String)queries[i][0];
                TestUtil.setupConnection();
                EmbedPreparedStatement ps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(queryString);
                Object[] params = (Object[])queries[i][2];
                int[] types = (int[])queries[i][4];
                String log = "\nexecuting Query " + (i + 1) + " : \"" + ps.getSQLText() + "\"" + " with args: " + Arrays.toString(params);
                this.getLogWriter().info((Object)log);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, types[j]);
                }
                int numUpdates = ps.executeUpdate();
                NodesPruningHelper.validateNodePruningForQuery(queryString, uArr[0], (Object[][])queries[i][1], this, actArr[0]);
                UpdatePreparedStatementDUnit.assertEquals((int)numUpdates, (int)((Integer)queries[i][3]));
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrimaryKeyUpdateNotSupported_Bug39913() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) , ADDRESS varchar(1024), primary key (ID))" + this.getOverflowSuffix());
        try {
            for (int i = 0; i <= 8; ++i) {
                this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ",'" + (i + 1) + "', 'J 604')");
            }
            String query = "Update TESTTABLE SET ID = 10  where DESCRIPTION =  '9' and ID = 9  ";
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            try {
                int numUpdates = stmnt.executeUpdate(query);
                UpdatePreparedStatementDUnit.fail((String)"Update of primary key column should not be allowed");
                UpdatePreparedStatementDUnit.assertEquals((int)numUpdates, (int)1);
                ResultSet rs = stmnt.executeQuery("Select * from TESTTABLE where ID = 9");
                UpdatePreparedStatementDUnit.assertFalse((boolean)rs.next());
            }
            catch (Exception se) {
                String message = se.getMessage();
                if (message.indexOf("Update of column which is primary key or is part of the primary key, not supported") == -1 && message.indexOf("Update of partitioning column not supported") == -1) {
                    UpdatePreparedStatementDUnit.fail((String)("Unexpected type of StandardException." + se.toString()));
                }
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    public String getOverflowSuffix() {
        return " ";
    }
}

