/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.derbyTesting.junit.JDBC;

public class TruncateTableDUnit
extends DistributedSQLTestBase {
    public TruncateTableDUnit(String name) {
        super(name);
    }

    public void testBug45094_replicate() throws Exception {
        int i;
        this.startVMs(1, 2, 0, null, null);
        int netPort1 = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort1);
        Connection conn = DriverManager.getConnection(url);
        Statement st = conn.createStatement();
        st.execute("create schema test");
        st.execute("create table test.test_table (first_column int not null, second_column int not null) replicate");
        st.execute("create table test.test_table2 (first_column int not null, second_column int not null) replicate persistent");
        st.execute("create unique index test.first_index on test.test_table (first_column)");
        st.execute("create index test.second_index on test.test_table (second_column)");
        st.execute("create unique index test.first_index2 on test.test_table2 (first_column)");
        st.execute("create index test.second_index2 on test.test_table2 (second_column)");
        PreparedStatement ps = conn.prepareStatement("insert into test.test_table values (?, ?)");
        for (i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 10);
            ps.execute();
        }
        ps = conn.prepareStatement("insert into test.test_table2 values (?, ?)");
        for (i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 10);
            ps.execute();
        }
        ps = conn.prepareStatement("select count(*) from test.test_table");
        ResultSet rs = ps.executeQuery();
        TruncateTableDUnit.assertTrue((boolean)rs.next());
        TruncateTableDUnit.assertEquals((int)10, (int)rs.getInt(1));
        TruncateTableDUnit.assertFalse((boolean)rs.next());
        ps = conn.prepareStatement("select count(*) from test.test_table2");
        rs = ps.executeQuery();
        TruncateTableDUnit.assertTrue((boolean)rs.next());
        TruncateTableDUnit.assertEquals((int)10, (int)rs.getInt(1));
        TruncateTableDUnit.assertFalse((boolean)rs.next());
        for (int vm = 1; vm <= 2; ++vm) {
            int i2;
            if (vm == 2) {
                this.stopAllVMs();
                this.restartVMNums(-1, -2);
                this.restartVMNums(1);
                conn = TestUtil.getConnection();
                st = conn.createStatement();
                ps = conn.prepareStatement("select count(*) from test.test_table");
                rs = ps.executeQuery();
                TruncateTableDUnit.assertTrue((boolean)rs.next());
                TruncateTableDUnit.assertEquals((int)0, (int)rs.getInt(1));
                TruncateTableDUnit.assertFalse((boolean)rs.next());
                rs.close();
                ps = conn.prepareStatement("select count(*) from test.test_table2");
                rs = ps.executeQuery();
                TruncateTableDUnit.assertTrue((boolean)rs.next());
                TruncateTableDUnit.assertEquals((int)20, (int)rs.getInt(1));
                TruncateTableDUnit.assertFalse((boolean)rs.next());
                rs.close();
            }
            ps = conn.prepareStatement("truncate table test.test_table");
            ps.execute();
            ps = conn.prepareStatement("truncate table test.test_table2");
            ps.execute();
            ps = conn.prepareStatement("select count(*) from test.test_table");
            rs = ps.executeQuery();
            TruncateTableDUnit.assertTrue((boolean)rs.next());
            TruncateTableDUnit.assertEquals((int)0, (int)rs.getInt(1));
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select count(*) from test.test_table2");
            rs = ps.executeQuery();
            TruncateTableDUnit.assertTrue((boolean)rs.next());
            TruncateTableDUnit.assertEquals((int)0, (int)rs.getInt(1));
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select * from test.test_table where first_column = ?");
            ps.setInt(1, 7);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select * from test.test_table2 where first_column = ?");
            ps.setInt(1, 7);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select * from test.test_table where second_column = ?");
            ps.setInt(1, 12);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select * from test.test_table2 where second_column = ?");
            ps.setInt(1, 12);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            rs = st.executeQuery("values SYSCS_UTIL.CHECK_TABLE('TEST', 'TEST_TABLE')");
            JDBC.assertSingleValueResultSet(rs, "1");
            rs.close();
            rs = st.executeQuery("values SYSCS_UTIL.CHECK_TABLE('TEST', 'TEST_TABLE2')");
            JDBC.assertSingleValueResultSet(rs, "1");
            rs.close();
            ps = conn.prepareStatement("insert into test.test_table values (?, ?)");
            for (i2 = 0; i2 < 20; ++i2) {
                ps.setInt(1, i2 + 100);
                ps.setInt(2, i2 + 1000);
                ps.execute();
            }
            ps = conn.prepareStatement("insert into test.test_table2 values (?, ?)");
            for (i2 = 0; i2 < 20; ++i2) {
                ps.setInt(1, i2 + 100);
                ps.setInt(2, i2 + 1000);
                ps.execute();
            }
            ps = conn.prepareStatement("select count(*) from test.test_table");
            rs = ps.executeQuery();
            TruncateTableDUnit.assertTrue((boolean)rs.next());
            TruncateTableDUnit.assertEquals((int)20, (int)rs.getInt(1));
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select count(*) from test.test_table2");
            rs = ps.executeQuery();
            TruncateTableDUnit.assertTrue((boolean)rs.next());
            TruncateTableDUnit.assertEquals((int)20, (int)rs.getInt(1));
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select * from test.test_table where first_column = ?");
            ps.setInt(1, 7);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps.setInt(1, 107);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertTrue((boolean)rs.next());
            TruncateTableDUnit.assertEquals((int)107, (int)rs.getInt(1));
            TruncateTableDUnit.assertEquals((int)1007, (int)rs.getInt(2));
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select * from test.test_table2 where first_column = ?");
            ps.setInt(1, 7);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps.setInt(1, 107);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertTrue((boolean)rs.next());
            TruncateTableDUnit.assertEquals((int)107, (int)rs.getInt(1));
            TruncateTableDUnit.assertEquals((int)1007, (int)rs.getInt(2));
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select * from test.test_table where second_column = ?");
            ps.setInt(1, 12);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps.setInt(1, 1012);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertTrue((boolean)rs.next());
            TruncateTableDUnit.assertEquals((int)112, (int)rs.getInt(1));
            TruncateTableDUnit.assertEquals((int)1012, (int)rs.getInt(2));
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps = conn.prepareStatement("select * from test.test_table2 where second_column = ?");
            ps.setInt(1, 12);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            ps.setInt(1, 1012);
            rs = ps.executeQuery();
            TruncateTableDUnit.assertTrue((boolean)rs.next());
            TruncateTableDUnit.assertEquals((int)112, (int)rs.getInt(1));
            TruncateTableDUnit.assertEquals((int)1012, (int)rs.getInt(2));
            TruncateTableDUnit.assertFalse((boolean)rs.next());
            conn.close();
        }
    }

    public void testBug45094_partitioned() throws Exception {
        this.startVMs(0, 2, 0, null, null);
        int netPort1 = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort1);
        Connection conn = DriverManager.getConnection(url);
        Statement st = conn.createStatement();
        st.execute("create schema test");
        st.execute("create table test.test_table (first_column int not null, second_column int not null) partition by (first_column)");
        st.execute("create unique index test.first_index on test.test_table (first_column)");
        st.execute("create index test.second_index on test.test_table (second_column)");
        PreparedStatement ps = conn.prepareStatement("insert into test.test_table values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 10);
            ps.execute();
        }
        ps = conn.prepareStatement("select count(*) from test.test_table");
        ResultSet rs = ps.executeQuery();
        rs.next();
        TruncateTableDUnit.assertEquals((int)10, (int)rs.getInt(1));
        ps = conn.prepareStatement("truncate table test.test_table");
        ps.execute();
        ps = conn.prepareStatement("select count(*) from test.test_table");
        rs = ps.executeQuery();
        rs.next();
        TruncateTableDUnit.assertEquals((int)0, (int)rs.getInt(1));
        ps = conn.prepareStatement("select * from test.test_table where first_column = ?");
        ps.setInt(1, 7);
        rs = ps.executeQuery();
        TruncateTableDUnit.assertFalse((boolean)rs.next());
        ps = conn.prepareStatement("select * from test.test_table where second_column = ?");
        ps.setInt(1, 12);
        rs = ps.executeQuery();
        TruncateTableDUnit.assertFalse((boolean)rs.next());
        rs = st.executeQuery("values SYSCS_UTIL.CHECK_TABLE('TEST', 'TEST_TABLE')");
        JDBC.assertSingleValueResultSet(rs, "1");
        ps = conn.prepareStatement("insert into test.test_table values (?, ?)");
        for (int i = 0; i < 20; ++i) {
            ps.setInt(1, i + 100);
            ps.setInt(2, i + 1000);
            ps.execute();
        }
        ps = conn.prepareStatement("select count(*) from test.test_table");
        rs = ps.executeQuery();
        rs.next();
        TruncateTableDUnit.assertEquals((int)20, (int)rs.getInt(1));
    }
}

