/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.ClientServerDUnit;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;

public class SubqueryDUnit
extends DistributedSQLTestBase {
    protected static volatile boolean isQueryExecutedOnNode = false;
    private static final int byrange = 1;
    private static final int bylist = 2;
    private static final int bycolumn = 4;
    private static final int ANDing = 8;
    private static final int ORing = 16;
    private static final int Contains = 32;
    private static final int OrderBy = 64;
    private static final int noCheck = 1;
    private static final int fixLater = 3;
    private static final int fixImmediate = 5;
    private static final int wontFix = 9;
    private static final int fixDepend = 17;
    private static final int fixInvestigate = 33;
    private static volatile Connection derbyConn = null;

    public SubqueryDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPR_PR_IN_NonCorrelatedSubqueryPKBased() throws Exception {
        try {
            String insert;
            int i;
            String subqueryStr = "Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?";
            String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where description1 like ? and address1  like ?  and  ID1 IN ( Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ? ) ";
            this.startVMs(1, 3);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))";
            String table2 = "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) ";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2);
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            for (i = 35; i < 100; ++i) {
                insert = "Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'add1_" + i + "')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 1; i < 11; ++i) {
                insert = "Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'add2_')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            Object[] params = new Object[]{"desc1%", "add1%", "desc2_", "add2_"};
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, true, params, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, true, params, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeletePR_PR_IN_NonCorrelatedSubqueryPKBased() throws Exception {
        try {
            String insert;
            int i;
            String subqueryStr = "Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?";
            String query = "Delete from TESTTABLE1 where description1 like ? and address1 like ?  and  ID1 IN ( Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ? ) ";
            this.startVMs(1, 3);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))";
            String table2 = "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) ";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2);
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            for (i = 35; i < 100; ++i) {
                insert = "Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'add1_" + i + "')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 1; i < 11; ++i) {
                insert = "Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'add2_')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            Object[] params = new Object[]{"desc1%", "add1%", "desc2_", "add2_"};
            int numUpdGfxd = SubqueryDUnit.executeUpdate(query, true, params, false);
            int numUpdDerby = SubqueryDUnit.executeUpdate(query, true, params, true);
            SubqueryDUnit.assertTrue((numUpdDerby > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numUpdDerby, (int)numUpdGfxd);
            String select = "select * from testtable1";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(select, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(select, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdatePR_PR_IN_NonCorrelatedSubqueryPKBased() throws Exception {
        try {
            String insert;
            int i;
            String subqueryStr = "Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ?";
            String query = "Update  TESTTABLE1 set description1 = 'no description' where description1 like ? and address1 like ?  and  ID1 IN ( Select SUM(ID2) from Testtable2  where description2 = ? and  address2 = ? ) ";
            this.startVMs(1, 3);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))";
            String table2 = "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) ";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2);
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            for (i = 35; i < 100; ++i) {
                insert = "Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'add1_" + i + "')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 1; i < 11; ++i) {
                insert = "Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'add2_')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            Object[] params = new Object[]{"desc1%", "add1%", "desc2_", "add2_"};
            int numUpdGfxd = SubqueryDUnit.executeUpdate(query, true, params, false);
            int numUpdDerby = SubqueryDUnit.executeUpdate(query, true, params, true);
            SubqueryDUnit.assertTrue((numUpdDerby > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numUpdDerby, (int)numUpdGfxd);
            String select = "select * from testtable1";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(select, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(select, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42428() throws Exception {
        try {
            String query = "select  DESCRIPTION1 from TESTTABLE1 where ID1 IN (select ID2 from TESTTABLE2) ";
            this.startVMs(1, 3);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ";
            String table2 = "create table TESTTABLE2 (ID int not null,ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID) ) ";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1 + " replicate");
            this.clientSQLExecute(1, table2);
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            String insert = "Insert into  TESTTABLE1 values(1,'desc1_1','add1_1')";
            this.clientSQLExecute(1, insert);
            SubqueryDUnit.executeOnDerby(insert, false, null);
            for (int i = 1; i < 3; ++i) {
                insert = "Insert into  TESTTABLE2 values(" + i + ",1,'desc2_" + "', 'add2_')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42428ForDelete() throws Exception {
        try {
            String dml = "delete  from TESTTABLE1 where ID1 IN (select ID2 from TESTTABLE2) ";
            this.startVMs(1, 3);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ";
            String table2 = "create table TESTTABLE2 (ID int not null,ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID) ) ";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1 + " replicate");
            this.clientSQLExecute(1, table2);
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            String insert = "Insert into  TESTTABLE1 values(1,'desc1_1','add1_1')";
            this.clientSQLExecute(1, insert);
            SubqueryDUnit.executeOnDerby(insert, false, null);
            for (int i = 1; i < 3; ++i) {
                insert = "Insert into  TESTTABLE2 values(" + i + ",1,'desc2_" + "', 'add2_')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            int numGfxdUpdates = SubqueryDUnit.executeUpdate(dml, false, null, false);
            int numDerbyUpdates = SubqueryDUnit.executeUpdate(dml, false, null, true);
            SubqueryDUnit.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
            String query = "select * from testtable1";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42428ForUpdate() throws Exception {
        try {
            String dml = "Update TESTTABLE1 set Description1 = 'no description' where ID1 IN (select ID2 from TESTTABLE2) ";
            this.startVMs(1, 3);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ";
            String table2 = "create table TESTTABLE2 (ID int not null,ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID) ) ";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1 + " replicate");
            this.clientSQLExecute(1, table2);
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            String insert = "Insert into  TESTTABLE1 values(1,'desc1_1','add1_1')";
            this.clientSQLExecute(1, insert);
            SubqueryDUnit.executeOnDerby(insert, false, null);
            for (int i = 1; i < 3; ++i) {
                insert = "Insert into  TESTTABLE2 values(" + i + ",1,'desc2_" + "', 'add2_')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            int numGfxdUpdates = SubqueryDUnit.executeUpdate(dml, false, null, false);
            int numDerbyUpdates = SubqueryDUnit.executeUpdate(dml, false, null, true);
            SubqueryDUnit.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
            String query = "select * from testtable1";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.cleanup();
        }
    }

    public void BUG_testSubqueryWithOrderBy() throws Exception {
        this.startVMs(2, 3);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        conn.createStatement().execute(" create table course ( course_id int, course_name varchar(20),primary key(course_id, course_name)) partition by column (course_id) ");
        conn.createStatement().execute(" create table student ( st_id varchar(10), c_id int,primary key(st_id, c_id)) replicate ");
        st.execute("insert into student values('x', 1)");
        st.execute("insert into student values('x', 2)");
        st.execute("insert into student values('x', 3)");
        st.execute("insert into student values('a', 1)");
        st.execute("insert into student values('bb', 4)");
        st.execute("insert into course values(4, 'FOUR')");
        st.execute("insert into course values(5, 'FIVE')");
        st.execute("insert into course values(6, 'SIX')");
        SerializableRunnable selects = new SerializableRunnable(){
            long[] res = new long[]{3L, 2L, 1L};

            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    ResultSet st_st = st.executeQuery("select c_id from student where st_id = 'x' and c_id not in (select distinct course_id from course) order by c_id desc NULLS first ");
                    int r = -1;
                    while (st_st.next()) {
                        int received = st_st.getInt(1);
                        assert (r < this.res.length);
                        SubqueryDUnit.this.getLogWriter().info((Object)("Received course id from student " + received));
                        TestCase.assertEquals((long)this.res[++r], (long)received);
                    }
                    TestCase.assertTrue((r != -1 ? 1 : 0) != 0);
                }
                catch (SQLException e) {
                    DistributedSQLTestBase.fail("Exception occured ", e);
                }
            }
        };
        ArrayList<AsyncInvocation> runlist1 = this.executeTaskAsync(new int[]{2}, new int[]{1, 2, 3}, (Runnable)selects);
        selects.run();
        this.joinAsyncInvocation(runlist1);
    }

    private void cleanup() throws Exception {
        Statement derbyStmt;
        if (derbyConn != null && (derbyStmt = derbyConn.createStatement()) != null) {
            String[] tables2;
            for (String table : tables2 = new String[]{"testtable", "testtable1", "testtable2", "testtable3"}) {
                try {
                    derbyStmt.execute("drop table " + table);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    this.clientSQLExecute(1, "drop table " + table);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void executeOnDerby(String sql, boolean isPrepStmt, Object[] params) throws Exception {
        if (derbyConn == null) {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            derbyConn = DriverManager.getConnection(derbyDbUrl);
        }
        if (isPrepStmt) {
            PreparedStatement ps = derbyConn.prepareStatement(sql);
            if (params != null) {
                int j = 1;
                for (Object param : params) {
                    if (param == null) {
                        ps.setNull(j, 2000);
                        continue;
                    }
                    ps.setObject(j, param);
                }
            }
            ps.execute();
        } else {
            derbyConn.createStatement().execute(sql);
        }
    }

    public static ResultSet executeQuery(String sql, boolean isPrepStmt, Object[] params, boolean isDerby) throws Exception {
        Connection derbyOrGfxd = null;
        ResultSet rs = null;
        if (isDerby) {
            if (derbyConn == null) {
                String derbyDbUrl = "jdbc:derby:newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
            }
            derbyOrGfxd = derbyConn;
        } else {
            derbyOrGfxd = TestUtil.getConnection();
        }
        if (isPrepStmt) {
            PreparedStatement ps = derbyOrGfxd.prepareStatement(sql);
            if (params != null) {
                int j = 1;
                for (Object param : params) {
                    if (param == null) {
                        ps.setNull(j, 2000);
                    } else {
                        ps.setObject(j, param);
                    }
                    ++j;
                }
            }
            rs = ps.executeQuery();
        } else {
            rs = derbyOrGfxd.createStatement().executeQuery(sql);
        }
        return rs;
    }

    public static int executeUpdate(String sql, boolean isPrepStmt, Object[] params, boolean isDerby) throws Exception {
        Connection derbyOrGfxd = null;
        int numUpdate = 0;
        if (isDerby) {
            if (derbyConn == null) {
                String derbyDbUrl = "jdbc:derby:newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
            }
            derbyOrGfxd = derbyConn;
        } else {
            derbyOrGfxd = TestUtil.getConnection();
        }
        if (isPrepStmt) {
            PreparedStatement ps = derbyOrGfxd.prepareStatement(sql);
            if (params != null) {
                int j = 1;
                for (Object param : params) {
                    if (param == null) {
                        ps.setNull(j, 2000);
                    } else {
                        ps.setObject(j, param);
                    }
                    ++j;
                }
            }
            numUpdate = ps.executeUpdate();
        } else {
            numUpdate = derbyOrGfxd.createStatement().executeUpdate(sql);
        }
        return numUpdate;
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            derbyConn = null;
        }
        catch (SQLException sqle) {
            derbyConn = null;
            if (sqle.getMessage().indexOf("shutdown") == -1 && sqle.getMessage().indexOf("Driver is not registered ") == -1) {
                sqle.printStackTrace();
                throw sqle;
            }
            derbyConn = null;
        }
        super.tearDown2();
    }

    private void setupObservers(VM[] dataStores, final SelectQueryInfo[] sqi, String queryStr) {
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qi, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                sqi[0] = (SelectQueryInfo)qi;
            }
        });
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver on DataStore Node for query " + queryStr){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                            SubqueryDUnit.this.getLogWriter().info((Object)"Observer::beforeQueryExecutionByPrepStatementQueryExecutor invoked");
                            isQueryExecutedOnNode = true;
                        }

                        public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
                            isQueryExecutedOnNode = true;
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        for (VM dataStore : dataStores) {
            dataStore.invoke((Runnable)setObserver);
        }
    }

    private void verifyQueryExecution(SelectQueryInfo sqi, Object[] routingObjects, int noOfPrunedNodes, int noOfNoExecQueryNodes, String query) {
        PartitionedRegion pr = (PartitionedRegion)sqi.getRegion();
        Set<DistributedMember> prunedNodes = routingObjects.length != 0 ? pr.getMembersFromRoutingObjects(routingObjects) : new HashSet();
        this.getLogWriter().info((Object)("Number of members found after prunning =" + prunedNodes.size()));
        this.verifyExecutionOnDMs(sqi, prunedNodes, noOfPrunedNodes, noOfNoExecQueryNodes, query);
    }

    private void verifyExecutionOnDMs(SelectQueryInfo sqi, Set<DistributedMember> prunedNodes, int noOfPrunedNodes, int noOfNoExecQueryNodes, String query) {
        VM nodeVM;
        SerializableRunnable validateQueryExecution = new SerializableRunnable("validate node has executed the query " + query){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertTrue((boolean)isQueryExecutedOnNode);
                    isQueryExecutedOnNode = false;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        SerializableRunnable validateNoQueryExecution = new SerializableRunnable("validate node has NOT executed the query " + query){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertFalse((boolean)isQueryExecutedOnNode);
                    isQueryExecutedOnNode = false;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        PartitionedRegion pr = (PartitionedRegion)sqi.getRegion();
        Set nodesOfPr = pr.getRegionAdvisor().adviseDataStore();
        this.getLogWriter().info((Object)(" Total members = " + nodesOfPr.size()));
        String logPrunedMembers = new String();
        logPrunedMembers = " Prunned member(s) " + prunedNodes.size() + "\n";
        for (DistributedMember dm : prunedNodes) {
            if (dm == null) continue;
            logPrunedMembers = logPrunedMembers + dm.toString() + " ";
        }
        this.getLogWriter().info((Object)logPrunedMembers);
        if (noOfPrunedNodes > -1) {
            SubqueryDUnit.assertEquals((int)noOfPrunedNodes, (int)prunedNodes.size());
        }
        nodesOfPr.removeAll(prunedNodes);
        String logNonPrunedMembers = new String();
        logNonPrunedMembers = " Non-prunned member(s) " + nodesOfPr.size() + "\n";
        for (DistributedMember dm : nodesOfPr) {
            if (dm == null) continue;
            logNonPrunedMembers = logNonPrunedMembers + dm.toString() + " ";
        }
        this.getLogWriter().info((Object)logNonPrunedMembers);
        if (noOfNoExecQueryNodes > -1) {
            SubqueryDUnit.assertEquals((int)noOfNoExecQueryNodes, (int)nodesOfPr.size());
        }
        for (DistributedMember memberNoExec : nodesOfPr) {
            nodeVM = this.getHostVMForMember(memberNoExec);
            SubqueryDUnit.assertNotNull((Object)nodeVM);
            this.getLogWriter().info((Object)("Checking non-execution on VM(pid) : " + nodeVM.getPid()));
            nodeVM.invoke((Runnable)validateNoQueryExecution);
        }
        for (DistributedMember memberExec : prunedNodes) {
            nodeVM = this.getHostVMForMember(memberExec);
            SubqueryDUnit.assertNotNull((Object)nodeVM);
            this.getLogWriter().info((Object)("Checking execution on VM(pid) : " + nodeVM.getPid()));
            nodeVM.invoke((Runnable)validateQueryExecution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42416() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        String table2 = "create table portfolio (cid int not null, sid int not null,  constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict) partition by range (cid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 5 AND 10, VALUES BETWEEN 10 AND 15) colocate with (customers)";
        String table3 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid)) partition by range (cid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 5 AND 10, VALUES BETWEEN 10 AND 15)";
        s.execute(table3);
        s.execute(table2);
        for (int i = 0; i < 15; ++i) {
            this.clientSQLExecute(1, "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")");
        }
        this.clientSQLExecute(1, "insert into portfolio values (2,7)");
        this.clientSQLExecute(1, "insert into portfolio values (3,8)");
        this.clientSQLExecute(1, "insert into portfolio values (5,12)");
        this.clientSQLExecute(1, "insert into portfolio values (6,13)");
        this.clientSQLExecute(1, "insert into portfolio values (7,2)");
        this.clientSQLExecute(1, "insert into portfolio values (8,3)");
        this.clientSQLExecute(1, "insert into portfolio values (12,18)");
        this.clientSQLExecute(1, "insert into portfolio values (13,19)");
        GemFireXDQueryObserver old = null;
        String query = "select c.cid, c.tid from customers c where c.tid IN (select sid from portfolio f)";
        try {
            this.sqlExecuteVerify(new int[]{1}, null, query, TestUtil.getResourcesDir() + "/lib/checkSubquery.xml", "subquery_1", true, false);
            this.sqlExecuteVerify(new int[]{1}, null, query, TestUtil.getResourcesDir() + "/lib/checkSubquery.xml", "subquery_1", false, false);
        }
        finally {
            s.execute("drop table portfolio");
            s.execute("drop table customers");
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42416ForDelete() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        String table2 = "create table portfolio (cid int not null, sid int not null,  constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) )";
        String table3 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
        SubqueryDUnit.executeOnDerby(table3, false, null);
        SubqueryDUnit.executeOnDerby(table2, false, null);
        s.execute(table3 + " partition by range " + "(cid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 5 AND 10, " + "VALUES BETWEEN 10 AND 15)");
        s.execute(table2 + " partition by range " + "(cid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 5 AND 10, " + "VALUES BETWEEN 10 AND 15) colocate with (customers)");
        for (int i = 0; i < 15; ++i) {
            String insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
            this.clientSQLExecute(1, insert);
            SubqueryDUnit.executeOnDerby(insert, false, null);
        }
        this.clientSQLExecute(1, "insert into portfolio values (2,7)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (2,7)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (3,8)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (3,8)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (5,12)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (5,12)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (6,13)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (6,13)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (7,2)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (7,2)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (8,3)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (8,3)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (12,18)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (12,18)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (13,19)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (13,19)", false, null);
        GemFireXDQueryObserver old = null;
        String dml = "delete  from portfolio p where p.sid IN (select tid from customers c)";
        try {
            int numGfxdUpdates = SubqueryDUnit.executeUpdate(dml, false, null, false);
            int numDerbyUpdates = SubqueryDUnit.executeUpdate(dml, false, null, true);
            SubqueryDUnit.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
            String query = "select * from portfolio";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            s.execute("drop table portfolio");
            s.execute("drop table customers");
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42416ForUpdate() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        String table2 = "create table portfolio (cid int not null, sid int not null, loan int not null,  constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) )";
        String table3 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
        SubqueryDUnit.executeOnDerby(table3, false, null);
        SubqueryDUnit.executeOnDerby(table2, false, null);
        s.execute(table3 + " partition by range " + "(cid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 5 AND 10, " + "VALUES BETWEEN 10 AND 15)");
        s.execute(table2 + " partition by range " + "(cid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 5 AND 10, " + "VALUES BETWEEN 10 AND 15) colocate with (customers)");
        for (int i = 0; i < 15; ++i) {
            String insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
            this.clientSQLExecute(1, insert);
            SubqueryDUnit.executeOnDerby(insert, false, null);
        }
        this.clientSQLExecute(1, "insert into portfolio values (2,7,100)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (2,7,100)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (3,8,150)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (3,8,150)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (5,12,200)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (5,12,200)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (6,13,250)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (6,13,250)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (7,2,300)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (7,2,300)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (8,3,350)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (8,3,350)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (12,18,400)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (12,18,400)", false, null);
        this.clientSQLExecute(1, "insert into portfolio values (13,19,450)");
        SubqueryDUnit.executeOnDerby("insert into portfolio values (13,19,450)", false, null);
        GemFireXDQueryObserver old = null;
        String dml = "Update  portfolio p set p.loan = p.loan +100 where p.sid IN (select tid from customers c)";
        try {
            int numGfxdUpdates = SubqueryDUnit.executeUpdate(dml, false, null, false);
            int numDerbyUpdates = SubqueryDUnit.executeUpdate(dml, false, null, true);
            SubqueryDUnit.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
            String query = "select * from portfolio";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            s.execute("drop table portfolio");
            s.execute("drop table customers");
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42426_1() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String query2 = "select sec_id, symbol, price from securities s where sec_id IN (select sid from portfolio f where tid  > 0  GROUP BY sid Having count(*) > 2)";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (9,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,4,16,56,8)", false, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            ResultSet rsGfxd = SubqueryDUnit.executeQuery("select sec_id, symbol, price from securities s where sec_id IN (select sid from portfolio f where tid  > 0  GROUP BY sid Having count(*) > 2)", false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery("select sec_id, symbol, price from securities s where sec_id IN (select sid from portfolio f where tid  > 0  GROUP BY sid Having count(*) > 2)", false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery("select sec_id, symbol, price from securities s where sec_id IN (select sid from portfolio f where tid  > 0  GROUP BY sid Having count(*) > 2)", false, null, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery("select sec_id, symbol, price from securities s where sec_id IN (select sid from portfolio f where tid  > 0  GROUP BY sid Having count(*) > 2)", false, null, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42426_1ForDelete_1() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "delete from portfolio f where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (9,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,4,16,56,8)", false, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        int numGfxdUpdates = SubqueryDUnit.executeUpdate("delete from portfolio f where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )", false, null, false);
                        int numDerbyUpdates = SubqueryDUnit.executeUpdate("delete from portfolio f where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )", false, null, true);
                        TestCase.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
                        String query = "select * from portfolio";
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42426_1ForUpdate_1() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "Update portfolio f set f.qty = qty*100 where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (9,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,4,16,56,8)", false, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        int numGfxdUpdates = SubqueryDUnit.executeUpdate("Update portfolio f set f.qty = qty*100 where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )", false, null, false);
                        int numDerbyUpdates = SubqueryDUnit.executeUpdate("Update portfolio f set f.qty = qty*100 where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )", false, null, true);
                        TestCase.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
                        String query = "select * from portfolio";
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42426_1ForDelete_2() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "delete from portfolio f where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (9,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,4,16,56,8)", false, null);
            int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            int numGfxdUpdates = SubqueryDUnit.executeUpdate("delete from portfolio f where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )", false, null, false);
            int numDerbyUpdates = SubqueryDUnit.executeUpdate("delete from portfolio f where tid > 0 and sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )", false, null, true);
            SubqueryDUnit.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
            String query = "select * from portfolio";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42426_1ForUpdate_2() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "Update portfolio f set f.qty = qty + 100 where f.tid > 0 and f.sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (9,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,4,16,56,8)", false, null);
            int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            int numGfxdUpdates = SubqueryDUnit.executeUpdate("Update portfolio f set f.qty = qty + 100 where f.tid > 0 and f.sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )", false, null, false);
            int numDerbyUpdates = SubqueryDUnit.executeUpdate("Update portfolio f set f.qty = qty + 100 where f.tid > 0 and f.sid IN (select sec_id from securities  s where tid  > 0  GROUP BY sec_id )", false, null, true);
            SubqueryDUnit.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
            String query = "select * from portfolio";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42426_2() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String query1 = " select sid from portfolio f where tid > 0 GROUP BY sid Having count(*) > 2 ";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,13,52,5)");
            this.clientSQLExecute(1, "insert into portfolio values (7,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (9,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,13,52,5)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,4,16,56,8)", false, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(" select sid from portfolio f where tid > 0 GROUP BY sid Having count(*) > 2 ", false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(" select sid from portfolio f where tid > 0 GROUP BY sid Having count(*) > 2 ", false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery(" select sid from portfolio f where tid > 0 GROUP BY sid Having count(*) > 2 ", false, null, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery(" select sid from portfolio f where tid > 0 GROUP BY sid Having count(*) > 2 ", false, null, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                        TestUtil.getConnection().close();
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42659() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String query1 = " select * from securities trade where sec_id IN (select sid from portfolio where cid >?) ";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,13,52,5)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (9,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,13,52,5)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,2,11,51,3)", false, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(" select * from securities trade where sec_id IN (select sid from portfolio where cid >?) ", true, new Object[]{new Integer(5)}, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(" select * from securities trade where sec_id IN (select sid from portfolio where cid >?) ", true, new Object[]{new Integer(5)}, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery(" select * from securities trade where sec_id IN (select sid from portfolio where cid >?) ", true, new Object[]{new Integer(100)}, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery(" select * from securities trade where sec_id IN (select sid from portfolio where cid >?) ", true, new Object[]{new Integer(100)}, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                        TestUtil.getConnection().close();
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42697And42673() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String query1 = "select * from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,13,52,5)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (9,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,13,52,5)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,2,11,51,3)", false, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            ResultSet rsGfxd = SubqueryDUnit.executeQuery("select * from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(0)}, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery("select * from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(0)}, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery("select * from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(100)}, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery("select * from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(100)}, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                        TestUtil.getConnection().close();
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42697And42673ForDelete_1() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "delete  from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,13,52,5)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (9,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,13,52,5)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,2,11,51,3)", false, null);
            int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            int numGfxdUpdates = SubqueryDUnit.executeUpdate("delete  from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(0)}, false);
            int numDerbyUpdates = SubqueryDUnit.executeUpdate("delete  from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(0)}, true);
            SubqueryDUnit.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
            String query = "select * from securities";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42697And42673ForUpdate_1() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "Update  securities set symbol = 'no symbol' where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,13,52,5)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (9,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,13,52,5)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,2,11,51,3)", false, null);
            int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            int numGfxdUpdates = SubqueryDUnit.executeUpdate("Update  securities set symbol = 'no symbol' where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(0)}, false);
            int numDerbyUpdates = SubqueryDUnit.executeUpdate("Update  securities set symbol = 'no symbol' where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(0)}, true);
            SubqueryDUnit.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
            SubqueryDUnit.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
            String query = "select * from securities";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42697And42673ForDelete_2() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "delete  from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,13,52,5)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (9,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,13,52,5)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,2,11,51,3)", false, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        int numGfxdUpdates = SubqueryDUnit.executeUpdate("delete  from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(1)}, false);
                        int numDerbyUpdates = SubqueryDUnit.executeUpdate("delete  from securities where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(1)}, true);
                        TestCase.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
                        String query = "select * from securities";
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                        TestUtil.getConnection().close();
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42697And42673ForUpdate_2() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "Update  securities set symbol = 'no symbol' where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null, qty int not null, availQty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict )   ";
            String table4 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int,  constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            for (i = 0; i < 15; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + i + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,10,50,2)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (4,3,12,52,4)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,13,52,5)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,14,70,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,15,55,7)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,16,56,8)");
            this.clientSQLExecute(1, "insert into portfolio values (9,2,11,51,3)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,16,56,8)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,10,50,2)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,11,51,3)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,3,12,52,4)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,13,52,5)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,14,70,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,15,55,7)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,16,56,8)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,2,11,51,3)", false, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        int numGfxdUpdates = SubqueryDUnit.executeUpdate("Update  securities set symbol = 'no symbol' where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(1)}, false);
                        int numDerbyUpdates = SubqueryDUnit.executeUpdate("Update  securities set symbol = 'no symbol' where sec_id IN (select sid from portfolio f where cid =      (select c.cid from customers c where tid > ? and c.cid = f.cid) ) ", true, new Object[]{new Integer(1)}, true);
                        TestCase.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
                        String query = "select * from securities";
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                        TestUtil.getConnection().close();
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    public static void reset() {
        isQueryExecutedOnNode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug43747() throws Exception {
        NetworkServerControl server = null;
        try {
            String insert;
            int i;
            String dml = "delete from networth n where tid = 6 and n.cid IN (select cid from portfolio where tid =6 and sid >=2 and sid <=4 )";
            this.startVMs(1, 3);
            String table1 = "create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))";
            String table2 = "create table securities (sec_id int not null, symbol varchar(10) not null, price int,  tid int, constraint sec_pk primary key (sec_id)  )   ";
            String table3 = "create table portfolio (cid int not null, sid int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references securities (sec_id) on delete restrict)";
            String table4 = "create table networth (cid int not null,   tid int, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references customers (cid) on delete restrict) ";
            String table5 = "create table sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, tid int, constraint portf_fk foreign key (cid, sid) references portfolio (cid, sid) on delete restrict)";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1);
            this.clientSQLExecute(1, table2 + " replicate");
            this.clientSQLExecute(1, table3 + " partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table4 + "partition by column (cid) colocate with (customers)");
            this.clientSQLExecute(1, table5 + "partition by column (cid) colocate with (customers)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            SubqueryDUnit.executeOnDerby(table3, false, null);
            SubqueryDUnit.executeOnDerby(table4, false, null);
            SubqueryDUnit.executeOnDerby(table5, false, null);
            for (i = 0; i < 45; ++i) {
                insert = "insert into customers values (" + i + "," + "'name_" + i + "'," + 6 + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 45; ++i) {
                insert = "insert into networth values (" + i + "," + 6 + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 0; i < 40; ++i) {
                insert = "insert into securities values (" + i + "," + "'sec_" + i + "'," + i * 10 + "," + 6 + ")";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            this.clientSQLExecute(1, "insert into portfolio values (2,2,6)");
            this.clientSQLExecute(1, "insert into portfolio values (3,2,6)");
            this.clientSQLExecute(1, "insert into portfolio values (4,2,6)");
            this.clientSQLExecute(1, "insert into portfolio values (5,3,6)");
            this.clientSQLExecute(1, "insert into portfolio values (6,3,6)");
            this.clientSQLExecute(1, "insert into portfolio values (7,4,6)");
            this.clientSQLExecute(1, "insert into portfolio values (8,4,6)");
            this.clientSQLExecute(1, "insert into portfolio values (9,4,6)");
            this.clientSQLExecute(1, "insert into portfolio values (10,4,6)");
            SubqueryDUnit.executeOnDerby("insert into portfolio values (2,2,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (3,2,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (4,2,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (5,3,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (6,3,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (7,4,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (8,4,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (10,4,6)", false, null);
            SubqueryDUnit.executeOnDerby("insert into portfolio values (9,4,6)", false, null);
            this.startServerVMs(1, 0, null);
            final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            server = new NetworkServerControl(InetAddress.getByName("localhost"), derbyPort);
            server.start(null);
            ClientServerDUnit.waitForDerbyInitialization(server);
            SerializableRunnable csr = new SerializableRunnable("query executor"){
                final String uName;
                final String psswd;
                {
                    super(x0);
                    this.uName = TestUtil.currentUserName;
                    this.psswd = TestUtil.currentUserPassword;
                }

                public void run() throws CacheException {
                    try {
                        TestUtil.currentUserName = this.uName;
                        TestUtil.currentUserPassword = this.psswd;
                        String derbyDbUrl = "jdbc:derby://localhost:" + derbyPort + "/newDB;";
                        if (TestUtil.currentUserName != null) {
                            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                        }
                        derbyConn = DriverManager.getConnection(derbyDbUrl);
                        int numGfxdUpdates = SubqueryDUnit.executeUpdate("delete from networth n where tid = 6 and n.cid IN (select cid from portfolio where tid =6 and sid >=2 and sid <=4 )", false, null, false);
                        int numDerbyUpdates = SubqueryDUnit.executeUpdate("delete from networth n where tid = 6 and n.cid IN (select cid from portfolio where tid =6 and sid >=2 and sid <=4 )", false, null, true);
                        String query = "select * from networth";
                        ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
                        ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
                        TestUtil.validateResults(rsDerby, rsGfxd, false);
                        TestCase.assertTrue((numDerbyUpdates > 0 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)numDerbyUpdates, (int)numGfxdUpdates);
                        TestUtil.getConnection().close();
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            csr.run();
        }
        finally {
            this.clientSQLExecute(1, "drop table networth");
            this.clientSQLExecute(1, "drop table sellorders");
            this.clientSQLExecute(1, "drop table portfolio");
            this.clientSQLExecute(1, "drop table securities");
            this.clientSQLExecute(1, "drop table customers");
            SubqueryDUnit.executeOnDerby("drop table networth", false, null);
            SubqueryDUnit.executeOnDerby("drop table sellorders", false, null);
            SubqueryDUnit.executeOnDerby("drop table portfolio", false, null);
            SubqueryDUnit.executeOnDerby("drop table securities", false, null);
            SubqueryDUnit.executeOnDerby("drop table customers", false, null);
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42856() throws Exception {
        try {
            String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 = ( select DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 > 'desc1_1' intersect select DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 < 'desc1_3')";
            this.startVMs(1, 3);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1 + "  partition by column(ID1)");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            for (int i = 1; i < 4; ++i) {
                String insert = "Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "','add1_" + i + "')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            SubqueryDUnit.assertTrue((boolean)rsDerby.next());
            SubqueryDUnit.assertFalse((boolean)rsDerby.next());
            rsDerby.close();
            try {
                ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
                SubqueryDUnit.fail((String)"Test should fail with feature not supported exception");
            }
            catch (SQLException sqle) {
                SubqueryDUnit.assertEquals((String)"0A000", (String)sqle.getSQLState());
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatementMatchingForSubquery() throws Exception {
        try {
            String insert;
            int i;
            this.startVMs(1, 2);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null , primary key (ID1))";
            String table2 = "create table TESTTABLE2 (ID int not null,ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID) )";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.clientSQLExecute(1, table1 + " partition by primary key  ");
            this.clientSQLExecute(1, table2 + " partition by primary key  ");
            SubqueryDUnit.executeOnDerby(table1, false, null);
            SubqueryDUnit.executeOnDerby(table2, false, null);
            for (i = 1; i < 20; ++i) {
                insert = "Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "','add1_" + i + "')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (i = 1; i < 20; ++i) {
                insert = "Insert into  TESTTABLE2 values(" + i + ",1,'desc2_" + i + "', 'add2_" + i + "')";
                this.clientSQLExecute(1, insert);
                SubqueryDUnit.executeOnDerby(insert, false, null);
            }
            for (VM vm : this.serverVMs) {
                vm.invoke(SubqueryDUnit.class, "reset");
            }
            SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver on DataStore Node for test= testStatementMatchingForSubquery"){
                private List<SelectQueryInfo> sqiList;
                private int numTimesInvoked;
                {
                    this.sqiList = new ArrayList<SelectQueryInfo>();
                    this.numTimesInvoked = 0;
                }

                public void run() throws CacheException {
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                            public void afterGemFireActivationCreate(AbstractGemFireActivation ac) {
                                try {
                                    SelectQueryInfo sqi = (SelectQueryInfo)TestUtil.getField(AbstractGemFireActivation.class, ac, "qInfo");
                                    sqiList.add(sqi);
                                }
                                catch (Exception e) {
                                    throw new GemFireXDRuntimeException((Throwable)e);
                                }
                                ++numTimesInvoked;
                                SubqueryDUnit.this.getLogWriter().info((Object)("Number of time GemFireActivation got created = " + numTimesInvoked));
                                SubqueryDUnit.this.getLogWriter().info((Object)("query string for activation = " + ac.getPreparedStatement().getSource()));
                                boolean bl = isQueryExecutedOnNode = sqiList.size() == 4;
                                if (isQueryExecutedOnNode) {
                                    for (int i = 0; i < 3; ++i) {
                                        TestCase.assertEquals(sqiList.get(i), sqiList.get(i + 1));
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            for (VM vm : this.serverVMs) {
                vm.invoke((Runnable)setObserver);
            }
            String query = "select  DESCRIPTION1 from TESTTABLE1 where ID1 IN (select ID2 from TESTTABLE2 where ID2 > 5) and ID1 > 8";
            ResultSet rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            ResultSet rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
            query = "select  DESCRIPTION1 from TESTTABLE1 where ID1 IN (select ID2 from TESTTABLE2 where ID2 > 9) and ID1 > 13";
            rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
            query = "select  DESCRIPTION1 from TESTTABLE1 where ID1 IN (select ID2 from TESTTABLE2 where ID2 > 2) and ID1 > 1";
            rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
            query = "select  DESCRIPTION1 from TESTTABLE1 where ID1 IN (select ID2 from TESTTABLE2 where ID2 > 0) and ID1 > 0";
            rsGfxd = SubqueryDUnit.executeQuery(query, false, null, false);
            rsDerby = SubqueryDUnit.executeQuery(query, false, null, true);
            TestUtil.validateResults(rsDerby, rsGfxd, false);
            SerializableRunnable assertQueryExec = new SerializableRunnable("Assert that queryExecutedOnNode is true"){

                public void run() throws CacheException {
                    TestCase.assertTrue((boolean)isQueryExecutedOnNode);
                }
            };
            for (VM vm : this.serverVMs) {
                vm.invoke((Runnable)assertQueryExec);
            }
        }
        finally {
            this.cleanup();
        }
    }
}

