/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.NodesPruningHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireSelectActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class StatementQueryDUnit
extends DistributedSQLTestBase {
    private static volatile long connID;
    private static volatile long stmtID;
    private static volatile boolean skipListeners;

    public StatementQueryDUnit(String name) {
        super(name);
    }

    private void checkOneResult(ResultSet rs) throws SQLException {
        StatementQueryDUnit.assertTrue((String)"Expected one result", (boolean)rs.next());
        if (rs.next()) {
            StatementQueryDUnit.fail((String)("unexpected next element with ID: " + rs.getObject(1)));
        }
    }

    public void testSerializationData() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null , primary key (ID))");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (0, 'Zero')");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
                            connID = wrapper.getIncomingConnectionId();
                            stmtID = stmt.getID();
                            try {
                                EmbedConnection conn = wrapper.getConnectionForSynchronization();
                                skipListeners = conn.getLanguageConnectionContext().isSkipListeners();
                            }
                            catch (SQLException sqle) {
                                throw new GemFireXDRuntimeException((Throwable)sqle);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        Properties props = new Properties();
        props.put("skip-listeners", "true");
        EmbedConnection mcon = (EmbedConnection)TestUtil.getConnection(props);
        EmbedStatement es = (EmbedStatement)mcon.createStatement();
        ResultSet rs = es.executeQuery("select ID, DESCRIPTION from EMP.TESTTABLE where id > 0");
        this.checkOneResult(rs);
        final long clientConnID = mcon.getConnectionID();
        final long clientStmntID = es.getID();
        SerializableRunnable validate = new SerializableRunnable("validate"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertEquals((long)clientConnID, (long)connID);
                    TestCase.assertEquals((long)clientStmntID, (long)stmtID);
                    TestCase.assertTrue((boolean)skipListeners);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)validate);
        dataStore2.invoke((Runnable)validate);
        this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
        this.clientSQLExecute(1, "Drop schema EMP restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionGetConversionForCompositeKey() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), Primary Key (ID, DESCRIPTION))");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'asif')");
        final boolean[] callback = new boolean[]{false};
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                    StatementQueryDUnit.getGlobalLogger().info((Object)("StatementQueryDunit::testRegionGetConversionForCompositeKey: The activation object is = " + activation));
                    TestCase.assertTrue((boolean)(activation instanceof GemFireSelectActivation));
                    callback[0] = true;
                }
            });
            TestUtil.setupConnection();
            EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            ResultSet rs = es.executeQuery("select ID, DESCRIPTION from EMP.TESTTABLE where id = 1 AND DESCRIPTION = 'First'");
            StatementQueryDUnit.assertTrue((boolean)rs.next());
            StatementQueryDUnit.assertEquals((int)rs.getInt(1), (int)1);
            StatementQueryDUnit.assertTrue((boolean)callback[0]);
            StatementQueryDUnit.assertFalse((boolean)rs.next());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    public void testBug39364() throws Exception {
        this.startVMs(1, 1);
        String queryStr = "select ID, DESCRIPTION from EMP.TESTTABLE where id IN (1,2,3) order by ID asc";
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID))");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'First', 'J 604')");
        TestUtil.setupConnection();
        EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
        ResultSet rs = es.executeQuery("select ID, DESCRIPTION from EMP.TESTTABLE where id IN (1,2,3) order by ID asc");
        for (int i = 0; i < 3; ++i) {
            rs.next();
            StatementQueryDUnit.assertEquals((int)rs.getInt(1), (int)(i + 1));
        }
        StatementQueryDUnit.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNodesBehaviourForPartitionKeySameAsPrimaryKey() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ID  > 6 AND ID =7 ";
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) PARTITION BY RANGE ( ID ) (VALUES BETWEEN -Infinity and 5, VALUES BETWEEN 5 and +Infinity)");
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            Activation[] actArr = new Activation[1];
            NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqi, actArr);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            ResultSet rs = stmnt.executeQuery(query);
            this.checkOneResult(rs);
            HashSet<InternalDistributedMember> members = new HashSet<InternalDistributedMember>();
            HashSet<Object> routingKeys = new HashSet<Object>();
            routingKeys.add(ResolverUtils.TOK_ALL_NODES);
            sqi[0].computeNodes(routingKeys, actArr[0], false);
            members.addAll(NodesPruningHelper.convertRoutingKeysIntoMembersForPR(routingKeys, (PartitionedRegion)sqi[0].getRegion()));
            PartitionedRegion pr = (PartitionedRegion)sqi[0].getRegion();
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            Object[] routingObjects = spr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(5), true, null, true);
            Set prunedNodes = pr.getMembersFromRoutingObjects(routingObjects);
            StatementQueryDUnit.assertEquals((int)members.size(), (int)prunedNodes.size());
            members.removeAll(prunedNodes);
            StatementQueryDUnit.assertTrue((boolean)members.isEmpty());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNodesBehaviourWithSingleColumnAsPartitoningKey_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) PARTITION BY COLUMN ( ID )");
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        Object[][] queries = new Object[][]{{"select ID, DESCRIPTION from TESTTABLE where ID  > 6 AND ID = 7 ", new Object[][]{{new Integer(3), new SQLInteger(7)}}}, {"select ID, DESCRIPTION from TESTTABLE where ID  > 6 AND ID IN ( 7 )", new Object[][]{{new Integer(3), new SQLInteger(7)}}}, {"select ID, DESCRIPTION from TESTTABLE where  ID IN ( 7 ,9)", new Object[][]{{new Integer(3), new SQLInteger(7)}, {new Integer(3), new SQLInteger(9), new Integer(5)}}}, {"select ID, DESCRIPTION from TESTTABLE where  ID IN ( 7 ,8) OR ID = 6 ", new Object[][]{{new Integer(2), new SQLInteger(7), new SQLInteger(8), new SQLInteger(6)}}}, {"select ID, DESCRIPTION from TESTTABLE where  ID > 7 AND  ID < 66 ", new Object[][]{{new Integer(6)}}}};
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                Activation[] actArr = new Activation[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr, actArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                NodesPruningHelper.validateNodePruningForQuery(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this, actArr[0]);
                rs.close();
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNodesBehaviourWithSingleColumnAsPartitoningKey_2() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID, DESCRIPTION)) PARTITION BY COLUMN (ID)");
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        Object[][] queries = new Object[][]{{"select ID, DESCRIPTION from TESTTABLE where ID  > 6 AND ID = 7 ", new Object[][]{{new Integer(3), new SQLInteger(7)}}}, {"select ID, DESCRIPTION from TESTTABLE where ID  > 6 AND ID IN ( 7 )", new Object[][]{{new Integer(3), new SQLInteger(7)}}}, {"select ID, DESCRIPTION from TESTTABLE where  ID IN ( 7 ,8) OR ID = 6 ", new Object[][]{{new Integer(2), new SQLInteger(7), new SQLInteger(8), new SQLInteger(6)}}}, {"select ID, DESCRIPTION from TESTTABLE where  ID > 7 AND  ID < 66 ", new Object[][]{{new Integer(6)}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                Activation[] actArr = new Activation[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr, actArr);
                String queryString = (String)queries[i][0];
                TestUtil.setupConnection();
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                NodesPruningHelper.validateNodePruningForQuery(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this, actArr[0]);
                rs.close();
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNodesBehaviourWithMultipleColumnsAsPartitoningKey() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, NAME varchar(1024) not null, primary key (ID, DESCRIPTION,NAME)) PARTITION BY COLUMN (DESCRIPTION, NAME)");
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604','Asif" + (i + 1) + "' )");
        }
        Object[][] queries = new Object[][]{{"select ID, DESCRIPTION from TESTTABLE where DESCRIPTION = 'First1' AND NAME = 'Asif1' ", new Object[][]{{new Integer(3), new String("First1"), new String("Asif1")}}}, {"select ID, DESCRIPTION from TESTTABLE where ID  > 6 AND ID IN ( 7 )", new Object[][]{{new Integer(3), new SQLInteger(7)}}}, {"select ID, DESCRIPTION from TESTTABLE where  ID IN ( 7 ,8) OR ID = 6 ", new Object[][]{{new Integer(2), new SQLInteger(7), new SQLInteger(8), new SQLInteger(6)}}}, {"select ID, DESCRIPTION from TESTTABLE where  ID > 7 AND  ID < 66 ", new Object[][]{{new Integer(6)}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr);
                String queryString = (String)queries[i][0];
                TestUtil.setupConnection();
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                rs.close();
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    public void testLikePredicateQuery_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int primary key,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, NAME varchar(1024) not null) PARTITION BY Primary Key");
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604','Asif" + (i + 1) + "' )");
        }
        this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ADDRESS like '%604'", TestUtil.getResourcesDir() + "/lib/checkStatementQueryDUnit.xml", "testLikePredicateQuery_1", false, false);
    }

    public void testLikePredicateQuery_2() throws Exception {
        int i;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int primary key,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null) PARTITION BY Primary key");
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int  primary key,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, ID_FK int, foreign key (ID_FK) references TESTTABLE1(ID1))");
        for (i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604' )");
        }
        for (i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604', " + (i + 1) + " )");
        }
        this.sqlExecuteVerify(new int[]{1}, null, "select ID2 from TESTTABLE2 where ADDRESS2 like '%604'", TestUtil.getResourcesDir() + "/lib/checkStatementQueryDUnit.xml", "testLikePredicateQuery_2", false, false);
    }

    public void testBug40626() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int primary key,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, NAME varchar(1024) not null) PARTITION BY Primary Key");
        this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE ", TestUtil.getResourcesDir() + "/lib/checkStatementQueryDUnit.xml", "testBug40626", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE ", TestUtil.getResourcesDir() + "/lib/checkStatementQueryDUnit.xml", "testBug40626", true, false);
    }

    static {
        skipListeners = false;
    }
}

