/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.NodesPruningHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import io.snappydata.test.dunit.VM;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;

public class StatementNodesPrunningDUnit
extends DistributedSQLTestBase {
    public StatementNodesPrunningDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiConditionWhereClauseWithRangePartitioning() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ID >= 1 and ID <= 3";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 8 )" + this.getSuffix());
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 1; i < 4; ++i) {
                rslts.add(i);
            }
            ResultSet rs = stmnt.executeQuery(query);
            for (int i = 1; i < 4; ++i) {
                StatementNodesPrunningDUnit.assertTrue((boolean)rs.next());
                StatementNodesPrunningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.isEmpty());
            StatementNodesPrunningDUnit.assertFalse((boolean)rs.next());
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(1), Boolean.TRUE, new SQLInteger(3), Boolean.FALSE}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 1, 2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRangePartitionBehaviourForPartitioningColumnEqualityOutsideRange() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where PartitionColumn = 7";
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, PartitionColumn int, primary key (ID)) PARTITION BY RANGE ( PartitionColumn) ( VALUES BETWEEN 0 and 5)" + this.getSuffix());
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            Activation[] actArr = new Activation[1];
            NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqi, actArr);
            TestUtil.setupConnection();
            TestUtil.jdbcConn.prepareStatement(query);
            HashSet<Object> actualRoutingKeys = new HashSet<Object>();
            actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
            sqi[0].computeNodes(actualRoutingKeys, null, false);
            StatementNodesPrunningDUnit.assertEquals((int)actualRoutingKeys.size(), (int)1);
            StatementNodesPrunningDUnit.assertEquals(actualRoutingKeys.iterator().next(), (Object)7);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRangePartitionBehaviourForPartitioningColumnEqualityListOutsideRange() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where PartitionColumn IN (1,2, 7)";
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, PartitionColumn int, primary key (ID)) PARTITION BY RANGE ( PartitionColumn) ( VALUES BETWEEN 0 and 5)" + this.getSuffix());
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            Activation[] actArr = new Activation[1];
            NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqi, actArr);
            TestUtil.setupConnection();
            TestUtil.jdbcConn.prepareStatement(query);
            HashSet<Object> actualRoutingKeys = new HashSet<Object>();
            actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
            sqi[0].computeNodes(actualRoutingKeys, null, false);
            StatementNodesPrunningDUnit.assertEquals((int)actualRoutingKeys.size(), (int)2);
            StatementNodesPrunningDUnit.assertTrue((boolean)actualRoutingKeys.contains(7));
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39911() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where PartitionColumn = 7";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, PartitionColumn int, primary key (ID)) PARTITION BY RANGE ( PartitionColumn) ( VALUES BETWEEN 0 and 5)" + this.getSuffix());
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604', " + (i + 1) + ")");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            rslts.add(7);
            ResultSet rs = stmnt.executeQuery(query);
            StatementNodesPrunningDUnit.assertTrue((boolean)rs.next());
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.isEmpty());
            StatementNodesPrunningDUnit.assertFalse((boolean)rs.next());
            Object[][] routingInfo = new Object[][]{{new Integer(3), new SQLInteger(7)}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 1, 2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleConditionWhereClauseWithRangePartitioning_1() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ID  >= 5 ";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -Infinity and 5, VALUES BETWEEN  5 and +Infinity )" + this.getSuffix());
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 5; i < 9; ++i) {
                rslts.add(i);
            }
            ResultSet rs = stmnt.executeQuery(query);
            for (int i = 5; i < 9; ++i) {
                StatementNodesPrunningDUnit.assertTrue((boolean)rs.next());
                StatementNodesPrunningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.isEmpty());
            StatementNodesPrunningDUnit.assertFalse((boolean)rs.next());
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(5), Boolean.TRUE, null, Boolean.TRUE}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 1, 2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleConditionWhereClauseWithRangePartitioning_2() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ID  >= 5 ";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -Infinity and 5, VALUES BETWEEN  5 and +Infinity )" + this.getSuffix());
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 5; i < 9; ++i) {
                rslts.add(i);
            }
            ResultSet rs = stmnt.executeQuery(query);
            for (int i = 5; i < 9; ++i) {
                StatementNodesPrunningDUnit.assertTrue((boolean)rs.next());
                StatementNodesPrunningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            StatementNodesPrunningDUnit.assertFalse((boolean)rs.next());
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.isEmpty());
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(5), Boolean.TRUE, null, Boolean.TRUE}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 1, 2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoExplicitResolverDefined_Bug39680() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ID  = 5 and DESCRIPTION = 'First5' ";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))" + this.getSuffix());
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            rslts.add(5);
            ResultSet rs = stmnt.executeQuery(query);
            StatementNodesPrunningDUnit.assertTrue((boolean)rs.next());
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.isEmpty());
            StatementNodesPrunningDUnit.assertFalse((boolean)rs.next());
            Object[][] routingInfo = new Object[][]{{new Integer(3), new SQLInteger(5)}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 1, 2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListPartitioningForDefaultResolver() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ID  IN (5,6) and DESCRIPTION <> '' ";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))" + this.getSuffix());
        for (int i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            rslts.add(5);
            rslts.add(6);
            ResultSet rs = stmnt.executeQuery(query);
            StatementNodesPrunningDUnit.assertTrue((boolean)rs.next());
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            StatementNodesPrunningDUnit.assertTrue((boolean)rs.next());
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            StatementNodesPrunningDUnit.assertFalse((boolean)rs.next());
            StatementNodesPrunningDUnit.assertTrue((boolean)rslts.isEmpty());
            Object[][] routingInfo = new Object[][]{{new Integer(2), new SQLInteger(5), new SQLInteger(6)}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 2, 1);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    public String getSuffix() {
        return "  ";
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
        StatementNodesPrunningDUnit.reset();
    }
}

