/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.TreeMap;
import junit.framework.Assert;
import org.apache.log4j.Logger;

public class SetQueriesDUnitHelper {
    static String schemaName = "setopqry";
    static int currentCount = 0;
    private static final int MAXQUERIES = 35;
    static final String[] queryStringsLeft = new String[35];
    static final String[] queryStringsRight = new String[35];
    static final int[] unionResult_withPK = new int[35];
    static final int[] unionAllResult_withPK = new int[35];
    static final int[] intersectResult_withPK = new int[35];
    static final int[] intersectAllResult_withPK = new int[35];
    static final int[] exceptResult_withPK = new int[35];
    static final int[] exceptAllResult_withPK = new int[35];
    static final int[] unionResult_noPK = new int[35];
    static final int[] unionAllResult_noPK = new int[35];
    static final int[] intersectResult_noPK = new int[35];
    static final int[] intersectAllResult_noPK = new int[35];
    static final int[] exceptResult_noPK = new int[35];
    static final int[] exceptAllResult_noPK = new int[35];

    private static void setResults_withPK(int unionCount, int unionAllCount, int intersectCount, int intersectAllCount, int exceptCount, int exceptAllCount) {
        SetQueriesDUnitHelper.unionResult_withPK[SetQueriesDUnitHelper.currentCount] = unionCount;
        SetQueriesDUnitHelper.unionAllResult_withPK[SetQueriesDUnitHelper.currentCount] = unionAllCount;
        SetQueriesDUnitHelper.intersectResult_withPK[SetQueriesDUnitHelper.currentCount] = intersectCount;
        SetQueriesDUnitHelper.intersectAllResult_withPK[SetQueriesDUnitHelper.currentCount] = intersectAllCount;
        SetQueriesDUnitHelper.exceptResult_withPK[SetQueriesDUnitHelper.currentCount] = exceptCount;
        SetQueriesDUnitHelper.exceptAllResult_withPK[SetQueriesDUnitHelper.currentCount] = exceptAllCount;
    }

    private static void setResults_noPK(int unionCount, int unionAllCount, int intersectCount, int intersectAllCount, int exceptCount, int exceptAllCount) {
        SetQueriesDUnitHelper.unionResult_noPK[SetQueriesDUnitHelper.currentCount] = unionCount;
        SetQueriesDUnitHelper.unionAllResult_noPK[SetQueriesDUnitHelper.currentCount] = unionAllCount;
        SetQueriesDUnitHelper.intersectResult_noPK[SetQueriesDUnitHelper.currentCount] = intersectCount;
        SetQueriesDUnitHelper.intersectAllResult_noPK[SetQueriesDUnitHelper.currentCount] = intersectAllCount;
        SetQueriesDUnitHelper.exceptResult_noPK[SetQueriesDUnitHelper.currentCount] = exceptCount;
        SetQueriesDUnitHelper.exceptAllResult_noPK[SetQueriesDUnitHelper.currentCount] = exceptAllCount;
    }

    static void createLocalIndex(Connection conn, String tabname, String columnname) throws SQLException {
        String tablename = schemaName + "." + tabname;
        String indexName = tabname + columnname + columnname.length();
        Statement s = conn.createStatement();
        s.execute("create INDEX " + indexName + " on " + tablename + "(" + columnname + ")");
        s.close();
    }

    static void loadSampleData(Logger logw, Connection conn, int numOfRows, String tabname, int startVal) throws SQLException {
        String tablename = schemaName + "." + tabname;
        logw.info((Object)("Loading data (" + numOfRows + " rows..." + startVal + " as start value)..."));
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        PreparedStatement psInsert = conn.prepareStatement("insert into " + tablename + " values (?, ?, ?, ?, ?, ?)");
        for (int i = 0; i < numOfRows; ++i) {
            int baseId = i + startVal;
            String custName = "CustomerWithaLongName" + baseId;
            psInsert.setInt(1, baseId);
            psInsert.setString(2, custName);
            psInsert.setInt(3, baseId);
            psInsert.setString(4, securities[baseId % 10]);
            psInsert.setInt(5, 0);
            String queryString = "Emperors club for desperate men, Washington DC, District of Columbia";
            psInsert.setString(6, queryString);
            psInsert.executeUpdate();
        }
    }

    static void dropTable(Connection conn, String tabname) throws SQLException {
        String tablename = schemaName + "." + tabname;
        Statement s = conn.createStatement();
        s.execute("drop table " + tablename);
        s.close();
    }

    static void createSchema(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create schema " + schemaName);
        s.close();
    }

    static void dropSchema(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("drop schema " + schemaName + " RESTRICT");
        s.close();
    }

    static void executeSetOp_1(Logger logw, String queryType, int expectedRows, String query1, String query2, Connection conn, String failureMessage, int failIndex) throws Exception {
        SanityManager.ASSERT((query1 != null ? 1 : 0) != 0, (String)"Query1 is null");
        SanityManager.ASSERT((query2 != null ? 1 : 0) != 0, (String)"Query2 is null");
        String execQuery = query1 + " " + queryType + " " + query2;
        logw.info((Object)("Execute Query[" + failIndex + "]: " + execQuery));
        ResultSet rs = conn.createStatement().executeQuery(execQuery);
        int rowCount = 0;
        TreeMap<Integer, Integer> resultMap = new TreeMap<Integer, Integer>();
        while (rs.next()) {
            ++rowCount;
            resultMap.put(rs.getInt(1), resultMap.get(rs.getInt(1)) == null ? 1 : (Integer)resultMap.get(rs.getInt(1)) + 1);
        }
        rs.close();
        logw.info((Object)("expectedRows : " + expectedRows + " Got : " + rowCount));
        logw.info((Object)((Object)resultMap).toString());
        Assert.assertEquals((String)(failureMessage + execQuery), (int)expectedRows, (int)rowCount);
    }

    static void callExecuteSetOp_withPK(Logger logw, boolean doSetOp, boolean doSetOpDistinct, boolean doSetOpAll, Connection conn, String failureMessage) throws Exception {
        String onFailMessage;
        int i;
        SanityManager.ASSERT((conn != null ? 1 : 0) != 0, (String)"Connection is null");
        if (doSetOp) {
            for (i = 0; i < currentCount; ++i) {
                onFailMessage = failureMessage + " query: " + "(" + i + ") ";
                SetQueriesDUnitHelper.executeSetOp_1(logw, "union", unionResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "intersect", intersectResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "except", exceptResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
            }
        }
        if (doSetOpDistinct) {
            for (i = 0; i < currentCount; ++i) {
                onFailMessage = failureMessage + " query: " + "(" + i + ") ";
                SetQueriesDUnitHelper.executeSetOp_1(logw, "union distinct", unionResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "intersect distinct", intersectResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "except distinct", exceptResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
            }
        }
        if (doSetOpAll) {
            for (i = 0; i < currentCount; ++i) {
                onFailMessage = failureMessage + " query: " + "(" + i + ") ";
                SetQueriesDUnitHelper.executeSetOp_1(logw, "union all", unionAllResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "intersect all", intersectAllResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "except all", exceptAllResult_withPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
            }
        }
    }

    static void callExecuteSetOp_noPK(Logger logw, boolean doSetOp, boolean doSetOpDistinct, boolean doSetOpAll, Connection conn, String failureMessage) throws Exception {
        String onFailMessage;
        int i;
        SanityManager.ASSERT((conn != null ? 1 : 0) != 0, (String)"Connection is null");
        if (doSetOp) {
            for (i = 0; i < currentCount; ++i) {
                onFailMessage = failureMessage + " query: " + "(" + i + ") ";
                SetQueriesDUnitHelper.executeSetOp_1(logw, "union", unionResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "intersect", intersectResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "except", exceptResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
            }
        }
        if (doSetOpDistinct) {
            for (i = 0; i < currentCount; ++i) {
                onFailMessage = failureMessage + " query: " + "(" + i + ") ";
                SetQueriesDUnitHelper.executeSetOp_1(logw, "union distinct", unionResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "intersect distinct", intersectResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "except distinct", exceptResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
            }
        }
        if (doSetOpAll) {
            for (i = 0; i < currentCount; ++i) {
                onFailMessage = failureMessage + " query: " + "(" + i + ") ";
                SetQueriesDUnitHelper.executeSetOp_1(logw, "union all", unionAllResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "intersect all", intersectAllResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
                SetQueriesDUnitHelper.executeSetOp_1(logw, "except all", exceptAllResult_noPK[i], queryStringsLeft[i], queryStringsRight[i], conn, onFailMessage, i);
            }
        }
    }

    static void caseSetOperators_noColoc_withPK_scenario1(Logger logw, int leftTableIndex, int rightTableIndex, boolean createIndex, int redundancy, boolean setOPDistinct, boolean setOpAll, CreateTableDUnitF[] createTableFunctions_noColoc_withPK) throws Exception {
        if (setOPDistinct || setOpAll) {
            Properties props = new Properties();
            Connection conn = TestUtil.getConnection(props);
            SetQueriesDUnitHelper.createSchema(conn);
            logw.info((Object)("SetOperatorQueriesDUnit.caseSetOperators_noColoc_withPK_scenario1: With Index " + createIndex + " with redundancy " + redundancy));
            logw.info((Object)("Execute left create table: [" + leftTableIndex + "] " + createTableFunctions_noColoc_withPK[leftTableIndex].getClass().getName()));
            createTableFunctions_noColoc_withPK[leftTableIndex].createTableFunction(conn, "orders1", redundancy);
            logw.info((Object)("Execute right create table: [" + rightTableIndex + "] " + createTableFunctions_noColoc_withPK[rightTableIndex].getClass().getName()));
            createTableFunctions_noColoc_withPK[rightTableIndex].createTableFunction(conn, "orders2", redundancy);
            if (createIndex) {
                logw.info((Object)"Execute create index on left table: ");
                SetQueriesDUnitHelper.createLocalIndex(conn, "orders1", "vol");
                logw.info((Object)"Execute create index on right table: ");
                SetQueriesDUnitHelper.createLocalIndex(conn, "orders2", "vol");
            }
            SetQueriesDUnitHelper.loadSampleData(logw, conn, 20, "orders1", 0);
            SetQueriesDUnitHelper.loadSampleData(logw, conn, 20, "orders2", 10);
            logw.info((Object)("call execute with: doUnion/Intersect/Except " + setOPDistinct + " doUnion/Intersect/ExceptDistinct " + setOPDistinct + " doUnion/Intersect/ExceptAll " + setOpAll));
            String onFailMessage = "create table: [" + leftTableIndex + "]" + "[" + rightTableIndex + "] " + "with index" + "(" + createIndex + ") " + "redundancy" + "(" + redundancy + ") ";
            SetQueriesDUnitHelper.callExecuteSetOp_withPK(logw, setOPDistinct, setOPDistinct, setOpAll, conn, onFailMessage);
            SetQueriesDUnitHelper.dropTable(conn, "orders2");
            SetQueriesDUnitHelper.dropTable(conn, "orders1");
            SetQueriesDUnitHelper.dropSchema(conn);
        } else {
            logw.info((Object)("SetOperatorQueriesDUnit.caseSetOperators_noColoc_withPK_scenario1: With Index " + createIndex + " with redundancy " + redundancy + "Did not execute for being disabled"));
        }
    }

    static {
        assert (currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1";
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2";
        SetQueriesDUnitHelper.setResults_withPK(30, 40, 10, 10, 10, 10);
        SetQueriesDUnitHelper.setResults_noPK(30, 100, 10, 20, 10, 40);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1";
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select id, cust_name, vol, security_id, num, addr from " + schemaName + ".orders2";
        SetQueriesDUnitHelper.setResults_withPK(30, 40, 10, 10, 10, 10);
        SetQueriesDUnitHelper.setResults_noPK(30, 100, 10, 20, 10, 40);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select id, cust_name, vol, security_id, num, addr from " + schemaName + ".orders1";
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2";
        SetQueriesDUnitHelper.setResults_withPK(30, 40, 10, 10, 10, 10);
        SetQueriesDUnitHelper.setResults_noPK(30, 100, 10, 20, 10, 40);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1";
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2";
        SetQueriesDUnitHelper.setResults_withPK(30, 40, 10, 10, 10, 10);
        SetQueriesDUnitHelper.setResults_noPK(30, 100, 10, 20, 10, 40);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 9;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(1, 3, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 18;
        SetQueriesDUnitHelper.setResults_withPK(1, 2, 1, 1, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(1, 5, 1, 2, 0, 1);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 28;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 28;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(1, 2, 0, 0, 0, 0);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 38;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 38;
        SetQueriesDUnitHelper.setResults_withPK(0, 0, 0, 0, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(0, 0, 0, 0, 0, 0);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 28;
        SetQueriesDUnitHelper.setResults_withPK(2, 2, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(2, 5, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 18;
        SetQueriesDUnitHelper.setResults_withPK(2, 2, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(2, 5, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 38;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(1, 3, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 38;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 25;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(1, 2, 0, 0, 0, 0);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select id, cust_name, vol, security_id, num, addr from " + schemaName + ".orders1" + " where id = " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select id, cust_name, vol, security_id, num, addr from " + schemaName + ".orders2" + " where id = " + 28;
        SetQueriesDUnitHelper.setResults_withPK(2, 2, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(2, 5, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select id, cust_name, vol, security_id, num, addr from " + schemaName + ".orders1" + " where id = " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 18;
        SetQueriesDUnitHelper.setResults_withPK(2, 2, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(2, 5, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select id, cust_name, vol, security_id, num, addr from " + schemaName + ".orders1" + " where id = " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id = " + 38;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(1, 3, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id = " + 38;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select id, cust_name, vol, security_id, num, addr from " + schemaName + ".orders2" + " where id = " + 25;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(1, 2, 0, 0, 0, 0);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id < " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id < " + 18;
        SetQueriesDUnitHelper.setResults_withPK(18, 26, 8, 8, 10, 10);
        SetQueriesDUnitHelper.setResults_noPK(18, 70, 8, 16, 10, 38);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id > " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id > " + 18;
        SetQueriesDUnitHelper.setResults_withPK(11, 12, 1, 1, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(11, 25, 1, 2, 0, 1);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id < " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id > " + 28;
        SetQueriesDUnitHelper.setResults_withPK(10, 10, 0, 0, 9, 9);
        SetQueriesDUnitHelper.setResults_noPK(10, 29, 0, 0, 9, 27);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id > " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id < " + 18;
        SetQueriesDUnitHelper.setResults_withPK(10, 18, 8, 8, 2, 2);
        SetQueriesDUnitHelper.setResults_noPK(10, 46, 8, 16, 2, 14);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where id < " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where id > " + 38;
        SetQueriesDUnitHelper.setResults_withPK(18, 18, 0, 0, 18, 18);
        SetQueriesDUnitHelper.setResults_noPK(18, 54, 0, 0, 18, 54);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol = " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol = " + 9;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(1, 3, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol = " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol = " + 18;
        SetQueriesDUnitHelper.setResults_withPK(1, 2, 1, 1, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(1, 5, 1, 2, 0, 1);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol = " + 28;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol = " + 28;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(1, 2, 0, 0, 0, 0);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol = " + 38;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol = " + 38;
        SetQueriesDUnitHelper.setResults_withPK(0, 0, 0, 0, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(0, 0, 0, 0, 0, 0);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol = " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol = " + 28;
        SetQueriesDUnitHelper.setResults_withPK(2, 2, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(2, 5, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol = " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol = " + 18;
        SetQueriesDUnitHelper.setResults_withPK(2, 2, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(2, 5, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol = " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol = " + 38;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 1, 1);
        SetQueriesDUnitHelper.setResults_noPK(1, 3, 0, 0, 1, 3);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol = " + 38;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol = " + 25;
        SetQueriesDUnitHelper.setResults_withPK(1, 1, 0, 0, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(1, 2, 0, 0, 0, 0);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol < " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol < " + 18;
        SetQueriesDUnitHelper.setResults_withPK(18, 26, 8, 8, 10, 10);
        SetQueriesDUnitHelper.setResults_noPK(18, 70, 8, 16, 10, 38);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol > " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol > " + 18;
        SetQueriesDUnitHelper.setResults_withPK(11, 12, 1, 1, 0, 0);
        SetQueriesDUnitHelper.setResults_noPK(11, 25, 1, 2, 0, 1);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol < " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol > " + 28;
        SetQueriesDUnitHelper.setResults_withPK(10, 10, 0, 0, 9, 9);
        SetQueriesDUnitHelper.setResults_noPK(10, 29, 0, 0, 9, 27);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol > " + 9;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol < " + 18;
        SetQueriesDUnitHelper.setResults_withPK(10, 18, 8, 8, 2, 2);
        SetQueriesDUnitHelper.setResults_noPK(10, 46, 8, 16, 2, 14);
        assert (++currentCount < 35);
        SetQueriesDUnitHelper.queryStringsLeft[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders1" + " where vol < " + 18;
        SetQueriesDUnitHelper.queryStringsRight[SetQueriesDUnitHelper.currentCount] = "Select * from " + schemaName + ".orders2" + " where vol > " + 38;
        SetQueriesDUnitHelper.setResults_withPK(18, 18, 0, 0, 18, 18);
        SetQueriesDUnitHelper.setResults_noPK(18, 54, 0, 0, 18, 54);
        ++currentCount;
    }

    public class CreateTable_noPK_PR_onRange_ofCol_1
    extends CreateTableDUnitF {
        String mainTableName;

        public CreateTable_noPK_PR_onRange_ofCol_1() {
            this.mainTableName = null;
        }

        @Override
        public void createTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename;
            this.mainTableName = tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            s.execute("create table " + tablename + " (id int not null , cust_name varchar(200), vol int, " + " security_id varchar(10), num int, addr varchar(100))" + " partition by range ( vol ) " + " (VALUES BETWEEN 0 AND 9, VALUES BETWEEN 10 AND 20)  " + " BUCKETS 2 " + " REDUNDANCY " + redundancy);
        }

        @Override
        public void createColocatedTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            throw new SQLException("Colocated tables test has not been added yet");
        }
    }

    public class CreateTable_noPK_PR_onCol_1
    extends CreateTableDUnitF {
        String mainTableName;

        public CreateTable_noPK_PR_onCol_1() {
            this.mainTableName = null;
        }

        @Override
        public void createTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename;
            this.mainTableName = tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            if (redundancy == 0) {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100))" + " partition by column (vol)");
            } else {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100))" + " partition by column (vol)" + " redundancy " + redundancy);
            }
        }

        @Override
        public void createColocatedTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            throw new SQLException("Colocated tables test has not been added yet");
        }
    }

    public class CreateTable_withPK_Replicated_1
    extends CreateTableDUnitF {
        @Override
        public void createTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  replicate");
        }

        @Override
        public void createColocatedTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            throw new SQLException("Colocated tables on replicated table not supported");
        }
    }

    public class CreateTable_withPK_PR_onRange_ofCol_1
    extends CreateTableDUnitF {
        String mainTableName;

        public CreateTable_withPK_PR_onRange_ofCol_1() {
            this.mainTableName = null;
        }

        @Override
        public void createTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename;
            this.mainTableName = tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            s.execute("create table " + tablename + " (id int not null , cust_name varchar(200), vol int, " + " security_id varchar(10), num int, addr varchar(100)" + ", primary key ( id )) " + " partition by range ( vol ) " + " (VALUES BETWEEN 0 AND 9, VALUES BETWEEN 10 AND 20)  " + " BUCKETS 2 " + " REDUNDANCY " + redundancy);
        }

        @Override
        public void createColocatedTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            s.execute("create table " + tablename + " (id int not null , cust_name varchar(200), vol int, " + " security_id varchar(10), num int, addr varchar(100)" + ", primary key ( id )) " + " partition by range ( vol ) " + " (VALUES BETWEEN 0 AND 9, VALUES BETWEEN 10 AND 20)  " + " colocate with (" + this.mainTableName + ")" + " REDUNDANCY " + redundancy);
        }
    }

    public class CreateTable_withPK_PR_onRange_ofPK_1
    extends CreateTableDUnitF {
        String mainTableName;

        public CreateTable_withPK_PR_onRange_ofPK_1() {
            this.mainTableName = null;
        }

        @Override
        public void createTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename;
            this.mainTableName = tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            s.execute("create table " + tablename + " (id int not null , cust_name varchar(200), vol int, " + " security_id varchar(10), num int, addr varchar(100)" + ", primary key ( id )) " + " partition by range ( id ) " + " (VALUES BETWEEN 0 AND 9, VALUES BETWEEN 10 AND 20)  " + "BUCKETS 2 " + " REDUNDANCY " + redundancy);
        }

        @Override
        public void createColocatedTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            s.execute("create table " + tablename + " (id int not null , cust_name varchar(200), vol int, " + " security_id varchar(10), num int, addr varchar(100)" + ", primary key ( id )) " + " partition by range ( id ) " + " (VALUES BETWEEN 0 AND 9, VALUES BETWEEN 10 AND 20)  " + " colocate with (" + this.mainTableName + ")" + " REDUNDANCY " + redundancy);
        }
    }

    public class CreateTable_withPK_PR_onCol_1
    extends CreateTableDUnitF {
        String mainTableName;

        public CreateTable_withPK_PR_onCol_1() {
            this.mainTableName = null;
        }

        @Override
        public void createTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename;
            this.mainTableName = tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            if (redundancy == 0) {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  partition by column (vol)");
            } else {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  partition by column (vol)" + " redundancy " + redundancy);
            }
        }

        @Override
        public void createColocatedTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            if (redundancy == 0) {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  partition by column (vol)" + " colocate with (" + this.mainTableName + ")");
            } else {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  partition by column (vol)" + " colocate with (" + this.mainTableName + ")" + " redundancy " + redundancy);
            }
        }
    }

    public class CreateTable_withPK_PR_onPK_1
    extends CreateTableDUnitF {
        String mainTableName;

        public CreateTable_withPK_PR_onPK_1() {
            this.mainTableName = null;
        }

        @Override
        public void createTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename;
            this.mainTableName = tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            if (redundancy == 0) {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  partition by column (id)");
            } else {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  partition by column (id)" + " redundancy " + redundancy);
            }
        }

        @Override
        public void createColocatedTableFunction(Connection conn, String tabname, int redundancy) throws SQLException {
            String tablename = schemaName + "." + tabname;
            Statement s = conn.createStatement();
            if (redundancy == 0) {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  partition by column (id)" + " colocate with (" + this.mainTableName + ")");
            } else {
                s.execute("create table " + tablename + "(id int not null , cust_name varchar(200), vol int, " + "security_id varchar(10), num int, addr varchar(100)" + ", primary key (id))  partition by column (id)" + " colocate with (" + this.mainTableName + ")" + " redundancy " + redundancy);
            }
        }
    }

    public abstract class CreateTableDUnitF {
        public abstract void createTableFunction(Connection var1, String var2, int var3) throws SQLException;

        public abstract void createColocatedTableFunction(Connection var1, String var2, int var3) throws SQLException;
    }
}

