/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.SetQueriesDUnitHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeMap;

public class SetOperatorExtendedQueriesDUnit
extends DistributedSQLTestBase {
    private static SetQueriesDUnitHelper setQueriesDUnitHelper = new SetQueriesDUnitHelper();
    static boolean[] doRunThisCaseForSetOpDistinct_withPK_withColoc = new boolean[]{true, true, true, true};
    static boolean[] doRunThisCaseForSetOpAll_withPK_withColoc = new boolean[]{true, true, true, true};
    private final SetQueriesDUnitHelper.CreateTableDUnitF[] createTableFunctions_withColoc_withPK;
    private final SetQueriesDUnitHelper.CreateTableDUnitF[] createTableFunctions_noPK;

    public SetOperatorExtendedQueriesDUnit(String name) {
        super(name);
        SetQueriesDUnitHelper.CreateTableDUnitF[] createTableDUnitFArray = new SetQueriesDUnitHelper.CreateTableDUnitF[4];
        createTableDUnitFArray[0] = new SetQueriesDUnitHelper.CreateTable_withPK_PR_onPK_1(setQueriesDUnitHelper);
        createTableDUnitFArray[1] = new SetQueriesDUnitHelper.CreateTable_withPK_PR_onCol_1(setQueriesDUnitHelper);
        createTableDUnitFArray[2] = new SetQueriesDUnitHelper.CreateTable_withPK_PR_onRange_ofPK_1(setQueriesDUnitHelper);
        createTableDUnitFArray[3] = new SetQueriesDUnitHelper.CreateTable_withPK_PR_onRange_ofCol_1(setQueriesDUnitHelper);
        this.createTableFunctions_withColoc_withPK = createTableDUnitFArray;
        SetQueriesDUnitHelper.CreateTableDUnitF[] createTableDUnitFArray2 = new SetQueriesDUnitHelper.CreateTableDUnitF[2];
        createTableDUnitFArray2[0] = new SetQueriesDUnitHelper.CreateTable_noPK_PR_onCol_1(setQueriesDUnitHelper);
        createTableDUnitFArray2[1] = new SetQueriesDUnitHelper.CreateTable_noPK_PR_onRange_ofCol_1(setQueriesDUnitHelper);
        this.createTableFunctions_noPK = createTableDUnitFArray2;
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testSetOperators_withColoc_withPK_noIndex_red0() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 0;
        for (int i = this.createTableFunctions_withColoc_withPK.length - 1; i >= 0; --i) {
            this.caseSetOperators_withColoc_withPK_scenario1(i, false, redundancy);
        }
    }

    public void testSetOperators_withColoc_withPK_noIndex_red1() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 1;
        for (int i = this.createTableFunctions_withColoc_withPK.length - 1; i >= 0; --i) {
            this.caseSetOperators_withColoc_withPK_scenario1(i, false, redundancy);
        }
    }

    public void testSetOperators_withColoc_withPK_noIndex_red2() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 2;
        for (int i = this.createTableFunctions_withColoc_withPK.length - 1; i >= 0; --i) {
            this.caseSetOperators_withColoc_withPK_scenario1(i, false, redundancy);
        }
    }

    public void testSetOperators_withColoc_withPK_withIndex_red0() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 0;
        for (int i = this.createTableFunctions_withColoc_withPK.length - 1; i >= 0; --i) {
            this.caseSetOperators_withColoc_withPK_scenario1(i, true, redundancy);
        }
    }

    public void testSetOperators_withColoc_withPK_withIndex_red1() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 1;
        for (int i = this.createTableFunctions_withColoc_withPK.length - 1; i >= 0; --i) {
            this.caseSetOperators_withColoc_withPK_scenario1(i, true, redundancy);
        }
    }

    public void testSetOperators_withColoc_withPK_withIndex_red2() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 2;
        for (int i = this.createTableFunctions_withColoc_withPK.length - 1; i >= 0; --i) {
            this.caseSetOperators_withColoc_withPK_scenario1(i, true, redundancy);
        }
    }

    public void testSetOperators_noColoc_noPK_noIndex_red0() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 0;
        this.caseSetOperators_noColoc_noPK_scenario1(false, redundancy);
    }

    public void testSetOperators_noColoc_noPK_withIndex_red0() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 0;
        this.caseSetOperators_noColoc_noPK_scenario1(true, redundancy);
    }

    public void testSetOperators_noColoc_noPK_noIndex_red1() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 1;
        this.caseSetOperators_noColoc_noPK_scenario1(false, redundancy);
    }

    public void testSetOperators_noColoc_noPK_withIndex_red1() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 1;
        this.caseSetOperators_noColoc_noPK_scenario1(true, redundancy);
    }

    public void testSetOperators_noColoc_noPK_noIndex_red2() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 2;
        this.caseSetOperators_noColoc_noPK_scenario1(false, redundancy);
    }

    public void testSetOperators_noColoc_noPK_withIndex_red2() throws Exception {
        this.startVMs(1, 3);
        int redundancy = 2;
        this.caseSetOperators_noColoc_noPK_scenario1(true, redundancy);
    }

    public void testSetOperators_specialTest1_SingleNodeCase_1() throws Exception {
        this.startVMs(1, 1);
        int loc1 = 9;
        int loc2 = 28;
        String query1 = "Select * from " + SetQueriesDUnitHelper.schemaName + ".orders1" + " where id = " + loc1;
        String query2 = "Select * from " + SetQueriesDUnitHelper.schemaName + ".orders2" + " where id = " + loc2;
        Connection conn = this.case1SetOperators_PR_PR_SingleNodeScenario1_half1(false);
        this.startVMs(0, 2);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("union", 2, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("union all", 2, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("intersect", 0, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("intersect all", 0, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("except", 1, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("except all", 1, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half3(conn);
    }

    public void testSetOperators_specialTest1_SingleNodeCase_2() throws Exception {
        this.startVMs(1, 1);
        int loc1 = 9;
        int loc2 = 18;
        String query1 = "Select * from " + SetQueriesDUnitHelper.schemaName + ".orders1" + " where id = " + loc1;
        String query2 = "Select * from " + SetQueriesDUnitHelper.schemaName + ".orders2" + " where id = " + loc2;
        Connection conn = this.case1SetOperators_PR_PR_SingleNodeScenario1_half1(false);
        this.startVMs(0, 2);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("union", 2, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("union all", 2, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("intersect", 0, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("intersect all", 0, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("except", 1, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half2("except all", 1, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario1_half3(conn);
    }

    public void testSetOperators_specialTest1_SingleNodeCase_3() throws Exception {
        this.startVMs(1, 1);
        int loc1 = 9;
        int loc2 = 28;
        String query1 = "Select * from " + SetQueriesDUnitHelper.schemaName + ".orders1" + " where id = " + loc1;
        String query2 = "Select * from " + SetQueriesDUnitHelper.schemaName + ".orders2" + " where id = " + loc2;
        Connection conn = this.case1SetOperators_PR_PR_SingleNodeScenario2_half1(false);
        this.startVMs(0, 2);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("union", 2, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("union all", 2, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("intersect", 0, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("intersect all", 0, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("except", 1, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("except all", 1, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half3(conn);
    }

    public void testSetOperators_specialTest1_SingleNodeCase_4() throws Exception {
        this.startVMs(1, 1);
        int loc1 = 9;
        int loc2 = 18;
        String query1 = "Select * from " + SetQueriesDUnitHelper.schemaName + ".orders1" + " where id = " + loc1;
        String query2 = "Select * from " + SetQueriesDUnitHelper.schemaName + ".orders2" + " where id = " + loc2;
        Connection conn = this.case1SetOperators_PR_PR_SingleNodeScenario2_half1(false);
        this.startVMs(0, 2);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("union", 2, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("union all", 2, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("intersect", 0, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("intersect all", 0, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("except", 1, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half2("except all", 1, query1, query2, conn);
        this.case1SetOperators_PR_PR_SingleNodeScenario2_half3(conn);
    }

    private void caseSetOperators_withColoc_withPK_scenario1(int tableIndex, boolean createIndex, int redundancy) throws Exception {
        boolean setOPDistinct = doRunThisCaseForSetOpDistinct_withPK_withColoc[tableIndex];
        boolean setOpAll = doRunThisCaseForSetOpAll_withPK_withColoc[tableIndex];
        if (setOPDistinct || setOpAll) {
            Properties props = new Properties();
            Connection conn = TestUtil.getConnection(props);
            SetQueriesDUnitHelper.createSchema(conn);
            this.getLogWriter().info((Object)("SetOperatorQueriesDUnit.caseSetOperators_withColoc_withPK_scenario1: With Index " + createIndex + " with redundancy " + redundancy));
            this.getLogWriter().info((Object)("Execute create table (main): [" + tableIndex + "] " + this.createTableFunctions_withColoc_withPK[tableIndex].getClass().getName()));
            this.createTableFunctions_withColoc_withPK[tableIndex].createTableFunction(conn, "orders1", redundancy);
            this.getLogWriter().info((Object)("Execute create table (colocated): [" + tableIndex + "] " + this.createTableFunctions_withColoc_withPK[tableIndex].getClass().getName()));
            this.createTableFunctions_withColoc_withPK[tableIndex].createColocatedTableFunction(conn, "orders2", redundancy);
            if (createIndex) {
                SetQueriesDUnitHelper.createLocalIndex(conn, "orders1", "vol");
                SetQueriesDUnitHelper.createLocalIndex(conn, "orders2", "vol");
            }
            SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders1", 0);
            SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders2", 10);
            this.getLogWriter().info((Object)("call execute with: doUnion/Intersect/Except " + setOPDistinct + " doUnion/Intersect/ExceptDistinct " + setOPDistinct + " doUnion/Intersect/ExceptAll " + setOpAll));
            String onFailMessage = "create table: [" + tableIndex + "]" + "[" + tableIndex + "] " + "with index" + "(" + createIndex + ") " + "redundancy" + "(" + redundancy + ") ";
            SetQueriesDUnitHelper.callExecuteSetOp_withPK(this.getLogWriter(), setOPDistinct, setOPDistinct, setOpAll, conn, onFailMessage);
            SetQueriesDUnitHelper.dropTable(conn, "orders2");
            SetQueriesDUnitHelper.dropTable(conn, "orders1");
            SetQueriesDUnitHelper.dropSchema(conn);
        } else {
            this.getLogWriter().info((Object)("SetOperatorQueriesDUnit.caseSetOperators_withColoc_withPK_scenario1: With Index " + createIndex + " with redundancy " + redundancy + "Did not execute for being disabled"));
        }
    }

    private void caseSetOperators_noColoc_noPK_scenario1(boolean createIndex, int redundancy) throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        SetQueriesDUnitHelper.createSchema(conn);
        this.getLogWriter().info((Object)("SetOperatorQueriesDUnit.caseSetOperators_noColoc_withPK_scenario1: With Index " + createIndex + " with redundancy " + redundancy));
        this.getLogWriter().info((Object)("Execute left create table: " + this.createTableFunctions_noPK[0].getClass().getName()));
        this.createTableFunctions_noPK[0].createTableFunction(conn, "orders1", redundancy);
        this.getLogWriter().info((Object)("Execute right create table: " + this.createTableFunctions_noPK[1].getClass().getName()));
        this.createTableFunctions_noPK[1].createTableFunction(conn, "orders2", redundancy);
        if (createIndex) {
            this.getLogWriter().info((Object)"Execute create index on left table: ");
            SetQueriesDUnitHelper.createLocalIndex(conn, "orders1", "vol");
            this.getLogWriter().info((Object)"Execute create index on right table: ");
            SetQueriesDUnitHelper.createLocalIndex(conn, "orders2", "vol");
        }
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders1", 0);
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders1", 0);
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders1", 0);
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders2", 10);
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders2", 10);
        this.getLogWriter().info((Object)"call execute with: doUnion/Intersect/Except true doUnion/Intersect/ExceptDistinct true doUnion/Intersect/ExceptAll true");
        String onFailMessage = "create table-noPK: with index(" + createIndex + ") " + "redundancy" + "(" + redundancy + ") ";
        SetQueriesDUnitHelper.callExecuteSetOp_noPK(this.getLogWriter(), true, true, true, conn, onFailMessage);
        SetQueriesDUnitHelper.dropTable(conn, "orders2");
        SetQueriesDUnitHelper.dropTable(conn, "orders1");
        SetQueriesDUnitHelper.dropSchema(conn);
    }

    private Connection case1SetOperators_PR_PR_SingleNodeScenario1_half1(boolean createIndex) throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        SetQueriesDUnitHelper.createSchema(conn);
        new SetQueriesDUnitHelper.CreateTable_withPK_PR_onRange_ofCol_1(setQueriesDUnitHelper).createTableFunction(conn, "orders1", 1);
        new SetQueriesDUnitHelper.CreateTable_withPK_PR_onPK_1(setQueriesDUnitHelper).createTableFunction(conn, "orders2", 1);
        if (createIndex) {
            SetQueriesDUnitHelper.createLocalIndex(conn, "orders1", "vol");
            SetQueriesDUnitHelper.createLocalIndex(conn, "orders2", "vol");
        }
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders1", 0);
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders2", 10);
        return conn;
    }

    private void case1SetOperators_PR_PR_SingleNodeScenario1_half2(String queryType, int expectedRows, String query1, String query2, Connection conn) throws Exception {
        String execQuery = query1 + " " + queryType + " " + query2;
        this.getLogWriter().info((Object)("Execute Query: " + execQuery));
        ResultSet rs = conn.createStatement().executeQuery(execQuery);
        int rowCount = 0;
        TreeMap<Integer, Integer> resultMap = new TreeMap<Integer, Integer>();
        while (rs.next()) {
            ++rowCount;
            resultMap.put(rs.getInt(1), resultMap.get(rs.getInt(1)) == null ? 1 : (Integer)resultMap.get(rs.getInt(1)) + 1);
        }
        rs.close();
        this.getLogWriter().info((Object)("expectedRows : " + expectedRows + " Got : " + rowCount));
        this.getLogWriter().info((Object)((Object)resultMap).toString());
        SetOperatorExtendedQueriesDUnit.assertEquals((int)expectedRows, (int)rowCount);
    }

    private void case1SetOperators_PR_PR_SingleNodeScenario1_half3(Connection conn) throws Exception {
        SetQueriesDUnitHelper.dropTable(conn, "orders2");
        SetQueriesDUnitHelper.dropTable(conn, "orders1");
        SetQueriesDUnitHelper.dropSchema(conn);
    }

    private Connection case1SetOperators_PR_PR_SingleNodeScenario2_half1(boolean createIndex) throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        SetQueriesDUnitHelper.createSchema(conn);
        new SetQueriesDUnitHelper.CreateTable_withPK_PR_onCol_1(setQueriesDUnitHelper).createTableFunction(conn, "orders1", 1);
        new SetQueriesDUnitHelper.CreateTable_withPK_PR_onRange_ofPK_1(setQueriesDUnitHelper).createTableFunction(conn, "orders2", 1);
        if (createIndex) {
            SetQueriesDUnitHelper.createLocalIndex(conn, "orders1", "vol");
            SetQueriesDUnitHelper.createLocalIndex(conn, "orders2", "vol");
        }
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders1", 0);
        SetQueriesDUnitHelper.loadSampleData(this.getLogWriter(), conn, 20, "orders2", 10);
        return conn;
    }

    private void case1SetOperators_PR_PR_SingleNodeScenario2_half2(String queryType, int expectedRows, String query1, String query2, Connection conn) throws Exception {
        String execQuery = query1 + " " + queryType + " " + query2;
        this.getLogWriter().info((Object)("Execute Query: " + execQuery));
        ResultSet rs = conn.createStatement().executeQuery(execQuery);
        int rowCount = 0;
        TreeMap<Integer, Integer> resultMap = new TreeMap<Integer, Integer>();
        while (rs.next()) {
            ++rowCount;
            resultMap.put(rs.getInt(1), resultMap.get(rs.getInt(1)) == null ? 1 : (Integer)resultMap.get(rs.getInt(1)) + 1);
        }
        rs.close();
        this.getLogWriter().info((Object)("expectedRows : " + expectedRows + " Got : " + rowCount));
        this.getLogWriter().info((Object)((Object)resultMap).toString());
        SetOperatorExtendedQueriesDUnit.assertEquals((int)expectedRows, (int)rowCount);
    }

    private void case1SetOperators_PR_PR_SingleNodeScenario2_half3(Connection conn) throws Exception {
        SetQueriesDUnitHelper.dropTable(conn, "orders2");
        SetQueriesDUnitHelper.dropTable(conn, "orders1");
        SetQueriesDUnitHelper.dropSchema(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42918() throws Exception {
        try {
            String query = "SELECT COUNT(ID1) FROM TESTTABLE1 UNION SELECT ID1 FROM TESTTABLE1 where ID1 = 0";
            this.startVMs(1, 3);
            String table1 = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ";
            this.clientSQLExecute(1, table1 + "  partition by column(ID1)");
            for (int i = 1; i < 4; ++i) {
                String insert = "Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "','add1_" + i + "')";
                this.clientSQLExecute(1, insert);
            }
            try {
                TestUtil.getConnection().createStatement().executeQuery(query);
                SetOperatorExtendedQueriesDUnit.fail((String)"Test should fail with feature not supported exception");
            }
            catch (SQLException sqle) {
                SetOperatorExtendedQueriesDUnit.assertEquals((String)"0A000", (String)sqle.getSQLState());
            }
        }
        finally {
            this.clientSQLExecute(1, "drop table TESTTABLE1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46711() throws Exception {
        try {
            String query1 = "select id, name from trade.t1 where type =21 and name like 'a%' union select id, name from trade.t1 where type =22 and name like 'a%'";
            String query2 = "select id, name from trade.t1 where type =21 and name = 'aa' union select id, name from trade.t1 where type =22 and name = 'ab'";
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table trade.t1 ( id int primary key, name varchar(10), type int) partition by primary key");
            this.clientSQLExecute(1, "Insert into  trade.t1 values(1,'aa',21)");
            this.clientSQLExecute(1, "Insert into  trade.t1 values(2,'ab',22)");
            this.clientSQLExecute(1, "Insert into  trade.t1 values(3,'ac',23)");
            this.clientSQLExecute(1, "Insert into  trade.t1 values(4,'ad',24)");
            this.clientSQLExecute(1, "Insert into  trade.t1 values(5,'ae',25)");
            ResultSet rs46711 = TestUtil.getConnection().createStatement().executeQuery(query1);
            int count = 1;
            while (rs46711.next()) {
                SetOperatorExtendedQueriesDUnit.assertEquals((int)count, (int)rs46711.getInt(1));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)3, (int)count);
            rs46711 = TestUtil.getConnection().createStatement().executeQuery(query2);
            count = 1;
            while (rs46711.next()) {
                SetOperatorExtendedQueriesDUnit.assertEquals((int)count, (int)rs46711.getInt(1));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)3, (int)count);
        }
        finally {
            this.clientSQLExecute(1, "drop table trade.t1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46899_replicated() throws Exception {
        try {
            String query1 = "select count(symbol) as symbolcount, exchange from t1 where tid = 1 and symbol like '%b%' group by exchange union all select count(symbol) as symbolcount, exchange from t2 where tid = 11 group by exchange";
            String query2 = "select count(symbol) as symbolcount, exchange from t1 where tid = 1 and symbol like '%b%' group by exchange union all select count(symbol) as symbolcount, exchange from t2 where tid = 11 group by exchange order by symbolcount";
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table t1 (tid int, sid int, exchange int, symbol varchar(10)) replicate");
            this.clientSQLExecute(1, "create table t2 (tid int, sid int, exchange int, symbol varchar(10)) replicate");
            this.clientSQLExecute(1, "insert into t1 values (1,1,1,'abc')");
            this.clientSQLExecute(1, "insert into t1 values (1,1,1,'abcd')");
            this.clientSQLExecute(1, "insert into t2 values (11,11,11,'c')");
            this.clientSQLExecute(1, "insert into t2 values (11,11,11,'cd')");
            ResultSet rs46899 = TestUtil.getConnection().createStatement().executeQuery(query1);
            int count = 0;
            while (rs46899.next()) {
                SetOperatorExtendedQueriesDUnit.assertEquals((int)2, (int)rs46899.getInt(1));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)2, (int)count);
            rs46899 = TestUtil.getConnection().createStatement().executeQuery(query2);
            count = 0;
            while (rs46899.next()) {
                SetOperatorExtendedQueriesDUnit.assertEquals((int)2, (int)rs46899.getInt(1));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)2, (int)count);
        }
        finally {
            this.clientSQLExecute(1, "drop table t2");
            this.clientSQLExecute(1, "drop table t1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46899_partitioned() throws Exception {
        try {
            String query1 = "select count(symbol) as symbolcount, exchange from t1 where tid = 1 and symbol like '%b%' group by exchange union all select count(symbol) as symbolcount, exchange from t2 where tid = 11 group by exchange";
            String query2 = "select count(symbol) as symbolcount, exchange from t1 where tid = 1 and symbol like '%b%' group by exchange union all select count(symbol) as symbolcount, exchange from t2 where tid = 11 group by exchange order by symbolcount";
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table t1 (tid int, sid int, exchange int, symbol varchar(10)) partition by column(tid)");
            this.clientSQLExecute(1, "create table t2 (tid int, sid int, exchange int, symbol varchar(10)) partition by column(tid)");
            this.clientSQLExecute(1, "insert into t1 values (1,1,1,'abc')");
            this.clientSQLExecute(1, "insert into t1 values (1,1,1,'abcd')");
            this.clientSQLExecute(1, "insert into t2 values (11,11,11,'c')");
            this.clientSQLExecute(1, "insert into t2 values (11,11,11,'cd')");
            try {
                TestUtil.getConnection().createStatement().executeQuery(query1);
                SetOperatorExtendedQueriesDUnit.fail((String)"Test should fail with feature not supported exception");
            }
            catch (SQLException sqle) {
                SetOperatorExtendedQueriesDUnit.assertEquals((String)"0A000", (String)sqle.getSQLState());
            }
            try {
                TestUtil.getConnection().createStatement().executeQuery(query2);
                SetOperatorExtendedQueriesDUnit.fail((String)"Test should fail with feature not supported exception");
            }
            catch (SQLException sqle) {
                SetOperatorExtendedQueriesDUnit.assertEquals((String)"0A000", (String)sqle.getSQLState());
            }
        }
        finally {
            this.clientSQLExecute(1, "drop table t2");
            this.clientSQLExecute(1, "drop table t1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46805_replicated() throws Exception {
        try {
            String query1 = "select * from t3";
            String query2 = "select * from t4";
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table t1 (c1 int, c2 int) replicate");
            this.clientSQLExecute(1, "create table t2 (c1 int, c2 int) replicate");
            this.clientSQLExecute(1, "create table t3 (c1 int, c2 int) replicate");
            this.clientSQLExecute(1, "create table t4 (c1 int, c2 int) replicate");
            this.clientSQLExecute(1, "insert into t1 values (1,1)");
            this.clientSQLExecute(1, "insert into t1 values (2,2)");
            this.clientSQLExecute(1, "insert into t2 values (3,3)");
            this.clientSQLExecute(1, "insert into t2 values (4,4)");
            this.clientSQLExecute(1, "insert into t3 select * from t1 union select * from t2");
            this.clientSQLExecute(1, "insert into t4 select * from t1 union all select * from t2");
            HashSet<Integer> expected = new HashSet<Integer>();
            for (int i = 0; i < 4; ++i) {
                expected.add(i + 1);
            }
            ResultSet rs46805 = TestUtil.getConnection().createStatement().executeQuery(query1);
            int count = 0;
            while (rs46805.next()) {
                SetOperatorExtendedQueriesDUnit.assertTrue((boolean)expected.remove(rs46805.getInt(1)));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)4, (int)count);
            expected = new HashSet();
            for (int i = 0; i < 4; ++i) {
                expected.add(i + 1);
            }
            rs46805 = TestUtil.getConnection().createStatement().executeQuery(query2);
            count = 0;
            while (rs46805.next()) {
                SetOperatorExtendedQueriesDUnit.assertTrue((boolean)expected.remove(rs46805.getInt(1)));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)4, (int)count);
        }
        finally {
            this.clientSQLExecute(1, "drop table t2");
            this.clientSQLExecute(1, "drop table t1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46805_partitioned() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table t1 (c1 int, c2 int) partition by column(c1)");
            this.clientSQLExecute(1, "create table t2 (c1 int, c2 int) partition by column(c1)");
            this.clientSQLExecute(1, "create table t3 (c1 int, c2 int) partition by column(c1)");
            this.clientSQLExecute(1, "create table t4 (c1 int, c2 int) partition by column(c1)");
            this.clientSQLExecute(1, "insert into t1 values (1,1)");
            this.clientSQLExecute(1, "insert into t1 values (2,2)");
            this.clientSQLExecute(1, "insert into t2 values (3,3)");
            this.clientSQLExecute(1, "insert into t2 values (4,4)");
            this.clientSQLExecute(1, "insert into t4 select * from t1 union all select * from t2");
            String query = "select * from t4";
            HashSet<Integer> expected = new HashSet<Integer>();
            for (int i = 0; i < 4; ++i) {
                expected.add(i + 1);
            }
            ResultSet rs46805 = TestUtil.getConnection().createStatement().executeQuery("select * from t4");
            int count = 0;
            while (rs46805.next()) {
                SetOperatorExtendedQueriesDUnit.assertTrue((boolean)expected.remove(rs46805.getInt(1)));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)4, (int)count);
            try {
                this.clientSQLExecute(1, "insert into t4 select * from t1 union select * from t2");
                SetOperatorExtendedQueriesDUnit.fail((String)"Test should fail with feature not supported exception");
            }
            catch (SQLException sqle) {
                SetOperatorExtendedQueriesDUnit.assertEquals((String)"0A000", (String)sqle.getSQLState());
            }
        }
        finally {
            this.clientSQLExecute(1, "drop table t2");
            this.clientSQLExecute(1, "drop table t1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test45342() throws Exception {
        String qryLine;
        BufferedReader scriptReader = new BufferedReader(new FileReader(TestUtil.getResourcesDir() + "/lib/GemFireXD_EF_IntegrationQuery.sql"));
        StringBuilder qry = new StringBuilder();
        while ((qryLine = scriptReader.readLine()) != null) {
            qry.append(qryLine).append('\n');
        }
        this.startVMs(1, 3);
        try {
            this.clientSQLExecute(1, "create schema TESTAPP");
            this.clientSQLExecute(1, "CREATE TABLE TESTAPP.TESTTABLE(ID INT, NAME VARCHAR(50))");
            this.clientSQLExecute(1, "create schema TEMP");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMATABLES(TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50), TABLE_TYPE VARCHAR(50)) replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMACOLUMNS (TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50), COLUMN_NAME VARCHAR(50), ORDINAL_POSITION INTEGER, COLUMN_DEFAULT VARCHAR(50), IS_NULLABLE VARCHAR(50), DATA_TYPE INTEGER, TYPE_NAME VARCHAR(50), CHARACTER_OCTET_LENGTH INTEGER, COLUMN_SIZE INTEGER, SCALE INTEGER, PRECISION_RADIX INTEGER, IS_AUTOINCREMENT VARCHAR(50), PRIMARY_KEY VARCHAR(50), EDM_TYPE VARCHAR(50))  replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMAVIEWS (TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50)) replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMAINDEXES (TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50), INDEX_NAME VARCHAR(50), INDEX_QUALIFIER VARCHAR(50), INDEX_TYPE VARCHAR(50), COLUMN_NAME VARCHAR(50), SUNIQUE SMALLINT, SORT_TYPE VARCHAR(50), FILTER_CONDITION VARCHAR(50), PRIMARY_KEY VARCHAR(50)) replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMAINDEXCOLUMNS (TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50), INDEX_NAME VARCHAR(50), INDEX_QUALIFIER VARCHAR(50), INDEX_TYPE VARCHAR(50), COLUMN_NAME VARCHAR(50), ORDINAL_POSITION SMALLINT, IS_NOT_UNIQUE SMALLINT, SORT_TYPE VARCHAR(50), FILTER_CONDITION VARCHAR(50)) replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMAFOREIGNKEYS (TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50), CONSTRAINT_NAME VARCHAR(50), PRIMARYKEY_TABLE_CATALOG VARCHAR(50), PRIMARYKEY_TABLE_SCHEMA VARCHAR(50), PRIMARYKEY_TABLE_NAME VARCHAR(50), PRIMARYKEY_NAME VARCHAR(50), PRIMARYKEY_COLUMN_NAME VARCHAR(50), COLUMN_NAME VARCHAR(50), DEFERRABILITY VARCHAR(50)) replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMAFOREIGNKEYCOLUMNS (TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50), CONSTRAINT_NAME VARCHAR(50), PRIMARYKEY_TABLE_CATALOG VARCHAR(50), PRIMARYKEY_TABLE_SCHEMA VARCHAR(50), PRIMARYKEY_TABLE_NAME VARCHAR(50), PRIMARYKEY_NAME VARCHAR(50), PRIMARYKEY_COLUMN_NAME VARCHAR(50), COLUMN_NAME VARCHAR(50), ORDINAL_POSITION SMALLINT, DEFERRABILITY VARCHAR(50)) replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMAPRIMARYKEYCOLUMNS (TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50), PRIMARYKEY_NAME VARCHAR(50), COLUMN_NAME VARCHAR(50), ORDINAL_POSITION SMALLINT) replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMACONSTRAINTCOLUMNS (TABLE_CATALOG VARCHAR(50), TABLE_SCHEMA VARCHAR(50), TABLE_NAME VARCHAR(50), CONSTRAINT_NAME VARCHAR(50), PRIMARYKEY_TABLE_CATALOG VARCHAR(50), PRIMARYKEY_TABLE_SCHEMA VARCHAR(50), PRIMARYKEY_TABLE_NAME VARCHAR(50), PRIMARYKEY_NAME VARCHAR(50), PRIMARYKEY_COLUMN_NAME VARCHAR(50), COLUMN_NAME VARCHAR(50), ORDINAL_POSITION SMALLINT, DEFERRABILITY VARCHAR(50)) replicate");
            this.clientSQLExecute(1, "CREATE TABLE TEMP.SCHEMASCHEMAS (SCHEMA_CATALOG VARCHAR(50), SCHEMA_NAME VARCHAR(50)) replicate");
            for (int i = 1; i < 4; ++i) {
                String insert = "Insert into TESTAPP.TESTTABLE values(" + i + ",'desc1_" + i + "')";
                this.clientSQLExecute(1, insert);
            }
            ResultSet rs45342 = TestUtil.getConnection().createStatement().executeQuery(qry.toString());
            SetOperatorExtendedQueriesDUnit.assertFalse((boolean)rs45342.next());
        }
        finally {
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMASCHEMAS");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMACONSTRAINTCOLUMNS");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMAPRIMARYKEYCOLUMNS");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMAFOREIGNKEYCOLUMNS");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMAFOREIGNKEYS");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMAINDEXCOLUMNS");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMAINDEXES");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMAVIEWS");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMACOLUMNS");
            this.clientSQLExecute(1, "drop table if exists TEMP.SCHEMATABLES");
            this.clientSQLExecute(1, "drop schema TEMP RESTRICT");
            this.clientSQLExecute(1, "drop table if exists TESTAPP.TESTTABLE");
            this.clientSQLExecute(1, "drop schema TESTAPP RESTRICT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug45876_replicated() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table t1 (c1 int, c2 int) replicate");
            this.clientSQLExecute(1, "create table t2 (c1 int, c2 int) replicate");
            this.clientSQLExecute(1, "insert into t1 values (1,1)");
            this.clientSQLExecute(1, "insert into t1 values (2,2)");
            this.clientSQLExecute(1, "insert into t2 values (3,3)");
            this.clientSQLExecute(1, "insert into t2 values (2,3)");
            this.clientSQLExecute(1, "insert into t2 values (4,4)");
            this.clientSQLExecute(1, "insert into t2 values (3,4)");
            HashSet<Integer> expected = new HashSet<Integer>();
            expected.add(0);
            for (int i = 3; i < 5; ++i) {
                expected.add(i);
            }
            ResultSet rs = TestUtil.getConnection().createStatement().executeQuery("SELECT 0, 2 from T1 UNION SELECT MAX(C1), C2 FROM T2 GROUP BY C2");
            int count = 0;
            while (rs.next()) {
                SetOperatorExtendedQueriesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)3, (int)count);
            expected = new HashSet();
            for (int i = 1; i < 5; ++i) {
                expected.add(i);
            }
            rs = TestUtil.getConnection().createStatement().executeQuery("SELECT c1, c1 from T1 UNION SELECT MAX(C1), C1 FROM T2 GROUP BY C1");
            count = 0;
            while (rs.next()) {
                SetOperatorExtendedQueriesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
                ++count;
            }
            SetOperatorExtendedQueriesDUnit.assertEquals((int)4, (int)count);
        }
        finally {
            this.clientSQLExecute(1, "drop table t2");
            this.clientSQLExecute(1, "drop table t1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug45876_partitioned() throws Exception {
        try {
            int count;
            HashSet<Integer> expected;
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table t1 (c1 int, c2 int) partition by column(c1)");
            this.clientSQLExecute(1, "create table t2 (c1 int, c2 int) partition by column(c1)");
            this.clientSQLExecute(1, "insert into t1 values (1,1)");
            this.clientSQLExecute(1, "insert into t1 values (2,2)");
            this.clientSQLExecute(1, "insert into t2 values (3,3)");
            this.clientSQLExecute(1, "insert into t2 values (2,3)");
            this.clientSQLExecute(1, "insert into t2 values (4,4)");
            this.clientSQLExecute(1, "insert into t2 values (3,4)");
            try {
                expected = new HashSet<Integer>();
                expected.add(0);
                for (int i = 3; i < 5; ++i) {
                    expected.add(i);
                }
                ResultSet rs = TestUtil.getConnection().createStatement().executeQuery("SELECT 0, 2 from T1 UNION SELECT MAX(C1), C2 FROM T2 GROUP BY C2");
                count = 0;
                while (rs.next()) {
                    SetOperatorExtendedQueriesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
                    ++count;
                }
                SetOperatorExtendedQueriesDUnit.assertEquals((int)3, (int)count);
                SetOperatorExtendedQueriesDUnit.fail((String)"Test should fail with feature not supported exception");
            }
            catch (SQLException sqle) {
                SetOperatorExtendedQueriesDUnit.assertEquals((String)"0A000", (String)sqle.getSQLState());
            }
            try {
                expected = new HashSet();
                for (int i = 1; i < 5; ++i) {
                    expected.add(i);
                }
                ResultSet rs = TestUtil.getConnection().createStatement().executeQuery("SELECT c1, c1 from T1 UNION SELECT MAX(C1), C1 FROM T2 GROUP BY C1");
                count = 0;
                while (rs.next()) {
                    SetOperatorExtendedQueriesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
                    ++count;
                }
                SetOperatorExtendedQueriesDUnit.assertEquals((int)4, (int)count);
                SetOperatorExtendedQueriesDUnit.fail((String)"Test should fail with feature not supported exception");
            }
            catch (SQLException sqle) {
                SetOperatorExtendedQueriesDUnit.assertEquals((String)"0A000", (String)sqle.getSQLState());
            }
        }
        finally {
            this.clientSQLExecute(1, "drop table t2");
            this.clientSQLExecute(1, "drop table t1");
        }
    }
}

