/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

public class ScrollableResultSetDUnit
extends DistributedSQLTestBase {
    private static final long serialVersionUID = 1L;

    public ScrollableResultSetDUnit(String name) {
        super(name);
    }

    public void testScrolling_embedClient() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        this.runTest(conn);
    }

    public void testScrolling_thinClient() throws Exception {
        this.startVMs(0, 2);
        int netPort = this.startNetworkServer(1, null, null);
        TestUtil.loadNetDriver();
        InetAddress localHost = SocketCreator.getLocalHost();
        Connection conn = DriverManager.getConnection(TestUtil.getNetProtocol(localHost.getHostName(), netPort));
        this.runTest(conn);
    }

    public void runTest(Connection conn) throws Exception {
        Statement s = conn.createStatement();
        String ddl = "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by column (sec_id, price)  REDUNDANCY 2";
        s.execute(ddl);
        ddl = "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 10000)  REDUNDANCY 2";
        s.execute(ddl);
        s.execute("insert into trade.securities values (1204, 'lo', 33.9, 'hkse', 53), (1205, 'do', 34.9, 'fse', 54), (1206, 'jo', 35.9, 'tse', 55)");
        s.execute("insert into trade.portfolio values (508, 1204, 1080, 1080, 36612.00000000000000000000, 100)");
        Statement scrStmnt = conn.createStatement(1004, 1007);
        ResultSet rs = scrStmnt.executeQuery("SELECT sec_id, symbol FROM trade.securities");
        rs.last();
        rs.next();
        ScrollableResultSetDUnit.assertFalse((boolean)rs.next());
        ScrollableResultSetDUnit.assertTrue((boolean)rs.first());
        int cnt = 1;
        while (rs.next()) {
            ++cnt;
        }
        ScrollableResultSetDUnit.assertEquals((int)3, (int)cnt);
        scrStmnt.close();
        s.execute("drop table trade.securities");
        s.execute("drop table trade.portfolio");
        ddl = "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate";
        s.execute(ddl);
        ddl = "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty)) replicate";
        s.execute(ddl);
        s.execute("insert into trade.securities values (1204, 'lo', 33.9, 'hkse', 53), (1205, 'do', 34.9, 'fse', 54), (1206, 'jo', 35.9, 'tse', 55)");
        s.execute("insert into trade.portfolio values (508, 1204, 1080, 1080, 36612.00000000000000000000, 100), (508, 1205, 1080, 1080, 36612.00000000000000000000, 100), (508, 1206, 1080, 1080, 36612.00000000000000000000, 100)");
        scrStmnt = conn.createStatement(1004, 1007);
        rs = scrStmnt.executeQuery("SELECT sec_id, symbol FROM trade.securities");
        rs.last();
        rs.next();
        ScrollableResultSetDUnit.assertFalse((boolean)rs.next());
        ScrollableResultSetDUnit.assertTrue((boolean)rs.first());
        cnt = 1;
        while (rs.next()) {
            ++cnt;
        }
        ScrollableResultSetDUnit.assertEquals((int)3, (int)cnt);
        rs = scrStmnt.executeQuery("SELECT sec_id, symbol, sid FROM trade.securities, trade.portfolio where sec_id = sid");
        rs.last();
        rs.next();
        ScrollableResultSetDUnit.assertFalse((boolean)rs.next());
        ScrollableResultSetDUnit.assertTrue((boolean)rs.first());
        cnt = 1;
        while (rs.next()) {
            ++cnt;
        }
        ScrollableResultSetDUnit.assertEquals((int)3, (int)cnt);
        rs = scrStmnt.executeQuery("SELECT * FROM trade.securities, trade.portfolio");
        rs.last();
        rs.next();
        ScrollableResultSetDUnit.assertFalse((boolean)rs.next());
        ScrollableResultSetDUnit.assertTrue((boolean)rs.first());
        cnt = 1;
        while (rs.next()) {
            ++cnt;
        }
        ScrollableResultSetDUnit.assertEquals((int)9, (int)cnt);
        rs = scrStmnt.executeQuery("SELECT * FROM trade.portfolio where cid = 508 and sid = 1204");
        rs.last();
        rs.next();
        ScrollableResultSetDUnit.assertFalse((boolean)rs.next());
        ScrollableResultSetDUnit.assertTrue((boolean)rs.first());
        cnt = 1;
        while (rs.next()) {
            ++cnt;
        }
        ScrollableResultSetDUnit.assertEquals((int)1, (int)cnt);
    }
}

